/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestSubscribeCOV extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.SUBSCRIBE_COV;
  }

  // Properties.
  protected final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
  protected final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
  protected final BACnetContextTagBoolean issueConfirmed;
  protected final BACnetContextTagUnsignedInteger lifetimeInSeconds;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestSubscribeCOV(
      BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
      BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
      BACnetContextTagBoolean issueConfirmed,
      BACnetContextTagUnsignedInteger lifetimeInSeconds,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.subscriberProcessIdentifier = subscriberProcessIdentifier;
    this.monitoredObjectIdentifier = monitoredObjectIdentifier;
    this.issueConfirmed = issueConfirmed;
    this.lifetimeInSeconds = lifetimeInSeconds;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetContextTagUnsignedInteger getSubscriberProcessIdentifier() {
    return subscriberProcessIdentifier;
  }

  public BACnetContextTagObjectIdentifier getMonitoredObjectIdentifier() {
    return monitoredObjectIdentifier;
  }

  public BACnetContextTagBoolean getIssueConfirmed() {
    return issueConfirmed;
  }

  public BACnetContextTagUnsignedInteger getLifetimeInSeconds() {
    return lifetimeInSeconds;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestSubscribeCOV");

    // Simple Field (subscriberProcessIdentifier)
    writeSimpleField(
        "subscriberProcessIdentifier",
        subscriberProcessIdentifier,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (monitoredObjectIdentifier)
    writeSimpleField(
        "monitoredObjectIdentifier",
        monitoredObjectIdentifier,
        new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (issueConfirmed) (Can be skipped, if the value is null)
    writeOptionalField(
        "issueConfirmed", issueConfirmed, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (lifetimeInSeconds) (Can be skipped, if the value is null)
    writeOptionalField(
        "lifetimeInSeconds", lifetimeInSeconds, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestSubscribeCOV");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestSubscribeCOV _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subscriberProcessIdentifier)
    lengthInBits += subscriberProcessIdentifier.getLengthInBits();

    // Simple field (monitoredObjectIdentifier)
    lengthInBits += monitoredObjectIdentifier.getLengthInBits();

    // Optional Field (issueConfirmed)
    if (issueConfirmed != null) {
      lengthInBits += issueConfirmed.getLengthInBits();
    }

    // Optional Field (lifetimeInSeconds)
    if (lifetimeInSeconds != null) {
      lengthInBits += lifetimeInSeconds.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestSubscribeCOV");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger subscriberProcessIdentifier =
        readSimpleField(
            "subscriberProcessIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagObjectIdentifier monitoredObjectIdentifier =
        readSimpleField(
            "monitoredObjectIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetContextTagBoolean issueConfirmed =
        readOptionalField(
            "issueConfirmed",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (2), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger lifetimeInSeconds =
        readOptionalField(
            "lifetimeInSeconds",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestSubscribeCOV");
    // Create the instance
    return new BACnetConfirmedServiceRequestSubscribeCOVBuilderImpl(
        subscriberProcessIdentifier,
        monitoredObjectIdentifier,
        issueConfirmed,
        lifetimeInSeconds,
        serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestSubscribeCOVBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
    private final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
    private final BACnetContextTagBoolean issueConfirmed;
    private final BACnetContextTagUnsignedInteger lifetimeInSeconds;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestSubscribeCOVBuilderImpl(
        BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
        BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
        BACnetContextTagBoolean issueConfirmed,
        BACnetContextTagUnsignedInteger lifetimeInSeconds,
        Long serviceRequestLength) {
      this.subscriberProcessIdentifier = subscriberProcessIdentifier;
      this.monitoredObjectIdentifier = monitoredObjectIdentifier;
      this.issueConfirmed = issueConfirmed;
      this.lifetimeInSeconds = lifetimeInSeconds;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestSubscribeCOV build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestSubscribeCOV bACnetConfirmedServiceRequestSubscribeCOV =
          new BACnetConfirmedServiceRequestSubscribeCOV(
              subscriberProcessIdentifier,
              monitoredObjectIdentifier,
              issueConfirmed,
              lifetimeInSeconds,
              serviceRequestLength);
      return bACnetConfirmedServiceRequestSubscribeCOV;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestSubscribeCOV)) {
      return false;
    }
    BACnetConfirmedServiceRequestSubscribeCOV that = (BACnetConfirmedServiceRequestSubscribeCOV) o;
    return (getSubscriberProcessIdentifier() == that.getSubscriberProcessIdentifier())
        && (getMonitoredObjectIdentifier() == that.getMonitoredObjectIdentifier())
        && (getIssueConfirmed() == that.getIssueConfirmed())
        && (getLifetimeInSeconds() == that.getLifetimeInSeconds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSubscriberProcessIdentifier(),
        getMonitoredObjectIdentifier(),
        getIssueConfirmed(),
        getLifetimeInSeconds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
