/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetAuthenticationFactor implements Message {

  // Properties.
  protected final BACnetAuthenticationFactorTypeTagged formatType;
  protected final BACnetContextTagUnsignedInteger formatClass;
  protected final BACnetContextTagOctetString value;

  public BACnetAuthenticationFactor(
      BACnetAuthenticationFactorTypeTagged formatType,
      BACnetContextTagUnsignedInteger formatClass,
      BACnetContextTagOctetString value) {
    super();
    this.formatType = formatType;
    this.formatClass = formatClass;
    this.value = value;
  }

  public BACnetAuthenticationFactorTypeTagged getFormatType() {
    return formatType;
  }

  public BACnetContextTagUnsignedInteger getFormatClass() {
    return formatClass;
  }

  public BACnetContextTagOctetString getValue() {
    return value;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetAuthenticationFactor");

    // Simple Field (formatType)
    writeSimpleField("formatType", formatType, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (formatClass)
    writeSimpleField("formatClass", formatClass, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (value)
    writeSimpleField("value", value, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetAuthenticationFactor");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetAuthenticationFactor _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (formatType)
    lengthInBits += formatType.getLengthInBits();

    // Simple field (formatClass)
    lengthInBits += formatClass.getLengthInBits();

    // Simple field (value)
    lengthInBits += value.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetAuthenticationFactor staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetAuthenticationFactor staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetAuthenticationFactor");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetAuthenticationFactorTypeTagged formatType =
        readSimpleField(
            "formatType",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetAuthenticationFactorTypeTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagUnsignedInteger formatClass =
        readSimpleField(
            "formatClass",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagOctetString value =
        readSimpleField(
            "value",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagOctetString)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.OCTET_STRING)),
                readBuffer));

    readBuffer.closeContext("BACnetAuthenticationFactor");
    // Create the instance
    BACnetAuthenticationFactor _bACnetAuthenticationFactor;
    _bACnetAuthenticationFactor = new BACnetAuthenticationFactor(formatType, formatClass, value);
    return _bACnetAuthenticationFactor;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetAuthenticationFactor)) {
      return false;
    }
    BACnetAuthenticationFactor that = (BACnetAuthenticationFactor) o;
    return (getFormatType() == that.getFormatType())
        && (getFormatClass() == that.getFormatClass())
        && (getValue() == that.getValue())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFormatType(), getFormatClass(), getValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
