/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsTableSizes implements Message {

  // Properties.
  protected final long symbolCount;
  protected final long symbolLength;
  protected final long dataTypeCount;
  protected final long dataTypeLength;
  protected final long extraCount;
  protected final long extraLength;

  public AdsTableSizes(
      long symbolCount,
      long symbolLength,
      long dataTypeCount,
      long dataTypeLength,
      long extraCount,
      long extraLength) {
    super();
    this.symbolCount = symbolCount;
    this.symbolLength = symbolLength;
    this.dataTypeCount = dataTypeCount;
    this.dataTypeLength = dataTypeLength;
    this.extraCount = extraCount;
    this.extraLength = extraLength;
  }

  public long getSymbolCount() {
    return symbolCount;
  }

  public long getSymbolLength() {
    return symbolLength;
  }

  public long getDataTypeCount() {
    return dataTypeCount;
  }

  public long getDataTypeLength() {
    return dataTypeLength;
  }

  public long getExtraCount() {
    return extraCount;
  }

  public long getExtraLength() {
    return extraLength;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AdsTableSizes");

    // Simple Field (symbolCount)
    writeSimpleField(
        "symbolCount",
        symbolCount,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (symbolLength)
    writeSimpleField(
        "symbolLength",
        symbolLength,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (dataTypeCount)
    writeSimpleField(
        "dataTypeCount",
        dataTypeCount,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (dataTypeLength)
    writeSimpleField(
        "dataTypeLength",
        dataTypeLength,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (extraCount)
    writeSimpleField(
        "extraCount",
        extraCount,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (extraLength)
    writeSimpleField(
        "extraLength",
        extraLength,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("AdsTableSizes");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AdsTableSizes _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (symbolCount)
    lengthInBits += 32;

    // Simple field (symbolLength)
    lengthInBits += 32;

    // Simple field (dataTypeCount)
    lengthInBits += 32;

    // Simple field (dataTypeLength)
    lengthInBits += 32;

    // Simple field (extraCount)
    lengthInBits += 32;

    // Simple field (extraLength)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static AdsTableSizes staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AdsTableSizes staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AdsTableSizes");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long symbolCount =
        readSimpleField(
            "symbolCount",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long symbolLength =
        readSimpleField(
            "symbolLength",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long dataTypeCount =
        readSimpleField(
            "dataTypeCount",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long dataTypeLength =
        readSimpleField(
            "dataTypeLength",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long extraCount =
        readSimpleField(
            "extraCount",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long extraLength =
        readSimpleField(
            "extraLength",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("AdsTableSizes");
    // Create the instance
    AdsTableSizes _adsTableSizes;
    _adsTableSizes =
        new AdsTableSizes(
            symbolCount, symbolLength, dataTypeCount, dataTypeLength, extraCount, extraLength);
    return _adsTableSizes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsTableSizes)) {
      return false;
    }
    AdsTableSizes that = (AdsTableSizes) o;
    return (getSymbolCount() == that.getSymbolCount())
        && (getSymbolLength() == that.getSymbolLength())
        && (getDataTypeCount() == that.getDataTypeCount())
        && (getDataTypeLength() == that.getDataTypeLength())
        && (getExtraCount() == that.getExtraCount())
        && (getExtraLength() == that.getExtraLength())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getSymbolCount(),
        getSymbolLength(),
        getDataTypeCount(),
        getDataTypeLength(),
        getExtraCount(),
        getExtraLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
