/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AmsNetId implements Message {

  // Properties.
  protected final short octet1;
  protected final short octet2;
  protected final short octet3;
  protected final short octet4;
  protected final short octet5;
  protected final short octet6;

  public AmsNetId(
      short octet1, short octet2, short octet3, short octet4, short octet5, short octet6) {
    super();
    this.octet1 = octet1;
    this.octet2 = octet2;
    this.octet3 = octet3;
    this.octet4 = octet4;
    this.octet5 = octet5;
    this.octet6 = octet6;
  }

  public short getOctet1() {
    return octet1;
  }

  public short getOctet2() {
    return octet2;
  }

  public short getOctet3() {
    return octet3;
  }

  public short getOctet4() {
    return octet4;
  }

  public short getOctet5() {
    return octet5;
  }

  public short getOctet6() {
    return octet6;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AmsNetId");

    // Simple Field (octet1)
    writeSimpleField("octet1", octet1, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (octet2)
    writeSimpleField("octet2", octet2, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (octet3)
    writeSimpleField("octet3", octet3, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (octet4)
    writeSimpleField("octet4", octet4, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (octet5)
    writeSimpleField("octet5", octet5, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (octet6)
    writeSimpleField("octet6", octet6, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("AmsNetId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AmsNetId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (octet1)
    lengthInBits += 8;

    // Simple field (octet2)
    lengthInBits += 8;

    // Simple field (octet3)
    lengthInBits += 8;

    // Simple field (octet4)
    lengthInBits += 8;

    // Simple field (octet5)
    lengthInBits += 8;

    // Simple field (octet6)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static AmsNetId staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AmsNetId staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AmsNetId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short octet1 = readSimpleField("octet1", readUnsignedShort(readBuffer, 8));

    short octet2 = readSimpleField("octet2", readUnsignedShort(readBuffer, 8));

    short octet3 = readSimpleField("octet3", readUnsignedShort(readBuffer, 8));

    short octet4 = readSimpleField("octet4", readUnsignedShort(readBuffer, 8));

    short octet5 = readSimpleField("octet5", readUnsignedShort(readBuffer, 8));

    short octet6 = readSimpleField("octet6", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("AmsNetId");
    // Create the instance
    AmsNetId _amsNetId;
    _amsNetId = new AmsNetId(octet1, octet2, octet3, octet4, octet5, octet6);
    return _amsNetId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AmsNetId)) {
      return false;
    }
    AmsNetId that = (AmsNetId) o;
    return (getOctet1() == that.getOctet1())
        && (getOctet2() == that.getOctet2())
        && (getOctet3() == that.getOctet3())
        && (getOctet4() == that.getOctet4())
        && (getOctet5() == that.getOctet5())
        && (getOctet6() == that.getOctet6())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getOctet1(), getOctet2(), getOctet3(), getOctet4(), getOctet5(), getOctet6());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
