/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by "plc4xgenerator -type=future"; DO NOT EDIT.

package pool

import (
	"context"
	"encoding/binary"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

var _ = fmt.Printf

func (d *future) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := d.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (d *future) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	if err := writeBuffer.PushContext("future"); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("cancelRequested", d.cancelRequested.Load()); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("interruptRequested", d.interruptRequested.Load()); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("completed", d.completed.Load()); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("errored", d.errored.Load()); err != nil {
		return err
	}

	if d.err.Load() != nil {
		if serializableField, ok := d.err.Load().(utils.Serializable); ok {
			if err := writeBuffer.PushContext("err"); err != nil {
				return err
			}
			if err := serializableField.SerializeWithWriteBuffer(ctx, writeBuffer); err != nil {
				return err
			}
			if err := writeBuffer.PopContext("err"); err != nil {
				return err
			}
		} else {
			stringValue := fmt.Sprintf("%v", d.err.Load())
			if err := writeBuffer.WriteString("err", uint32(len(stringValue)*8), "UTF-8", stringValue); err != nil {
				return err
			}
		}
	}
	if err := writeBuffer.PopContext("future"); err != nil {
		return err
	}
	return nil
}

func (d *future) String() string {
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), d); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
