/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/apache/plc4x/plc4go/protocols/s7/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type S7ParserHelper struct {
}

func (m S7ParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "SzlId":
		return model.SzlIdParseWithBuffer(context.Background(), io)
	case "AlarmMessageObjectAckType":
		return model.AlarmMessageObjectAckTypeParseWithBuffer(context.Background(), io)
	case "S7Parameter":
		messageType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.S7ParameterParseWithBuffer(context.Background(), io, messageType)
	case "S7DataAlarmMessage":
		cpuFunctionType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.S7DataAlarmMessageParseWithBuffer(context.Background(), io, cpuFunctionType)
	case "S7PayloadUserDataItem":
		cpuFunctionGroup, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		cpuFunctionType, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		cpuSubfunction, err := utils.StrToUint8(arguments[2])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.S7PayloadUserDataItemParseWithBuffer(context.Background(), io, cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
	case "AlarmMessageObjectPushType":
		return model.AlarmMessageObjectPushTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessagePushType":
		return model.AlarmMessagePushTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckObjectPushType":
		return model.AlarmMessageAckObjectPushTypeParseWithBuffer(context.Background(), io)
	case "S7Payload":
		messageType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var parameter model.S7Parameter
		return model.S7PayloadParseWithBuffer(context.Background(), io, messageType, parameter)
	case "S7Address":
		return model.S7AddressParseWithBuffer(context.Background(), io)
	case "DataItem":
		dataProtocolId, err := utils.StrToString(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		stringLength, err := utils.StrToInt32(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.DataItemParseWithBuffer(context.Background(), io, dataProtocolId, stringLength)
	case "SubItem":
		return model.SubItemParseWithBuffer(context.Background(), io)
	case "CycServiceItemType":
		return model.CycServiceItemTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckPushType":
		return model.AlarmMessageAckPushTypeParseWithBuffer(context.Background(), io)
	case "S7Message":
		return model.S7MessageParseWithBuffer(context.Background(), io)
	case "S7VarPayloadStatusItem":
		return model.S7VarPayloadStatusItemParseWithBuffer(context.Background(), io)
	case "SzlDataTreeItem":
		return model.SzlDataTreeItemParseWithBuffer(context.Background(), io)
	case "AssociatedQueryValueType":
		return model.AssociatedQueryValueTypeParseWithBuffer(context.Background(), io)
	case "COTPPacket":
		cotpLen, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.COTPPacketParseWithBuffer(context.Background(), io, cotpLen)
	case "DateAndTime":
		return model.DateAndTimeParseWithBuffer(context.Background(), io)
	case "COTPParameter":
		rest, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.COTPParameterParseWithBuffer(context.Background(), io, rest)
	case "State":
		return model.StateParseWithBuffer(context.Background(), io)
	case "TPKTPacket":
		return model.TPKTPacketParseWithBuffer(context.Background(), io)
	case "Alarm8MessageQueryType":
		return model.Alarm8MessageQueryTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckType":
		return model.AlarmMessageAckTypeParseWithBuffer(context.Background(), io)
	case "AssociatedValueType":
		return model.AssociatedValueTypeParseWithBuffer(context.Background(), io)
	case "S7VarRequestParameterItem":
		return model.S7VarRequestParameterItemParseWithBuffer(context.Background(), io)
	case "S7VarPayloadDataItem":
		return model.S7VarPayloadDataItemParseWithBuffer(context.Background(), io)
	case "AlarmMessageQueryType":
		return model.AlarmMessageQueryTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckResponseType":
		return model.AlarmMessageAckResponseTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageObjectQueryType":
		return model.AlarmMessageObjectQueryTypeParseWithBuffer(context.Background(), io)
	case "S7ParameterUserDataItem":
		return model.S7ParameterUserDataItemParseWithBuffer(context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
