/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UtcTime is the corresponding interface of UtcTime
type UtcTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// UtcTimeExactly can be used when we want exactly this type and not a type which fulfills UtcTime.
// This is useful for switch cases.
type UtcTimeExactly interface {
	UtcTime
	isUtcTime() bool
}

// _UtcTime is the data-structure of this message
type _UtcTime struct {
}

// NewUtcTime factory function for _UtcTime
func NewUtcTime() *_UtcTime {
	return &_UtcTime{}
}

// Deprecated: use the interface for direct cast
func CastUtcTime(structType any) UtcTime {
	if casted, ok := structType.(UtcTime); ok {
		return casted
	}
	if casted, ok := structType.(*UtcTime); ok {
		return *casted
	}
	return nil
}

func (m *_UtcTime) GetTypeName() string {
	return "UtcTime"
}

func (m *_UtcTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_UtcTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UtcTimeParse(ctx context.Context, theBytes []byte) (UtcTime, error) {
	return UtcTimeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func UtcTimeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (UtcTime, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("UtcTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UtcTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("UtcTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UtcTime")
	}

	// Create the instance
	return &_UtcTime{}, nil
}

func (m *_UtcTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UtcTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("UtcTime"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for UtcTime")
	}

	if popErr := writeBuffer.PopContext("UtcTime"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for UtcTime")
	}
	return nil
}

func (m *_UtcTime) isUtcTime() bool {
	return true
}

func (m *_UtcTime) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
