/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UserTokenPolicy is the corresponding interface of UserTokenPolicy
type UserTokenPolicy interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetPolicyId returns PolicyId (property field)
	GetPolicyId() PascalString
	// GetTokenType returns TokenType (property field)
	GetTokenType() UserTokenType
	// GetIssuedTokenType returns IssuedTokenType (property field)
	GetIssuedTokenType() PascalString
	// GetIssuerEndpointUrl returns IssuerEndpointUrl (property field)
	GetIssuerEndpointUrl() PascalString
	// GetSecurityPolicyUri returns SecurityPolicyUri (property field)
	GetSecurityPolicyUri() PascalString
}

// UserTokenPolicyExactly can be used when we want exactly this type and not a type which fulfills UserTokenPolicy.
// This is useful for switch cases.
type UserTokenPolicyExactly interface {
	UserTokenPolicy
	isUserTokenPolicy() bool
}

// _UserTokenPolicy is the data-structure of this message
type _UserTokenPolicy struct {
	*_ExtensionObjectDefinition
	PolicyId          PascalString
	TokenType         UserTokenType
	IssuedTokenType   PascalString
	IssuerEndpointUrl PascalString
	SecurityPolicyUri PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UserTokenPolicy) GetIdentifier() string {
	return "306"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UserTokenPolicy) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_UserTokenPolicy) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UserTokenPolicy) GetPolicyId() PascalString {
	return m.PolicyId
}

func (m *_UserTokenPolicy) GetTokenType() UserTokenType {
	return m.TokenType
}

func (m *_UserTokenPolicy) GetIssuedTokenType() PascalString {
	return m.IssuedTokenType
}

func (m *_UserTokenPolicy) GetIssuerEndpointUrl() PascalString {
	return m.IssuerEndpointUrl
}

func (m *_UserTokenPolicy) GetSecurityPolicyUri() PascalString {
	return m.SecurityPolicyUri
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewUserTokenPolicy factory function for _UserTokenPolicy
func NewUserTokenPolicy(policyId PascalString, tokenType UserTokenType, issuedTokenType PascalString, issuerEndpointUrl PascalString, securityPolicyUri PascalString) *_UserTokenPolicy {
	_result := &_UserTokenPolicy{
		PolicyId:                   policyId,
		TokenType:                  tokenType,
		IssuedTokenType:            issuedTokenType,
		IssuerEndpointUrl:          issuerEndpointUrl,
		SecurityPolicyUri:          securityPolicyUri,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastUserTokenPolicy(structType any) UserTokenPolicy {
	if casted, ok := structType.(UserTokenPolicy); ok {
		return casted
	}
	if casted, ok := structType.(*UserTokenPolicy); ok {
		return *casted
	}
	return nil
}

func (m *_UserTokenPolicy) GetTypeName() string {
	return "UserTokenPolicy"
}

func (m *_UserTokenPolicy) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (policyId)
	lengthInBits += m.PolicyId.GetLengthInBits(ctx)

	// Simple field (tokenType)
	lengthInBits += 32

	// Simple field (issuedTokenType)
	lengthInBits += m.IssuedTokenType.GetLengthInBits(ctx)

	// Simple field (issuerEndpointUrl)
	lengthInBits += m.IssuerEndpointUrl.GetLengthInBits(ctx)

	// Simple field (securityPolicyUri)
	lengthInBits += m.SecurityPolicyUri.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UserTokenPolicy) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UserTokenPolicyParse(ctx context.Context, theBytes []byte, identifier string) (UserTokenPolicy, error) {
	return UserTokenPolicyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func UserTokenPolicyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (UserTokenPolicy, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("UserTokenPolicy"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UserTokenPolicy")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (policyId)
	if pullErr := readBuffer.PullContext("policyId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for policyId")
	}
	_policyId, _policyIdErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _policyIdErr != nil {
		return nil, errors.Wrap(_policyIdErr, "Error parsing 'policyId' field of UserTokenPolicy")
	}
	policyId := _policyId.(PascalString)
	if closeErr := readBuffer.CloseContext("policyId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for policyId")
	}

	// Simple Field (tokenType)
	if pullErr := readBuffer.PullContext("tokenType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for tokenType")
	}
	_tokenType, _tokenTypeErr := UserTokenTypeParseWithBuffer(ctx, readBuffer)
	if _tokenTypeErr != nil {
		return nil, errors.Wrap(_tokenTypeErr, "Error parsing 'tokenType' field of UserTokenPolicy")
	}
	tokenType := _tokenType
	if closeErr := readBuffer.CloseContext("tokenType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for tokenType")
	}

	// Simple Field (issuedTokenType)
	if pullErr := readBuffer.PullContext("issuedTokenType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for issuedTokenType")
	}
	_issuedTokenType, _issuedTokenTypeErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _issuedTokenTypeErr != nil {
		return nil, errors.Wrap(_issuedTokenTypeErr, "Error parsing 'issuedTokenType' field of UserTokenPolicy")
	}
	issuedTokenType := _issuedTokenType.(PascalString)
	if closeErr := readBuffer.CloseContext("issuedTokenType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for issuedTokenType")
	}

	// Simple Field (issuerEndpointUrl)
	if pullErr := readBuffer.PullContext("issuerEndpointUrl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for issuerEndpointUrl")
	}
	_issuerEndpointUrl, _issuerEndpointUrlErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _issuerEndpointUrlErr != nil {
		return nil, errors.Wrap(_issuerEndpointUrlErr, "Error parsing 'issuerEndpointUrl' field of UserTokenPolicy")
	}
	issuerEndpointUrl := _issuerEndpointUrl.(PascalString)
	if closeErr := readBuffer.CloseContext("issuerEndpointUrl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for issuerEndpointUrl")
	}

	// Simple Field (securityPolicyUri)
	if pullErr := readBuffer.PullContext("securityPolicyUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityPolicyUri")
	}
	_securityPolicyUri, _securityPolicyUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _securityPolicyUriErr != nil {
		return nil, errors.Wrap(_securityPolicyUriErr, "Error parsing 'securityPolicyUri' field of UserTokenPolicy")
	}
	securityPolicyUri := _securityPolicyUri.(PascalString)
	if closeErr := readBuffer.CloseContext("securityPolicyUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityPolicyUri")
	}

	if closeErr := readBuffer.CloseContext("UserTokenPolicy"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UserTokenPolicy")
	}

	// Create a partially initialized instance
	_child := &_UserTokenPolicy{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		PolicyId:                   policyId,
		TokenType:                  tokenType,
		IssuedTokenType:            issuedTokenType,
		IssuerEndpointUrl:          issuerEndpointUrl,
		SecurityPolicyUri:          securityPolicyUri,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_UserTokenPolicy) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UserTokenPolicy) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UserTokenPolicy"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UserTokenPolicy")
		}

		// Simple Field (policyId)
		if pushErr := writeBuffer.PushContext("policyId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for policyId")
		}
		_policyIdErr := writeBuffer.WriteSerializable(ctx, m.GetPolicyId())
		if popErr := writeBuffer.PopContext("policyId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for policyId")
		}
		if _policyIdErr != nil {
			return errors.Wrap(_policyIdErr, "Error serializing 'policyId' field")
		}

		// Simple Field (tokenType)
		if pushErr := writeBuffer.PushContext("tokenType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for tokenType")
		}
		_tokenTypeErr := writeBuffer.WriteSerializable(ctx, m.GetTokenType())
		if popErr := writeBuffer.PopContext("tokenType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for tokenType")
		}
		if _tokenTypeErr != nil {
			return errors.Wrap(_tokenTypeErr, "Error serializing 'tokenType' field")
		}

		// Simple Field (issuedTokenType)
		if pushErr := writeBuffer.PushContext("issuedTokenType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for issuedTokenType")
		}
		_issuedTokenTypeErr := writeBuffer.WriteSerializable(ctx, m.GetIssuedTokenType())
		if popErr := writeBuffer.PopContext("issuedTokenType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for issuedTokenType")
		}
		if _issuedTokenTypeErr != nil {
			return errors.Wrap(_issuedTokenTypeErr, "Error serializing 'issuedTokenType' field")
		}

		// Simple Field (issuerEndpointUrl)
		if pushErr := writeBuffer.PushContext("issuerEndpointUrl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for issuerEndpointUrl")
		}
		_issuerEndpointUrlErr := writeBuffer.WriteSerializable(ctx, m.GetIssuerEndpointUrl())
		if popErr := writeBuffer.PopContext("issuerEndpointUrl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for issuerEndpointUrl")
		}
		if _issuerEndpointUrlErr != nil {
			return errors.Wrap(_issuerEndpointUrlErr, "Error serializing 'issuerEndpointUrl' field")
		}

		// Simple Field (securityPolicyUri)
		if pushErr := writeBuffer.PushContext("securityPolicyUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityPolicyUri")
		}
		_securityPolicyUriErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityPolicyUri())
		if popErr := writeBuffer.PopContext("securityPolicyUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityPolicyUri")
		}
		if _securityPolicyUriErr != nil {
			return errors.Wrap(_securityPolicyUriErr, "Error serializing 'securityPolicyUri' field")
		}

		if popErr := writeBuffer.PopContext("UserTokenPolicy"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UserTokenPolicy")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UserTokenPolicy) isUserTokenPolicy() bool {
	return true
}

func (m *_UserTokenPolicy) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
