/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UserNameIdentityToken is the corresponding interface of UserNameIdentityToken
type UserNameIdentityToken interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	UserIdentityTokenDefinition
	// GetUserName returns UserName (property field)
	GetUserName() PascalString
	// GetPassword returns Password (property field)
	GetPassword() PascalByteString
	// GetEncryptionAlgorithm returns EncryptionAlgorithm (property field)
	GetEncryptionAlgorithm() PascalString
}

// UserNameIdentityTokenExactly can be used when we want exactly this type and not a type which fulfills UserNameIdentityToken.
// This is useful for switch cases.
type UserNameIdentityTokenExactly interface {
	UserNameIdentityToken
	isUserNameIdentityToken() bool
}

// _UserNameIdentityToken is the data-structure of this message
type _UserNameIdentityToken struct {
	*_UserIdentityTokenDefinition
	UserName            PascalString
	Password            PascalByteString
	EncryptionAlgorithm PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UserNameIdentityToken) GetIdentifier() string {
	return "username"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UserNameIdentityToken) InitializeParent(parent UserIdentityTokenDefinition) {}

func (m *_UserNameIdentityToken) GetParent() UserIdentityTokenDefinition {
	return m._UserIdentityTokenDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UserNameIdentityToken) GetUserName() PascalString {
	return m.UserName
}

func (m *_UserNameIdentityToken) GetPassword() PascalByteString {
	return m.Password
}

func (m *_UserNameIdentityToken) GetEncryptionAlgorithm() PascalString {
	return m.EncryptionAlgorithm
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewUserNameIdentityToken factory function for _UserNameIdentityToken
func NewUserNameIdentityToken(userName PascalString, password PascalByteString, encryptionAlgorithm PascalString) *_UserNameIdentityToken {
	_result := &_UserNameIdentityToken{
		UserName:                     userName,
		Password:                     password,
		EncryptionAlgorithm:          encryptionAlgorithm,
		_UserIdentityTokenDefinition: NewUserIdentityTokenDefinition(),
	}
	_result._UserIdentityTokenDefinition._UserIdentityTokenDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastUserNameIdentityToken(structType any) UserNameIdentityToken {
	if casted, ok := structType.(UserNameIdentityToken); ok {
		return casted
	}
	if casted, ok := structType.(*UserNameIdentityToken); ok {
		return *casted
	}
	return nil
}

func (m *_UserNameIdentityToken) GetTypeName() string {
	return "UserNameIdentityToken"
}

func (m *_UserNameIdentityToken) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (userName)
	lengthInBits += m.UserName.GetLengthInBits(ctx)

	// Simple field (password)
	lengthInBits += m.Password.GetLengthInBits(ctx)

	// Simple field (encryptionAlgorithm)
	lengthInBits += m.EncryptionAlgorithm.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UserNameIdentityToken) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UserNameIdentityTokenParse(ctx context.Context, theBytes []byte, identifier string) (UserNameIdentityToken, error) {
	return UserNameIdentityTokenParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func UserNameIdentityTokenParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (UserNameIdentityToken, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("UserNameIdentityToken"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UserNameIdentityToken")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (userName)
	if pullErr := readBuffer.PullContext("userName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for userName")
	}
	_userName, _userNameErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _userNameErr != nil {
		return nil, errors.Wrap(_userNameErr, "Error parsing 'userName' field of UserNameIdentityToken")
	}
	userName := _userName.(PascalString)
	if closeErr := readBuffer.CloseContext("userName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for userName")
	}

	// Simple Field (password)
	if pullErr := readBuffer.PullContext("password"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for password")
	}
	_password, _passwordErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _passwordErr != nil {
		return nil, errors.Wrap(_passwordErr, "Error parsing 'password' field of UserNameIdentityToken")
	}
	password := _password.(PascalByteString)
	if closeErr := readBuffer.CloseContext("password"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for password")
	}

	// Simple Field (encryptionAlgorithm)
	if pullErr := readBuffer.PullContext("encryptionAlgorithm"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for encryptionAlgorithm")
	}
	_encryptionAlgorithm, _encryptionAlgorithmErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _encryptionAlgorithmErr != nil {
		return nil, errors.Wrap(_encryptionAlgorithmErr, "Error parsing 'encryptionAlgorithm' field of UserNameIdentityToken")
	}
	encryptionAlgorithm := _encryptionAlgorithm.(PascalString)
	if closeErr := readBuffer.CloseContext("encryptionAlgorithm"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for encryptionAlgorithm")
	}

	if closeErr := readBuffer.CloseContext("UserNameIdentityToken"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UserNameIdentityToken")
	}

	// Create a partially initialized instance
	_child := &_UserNameIdentityToken{
		_UserIdentityTokenDefinition: &_UserIdentityTokenDefinition{},
		UserName:                     userName,
		Password:                     password,
		EncryptionAlgorithm:          encryptionAlgorithm,
	}
	_child._UserIdentityTokenDefinition._UserIdentityTokenDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_UserNameIdentityToken) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UserNameIdentityToken) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UserNameIdentityToken"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UserNameIdentityToken")
		}

		// Simple Field (userName)
		if pushErr := writeBuffer.PushContext("userName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for userName")
		}
		_userNameErr := writeBuffer.WriteSerializable(ctx, m.GetUserName())
		if popErr := writeBuffer.PopContext("userName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for userName")
		}
		if _userNameErr != nil {
			return errors.Wrap(_userNameErr, "Error serializing 'userName' field")
		}

		// Simple Field (password)
		if pushErr := writeBuffer.PushContext("password"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for password")
		}
		_passwordErr := writeBuffer.WriteSerializable(ctx, m.GetPassword())
		if popErr := writeBuffer.PopContext("password"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for password")
		}
		if _passwordErr != nil {
			return errors.Wrap(_passwordErr, "Error serializing 'password' field")
		}

		// Simple Field (encryptionAlgorithm)
		if pushErr := writeBuffer.PushContext("encryptionAlgorithm"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for encryptionAlgorithm")
		}
		_encryptionAlgorithmErr := writeBuffer.WriteSerializable(ctx, m.GetEncryptionAlgorithm())
		if popErr := writeBuffer.PopContext("encryptionAlgorithm"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for encryptionAlgorithm")
		}
		if _encryptionAlgorithmErr != nil {
			return errors.Wrap(_encryptionAlgorithmErr, "Error serializing 'encryptionAlgorithm' field")
		}

		if popErr := writeBuffer.PopContext("UserNameIdentityToken"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UserNameIdentityToken")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UserNameIdentityToken) isUserNameIdentityToken() bool {
	return true
}

func (m *_UserNameIdentityToken) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
