/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UserManagementDataType is the corresponding interface of UserManagementDataType
type UserManagementDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetUserName returns UserName (property field)
	GetUserName() PascalString
	// GetUserConfiguration returns UserConfiguration (property field)
	GetUserConfiguration() UserConfigurationMask
	// GetDescription returns Description (property field)
	GetDescription() PascalString
}

// UserManagementDataTypeExactly can be used when we want exactly this type and not a type which fulfills UserManagementDataType.
// This is useful for switch cases.
type UserManagementDataTypeExactly interface {
	UserManagementDataType
	isUserManagementDataType() bool
}

// _UserManagementDataType is the data-structure of this message
type _UserManagementDataType struct {
	*_ExtensionObjectDefinition
	UserName          PascalString
	UserConfiguration UserConfigurationMask
	Description       PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UserManagementDataType) GetIdentifier() string {
	return "24283"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UserManagementDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_UserManagementDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UserManagementDataType) GetUserName() PascalString {
	return m.UserName
}

func (m *_UserManagementDataType) GetUserConfiguration() UserConfigurationMask {
	return m.UserConfiguration
}

func (m *_UserManagementDataType) GetDescription() PascalString {
	return m.Description
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewUserManagementDataType factory function for _UserManagementDataType
func NewUserManagementDataType(userName PascalString, userConfiguration UserConfigurationMask, description PascalString) *_UserManagementDataType {
	_result := &_UserManagementDataType{
		UserName:                   userName,
		UserConfiguration:          userConfiguration,
		Description:                description,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastUserManagementDataType(structType any) UserManagementDataType {
	if casted, ok := structType.(UserManagementDataType); ok {
		return casted
	}
	if casted, ok := structType.(*UserManagementDataType); ok {
		return *casted
	}
	return nil
}

func (m *_UserManagementDataType) GetTypeName() string {
	return "UserManagementDataType"
}

func (m *_UserManagementDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (userName)
	lengthInBits += m.UserName.GetLengthInBits(ctx)

	// Simple field (userConfiguration)
	lengthInBits += 32

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UserManagementDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UserManagementDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (UserManagementDataType, error) {
	return UserManagementDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func UserManagementDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (UserManagementDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("UserManagementDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UserManagementDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (userName)
	if pullErr := readBuffer.PullContext("userName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for userName")
	}
	_userName, _userNameErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _userNameErr != nil {
		return nil, errors.Wrap(_userNameErr, "Error parsing 'userName' field of UserManagementDataType")
	}
	userName := _userName.(PascalString)
	if closeErr := readBuffer.CloseContext("userName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for userName")
	}

	// Simple Field (userConfiguration)
	if pullErr := readBuffer.PullContext("userConfiguration"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for userConfiguration")
	}
	_userConfiguration, _userConfigurationErr := UserConfigurationMaskParseWithBuffer(ctx, readBuffer)
	if _userConfigurationErr != nil {
		return nil, errors.Wrap(_userConfigurationErr, "Error parsing 'userConfiguration' field of UserManagementDataType")
	}
	userConfiguration := _userConfiguration
	if closeErr := readBuffer.CloseContext("userConfiguration"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for userConfiguration")
	}

	// Simple Field (description)
	if pullErr := readBuffer.PullContext("description"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for description")
	}
	_description, _descriptionErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _descriptionErr != nil {
		return nil, errors.Wrap(_descriptionErr, "Error parsing 'description' field of UserManagementDataType")
	}
	description := _description.(PascalString)
	if closeErr := readBuffer.CloseContext("description"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for description")
	}

	if closeErr := readBuffer.CloseContext("UserManagementDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UserManagementDataType")
	}

	// Create a partially initialized instance
	_child := &_UserManagementDataType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		UserName:                   userName,
		UserConfiguration:          userConfiguration,
		Description:                description,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_UserManagementDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UserManagementDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UserManagementDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UserManagementDataType")
		}

		// Simple Field (userName)
		if pushErr := writeBuffer.PushContext("userName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for userName")
		}
		_userNameErr := writeBuffer.WriteSerializable(ctx, m.GetUserName())
		if popErr := writeBuffer.PopContext("userName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for userName")
		}
		if _userNameErr != nil {
			return errors.Wrap(_userNameErr, "Error serializing 'userName' field")
		}

		// Simple Field (userConfiguration)
		if pushErr := writeBuffer.PushContext("userConfiguration"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for userConfiguration")
		}
		_userConfigurationErr := writeBuffer.WriteSerializable(ctx, m.GetUserConfiguration())
		if popErr := writeBuffer.PopContext("userConfiguration"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for userConfiguration")
		}
		if _userConfigurationErr != nil {
			return errors.Wrap(_userConfigurationErr, "Error serializing 'userConfiguration' field")
		}

		// Simple Field (description)
		if pushErr := writeBuffer.PushContext("description"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for description")
		}
		_descriptionErr := writeBuffer.WriteSerializable(ctx, m.GetDescription())
		if popErr := writeBuffer.PopContext("description"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for description")
		}
		if _descriptionErr != nil {
			return errors.Wrap(_descriptionErr, "Error serializing 'description' field")
		}

		if popErr := writeBuffer.PopContext("UserManagementDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UserManagementDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UserManagementDataType) isUserManagementDataType() bool {
	return true
}

func (m *_UserManagementDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
