/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UserIdentityTokenDefinition is the corresponding interface of UserIdentityTokenDefinition
type UserIdentityTokenDefinition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetIdentifier returns Identifier (discriminator field)
	GetIdentifier() string
}

// UserIdentityTokenDefinitionExactly can be used when we want exactly this type and not a type which fulfills UserIdentityTokenDefinition.
// This is useful for switch cases.
type UserIdentityTokenDefinitionExactly interface {
	UserIdentityTokenDefinition
	isUserIdentityTokenDefinition() bool
}

// _UserIdentityTokenDefinition is the data-structure of this message
type _UserIdentityTokenDefinition struct {
	_UserIdentityTokenDefinitionChildRequirements
}

type _UserIdentityTokenDefinitionChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetIdentifier() string
}

type UserIdentityTokenDefinitionParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child UserIdentityTokenDefinition, serializeChildFunction func() error) error
	GetTypeName() string
}

type UserIdentityTokenDefinitionChild interface {
	utils.Serializable
	InitializeParent(parent UserIdentityTokenDefinition)
	GetParent() *UserIdentityTokenDefinition

	GetTypeName() string
	UserIdentityTokenDefinition
}

// NewUserIdentityTokenDefinition factory function for _UserIdentityTokenDefinition
func NewUserIdentityTokenDefinition() *_UserIdentityTokenDefinition {
	return &_UserIdentityTokenDefinition{}
}

// Deprecated: use the interface for direct cast
func CastUserIdentityTokenDefinition(structType any) UserIdentityTokenDefinition {
	if casted, ok := structType.(UserIdentityTokenDefinition); ok {
		return casted
	}
	if casted, ok := structType.(*UserIdentityTokenDefinition); ok {
		return *casted
	}
	return nil
}

func (m *_UserIdentityTokenDefinition) GetTypeName() string {
	return "UserIdentityTokenDefinition"
}

func (m *_UserIdentityTokenDefinition) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_UserIdentityTokenDefinition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UserIdentityTokenDefinitionParse(ctx context.Context, theBytes []byte, identifier string) (UserIdentityTokenDefinition, error) {
	return UserIdentityTokenDefinitionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func UserIdentityTokenDefinitionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (UserIdentityTokenDefinition, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("UserIdentityTokenDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UserIdentityTokenDefinition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type UserIdentityTokenDefinitionChildSerializeRequirement interface {
		UserIdentityTokenDefinition
		InitializeParent(UserIdentityTokenDefinition)
		GetParent() UserIdentityTokenDefinition
	}
	var _childTemp any
	var _child UserIdentityTokenDefinitionChildSerializeRequirement
	var typeSwitchError error
	switch {
	case identifier == "anonymous": // AnonymousIdentityToken
		_childTemp, typeSwitchError = AnonymousIdentityTokenParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "username": // UserNameIdentityToken
		_childTemp, typeSwitchError = UserNameIdentityTokenParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "certificate": // X509IdentityToken
		_childTemp, typeSwitchError = X509IdentityTokenParseWithBuffer(ctx, readBuffer, identifier)
	case identifier == "identity": // IssuedIdentityToken
		_childTemp, typeSwitchError = IssuedIdentityTokenParseWithBuffer(ctx, readBuffer, identifier)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [identifier=%v]", identifier)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of UserIdentityTokenDefinition")
	}
	_child = _childTemp.(UserIdentityTokenDefinitionChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("UserIdentityTokenDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UserIdentityTokenDefinition")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_UserIdentityTokenDefinition) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child UserIdentityTokenDefinition, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("UserIdentityTokenDefinition"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for UserIdentityTokenDefinition")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("UserIdentityTokenDefinition"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for UserIdentityTokenDefinition")
	}
	return nil
}

func (m *_UserIdentityTokenDefinition) isUserIdentityTokenDefinition() bool {
	return true
}

func (m *_UserIdentityTokenDefinition) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
