/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// UadpNetworkMessageContentMask is an enum
type UadpNetworkMessageContentMask uint32

type IUadpNetworkMessageContentMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNone                 UadpNetworkMessageContentMask = 0
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPublisherId          UadpNetworkMessageContentMask = 1
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupHeader          UadpNetworkMessageContentMask = 2
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskWriterGroupId        UadpNetworkMessageContentMask = 4
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupVersion         UadpNetworkMessageContentMask = 8
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNetworkMessageNumber UadpNetworkMessageContentMask = 16
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskSequenceNumber       UadpNetworkMessageContentMask = 32
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPayloadHeader        UadpNetworkMessageContentMask = 64
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskTimestamp            UadpNetworkMessageContentMask = 128
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPicoSeconds          UadpNetworkMessageContentMask = 256
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskDataSetClassId       UadpNetworkMessageContentMask = 512
	UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPromotedFields       UadpNetworkMessageContentMask = 1024
)

var UadpNetworkMessageContentMaskValues []UadpNetworkMessageContentMask

func init() {
	_ = errors.New
	UadpNetworkMessageContentMaskValues = []UadpNetworkMessageContentMask{
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNone,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPublisherId,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupHeader,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskWriterGroupId,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupVersion,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNetworkMessageNumber,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskSequenceNumber,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPayloadHeader,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskTimestamp,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPicoSeconds,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskDataSetClassId,
		UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPromotedFields,
	}
}

func UadpNetworkMessageContentMaskByValue(value uint32) (enum UadpNetworkMessageContentMask, ok bool) {
	switch value {
	case 0:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNone, true
	case 1:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPublisherId, true
	case 1024:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPromotedFields, true
	case 128:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskTimestamp, true
	case 16:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNetworkMessageNumber, true
	case 2:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupHeader, true
	case 256:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPicoSeconds, true
	case 32:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskSequenceNumber, true
	case 4:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskWriterGroupId, true
	case 512:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskDataSetClassId, true
	case 64:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPayloadHeader, true
	case 8:
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupVersion, true
	}
	return 0, false
}

func UadpNetworkMessageContentMaskByName(value string) (enum UadpNetworkMessageContentMask, ok bool) {
	switch value {
	case "uadpNetworkMessageContentMaskNone":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNone, true
	case "uadpNetworkMessageContentMaskPublisherId":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPublisherId, true
	case "uadpNetworkMessageContentMaskPromotedFields":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPromotedFields, true
	case "uadpNetworkMessageContentMaskTimestamp":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskTimestamp, true
	case "uadpNetworkMessageContentMaskNetworkMessageNumber":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNetworkMessageNumber, true
	case "uadpNetworkMessageContentMaskGroupHeader":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupHeader, true
	case "uadpNetworkMessageContentMaskPicoSeconds":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPicoSeconds, true
	case "uadpNetworkMessageContentMaskSequenceNumber":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskSequenceNumber, true
	case "uadpNetworkMessageContentMaskWriterGroupId":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskWriterGroupId, true
	case "uadpNetworkMessageContentMaskDataSetClassId":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskDataSetClassId, true
	case "uadpNetworkMessageContentMaskPayloadHeader":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPayloadHeader, true
	case "uadpNetworkMessageContentMaskGroupVersion":
		return UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupVersion, true
	}
	return 0, false
}

func UadpNetworkMessageContentMaskKnows(value uint32) bool {
	for _, typeValue := range UadpNetworkMessageContentMaskValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastUadpNetworkMessageContentMask(structType any) UadpNetworkMessageContentMask {
	castFunc := func(typ any) UadpNetworkMessageContentMask {
		if sUadpNetworkMessageContentMask, ok := typ.(UadpNetworkMessageContentMask); ok {
			return sUadpNetworkMessageContentMask
		}
		return 0
	}
	return castFunc(structType)
}

func (m UadpNetworkMessageContentMask) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m UadpNetworkMessageContentMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UadpNetworkMessageContentMaskParse(ctx context.Context, theBytes []byte) (UadpNetworkMessageContentMask, error) {
	return UadpNetworkMessageContentMaskParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func UadpNetworkMessageContentMaskParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (UadpNetworkMessageContentMask, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("UadpNetworkMessageContentMask", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading UadpNetworkMessageContentMask")
	}
	if enum, ok := UadpNetworkMessageContentMaskByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for UadpNetworkMessageContentMask")
		return UadpNetworkMessageContentMask(val), nil
	} else {
		return enum, nil
	}
}

func (e UadpNetworkMessageContentMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e UadpNetworkMessageContentMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("UadpNetworkMessageContentMask", 32, uint32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e UadpNetworkMessageContentMask) PLC4XEnumName() string {
	switch e {
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNone:
		return "uadpNetworkMessageContentMaskNone"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPublisherId:
		return "uadpNetworkMessageContentMaskPublisherId"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPromotedFields:
		return "uadpNetworkMessageContentMaskPromotedFields"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskTimestamp:
		return "uadpNetworkMessageContentMaskTimestamp"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskNetworkMessageNumber:
		return "uadpNetworkMessageContentMaskNetworkMessageNumber"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupHeader:
		return "uadpNetworkMessageContentMaskGroupHeader"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPicoSeconds:
		return "uadpNetworkMessageContentMaskPicoSeconds"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskSequenceNumber:
		return "uadpNetworkMessageContentMaskSequenceNumber"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskWriterGroupId:
		return "uadpNetworkMessageContentMaskWriterGroupId"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskDataSetClassId:
		return "uadpNetworkMessageContentMaskDataSetClassId"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskPayloadHeader:
		return "uadpNetworkMessageContentMaskPayloadHeader"
	case UadpNetworkMessageContentMask_uadpNetworkMessageContentMaskGroupVersion:
		return "uadpNetworkMessageContentMaskGroupVersion"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e UadpNetworkMessageContentMask) String() string {
	return e.PLC4XEnumName()
}
