/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SubscriptionDiagnosticsDataType is the corresponding interface of SubscriptionDiagnosticsDataType
type SubscriptionDiagnosticsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetSessionId returns SessionId (property field)
	GetSessionId() NodeId
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetPriority returns Priority (property field)
	GetPriority() uint8
	// GetPublishingInterval returns PublishingInterval (property field)
	GetPublishingInterval() float64
	// GetMaxKeepAliveCount returns MaxKeepAliveCount (property field)
	GetMaxKeepAliveCount() uint32
	// GetMaxLifetimeCount returns MaxLifetimeCount (property field)
	GetMaxLifetimeCount() uint32
	// GetMaxNotificationsPerPublish returns MaxNotificationsPerPublish (property field)
	GetMaxNotificationsPerPublish() uint32
	// GetPublishingEnabled returns PublishingEnabled (property field)
	GetPublishingEnabled() bool
	// GetModifyCount returns ModifyCount (property field)
	GetModifyCount() uint32
	// GetEnableCount returns EnableCount (property field)
	GetEnableCount() uint32
	// GetDisableCount returns DisableCount (property field)
	GetDisableCount() uint32
	// GetRepublishRequestCount returns RepublishRequestCount (property field)
	GetRepublishRequestCount() uint32
	// GetRepublishMessageRequestCount returns RepublishMessageRequestCount (property field)
	GetRepublishMessageRequestCount() uint32
	// GetRepublishMessageCount returns RepublishMessageCount (property field)
	GetRepublishMessageCount() uint32
	// GetTransferRequestCount returns TransferRequestCount (property field)
	GetTransferRequestCount() uint32
	// GetTransferredToAltClientCount returns TransferredToAltClientCount (property field)
	GetTransferredToAltClientCount() uint32
	// GetTransferredToSameClientCount returns TransferredToSameClientCount (property field)
	GetTransferredToSameClientCount() uint32
	// GetPublishRequestCount returns PublishRequestCount (property field)
	GetPublishRequestCount() uint32
	// GetDataChangeNotificationsCount returns DataChangeNotificationsCount (property field)
	GetDataChangeNotificationsCount() uint32
	// GetEventNotificationsCount returns EventNotificationsCount (property field)
	GetEventNotificationsCount() uint32
	// GetNotificationsCount returns NotificationsCount (property field)
	GetNotificationsCount() uint32
	// GetLatePublishRequestCount returns LatePublishRequestCount (property field)
	GetLatePublishRequestCount() uint32
	// GetCurrentKeepAliveCount returns CurrentKeepAliveCount (property field)
	GetCurrentKeepAliveCount() uint32
	// GetCurrentLifetimeCount returns CurrentLifetimeCount (property field)
	GetCurrentLifetimeCount() uint32
	// GetUnacknowledgedMessageCount returns UnacknowledgedMessageCount (property field)
	GetUnacknowledgedMessageCount() uint32
	// GetDiscardedMessageCount returns DiscardedMessageCount (property field)
	GetDiscardedMessageCount() uint32
	// GetMonitoredItemCount returns MonitoredItemCount (property field)
	GetMonitoredItemCount() uint32
	// GetDisabledMonitoredItemCount returns DisabledMonitoredItemCount (property field)
	GetDisabledMonitoredItemCount() uint32
	// GetMonitoringQueueOverflowCount returns MonitoringQueueOverflowCount (property field)
	GetMonitoringQueueOverflowCount() uint32
	// GetNextSequenceNumber returns NextSequenceNumber (property field)
	GetNextSequenceNumber() uint32
	// GetEventQueueOverFlowCount returns EventQueueOverFlowCount (property field)
	GetEventQueueOverFlowCount() uint32
}

// SubscriptionDiagnosticsDataTypeExactly can be used when we want exactly this type and not a type which fulfills SubscriptionDiagnosticsDataType.
// This is useful for switch cases.
type SubscriptionDiagnosticsDataTypeExactly interface {
	SubscriptionDiagnosticsDataType
	isSubscriptionDiagnosticsDataType() bool
}

// _SubscriptionDiagnosticsDataType is the data-structure of this message
type _SubscriptionDiagnosticsDataType struct {
	*_ExtensionObjectDefinition
	SessionId                    NodeId
	SubscriptionId               uint32
	Priority                     uint8
	PublishingInterval           float64
	MaxKeepAliveCount            uint32
	MaxLifetimeCount             uint32
	MaxNotificationsPerPublish   uint32
	PublishingEnabled            bool
	ModifyCount                  uint32
	EnableCount                  uint32
	DisableCount                 uint32
	RepublishRequestCount        uint32
	RepublishMessageRequestCount uint32
	RepublishMessageCount        uint32
	TransferRequestCount         uint32
	TransferredToAltClientCount  uint32
	TransferredToSameClientCount uint32
	PublishRequestCount          uint32
	DataChangeNotificationsCount uint32
	EventNotificationsCount      uint32
	NotificationsCount           uint32
	LatePublishRequestCount      uint32
	CurrentKeepAliveCount        uint32
	CurrentLifetimeCount         uint32
	UnacknowledgedMessageCount   uint32
	DiscardedMessageCount        uint32
	MonitoredItemCount           uint32
	DisabledMonitoredItemCount   uint32
	MonitoringQueueOverflowCount uint32
	NextSequenceNumber           uint32
	EventQueueOverFlowCount      uint32
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SubscriptionDiagnosticsDataType) GetIdentifier() string {
	return "876"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SubscriptionDiagnosticsDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SubscriptionDiagnosticsDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SubscriptionDiagnosticsDataType) GetSessionId() NodeId {
	return m.SessionId
}

func (m *_SubscriptionDiagnosticsDataType) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_SubscriptionDiagnosticsDataType) GetPriority() uint8 {
	return m.Priority
}

func (m *_SubscriptionDiagnosticsDataType) GetPublishingInterval() float64 {
	return m.PublishingInterval
}

func (m *_SubscriptionDiagnosticsDataType) GetMaxKeepAliveCount() uint32 {
	return m.MaxKeepAliveCount
}

func (m *_SubscriptionDiagnosticsDataType) GetMaxLifetimeCount() uint32 {
	return m.MaxLifetimeCount
}

func (m *_SubscriptionDiagnosticsDataType) GetMaxNotificationsPerPublish() uint32 {
	return m.MaxNotificationsPerPublish
}

func (m *_SubscriptionDiagnosticsDataType) GetPublishingEnabled() bool {
	return m.PublishingEnabled
}

func (m *_SubscriptionDiagnosticsDataType) GetModifyCount() uint32 {
	return m.ModifyCount
}

func (m *_SubscriptionDiagnosticsDataType) GetEnableCount() uint32 {
	return m.EnableCount
}

func (m *_SubscriptionDiagnosticsDataType) GetDisableCount() uint32 {
	return m.DisableCount
}

func (m *_SubscriptionDiagnosticsDataType) GetRepublishRequestCount() uint32 {
	return m.RepublishRequestCount
}

func (m *_SubscriptionDiagnosticsDataType) GetRepublishMessageRequestCount() uint32 {
	return m.RepublishMessageRequestCount
}

func (m *_SubscriptionDiagnosticsDataType) GetRepublishMessageCount() uint32 {
	return m.RepublishMessageCount
}

func (m *_SubscriptionDiagnosticsDataType) GetTransferRequestCount() uint32 {
	return m.TransferRequestCount
}

func (m *_SubscriptionDiagnosticsDataType) GetTransferredToAltClientCount() uint32 {
	return m.TransferredToAltClientCount
}

func (m *_SubscriptionDiagnosticsDataType) GetTransferredToSameClientCount() uint32 {
	return m.TransferredToSameClientCount
}

func (m *_SubscriptionDiagnosticsDataType) GetPublishRequestCount() uint32 {
	return m.PublishRequestCount
}

func (m *_SubscriptionDiagnosticsDataType) GetDataChangeNotificationsCount() uint32 {
	return m.DataChangeNotificationsCount
}

func (m *_SubscriptionDiagnosticsDataType) GetEventNotificationsCount() uint32 {
	return m.EventNotificationsCount
}

func (m *_SubscriptionDiagnosticsDataType) GetNotificationsCount() uint32 {
	return m.NotificationsCount
}

func (m *_SubscriptionDiagnosticsDataType) GetLatePublishRequestCount() uint32 {
	return m.LatePublishRequestCount
}

func (m *_SubscriptionDiagnosticsDataType) GetCurrentKeepAliveCount() uint32 {
	return m.CurrentKeepAliveCount
}

func (m *_SubscriptionDiagnosticsDataType) GetCurrentLifetimeCount() uint32 {
	return m.CurrentLifetimeCount
}

func (m *_SubscriptionDiagnosticsDataType) GetUnacknowledgedMessageCount() uint32 {
	return m.UnacknowledgedMessageCount
}

func (m *_SubscriptionDiagnosticsDataType) GetDiscardedMessageCount() uint32 {
	return m.DiscardedMessageCount
}

func (m *_SubscriptionDiagnosticsDataType) GetMonitoredItemCount() uint32 {
	return m.MonitoredItemCount
}

func (m *_SubscriptionDiagnosticsDataType) GetDisabledMonitoredItemCount() uint32 {
	return m.DisabledMonitoredItemCount
}

func (m *_SubscriptionDiagnosticsDataType) GetMonitoringQueueOverflowCount() uint32 {
	return m.MonitoringQueueOverflowCount
}

func (m *_SubscriptionDiagnosticsDataType) GetNextSequenceNumber() uint32 {
	return m.NextSequenceNumber
}

func (m *_SubscriptionDiagnosticsDataType) GetEventQueueOverFlowCount() uint32 {
	return m.EventQueueOverFlowCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSubscriptionDiagnosticsDataType factory function for _SubscriptionDiagnosticsDataType
func NewSubscriptionDiagnosticsDataType(sessionId NodeId, subscriptionId uint32, priority uint8, publishingInterval float64, maxKeepAliveCount uint32, maxLifetimeCount uint32, maxNotificationsPerPublish uint32, publishingEnabled bool, modifyCount uint32, enableCount uint32, disableCount uint32, republishRequestCount uint32, republishMessageRequestCount uint32, republishMessageCount uint32, transferRequestCount uint32, transferredToAltClientCount uint32, transferredToSameClientCount uint32, publishRequestCount uint32, dataChangeNotificationsCount uint32, eventNotificationsCount uint32, notificationsCount uint32, latePublishRequestCount uint32, currentKeepAliveCount uint32, currentLifetimeCount uint32, unacknowledgedMessageCount uint32, discardedMessageCount uint32, monitoredItemCount uint32, disabledMonitoredItemCount uint32, monitoringQueueOverflowCount uint32, nextSequenceNumber uint32, eventQueueOverFlowCount uint32) *_SubscriptionDiagnosticsDataType {
	_result := &_SubscriptionDiagnosticsDataType{
		SessionId:                    sessionId,
		SubscriptionId:               subscriptionId,
		Priority:                     priority,
		PublishingInterval:           publishingInterval,
		MaxKeepAliveCount:            maxKeepAliveCount,
		MaxLifetimeCount:             maxLifetimeCount,
		MaxNotificationsPerPublish:   maxNotificationsPerPublish,
		PublishingEnabled:            publishingEnabled,
		ModifyCount:                  modifyCount,
		EnableCount:                  enableCount,
		DisableCount:                 disableCount,
		RepublishRequestCount:        republishRequestCount,
		RepublishMessageRequestCount: republishMessageRequestCount,
		RepublishMessageCount:        republishMessageCount,
		TransferRequestCount:         transferRequestCount,
		TransferredToAltClientCount:  transferredToAltClientCount,
		TransferredToSameClientCount: transferredToSameClientCount,
		PublishRequestCount:          publishRequestCount,
		DataChangeNotificationsCount: dataChangeNotificationsCount,
		EventNotificationsCount:      eventNotificationsCount,
		NotificationsCount:           notificationsCount,
		LatePublishRequestCount:      latePublishRequestCount,
		CurrentKeepAliveCount:        currentKeepAliveCount,
		CurrentLifetimeCount:         currentLifetimeCount,
		UnacknowledgedMessageCount:   unacknowledgedMessageCount,
		DiscardedMessageCount:        discardedMessageCount,
		MonitoredItemCount:           monitoredItemCount,
		DisabledMonitoredItemCount:   disabledMonitoredItemCount,
		MonitoringQueueOverflowCount: monitoringQueueOverflowCount,
		NextSequenceNumber:           nextSequenceNumber,
		EventQueueOverFlowCount:      eventQueueOverFlowCount,
		_ExtensionObjectDefinition:   NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSubscriptionDiagnosticsDataType(structType any) SubscriptionDiagnosticsDataType {
	if casted, ok := structType.(SubscriptionDiagnosticsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*SubscriptionDiagnosticsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_SubscriptionDiagnosticsDataType) GetTypeName() string {
	return "SubscriptionDiagnosticsDataType"
}

func (m *_SubscriptionDiagnosticsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (sessionId)
	lengthInBits += m.SessionId.GetLengthInBits(ctx)

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (priority)
	lengthInBits += 8

	// Simple field (publishingInterval)
	lengthInBits += 64

	// Simple field (maxKeepAliveCount)
	lengthInBits += 32

	// Simple field (maxLifetimeCount)
	lengthInBits += 32

	// Simple field (maxNotificationsPerPublish)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (publishingEnabled)
	lengthInBits += 1

	// Simple field (modifyCount)
	lengthInBits += 32

	// Simple field (enableCount)
	lengthInBits += 32

	// Simple field (disableCount)
	lengthInBits += 32

	// Simple field (republishRequestCount)
	lengthInBits += 32

	// Simple field (republishMessageRequestCount)
	lengthInBits += 32

	// Simple field (republishMessageCount)
	lengthInBits += 32

	// Simple field (transferRequestCount)
	lengthInBits += 32

	// Simple field (transferredToAltClientCount)
	lengthInBits += 32

	// Simple field (transferredToSameClientCount)
	lengthInBits += 32

	// Simple field (publishRequestCount)
	lengthInBits += 32

	// Simple field (dataChangeNotificationsCount)
	lengthInBits += 32

	// Simple field (eventNotificationsCount)
	lengthInBits += 32

	// Simple field (notificationsCount)
	lengthInBits += 32

	// Simple field (latePublishRequestCount)
	lengthInBits += 32

	// Simple field (currentKeepAliveCount)
	lengthInBits += 32

	// Simple field (currentLifetimeCount)
	lengthInBits += 32

	// Simple field (unacknowledgedMessageCount)
	lengthInBits += 32

	// Simple field (discardedMessageCount)
	lengthInBits += 32

	// Simple field (monitoredItemCount)
	lengthInBits += 32

	// Simple field (disabledMonitoredItemCount)
	lengthInBits += 32

	// Simple field (monitoringQueueOverflowCount)
	lengthInBits += 32

	// Simple field (nextSequenceNumber)
	lengthInBits += 32

	// Simple field (eventQueueOverFlowCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SubscriptionDiagnosticsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SubscriptionDiagnosticsDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (SubscriptionDiagnosticsDataType, error) {
	return SubscriptionDiagnosticsDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SubscriptionDiagnosticsDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SubscriptionDiagnosticsDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SubscriptionDiagnosticsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SubscriptionDiagnosticsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (sessionId)
	if pullErr := readBuffer.PullContext("sessionId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for sessionId")
	}
	_sessionId, _sessionIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _sessionIdErr != nil {
		return nil, errors.Wrap(_sessionIdErr, "Error parsing 'sessionId' field of SubscriptionDiagnosticsDataType")
	}
	sessionId := _sessionId.(NodeId)
	if closeErr := readBuffer.CloseContext("sessionId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for sessionId")
	}

	// Simple Field (subscriptionId)
	_subscriptionId, _subscriptionIdErr := readBuffer.ReadUint32("subscriptionId", 32)
	if _subscriptionIdErr != nil {
		return nil, errors.Wrap(_subscriptionIdErr, "Error parsing 'subscriptionId' field of SubscriptionDiagnosticsDataType")
	}
	subscriptionId := _subscriptionId

	// Simple Field (priority)
	_priority, _priorityErr := readBuffer.ReadUint8("priority", 8)
	if _priorityErr != nil {
		return nil, errors.Wrap(_priorityErr, "Error parsing 'priority' field of SubscriptionDiagnosticsDataType")
	}
	priority := _priority

	// Simple Field (publishingInterval)
	_publishingInterval, _publishingIntervalErr := readBuffer.ReadFloat64("publishingInterval", 64)
	if _publishingIntervalErr != nil {
		return nil, errors.Wrap(_publishingIntervalErr, "Error parsing 'publishingInterval' field of SubscriptionDiagnosticsDataType")
	}
	publishingInterval := _publishingInterval

	// Simple Field (maxKeepAliveCount)
	_maxKeepAliveCount, _maxKeepAliveCountErr := readBuffer.ReadUint32("maxKeepAliveCount", 32)
	if _maxKeepAliveCountErr != nil {
		return nil, errors.Wrap(_maxKeepAliveCountErr, "Error parsing 'maxKeepAliveCount' field of SubscriptionDiagnosticsDataType")
	}
	maxKeepAliveCount := _maxKeepAliveCount

	// Simple Field (maxLifetimeCount)
	_maxLifetimeCount, _maxLifetimeCountErr := readBuffer.ReadUint32("maxLifetimeCount", 32)
	if _maxLifetimeCountErr != nil {
		return nil, errors.Wrap(_maxLifetimeCountErr, "Error parsing 'maxLifetimeCount' field of SubscriptionDiagnosticsDataType")
	}
	maxLifetimeCount := _maxLifetimeCount

	// Simple Field (maxNotificationsPerPublish)
	_maxNotificationsPerPublish, _maxNotificationsPerPublishErr := readBuffer.ReadUint32("maxNotificationsPerPublish", 32)
	if _maxNotificationsPerPublishErr != nil {
		return nil, errors.Wrap(_maxNotificationsPerPublishErr, "Error parsing 'maxNotificationsPerPublish' field of SubscriptionDiagnosticsDataType")
	}
	maxNotificationsPerPublish := _maxNotificationsPerPublish

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of SubscriptionDiagnosticsDataType")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (publishingEnabled)
	_publishingEnabled, _publishingEnabledErr := readBuffer.ReadBit("publishingEnabled")
	if _publishingEnabledErr != nil {
		return nil, errors.Wrap(_publishingEnabledErr, "Error parsing 'publishingEnabled' field of SubscriptionDiagnosticsDataType")
	}
	publishingEnabled := _publishingEnabled

	// Simple Field (modifyCount)
	_modifyCount, _modifyCountErr := readBuffer.ReadUint32("modifyCount", 32)
	if _modifyCountErr != nil {
		return nil, errors.Wrap(_modifyCountErr, "Error parsing 'modifyCount' field of SubscriptionDiagnosticsDataType")
	}
	modifyCount := _modifyCount

	// Simple Field (enableCount)
	_enableCount, _enableCountErr := readBuffer.ReadUint32("enableCount", 32)
	if _enableCountErr != nil {
		return nil, errors.Wrap(_enableCountErr, "Error parsing 'enableCount' field of SubscriptionDiagnosticsDataType")
	}
	enableCount := _enableCount

	// Simple Field (disableCount)
	_disableCount, _disableCountErr := readBuffer.ReadUint32("disableCount", 32)
	if _disableCountErr != nil {
		return nil, errors.Wrap(_disableCountErr, "Error parsing 'disableCount' field of SubscriptionDiagnosticsDataType")
	}
	disableCount := _disableCount

	// Simple Field (republishRequestCount)
	_republishRequestCount, _republishRequestCountErr := readBuffer.ReadUint32("republishRequestCount", 32)
	if _republishRequestCountErr != nil {
		return nil, errors.Wrap(_republishRequestCountErr, "Error parsing 'republishRequestCount' field of SubscriptionDiagnosticsDataType")
	}
	republishRequestCount := _republishRequestCount

	// Simple Field (republishMessageRequestCount)
	_republishMessageRequestCount, _republishMessageRequestCountErr := readBuffer.ReadUint32("republishMessageRequestCount", 32)
	if _republishMessageRequestCountErr != nil {
		return nil, errors.Wrap(_republishMessageRequestCountErr, "Error parsing 'republishMessageRequestCount' field of SubscriptionDiagnosticsDataType")
	}
	republishMessageRequestCount := _republishMessageRequestCount

	// Simple Field (republishMessageCount)
	_republishMessageCount, _republishMessageCountErr := readBuffer.ReadUint32("republishMessageCount", 32)
	if _republishMessageCountErr != nil {
		return nil, errors.Wrap(_republishMessageCountErr, "Error parsing 'republishMessageCount' field of SubscriptionDiagnosticsDataType")
	}
	republishMessageCount := _republishMessageCount

	// Simple Field (transferRequestCount)
	_transferRequestCount, _transferRequestCountErr := readBuffer.ReadUint32("transferRequestCount", 32)
	if _transferRequestCountErr != nil {
		return nil, errors.Wrap(_transferRequestCountErr, "Error parsing 'transferRequestCount' field of SubscriptionDiagnosticsDataType")
	}
	transferRequestCount := _transferRequestCount

	// Simple Field (transferredToAltClientCount)
	_transferredToAltClientCount, _transferredToAltClientCountErr := readBuffer.ReadUint32("transferredToAltClientCount", 32)
	if _transferredToAltClientCountErr != nil {
		return nil, errors.Wrap(_transferredToAltClientCountErr, "Error parsing 'transferredToAltClientCount' field of SubscriptionDiagnosticsDataType")
	}
	transferredToAltClientCount := _transferredToAltClientCount

	// Simple Field (transferredToSameClientCount)
	_transferredToSameClientCount, _transferredToSameClientCountErr := readBuffer.ReadUint32("transferredToSameClientCount", 32)
	if _transferredToSameClientCountErr != nil {
		return nil, errors.Wrap(_transferredToSameClientCountErr, "Error parsing 'transferredToSameClientCount' field of SubscriptionDiagnosticsDataType")
	}
	transferredToSameClientCount := _transferredToSameClientCount

	// Simple Field (publishRequestCount)
	_publishRequestCount, _publishRequestCountErr := readBuffer.ReadUint32("publishRequestCount", 32)
	if _publishRequestCountErr != nil {
		return nil, errors.Wrap(_publishRequestCountErr, "Error parsing 'publishRequestCount' field of SubscriptionDiagnosticsDataType")
	}
	publishRequestCount := _publishRequestCount

	// Simple Field (dataChangeNotificationsCount)
	_dataChangeNotificationsCount, _dataChangeNotificationsCountErr := readBuffer.ReadUint32("dataChangeNotificationsCount", 32)
	if _dataChangeNotificationsCountErr != nil {
		return nil, errors.Wrap(_dataChangeNotificationsCountErr, "Error parsing 'dataChangeNotificationsCount' field of SubscriptionDiagnosticsDataType")
	}
	dataChangeNotificationsCount := _dataChangeNotificationsCount

	// Simple Field (eventNotificationsCount)
	_eventNotificationsCount, _eventNotificationsCountErr := readBuffer.ReadUint32("eventNotificationsCount", 32)
	if _eventNotificationsCountErr != nil {
		return nil, errors.Wrap(_eventNotificationsCountErr, "Error parsing 'eventNotificationsCount' field of SubscriptionDiagnosticsDataType")
	}
	eventNotificationsCount := _eventNotificationsCount

	// Simple Field (notificationsCount)
	_notificationsCount, _notificationsCountErr := readBuffer.ReadUint32("notificationsCount", 32)
	if _notificationsCountErr != nil {
		return nil, errors.Wrap(_notificationsCountErr, "Error parsing 'notificationsCount' field of SubscriptionDiagnosticsDataType")
	}
	notificationsCount := _notificationsCount

	// Simple Field (latePublishRequestCount)
	_latePublishRequestCount, _latePublishRequestCountErr := readBuffer.ReadUint32("latePublishRequestCount", 32)
	if _latePublishRequestCountErr != nil {
		return nil, errors.Wrap(_latePublishRequestCountErr, "Error parsing 'latePublishRequestCount' field of SubscriptionDiagnosticsDataType")
	}
	latePublishRequestCount := _latePublishRequestCount

	// Simple Field (currentKeepAliveCount)
	_currentKeepAliveCount, _currentKeepAliveCountErr := readBuffer.ReadUint32("currentKeepAliveCount", 32)
	if _currentKeepAliveCountErr != nil {
		return nil, errors.Wrap(_currentKeepAliveCountErr, "Error parsing 'currentKeepAliveCount' field of SubscriptionDiagnosticsDataType")
	}
	currentKeepAliveCount := _currentKeepAliveCount

	// Simple Field (currentLifetimeCount)
	_currentLifetimeCount, _currentLifetimeCountErr := readBuffer.ReadUint32("currentLifetimeCount", 32)
	if _currentLifetimeCountErr != nil {
		return nil, errors.Wrap(_currentLifetimeCountErr, "Error parsing 'currentLifetimeCount' field of SubscriptionDiagnosticsDataType")
	}
	currentLifetimeCount := _currentLifetimeCount

	// Simple Field (unacknowledgedMessageCount)
	_unacknowledgedMessageCount, _unacknowledgedMessageCountErr := readBuffer.ReadUint32("unacknowledgedMessageCount", 32)
	if _unacknowledgedMessageCountErr != nil {
		return nil, errors.Wrap(_unacknowledgedMessageCountErr, "Error parsing 'unacknowledgedMessageCount' field of SubscriptionDiagnosticsDataType")
	}
	unacknowledgedMessageCount := _unacknowledgedMessageCount

	// Simple Field (discardedMessageCount)
	_discardedMessageCount, _discardedMessageCountErr := readBuffer.ReadUint32("discardedMessageCount", 32)
	if _discardedMessageCountErr != nil {
		return nil, errors.Wrap(_discardedMessageCountErr, "Error parsing 'discardedMessageCount' field of SubscriptionDiagnosticsDataType")
	}
	discardedMessageCount := _discardedMessageCount

	// Simple Field (monitoredItemCount)
	_monitoredItemCount, _monitoredItemCountErr := readBuffer.ReadUint32("monitoredItemCount", 32)
	if _monitoredItemCountErr != nil {
		return nil, errors.Wrap(_monitoredItemCountErr, "Error parsing 'monitoredItemCount' field of SubscriptionDiagnosticsDataType")
	}
	monitoredItemCount := _monitoredItemCount

	// Simple Field (disabledMonitoredItemCount)
	_disabledMonitoredItemCount, _disabledMonitoredItemCountErr := readBuffer.ReadUint32("disabledMonitoredItemCount", 32)
	if _disabledMonitoredItemCountErr != nil {
		return nil, errors.Wrap(_disabledMonitoredItemCountErr, "Error parsing 'disabledMonitoredItemCount' field of SubscriptionDiagnosticsDataType")
	}
	disabledMonitoredItemCount := _disabledMonitoredItemCount

	// Simple Field (monitoringQueueOverflowCount)
	_monitoringQueueOverflowCount, _monitoringQueueOverflowCountErr := readBuffer.ReadUint32("monitoringQueueOverflowCount", 32)
	if _monitoringQueueOverflowCountErr != nil {
		return nil, errors.Wrap(_monitoringQueueOverflowCountErr, "Error parsing 'monitoringQueueOverflowCount' field of SubscriptionDiagnosticsDataType")
	}
	monitoringQueueOverflowCount := _monitoringQueueOverflowCount

	// Simple Field (nextSequenceNumber)
	_nextSequenceNumber, _nextSequenceNumberErr := readBuffer.ReadUint32("nextSequenceNumber", 32)
	if _nextSequenceNumberErr != nil {
		return nil, errors.Wrap(_nextSequenceNumberErr, "Error parsing 'nextSequenceNumber' field of SubscriptionDiagnosticsDataType")
	}
	nextSequenceNumber := _nextSequenceNumber

	// Simple Field (eventQueueOverFlowCount)
	_eventQueueOverFlowCount, _eventQueueOverFlowCountErr := readBuffer.ReadUint32("eventQueueOverFlowCount", 32)
	if _eventQueueOverFlowCountErr != nil {
		return nil, errors.Wrap(_eventQueueOverFlowCountErr, "Error parsing 'eventQueueOverFlowCount' field of SubscriptionDiagnosticsDataType")
	}
	eventQueueOverFlowCount := _eventQueueOverFlowCount

	if closeErr := readBuffer.CloseContext("SubscriptionDiagnosticsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SubscriptionDiagnosticsDataType")
	}

	// Create a partially initialized instance
	_child := &_SubscriptionDiagnosticsDataType{
		_ExtensionObjectDefinition:   &_ExtensionObjectDefinition{},
		SessionId:                    sessionId,
		SubscriptionId:               subscriptionId,
		Priority:                     priority,
		PublishingInterval:           publishingInterval,
		MaxKeepAliveCount:            maxKeepAliveCount,
		MaxLifetimeCount:             maxLifetimeCount,
		MaxNotificationsPerPublish:   maxNotificationsPerPublish,
		PublishingEnabled:            publishingEnabled,
		ModifyCount:                  modifyCount,
		EnableCount:                  enableCount,
		DisableCount:                 disableCount,
		RepublishRequestCount:        republishRequestCount,
		RepublishMessageRequestCount: republishMessageRequestCount,
		RepublishMessageCount:        republishMessageCount,
		TransferRequestCount:         transferRequestCount,
		TransferredToAltClientCount:  transferredToAltClientCount,
		TransferredToSameClientCount: transferredToSameClientCount,
		PublishRequestCount:          publishRequestCount,
		DataChangeNotificationsCount: dataChangeNotificationsCount,
		EventNotificationsCount:      eventNotificationsCount,
		NotificationsCount:           notificationsCount,
		LatePublishRequestCount:      latePublishRequestCount,
		CurrentKeepAliveCount:        currentKeepAliveCount,
		CurrentLifetimeCount:         currentLifetimeCount,
		UnacknowledgedMessageCount:   unacknowledgedMessageCount,
		DiscardedMessageCount:        discardedMessageCount,
		MonitoredItemCount:           monitoredItemCount,
		DisabledMonitoredItemCount:   disabledMonitoredItemCount,
		MonitoringQueueOverflowCount: monitoringQueueOverflowCount,
		NextSequenceNumber:           nextSequenceNumber,
		EventQueueOverFlowCount:      eventQueueOverFlowCount,
		reservedField0:               reservedField0,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SubscriptionDiagnosticsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SubscriptionDiagnosticsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SubscriptionDiagnosticsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SubscriptionDiagnosticsDataType")
		}

		// Simple Field (sessionId)
		if pushErr := writeBuffer.PushContext("sessionId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for sessionId")
		}
		_sessionIdErr := writeBuffer.WriteSerializable(ctx, m.GetSessionId())
		if popErr := writeBuffer.PopContext("sessionId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for sessionId")
		}
		if _sessionIdErr != nil {
			return errors.Wrap(_sessionIdErr, "Error serializing 'sessionId' field")
		}

		// Simple Field (subscriptionId)
		subscriptionId := uint32(m.GetSubscriptionId())
		_subscriptionIdErr := writeBuffer.WriteUint32("subscriptionId", 32, (subscriptionId))
		if _subscriptionIdErr != nil {
			return errors.Wrap(_subscriptionIdErr, "Error serializing 'subscriptionId' field")
		}

		// Simple Field (priority)
		priority := uint8(m.GetPriority())
		_priorityErr := writeBuffer.WriteUint8("priority", 8, (priority))
		if _priorityErr != nil {
			return errors.Wrap(_priorityErr, "Error serializing 'priority' field")
		}

		// Simple Field (publishingInterval)
		publishingInterval := float64(m.GetPublishingInterval())
		_publishingIntervalErr := writeBuffer.WriteFloat64("publishingInterval", 64, (publishingInterval))
		if _publishingIntervalErr != nil {
			return errors.Wrap(_publishingIntervalErr, "Error serializing 'publishingInterval' field")
		}

		// Simple Field (maxKeepAliveCount)
		maxKeepAliveCount := uint32(m.GetMaxKeepAliveCount())
		_maxKeepAliveCountErr := writeBuffer.WriteUint32("maxKeepAliveCount", 32, (maxKeepAliveCount))
		if _maxKeepAliveCountErr != nil {
			return errors.Wrap(_maxKeepAliveCountErr, "Error serializing 'maxKeepAliveCount' field")
		}

		// Simple Field (maxLifetimeCount)
		maxLifetimeCount := uint32(m.GetMaxLifetimeCount())
		_maxLifetimeCountErr := writeBuffer.WriteUint32("maxLifetimeCount", 32, (maxLifetimeCount))
		if _maxLifetimeCountErr != nil {
			return errors.Wrap(_maxLifetimeCountErr, "Error serializing 'maxLifetimeCount' field")
		}

		// Simple Field (maxNotificationsPerPublish)
		maxNotificationsPerPublish := uint32(m.GetMaxNotificationsPerPublish())
		_maxNotificationsPerPublishErr := writeBuffer.WriteUint32("maxNotificationsPerPublish", 32, (maxNotificationsPerPublish))
		if _maxNotificationsPerPublishErr != nil {
			return errors.Wrap(_maxNotificationsPerPublishErr, "Error serializing 'maxNotificationsPerPublish' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 7, reserved)
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (publishingEnabled)
		publishingEnabled := bool(m.GetPublishingEnabled())
		_publishingEnabledErr := writeBuffer.WriteBit("publishingEnabled", (publishingEnabled))
		if _publishingEnabledErr != nil {
			return errors.Wrap(_publishingEnabledErr, "Error serializing 'publishingEnabled' field")
		}

		// Simple Field (modifyCount)
		modifyCount := uint32(m.GetModifyCount())
		_modifyCountErr := writeBuffer.WriteUint32("modifyCount", 32, (modifyCount))
		if _modifyCountErr != nil {
			return errors.Wrap(_modifyCountErr, "Error serializing 'modifyCount' field")
		}

		// Simple Field (enableCount)
		enableCount := uint32(m.GetEnableCount())
		_enableCountErr := writeBuffer.WriteUint32("enableCount", 32, (enableCount))
		if _enableCountErr != nil {
			return errors.Wrap(_enableCountErr, "Error serializing 'enableCount' field")
		}

		// Simple Field (disableCount)
		disableCount := uint32(m.GetDisableCount())
		_disableCountErr := writeBuffer.WriteUint32("disableCount", 32, (disableCount))
		if _disableCountErr != nil {
			return errors.Wrap(_disableCountErr, "Error serializing 'disableCount' field")
		}

		// Simple Field (republishRequestCount)
		republishRequestCount := uint32(m.GetRepublishRequestCount())
		_republishRequestCountErr := writeBuffer.WriteUint32("republishRequestCount", 32, (republishRequestCount))
		if _republishRequestCountErr != nil {
			return errors.Wrap(_republishRequestCountErr, "Error serializing 'republishRequestCount' field")
		}

		// Simple Field (republishMessageRequestCount)
		republishMessageRequestCount := uint32(m.GetRepublishMessageRequestCount())
		_republishMessageRequestCountErr := writeBuffer.WriteUint32("republishMessageRequestCount", 32, (republishMessageRequestCount))
		if _republishMessageRequestCountErr != nil {
			return errors.Wrap(_republishMessageRequestCountErr, "Error serializing 'republishMessageRequestCount' field")
		}

		// Simple Field (republishMessageCount)
		republishMessageCount := uint32(m.GetRepublishMessageCount())
		_republishMessageCountErr := writeBuffer.WriteUint32("republishMessageCount", 32, (republishMessageCount))
		if _republishMessageCountErr != nil {
			return errors.Wrap(_republishMessageCountErr, "Error serializing 'republishMessageCount' field")
		}

		// Simple Field (transferRequestCount)
		transferRequestCount := uint32(m.GetTransferRequestCount())
		_transferRequestCountErr := writeBuffer.WriteUint32("transferRequestCount", 32, (transferRequestCount))
		if _transferRequestCountErr != nil {
			return errors.Wrap(_transferRequestCountErr, "Error serializing 'transferRequestCount' field")
		}

		// Simple Field (transferredToAltClientCount)
		transferredToAltClientCount := uint32(m.GetTransferredToAltClientCount())
		_transferredToAltClientCountErr := writeBuffer.WriteUint32("transferredToAltClientCount", 32, (transferredToAltClientCount))
		if _transferredToAltClientCountErr != nil {
			return errors.Wrap(_transferredToAltClientCountErr, "Error serializing 'transferredToAltClientCount' field")
		}

		// Simple Field (transferredToSameClientCount)
		transferredToSameClientCount := uint32(m.GetTransferredToSameClientCount())
		_transferredToSameClientCountErr := writeBuffer.WriteUint32("transferredToSameClientCount", 32, (transferredToSameClientCount))
		if _transferredToSameClientCountErr != nil {
			return errors.Wrap(_transferredToSameClientCountErr, "Error serializing 'transferredToSameClientCount' field")
		}

		// Simple Field (publishRequestCount)
		publishRequestCount := uint32(m.GetPublishRequestCount())
		_publishRequestCountErr := writeBuffer.WriteUint32("publishRequestCount", 32, (publishRequestCount))
		if _publishRequestCountErr != nil {
			return errors.Wrap(_publishRequestCountErr, "Error serializing 'publishRequestCount' field")
		}

		// Simple Field (dataChangeNotificationsCount)
		dataChangeNotificationsCount := uint32(m.GetDataChangeNotificationsCount())
		_dataChangeNotificationsCountErr := writeBuffer.WriteUint32("dataChangeNotificationsCount", 32, (dataChangeNotificationsCount))
		if _dataChangeNotificationsCountErr != nil {
			return errors.Wrap(_dataChangeNotificationsCountErr, "Error serializing 'dataChangeNotificationsCount' field")
		}

		// Simple Field (eventNotificationsCount)
		eventNotificationsCount := uint32(m.GetEventNotificationsCount())
		_eventNotificationsCountErr := writeBuffer.WriteUint32("eventNotificationsCount", 32, (eventNotificationsCount))
		if _eventNotificationsCountErr != nil {
			return errors.Wrap(_eventNotificationsCountErr, "Error serializing 'eventNotificationsCount' field")
		}

		// Simple Field (notificationsCount)
		notificationsCount := uint32(m.GetNotificationsCount())
		_notificationsCountErr := writeBuffer.WriteUint32("notificationsCount", 32, (notificationsCount))
		if _notificationsCountErr != nil {
			return errors.Wrap(_notificationsCountErr, "Error serializing 'notificationsCount' field")
		}

		// Simple Field (latePublishRequestCount)
		latePublishRequestCount := uint32(m.GetLatePublishRequestCount())
		_latePublishRequestCountErr := writeBuffer.WriteUint32("latePublishRequestCount", 32, (latePublishRequestCount))
		if _latePublishRequestCountErr != nil {
			return errors.Wrap(_latePublishRequestCountErr, "Error serializing 'latePublishRequestCount' field")
		}

		// Simple Field (currentKeepAliveCount)
		currentKeepAliveCount := uint32(m.GetCurrentKeepAliveCount())
		_currentKeepAliveCountErr := writeBuffer.WriteUint32("currentKeepAliveCount", 32, (currentKeepAliveCount))
		if _currentKeepAliveCountErr != nil {
			return errors.Wrap(_currentKeepAliveCountErr, "Error serializing 'currentKeepAliveCount' field")
		}

		// Simple Field (currentLifetimeCount)
		currentLifetimeCount := uint32(m.GetCurrentLifetimeCount())
		_currentLifetimeCountErr := writeBuffer.WriteUint32("currentLifetimeCount", 32, (currentLifetimeCount))
		if _currentLifetimeCountErr != nil {
			return errors.Wrap(_currentLifetimeCountErr, "Error serializing 'currentLifetimeCount' field")
		}

		// Simple Field (unacknowledgedMessageCount)
		unacknowledgedMessageCount := uint32(m.GetUnacknowledgedMessageCount())
		_unacknowledgedMessageCountErr := writeBuffer.WriteUint32("unacknowledgedMessageCount", 32, (unacknowledgedMessageCount))
		if _unacknowledgedMessageCountErr != nil {
			return errors.Wrap(_unacknowledgedMessageCountErr, "Error serializing 'unacknowledgedMessageCount' field")
		}

		// Simple Field (discardedMessageCount)
		discardedMessageCount := uint32(m.GetDiscardedMessageCount())
		_discardedMessageCountErr := writeBuffer.WriteUint32("discardedMessageCount", 32, (discardedMessageCount))
		if _discardedMessageCountErr != nil {
			return errors.Wrap(_discardedMessageCountErr, "Error serializing 'discardedMessageCount' field")
		}

		// Simple Field (monitoredItemCount)
		monitoredItemCount := uint32(m.GetMonitoredItemCount())
		_monitoredItemCountErr := writeBuffer.WriteUint32("monitoredItemCount", 32, (monitoredItemCount))
		if _monitoredItemCountErr != nil {
			return errors.Wrap(_monitoredItemCountErr, "Error serializing 'monitoredItemCount' field")
		}

		// Simple Field (disabledMonitoredItemCount)
		disabledMonitoredItemCount := uint32(m.GetDisabledMonitoredItemCount())
		_disabledMonitoredItemCountErr := writeBuffer.WriteUint32("disabledMonitoredItemCount", 32, (disabledMonitoredItemCount))
		if _disabledMonitoredItemCountErr != nil {
			return errors.Wrap(_disabledMonitoredItemCountErr, "Error serializing 'disabledMonitoredItemCount' field")
		}

		// Simple Field (monitoringQueueOverflowCount)
		monitoringQueueOverflowCount := uint32(m.GetMonitoringQueueOverflowCount())
		_monitoringQueueOverflowCountErr := writeBuffer.WriteUint32("monitoringQueueOverflowCount", 32, (monitoringQueueOverflowCount))
		if _monitoringQueueOverflowCountErr != nil {
			return errors.Wrap(_monitoringQueueOverflowCountErr, "Error serializing 'monitoringQueueOverflowCount' field")
		}

		// Simple Field (nextSequenceNumber)
		nextSequenceNumber := uint32(m.GetNextSequenceNumber())
		_nextSequenceNumberErr := writeBuffer.WriteUint32("nextSequenceNumber", 32, (nextSequenceNumber))
		if _nextSequenceNumberErr != nil {
			return errors.Wrap(_nextSequenceNumberErr, "Error serializing 'nextSequenceNumber' field")
		}

		// Simple Field (eventQueueOverFlowCount)
		eventQueueOverFlowCount := uint32(m.GetEventQueueOverFlowCount())
		_eventQueueOverFlowCountErr := writeBuffer.WriteUint32("eventQueueOverFlowCount", 32, (eventQueueOverFlowCount))
		if _eventQueueOverFlowCountErr != nil {
			return errors.Wrap(_eventQueueOverFlowCountErr, "Error serializing 'eventQueueOverFlowCount' field")
		}

		if popErr := writeBuffer.PopContext("SubscriptionDiagnosticsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SubscriptionDiagnosticsDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SubscriptionDiagnosticsDataType) isSubscriptionDiagnosticsDataType() bool {
	return true
}

func (m *_SubscriptionDiagnosticsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
