/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SignatureData is the corresponding interface of SignatureData
type SignatureData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetAlgorithm returns Algorithm (property field)
	GetAlgorithm() PascalString
	// GetSignature returns Signature (property field)
	GetSignature() PascalByteString
}

// SignatureDataExactly can be used when we want exactly this type and not a type which fulfills SignatureData.
// This is useful for switch cases.
type SignatureDataExactly interface {
	SignatureData
	isSignatureData() bool
}

// _SignatureData is the data-structure of this message
type _SignatureData struct {
	*_ExtensionObjectDefinition
	Algorithm PascalString
	Signature PascalByteString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SignatureData) GetIdentifier() string {
	return "458"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SignatureData) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SignatureData) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SignatureData) GetAlgorithm() PascalString {
	return m.Algorithm
}

func (m *_SignatureData) GetSignature() PascalByteString {
	return m.Signature
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSignatureData factory function for _SignatureData
func NewSignatureData(algorithm PascalString, signature PascalByteString) *_SignatureData {
	_result := &_SignatureData{
		Algorithm:                  algorithm,
		Signature:                  signature,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSignatureData(structType any) SignatureData {
	if casted, ok := structType.(SignatureData); ok {
		return casted
	}
	if casted, ok := structType.(*SignatureData); ok {
		return *casted
	}
	return nil
}

func (m *_SignatureData) GetTypeName() string {
	return "SignatureData"
}

func (m *_SignatureData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (algorithm)
	lengthInBits += m.Algorithm.GetLengthInBits(ctx)

	// Simple field (signature)
	lengthInBits += m.Signature.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SignatureData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SignatureDataParse(ctx context.Context, theBytes []byte, identifier string) (SignatureData, error) {
	return SignatureDataParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SignatureDataParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SignatureData, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SignatureData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SignatureData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (algorithm)
	if pullErr := readBuffer.PullContext("algorithm"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for algorithm")
	}
	_algorithm, _algorithmErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _algorithmErr != nil {
		return nil, errors.Wrap(_algorithmErr, "Error parsing 'algorithm' field of SignatureData")
	}
	algorithm := _algorithm.(PascalString)
	if closeErr := readBuffer.CloseContext("algorithm"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for algorithm")
	}

	// Simple Field (signature)
	if pullErr := readBuffer.PullContext("signature"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for signature")
	}
	_signature, _signatureErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _signatureErr != nil {
		return nil, errors.Wrap(_signatureErr, "Error parsing 'signature' field of SignatureData")
	}
	signature := _signature.(PascalByteString)
	if closeErr := readBuffer.CloseContext("signature"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for signature")
	}

	if closeErr := readBuffer.CloseContext("SignatureData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SignatureData")
	}

	// Create a partially initialized instance
	_child := &_SignatureData{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Algorithm:                  algorithm,
		Signature:                  signature,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SignatureData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SignatureData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SignatureData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SignatureData")
		}

		// Simple Field (algorithm)
		if pushErr := writeBuffer.PushContext("algorithm"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for algorithm")
		}
		_algorithmErr := writeBuffer.WriteSerializable(ctx, m.GetAlgorithm())
		if popErr := writeBuffer.PopContext("algorithm"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for algorithm")
		}
		if _algorithmErr != nil {
			return errors.Wrap(_algorithmErr, "Error serializing 'algorithm' field")
		}

		// Simple Field (signature)
		if pushErr := writeBuffer.PushContext("signature"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for signature")
		}
		_signatureErr := writeBuffer.WriteSerializable(ctx, m.GetSignature())
		if popErr := writeBuffer.PopContext("signature"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for signature")
		}
		if _signatureErr != nil {
			return errors.Wrap(_signatureErr, "Error serializing 'signature' field")
		}

		if popErr := writeBuffer.PopContext("SignatureData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SignatureData")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SignatureData) isSignatureData() bool {
	return true
}

func (m *_SignatureData) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
