/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SetMonitoringModeRequest is the corresponding interface of SetMonitoringModeRequest
type SetMonitoringModeRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetMonitoringMode returns MonitoringMode (property field)
	GetMonitoringMode() MonitoringMode
	// GetNoOfMonitoredItemIds returns NoOfMonitoredItemIds (property field)
	GetNoOfMonitoredItemIds() int32
	// GetMonitoredItemIds returns MonitoredItemIds (property field)
	GetMonitoredItemIds() []uint32
}

// SetMonitoringModeRequestExactly can be used when we want exactly this type and not a type which fulfills SetMonitoringModeRequest.
// This is useful for switch cases.
type SetMonitoringModeRequestExactly interface {
	SetMonitoringModeRequest
	isSetMonitoringModeRequest() bool
}

// _SetMonitoringModeRequest is the data-structure of this message
type _SetMonitoringModeRequest struct {
	*_ExtensionObjectDefinition
	RequestHeader        ExtensionObjectDefinition
	SubscriptionId       uint32
	MonitoringMode       MonitoringMode
	NoOfMonitoredItemIds int32
	MonitoredItemIds     []uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SetMonitoringModeRequest) GetIdentifier() string {
	return "769"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SetMonitoringModeRequest) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_SetMonitoringModeRequest) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SetMonitoringModeRequest) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_SetMonitoringModeRequest) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_SetMonitoringModeRequest) GetMonitoringMode() MonitoringMode {
	return m.MonitoringMode
}

func (m *_SetMonitoringModeRequest) GetNoOfMonitoredItemIds() int32 {
	return m.NoOfMonitoredItemIds
}

func (m *_SetMonitoringModeRequest) GetMonitoredItemIds() []uint32 {
	return m.MonitoredItemIds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewSetMonitoringModeRequest factory function for _SetMonitoringModeRequest
func NewSetMonitoringModeRequest(requestHeader ExtensionObjectDefinition, subscriptionId uint32, monitoringMode MonitoringMode, noOfMonitoredItemIds int32, monitoredItemIds []uint32) *_SetMonitoringModeRequest {
	_result := &_SetMonitoringModeRequest{
		RequestHeader:              requestHeader,
		SubscriptionId:             subscriptionId,
		MonitoringMode:             monitoringMode,
		NoOfMonitoredItemIds:       noOfMonitoredItemIds,
		MonitoredItemIds:           monitoredItemIds,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSetMonitoringModeRequest(structType any) SetMonitoringModeRequest {
	if casted, ok := structType.(SetMonitoringModeRequest); ok {
		return casted
	}
	if casted, ok := structType.(*SetMonitoringModeRequest); ok {
		return *casted
	}
	return nil
}

func (m *_SetMonitoringModeRequest) GetTypeName() string {
	return "SetMonitoringModeRequest"
}

func (m *_SetMonitoringModeRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (monitoringMode)
	lengthInBits += 32

	// Simple field (noOfMonitoredItemIds)
	lengthInBits += 32

	// Array field
	if len(m.MonitoredItemIds) > 0 {
		lengthInBits += 32 * uint16(len(m.MonitoredItemIds))
	}

	return lengthInBits
}

func (m *_SetMonitoringModeRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SetMonitoringModeRequestParse(ctx context.Context, theBytes []byte, identifier string) (SetMonitoringModeRequest, error) {
	return SetMonitoringModeRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func SetMonitoringModeRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (SetMonitoringModeRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SetMonitoringModeRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SetMonitoringModeRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of SetMonitoringModeRequest")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	// Simple Field (subscriptionId)
	_subscriptionId, _subscriptionIdErr := readBuffer.ReadUint32("subscriptionId", 32)
	if _subscriptionIdErr != nil {
		return nil, errors.Wrap(_subscriptionIdErr, "Error parsing 'subscriptionId' field of SetMonitoringModeRequest")
	}
	subscriptionId := _subscriptionId

	// Simple Field (monitoringMode)
	if pullErr := readBuffer.PullContext("monitoringMode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for monitoringMode")
	}
	_monitoringMode, _monitoringModeErr := MonitoringModeParseWithBuffer(ctx, readBuffer)
	if _monitoringModeErr != nil {
		return nil, errors.Wrap(_monitoringModeErr, "Error parsing 'monitoringMode' field of SetMonitoringModeRequest")
	}
	monitoringMode := _monitoringMode
	if closeErr := readBuffer.CloseContext("monitoringMode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for monitoringMode")
	}

	// Simple Field (noOfMonitoredItemIds)
	_noOfMonitoredItemIds, _noOfMonitoredItemIdsErr := readBuffer.ReadInt32("noOfMonitoredItemIds", 32)
	if _noOfMonitoredItemIdsErr != nil {
		return nil, errors.Wrap(_noOfMonitoredItemIdsErr, "Error parsing 'noOfMonitoredItemIds' field of SetMonitoringModeRequest")
	}
	noOfMonitoredItemIds := _noOfMonitoredItemIds

	// Array field (monitoredItemIds)
	if pullErr := readBuffer.PullContext("monitoredItemIds", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for monitoredItemIds")
	}
	// Count array
	monitoredItemIds := make([]uint32, utils.Max(noOfMonitoredItemIds, 0))
	// This happens when the size is set conditional to 0
	if len(monitoredItemIds) == 0 {
		monitoredItemIds = nil
	}
	{
		_numItems := uint16(utils.Max(noOfMonitoredItemIds, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := readBuffer.ReadUint32("", 32)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'monitoredItemIds' field of SetMonitoringModeRequest")
			}
			monitoredItemIds[_curItem] = _item
		}
	}
	if closeErr := readBuffer.CloseContext("monitoredItemIds", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for monitoredItemIds")
	}

	if closeErr := readBuffer.CloseContext("SetMonitoringModeRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SetMonitoringModeRequest")
	}

	// Create a partially initialized instance
	_child := &_SetMonitoringModeRequest{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RequestHeader:              requestHeader,
		SubscriptionId:             subscriptionId,
		MonitoringMode:             monitoringMode,
		NoOfMonitoredItemIds:       noOfMonitoredItemIds,
		MonitoredItemIds:           monitoredItemIds,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_SetMonitoringModeRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SetMonitoringModeRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SetMonitoringModeRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SetMonitoringModeRequest")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Simple Field (subscriptionId)
		subscriptionId := uint32(m.GetSubscriptionId())
		_subscriptionIdErr := writeBuffer.WriteUint32("subscriptionId", 32, (subscriptionId))
		if _subscriptionIdErr != nil {
			return errors.Wrap(_subscriptionIdErr, "Error serializing 'subscriptionId' field")
		}

		// Simple Field (monitoringMode)
		if pushErr := writeBuffer.PushContext("monitoringMode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for monitoringMode")
		}
		_monitoringModeErr := writeBuffer.WriteSerializable(ctx, m.GetMonitoringMode())
		if popErr := writeBuffer.PopContext("monitoringMode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for monitoringMode")
		}
		if _monitoringModeErr != nil {
			return errors.Wrap(_monitoringModeErr, "Error serializing 'monitoringMode' field")
		}

		// Simple Field (noOfMonitoredItemIds)
		noOfMonitoredItemIds := int32(m.GetNoOfMonitoredItemIds())
		_noOfMonitoredItemIdsErr := writeBuffer.WriteInt32("noOfMonitoredItemIds", 32, (noOfMonitoredItemIds))
		if _noOfMonitoredItemIdsErr != nil {
			return errors.Wrap(_noOfMonitoredItemIdsErr, "Error serializing 'noOfMonitoredItemIds' field")
		}

		// Array Field (monitoredItemIds)
		if pushErr := writeBuffer.PushContext("monitoredItemIds", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for monitoredItemIds")
		}
		for _curItem, _element := range m.GetMonitoredItemIds() {
			_ = _curItem
			_elementErr := writeBuffer.WriteUint32("", 32, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'monitoredItemIds' field")
			}
		}
		if popErr := writeBuffer.PopContext("monitoredItemIds", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for monitoredItemIds")
		}

		if popErr := writeBuffer.PopContext("SetMonitoringModeRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SetMonitoringModeRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SetMonitoringModeRequest) isSetMonitoringModeRequest() bool {
	return true
}

func (m *_SetMonitoringModeRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
