/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ServerDiagnosticsSummaryDataType is the corresponding interface of ServerDiagnosticsSummaryDataType
type ServerDiagnosticsSummaryDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetServerViewCount returns ServerViewCount (property field)
	GetServerViewCount() uint32
	// GetCurrentSessionCount returns CurrentSessionCount (property field)
	GetCurrentSessionCount() uint32
	// GetCumulatedSessionCount returns CumulatedSessionCount (property field)
	GetCumulatedSessionCount() uint32
	// GetSecurityRejectedSessionCount returns SecurityRejectedSessionCount (property field)
	GetSecurityRejectedSessionCount() uint32
	// GetRejectedSessionCount returns RejectedSessionCount (property field)
	GetRejectedSessionCount() uint32
	// GetSessionTimeoutCount returns SessionTimeoutCount (property field)
	GetSessionTimeoutCount() uint32
	// GetSessionAbortCount returns SessionAbortCount (property field)
	GetSessionAbortCount() uint32
	// GetCurrentSubscriptionCount returns CurrentSubscriptionCount (property field)
	GetCurrentSubscriptionCount() uint32
	// GetCumulatedSubscriptionCount returns CumulatedSubscriptionCount (property field)
	GetCumulatedSubscriptionCount() uint32
	// GetPublishingIntervalCount returns PublishingIntervalCount (property field)
	GetPublishingIntervalCount() uint32
	// GetSecurityRejectedRequestsCount returns SecurityRejectedRequestsCount (property field)
	GetSecurityRejectedRequestsCount() uint32
	// GetRejectedRequestsCount returns RejectedRequestsCount (property field)
	GetRejectedRequestsCount() uint32
}

// ServerDiagnosticsSummaryDataTypeExactly can be used when we want exactly this type and not a type which fulfills ServerDiagnosticsSummaryDataType.
// This is useful for switch cases.
type ServerDiagnosticsSummaryDataTypeExactly interface {
	ServerDiagnosticsSummaryDataType
	isServerDiagnosticsSummaryDataType() bool
}

// _ServerDiagnosticsSummaryDataType is the data-structure of this message
type _ServerDiagnosticsSummaryDataType struct {
	*_ExtensionObjectDefinition
	ServerViewCount               uint32
	CurrentSessionCount           uint32
	CumulatedSessionCount         uint32
	SecurityRejectedSessionCount  uint32
	RejectedSessionCount          uint32
	SessionTimeoutCount           uint32
	SessionAbortCount             uint32
	CurrentSubscriptionCount      uint32
	CumulatedSubscriptionCount    uint32
	PublishingIntervalCount       uint32
	SecurityRejectedRequestsCount uint32
	RejectedRequestsCount         uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ServerDiagnosticsSummaryDataType) GetIdentifier() string {
	return "861"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ServerDiagnosticsSummaryDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ServerDiagnosticsSummaryDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ServerDiagnosticsSummaryDataType) GetServerViewCount() uint32 {
	return m.ServerViewCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetCurrentSessionCount() uint32 {
	return m.CurrentSessionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetCumulatedSessionCount() uint32 {
	return m.CumulatedSessionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetSecurityRejectedSessionCount() uint32 {
	return m.SecurityRejectedSessionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetRejectedSessionCount() uint32 {
	return m.RejectedSessionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetSessionTimeoutCount() uint32 {
	return m.SessionTimeoutCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetSessionAbortCount() uint32 {
	return m.SessionAbortCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetCurrentSubscriptionCount() uint32 {
	return m.CurrentSubscriptionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetCumulatedSubscriptionCount() uint32 {
	return m.CumulatedSubscriptionCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetPublishingIntervalCount() uint32 {
	return m.PublishingIntervalCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetSecurityRejectedRequestsCount() uint32 {
	return m.SecurityRejectedRequestsCount
}

func (m *_ServerDiagnosticsSummaryDataType) GetRejectedRequestsCount() uint32 {
	return m.RejectedRequestsCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewServerDiagnosticsSummaryDataType factory function for _ServerDiagnosticsSummaryDataType
func NewServerDiagnosticsSummaryDataType(serverViewCount uint32, currentSessionCount uint32, cumulatedSessionCount uint32, securityRejectedSessionCount uint32, rejectedSessionCount uint32, sessionTimeoutCount uint32, sessionAbortCount uint32, currentSubscriptionCount uint32, cumulatedSubscriptionCount uint32, publishingIntervalCount uint32, securityRejectedRequestsCount uint32, rejectedRequestsCount uint32) *_ServerDiagnosticsSummaryDataType {
	_result := &_ServerDiagnosticsSummaryDataType{
		ServerViewCount:               serverViewCount,
		CurrentSessionCount:           currentSessionCount,
		CumulatedSessionCount:         cumulatedSessionCount,
		SecurityRejectedSessionCount:  securityRejectedSessionCount,
		RejectedSessionCount:          rejectedSessionCount,
		SessionTimeoutCount:           sessionTimeoutCount,
		SessionAbortCount:             sessionAbortCount,
		CurrentSubscriptionCount:      currentSubscriptionCount,
		CumulatedSubscriptionCount:    cumulatedSubscriptionCount,
		PublishingIntervalCount:       publishingIntervalCount,
		SecurityRejectedRequestsCount: securityRejectedRequestsCount,
		RejectedRequestsCount:         rejectedRequestsCount,
		_ExtensionObjectDefinition:    NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastServerDiagnosticsSummaryDataType(structType any) ServerDiagnosticsSummaryDataType {
	if casted, ok := structType.(ServerDiagnosticsSummaryDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ServerDiagnosticsSummaryDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ServerDiagnosticsSummaryDataType) GetTypeName() string {
	return "ServerDiagnosticsSummaryDataType"
}

func (m *_ServerDiagnosticsSummaryDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (serverViewCount)
	lengthInBits += 32

	// Simple field (currentSessionCount)
	lengthInBits += 32

	// Simple field (cumulatedSessionCount)
	lengthInBits += 32

	// Simple field (securityRejectedSessionCount)
	lengthInBits += 32

	// Simple field (rejectedSessionCount)
	lengthInBits += 32

	// Simple field (sessionTimeoutCount)
	lengthInBits += 32

	// Simple field (sessionAbortCount)
	lengthInBits += 32

	// Simple field (currentSubscriptionCount)
	lengthInBits += 32

	// Simple field (cumulatedSubscriptionCount)
	lengthInBits += 32

	// Simple field (publishingIntervalCount)
	lengthInBits += 32

	// Simple field (securityRejectedRequestsCount)
	lengthInBits += 32

	// Simple field (rejectedRequestsCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_ServerDiagnosticsSummaryDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ServerDiagnosticsSummaryDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (ServerDiagnosticsSummaryDataType, error) {
	return ServerDiagnosticsSummaryDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ServerDiagnosticsSummaryDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ServerDiagnosticsSummaryDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ServerDiagnosticsSummaryDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ServerDiagnosticsSummaryDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (serverViewCount)
	_serverViewCount, _serverViewCountErr := readBuffer.ReadUint32("serverViewCount", 32)
	if _serverViewCountErr != nil {
		return nil, errors.Wrap(_serverViewCountErr, "Error parsing 'serverViewCount' field of ServerDiagnosticsSummaryDataType")
	}
	serverViewCount := _serverViewCount

	// Simple Field (currentSessionCount)
	_currentSessionCount, _currentSessionCountErr := readBuffer.ReadUint32("currentSessionCount", 32)
	if _currentSessionCountErr != nil {
		return nil, errors.Wrap(_currentSessionCountErr, "Error parsing 'currentSessionCount' field of ServerDiagnosticsSummaryDataType")
	}
	currentSessionCount := _currentSessionCount

	// Simple Field (cumulatedSessionCount)
	_cumulatedSessionCount, _cumulatedSessionCountErr := readBuffer.ReadUint32("cumulatedSessionCount", 32)
	if _cumulatedSessionCountErr != nil {
		return nil, errors.Wrap(_cumulatedSessionCountErr, "Error parsing 'cumulatedSessionCount' field of ServerDiagnosticsSummaryDataType")
	}
	cumulatedSessionCount := _cumulatedSessionCount

	// Simple Field (securityRejectedSessionCount)
	_securityRejectedSessionCount, _securityRejectedSessionCountErr := readBuffer.ReadUint32("securityRejectedSessionCount", 32)
	if _securityRejectedSessionCountErr != nil {
		return nil, errors.Wrap(_securityRejectedSessionCountErr, "Error parsing 'securityRejectedSessionCount' field of ServerDiagnosticsSummaryDataType")
	}
	securityRejectedSessionCount := _securityRejectedSessionCount

	// Simple Field (rejectedSessionCount)
	_rejectedSessionCount, _rejectedSessionCountErr := readBuffer.ReadUint32("rejectedSessionCount", 32)
	if _rejectedSessionCountErr != nil {
		return nil, errors.Wrap(_rejectedSessionCountErr, "Error parsing 'rejectedSessionCount' field of ServerDiagnosticsSummaryDataType")
	}
	rejectedSessionCount := _rejectedSessionCount

	// Simple Field (sessionTimeoutCount)
	_sessionTimeoutCount, _sessionTimeoutCountErr := readBuffer.ReadUint32("sessionTimeoutCount", 32)
	if _sessionTimeoutCountErr != nil {
		return nil, errors.Wrap(_sessionTimeoutCountErr, "Error parsing 'sessionTimeoutCount' field of ServerDiagnosticsSummaryDataType")
	}
	sessionTimeoutCount := _sessionTimeoutCount

	// Simple Field (sessionAbortCount)
	_sessionAbortCount, _sessionAbortCountErr := readBuffer.ReadUint32("sessionAbortCount", 32)
	if _sessionAbortCountErr != nil {
		return nil, errors.Wrap(_sessionAbortCountErr, "Error parsing 'sessionAbortCount' field of ServerDiagnosticsSummaryDataType")
	}
	sessionAbortCount := _sessionAbortCount

	// Simple Field (currentSubscriptionCount)
	_currentSubscriptionCount, _currentSubscriptionCountErr := readBuffer.ReadUint32("currentSubscriptionCount", 32)
	if _currentSubscriptionCountErr != nil {
		return nil, errors.Wrap(_currentSubscriptionCountErr, "Error parsing 'currentSubscriptionCount' field of ServerDiagnosticsSummaryDataType")
	}
	currentSubscriptionCount := _currentSubscriptionCount

	// Simple Field (cumulatedSubscriptionCount)
	_cumulatedSubscriptionCount, _cumulatedSubscriptionCountErr := readBuffer.ReadUint32("cumulatedSubscriptionCount", 32)
	if _cumulatedSubscriptionCountErr != nil {
		return nil, errors.Wrap(_cumulatedSubscriptionCountErr, "Error parsing 'cumulatedSubscriptionCount' field of ServerDiagnosticsSummaryDataType")
	}
	cumulatedSubscriptionCount := _cumulatedSubscriptionCount

	// Simple Field (publishingIntervalCount)
	_publishingIntervalCount, _publishingIntervalCountErr := readBuffer.ReadUint32("publishingIntervalCount", 32)
	if _publishingIntervalCountErr != nil {
		return nil, errors.Wrap(_publishingIntervalCountErr, "Error parsing 'publishingIntervalCount' field of ServerDiagnosticsSummaryDataType")
	}
	publishingIntervalCount := _publishingIntervalCount

	// Simple Field (securityRejectedRequestsCount)
	_securityRejectedRequestsCount, _securityRejectedRequestsCountErr := readBuffer.ReadUint32("securityRejectedRequestsCount", 32)
	if _securityRejectedRequestsCountErr != nil {
		return nil, errors.Wrap(_securityRejectedRequestsCountErr, "Error parsing 'securityRejectedRequestsCount' field of ServerDiagnosticsSummaryDataType")
	}
	securityRejectedRequestsCount := _securityRejectedRequestsCount

	// Simple Field (rejectedRequestsCount)
	_rejectedRequestsCount, _rejectedRequestsCountErr := readBuffer.ReadUint32("rejectedRequestsCount", 32)
	if _rejectedRequestsCountErr != nil {
		return nil, errors.Wrap(_rejectedRequestsCountErr, "Error parsing 'rejectedRequestsCount' field of ServerDiagnosticsSummaryDataType")
	}
	rejectedRequestsCount := _rejectedRequestsCount

	if closeErr := readBuffer.CloseContext("ServerDiagnosticsSummaryDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ServerDiagnosticsSummaryDataType")
	}

	// Create a partially initialized instance
	_child := &_ServerDiagnosticsSummaryDataType{
		_ExtensionObjectDefinition:    &_ExtensionObjectDefinition{},
		ServerViewCount:               serverViewCount,
		CurrentSessionCount:           currentSessionCount,
		CumulatedSessionCount:         cumulatedSessionCount,
		SecurityRejectedSessionCount:  securityRejectedSessionCount,
		RejectedSessionCount:          rejectedSessionCount,
		SessionTimeoutCount:           sessionTimeoutCount,
		SessionAbortCount:             sessionAbortCount,
		CurrentSubscriptionCount:      currentSubscriptionCount,
		CumulatedSubscriptionCount:    cumulatedSubscriptionCount,
		PublishingIntervalCount:       publishingIntervalCount,
		SecurityRejectedRequestsCount: securityRejectedRequestsCount,
		RejectedRequestsCount:         rejectedRequestsCount,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ServerDiagnosticsSummaryDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ServerDiagnosticsSummaryDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ServerDiagnosticsSummaryDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ServerDiagnosticsSummaryDataType")
		}

		// Simple Field (serverViewCount)
		serverViewCount := uint32(m.GetServerViewCount())
		_serverViewCountErr := writeBuffer.WriteUint32("serverViewCount", 32, (serverViewCount))
		if _serverViewCountErr != nil {
			return errors.Wrap(_serverViewCountErr, "Error serializing 'serverViewCount' field")
		}

		// Simple Field (currentSessionCount)
		currentSessionCount := uint32(m.GetCurrentSessionCount())
		_currentSessionCountErr := writeBuffer.WriteUint32("currentSessionCount", 32, (currentSessionCount))
		if _currentSessionCountErr != nil {
			return errors.Wrap(_currentSessionCountErr, "Error serializing 'currentSessionCount' field")
		}

		// Simple Field (cumulatedSessionCount)
		cumulatedSessionCount := uint32(m.GetCumulatedSessionCount())
		_cumulatedSessionCountErr := writeBuffer.WriteUint32("cumulatedSessionCount", 32, (cumulatedSessionCount))
		if _cumulatedSessionCountErr != nil {
			return errors.Wrap(_cumulatedSessionCountErr, "Error serializing 'cumulatedSessionCount' field")
		}

		// Simple Field (securityRejectedSessionCount)
		securityRejectedSessionCount := uint32(m.GetSecurityRejectedSessionCount())
		_securityRejectedSessionCountErr := writeBuffer.WriteUint32("securityRejectedSessionCount", 32, (securityRejectedSessionCount))
		if _securityRejectedSessionCountErr != nil {
			return errors.Wrap(_securityRejectedSessionCountErr, "Error serializing 'securityRejectedSessionCount' field")
		}

		// Simple Field (rejectedSessionCount)
		rejectedSessionCount := uint32(m.GetRejectedSessionCount())
		_rejectedSessionCountErr := writeBuffer.WriteUint32("rejectedSessionCount", 32, (rejectedSessionCount))
		if _rejectedSessionCountErr != nil {
			return errors.Wrap(_rejectedSessionCountErr, "Error serializing 'rejectedSessionCount' field")
		}

		// Simple Field (sessionTimeoutCount)
		sessionTimeoutCount := uint32(m.GetSessionTimeoutCount())
		_sessionTimeoutCountErr := writeBuffer.WriteUint32("sessionTimeoutCount", 32, (sessionTimeoutCount))
		if _sessionTimeoutCountErr != nil {
			return errors.Wrap(_sessionTimeoutCountErr, "Error serializing 'sessionTimeoutCount' field")
		}

		// Simple Field (sessionAbortCount)
		sessionAbortCount := uint32(m.GetSessionAbortCount())
		_sessionAbortCountErr := writeBuffer.WriteUint32("sessionAbortCount", 32, (sessionAbortCount))
		if _sessionAbortCountErr != nil {
			return errors.Wrap(_sessionAbortCountErr, "Error serializing 'sessionAbortCount' field")
		}

		// Simple Field (currentSubscriptionCount)
		currentSubscriptionCount := uint32(m.GetCurrentSubscriptionCount())
		_currentSubscriptionCountErr := writeBuffer.WriteUint32("currentSubscriptionCount", 32, (currentSubscriptionCount))
		if _currentSubscriptionCountErr != nil {
			return errors.Wrap(_currentSubscriptionCountErr, "Error serializing 'currentSubscriptionCount' field")
		}

		// Simple Field (cumulatedSubscriptionCount)
		cumulatedSubscriptionCount := uint32(m.GetCumulatedSubscriptionCount())
		_cumulatedSubscriptionCountErr := writeBuffer.WriteUint32("cumulatedSubscriptionCount", 32, (cumulatedSubscriptionCount))
		if _cumulatedSubscriptionCountErr != nil {
			return errors.Wrap(_cumulatedSubscriptionCountErr, "Error serializing 'cumulatedSubscriptionCount' field")
		}

		// Simple Field (publishingIntervalCount)
		publishingIntervalCount := uint32(m.GetPublishingIntervalCount())
		_publishingIntervalCountErr := writeBuffer.WriteUint32("publishingIntervalCount", 32, (publishingIntervalCount))
		if _publishingIntervalCountErr != nil {
			return errors.Wrap(_publishingIntervalCountErr, "Error serializing 'publishingIntervalCount' field")
		}

		// Simple Field (securityRejectedRequestsCount)
		securityRejectedRequestsCount := uint32(m.GetSecurityRejectedRequestsCount())
		_securityRejectedRequestsCountErr := writeBuffer.WriteUint32("securityRejectedRequestsCount", 32, (securityRejectedRequestsCount))
		if _securityRejectedRequestsCountErr != nil {
			return errors.Wrap(_securityRejectedRequestsCountErr, "Error serializing 'securityRejectedRequestsCount' field")
		}

		// Simple Field (rejectedRequestsCount)
		rejectedRequestsCount := uint32(m.GetRejectedRequestsCount())
		_rejectedRequestsCountErr := writeBuffer.WriteUint32("rejectedRequestsCount", 32, (rejectedRequestsCount))
		if _rejectedRequestsCountErr != nil {
			return errors.Wrap(_rejectedRequestsCountErr, "Error serializing 'rejectedRequestsCount' field")
		}

		if popErr := writeBuffer.PopContext("ServerDiagnosticsSummaryDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ServerDiagnosticsSummaryDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ServerDiagnosticsSummaryDataType) isServerDiagnosticsSummaryDataType() bool {
	return true
}

func (m *_ServerDiagnosticsSummaryDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
