/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// PubSubConfigurationRefMask is an enum
type PubSubConfigurationRefMask uint32

type IPubSubConfigurationRefMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskNone                   PubSubConfigurationRefMask = 0
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementAdd             PubSubConfigurationRefMask = 1
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementMatch           PubSubConfigurationRefMask = 2
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementModify          PubSubConfigurationRefMask = 4
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementRemove          PubSubConfigurationRefMask = 8
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriter        PubSubConfigurationRefMask = 16
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReader        PubSubConfigurationRefMask = 32
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriterGroup   PubSubConfigurationRefMask = 64
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReaderGroup   PubSubConfigurationRefMask = 128
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceConnection    PubSubConfigurationRefMask = 256
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePubDataset    PubSubConfigurationRefMask = 512
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSubDataset    PubSubConfigurationRefMask = 1024
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSecurityGroup PubSubConfigurationRefMask = 2048
	PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePushTarget    PubSubConfigurationRefMask = 4096
)

var PubSubConfigurationRefMaskValues []PubSubConfigurationRefMask

func init() {
	_ = errors.New
	PubSubConfigurationRefMaskValues = []PubSubConfigurationRefMask{
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskNone,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementAdd,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementMatch,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementModify,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementRemove,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriter,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReader,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriterGroup,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReaderGroup,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceConnection,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePubDataset,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSubDataset,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSecurityGroup,
		PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePushTarget,
	}
}

func PubSubConfigurationRefMaskByValue(value uint32) (enum PubSubConfigurationRefMask, ok bool) {
	switch value {
	case 0:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskNone, true
	case 1:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementAdd, true
	case 1024:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSubDataset, true
	case 128:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReaderGroup, true
	case 16:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriter, true
	case 2:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementMatch, true
	case 2048:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSecurityGroup, true
	case 256:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceConnection, true
	case 32:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReader, true
	case 4:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementModify, true
	case 4096:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePushTarget, true
	case 512:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePubDataset, true
	case 64:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriterGroup, true
	case 8:
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementRemove, true
	}
	return 0, false
}

func PubSubConfigurationRefMaskByName(value string) (enum PubSubConfigurationRefMask, ok bool) {
	switch value {
	case "pubSubConfigurationRefMaskNone":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskNone, true
	case "pubSubConfigurationRefMaskElementAdd":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementAdd, true
	case "pubSubConfigurationRefMaskReferenceSubDataset":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSubDataset, true
	case "pubSubConfigurationRefMaskReferenceReaderGroup":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReaderGroup, true
	case "pubSubConfigurationRefMaskReferenceWriter":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriter, true
	case "pubSubConfigurationRefMaskElementMatch":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementMatch, true
	case "pubSubConfigurationRefMaskReferenceSecurityGroup":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSecurityGroup, true
	case "pubSubConfigurationRefMaskReferenceConnection":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceConnection, true
	case "pubSubConfigurationRefMaskReferenceReader":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReader, true
	case "pubSubConfigurationRefMaskElementModify":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementModify, true
	case "pubSubConfigurationRefMaskReferencePushTarget":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePushTarget, true
	case "pubSubConfigurationRefMaskReferencePubDataset":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePubDataset, true
	case "pubSubConfigurationRefMaskReferenceWriterGroup":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriterGroup, true
	case "pubSubConfigurationRefMaskElementRemove":
		return PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementRemove, true
	}
	return 0, false
}

func PubSubConfigurationRefMaskKnows(value uint32) bool {
	for _, typeValue := range PubSubConfigurationRefMaskValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastPubSubConfigurationRefMask(structType any) PubSubConfigurationRefMask {
	castFunc := func(typ any) PubSubConfigurationRefMask {
		if sPubSubConfigurationRefMask, ok := typ.(PubSubConfigurationRefMask); ok {
			return sPubSubConfigurationRefMask
		}
		return 0
	}
	return castFunc(structType)
}

func (m PubSubConfigurationRefMask) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m PubSubConfigurationRefMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PubSubConfigurationRefMaskParse(ctx context.Context, theBytes []byte) (PubSubConfigurationRefMask, error) {
	return PubSubConfigurationRefMaskParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PubSubConfigurationRefMaskParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PubSubConfigurationRefMask, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("PubSubConfigurationRefMask", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading PubSubConfigurationRefMask")
	}
	if enum, ok := PubSubConfigurationRefMaskByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for PubSubConfigurationRefMask")
		return PubSubConfigurationRefMask(val), nil
	} else {
		return enum, nil
	}
}

func (e PubSubConfigurationRefMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e PubSubConfigurationRefMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("PubSubConfigurationRefMask", 32, uint32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e PubSubConfigurationRefMask) PLC4XEnumName() string {
	switch e {
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskNone:
		return "pubSubConfigurationRefMaskNone"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementAdd:
		return "pubSubConfigurationRefMaskElementAdd"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSubDataset:
		return "pubSubConfigurationRefMaskReferenceSubDataset"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReaderGroup:
		return "pubSubConfigurationRefMaskReferenceReaderGroup"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriter:
		return "pubSubConfigurationRefMaskReferenceWriter"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementMatch:
		return "pubSubConfigurationRefMaskElementMatch"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceSecurityGroup:
		return "pubSubConfigurationRefMaskReferenceSecurityGroup"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceConnection:
		return "pubSubConfigurationRefMaskReferenceConnection"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceReader:
		return "pubSubConfigurationRefMaskReferenceReader"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementModify:
		return "pubSubConfigurationRefMaskElementModify"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePushTarget:
		return "pubSubConfigurationRefMaskReferencePushTarget"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferencePubDataset:
		return "pubSubConfigurationRefMaskReferencePubDataset"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskReferenceWriterGroup:
		return "pubSubConfigurationRefMaskReferenceWriterGroup"
	case PubSubConfigurationRefMask_pubSubConfigurationRefMaskElementRemove:
		return "pubSubConfigurationRefMaskElementRemove"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e PubSubConfigurationRefMask) String() string {
	return e.PLC4XEnumName()
}
