/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OptionSet is the corresponding interface of OptionSet
type OptionSet interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetValue returns Value (property field)
	GetValue() PascalByteString
	// GetValidBits returns ValidBits (property field)
	GetValidBits() PascalByteString
}

// OptionSetExactly can be used when we want exactly this type and not a type which fulfills OptionSet.
// This is useful for switch cases.
type OptionSetExactly interface {
	OptionSet
	isOptionSet() bool
}

// _OptionSet is the data-structure of this message
type _OptionSet struct {
	*_ExtensionObjectDefinition
	Value     PascalByteString
	ValidBits PascalByteString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OptionSet) GetIdentifier() string {
	return "12757"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OptionSet) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_OptionSet) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OptionSet) GetValue() PascalByteString {
	return m.Value
}

func (m *_OptionSet) GetValidBits() PascalByteString {
	return m.ValidBits
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOptionSet factory function for _OptionSet
func NewOptionSet(value PascalByteString, validBits PascalByteString) *_OptionSet {
	_result := &_OptionSet{
		Value:                      value,
		ValidBits:                  validBits,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOptionSet(structType any) OptionSet {
	if casted, ok := structType.(OptionSet); ok {
		return casted
	}
	if casted, ok := structType.(*OptionSet); ok {
		return *casted
	}
	return nil
}

func (m *_OptionSet) GetTypeName() string {
	return "OptionSet"
}

func (m *_OptionSet) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	// Simple field (validBits)
	lengthInBits += m.ValidBits.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OptionSet) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OptionSetParse(ctx context.Context, theBytes []byte, identifier string) (OptionSet, error) {
	return OptionSetParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func OptionSetParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (OptionSet, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OptionSet"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OptionSet")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (value)
	if pullErr := readBuffer.PullContext("value"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for value")
	}
	_value, _valueErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _valueErr != nil {
		return nil, errors.Wrap(_valueErr, "Error parsing 'value' field of OptionSet")
	}
	value := _value.(PascalByteString)
	if closeErr := readBuffer.CloseContext("value"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for value")
	}

	// Simple Field (validBits)
	if pullErr := readBuffer.PullContext("validBits"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for validBits")
	}
	_validBits, _validBitsErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _validBitsErr != nil {
		return nil, errors.Wrap(_validBitsErr, "Error parsing 'validBits' field of OptionSet")
	}
	validBits := _validBits.(PascalByteString)
	if closeErr := readBuffer.CloseContext("validBits"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for validBits")
	}

	if closeErr := readBuffer.CloseContext("OptionSet"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OptionSet")
	}

	// Create a partially initialized instance
	_child := &_OptionSet{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Value:                      value,
		ValidBits:                  validBits,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_OptionSet) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OptionSet) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OptionSet"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OptionSet")
		}

		// Simple Field (value)
		if pushErr := writeBuffer.PushContext("value"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for value")
		}
		_valueErr := writeBuffer.WriteSerializable(ctx, m.GetValue())
		if popErr := writeBuffer.PopContext("value"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for value")
		}
		if _valueErr != nil {
			return errors.Wrap(_valueErr, "Error serializing 'value' field")
		}

		// Simple Field (validBits)
		if pushErr := writeBuffer.PushContext("validBits"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for validBits")
		}
		_validBitsErr := writeBuffer.WriteSerializable(ctx, m.GetValidBits())
		if popErr := writeBuffer.PopContext("validBits"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for validBits")
		}
		if _validBitsErr != nil {
			return errors.Wrap(_validBitsErr, "Error serializing 'validBits' field")
		}

		if popErr := writeBuffer.PopContext("OptionSet"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OptionSet")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OptionSet) isOptionSet() bool {
	return true
}

func (m *_OptionSet) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
