/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpenSecureChannelRequest is the corresponding interface of OpenSecureChannelRequest
type OpenSecureChannelRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetClientProtocolVersion returns ClientProtocolVersion (property field)
	GetClientProtocolVersion() uint32
	// GetRequestType returns RequestType (property field)
	GetRequestType() SecurityTokenRequestType
	// GetSecurityMode returns SecurityMode (property field)
	GetSecurityMode() MessageSecurityMode
	// GetClientNonce returns ClientNonce (property field)
	GetClientNonce() PascalByteString
	// GetRequestedLifetime returns RequestedLifetime (property field)
	GetRequestedLifetime() uint32
}

// OpenSecureChannelRequestExactly can be used when we want exactly this type and not a type which fulfills OpenSecureChannelRequest.
// This is useful for switch cases.
type OpenSecureChannelRequestExactly interface {
	OpenSecureChannelRequest
	isOpenSecureChannelRequest() bool
}

// _OpenSecureChannelRequest is the data-structure of this message
type _OpenSecureChannelRequest struct {
	*_ExtensionObjectDefinition
	RequestHeader         ExtensionObjectDefinition
	ClientProtocolVersion uint32
	RequestType           SecurityTokenRequestType
	SecurityMode          MessageSecurityMode
	ClientNonce           PascalByteString
	RequestedLifetime     uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpenSecureChannelRequest) GetIdentifier() string {
	return "446"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpenSecureChannelRequest) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_OpenSecureChannelRequest) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpenSecureChannelRequest) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_OpenSecureChannelRequest) GetClientProtocolVersion() uint32 {
	return m.ClientProtocolVersion
}

func (m *_OpenSecureChannelRequest) GetRequestType() SecurityTokenRequestType {
	return m.RequestType
}

func (m *_OpenSecureChannelRequest) GetSecurityMode() MessageSecurityMode {
	return m.SecurityMode
}

func (m *_OpenSecureChannelRequest) GetClientNonce() PascalByteString {
	return m.ClientNonce
}

func (m *_OpenSecureChannelRequest) GetRequestedLifetime() uint32 {
	return m.RequestedLifetime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewOpenSecureChannelRequest factory function for _OpenSecureChannelRequest
func NewOpenSecureChannelRequest(requestHeader ExtensionObjectDefinition, clientProtocolVersion uint32, requestType SecurityTokenRequestType, securityMode MessageSecurityMode, clientNonce PascalByteString, requestedLifetime uint32) *_OpenSecureChannelRequest {
	_result := &_OpenSecureChannelRequest{
		RequestHeader:              requestHeader,
		ClientProtocolVersion:      clientProtocolVersion,
		RequestType:                requestType,
		SecurityMode:               securityMode,
		ClientNonce:                clientNonce,
		RequestedLifetime:          requestedLifetime,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastOpenSecureChannelRequest(structType any) OpenSecureChannelRequest {
	if casted, ok := structType.(OpenSecureChannelRequest); ok {
		return casted
	}
	if casted, ok := structType.(*OpenSecureChannelRequest); ok {
		return *casted
	}
	return nil
}

func (m *_OpenSecureChannelRequest) GetTypeName() string {
	return "OpenSecureChannelRequest"
}

func (m *_OpenSecureChannelRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Simple field (clientProtocolVersion)
	lengthInBits += 32

	// Simple field (requestType)
	lengthInBits += 32

	// Simple field (securityMode)
	lengthInBits += 32

	// Simple field (clientNonce)
	lengthInBits += m.ClientNonce.GetLengthInBits(ctx)

	// Simple field (requestedLifetime)
	lengthInBits += 32

	return lengthInBits
}

func (m *_OpenSecureChannelRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpenSecureChannelRequestParse(ctx context.Context, theBytes []byte, identifier string) (OpenSecureChannelRequest, error) {
	return OpenSecureChannelRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func OpenSecureChannelRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (OpenSecureChannelRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("OpenSecureChannelRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpenSecureChannelRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of OpenSecureChannelRequest")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	// Simple Field (clientProtocolVersion)
	_clientProtocolVersion, _clientProtocolVersionErr := readBuffer.ReadUint32("clientProtocolVersion", 32)
	if _clientProtocolVersionErr != nil {
		return nil, errors.Wrap(_clientProtocolVersionErr, "Error parsing 'clientProtocolVersion' field of OpenSecureChannelRequest")
	}
	clientProtocolVersion := _clientProtocolVersion

	// Simple Field (requestType)
	if pullErr := readBuffer.PullContext("requestType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestType")
	}
	_requestType, _requestTypeErr := SecurityTokenRequestTypeParseWithBuffer(ctx, readBuffer)
	if _requestTypeErr != nil {
		return nil, errors.Wrap(_requestTypeErr, "Error parsing 'requestType' field of OpenSecureChannelRequest")
	}
	requestType := _requestType
	if closeErr := readBuffer.CloseContext("requestType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestType")
	}

	// Simple Field (securityMode)
	if pullErr := readBuffer.PullContext("securityMode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityMode")
	}
	_securityMode, _securityModeErr := MessageSecurityModeParseWithBuffer(ctx, readBuffer)
	if _securityModeErr != nil {
		return nil, errors.Wrap(_securityModeErr, "Error parsing 'securityMode' field of OpenSecureChannelRequest")
	}
	securityMode := _securityMode
	if closeErr := readBuffer.CloseContext("securityMode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityMode")
	}

	// Simple Field (clientNonce)
	if pullErr := readBuffer.PullContext("clientNonce"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for clientNonce")
	}
	_clientNonce, _clientNonceErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _clientNonceErr != nil {
		return nil, errors.Wrap(_clientNonceErr, "Error parsing 'clientNonce' field of OpenSecureChannelRequest")
	}
	clientNonce := _clientNonce.(PascalByteString)
	if closeErr := readBuffer.CloseContext("clientNonce"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for clientNonce")
	}

	// Simple Field (requestedLifetime)
	_requestedLifetime, _requestedLifetimeErr := readBuffer.ReadUint32("requestedLifetime", 32)
	if _requestedLifetimeErr != nil {
		return nil, errors.Wrap(_requestedLifetimeErr, "Error parsing 'requestedLifetime' field of OpenSecureChannelRequest")
	}
	requestedLifetime := _requestedLifetime

	if closeErr := readBuffer.CloseContext("OpenSecureChannelRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpenSecureChannelRequest")
	}

	// Create a partially initialized instance
	_child := &_OpenSecureChannelRequest{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RequestHeader:              requestHeader,
		ClientProtocolVersion:      clientProtocolVersion,
		RequestType:                requestType,
		SecurityMode:               securityMode,
		ClientNonce:                clientNonce,
		RequestedLifetime:          requestedLifetime,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_OpenSecureChannelRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpenSecureChannelRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpenSecureChannelRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpenSecureChannelRequest")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Simple Field (clientProtocolVersion)
		clientProtocolVersion := uint32(m.GetClientProtocolVersion())
		_clientProtocolVersionErr := writeBuffer.WriteUint32("clientProtocolVersion", 32, (clientProtocolVersion))
		if _clientProtocolVersionErr != nil {
			return errors.Wrap(_clientProtocolVersionErr, "Error serializing 'clientProtocolVersion' field")
		}

		// Simple Field (requestType)
		if pushErr := writeBuffer.PushContext("requestType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestType")
		}
		_requestTypeErr := writeBuffer.WriteSerializable(ctx, m.GetRequestType())
		if popErr := writeBuffer.PopContext("requestType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestType")
		}
		if _requestTypeErr != nil {
			return errors.Wrap(_requestTypeErr, "Error serializing 'requestType' field")
		}

		// Simple Field (securityMode)
		if pushErr := writeBuffer.PushContext("securityMode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityMode")
		}
		_securityModeErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityMode())
		if popErr := writeBuffer.PopContext("securityMode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityMode")
		}
		if _securityModeErr != nil {
			return errors.Wrap(_securityModeErr, "Error serializing 'securityMode' field")
		}

		// Simple Field (clientNonce)
		if pushErr := writeBuffer.PushContext("clientNonce"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for clientNonce")
		}
		_clientNonceErr := writeBuffer.WriteSerializable(ctx, m.GetClientNonce())
		if popErr := writeBuffer.PopContext("clientNonce"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for clientNonce")
		}
		if _clientNonceErr != nil {
			return errors.Wrap(_clientNonceErr, "Error serializing 'clientNonce' field")
		}

		// Simple Field (requestedLifetime)
		requestedLifetime := uint32(m.GetRequestedLifetime())
		_requestedLifetimeErr := writeBuffer.WriteUint32("requestedLifetime", 32, (requestedLifetime))
		if _requestedLifetimeErr != nil {
			return errors.Wrap(_requestedLifetimeErr, "Error serializing 'requestedLifetime' field")
		}

		if popErr := writeBuffer.PopContext("OpenSecureChannelRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpenSecureChannelRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OpenSecureChannelRequest) isOpenSecureChannelRequest() bool {
	return true
}

func (m *_OpenSecureChannelRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
