/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTrust is an enum
type OpcuaNodeIdServicesVariableTrust int32

type IOpcuaNodeIdServicesVariableTrust interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTrust_TrustListType_Size                                                               OpcuaNodeIdServicesVariableTrust = 12523
	OpcuaNodeIdServicesVariableTrust_TrustListType_OpenCount                                                          OpcuaNodeIdServicesVariableTrust = 12526
	OpcuaNodeIdServicesVariableTrust_TrustListType_Open_InputArguments                                                OpcuaNodeIdServicesVariableTrust = 12528
	OpcuaNodeIdServicesVariableTrust_TrustListType_Open_OutputArguments                                               OpcuaNodeIdServicesVariableTrust = 12529
	OpcuaNodeIdServicesVariableTrust_TrustListType_Close_InputArguments                                               OpcuaNodeIdServicesVariableTrust = 12531
	OpcuaNodeIdServicesVariableTrust_TrustListType_Read_InputArguments                                                OpcuaNodeIdServicesVariableTrust = 12533
	OpcuaNodeIdServicesVariableTrust_TrustListType_Read_OutputArguments                                               OpcuaNodeIdServicesVariableTrust = 12534
	OpcuaNodeIdServicesVariableTrust_TrustListType_Write_InputArguments                                               OpcuaNodeIdServicesVariableTrust = 12536
	OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_InputArguments                                         OpcuaNodeIdServicesVariableTrust = 12538
	OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_OutputArguments                                        OpcuaNodeIdServicesVariableTrust = 12539
	OpcuaNodeIdServicesVariableTrust_TrustListType_SetPosition_InputArguments                                         OpcuaNodeIdServicesVariableTrust = 12541
	OpcuaNodeIdServicesVariableTrust_TrustListType_LastUpdateTime                                                     OpcuaNodeIdServicesVariableTrust = 12542
	OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_InputArguments                                       OpcuaNodeIdServicesVariableTrust = 12544
	OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_OutputArguments                                      OpcuaNodeIdServicesVariableTrust = 12545
	OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_OutputArguments                                     OpcuaNodeIdServicesVariableTrust = 12547
	OpcuaNodeIdServicesVariableTrust_TrustListType_AddCertificate_InputArguments                                      OpcuaNodeIdServicesVariableTrust = 12549
	OpcuaNodeIdServicesVariableTrust_TrustListType_RemoveCertificate_InputArguments                                   OpcuaNodeIdServicesVariableTrust = 12551
	OpcuaNodeIdServicesVariableTrust_TrustListMasks_EnumValues                                                        OpcuaNodeIdServicesVariableTrust = 12553
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventId                                           OpcuaNodeIdServicesVariableTrust = 12562
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventType                                         OpcuaNodeIdServicesVariableTrust = 12563
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceNode                                        OpcuaNodeIdServicesVariableTrust = 12564
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceName                                        OpcuaNodeIdServicesVariableTrust = 12565
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Time                                              OpcuaNodeIdServicesVariableTrust = 12566
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ReceiveTime                                       OpcuaNodeIdServicesVariableTrust = 12567
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_LocalTime                                         OpcuaNodeIdServicesVariableTrust = 12568
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Message                                           OpcuaNodeIdServicesVariableTrust = 12569
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Severity                                          OpcuaNodeIdServicesVariableTrust = 12570
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ActionTimeStamp                                   OpcuaNodeIdServicesVariableTrust = 12571
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Status                                            OpcuaNodeIdServicesVariableTrust = 12572
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ServerId                                          OpcuaNodeIdServicesVariableTrust = 12573
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientAuditEntryId                                OpcuaNodeIdServicesVariableTrust = 12574
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientUserId                                      OpcuaNodeIdServicesVariableTrust = 12575
	OpcuaNodeIdServicesVariableTrust_TrustListType_Writable                                                           OpcuaNodeIdServicesVariableTrust = 12698
	OpcuaNodeIdServicesVariableTrust_TrustListType_UserWritable                                                       OpcuaNodeIdServicesVariableTrust = 12699
	OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_InputArguments                                      OpcuaNodeIdServicesVariableTrust = 12705
	OpcuaNodeIdServicesVariableTrust_TrustListType_MimeType                                                           OpcuaNodeIdServicesVariableTrust = 13403
	OpcuaNodeIdServicesVariableTrust_TrustListType_UpdateFrequency                                                    OpcuaNodeIdServicesVariableTrust = 19296
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventId                                              OpcuaNodeIdServicesVariableTrust = 19298
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventType                                            OpcuaNodeIdServicesVariableTrust = 19299
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableTrust = 19300
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceName                                           OpcuaNodeIdServicesVariableTrust = 19301
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Time                                                 OpcuaNodeIdServicesVariableTrust = 19302
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableTrust = 19303
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableTrust = 19304
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Message                                              OpcuaNodeIdServicesVariableTrust = 19305
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Severity                                             OpcuaNodeIdServicesVariableTrust = 19306
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableTrust = 19307
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableTrust = 19308
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableTrust = 19309
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableTrust = 19310
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableTrust = 19311
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_BranchId                                             OpcuaNodeIdServicesVariableTrust = 19312
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Retain                                               OpcuaNodeIdServicesVariableTrust = 19313
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableTrust = 19314
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableTrust = 19315
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableTrust = 19316
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableTrust = 19317
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrust = 19318
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableTrust = 19319
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrust = 19320
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableTrust = 19321
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableTrust = 19322
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality                                              OpcuaNodeIdServicesVariableTrust = 19323
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableTrust = 19324
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableTrust = 19325
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableTrust = 19326
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment                                              OpcuaNodeIdServicesVariableTrust = 19327
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableTrust = 19328
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableTrust = 19329
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableTrust = 19333
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableTrust = 19335
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableTrust = 19337
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState                                           OpcuaNodeIdServicesVariableTrust = 19338
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableTrust = 19339
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableTrust = 19340
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableTrust = 19341
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableTrust = 19342
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableTrust = 19343
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableTrust = 19344
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableTrust = 19345
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableTrust = 19346
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableTrust = 19347
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableTrust = 19348
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableTrust = 19349
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableTrust = 19350
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableTrust = 19351
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableTrust = 19352
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableTrust = 19353
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableTrust = 19354
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableTrust = 19355
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableTrust = 19357
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableTrust = 19359
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableTrust = 19360
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableTrust = 19361
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableTrust = 19362
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableTrust = 19363
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableTrust = 19364
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableTrust = 19365
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableTrust = 19366
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableTrust = 19367
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableTrust = 19368
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_InputNode                                            OpcuaNodeIdServicesVariableTrust = 19369
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableTrust = 19370
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableTrust = 19371
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableTrust = 19372
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableTrust = 19373
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableTrust = 19374
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableTrust = 19375
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableTrust = 19376
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableTrust = 19377
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableTrust = 19378
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableTrust = 19379
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableTrust = 19380
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableTrust = 19381
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableTrust = 19382
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableTrust = 19383
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableTrust = 19384
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableTrust = 19385
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableTrust = 19386
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableTrust = 19387
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableTrust = 19389
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableTrust = 19390
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableTrust = 19391
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableTrust = 19392
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableTrust = 19393
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableTrust = 19394
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableTrust = 19395
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableTrust = 19396
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableTrust = 19397
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableTrust = 19398
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableTrust = 19399
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableTrust = 19400
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableTrust = 19401
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableTrust = 19402
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableTrust = 19404
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableTrust = 19407
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableTrust = 19408
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableTrust = 19409
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableTrust = 19410
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableTrust = 19411
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableTrust = 19412
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableTrust = 19413
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableTrust = 19414
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableTrust = 19415
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableTrust = 19416
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableTrust = 19417
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrust = 19418
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableTrust = 19419
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrust = 19420
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableTrust = 19421
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableTrust = 19422
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableTrust = 19423
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableTrust = 19424
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableTrust = 19425
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableTrust = 19427
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableTrust = 19428
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableTrust = 19429
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableTrust = 19430
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableTrust = 19431
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableTrust = 19432
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableTrust = 19433
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableTrust = 19434
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableTrust = 19435
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableTrust = 19437
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableTrust = 19438
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_NormalState                                          OpcuaNodeIdServicesVariableTrust = 19445
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_TrustListId                                          OpcuaNodeIdServicesVariableTrust = 19446
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastUpdateTime                                       OpcuaNodeIdServicesVariableTrust = 19447
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_UpdateFrequency                                      OpcuaNodeIdServicesVariableTrust = 19448
	OpcuaNodeIdServicesVariableTrust_TrustListType_DefaultValidationOptions                                           OpcuaNodeIdServicesVariableTrust = 23563
	OpcuaNodeIdServicesVariableTrust_TrustListValidationOptions_OptionSetValues                                       OpcuaNodeIdServicesVariableTrust = 23565
	OpcuaNodeIdServicesVariableTrust_TrustListType_MaxByteStringLength                                                OpcuaNodeIdServicesVariableTrust = 24250
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableTrust = 24509
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableTrust = 24511
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableTrust = 24513
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableTrust = 24515
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableTrust = 24517
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableTrust = 24971
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableTrust = 24973
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableTrust = 24975
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableTrust = 25176
	OpcuaNodeIdServicesVariableTrust_TrustListType_LastModifiedTime                                                   OpcuaNodeIdServicesVariableTrust = 25206
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassId                                  OpcuaNodeIdServicesVariableTrust = 32027
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassName                                OpcuaNodeIdServicesVariableTrust = 32028
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassId                               OpcuaNodeIdServicesVariableTrust = 32029
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassName                             OpcuaNodeIdServicesVariableTrust = 32030
	OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableTrust = 32253
	OpcuaNodeIdServicesVariableTrust_TrustListType_ActivityTimeout                                                    OpcuaNodeIdServicesVariableTrust = 32254
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventId                                   OpcuaNodeIdServicesVariableTrust = 32261
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventType                                 OpcuaNodeIdServicesVariableTrust = 32262
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceNode                                OpcuaNodeIdServicesVariableTrust = 32263
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceName                                OpcuaNodeIdServicesVariableTrust = 32264
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Time                                      OpcuaNodeIdServicesVariableTrust = 32265
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ReceiveTime                               OpcuaNodeIdServicesVariableTrust = 32266
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_LocalTime                                 OpcuaNodeIdServicesVariableTrust = 32267
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Message                                   OpcuaNodeIdServicesVariableTrust = 32268
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Severity                                  OpcuaNodeIdServicesVariableTrust = 32269
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassId                          OpcuaNodeIdServicesVariableTrust = 32270
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassName                        OpcuaNodeIdServicesVariableTrust = 32271
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassId                       OpcuaNodeIdServicesVariableTrust = 32272
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassName                     OpcuaNodeIdServicesVariableTrust = 32273
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ActionTimeStamp                           OpcuaNodeIdServicesVariableTrust = 32274
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Status                                    OpcuaNodeIdServicesVariableTrust = 32275
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ServerId                                  OpcuaNodeIdServicesVariableTrust = 32276
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientAuditEntryId                        OpcuaNodeIdServicesVariableTrust = 32277
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientUserId                              OpcuaNodeIdServicesVariableTrust = 32278
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_MethodId                                  OpcuaNodeIdServicesVariableTrust = 32279
	OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_InputArguments                            OpcuaNodeIdServicesVariableTrust = 32280
	OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_TrustListId                                       OpcuaNodeIdServicesVariableTrust = 32281
)

var OpcuaNodeIdServicesVariableTrustValues []OpcuaNodeIdServicesVariableTrust

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTrustValues = []OpcuaNodeIdServicesVariableTrust{
		OpcuaNodeIdServicesVariableTrust_TrustListType_Size,
		OpcuaNodeIdServicesVariableTrust_TrustListType_OpenCount,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Open_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Open_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Close_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Read_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Read_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Write_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_LastUpdateTime,
		OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListMasks_EnumValues,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventType,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Time,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Message,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Severity,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Status,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableTrust_TrustListType_Writable,
		OpcuaNodeIdServicesVariableTrust_TrustListType_UserWritable,
		OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_MimeType,
		OpcuaNodeIdServicesVariableTrust_TrustListType_UpdateFrequency,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventType,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Time,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Message,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Severity,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_BranchId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Retain,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_InputNode,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_NormalState,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_TrustListId,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastUpdateTime,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_UpdateFrequency,
		OpcuaNodeIdServicesVariableTrust_TrustListType_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableTrust_TrustListValidationOptions_OptionSetValues,
		OpcuaNodeIdServicesVariableTrust_TrustListType_MaxByteStringLength,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListType_LastModifiedTime,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableTrust_TrustListType_ActivityTimeout,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventType,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Time,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Message,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Severity,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Status,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_MethodId,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_InputArguments,
		OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_TrustListId,
	}
}

func OpcuaNodeIdServicesVariableTrustByValue(value int32) (enum OpcuaNodeIdServicesVariableTrust, ok bool) {
	switch value {
	case 12523:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Size, true
	case 12526:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenCount, true
	case 12528:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Open_InputArguments, true
	case 12529:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Open_OutputArguments, true
	case 12531:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Close_InputArguments, true
	case 12533:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Read_InputArguments, true
	case 12534:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Read_OutputArguments, true
	case 12536:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Write_InputArguments, true
	case 12538:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_InputArguments, true
	case 12539:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_OutputArguments, true
	case 12541:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_SetPosition_InputArguments, true
	case 12542:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_LastUpdateTime, true
	case 12544:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_InputArguments, true
	case 12545:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_OutputArguments, true
	case 12547:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_OutputArguments, true
	case 12549:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_AddCertificate_InputArguments, true
	case 12551:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_RemoveCertificate_InputArguments, true
	case 12553:
		return OpcuaNodeIdServicesVariableTrust_TrustListMasks_EnumValues, true
	case 12562:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventId, true
	case 12563:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventType, true
	case 12564:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceNode, true
	case 12565:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceName, true
	case 12566:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Time, true
	case 12567:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ReceiveTime, true
	case 12568:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_LocalTime, true
	case 12569:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Message, true
	case 12570:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Severity, true
	case 12571:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ActionTimeStamp, true
	case 12572:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Status, true
	case 12573:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ServerId, true
	case 12574:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientAuditEntryId, true
	case 12575:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientUserId, true
	case 12698:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Writable, true
	case 12699:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_UserWritable, true
	case 12705:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_InputArguments, true
	case 13403:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_MimeType, true
	case 19296:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_UpdateFrequency, true
	case 19298:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventId, true
	case 19299:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventType, true
	case 19300:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceNode, true
	case 19301:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceName, true
	case 19302:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Time, true
	case 19303:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReceiveTime, true
	case 19304:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LocalTime, true
	case 19305:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Message, true
	case 19306:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Severity, true
	case 19307:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassId, true
	case 19308:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassName, true
	case 19309:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassId, true
	case 19310:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassName, true
	case 19311:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionName, true
	case 19312:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_BranchId, true
	case 19313:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Retain, true
	case 19314:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState, true
	case 19315:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Id, true
	case 19316:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Name, true
	case 19317:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Number, true
	case 19318:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName, true
	case 19319:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TransitionTime, true
	case 19320:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime, true
	case 19321:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TrueState, true
	case 19322:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_FalseState, true
	case 19323:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality, true
	case 19324:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality_SourceTimestamp, true
	case 19325:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity, true
	case 19326:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp, true
	case 19327:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment, true
	case 19328:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment_SourceTimestamp, true
	case 19329:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ClientUserId, true
	case 19333:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AddComment_InputArguments, true
	case 19335:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments, true
	case 19337:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments, true
	case 19338:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState, true
	case 19339:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Id, true
	case 19340:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Name, true
	case 19341:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Number, true
	case 19342:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName, true
	case 19343:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TransitionTime, true
	case 19344:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime, true
	case 19345:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TrueState, true
	case 19346:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_FalseState, true
	case 19347:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState, true
	case 19348:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Id, true
	case 19349:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Name, true
	case 19350:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Number, true
	case 19351:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 19352:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime, true
	case 19353:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 19354:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TrueState, true
	case 19355:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_FalseState, true
	case 19357:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Acknowledge_InputArguments, true
	case 19359:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Confirm_InputArguments, true
	case 19360:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState, true
	case 19361:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Id, true
	case 19362:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Name, true
	case 19363:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Number, true
	case 19364:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName, true
	case 19365:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TransitionTime, true
	case 19366:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime, true
	case 19367:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TrueState, true
	case 19368:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_FalseState, true
	case 19369:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_InputNode, true
	case 19370:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState, true
	case 19371:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Id, true
	case 19372:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Name, true
	case 19373:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Number, true
	case 19374:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName, true
	case 19375:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TransitionTime, true
	case 19376:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 19377:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TrueState, true
	case 19378:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_FalseState, true
	case 19379:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState, true
	case 19380:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Id, true
	case 19381:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Name, true
	case 19382:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Number, true
	case 19383:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 19384:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime, true
	case 19385:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 19386:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TrueState, true
	case 19387:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_FalseState, true
	case 19389:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState, true
	case 19390:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id, true
	case 19391:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name, true
	case 19392:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number, true
	case 19393:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 19394:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition, true
	case 19395:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id, true
	case 19396:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name, true
	case 19397:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number, true
	case 19398:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 19399:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 19400:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableStates, true
	case 19401:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions, true
	case 19402:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime, true
	case 19404:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 19407:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedOrShelved, true
	case 19408:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_MaxTimeShelved, true
	case 19409:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleEnabled, true
	case 19410:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound, true
	case 19411:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_ListId, true
	case 19412:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_AgencyId, true
	case 19413:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_VersionId, true
	case 19414:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState, true
	case 19415:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Id, true
	case 19416:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Name, true
	case 19417:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Number, true
	case 19418:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName, true
	case 19419:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TransitionTime, true
	case 19420:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime, true
	case 19421:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TrueState, true
	case 19422:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_FalseState, true
	case 19423:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OnDelay, true
	case 19424:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OffDelay, true
	case 19425:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_FirstInGroupFlag, true
	case 19427:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState, true
	case 19428:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Id, true
	case 19429:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Name, true
	case 19430:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Number, true
	case 19431:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName, true
	case 19432:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TransitionTime, true
	case 19433:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime, true
	case 19434:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TrueState, true
	case 19435:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_FalseState, true
	case 19437:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmTime, true
	case 19438:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmRepeatCount, true
	case 19445:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_NormalState, true
	case 19446:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_TrustListId, true
	case 19447:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastUpdateTime, true
	case 19448:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_UpdateFrequency, true
	case 23563:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_DefaultValidationOptions, true
	case 23565:
		return OpcuaNodeIdServicesVariableTrust_TrustListValidationOptions_OptionSetValues, true
	case 24250:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_MaxByteStringLength, true
	case 24509:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Suppress2_InputArguments, true
	case 24511:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments, true
	case 24513:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments, true
	case 24515:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments, true
	case 24517:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Reset2_InputArguments, true
	case 24971:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24973:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24975:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 25176:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments, true
	case 25206:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_LastModifiedTime, true
	case 32027:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassId, true
	case 32028:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassName, true
	case 32029:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassId, true
	case 32030:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassName, true
	case 32253:
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SupportsFilteredRetain, true
	case 32254:
		return OpcuaNodeIdServicesVariableTrust_TrustListType_ActivityTimeout, true
	case 32261:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventId, true
	case 32262:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventType, true
	case 32263:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceNode, true
	case 32264:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceName, true
	case 32265:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Time, true
	case 32266:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ReceiveTime, true
	case 32267:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_LocalTime, true
	case 32268:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Message, true
	case 32269:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Severity, true
	case 32270:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassId, true
	case 32271:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassName, true
	case 32272:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassId, true
	case 32273:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassName, true
	case 32274:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ActionTimeStamp, true
	case 32275:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Status, true
	case 32276:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ServerId, true
	case 32277:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientAuditEntryId, true
	case 32278:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientUserId, true
	case 32279:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_MethodId, true
	case 32280:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_InputArguments, true
	case 32281:
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_TrustListId, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTrustByName(value string) (enum OpcuaNodeIdServicesVariableTrust, ok bool) {
	switch value {
	case "TrustListType_Size":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Size, true
	case "TrustListType_OpenCount":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenCount, true
	case "TrustListType_Open_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Open_InputArguments, true
	case "TrustListType_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Open_OutputArguments, true
	case "TrustListType_Close_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Close_InputArguments, true
	case "TrustListType_Read_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Read_InputArguments, true
	case "TrustListType_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Read_OutputArguments, true
	case "TrustListType_Write_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Write_InputArguments, true
	case "TrustListType_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_InputArguments, true
	case "TrustListType_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_OutputArguments, true
	case "TrustListType_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_SetPosition_InputArguments, true
	case "TrustListType_LastUpdateTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_LastUpdateTime, true
	case "TrustListType_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_InputArguments, true
	case "TrustListType_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_OutputArguments, true
	case "TrustListType_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_OutputArguments, true
	case "TrustListType_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_AddCertificate_InputArguments, true
	case "TrustListType_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_RemoveCertificate_InputArguments, true
	case "TrustListMasks_EnumValues":
		return OpcuaNodeIdServicesVariableTrust_TrustListMasks_EnumValues, true
	case "TrustListUpdatedAuditEventType_EventId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventId, true
	case "TrustListUpdatedAuditEventType_EventType":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventType, true
	case "TrustListUpdatedAuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceNode, true
	case "TrustListUpdatedAuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceName, true
	case "TrustListUpdatedAuditEventType_Time":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Time, true
	case "TrustListUpdatedAuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ReceiveTime, true
	case "TrustListUpdatedAuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_LocalTime, true
	case "TrustListUpdatedAuditEventType_Message":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Message, true
	case "TrustListUpdatedAuditEventType_Severity":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Severity, true
	case "TrustListUpdatedAuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ActionTimeStamp, true
	case "TrustListUpdatedAuditEventType_Status":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Status, true
	case "TrustListUpdatedAuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ServerId, true
	case "TrustListUpdatedAuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientAuditEntryId, true
	case "TrustListUpdatedAuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientUserId, true
	case "TrustListType_Writable":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_Writable, true
	case "TrustListType_UserWritable":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_UserWritable, true
	case "TrustListType_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_InputArguments, true
	case "TrustListType_MimeType":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_MimeType, true
	case "TrustListType_UpdateFrequency":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_UpdateFrequency, true
	case "TrustListOutOfDateAlarmType_EventId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventId, true
	case "TrustListOutOfDateAlarmType_EventType":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventType, true
	case "TrustListOutOfDateAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceNode, true
	case "TrustListOutOfDateAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceName, true
	case "TrustListOutOfDateAlarmType_Time":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Time, true
	case "TrustListOutOfDateAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReceiveTime, true
	case "TrustListOutOfDateAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LocalTime, true
	case "TrustListOutOfDateAlarmType_Message":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Message, true
	case "TrustListOutOfDateAlarmType_Severity":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Severity, true
	case "TrustListOutOfDateAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassId, true
	case "TrustListOutOfDateAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassName, true
	case "TrustListOutOfDateAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassId, true
	case "TrustListOutOfDateAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassName, true
	case "TrustListOutOfDateAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionName, true
	case "TrustListOutOfDateAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_BranchId, true
	case "TrustListOutOfDateAlarmType_Retain":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Retain, true
	case "TrustListOutOfDateAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState, true
	case "TrustListOutOfDateAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Id, true
	case "TrustListOutOfDateAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Name, true
	case "TrustListOutOfDateAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Number, true
	case "TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TrueState, true
	case "TrustListOutOfDateAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_FalseState, true
	case "TrustListOutOfDateAlarmType_Quality":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality, true
	case "TrustListOutOfDateAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality_SourceTimestamp, true
	case "TrustListOutOfDateAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity, true
	case "TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp, true
	case "TrustListOutOfDateAlarmType_Comment":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment, true
	case "TrustListOutOfDateAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment_SourceTimestamp, true
	case "TrustListOutOfDateAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ClientUserId, true
	case "TrustListOutOfDateAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AddComment_InputArguments, true
	case "TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments, true
	case "TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments, true
	case "TrustListOutOfDateAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState, true
	case "TrustListOutOfDateAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Id, true
	case "TrustListOutOfDateAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Name, true
	case "TrustListOutOfDateAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Number, true
	case "TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TrueState, true
	case "TrustListOutOfDateAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_FalseState, true
	case "TrustListOutOfDateAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Id, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Name, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Number, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TrueState, true
	case "TrustListOutOfDateAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_FalseState, true
	case "TrustListOutOfDateAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Acknowledge_InputArguments, true
	case "TrustListOutOfDateAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Confirm_InputArguments, true
	case "TrustListOutOfDateAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState, true
	case "TrustListOutOfDateAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Id, true
	case "TrustListOutOfDateAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Name, true
	case "TrustListOutOfDateAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Number, true
	case "TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TrueState, true
	case "TrustListOutOfDateAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_FalseState, true
	case "TrustListOutOfDateAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_InputNode, true
	case "TrustListOutOfDateAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState, true
	case "TrustListOutOfDateAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Id, true
	case "TrustListOutOfDateAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Name, true
	case "TrustListOutOfDateAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Number, true
	case "TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TrueState, true
	case "TrustListOutOfDateAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_FalseState, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Id, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Name, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Number, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TrueState, true
	case "TrustListOutOfDateAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_FalseState, true
	case "TrustListOutOfDateAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState, true
	case "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id, true
	case "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name, true
	case "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number, true
	case "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableStates, true
	case "TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions, true
	case "TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime, true
	case "TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "TrustListOutOfDateAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedOrShelved, true
	case "TrustListOutOfDateAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_MaxTimeShelved, true
	case "TrustListOutOfDateAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleEnabled, true
	case "TrustListOutOfDateAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound, true
	case "TrustListOutOfDateAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_ListId, true
	case "TrustListOutOfDateAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_AgencyId, true
	case "TrustListOutOfDateAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_VersionId, true
	case "TrustListOutOfDateAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState, true
	case "TrustListOutOfDateAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Id, true
	case "TrustListOutOfDateAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Name, true
	case "TrustListOutOfDateAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Number, true
	case "TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TrueState, true
	case "TrustListOutOfDateAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_FalseState, true
	case "TrustListOutOfDateAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OnDelay, true
	case "TrustListOutOfDateAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OffDelay, true
	case "TrustListOutOfDateAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_FirstInGroupFlag, true
	case "TrustListOutOfDateAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState, true
	case "TrustListOutOfDateAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Id, true
	case "TrustListOutOfDateAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Name, true
	case "TrustListOutOfDateAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Number, true
	case "TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName, true
	case "TrustListOutOfDateAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TransitionTime, true
	case "TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime, true
	case "TrustListOutOfDateAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TrueState, true
	case "TrustListOutOfDateAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_FalseState, true
	case "TrustListOutOfDateAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmTime, true
	case "TrustListOutOfDateAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmRepeatCount, true
	case "TrustListOutOfDateAlarmType_NormalState":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_NormalState, true
	case "TrustListOutOfDateAlarmType_TrustListId":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_TrustListId, true
	case "TrustListOutOfDateAlarmType_LastUpdateTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastUpdateTime, true
	case "TrustListOutOfDateAlarmType_UpdateFrequency":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_UpdateFrequency, true
	case "TrustListType_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_DefaultValidationOptions, true
	case "TrustListValidationOptions_OptionSetValues":
		return OpcuaNodeIdServicesVariableTrust_TrustListValidationOptions_OptionSetValues, true
	case "TrustListType_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_MaxByteStringLength, true
	case "TrustListOutOfDateAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Suppress2_InputArguments, true
	case "TrustListOutOfDateAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments, true
	case "TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments, true
	case "TrustListOutOfDateAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments, true
	case "TrustListOutOfDateAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Reset2_InputArguments, true
	case "TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments, true
	case "TrustListType_LastModifiedTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_LastModifiedTime, true
	case "TrustListUpdatedAuditEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassId, true
	case "TrustListUpdatedAuditEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassName, true
	case "TrustListUpdatedAuditEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassId, true
	case "TrustListUpdatedAuditEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassName, true
	case "TrustListOutOfDateAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SupportsFilteredRetain, true
	case "TrustListType_ActivityTimeout":
		return OpcuaNodeIdServicesVariableTrust_TrustListType_ActivityTimeout, true
	case "TrustListUpdateRequestedAuditEventType_EventId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventId, true
	case "TrustListUpdateRequestedAuditEventType_EventType":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventType, true
	case "TrustListUpdateRequestedAuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceNode, true
	case "TrustListUpdateRequestedAuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceName, true
	case "TrustListUpdateRequestedAuditEventType_Time":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Time, true
	case "TrustListUpdateRequestedAuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ReceiveTime, true
	case "TrustListUpdateRequestedAuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_LocalTime, true
	case "TrustListUpdateRequestedAuditEventType_Message":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Message, true
	case "TrustListUpdateRequestedAuditEventType_Severity":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Severity, true
	case "TrustListUpdateRequestedAuditEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassId, true
	case "TrustListUpdateRequestedAuditEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassName, true
	case "TrustListUpdateRequestedAuditEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassId, true
	case "TrustListUpdateRequestedAuditEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassName, true
	case "TrustListUpdateRequestedAuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ActionTimeStamp, true
	case "TrustListUpdateRequestedAuditEventType_Status":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Status, true
	case "TrustListUpdateRequestedAuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ServerId, true
	case "TrustListUpdateRequestedAuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientAuditEntryId, true
	case "TrustListUpdateRequestedAuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientUserId, true
	case "TrustListUpdateRequestedAuditEventType_MethodId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_MethodId, true
	case "TrustListUpdateRequestedAuditEventType_InputArguments":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_InputArguments, true
	case "TrustListUpdatedAuditEventType_TrustListId":
		return OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_TrustListId, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTrustKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTrustValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTrust(structType any) OpcuaNodeIdServicesVariableTrust {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTrust {
		if sOpcuaNodeIdServicesVariableTrust, ok := typ.(OpcuaNodeIdServicesVariableTrust); ok {
			return sOpcuaNodeIdServicesVariableTrust
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTrust) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTrust) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTrustParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTrust, error) {
	return OpcuaNodeIdServicesVariableTrustParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTrustParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTrust, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTrust", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTrust")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTrustByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTrust")
		return OpcuaNodeIdServicesVariableTrust(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTrust) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTrust) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTrust", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTrust) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Size:
		return "TrustListType_Size"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_OpenCount:
		return "TrustListType_OpenCount"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Open_InputArguments:
		return "TrustListType_Open_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Open_OutputArguments:
		return "TrustListType_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Close_InputArguments:
		return "TrustListType_Close_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Read_InputArguments:
		return "TrustListType_Read_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Read_OutputArguments:
		return "TrustListType_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Write_InputArguments:
		return "TrustListType_Write_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_InputArguments:
		return "TrustListType_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_GetPosition_OutputArguments:
		return "TrustListType_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_SetPosition_InputArguments:
		return "TrustListType_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_LastUpdateTime:
		return "TrustListType_LastUpdateTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_InputArguments:
		return "TrustListType_OpenWithMasks_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_OpenWithMasks_OutputArguments:
		return "TrustListType_OpenWithMasks_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_OutputArguments:
		return "TrustListType_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_AddCertificate_InputArguments:
		return "TrustListType_AddCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_RemoveCertificate_InputArguments:
		return "TrustListType_RemoveCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListMasks_EnumValues:
		return "TrustListMasks_EnumValues"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventId:
		return "TrustListUpdatedAuditEventType_EventId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_EventType:
		return "TrustListUpdatedAuditEventType_EventType"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceNode:
		return "TrustListUpdatedAuditEventType_SourceNode"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_SourceName:
		return "TrustListUpdatedAuditEventType_SourceName"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Time:
		return "TrustListUpdatedAuditEventType_Time"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ReceiveTime:
		return "TrustListUpdatedAuditEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_LocalTime:
		return "TrustListUpdatedAuditEventType_LocalTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Message:
		return "TrustListUpdatedAuditEventType_Message"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Severity:
		return "TrustListUpdatedAuditEventType_Severity"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ActionTimeStamp:
		return "TrustListUpdatedAuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_Status:
		return "TrustListUpdatedAuditEventType_Status"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ServerId:
		return "TrustListUpdatedAuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientAuditEntryId:
		return "TrustListUpdatedAuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ClientUserId:
		return "TrustListUpdatedAuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_Writable:
		return "TrustListType_Writable"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_UserWritable:
		return "TrustListType_UserWritable"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_CloseAndUpdate_InputArguments:
		return "TrustListType_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_MimeType:
		return "TrustListType_MimeType"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_UpdateFrequency:
		return "TrustListType_UpdateFrequency"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventId:
		return "TrustListOutOfDateAlarmType_EventId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EventType:
		return "TrustListOutOfDateAlarmType_EventType"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceNode:
		return "TrustListOutOfDateAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SourceName:
		return "TrustListOutOfDateAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Time:
		return "TrustListOutOfDateAlarmType_Time"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReceiveTime:
		return "TrustListOutOfDateAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LocalTime:
		return "TrustListOutOfDateAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Message:
		return "TrustListOutOfDateAlarmType_Message"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Severity:
		return "TrustListOutOfDateAlarmType_Severity"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassId:
		return "TrustListOutOfDateAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionClassName:
		return "TrustListOutOfDateAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassId:
		return "TrustListOutOfDateAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionSubClassName:
		return "TrustListOutOfDateAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionName:
		return "TrustListOutOfDateAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_BranchId:
		return "TrustListOutOfDateAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Retain:
		return "TrustListOutOfDateAlarmType_Retain"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState:
		return "TrustListOutOfDateAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Id:
		return "TrustListOutOfDateAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Name:
		return "TrustListOutOfDateAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_Number:
		return "TrustListOutOfDateAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TransitionTime:
		return "TrustListOutOfDateAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_TrueState:
		return "TrustListOutOfDateAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_EnabledState_FalseState:
		return "TrustListOutOfDateAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality:
		return "TrustListOutOfDateAlarmType_Quality"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Quality_SourceTimestamp:
		return "TrustListOutOfDateAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity:
		return "TrustListOutOfDateAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp:
		return "TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment:
		return "TrustListOutOfDateAlarmType_Comment"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Comment_SourceTimestamp:
		return "TrustListOutOfDateAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ClientUserId:
		return "TrustListOutOfDateAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AddComment_InputArguments:
		return "TrustListOutOfDateAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments:
		return "TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments:
		return "TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState:
		return "TrustListOutOfDateAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Id:
		return "TrustListOutOfDateAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Name:
		return "TrustListOutOfDateAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_Number:
		return "TrustListOutOfDateAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TransitionTime:
		return "TrustListOutOfDateAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_TrueState:
		return "TrustListOutOfDateAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AckedState_FalseState:
		return "TrustListOutOfDateAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState:
		return "TrustListOutOfDateAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Id:
		return "TrustListOutOfDateAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Name:
		return "TrustListOutOfDateAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_Number:
		return "TrustListOutOfDateAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime:
		return "TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_TrueState:
		return "TrustListOutOfDateAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ConfirmedState_FalseState:
		return "TrustListOutOfDateAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Acknowledge_InputArguments:
		return "TrustListOutOfDateAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Confirm_InputArguments:
		return "TrustListOutOfDateAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState:
		return "TrustListOutOfDateAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Id:
		return "TrustListOutOfDateAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Name:
		return "TrustListOutOfDateAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_Number:
		return "TrustListOutOfDateAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TransitionTime:
		return "TrustListOutOfDateAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_TrueState:
		return "TrustListOutOfDateAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ActiveState_FalseState:
		return "TrustListOutOfDateAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_InputNode:
		return "TrustListOutOfDateAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState:
		return "TrustListOutOfDateAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Id:
		return "TrustListOutOfDateAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Name:
		return "TrustListOutOfDateAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_Number:
		return "TrustListOutOfDateAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TransitionTime:
		return "TrustListOutOfDateAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_TrueState:
		return "TrustListOutOfDateAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedState_FalseState:
		return "TrustListOutOfDateAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState:
		return "TrustListOutOfDateAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Id:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Name:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_Number:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_TrueState:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OutOfServiceState_FalseState:
		return "TrustListOutOfDateAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState:
		return "TrustListOutOfDateAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id:
		return "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name:
		return "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number:
		return "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableStates:
		return "TrustListOutOfDateAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions:
		return "TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime:
		return "TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SuppressedOrShelved:
		return "TrustListOutOfDateAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_MaxTimeShelved:
		return "TrustListOutOfDateAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleEnabled:
		return "TrustListOutOfDateAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound:
		return "TrustListOutOfDateAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_ListId:
		return "TrustListOutOfDateAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_AgencyId:
		return "TrustListOutOfDateAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_AudibleSound_VersionId:
		return "TrustListOutOfDateAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState:
		return "TrustListOutOfDateAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Id:
		return "TrustListOutOfDateAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Name:
		return "TrustListOutOfDateAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_Number:
		return "TrustListOutOfDateAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TransitionTime:
		return "TrustListOutOfDateAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_TrueState:
		return "TrustListOutOfDateAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SilenceState_FalseState:
		return "TrustListOutOfDateAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OnDelay:
		return "TrustListOutOfDateAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_OffDelay:
		return "TrustListOutOfDateAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_FirstInGroupFlag:
		return "TrustListOutOfDateAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState:
		return "TrustListOutOfDateAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Id:
		return "TrustListOutOfDateAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Name:
		return "TrustListOutOfDateAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_Number:
		return "TrustListOutOfDateAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName:
		return "TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TransitionTime:
		return "TrustListOutOfDateAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime:
		return "TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_TrueState:
		return "TrustListOutOfDateAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LatchedState_FalseState:
		return "TrustListOutOfDateAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmTime:
		return "TrustListOutOfDateAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ReAlarmRepeatCount:
		return "TrustListOutOfDateAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_NormalState:
		return "TrustListOutOfDateAlarmType_NormalState"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_TrustListId:
		return "TrustListOutOfDateAlarmType_TrustListId"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_LastUpdateTime:
		return "TrustListOutOfDateAlarmType_LastUpdateTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_UpdateFrequency:
		return "TrustListOutOfDateAlarmType_UpdateFrequency"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_DefaultValidationOptions:
		return "TrustListType_DefaultValidationOptions"
	case OpcuaNodeIdServicesVariableTrust_TrustListValidationOptions_OptionSetValues:
		return "TrustListValidationOptions_OptionSetValues"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_MaxByteStringLength:
		return "TrustListType_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Suppress2_InputArguments:
		return "TrustListOutOfDateAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments:
		return "TrustListOutOfDateAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments:
		return "TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments:
		return "TrustListOutOfDateAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_Reset2_InputArguments:
		return "TrustListOutOfDateAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments:
		return "TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_LastModifiedTime:
		return "TrustListType_LastModifiedTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassId:
		return "TrustListUpdatedAuditEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionClassName:
		return "TrustListUpdatedAuditEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassId:
		return "TrustListUpdatedAuditEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_ConditionSubClassName:
		return "TrustListUpdatedAuditEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListOutOfDateAlarmType_SupportsFilteredRetain:
		return "TrustListOutOfDateAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableTrust_TrustListType_ActivityTimeout:
		return "TrustListType_ActivityTimeout"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventId:
		return "TrustListUpdateRequestedAuditEventType_EventId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_EventType:
		return "TrustListUpdateRequestedAuditEventType_EventType"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceNode:
		return "TrustListUpdateRequestedAuditEventType_SourceNode"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_SourceName:
		return "TrustListUpdateRequestedAuditEventType_SourceName"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Time:
		return "TrustListUpdateRequestedAuditEventType_Time"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ReceiveTime:
		return "TrustListUpdateRequestedAuditEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_LocalTime:
		return "TrustListUpdateRequestedAuditEventType_LocalTime"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Message:
		return "TrustListUpdateRequestedAuditEventType_Message"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Severity:
		return "TrustListUpdateRequestedAuditEventType_Severity"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassId:
		return "TrustListUpdateRequestedAuditEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionClassName:
		return "TrustListUpdateRequestedAuditEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassId:
		return "TrustListUpdateRequestedAuditEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ConditionSubClassName:
		return "TrustListUpdateRequestedAuditEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ActionTimeStamp:
		return "TrustListUpdateRequestedAuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_Status:
		return "TrustListUpdateRequestedAuditEventType_Status"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ServerId:
		return "TrustListUpdateRequestedAuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientAuditEntryId:
		return "TrustListUpdateRequestedAuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_ClientUserId:
		return "TrustListUpdateRequestedAuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_MethodId:
		return "TrustListUpdateRequestedAuditEventType_MethodId"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdateRequestedAuditEventType_InputArguments:
		return "TrustListUpdateRequestedAuditEventType_InputArguments"
	case OpcuaNodeIdServicesVariableTrust_TrustListUpdatedAuditEventType_TrustListId:
		return "TrustListUpdatedAuditEventType_TrustListId"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTrust) String() string {
	return e.PLC4XEnumName()
}
