/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableServer is an enum
type OpcuaNodeIdServicesVariableServer int32

type IOpcuaNodeIdServicesVariableServer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableServer_ServerType_ServerArray                                                                                                                    OpcuaNodeIdServicesVariableServer = 2005
	OpcuaNodeIdServicesVariableServer_ServerType_NamespaceArray                                                                                                                 OpcuaNodeIdServicesVariableServer = 2006
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus                                                                                                                   OpcuaNodeIdServicesVariableServer = 2007
	OpcuaNodeIdServicesVariableServer_ServerType_ServiceLevel                                                                                                                   OpcuaNodeIdServicesVariableServer = 2008
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_ServerProfileArray                                                                                                 OpcuaNodeIdServicesVariableServer = 2014
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_LocaleIdArray                                                                                                      OpcuaNodeIdServicesVariableServer = 2016
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MinSupportedSampleRate                                                                                             OpcuaNodeIdServicesVariableServer = 2017
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary                                                                                            OpcuaNodeIdServicesVariableServer = 2021
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SamplingIntervalDiagnosticsArray                                                                                    OpcuaNodeIdServicesVariableServer = 2022
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SubscriptionDiagnosticsArray                                                                                        OpcuaNodeIdServicesVariableServer = 2023
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_EnabledFlag                                                                                                         OpcuaNodeIdServicesVariableServer = 2025
	OpcuaNodeIdServicesVariableServer_ServerRedundancyType_RedundancySupport                                                                                                    OpcuaNodeIdServicesVariableServer = 2035
	OpcuaNodeIdServicesVariableServer_ServerStatusType_StartTime                                                                                                                OpcuaNodeIdServicesVariableServer = 2139
	OpcuaNodeIdServicesVariableServer_ServerStatusType_CurrentTime                                                                                                              OpcuaNodeIdServicesVariableServer = 2140
	OpcuaNodeIdServicesVariableServer_ServerStatusType_State                                                                                                                    OpcuaNodeIdServicesVariableServer = 2141
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo                                                                                                                OpcuaNodeIdServicesVariableServer = 2142
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_ServerViewCount                                                                                              OpcuaNodeIdServicesVariableServer = 2151
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSessionCount                                                                                          OpcuaNodeIdServicesVariableServer = 2152
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSessionCount                                                                                        OpcuaNodeIdServicesVariableServer = 2153
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedSessionCount                                                                                 OpcuaNodeIdServicesVariableServer = 2154
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedSessionCount                                                                                         OpcuaNodeIdServicesVariableServer = 2155
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionTimeoutCount                                                                                          OpcuaNodeIdServicesVariableServer = 2156
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionAbortCount                                                                                            OpcuaNodeIdServicesVariableServer = 2157
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_PublishingIntervalCount                                                                                      OpcuaNodeIdServicesVariableServer = 2159
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSubscriptionCount                                                                                     OpcuaNodeIdServicesVariableServer = 2160
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSubscriptionCount                                                                                   OpcuaNodeIdServicesVariableServer = 2161
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount                                                                                OpcuaNodeIdServicesVariableServer = 2162
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedRequestsCount                                                                                        OpcuaNodeIdServicesVariableServer = 2163
	OpcuaNodeIdServicesVariableServer_Server_ServerArray                                                                                                                        OpcuaNodeIdServicesVariableServer = 2254
	OpcuaNodeIdServicesVariableServer_Server_NamespaceArray                                                                                                                     OpcuaNodeIdServicesVariableServer = 2255
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus                                                                                                                       OpcuaNodeIdServicesVariableServer = 2256
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_StartTime                                                                                                             OpcuaNodeIdServicesVariableServer = 2257
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_CurrentTime                                                                                                           OpcuaNodeIdServicesVariableServer = 2258
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_State                                                                                                                 OpcuaNodeIdServicesVariableServer = 2259
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo                                                                                                             OpcuaNodeIdServicesVariableServer = 2260
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductName                                                                                                 OpcuaNodeIdServicesVariableServer = 2261
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductUri                                                                                                  OpcuaNodeIdServicesVariableServer = 2262
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ManufacturerName                                                                                            OpcuaNodeIdServicesVariableServer = 2263
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_SoftwareVersion                                                                                             OpcuaNodeIdServicesVariableServer = 2264
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildNumber                                                                                                 OpcuaNodeIdServicesVariableServer = 2265
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildDate                                                                                                   OpcuaNodeIdServicesVariableServer = 2266
	OpcuaNodeIdServicesVariableServer_Server_ServiceLevel                                                                                                                       OpcuaNodeIdServicesVariableServer = 2267
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_ServerProfileArray                                                                                              OpcuaNodeIdServicesVariableServer = 2269
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_LocaleIdArray                                                                                                   OpcuaNodeIdServicesVariableServer = 2271
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MinSupportedSampleRate                                                                                          OpcuaNodeIdServicesVariableServer = 2272
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary                                                                                         OpcuaNodeIdServicesVariableServer = 2275
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount                                                                         OpcuaNodeIdServicesVariableServer = 2276
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount                                                                     OpcuaNodeIdServicesVariableServer = 2277
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount                                                                   OpcuaNodeIdServicesVariableServer = 2278
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                                            OpcuaNodeIdServicesVariableServer = 2279
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount                                                                     OpcuaNodeIdServicesVariableServer = 2281
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount                                                                       OpcuaNodeIdServicesVariableServer = 2282
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount                                                                 OpcuaNodeIdServicesVariableServer = 2284
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount                                                                OpcuaNodeIdServicesVariableServer = 2285
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                                              OpcuaNodeIdServicesVariableServer = 2286
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                                           OpcuaNodeIdServicesVariableServer = 2287
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount                                                                   OpcuaNodeIdServicesVariableServer = 2288
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray                                                                                 OpcuaNodeIdServicesVariableServer = 2289
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SubscriptionDiagnosticsArray                                                                                     OpcuaNodeIdServicesVariableServer = 2290
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_EnabledFlag                                                                                                      OpcuaNodeIdServicesVariableServer = 2294
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxBrowseContinuationPoints                                                                                        OpcuaNodeIdServicesVariableServer = 2732
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxQueryContinuationPoints                                                                                         OpcuaNodeIdServicesVariableServer = 2733
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxHistoryContinuationPoints                                                                                       OpcuaNodeIdServicesVariableServer = 2734
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxBrowseContinuationPoints                                                                                     OpcuaNodeIdServicesVariableServer = 2735
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxQueryContinuationPoints                                                                                      OpcuaNodeIdServicesVariableServer = 2736
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxHistoryContinuationPoints                                                                                    OpcuaNodeIdServicesVariableServer = 2737
	OpcuaNodeIdServicesVariableServer_ServerType_Auditing                                                                                                                       OpcuaNodeIdServicesVariableServer = 2742
	OpcuaNodeIdServicesVariableServer_ServerStatusType_SecondsTillShutdown                                                                                                      OpcuaNodeIdServicesVariableServer = 2752
	OpcuaNodeIdServicesVariableServer_ServerStatusType_ShutdownReason                                                                                                           OpcuaNodeIdServicesVariableServer = 2753
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_SecondsTillShutdown                                                                                                   OpcuaNodeIdServicesVariableServer = 2992
	OpcuaNodeIdServicesVariableServer_Server_ServerStatus_ShutdownReason                                                                                                        OpcuaNodeIdServicesVariableServer = 2993
	OpcuaNodeIdServicesVariableServer_Server_Auditing                                                                                                                           OpcuaNodeIdServicesVariableServer = 2994
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_SoftwareCertificates                                                                                               OpcuaNodeIdServicesVariableServer = 3049
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_StartTime                                                                                                         OpcuaNodeIdServicesVariableServer = 3074
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_CurrentTime                                                                                                       OpcuaNodeIdServicesVariableServer = 3075
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_State                                                                                                             OpcuaNodeIdServicesVariableServer = 3076
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo                                                                                                         OpcuaNodeIdServicesVariableServer = 3077
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ProductUri                                                                                              OpcuaNodeIdServicesVariableServer = 3078
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ManufacturerName                                                                                        OpcuaNodeIdServicesVariableServer = 3079
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ProductName                                                                                             OpcuaNodeIdServicesVariableServer = 3080
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_SoftwareVersion                                                                                         OpcuaNodeIdServicesVariableServer = 3081
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_BuildNumber                                                                                             OpcuaNodeIdServicesVariableServer = 3082
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_BuildDate                                                                                               OpcuaNodeIdServicesVariableServer = 3083
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_SecondsTillShutdown                                                                                               OpcuaNodeIdServicesVariableServer = 3084
	OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_ShutdownReason                                                                                                    OpcuaNodeIdServicesVariableServer = 3085
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_ServerProfileArray                                                                                          OpcuaNodeIdServicesVariableServer = 3086
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_LocaleIdArray                                                                                               OpcuaNodeIdServicesVariableServer = 3087
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MinSupportedSampleRate                                                                                      OpcuaNodeIdServicesVariableServer = 3088
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxBrowseContinuationPoints                                                                                 OpcuaNodeIdServicesVariableServer = 3089
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxQueryContinuationPoints                                                                                  OpcuaNodeIdServicesVariableServer = 3090
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxHistoryContinuationPoints                                                                                OpcuaNodeIdServicesVariableServer = 3091
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_SoftwareCertificates                                                                                        OpcuaNodeIdServicesVariableServer = 3092
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary                                                                                     OpcuaNodeIdServicesVariableServer = 3095
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount                                                                     OpcuaNodeIdServicesVariableServer = 3096
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount                                                                 OpcuaNodeIdServicesVariableServer = 3097
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount                                                               OpcuaNodeIdServicesVariableServer = 3098
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                                        OpcuaNodeIdServicesVariableServer = 3099
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount                                                                OpcuaNodeIdServicesVariableServer = 3100
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount                                                                 OpcuaNodeIdServicesVariableServer = 3101
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount                                                                   OpcuaNodeIdServicesVariableServer = 3102
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount                                                             OpcuaNodeIdServicesVariableServer = 3104
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount                                                            OpcuaNodeIdServicesVariableServer = 3105
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                                          OpcuaNodeIdServicesVariableServer = 3106
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                                       OpcuaNodeIdServicesVariableServer = 3107
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount                                                               OpcuaNodeIdServicesVariableServer = 3108
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SamplingIntervalDiagnosticsArray                                                                             OpcuaNodeIdServicesVariableServer = 3109
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray                                                                                 OpcuaNodeIdServicesVariableServer = 3110
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                                           OpcuaNodeIdServicesVariableServer = 3112
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                                                   OpcuaNodeIdServicesVariableServer = 3113
	OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_EnabledFlag                                                                                                  OpcuaNodeIdServicesVariableServer = 3114
	OpcuaNodeIdServicesVariableServer_ServerType_ServerRedundancy_RedundancySupport                                                                                             OpcuaNodeIdServicesVariableServer = 3115
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount                                                                            OpcuaNodeIdServicesVariableServer = 3116
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount                                                                        OpcuaNodeIdServicesVariableServer = 3117
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount                                                                      OpcuaNodeIdServicesVariableServer = 3118
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                                               OpcuaNodeIdServicesVariableServer = 3119
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount                                                                       OpcuaNodeIdServicesVariableServer = 3120
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount                                                                        OpcuaNodeIdServicesVariableServer = 3121
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount                                                                          OpcuaNodeIdServicesVariableServer = 3122
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount                                                                    OpcuaNodeIdServicesVariableServer = 3124
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount                                                                   OpcuaNodeIdServicesVariableServer = 3125
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                                                 OpcuaNodeIdServicesVariableServer = 3126
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                                              OpcuaNodeIdServicesVariableServer = 3127
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount                                                                      OpcuaNodeIdServicesVariableServer = 3128
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                                                  OpcuaNodeIdServicesVariableServer = 3129
	OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                                                          OpcuaNodeIdServicesVariableServer = 3130
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ProductUri                                                                                                     OpcuaNodeIdServicesVariableServer = 3698
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ManufacturerName                                                                                               OpcuaNodeIdServicesVariableServer = 3699
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ProductName                                                                                                    OpcuaNodeIdServicesVariableServer = 3700
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_SoftwareVersion                                                                                                OpcuaNodeIdServicesVariableServer = 3701
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_BuildNumber                                                                                                    OpcuaNodeIdServicesVariableServer = 3702
	OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_BuildDate                                                                                                      OpcuaNodeIdServicesVariableServer = 3703
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_SoftwareCertificates                                                                                            OpcuaNodeIdServicesVariableServer = 3704
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount                                                                    OpcuaNodeIdServicesVariableServer = 3705
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                                               OpcuaNodeIdServicesVariableServer = 3707
	OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                                                       OpcuaNodeIdServicesVariableServer = 3708
	OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_RedundancySupport                                                                                                 OpcuaNodeIdServicesVariableServer = 3709
	OpcuaNodeIdServicesVariableServer_ServerState_EnumStrings                                                                                                                   OpcuaNodeIdServicesVariableServer = 7612
	OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_CurrentServerId                                                                                                   OpcuaNodeIdServicesVariableServer = 11312
	OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_RedundantServerArray                                                                                              OpcuaNodeIdServicesVariableServer = 11313
	OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerUriArray                                                                                                    OpcuaNodeIdServicesVariableServer = 11314
	OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_InputArguments                                                                                               OpcuaNodeIdServicesVariableServer = 11490
	OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_OutputArguments                                                                                              OpcuaNodeIdServicesVariableServer = 11491
	OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_InputArguments                                                                                                   OpcuaNodeIdServicesVariableServer = 11493
	OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_OutputArguments                                                                                                  OpcuaNodeIdServicesVariableServer = 11494
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxArrayLength                                                                                              OpcuaNodeIdServicesVariableServer = 11514
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxStringLength                                                                                             OpcuaNodeIdServicesVariableServer = 11515
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead                                                                             OpcuaNodeIdServicesVariableServer = 11517
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite                                                                            OpcuaNodeIdServicesVariableServer = 11519
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall                                                                       OpcuaNodeIdServicesVariableServer = 11521
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse                                                                           OpcuaNodeIdServicesVariableServer = 11522
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes                                                                    OpcuaNodeIdServicesVariableServer = 11523
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds                                                    OpcuaNodeIdServicesVariableServer = 11524
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement                                                                   OpcuaNodeIdServicesVariableServer = 11525
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall                                                                    OpcuaNodeIdServicesVariableServer = 11526
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxArrayLength                                                                                                     OpcuaNodeIdServicesVariableServer = 11549
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxStringLength                                                                                                    OpcuaNodeIdServicesVariableServer = 11550
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRead                                                                                    OpcuaNodeIdServicesVariableServer = 11552
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite                                                                                   OpcuaNodeIdServicesVariableServer = 11554
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall                                                                              OpcuaNodeIdServicesVariableServer = 11556
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse                                                                                  OpcuaNodeIdServicesVariableServer = 11557
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes                                                                           OpcuaNodeIdServicesVariableServer = 11558
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds                                                           OpcuaNodeIdServicesVariableServer = 11559
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement                                                                          OpcuaNodeIdServicesVariableServer = 11560
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall                                                                           OpcuaNodeIdServicesVariableServer = 11561
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_VendorCapability_Placeholder                                                                                       OpcuaNodeIdServicesVariableServer = 11562
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxArrayLength                                                                                                  OpcuaNodeIdServicesVariableServer = 11702
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxStringLength                                                                                                 OpcuaNodeIdServicesVariableServer = 11703
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRead                                                                                 OpcuaNodeIdServicesVariableServer = 11705
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite                                                                                OpcuaNodeIdServicesVariableServer = 11707
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall                                                                           OpcuaNodeIdServicesVariableServer = 11709
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse                                                                               OpcuaNodeIdServicesVariableServer = 11710
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes                                                                        OpcuaNodeIdServicesVariableServer = 11711
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds                                                        OpcuaNodeIdServicesVariableServer = 11712
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement                                                                       OpcuaNodeIdServicesVariableServer = 11713
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall                                                                        OpcuaNodeIdServicesVariableServer = 11714
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData                                                                  OpcuaNodeIdServicesVariableServer = 12153
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents                                                                OpcuaNodeIdServicesVariableServer = 12154
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData                                                                OpcuaNodeIdServicesVariableServer = 12155
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents                                                              OpcuaNodeIdServicesVariableServer = 12156
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData                                                                         OpcuaNodeIdServicesVariableServer = 12157
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents                                                                       OpcuaNodeIdServicesVariableServer = 12158
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData                                                                       OpcuaNodeIdServicesVariableServer = 12159
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents                                                                     OpcuaNodeIdServicesVariableServer = 12160
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData                                                                      OpcuaNodeIdServicesVariableServer = 12165
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents                                                                    OpcuaNodeIdServicesVariableServer = 12166
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData                                                                    OpcuaNodeIdServicesVariableServer = 12167
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents                                                                  OpcuaNodeIdServicesVariableServer = 12168
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_SupportedPrivateKeyFormats                                                                                        OpcuaNodeIdServicesVariableServer = 12583
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MaxTrustListSize                                                                                                  OpcuaNodeIdServicesVariableServer = 12584
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MulticastDnsEnabled                                                                                               OpcuaNodeIdServicesVariableServer = 12585
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_InputArguments                                                                                  OpcuaNodeIdServicesVariableServer = 12617
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_OutputArguments                                                                                 OpcuaNodeIdServicesVariableServer = 12618
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_SupportedPrivateKeyFormats                                                                                            OpcuaNodeIdServicesVariableServer = 12639
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_MaxTrustListSize                                                                                                      OpcuaNodeIdServicesVariableServer = 12640
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_MulticastDnsEnabled                                                                                                   OpcuaNodeIdServicesVariableServer = 12641
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                                              OpcuaNodeIdServicesVariableServer = 12643
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                                         OpcuaNodeIdServicesVariableServer = 12646
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                                               OpcuaNodeIdServicesVariableServer = 12648
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                                              OpcuaNodeIdServicesVariableServer = 12649
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                                              OpcuaNodeIdServicesVariableServer = 12651
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                                               OpcuaNodeIdServicesVariableServer = 12653
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                                              OpcuaNodeIdServicesVariableServer = 12654
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                                              OpcuaNodeIdServicesVariableServer = 12656
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                                        OpcuaNodeIdServicesVariableServer = 12658
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                                       OpcuaNodeIdServicesVariableServer = 12659
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                                        OpcuaNodeIdServicesVariableServer = 12661
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                                                    OpcuaNodeIdServicesVariableServer = 12662
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                                      OpcuaNodeIdServicesVariableServer = 12664
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                                     OpcuaNodeIdServicesVariableServer = 12665
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                                    OpcuaNodeIdServicesVariableServer = 12667
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                                     OpcuaNodeIdServicesVariableServer = 12669
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                                  OpcuaNodeIdServicesVariableServer = 12671
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ServerCapabilities                                                                                                OpcuaNodeIdServicesVariableServer = 12708
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_ServerCapabilities                                                                                                    OpcuaNodeIdServicesVariableServer = 12710
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_InputArguments                                                                               OpcuaNodeIdServicesVariableServer = 12732
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_OutputArguments                                                                              OpcuaNodeIdServicesVariableServer = 12733
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_InputArguments                                                                                   OpcuaNodeIdServicesVariableServer = 12738
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_OutputArguments                                                                                  OpcuaNodeIdServicesVariableServer = 12739
	OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_InputArguments                                                                                          OpcuaNodeIdServicesVariableServer = 12747
	OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_OutputArguments                                                                                         OpcuaNodeIdServicesVariableServer = 12748
	OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_InputArguments                                                                                              OpcuaNodeIdServicesVariableServer = 12750
	OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_OutputArguments                                                                                             OpcuaNodeIdServicesVariableServer = 12751
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetRejectedList_OutputArguments                                                                                   OpcuaNodeIdServicesVariableServer = 12776
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetRejectedList_OutputArguments                                                                                       OpcuaNodeIdServicesVariableServer = 12778
	OpcuaNodeIdServicesVariableServer_ServerType_ResendData_InputArguments                                                                                                      OpcuaNodeIdServicesVariableServer = 12872
	OpcuaNodeIdServicesVariableServer_Server_ResendData_InputArguments                                                                                                          OpcuaNodeIdServicesVariableServer = 12874
	OpcuaNodeIdServicesVariableServer_ServerType_EstimatedReturnTime                                                                                                            OpcuaNodeIdServicesVariableServer = 12882
	OpcuaNodeIdServicesVariableServer_ServerType_RequestServerStateChange_InputArguments                                                                                        OpcuaNodeIdServicesVariableServer = 12884
	OpcuaNodeIdServicesVariableServer_Server_EstimatedReturnTime                                                                                                                OpcuaNodeIdServicesVariableServer = 12885
	OpcuaNodeIdServicesVariableServer_Server_RequestServerStateChange_InputArguments                                                                                            OpcuaNodeIdServicesVariableServer = 12887
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxByteStringLength                                                                                         OpcuaNodeIdServicesVariableServer = 12909
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxByteStringLength                                                                                                OpcuaNodeIdServicesVariableServer = 12910
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxByteStringLength                                                                                             OpcuaNodeIdServicesVariableServer = 12911
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_InputArguments                                                                                      OpcuaNodeIdServicesVariableServer = 13738
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_OutputArguments                                                                                     OpcuaNodeIdServicesVariableServer = 13739
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                                          OpcuaNodeIdServicesVariableServer = 13953
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                                      OpcuaNodeIdServicesVariableServer = 13954
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                                                  OpcuaNodeIdServicesVariableServer = 13955
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                                     OpcuaNodeIdServicesVariableServer = 13956
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                                      OpcuaNodeIdServicesVariableServer = 13957
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                                           OpcuaNodeIdServicesVariableServer = 13959
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                                          OpcuaNodeIdServicesVariableServer = 13960
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                                          OpcuaNodeIdServicesVariableServer = 13962
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                                           OpcuaNodeIdServicesVariableServer = 13964
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                                          OpcuaNodeIdServicesVariableServer = 13965
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                                          OpcuaNodeIdServicesVariableServer = 13967
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                                    OpcuaNodeIdServicesVariableServer = 13969
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                                   OpcuaNodeIdServicesVariableServer = 13970
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                                    OpcuaNodeIdServicesVariableServer = 13972
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                                                OpcuaNodeIdServicesVariableServer = 13973
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                                  OpcuaNodeIdServicesVariableServer = 13975
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                                 OpcuaNodeIdServicesVariableServer = 13976
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                                 OpcuaNodeIdServicesVariableServer = 13978
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                                OpcuaNodeIdServicesVariableServer = 13979
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                                 OpcuaNodeIdServicesVariableServer = 13981
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                              OpcuaNodeIdServicesVariableServer = 13983
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                                        OpcuaNodeIdServicesVariableServer = 13984
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                                                OpcuaNodeIdServicesVariableServer = 13987
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                                            OpcuaNodeIdServicesVariableServer = 13988
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                                        OpcuaNodeIdServicesVariableServer = 13989
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                                           OpcuaNodeIdServicesVariableServer = 13990
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                                            OpcuaNodeIdServicesVariableServer = 13991
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                                                 OpcuaNodeIdServicesVariableServer = 13993
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                                                OpcuaNodeIdServicesVariableServer = 13994
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                                                OpcuaNodeIdServicesVariableServer = 13996
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                                                 OpcuaNodeIdServicesVariableServer = 13998
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                                                OpcuaNodeIdServicesVariableServer = 13999
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                                                OpcuaNodeIdServicesVariableServer = 14001
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                          OpcuaNodeIdServicesVariableServer = 14003
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                         OpcuaNodeIdServicesVariableServer = 14004
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                          OpcuaNodeIdServicesVariableServer = 14006
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                                      OpcuaNodeIdServicesVariableServer = 14007
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                        OpcuaNodeIdServicesVariableServer = 14009
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                       OpcuaNodeIdServicesVariableServer = 14010
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                       OpcuaNodeIdServicesVariableServer = 14012
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                      OpcuaNodeIdServicesVariableServer = 14013
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                       OpcuaNodeIdServicesVariableServer = 14015
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                                    OpcuaNodeIdServicesVariableServer = 14017
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                                              OpcuaNodeIdServicesVariableServer = 14018
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                                            OpcuaNodeIdServicesVariableServer = 14021
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                                        OpcuaNodeIdServicesVariableServer = 14022
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                                    OpcuaNodeIdServicesVariableServer = 14023
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                                       OpcuaNodeIdServicesVariableServer = 14024
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                                        OpcuaNodeIdServicesVariableServer = 14025
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                                             OpcuaNodeIdServicesVariableServer = 14027
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                            OpcuaNodeIdServicesVariableServer = 14028
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                                            OpcuaNodeIdServicesVariableServer = 14030
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                                             OpcuaNodeIdServicesVariableServer = 14032
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                            OpcuaNodeIdServicesVariableServer = 14033
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                                            OpcuaNodeIdServicesVariableServer = 14035
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                      OpcuaNodeIdServicesVariableServer = 14037
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                     OpcuaNodeIdServicesVariableServer = 14038
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                      OpcuaNodeIdServicesVariableServer = 14040
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                                                  OpcuaNodeIdServicesVariableServer = 14041
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                                    OpcuaNodeIdServicesVariableServer = 14043
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                                   OpcuaNodeIdServicesVariableServer = 14044
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                                   OpcuaNodeIdServicesVariableServer = 14046
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                                  OpcuaNodeIdServicesVariableServer = 14047
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                                   OpcuaNodeIdServicesVariableServer = 14049
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                                OpcuaNodeIdServicesVariableServer = 14051
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                                          OpcuaNodeIdServicesVariableServer = 14052
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                                                    OpcuaNodeIdServicesVariableServer = 14090
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                                                OpcuaNodeIdServicesVariableServer = 14091
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                                            OpcuaNodeIdServicesVariableServer = 14092
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                                               OpcuaNodeIdServicesVariableServer = 14093
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                                                OpcuaNodeIdServicesVariableServer = 14094
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                                                     OpcuaNodeIdServicesVariableServer = 14096
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                                                    OpcuaNodeIdServicesVariableServer = 14097
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                                                    OpcuaNodeIdServicesVariableServer = 14099
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                                                     OpcuaNodeIdServicesVariableServer = 14101
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                                                    OpcuaNodeIdServicesVariableServer = 14102
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                                                    OpcuaNodeIdServicesVariableServer = 14104
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                              OpcuaNodeIdServicesVariableServer = 14106
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                             OpcuaNodeIdServicesVariableServer = 14107
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                              OpcuaNodeIdServicesVariableServer = 14109
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                                          OpcuaNodeIdServicesVariableServer = 14110
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                            OpcuaNodeIdServicesVariableServer = 14112
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                           OpcuaNodeIdServicesVariableServer = 14113
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                           OpcuaNodeIdServicesVariableServer = 14115
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                          OpcuaNodeIdServicesVariableServer = 14116
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                           OpcuaNodeIdServicesVariableServer = 14118
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                                        OpcuaNodeIdServicesVariableServer = 14120
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                                                  OpcuaNodeIdServicesVariableServer = 14121
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                                                OpcuaNodeIdServicesVariableServer = 14124
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                                            OpcuaNodeIdServicesVariableServer = 14125
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                                        OpcuaNodeIdServicesVariableServer = 14126
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                                           OpcuaNodeIdServicesVariableServer = 14127
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                                            OpcuaNodeIdServicesVariableServer = 14128
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                                                 OpcuaNodeIdServicesVariableServer = 14130
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                                OpcuaNodeIdServicesVariableServer = 14131
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                                                OpcuaNodeIdServicesVariableServer = 14133
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                                                 OpcuaNodeIdServicesVariableServer = 14135
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                                OpcuaNodeIdServicesVariableServer = 14136
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                                                OpcuaNodeIdServicesVariableServer = 14138
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                          OpcuaNodeIdServicesVariableServer = 14140
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                         OpcuaNodeIdServicesVariableServer = 14141
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                          OpcuaNodeIdServicesVariableServer = 14143
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                                                      OpcuaNodeIdServicesVariableServer = 14144
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                                        OpcuaNodeIdServicesVariableServer = 14146
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                                       OpcuaNodeIdServicesVariableServer = 14147
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                                       OpcuaNodeIdServicesVariableServer = 14149
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                                      OpcuaNodeIdServicesVariableServer = 14150
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                                       OpcuaNodeIdServicesVariableServer = 14152
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                                    OpcuaNodeIdServicesVariableServer = 14154
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                                              OpcuaNodeIdServicesVariableServer = 14155
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                                          OpcuaNodeIdServicesVariableServer = 14157
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                                                      OpcuaNodeIdServicesVariableServer = 14158
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                                          OpcuaNodeIdServicesVariableServer = 14159
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                                     OpcuaNodeIdServicesVariableServer = 14160
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                                            OpcuaNodeIdServicesVariableServer = 14161
	OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerNetworkGroups                                                                                               OpcuaNodeIdServicesVariableServer = 14415
	OpcuaNodeIdServicesVariableServer_ServerType_UrisVersion                                                                                                                    OpcuaNodeIdServicesVariableServer = 15003
	OpcuaNodeIdServicesVariableServer_Server_UrisVersion                                                                                                                        OpcuaNodeIdServicesVariableServer = 15004
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments                                                                              OpcuaNodeIdServicesVariableServer = 16291
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments                                                                             OpcuaNodeIdServicesVariableServer = 16292
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments                                                                           OpcuaNodeIdServicesVariableServer = 16294
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_InputArguments                                                                                     OpcuaNodeIdServicesVariableServer = 16297
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_OutputArguments                                                                                    OpcuaNodeIdServicesVariableServer = 16298
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments                                                                                  OpcuaNodeIdServicesVariableServer = 16300
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_InputArguments                                                                                  OpcuaNodeIdServicesVariableServer = 16302
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_OutputArguments                                                                                 OpcuaNodeIdServicesVariableServer = 16303
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments                                                                               OpcuaNodeIdServicesVariableServer = 16305
	OpcuaNodeIdServicesVariableServer_ServerType_LocalTime                                                                                                                      OpcuaNodeIdServicesVariableServer = 17612
	OpcuaNodeIdServicesVariableServer_Server_LocalTime                                                                                                                          OpcuaNodeIdServicesVariableServer = 17634
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency                                               OpcuaNodeIdServicesVariableServer = 21679
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId                                              OpcuaNodeIdServicesVariableServer = 21681
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType                                            OpcuaNodeIdServicesVariableServer = 21682
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode                                           OpcuaNodeIdServicesVariableServer = 21683
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName                                           OpcuaNodeIdServicesVariableServer = 21684
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time                                                 OpcuaNodeIdServicesVariableServer = 21685
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime                                          OpcuaNodeIdServicesVariableServer = 21686
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime                                            OpcuaNodeIdServicesVariableServer = 21687
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message                                              OpcuaNodeIdServicesVariableServer = 21688
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity                                             OpcuaNodeIdServicesVariableServer = 21689
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId                                     OpcuaNodeIdServicesVariableServer = 21690
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName                                   OpcuaNodeIdServicesVariableServer = 21691
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId                                  OpcuaNodeIdServicesVariableServer = 21692
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName                                OpcuaNodeIdServicesVariableServer = 21693
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName                                        OpcuaNodeIdServicesVariableServer = 21694
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId                                             OpcuaNodeIdServicesVariableServer = 21695
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain                                               OpcuaNodeIdServicesVariableServer = 21696
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState                                         OpcuaNodeIdServicesVariableServer = 21697
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id                                      OpcuaNodeIdServicesVariableServer = 21698
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name                                    OpcuaNodeIdServicesVariableServer = 21699
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number                                  OpcuaNodeIdServicesVariableServer = 21700
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21701
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21702
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21703
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState                               OpcuaNodeIdServicesVariableServer = 21704
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState                              OpcuaNodeIdServicesVariableServer = 21705
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality                                              OpcuaNodeIdServicesVariableServer = 21706
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableServer = 21707
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity                                         OpcuaNodeIdServicesVariableServer = 21708
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableServer = 21709
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment                                              OpcuaNodeIdServicesVariableServer = 21710
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableServer = 21711
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId                                         OpcuaNodeIdServicesVariableServer = 21712
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments                            OpcuaNodeIdServicesVariableServer = 21716
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState                                           OpcuaNodeIdServicesVariableServer = 21717
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id                                        OpcuaNodeIdServicesVariableServer = 21718
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name                                      OpcuaNodeIdServicesVariableServer = 21719
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number                                    OpcuaNodeIdServicesVariableServer = 21720
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 21721
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 21722
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 21723
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 21724
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState                                OpcuaNodeIdServicesVariableServer = 21725
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState                                       OpcuaNodeIdServicesVariableServer = 21726
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableServer = 21727
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableServer = 21728
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number                                OpcuaNodeIdServicesVariableServer = 21729
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableServer = 21730
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableServer = 21731
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableServer = 21732
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableServer = 21733
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableServer = 21734
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableServer = 21736
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments                               OpcuaNodeIdServicesVariableServer = 21738
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState                                          OpcuaNodeIdServicesVariableServer = 21739
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id                                       OpcuaNodeIdServicesVariableServer = 21740
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name                                     OpcuaNodeIdServicesVariableServer = 21741
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number                                   OpcuaNodeIdServicesVariableServer = 21742
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 21743
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 21744
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 21745
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState                                OpcuaNodeIdServicesVariableServer = 21746
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState                               OpcuaNodeIdServicesVariableServer = 21747
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode                                            OpcuaNodeIdServicesVariableServer = 21748
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState                                      OpcuaNodeIdServicesVariableServer = 21749
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id                                   OpcuaNodeIdServicesVariableServer = 21750
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name                                 OpcuaNodeIdServicesVariableServer = 21751
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number                               OpcuaNodeIdServicesVariableServer = 21752
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableServer = 21753
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableServer = 21754
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableServer = 21755
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableServer = 21756
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableServer = 21757
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState                                    OpcuaNodeIdServicesVariableServer = 21758
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableServer = 21759
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableServer = 21760
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableServer = 21761
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableServer = 21762
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableServer = 21763
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableServer = 21764
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableServer = 21765
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableServer = 21766
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableServer = 21768
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableServer = 21769
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableServer = 21770
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableServer = 21771
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableServer = 21772
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableServer = 21773
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableServer = 21774
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableServer = 21775
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableServer = 21776
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableServer = 21777
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableServer = 21778
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableServer = 21779
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableServer = 21780
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableServer = 21781
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableServer = 21783
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableServer = 21786
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved                                       OpcuaNodeIdServicesVariableServer = 21787
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled                                       OpcuaNodeIdServicesVariableServer = 21788
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound                                         OpcuaNodeIdServicesVariableServer = 21789
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableServer = 21790
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableServer = 21791
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableServer = 21792
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState                                         OpcuaNodeIdServicesVariableServer = 21793
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id                                      OpcuaNodeIdServicesVariableServer = 21794
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name                                    OpcuaNodeIdServicesVariableServer = 21795
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number                                  OpcuaNodeIdServicesVariableServer = 21796
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21797
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21798
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21799
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState                               OpcuaNodeIdServicesVariableServer = 21800
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState                              OpcuaNodeIdServicesVariableServer = 21801
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay                                              OpcuaNodeIdServicesVariableServer = 21802
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay                                             OpcuaNodeIdServicesVariableServer = 21803
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableServer = 21804
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState                                         OpcuaNodeIdServicesVariableServer = 21806
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id                                      OpcuaNodeIdServicesVariableServer = 21807
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name                                    OpcuaNodeIdServicesVariableServer = 21808
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number                                  OpcuaNodeIdServicesVariableServer = 21809
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21810
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21811
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21812
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState                               OpcuaNodeIdServicesVariableServer = 21813
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState                              OpcuaNodeIdServicesVariableServer = 21814
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime                                          OpcuaNodeIdServicesVariableServer = 21815
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableServer = 21816
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState                                          OpcuaNodeIdServicesVariableServer = 21823
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate                                       OpcuaNodeIdServicesVariableServer = 21824
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit                                      OpcuaNodeIdServicesVariableServer = 21825
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType                                      OpcuaNodeIdServicesVariableServer = 21826
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate                                          OpcuaNodeIdServicesVariableServer = 21827
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId                                              OpcuaNodeIdServicesVariableServer = 21829
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType                                            OpcuaNodeIdServicesVariableServer = 21830
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode                                           OpcuaNodeIdServicesVariableServer = 21831
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName                                           OpcuaNodeIdServicesVariableServer = 21832
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time                                                 OpcuaNodeIdServicesVariableServer = 21833
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime                                          OpcuaNodeIdServicesVariableServer = 21834
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime                                            OpcuaNodeIdServicesVariableServer = 21835
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message                                              OpcuaNodeIdServicesVariableServer = 21836
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity                                             OpcuaNodeIdServicesVariableServer = 21837
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId                                     OpcuaNodeIdServicesVariableServer = 21838
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName                                   OpcuaNodeIdServicesVariableServer = 21839
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId                                  OpcuaNodeIdServicesVariableServer = 21840
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName                                OpcuaNodeIdServicesVariableServer = 21841
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName                                        OpcuaNodeIdServicesVariableServer = 21842
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId                                             OpcuaNodeIdServicesVariableServer = 21843
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain                                               OpcuaNodeIdServicesVariableServer = 21844
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState                                         OpcuaNodeIdServicesVariableServer = 21845
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id                                      OpcuaNodeIdServicesVariableServer = 21846
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name                                    OpcuaNodeIdServicesVariableServer = 21847
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number                                  OpcuaNodeIdServicesVariableServer = 21848
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21849
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21850
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21851
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState                               OpcuaNodeIdServicesVariableServer = 21852
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState                              OpcuaNodeIdServicesVariableServer = 21853
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality                                              OpcuaNodeIdServicesVariableServer = 21854
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableServer = 21855
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity                                         OpcuaNodeIdServicesVariableServer = 21856
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableServer = 21857
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment                                              OpcuaNodeIdServicesVariableServer = 21858
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableServer = 21859
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId                                         OpcuaNodeIdServicesVariableServer = 21860
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments                            OpcuaNodeIdServicesVariableServer = 21864
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState                                           OpcuaNodeIdServicesVariableServer = 21865
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id                                        OpcuaNodeIdServicesVariableServer = 21866
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name                                      OpcuaNodeIdServicesVariableServer = 21867
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number                                    OpcuaNodeIdServicesVariableServer = 21868
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 21869
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 21870
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 21871
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 21872
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState                                OpcuaNodeIdServicesVariableServer = 21873
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState                                       OpcuaNodeIdServicesVariableServer = 21874
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableServer = 21875
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableServer = 21876
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number                                OpcuaNodeIdServicesVariableServer = 21877
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableServer = 21878
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableServer = 21879
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableServer = 21880
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableServer = 21881
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableServer = 21882
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableServer = 21884
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments                               OpcuaNodeIdServicesVariableServer = 21886
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState                                          OpcuaNodeIdServicesVariableServer = 21887
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id                                       OpcuaNodeIdServicesVariableServer = 21888
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name                                     OpcuaNodeIdServicesVariableServer = 21889
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number                                   OpcuaNodeIdServicesVariableServer = 21890
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 21891
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 21892
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 21893
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState                                OpcuaNodeIdServicesVariableServer = 21894
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState                               OpcuaNodeIdServicesVariableServer = 21895
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode                                            OpcuaNodeIdServicesVariableServer = 21896
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState                                      OpcuaNodeIdServicesVariableServer = 21897
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id                                   OpcuaNodeIdServicesVariableServer = 21898
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name                                 OpcuaNodeIdServicesVariableServer = 21899
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number                               OpcuaNodeIdServicesVariableServer = 21900
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableServer = 21901
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableServer = 21902
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableServer = 21903
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableServer = 21904
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableServer = 21905
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState                                    OpcuaNodeIdServicesVariableServer = 21906
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableServer = 21907
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableServer = 21908
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableServer = 21909
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableServer = 21910
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableServer = 21911
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableServer = 21912
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableServer = 21913
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableServer = 21914
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableServer = 21916
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableServer = 21917
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableServer = 21918
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableServer = 21919
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableServer = 21920
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableServer = 21921
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableServer = 21922
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableServer = 21923
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableServer = 21924
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableServer = 21925
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableServer = 21926
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableServer = 21927
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableServer = 21928
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableServer = 21929
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableServer = 21931
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableServer = 21934
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved                                       OpcuaNodeIdServicesVariableServer = 21935
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled                                       OpcuaNodeIdServicesVariableServer = 21936
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound                                         OpcuaNodeIdServicesVariableServer = 21937
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableServer = 21938
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableServer = 21939
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableServer = 21940
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState                                         OpcuaNodeIdServicesVariableServer = 21941
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id                                      OpcuaNodeIdServicesVariableServer = 21942
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name                                    OpcuaNodeIdServicesVariableServer = 21943
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number                                  OpcuaNodeIdServicesVariableServer = 21944
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21945
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21946
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21947
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState                               OpcuaNodeIdServicesVariableServer = 21948
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState                              OpcuaNodeIdServicesVariableServer = 21949
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay                                              OpcuaNodeIdServicesVariableServer = 21950
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay                                             OpcuaNodeIdServicesVariableServer = 21951
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableServer = 21952
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState                                         OpcuaNodeIdServicesVariableServer = 21954
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id                                      OpcuaNodeIdServicesVariableServer = 21955
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name                                    OpcuaNodeIdServicesVariableServer = 21956
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number                                  OpcuaNodeIdServicesVariableServer = 21957
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 21958
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 21959
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 21960
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState                               OpcuaNodeIdServicesVariableServer = 21961
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState                              OpcuaNodeIdServicesVariableServer = 21962
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime                                          OpcuaNodeIdServicesVariableServer = 21963
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableServer = 21964
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState                                          OpcuaNodeIdServicesVariableServer = 21971
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId                                          OpcuaNodeIdServicesVariableServer = 21972
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime                                       OpcuaNodeIdServicesVariableServer = 21973
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency                                      OpcuaNodeIdServicesVariableServer = 21974
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency                                                     OpcuaNodeIdServicesVariableServer = 21975
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId                                                    OpcuaNodeIdServicesVariableServer = 21977
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType                                                  OpcuaNodeIdServicesVariableServer = 21978
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode                                                 OpcuaNodeIdServicesVariableServer = 21979
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName                                                 OpcuaNodeIdServicesVariableServer = 21980
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time                                                       OpcuaNodeIdServicesVariableServer = 21981
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime                                                OpcuaNodeIdServicesVariableServer = 21982
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime                                                  OpcuaNodeIdServicesVariableServer = 21983
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message                                                    OpcuaNodeIdServicesVariableServer = 21984
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity                                                   OpcuaNodeIdServicesVariableServer = 21985
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId                                           OpcuaNodeIdServicesVariableServer = 21986
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName                                         OpcuaNodeIdServicesVariableServer = 21987
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId                                        OpcuaNodeIdServicesVariableServer = 21988
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName                                      OpcuaNodeIdServicesVariableServer = 21989
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName                                              OpcuaNodeIdServicesVariableServer = 21990
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId                                                   OpcuaNodeIdServicesVariableServer = 21991
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain                                                     OpcuaNodeIdServicesVariableServer = 21992
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState                                               OpcuaNodeIdServicesVariableServer = 21993
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id                                            OpcuaNodeIdServicesVariableServer = 21994
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name                                          OpcuaNodeIdServicesVariableServer = 21995
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number                                        OpcuaNodeIdServicesVariableServer = 21996
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 21997
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 21998
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 21999
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22000
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22001
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality                                                    OpcuaNodeIdServicesVariableServer = 22002
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 22003
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity                                               OpcuaNodeIdServicesVariableServer = 22004
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableServer = 22005
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment                                                    OpcuaNodeIdServicesVariableServer = 22006
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 22007
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId                                               OpcuaNodeIdServicesVariableServer = 22008
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableServer = 22012
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState                                                 OpcuaNodeIdServicesVariableServer = 22013
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id                                              OpcuaNodeIdServicesVariableServer = 22014
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name                                            OpcuaNodeIdServicesVariableServer = 22015
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number                                          OpcuaNodeIdServicesVariableServer = 22016
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 22017
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 22018
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 22019
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 22020
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 22021
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState                                             OpcuaNodeIdServicesVariableServer = 22022
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableServer = 22023
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableServer = 22024
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableServer = 22025
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22026
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22027
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22028
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22029
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22030
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableServer = 22032
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableServer = 22034
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState                                                OpcuaNodeIdServicesVariableServer = 22035
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id                                             OpcuaNodeIdServicesVariableServer = 22036
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name                                           OpcuaNodeIdServicesVariableServer = 22037
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number                                         OpcuaNodeIdServicesVariableServer = 22038
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 22039
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 22040
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 22041
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableServer = 22042
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableServer = 22043
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode                                                  OpcuaNodeIdServicesVariableServer = 22044
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState                                            OpcuaNodeIdServicesVariableServer = 22045
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id                                         OpcuaNodeIdServicesVariableServer = 22046
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name                                       OpcuaNodeIdServicesVariableServer = 22047
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number                                     OpcuaNodeIdServicesVariableServer = 22048
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 22049
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 22050
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 22051
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableServer = 22052
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableServer = 22053
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState                                          OpcuaNodeIdServicesVariableServer = 22054
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableServer = 22055
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableServer = 22056
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableServer = 22057
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 22058
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 22059
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 22060
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableServer = 22061
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableServer = 22062
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableServer = 22064
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableServer = 22065
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableServer = 22066
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableServer = 22067
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableServer = 22068
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableServer = 22069
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableServer = 22070
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableServer = 22071
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableServer = 22072
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableServer = 22073
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableServer = 22074
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableServer = 22075
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableServer = 22076
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableServer = 22077
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableServer = 22079
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableServer = 22082
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved                                             OpcuaNodeIdServicesVariableServer = 22083
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled                                             OpcuaNodeIdServicesVariableServer = 22084
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound                                               OpcuaNodeIdServicesVariableServer = 22085
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableServer = 22086
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableServer = 22087
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableServer = 22088
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState                                               OpcuaNodeIdServicesVariableServer = 22089
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id                                            OpcuaNodeIdServicesVariableServer = 22090
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name                                          OpcuaNodeIdServicesVariableServer = 22091
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number                                        OpcuaNodeIdServicesVariableServer = 22092
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22093
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22094
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22095
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22096
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22097
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay                                                    OpcuaNodeIdServicesVariableServer = 22098
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay                                                   OpcuaNodeIdServicesVariableServer = 22099
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableServer = 22100
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState                                               OpcuaNodeIdServicesVariableServer = 22102
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id                                            OpcuaNodeIdServicesVariableServer = 22103
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name                                          OpcuaNodeIdServicesVariableServer = 22104
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number                                        OpcuaNodeIdServicesVariableServer = 22105
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22106
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22107
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22108
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22109
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22110
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime                                                OpcuaNodeIdServicesVariableServer = 22111
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableServer = 22112
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState                                                OpcuaNodeIdServicesVariableServer = 22119
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate                                             OpcuaNodeIdServicesVariableServer = 22120
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit                                            OpcuaNodeIdServicesVariableServer = 22121
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType                                            OpcuaNodeIdServicesVariableServer = 22122
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate                                                OpcuaNodeIdServicesVariableServer = 22123
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId                                                    OpcuaNodeIdServicesVariableServer = 22125
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType                                                  OpcuaNodeIdServicesVariableServer = 22126
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode                                                 OpcuaNodeIdServicesVariableServer = 22127
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName                                                 OpcuaNodeIdServicesVariableServer = 22128
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time                                                       OpcuaNodeIdServicesVariableServer = 22129
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime                                                OpcuaNodeIdServicesVariableServer = 22130
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime                                                  OpcuaNodeIdServicesVariableServer = 22131
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message                                                    OpcuaNodeIdServicesVariableServer = 22132
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity                                                   OpcuaNodeIdServicesVariableServer = 22133
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId                                           OpcuaNodeIdServicesVariableServer = 22134
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName                                         OpcuaNodeIdServicesVariableServer = 22135
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId                                        OpcuaNodeIdServicesVariableServer = 22136
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName                                      OpcuaNodeIdServicesVariableServer = 22137
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName                                              OpcuaNodeIdServicesVariableServer = 22138
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId                                                   OpcuaNodeIdServicesVariableServer = 22139
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain                                                     OpcuaNodeIdServicesVariableServer = 22140
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState                                               OpcuaNodeIdServicesVariableServer = 22141
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id                                            OpcuaNodeIdServicesVariableServer = 22142
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name                                          OpcuaNodeIdServicesVariableServer = 22143
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number                                        OpcuaNodeIdServicesVariableServer = 22144
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22145
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22146
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22147
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22148
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22149
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality                                                    OpcuaNodeIdServicesVariableServer = 22150
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 22151
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity                                               OpcuaNodeIdServicesVariableServer = 22152
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableServer = 22153
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment                                                    OpcuaNodeIdServicesVariableServer = 22154
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 22155
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId                                               OpcuaNodeIdServicesVariableServer = 22156
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableServer = 22160
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState                                                 OpcuaNodeIdServicesVariableServer = 22161
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id                                              OpcuaNodeIdServicesVariableServer = 22162
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name                                            OpcuaNodeIdServicesVariableServer = 22163
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number                                          OpcuaNodeIdServicesVariableServer = 22164
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 22165
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 22166
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 22167
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 22168
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 22169
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState                                             OpcuaNodeIdServicesVariableServer = 22170
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableServer = 22171
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableServer = 22172
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableServer = 22173
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22174
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22175
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22176
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22177
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22178
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableServer = 22180
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableServer = 22182
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState                                                OpcuaNodeIdServicesVariableServer = 22183
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id                                             OpcuaNodeIdServicesVariableServer = 22184
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name                                           OpcuaNodeIdServicesVariableServer = 22185
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number                                         OpcuaNodeIdServicesVariableServer = 22186
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 22187
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 22188
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 22189
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableServer = 22190
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableServer = 22191
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode                                                  OpcuaNodeIdServicesVariableServer = 22192
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState                                            OpcuaNodeIdServicesVariableServer = 22193
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id                                         OpcuaNodeIdServicesVariableServer = 22194
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name                                       OpcuaNodeIdServicesVariableServer = 22195
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number                                     OpcuaNodeIdServicesVariableServer = 22196
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 22197
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 22198
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 22199
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableServer = 22200
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableServer = 22201
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState                                          OpcuaNodeIdServicesVariableServer = 22202
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableServer = 22203
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableServer = 22204
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableServer = 22205
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 22206
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 22207
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 22208
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableServer = 22209
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableServer = 22210
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableServer = 22212
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableServer = 22213
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableServer = 22214
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableServer = 22215
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableServer = 22216
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableServer = 22217
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableServer = 22218
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableServer = 22219
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableServer = 22220
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableServer = 22221
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableServer = 22222
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableServer = 22223
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableServer = 22224
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableServer = 22225
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableServer = 22227
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableServer = 22230
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved                                             OpcuaNodeIdServicesVariableServer = 22231
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled                                             OpcuaNodeIdServicesVariableServer = 22232
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound                                               OpcuaNodeIdServicesVariableServer = 22233
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableServer = 22234
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableServer = 22235
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableServer = 22236
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState                                               OpcuaNodeIdServicesVariableServer = 22237
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id                                            OpcuaNodeIdServicesVariableServer = 22238
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name                                          OpcuaNodeIdServicesVariableServer = 22239
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number                                        OpcuaNodeIdServicesVariableServer = 22240
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22241
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22242
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22243
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22244
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22245
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay                                                    OpcuaNodeIdServicesVariableServer = 22246
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay                                                   OpcuaNodeIdServicesVariableServer = 22247
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableServer = 22248
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState                                               OpcuaNodeIdServicesVariableServer = 22250
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id                                            OpcuaNodeIdServicesVariableServer = 22251
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name                                          OpcuaNodeIdServicesVariableServer = 22252
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number                                        OpcuaNodeIdServicesVariableServer = 22253
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22254
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22255
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22256
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22257
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22258
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime                                                OpcuaNodeIdServicesVariableServer = 22259
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableServer = 22260
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState                                                OpcuaNodeIdServicesVariableServer = 22267
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId                                                OpcuaNodeIdServicesVariableServer = 22268
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime                                             OpcuaNodeIdServicesVariableServer = 22269
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency                                            OpcuaNodeIdServicesVariableServer = 22270
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency                                                 OpcuaNodeIdServicesVariableServer = 22271
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId                                                OpcuaNodeIdServicesVariableServer = 22273
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType                                              OpcuaNodeIdServicesVariableServer = 22274
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode                                             OpcuaNodeIdServicesVariableServer = 22275
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName                                             OpcuaNodeIdServicesVariableServer = 22276
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time                                                   OpcuaNodeIdServicesVariableServer = 22277
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime                                            OpcuaNodeIdServicesVariableServer = 22278
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime                                              OpcuaNodeIdServicesVariableServer = 22279
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message                                                OpcuaNodeIdServicesVariableServer = 22280
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity                                               OpcuaNodeIdServicesVariableServer = 22281
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId                                       OpcuaNodeIdServicesVariableServer = 22282
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName                                     OpcuaNodeIdServicesVariableServer = 22283
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId                                    OpcuaNodeIdServicesVariableServer = 22284
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName                                  OpcuaNodeIdServicesVariableServer = 22285
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName                                          OpcuaNodeIdServicesVariableServer = 22286
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId                                               OpcuaNodeIdServicesVariableServer = 22287
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain                                                 OpcuaNodeIdServicesVariableServer = 22288
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState                                           OpcuaNodeIdServicesVariableServer = 22289
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id                                        OpcuaNodeIdServicesVariableServer = 22290
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name                                      OpcuaNodeIdServicesVariableServer = 22291
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number                                    OpcuaNodeIdServicesVariableServer = 22292
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22293
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22294
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22295
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22296
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState                                OpcuaNodeIdServicesVariableServer = 22297
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality                                                OpcuaNodeIdServicesVariableServer = 22298
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableServer = 22299
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity                                           OpcuaNodeIdServicesVariableServer = 22300
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableServer = 22301
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment                                                OpcuaNodeIdServicesVariableServer = 22302
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableServer = 22303
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId                                           OpcuaNodeIdServicesVariableServer = 22304
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments                              OpcuaNodeIdServicesVariableServer = 22308
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState                                             OpcuaNodeIdServicesVariableServer = 22309
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id                                          OpcuaNodeIdServicesVariableServer = 22310
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name                                        OpcuaNodeIdServicesVariableServer = 22311
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number                                      OpcuaNodeIdServicesVariableServer = 22312
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22313
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22314
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22315
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22316
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22317
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState                                         OpcuaNodeIdServicesVariableServer = 22318
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableServer = 22319
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableServer = 22320
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableServer = 22321
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 22322
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 22323
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 22324
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableServer = 22325
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableServer = 22326
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableServer = 22328
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableServer = 22330
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState                                            OpcuaNodeIdServicesVariableServer = 22331
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id                                         OpcuaNodeIdServicesVariableServer = 22332
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name                                       OpcuaNodeIdServicesVariableServer = 22333
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number                                     OpcuaNodeIdServicesVariableServer = 22334
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 22335
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 22336
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 22337
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableServer = 22338
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableServer = 22339
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode                                              OpcuaNodeIdServicesVariableServer = 22340
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState                                        OpcuaNodeIdServicesVariableServer = 22341
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id                                     OpcuaNodeIdServicesVariableServer = 22342
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name                                   OpcuaNodeIdServicesVariableServer = 22343
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number                                 OpcuaNodeIdServicesVariableServer = 22344
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableServer = 22345
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableServer = 22346
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableServer = 22347
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableServer = 22348
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableServer = 22349
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState                                      OpcuaNodeIdServicesVariableServer = 22350
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableServer = 22351
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableServer = 22352
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableServer = 22353
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableServer = 22354
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableServer = 22355
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableServer = 22356
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableServer = 22357
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableServer = 22358
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableServer = 22360
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableServer = 22361
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableServer = 22362
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableServer = 22363
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableServer = 22364
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableServer = 22365
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableServer = 22366
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableServer = 22367
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableServer = 22368
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableServer = 22369
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableServer = 22370
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableServer = 22371
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableServer = 22372
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableServer = 22373
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableServer = 22375
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableServer = 22378
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved                                         OpcuaNodeIdServicesVariableServer = 22379
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled                                         OpcuaNodeIdServicesVariableServer = 22380
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound                                           OpcuaNodeIdServicesVariableServer = 22381
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableServer = 22382
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableServer = 22383
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableServer = 22384
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState                                           OpcuaNodeIdServicesVariableServer = 22385
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id                                        OpcuaNodeIdServicesVariableServer = 22386
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name                                      OpcuaNodeIdServicesVariableServer = 22387
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number                                    OpcuaNodeIdServicesVariableServer = 22388
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22389
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22390
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22391
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22392
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState                                OpcuaNodeIdServicesVariableServer = 22393
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay                                                OpcuaNodeIdServicesVariableServer = 22394
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay                                               OpcuaNodeIdServicesVariableServer = 22395
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableServer = 22396
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState                                           OpcuaNodeIdServicesVariableServer = 22398
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id                                        OpcuaNodeIdServicesVariableServer = 22399
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name                                      OpcuaNodeIdServicesVariableServer = 22400
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number                                    OpcuaNodeIdServicesVariableServer = 22401
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22402
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22403
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22404
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22405
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState                                OpcuaNodeIdServicesVariableServer = 22406
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime                                            OpcuaNodeIdServicesVariableServer = 22407
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableServer = 22408
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState                                            OpcuaNodeIdServicesVariableServer = 22415
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate                                         OpcuaNodeIdServicesVariableServer = 22416
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit                                        OpcuaNodeIdServicesVariableServer = 22417
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType                                        OpcuaNodeIdServicesVariableServer = 22418
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate                                            OpcuaNodeIdServicesVariableServer = 22419
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId                                                OpcuaNodeIdServicesVariableServer = 22421
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType                                              OpcuaNodeIdServicesVariableServer = 22422
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode                                             OpcuaNodeIdServicesVariableServer = 22423
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName                                             OpcuaNodeIdServicesVariableServer = 22424
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time                                                   OpcuaNodeIdServicesVariableServer = 22425
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime                                            OpcuaNodeIdServicesVariableServer = 22426
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime                                              OpcuaNodeIdServicesVariableServer = 22427
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message                                                OpcuaNodeIdServicesVariableServer = 22428
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity                                               OpcuaNodeIdServicesVariableServer = 22429
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId                                       OpcuaNodeIdServicesVariableServer = 22430
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName                                     OpcuaNodeIdServicesVariableServer = 22431
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId                                    OpcuaNodeIdServicesVariableServer = 22432
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName                                  OpcuaNodeIdServicesVariableServer = 22433
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName                                          OpcuaNodeIdServicesVariableServer = 22434
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId                                               OpcuaNodeIdServicesVariableServer = 22435
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain                                                 OpcuaNodeIdServicesVariableServer = 22436
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState                                           OpcuaNodeIdServicesVariableServer = 22437
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id                                        OpcuaNodeIdServicesVariableServer = 22438
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name                                      OpcuaNodeIdServicesVariableServer = 22439
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number                                    OpcuaNodeIdServicesVariableServer = 22440
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22441
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22442
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22443
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22444
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState                                OpcuaNodeIdServicesVariableServer = 22445
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality                                                OpcuaNodeIdServicesVariableServer = 22446
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableServer = 22447
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity                                           OpcuaNodeIdServicesVariableServer = 22448
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableServer = 22449
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment                                                OpcuaNodeIdServicesVariableServer = 22450
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableServer = 22451
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId                                           OpcuaNodeIdServicesVariableServer = 22452
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments                              OpcuaNodeIdServicesVariableServer = 22456
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState                                             OpcuaNodeIdServicesVariableServer = 22457
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id                                          OpcuaNodeIdServicesVariableServer = 22458
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name                                        OpcuaNodeIdServicesVariableServer = 22459
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number                                      OpcuaNodeIdServicesVariableServer = 22460
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22461
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22462
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22463
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22464
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22465
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState                                         OpcuaNodeIdServicesVariableServer = 22466
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableServer = 22467
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableServer = 22468
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableServer = 22469
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableServer = 22470
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableServer = 22471
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableServer = 22472
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableServer = 22473
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableServer = 22474
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableServer = 22476
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableServer = 22478
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState                                            OpcuaNodeIdServicesVariableServer = 22479
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id                                         OpcuaNodeIdServicesVariableServer = 22480
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name                                       OpcuaNodeIdServicesVariableServer = 22481
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number                                     OpcuaNodeIdServicesVariableServer = 22482
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 22483
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 22484
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 22485
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableServer = 22486
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableServer = 22487
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode                                              OpcuaNodeIdServicesVariableServer = 22488
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState                                        OpcuaNodeIdServicesVariableServer = 22489
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id                                     OpcuaNodeIdServicesVariableServer = 22490
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name                                   OpcuaNodeIdServicesVariableServer = 22491
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number                                 OpcuaNodeIdServicesVariableServer = 22492
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableServer = 22493
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableServer = 22494
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableServer = 22495
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableServer = 22496
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableServer = 22497
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState                                      OpcuaNodeIdServicesVariableServer = 22498
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableServer = 22499
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableServer = 22500
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableServer = 22501
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableServer = 22502
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableServer = 22503
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableServer = 22504
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableServer = 22505
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableServer = 22506
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableServer = 22508
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableServer = 22509
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableServer = 22510
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableServer = 22511
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableServer = 22512
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableServer = 22513
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableServer = 22514
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableServer = 22515
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableServer = 22516
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableServer = 22517
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableServer = 22518
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableServer = 22519
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableServer = 22520
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableServer = 22521
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableServer = 22523
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableServer = 22526
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved                                         OpcuaNodeIdServicesVariableServer = 22527
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled                                         OpcuaNodeIdServicesVariableServer = 22528
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound                                           OpcuaNodeIdServicesVariableServer = 22529
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableServer = 22530
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableServer = 22531
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableServer = 22532
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState                                           OpcuaNodeIdServicesVariableServer = 22533
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id                                        OpcuaNodeIdServicesVariableServer = 22534
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name                                      OpcuaNodeIdServicesVariableServer = 22535
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number                                    OpcuaNodeIdServicesVariableServer = 22536
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22537
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22538
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22539
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22540
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState                                OpcuaNodeIdServicesVariableServer = 22541
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay                                                OpcuaNodeIdServicesVariableServer = 22542
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay                                               OpcuaNodeIdServicesVariableServer = 22543
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableServer = 22544
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState                                           OpcuaNodeIdServicesVariableServer = 22546
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id                                        OpcuaNodeIdServicesVariableServer = 22547
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name                                      OpcuaNodeIdServicesVariableServer = 22548
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number                                    OpcuaNodeIdServicesVariableServer = 22549
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22550
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22551
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22552
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22553
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState                                OpcuaNodeIdServicesVariableServer = 22554
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime                                            OpcuaNodeIdServicesVariableServer = 22555
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableServer = 22556
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState                                            OpcuaNodeIdServicesVariableServer = 22563
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId                                            OpcuaNodeIdServicesVariableServer = 22564
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime                                         OpcuaNodeIdServicesVariableServer = 22565
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency                                        OpcuaNodeIdServicesVariableServer = 22566
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency                                                   OpcuaNodeIdServicesVariableServer = 22567
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId                                                  OpcuaNodeIdServicesVariableServer = 22569
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType                                                OpcuaNodeIdServicesVariableServer = 22570
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode                                               OpcuaNodeIdServicesVariableServer = 22571
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName                                               OpcuaNodeIdServicesVariableServer = 22572
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time                                                     OpcuaNodeIdServicesVariableServer = 22573
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime                                              OpcuaNodeIdServicesVariableServer = 22574
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime                                                OpcuaNodeIdServicesVariableServer = 22575
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message                                                  OpcuaNodeIdServicesVariableServer = 22576
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity                                                 OpcuaNodeIdServicesVariableServer = 22577
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId                                         OpcuaNodeIdServicesVariableServer = 22578
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName                                       OpcuaNodeIdServicesVariableServer = 22579
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId                                      OpcuaNodeIdServicesVariableServer = 22580
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName                                    OpcuaNodeIdServicesVariableServer = 22581
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName                                            OpcuaNodeIdServicesVariableServer = 22582
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId                                                 OpcuaNodeIdServicesVariableServer = 22583
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain                                                   OpcuaNodeIdServicesVariableServer = 22584
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState                                             OpcuaNodeIdServicesVariableServer = 22585
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id                                          OpcuaNodeIdServicesVariableServer = 22586
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name                                        OpcuaNodeIdServicesVariableServer = 22587
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number                                      OpcuaNodeIdServicesVariableServer = 22588
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22589
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22590
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22591
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22592
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22593
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality                                                  OpcuaNodeIdServicesVariableServer = 22594
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp                                  OpcuaNodeIdServicesVariableServer = 22595
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity                                             OpcuaNodeIdServicesVariableServer = 22596
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp                             OpcuaNodeIdServicesVariableServer = 22597
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment                                                  OpcuaNodeIdServicesVariableServer = 22598
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp                                  OpcuaNodeIdServicesVariableServer = 22599
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId                                             OpcuaNodeIdServicesVariableServer = 22600
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments                                OpcuaNodeIdServicesVariableServer = 22604
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState                                               OpcuaNodeIdServicesVariableServer = 22605
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id                                            OpcuaNodeIdServicesVariableServer = 22606
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name                                          OpcuaNodeIdServicesVariableServer = 22607
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number                                        OpcuaNodeIdServicesVariableServer = 22608
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22609
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22610
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22611
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22612
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22613
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState                                           OpcuaNodeIdServicesVariableServer = 22614
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id                                        OpcuaNodeIdServicesVariableServer = 22615
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name                                      OpcuaNodeIdServicesVariableServer = 22616
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number                                    OpcuaNodeIdServicesVariableServer = 22617
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22618
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22619
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22620
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22621
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState                                OpcuaNodeIdServicesVariableServer = 22622
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments                               OpcuaNodeIdServicesVariableServer = 22624
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments                                   OpcuaNodeIdServicesVariableServer = 22626
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState                                              OpcuaNodeIdServicesVariableServer = 22627
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id                                           OpcuaNodeIdServicesVariableServer = 22628
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name                                         OpcuaNodeIdServicesVariableServer = 22629
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number                                       OpcuaNodeIdServicesVariableServer = 22630
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableServer = 22631
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime                               OpcuaNodeIdServicesVariableServer = 22632
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableServer = 22633
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState                                    OpcuaNodeIdServicesVariableServer = 22634
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState                                   OpcuaNodeIdServicesVariableServer = 22635
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode                                                OpcuaNodeIdServicesVariableServer = 22636
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState                                          OpcuaNodeIdServicesVariableServer = 22637
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id                                       OpcuaNodeIdServicesVariableServer = 22638
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name                                     OpcuaNodeIdServicesVariableServer = 22639
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number                                   OpcuaNodeIdServicesVariableServer = 22640
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 22641
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 22642
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 22643
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState                                OpcuaNodeIdServicesVariableServer = 22644
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState                               OpcuaNodeIdServicesVariableServer = 22645
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState                                        OpcuaNodeIdServicesVariableServer = 22646
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id                                     OpcuaNodeIdServicesVariableServer = 22647
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name                                   OpcuaNodeIdServicesVariableServer = 22648
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number                                 OpcuaNodeIdServicesVariableServer = 22649
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableServer = 22650
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime                         OpcuaNodeIdServicesVariableServer = 22651
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableServer = 22652
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState                              OpcuaNodeIdServicesVariableServer = 22653
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState                             OpcuaNodeIdServicesVariableServer = 22654
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState                               OpcuaNodeIdServicesVariableServer = 22656
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id                            OpcuaNodeIdServicesVariableServer = 22657
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name                          OpcuaNodeIdServicesVariableServer = 22658
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number                        OpcuaNodeIdServicesVariableServer = 22659
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName          OpcuaNodeIdServicesVariableServer = 22660
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition                             OpcuaNodeIdServicesVariableServer = 22661
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id                          OpcuaNodeIdServicesVariableServer = 22662
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name                        OpcuaNodeIdServicesVariableServer = 22663
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number                      OpcuaNodeIdServicesVariableServer = 22664
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime              OpcuaNodeIdServicesVariableServer = 22665
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime     OpcuaNodeIdServicesVariableServer = 22666
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates                            OpcuaNodeIdServicesVariableServer = 22667
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions                       OpcuaNodeIdServicesVariableServer = 22668
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime                               OpcuaNodeIdServicesVariableServer = 22669
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                 OpcuaNodeIdServicesVariableServer = 22671
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved                                      OpcuaNodeIdServicesVariableServer = 22674
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved                                           OpcuaNodeIdServicesVariableServer = 22675
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled                                           OpcuaNodeIdServicesVariableServer = 22676
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound                                             OpcuaNodeIdServicesVariableServer = 22677
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId                                      OpcuaNodeIdServicesVariableServer = 22678
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId                                    OpcuaNodeIdServicesVariableServer = 22679
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId                                   OpcuaNodeIdServicesVariableServer = 22680
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState                                             OpcuaNodeIdServicesVariableServer = 22681
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id                                          OpcuaNodeIdServicesVariableServer = 22682
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name                                        OpcuaNodeIdServicesVariableServer = 22683
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number                                      OpcuaNodeIdServicesVariableServer = 22684
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22685
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22686
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22687
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22688
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22689
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay                                                  OpcuaNodeIdServicesVariableServer = 22690
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay                                                 OpcuaNodeIdServicesVariableServer = 22691
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag                                         OpcuaNodeIdServicesVariableServer = 22692
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState                                             OpcuaNodeIdServicesVariableServer = 22694
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id                                          OpcuaNodeIdServicesVariableServer = 22695
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name                                        OpcuaNodeIdServicesVariableServer = 22696
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number                                      OpcuaNodeIdServicesVariableServer = 22697
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22698
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22699
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22700
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22701
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22702
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime                                              OpcuaNodeIdServicesVariableServer = 22703
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount                                       OpcuaNodeIdServicesVariableServer = 22704
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState                                              OpcuaNodeIdServicesVariableServer = 22711
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate                                           OpcuaNodeIdServicesVariableServer = 22712
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit                                          OpcuaNodeIdServicesVariableServer = 22713
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType                                          OpcuaNodeIdServicesVariableServer = 22714
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate                                              OpcuaNodeIdServicesVariableServer = 22715
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId                                                  OpcuaNodeIdServicesVariableServer = 22717
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType                                                OpcuaNodeIdServicesVariableServer = 22718
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode                                               OpcuaNodeIdServicesVariableServer = 22719
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName                                               OpcuaNodeIdServicesVariableServer = 22720
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time                                                     OpcuaNodeIdServicesVariableServer = 22721
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime                                              OpcuaNodeIdServicesVariableServer = 22722
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime                                                OpcuaNodeIdServicesVariableServer = 22723
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message                                                  OpcuaNodeIdServicesVariableServer = 22724
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity                                                 OpcuaNodeIdServicesVariableServer = 22725
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId                                         OpcuaNodeIdServicesVariableServer = 22726
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName                                       OpcuaNodeIdServicesVariableServer = 22727
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId                                      OpcuaNodeIdServicesVariableServer = 22728
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName                                    OpcuaNodeIdServicesVariableServer = 22729
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName                                            OpcuaNodeIdServicesVariableServer = 22730
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId                                                 OpcuaNodeIdServicesVariableServer = 22731
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain                                                   OpcuaNodeIdServicesVariableServer = 22732
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState                                             OpcuaNodeIdServicesVariableServer = 22733
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id                                          OpcuaNodeIdServicesVariableServer = 22734
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name                                        OpcuaNodeIdServicesVariableServer = 22735
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number                                      OpcuaNodeIdServicesVariableServer = 22736
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22737
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22738
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22739
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22740
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22741
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality                                                  OpcuaNodeIdServicesVariableServer = 22742
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp                                  OpcuaNodeIdServicesVariableServer = 22743
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity                                             OpcuaNodeIdServicesVariableServer = 22744
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                             OpcuaNodeIdServicesVariableServer = 22745
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment                                                  OpcuaNodeIdServicesVariableServer = 22746
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp                                  OpcuaNodeIdServicesVariableServer = 22747
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId                                             OpcuaNodeIdServicesVariableServer = 22748
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments                                OpcuaNodeIdServicesVariableServer = 22752
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState                                               OpcuaNodeIdServicesVariableServer = 22753
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id                                            OpcuaNodeIdServicesVariableServer = 22754
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name                                          OpcuaNodeIdServicesVariableServer = 22755
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number                                        OpcuaNodeIdServicesVariableServer = 22756
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 22757
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 22758
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 22759
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 22760
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 22761
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState                                           OpcuaNodeIdServicesVariableServer = 22762
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id                                        OpcuaNodeIdServicesVariableServer = 22763
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name                                      OpcuaNodeIdServicesVariableServer = 22764
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number                                    OpcuaNodeIdServicesVariableServer = 22765
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableServer = 22766
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                            OpcuaNodeIdServicesVariableServer = 22767
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableServer = 22768
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState                                 OpcuaNodeIdServicesVariableServer = 22769
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState                                OpcuaNodeIdServicesVariableServer = 22770
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments                               OpcuaNodeIdServicesVariableServer = 22772
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments                                   OpcuaNodeIdServicesVariableServer = 22774
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState                                              OpcuaNodeIdServicesVariableServer = 22775
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id                                           OpcuaNodeIdServicesVariableServer = 22776
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name                                         OpcuaNodeIdServicesVariableServer = 22777
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number                                       OpcuaNodeIdServicesVariableServer = 22778
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableServer = 22779
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime                               OpcuaNodeIdServicesVariableServer = 22780
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableServer = 22781
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState                                    OpcuaNodeIdServicesVariableServer = 22782
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState                                   OpcuaNodeIdServicesVariableServer = 22783
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode                                                OpcuaNodeIdServicesVariableServer = 22784
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState                                          OpcuaNodeIdServicesVariableServer = 22785
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id                                       OpcuaNodeIdServicesVariableServer = 22786
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name                                     OpcuaNodeIdServicesVariableServer = 22787
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number                                   OpcuaNodeIdServicesVariableServer = 22788
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 22789
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 22790
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 22791
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState                                OpcuaNodeIdServicesVariableServer = 22792
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState                               OpcuaNodeIdServicesVariableServer = 22793
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState                                        OpcuaNodeIdServicesVariableServer = 22794
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id                                     OpcuaNodeIdServicesVariableServer = 22795
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name                                   OpcuaNodeIdServicesVariableServer = 22796
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number                                 OpcuaNodeIdServicesVariableServer = 22797
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableServer = 22798
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                         OpcuaNodeIdServicesVariableServer = 22799
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableServer = 22800
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState                              OpcuaNodeIdServicesVariableServer = 22801
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState                             OpcuaNodeIdServicesVariableServer = 22802
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState                               OpcuaNodeIdServicesVariableServer = 22804
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                            OpcuaNodeIdServicesVariableServer = 22805
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                          OpcuaNodeIdServicesVariableServer = 22806
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                        OpcuaNodeIdServicesVariableServer = 22807
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName          OpcuaNodeIdServicesVariableServer = 22808
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition                             OpcuaNodeIdServicesVariableServer = 22809
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                          OpcuaNodeIdServicesVariableServer = 22810
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                        OpcuaNodeIdServicesVariableServer = 22811
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                      OpcuaNodeIdServicesVariableServer = 22812
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime              OpcuaNodeIdServicesVariableServer = 22813
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime     OpcuaNodeIdServicesVariableServer = 22814
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates                            OpcuaNodeIdServicesVariableServer = 22815
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                       OpcuaNodeIdServicesVariableServer = 22816
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                               OpcuaNodeIdServicesVariableServer = 22817
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                 OpcuaNodeIdServicesVariableServer = 22819
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved                                      OpcuaNodeIdServicesVariableServer = 22822
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved                                           OpcuaNodeIdServicesVariableServer = 22823
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled                                           OpcuaNodeIdServicesVariableServer = 22824
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound                                             OpcuaNodeIdServicesVariableServer = 22825
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId                                      OpcuaNodeIdServicesVariableServer = 22826
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId                                    OpcuaNodeIdServicesVariableServer = 22827
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId                                   OpcuaNodeIdServicesVariableServer = 22828
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState                                             OpcuaNodeIdServicesVariableServer = 22829
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id                                          OpcuaNodeIdServicesVariableServer = 22830
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name                                        OpcuaNodeIdServicesVariableServer = 22831
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number                                      OpcuaNodeIdServicesVariableServer = 22832
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22833
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22834
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22835
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22836
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22837
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay                                                  OpcuaNodeIdServicesVariableServer = 22838
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay                                                 OpcuaNodeIdServicesVariableServer = 22839
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag                                         OpcuaNodeIdServicesVariableServer = 22840
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState                                             OpcuaNodeIdServicesVariableServer = 22842
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id                                          OpcuaNodeIdServicesVariableServer = 22843
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name                                        OpcuaNodeIdServicesVariableServer = 22844
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number                                      OpcuaNodeIdServicesVariableServer = 22845
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 22846
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 22847
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 22848
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 22849
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 22850
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime                                              OpcuaNodeIdServicesVariableServer = 22851
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount                                       OpcuaNodeIdServicesVariableServer = 22852
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState                                              OpcuaNodeIdServicesVariableServer = 22859
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId                                              OpcuaNodeIdServicesVariableServer = 22860
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime                                           OpcuaNodeIdServicesVariableServer = 22861
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency                                          OpcuaNodeIdServicesVariableServer = 22862
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency                                                         OpcuaNodeIdServicesVariableServer = 22863
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId                                                        OpcuaNodeIdServicesVariableServer = 22865
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType                                                      OpcuaNodeIdServicesVariableServer = 22866
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode                                                     OpcuaNodeIdServicesVariableServer = 22867
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName                                                     OpcuaNodeIdServicesVariableServer = 22868
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time                                                           OpcuaNodeIdServicesVariableServer = 22869
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime                                                    OpcuaNodeIdServicesVariableServer = 22870
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime                                                      OpcuaNodeIdServicesVariableServer = 22871
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message                                                        OpcuaNodeIdServicesVariableServer = 22872
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity                                                       OpcuaNodeIdServicesVariableServer = 22873
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId                                               OpcuaNodeIdServicesVariableServer = 22874
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName                                             OpcuaNodeIdServicesVariableServer = 22875
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId                                            OpcuaNodeIdServicesVariableServer = 22876
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName                                          OpcuaNodeIdServicesVariableServer = 22877
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName                                                  OpcuaNodeIdServicesVariableServer = 22878
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId                                                       OpcuaNodeIdServicesVariableServer = 22879
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain                                                         OpcuaNodeIdServicesVariableServer = 22880
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState                                                   OpcuaNodeIdServicesVariableServer = 22881
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id                                                OpcuaNodeIdServicesVariableServer = 22882
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name                                              OpcuaNodeIdServicesVariableServer = 22883
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number                                            OpcuaNodeIdServicesVariableServer = 22884
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 22885
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 22886
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 22887
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState                                         OpcuaNodeIdServicesVariableServer = 22888
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState                                        OpcuaNodeIdServicesVariableServer = 22889
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality                                                        OpcuaNodeIdServicesVariableServer = 22890
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp                                        OpcuaNodeIdServicesVariableServer = 22891
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity                                                   OpcuaNodeIdServicesVariableServer = 22892
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp                                   OpcuaNodeIdServicesVariableServer = 22893
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment                                                        OpcuaNodeIdServicesVariableServer = 22894
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp                                        OpcuaNodeIdServicesVariableServer = 22895
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId                                                   OpcuaNodeIdServicesVariableServer = 22896
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments                                      OpcuaNodeIdServicesVariableServer = 22900
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState                                                     OpcuaNodeIdServicesVariableServer = 22901
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id                                                  OpcuaNodeIdServicesVariableServer = 22902
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name                                                OpcuaNodeIdServicesVariableServer = 22903
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number                                              OpcuaNodeIdServicesVariableServer = 22904
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName                                OpcuaNodeIdServicesVariableServer = 22905
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime                                      OpcuaNodeIdServicesVariableServer = 22906
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime                             OpcuaNodeIdServicesVariableServer = 22907
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState                                           OpcuaNodeIdServicesVariableServer = 22908
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState                                          OpcuaNodeIdServicesVariableServer = 22909
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState                                                 OpcuaNodeIdServicesVariableServer = 22910
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id                                              OpcuaNodeIdServicesVariableServer = 22911
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name                                            OpcuaNodeIdServicesVariableServer = 22912
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number                                          OpcuaNodeIdServicesVariableServer = 22913
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 22914
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 22915
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 22916
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 22917
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 22918
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments                                     OpcuaNodeIdServicesVariableServer = 22920
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments                                         OpcuaNodeIdServicesVariableServer = 22922
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState                                                    OpcuaNodeIdServicesVariableServer = 22923
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id                                                 OpcuaNodeIdServicesVariableServer = 22924
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name                                               OpcuaNodeIdServicesVariableServer = 22925
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number                                             OpcuaNodeIdServicesVariableServer = 22926
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableServer = 22927
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime                                     OpcuaNodeIdServicesVariableServer = 22928
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableServer = 22929
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState                                          OpcuaNodeIdServicesVariableServer = 22930
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState                                         OpcuaNodeIdServicesVariableServer = 22931
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode                                                      OpcuaNodeIdServicesVariableServer = 22932
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState                                                OpcuaNodeIdServicesVariableServer = 22933
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id                                             OpcuaNodeIdServicesVariableServer = 22934
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name                                           OpcuaNodeIdServicesVariableServer = 22935
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number                                         OpcuaNodeIdServicesVariableServer = 22936
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 22937
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 22938
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 22939
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState                                      OpcuaNodeIdServicesVariableServer = 22940
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState                                     OpcuaNodeIdServicesVariableServer = 22941
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState                                              OpcuaNodeIdServicesVariableServer = 22942
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id                                           OpcuaNodeIdServicesVariableServer = 22943
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name                                         OpcuaNodeIdServicesVariableServer = 22944
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number                                       OpcuaNodeIdServicesVariableServer = 22945
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableServer = 22946
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime                               OpcuaNodeIdServicesVariableServer = 22947
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableServer = 22948
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState                                    OpcuaNodeIdServicesVariableServer = 22949
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState                                   OpcuaNodeIdServicesVariableServer = 22950
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState                                     OpcuaNodeIdServicesVariableServer = 22952
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id                                  OpcuaNodeIdServicesVariableServer = 22953
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name                                OpcuaNodeIdServicesVariableServer = 22954
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number                              OpcuaNodeIdServicesVariableServer = 22955
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableServer = 22956
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition                                   OpcuaNodeIdServicesVariableServer = 22957
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id                                OpcuaNodeIdServicesVariableServer = 22958
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name                              OpcuaNodeIdServicesVariableServer = 22959
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number                            OpcuaNodeIdServicesVariableServer = 22960
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableServer = 22961
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableServer = 22962
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates                                  OpcuaNodeIdServicesVariableServer = 22963
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions                             OpcuaNodeIdServicesVariableServer = 22964
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime                                     OpcuaNodeIdServicesVariableServer = 22965
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                       OpcuaNodeIdServicesVariableServer = 22967
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved                                            OpcuaNodeIdServicesVariableServer = 22970
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved                                                 OpcuaNodeIdServicesVariableServer = 22971
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled                                                 OpcuaNodeIdServicesVariableServer = 22972
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound                                                   OpcuaNodeIdServicesVariableServer = 22973
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId                                            OpcuaNodeIdServicesVariableServer = 22974
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId                                          OpcuaNodeIdServicesVariableServer = 22975
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId                                         OpcuaNodeIdServicesVariableServer = 22976
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState                                                   OpcuaNodeIdServicesVariableServer = 22977
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id                                                OpcuaNodeIdServicesVariableServer = 22978
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name                                              OpcuaNodeIdServicesVariableServer = 22979
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number                                            OpcuaNodeIdServicesVariableServer = 22980
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 22981
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 22982
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 22983
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState                                         OpcuaNodeIdServicesVariableServer = 22984
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState                                        OpcuaNodeIdServicesVariableServer = 22985
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay                                                        OpcuaNodeIdServicesVariableServer = 22986
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay                                                       OpcuaNodeIdServicesVariableServer = 22987
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag                                               OpcuaNodeIdServicesVariableServer = 22988
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState                                                   OpcuaNodeIdServicesVariableServer = 22990
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id                                                OpcuaNodeIdServicesVariableServer = 22991
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name                                              OpcuaNodeIdServicesVariableServer = 22992
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number                                            OpcuaNodeIdServicesVariableServer = 22993
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 22994
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 22995
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 22996
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState                                         OpcuaNodeIdServicesVariableServer = 22997
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState                                        OpcuaNodeIdServicesVariableServer = 22998
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime                                                    OpcuaNodeIdServicesVariableServer = 22999
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount                                             OpcuaNodeIdServicesVariableServer = 23000
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState                                                    OpcuaNodeIdServicesVariableServer = 23007
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate                                                 OpcuaNodeIdServicesVariableServer = 23008
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit                                                OpcuaNodeIdServicesVariableServer = 23009
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType                                                OpcuaNodeIdServicesVariableServer = 23010
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate                                                    OpcuaNodeIdServicesVariableServer = 23011
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId                                                        OpcuaNodeIdServicesVariableServer = 23013
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType                                                      OpcuaNodeIdServicesVariableServer = 23014
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode                                                     OpcuaNodeIdServicesVariableServer = 23015
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName                                                     OpcuaNodeIdServicesVariableServer = 23016
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time                                                           OpcuaNodeIdServicesVariableServer = 23017
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime                                                    OpcuaNodeIdServicesVariableServer = 23018
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime                                                      OpcuaNodeIdServicesVariableServer = 23019
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message                                                        OpcuaNodeIdServicesVariableServer = 23020
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity                                                       OpcuaNodeIdServicesVariableServer = 23021
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId                                               OpcuaNodeIdServicesVariableServer = 23022
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName                                             OpcuaNodeIdServicesVariableServer = 23023
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId                                            OpcuaNodeIdServicesVariableServer = 23024
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName                                          OpcuaNodeIdServicesVariableServer = 23025
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName                                                  OpcuaNodeIdServicesVariableServer = 23026
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId                                                       OpcuaNodeIdServicesVariableServer = 23027
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain                                                         OpcuaNodeIdServicesVariableServer = 23028
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState                                                   OpcuaNodeIdServicesVariableServer = 23029
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id                                                OpcuaNodeIdServicesVariableServer = 23030
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name                                              OpcuaNodeIdServicesVariableServer = 23031
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number                                            OpcuaNodeIdServicesVariableServer = 23032
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 23033
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 23034
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 23035
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState                                         OpcuaNodeIdServicesVariableServer = 23036
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState                                        OpcuaNodeIdServicesVariableServer = 23037
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality                                                        OpcuaNodeIdServicesVariableServer = 23038
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp                                        OpcuaNodeIdServicesVariableServer = 23039
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity                                                   OpcuaNodeIdServicesVariableServer = 23040
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                                   OpcuaNodeIdServicesVariableServer = 23041
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment                                                        OpcuaNodeIdServicesVariableServer = 23042
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp                                        OpcuaNodeIdServicesVariableServer = 23043
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId                                                   OpcuaNodeIdServicesVariableServer = 23044
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments                                      OpcuaNodeIdServicesVariableServer = 23048
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState                                                     OpcuaNodeIdServicesVariableServer = 23049
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id                                                  OpcuaNodeIdServicesVariableServer = 23050
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name                                                OpcuaNodeIdServicesVariableServer = 23051
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number                                              OpcuaNodeIdServicesVariableServer = 23052
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                                OpcuaNodeIdServicesVariableServer = 23053
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime                                      OpcuaNodeIdServicesVariableServer = 23054
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                             OpcuaNodeIdServicesVariableServer = 23055
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState                                           OpcuaNodeIdServicesVariableServer = 23056
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState                                          OpcuaNodeIdServicesVariableServer = 23057
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState                                                 OpcuaNodeIdServicesVariableServer = 23058
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id                                              OpcuaNodeIdServicesVariableServer = 23059
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name                                            OpcuaNodeIdServicesVariableServer = 23060
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number                                          OpcuaNodeIdServicesVariableServer = 23061
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 23062
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 23063
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 23064
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 23065
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 23066
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments                                     OpcuaNodeIdServicesVariableServer = 23068
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments                                         OpcuaNodeIdServicesVariableServer = 23070
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState                                                    OpcuaNodeIdServicesVariableServer = 23071
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id                                                 OpcuaNodeIdServicesVariableServer = 23072
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name                                               OpcuaNodeIdServicesVariableServer = 23073
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number                                             OpcuaNodeIdServicesVariableServer = 23074
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableServer = 23075
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime                                     OpcuaNodeIdServicesVariableServer = 23076
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableServer = 23077
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState                                          OpcuaNodeIdServicesVariableServer = 23078
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState                                         OpcuaNodeIdServicesVariableServer = 23079
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode                                                      OpcuaNodeIdServicesVariableServer = 23080
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState                                                OpcuaNodeIdServicesVariableServer = 23081
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id                                             OpcuaNodeIdServicesVariableServer = 23082
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name                                           OpcuaNodeIdServicesVariableServer = 23083
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number                                         OpcuaNodeIdServicesVariableServer = 23084
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 23085
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 23086
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 23087
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState                                      OpcuaNodeIdServicesVariableServer = 23088
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState                                     OpcuaNodeIdServicesVariableServer = 23089
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState                                              OpcuaNodeIdServicesVariableServer = 23090
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id                                           OpcuaNodeIdServicesVariableServer = 23091
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name                                         OpcuaNodeIdServicesVariableServer = 23092
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number                                       OpcuaNodeIdServicesVariableServer = 23093
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableServer = 23094
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                               OpcuaNodeIdServicesVariableServer = 23095
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableServer = 23096
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                    OpcuaNodeIdServicesVariableServer = 23097
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState                                   OpcuaNodeIdServicesVariableServer = 23098
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState                                     OpcuaNodeIdServicesVariableServer = 23100
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                                  OpcuaNodeIdServicesVariableServer = 23101
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                                OpcuaNodeIdServicesVariableServer = 23102
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                              OpcuaNodeIdServicesVariableServer = 23103
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableServer = 23104
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition                                   OpcuaNodeIdServicesVariableServer = 23105
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                                OpcuaNodeIdServicesVariableServer = 23106
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                              OpcuaNodeIdServicesVariableServer = 23107
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                            OpcuaNodeIdServicesVariableServer = 23108
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableServer = 23109
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableServer = 23110
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates                                  OpcuaNodeIdServicesVariableServer = 23111
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                             OpcuaNodeIdServicesVariableServer = 23112
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                     OpcuaNodeIdServicesVariableServer = 23113
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                       OpcuaNodeIdServicesVariableServer = 23115
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved                                            OpcuaNodeIdServicesVariableServer = 23118
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved                                                 OpcuaNodeIdServicesVariableServer = 23119
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled                                                 OpcuaNodeIdServicesVariableServer = 23120
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound                                                   OpcuaNodeIdServicesVariableServer = 23121
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId                                            OpcuaNodeIdServicesVariableServer = 23122
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId                                          OpcuaNodeIdServicesVariableServer = 23123
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId                                         OpcuaNodeIdServicesVariableServer = 23124
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState                                                   OpcuaNodeIdServicesVariableServer = 23125
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id                                                OpcuaNodeIdServicesVariableServer = 23126
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name                                              OpcuaNodeIdServicesVariableServer = 23127
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number                                            OpcuaNodeIdServicesVariableServer = 23128
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 23129
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 23130
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 23131
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState                                         OpcuaNodeIdServicesVariableServer = 23132
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState                                        OpcuaNodeIdServicesVariableServer = 23133
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay                                                        OpcuaNodeIdServicesVariableServer = 23134
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay                                                       OpcuaNodeIdServicesVariableServer = 23135
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag                                               OpcuaNodeIdServicesVariableServer = 23136
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState                                                   OpcuaNodeIdServicesVariableServer = 23138
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id                                                OpcuaNodeIdServicesVariableServer = 23139
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name                                              OpcuaNodeIdServicesVariableServer = 23140
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number                                            OpcuaNodeIdServicesVariableServer = 23141
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableServer = 23142
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime                                    OpcuaNodeIdServicesVariableServer = 23143
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableServer = 23144
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState                                         OpcuaNodeIdServicesVariableServer = 23145
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState                                        OpcuaNodeIdServicesVariableServer = 23146
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime                                                    OpcuaNodeIdServicesVariableServer = 23147
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount                                             OpcuaNodeIdServicesVariableServer = 23148
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState                                                    OpcuaNodeIdServicesVariableServer = 23155
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId                                                    OpcuaNodeIdServicesVariableServer = 23156
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime                                                 OpcuaNodeIdServicesVariableServer = 23157
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency                                                OpcuaNodeIdServicesVariableServer = 23158
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency                                                     OpcuaNodeIdServicesVariableServer = 23159
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId                                                    OpcuaNodeIdServicesVariableServer = 23161
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType                                                  OpcuaNodeIdServicesVariableServer = 23162
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode                                                 OpcuaNodeIdServicesVariableServer = 23163
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName                                                 OpcuaNodeIdServicesVariableServer = 23164
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time                                                       OpcuaNodeIdServicesVariableServer = 23165
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime                                                OpcuaNodeIdServicesVariableServer = 23166
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime                                                  OpcuaNodeIdServicesVariableServer = 23167
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message                                                    OpcuaNodeIdServicesVariableServer = 23168
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity                                                   OpcuaNodeIdServicesVariableServer = 23169
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId                                           OpcuaNodeIdServicesVariableServer = 23170
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName                                         OpcuaNodeIdServicesVariableServer = 23171
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId                                        OpcuaNodeIdServicesVariableServer = 23172
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName                                      OpcuaNodeIdServicesVariableServer = 23173
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName                                              OpcuaNodeIdServicesVariableServer = 23174
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId                                                   OpcuaNodeIdServicesVariableServer = 23175
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain                                                     OpcuaNodeIdServicesVariableServer = 23176
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState                                               OpcuaNodeIdServicesVariableServer = 23177
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id                                            OpcuaNodeIdServicesVariableServer = 23178
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name                                          OpcuaNodeIdServicesVariableServer = 23179
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number                                        OpcuaNodeIdServicesVariableServer = 23180
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23181
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23182
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23183
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23184
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23185
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality                                                    OpcuaNodeIdServicesVariableServer = 23186
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 23187
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity                                               OpcuaNodeIdServicesVariableServer = 23188
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableServer = 23189
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment                                                    OpcuaNodeIdServicesVariableServer = 23190
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 23191
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId                                               OpcuaNodeIdServicesVariableServer = 23192
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableServer = 23196
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState                                                 OpcuaNodeIdServicesVariableServer = 23197
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id                                              OpcuaNodeIdServicesVariableServer = 23198
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name                                            OpcuaNodeIdServicesVariableServer = 23199
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number                                          OpcuaNodeIdServicesVariableServer = 23200
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 23201
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 23202
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 23203
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 23204
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 23205
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState                                             OpcuaNodeIdServicesVariableServer = 23206
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableServer = 23207
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableServer = 23208
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableServer = 23209
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 23210
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 23211
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 23212
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 23213
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 23214
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableServer = 23216
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableServer = 23218
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState                                                OpcuaNodeIdServicesVariableServer = 23219
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id                                             OpcuaNodeIdServicesVariableServer = 23220
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name                                           OpcuaNodeIdServicesVariableServer = 23221
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number                                         OpcuaNodeIdServicesVariableServer = 23222
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 23223
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 23224
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 23225
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableServer = 23226
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableServer = 23227
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode                                                  OpcuaNodeIdServicesVariableServer = 23228
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState                                            OpcuaNodeIdServicesVariableServer = 23229
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id                                         OpcuaNodeIdServicesVariableServer = 23230
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name                                       OpcuaNodeIdServicesVariableServer = 23231
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number                                     OpcuaNodeIdServicesVariableServer = 23232
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 23233
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 23234
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 23235
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableServer = 23236
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableServer = 23237
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState                                          OpcuaNodeIdServicesVariableServer = 23238
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableServer = 23239
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableServer = 23240
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableServer = 23241
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 23242
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 23243
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 23244
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableServer = 23245
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableServer = 23246
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableServer = 23248
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableServer = 23249
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableServer = 23250
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableServer = 23251
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableServer = 23252
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableServer = 23253
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableServer = 23254
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableServer = 23255
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableServer = 23256
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableServer = 23257
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableServer = 23258
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableServer = 23259
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableServer = 23260
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableServer = 23261
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableServer = 23263
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableServer = 23266
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved                                             OpcuaNodeIdServicesVariableServer = 23267
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled                                             OpcuaNodeIdServicesVariableServer = 23268
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound                                               OpcuaNodeIdServicesVariableServer = 23269
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableServer = 23270
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableServer = 23271
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableServer = 23272
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState                                               OpcuaNodeIdServicesVariableServer = 23273
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id                                            OpcuaNodeIdServicesVariableServer = 23274
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name                                          OpcuaNodeIdServicesVariableServer = 23275
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number                                        OpcuaNodeIdServicesVariableServer = 23276
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23277
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23278
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23279
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23280
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23281
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay                                                    OpcuaNodeIdServicesVariableServer = 23282
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay                                                   OpcuaNodeIdServicesVariableServer = 23283
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableServer = 23284
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState                                               OpcuaNodeIdServicesVariableServer = 23286
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id                                            OpcuaNodeIdServicesVariableServer = 23287
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name                                          OpcuaNodeIdServicesVariableServer = 23288
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number                                        OpcuaNodeIdServicesVariableServer = 23289
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23290
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23291
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23292
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23293
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23294
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime                                                OpcuaNodeIdServicesVariableServer = 23295
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableServer = 23296
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState                                                OpcuaNodeIdServicesVariableServer = 23303
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate                                             OpcuaNodeIdServicesVariableServer = 23304
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit                                            OpcuaNodeIdServicesVariableServer = 23305
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType                                            OpcuaNodeIdServicesVariableServer = 23306
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate                                                OpcuaNodeIdServicesVariableServer = 23307
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId                                                    OpcuaNodeIdServicesVariableServer = 23309
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType                                                  OpcuaNodeIdServicesVariableServer = 23310
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode                                                 OpcuaNodeIdServicesVariableServer = 23311
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName                                                 OpcuaNodeIdServicesVariableServer = 23312
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time                                                       OpcuaNodeIdServicesVariableServer = 23313
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime                                                OpcuaNodeIdServicesVariableServer = 23314
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime                                                  OpcuaNodeIdServicesVariableServer = 23315
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message                                                    OpcuaNodeIdServicesVariableServer = 23316
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity                                                   OpcuaNodeIdServicesVariableServer = 23317
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId                                           OpcuaNodeIdServicesVariableServer = 23318
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName                                         OpcuaNodeIdServicesVariableServer = 23319
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId                                        OpcuaNodeIdServicesVariableServer = 23320
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName                                      OpcuaNodeIdServicesVariableServer = 23321
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName                                              OpcuaNodeIdServicesVariableServer = 23322
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId                                                   OpcuaNodeIdServicesVariableServer = 23323
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain                                                     OpcuaNodeIdServicesVariableServer = 23324
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState                                               OpcuaNodeIdServicesVariableServer = 23325
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id                                            OpcuaNodeIdServicesVariableServer = 23326
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name                                          OpcuaNodeIdServicesVariableServer = 23327
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number                                        OpcuaNodeIdServicesVariableServer = 23328
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23329
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23330
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23331
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23332
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23333
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality                                                    OpcuaNodeIdServicesVariableServer = 23334
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 23335
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity                                               OpcuaNodeIdServicesVariableServer = 23336
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableServer = 23337
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment                                                    OpcuaNodeIdServicesVariableServer = 23338
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableServer = 23339
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId                                               OpcuaNodeIdServicesVariableServer = 23340
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableServer = 23344
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState                                                 OpcuaNodeIdServicesVariableServer = 23345
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id                                              OpcuaNodeIdServicesVariableServer = 23346
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name                                            OpcuaNodeIdServicesVariableServer = 23347
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number                                          OpcuaNodeIdServicesVariableServer = 23348
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableServer = 23349
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableServer = 23350
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableServer = 23351
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState                                       OpcuaNodeIdServicesVariableServer = 23352
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState                                      OpcuaNodeIdServicesVariableServer = 23353
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState                                             OpcuaNodeIdServicesVariableServer = 23354
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableServer = 23355
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableServer = 23356
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableServer = 23357
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableServer = 23358
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableServer = 23359
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableServer = 23360
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableServer = 23361
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableServer = 23362
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableServer = 23364
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableServer = 23366
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState                                                OpcuaNodeIdServicesVariableServer = 23367
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id                                             OpcuaNodeIdServicesVariableServer = 23368
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name                                           OpcuaNodeIdServicesVariableServer = 23369
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number                                         OpcuaNodeIdServicesVariableServer = 23370
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableServer = 23371
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableServer = 23372
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableServer = 23373
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableServer = 23374
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableServer = 23375
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode                                                  OpcuaNodeIdServicesVariableServer = 23376
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState                                            OpcuaNodeIdServicesVariableServer = 23377
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id                                         OpcuaNodeIdServicesVariableServer = 23378
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name                                       OpcuaNodeIdServicesVariableServer = 23379
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number                                     OpcuaNodeIdServicesVariableServer = 23380
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableServer = 23381
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableServer = 23382
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableServer = 23383
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableServer = 23384
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableServer = 23385
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState                                          OpcuaNodeIdServicesVariableServer = 23386
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableServer = 23387
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableServer = 23388
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableServer = 23389
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableServer = 23390
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableServer = 23391
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableServer = 23392
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableServer = 23393
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableServer = 23394
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableServer = 23396
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableServer = 23397
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableServer = 23398
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableServer = 23399
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableServer = 23400
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableServer = 23401
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableServer = 23402
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableServer = 23403
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableServer = 23404
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableServer = 23405
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableServer = 23406
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableServer = 23407
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableServer = 23408
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableServer = 23409
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableServer = 23411
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableServer = 23414
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved                                             OpcuaNodeIdServicesVariableServer = 23415
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled                                             OpcuaNodeIdServicesVariableServer = 23416
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound                                               OpcuaNodeIdServicesVariableServer = 23417
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableServer = 23418
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableServer = 23419
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableServer = 23420
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState                                               OpcuaNodeIdServicesVariableServer = 23421
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id                                            OpcuaNodeIdServicesVariableServer = 23422
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name                                          OpcuaNodeIdServicesVariableServer = 23423
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number                                        OpcuaNodeIdServicesVariableServer = 23424
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23425
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23426
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23427
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23428
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23429
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay                                                    OpcuaNodeIdServicesVariableServer = 23430
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay                                                   OpcuaNodeIdServicesVariableServer = 23431
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableServer = 23432
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState                                               OpcuaNodeIdServicesVariableServer = 23434
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id                                            OpcuaNodeIdServicesVariableServer = 23435
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name                                          OpcuaNodeIdServicesVariableServer = 23436
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number                                        OpcuaNodeIdServicesVariableServer = 23437
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableServer = 23438
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableServer = 23439
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableServer = 23440
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableServer = 23441
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableServer = 23442
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime                                                OpcuaNodeIdServicesVariableServer = 23443
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableServer = 23444
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState                                                OpcuaNodeIdServicesVariableServer = 23451
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId                                                OpcuaNodeIdServicesVariableServer = 23452
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime                                             OpcuaNodeIdServicesVariableServer = 23453
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency                                            OpcuaNodeIdServicesVariableServer = 23454
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments                                         OpcuaNodeIdServicesVariableServer = 23545
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments                                               OpcuaNodeIdServicesVariableServer = 23547
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments                                           OpcuaNodeIdServicesVariableServer = 23549
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments                                             OpcuaNodeIdServicesVariableServer = 23551
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments                                                   OpcuaNodeIdServicesVariableServer = 23553
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments                                               OpcuaNodeIdServicesVariableServer = 23555
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions                                      OpcuaNodeIdServicesVariableServer = 23571
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions                                            OpcuaNodeIdServicesVariableServer = 23572
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions                                        OpcuaNodeIdServicesVariableServer = 23573
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions                                          OpcuaNodeIdServicesVariableServer = 23574
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions                                                OpcuaNodeIdServicesVariableServer = 23575
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions                                            OpcuaNodeIdServicesVariableServer = 23576
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_HasSecureElement                                                                                                  OpcuaNodeIdServicesVariableServer = 23593
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_HasSecureElement                                                                                                      OpcuaNodeIdServicesVariableServer = 23597
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSessions                                                                                                 OpcuaNodeIdServicesVariableServer = 23752
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSubscriptions                                                                                            OpcuaNodeIdServicesVariableServer = 23753
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItems                                                                                           OpcuaNodeIdServicesVariableServer = 24083
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSubscriptionsPerSession                                                                                  OpcuaNodeIdServicesVariableServer = 24084
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSelectClauseParameters                                                                                   OpcuaNodeIdServicesVariableServer = 24085
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxWhereClauseParameters                                                                                    OpcuaNodeIdServicesVariableServer = 24086
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_ConformanceUnits                                                                                            OpcuaNodeIdServicesVariableServer = 24087
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSessions                                                                                                        OpcuaNodeIdServicesVariableServer = 24088
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSubscriptions                                                                                                   OpcuaNodeIdServicesVariableServer = 24089
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItems                                                                                                  OpcuaNodeIdServicesVariableServer = 24090
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSubscriptionsPerSession                                                                                         OpcuaNodeIdServicesVariableServer = 24091
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSelectClauseParameters                                                                                          OpcuaNodeIdServicesVariableServer = 24092
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxWhereClauseParameters                                                                                           OpcuaNodeIdServicesVariableServer = 24093
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_ConformanceUnits                                                                                                   OpcuaNodeIdServicesVariableServer = 24094
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSessions                                                                                                     OpcuaNodeIdServicesVariableServer = 24095
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSubscriptions                                                                                                OpcuaNodeIdServicesVariableServer = 24096
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItems                                                                                               OpcuaNodeIdServicesVariableServer = 24097
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSubscriptionsPerSession                                                                                      OpcuaNodeIdServicesVariableServer = 24098
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSelectClauseParameters                                                                                       OpcuaNodeIdServicesVariableServer = 24099
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxWhereClauseParameters                                                                                        OpcuaNodeIdServicesVariableServer = 24100
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_ConformanceUnits                                                                                                OpcuaNodeIdServicesVariableServer = 24101
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItemsPerSubscription                                                                            OpcuaNodeIdServicesVariableServer = 24102
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItemsPerSubscription                                                                                   OpcuaNodeIdServicesVariableServer = 24103
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItemsPerSubscription                                                                                OpcuaNodeIdServicesVariableServer = 24104
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength                                           OpcuaNodeIdServicesVariableServer = 24256
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength                                                 OpcuaNodeIdServicesVariableServer = 24257
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength                                             OpcuaNodeIdServicesVariableServer = 24258
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength                                               OpcuaNodeIdServicesVariableServer = 24259
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength                                                     OpcuaNodeIdServicesVariableServer = 24260
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength                                                 OpcuaNodeIdServicesVariableServer = 24261
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24619
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableServer = 24621
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableServer = 24623
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableServer = 24625
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments                                OpcuaNodeIdServicesVariableServer = 24627
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24629
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableServer = 24631
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableServer = 24633
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableServer = 24635
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments                                OpcuaNodeIdServicesVariableServer = 24637
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableServer = 24639
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24641
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableServer = 24643
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24645
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableServer = 24647
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableServer = 24649
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24651
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableServer = 24653
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24655
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableServer = 24657
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableServer = 24659
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24661
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableServer = 24663
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableServer = 24665
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableServer = 24667
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableServer = 24669
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24671
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableServer = 24673
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableServer = 24675
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableServer = 24677
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24679
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments                               OpcuaNodeIdServicesVariableServer = 24681
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments                        OpcuaNodeIdServicesVariableServer = 24683
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments                           OpcuaNodeIdServicesVariableServer = 24685
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments                                    OpcuaNodeIdServicesVariableServer = 24687
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24689
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments                               OpcuaNodeIdServicesVariableServer = 24691
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                        OpcuaNodeIdServicesVariableServer = 24693
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments                           OpcuaNodeIdServicesVariableServer = 24695
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments                                    OpcuaNodeIdServicesVariableServer = 24697
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments                                       OpcuaNodeIdServicesVariableServer = 24699
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments                                     OpcuaNodeIdServicesVariableServer = 24701
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments                              OpcuaNodeIdServicesVariableServer = 24703
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24705
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments                                          OpcuaNodeIdServicesVariableServer = 24707
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments                                       OpcuaNodeIdServicesVariableServer = 24709
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                     OpcuaNodeIdServicesVariableServer = 24711
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                              OpcuaNodeIdServicesVariableServer = 24713
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24715
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments                                          OpcuaNodeIdServicesVariableServer = 24717
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableServer = 24719
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24721
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableServer = 24723
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24725
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableServer = 24727
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableServer = 24729
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableServer = 24731
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableServer = 24733
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableServer = 24735
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableServer = 24737
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableServer = 25059
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableServer = 25061
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableServer = 25063
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableServer = 25067
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableServer = 25069
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableServer = 25071
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableServer = 25075
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableServer = 25077
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25079
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableServer = 25083
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableServer = 25085
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25087
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableServer = 25091
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableServer = 25093
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableServer = 25095
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableServer = 25099
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableServer = 25101
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableServer = 25103
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25107
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                   OpcuaNodeIdServicesVariableServer = 25109
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments              OpcuaNodeIdServicesVariableServer = 25111
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25115
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                   OpcuaNodeIdServicesVariableServer = 25117
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments              OpcuaNodeIdServicesVariableServer = 25119
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                      OpcuaNodeIdServicesVariableServer = 25123
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                         OpcuaNodeIdServicesVariableServer = 25125
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                    OpcuaNodeIdServicesVariableServer = 25127
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                      OpcuaNodeIdServicesVariableServer = 25131
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                         OpcuaNodeIdServicesVariableServer = 25133
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                    OpcuaNodeIdServicesVariableServer = 25135
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableServer = 25139
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableServer = 25141
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25143
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableServer = 25147
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableServer = 25149
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableServer = 25151
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableServer = 25187
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableServer = 25188
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableServer = 25189
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableServer = 25190
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableServer = 25191
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableServer = 25192
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments                      OpcuaNodeIdServicesVariableServer = 25193
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                      OpcuaNodeIdServicesVariableServer = 25194
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments                            OpcuaNodeIdServicesVariableServer = 25195
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                            OpcuaNodeIdServicesVariableServer = 25196
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableServer = 25197
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableServer = 25198
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime                                              OpcuaNodeIdServicesVariableServer = 25212
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime                                                    OpcuaNodeIdServicesVariableServer = 25213
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime                                                OpcuaNodeIdServicesVariableServer = 25214
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime                                                  OpcuaNodeIdServicesVariableServer = 25215
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime                                                        OpcuaNodeIdServicesVariableServer = 25216
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime                                                    OpcuaNodeIdServicesVariableServer = 25217
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ApplicationUri                                                                                                    OpcuaNodeIdServicesVariableServer = 25696
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ApplicationType                                                                                                   OpcuaNodeIdServicesVariableServer = 25697
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_ApplicationUri                                                                                                        OpcuaNodeIdServicesVariableServer = 25706
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_ApplicationType                                                                                                       OpcuaNodeIdServicesVariableServer = 25707
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ProductUri                                                                                                        OpcuaNodeIdServicesVariableServer = 25724
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_ProductUri                                                                                                            OpcuaNodeIdServicesVariableServer = 25725
	OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItemsQueueSize                                                                                  OpcuaNodeIdServicesVariableServer = 31769
	OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItemsQueueSize                                                                                         OpcuaNodeIdServicesVariableServer = 31770
	OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItemsQueueSize                                                                                      OpcuaNodeIdServicesVariableServer = 31916
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout                                               OpcuaNodeIdServicesVariableServer = 32293
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout                                                     OpcuaNodeIdServicesVariableServer = 32294
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout                                                 OpcuaNodeIdServicesVariableServer = 32295
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetCertificates_InputArguments                                                                                    OpcuaNodeIdServicesVariableServer = 32297
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetCertificates_OutputArguments                                                                                   OpcuaNodeIdServicesVariableServer = 32298
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_StartTime                                                                                  OpcuaNodeIdServicesVariableServer = 32300
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_EndTime                                                                                    OpcuaNodeIdServicesVariableServer = 32301
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_Result                                                                                     OpcuaNodeIdServicesVariableServer = 32302
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_AffectedTrustLists                                                                         OpcuaNodeIdServicesVariableServer = 32303
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_AffectedCertificateGroups                                                                  OpcuaNodeIdServicesVariableServer = 32304
	OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_Errors                                                                                     OpcuaNodeIdServicesVariableServer = 32305
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout                                                   OpcuaNodeIdServicesVariableServer = 32330
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout                                                         OpcuaNodeIdServicesVariableServer = 32331
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout                                                     OpcuaNodeIdServicesVariableServer = 32332
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetCertificates_InputArguments                                                                                        OpcuaNodeIdServicesVariableServer = 32334
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetCertificates_OutputArguments                                                                                       OpcuaNodeIdServicesVariableServer = 32335
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_StartTime                                                                                      OpcuaNodeIdServicesVariableServer = 32337
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_EndTime                                                                                        OpcuaNodeIdServicesVariableServer = 32338
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_Result                                                                                         OpcuaNodeIdServicesVariableServer = 32339
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_AffectedTrustLists                                                                             OpcuaNodeIdServicesVariableServer = 32340
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_AffectedCertificateGroups                                                                      OpcuaNodeIdServicesVariableServer = 32341
	OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_Errors                                                                                         OpcuaNodeIdServicesVariableServer = 32342
)

var OpcuaNodeIdServicesVariableServerValues []OpcuaNodeIdServicesVariableServer

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableServerValues = []OpcuaNodeIdServicesVariableServer{
		OpcuaNodeIdServicesVariableServer_ServerType_ServerArray,
		OpcuaNodeIdServicesVariableServer_ServerType_NamespaceArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus,
		OpcuaNodeIdServicesVariableServer_ServerType_ServiceLevel,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_ServerProfileArray,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_LocaleIdArray,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MinSupportedSampleRate,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SamplingIntervalDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SubscriptionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_EnabledFlag,
		OpcuaNodeIdServicesVariableServer_ServerRedundancyType_RedundancySupport,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_StartTime,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_CurrentTime,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_State,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_ServerViewCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionTimeoutCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionAbortCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_PublishingIntervalCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerArray,
		OpcuaNodeIdServicesVariableServer_Server_NamespaceArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_StartTime,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_CurrentTime,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_State,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductName,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductUri,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ManufacturerName,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_SoftwareVersion,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildNumber,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildDate,
		OpcuaNodeIdServicesVariableServer_Server_ServiceLevel,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_ServerProfileArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_LocaleIdArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MinSupportedSampleRate,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SubscriptionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_EnabledFlag,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxBrowseContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxQueryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxHistoryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxBrowseContinuationPoints,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxQueryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxHistoryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerType_Auditing,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_SecondsTillShutdown,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_ShutdownReason,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_SecondsTillShutdown,
		OpcuaNodeIdServicesVariableServer_Server_ServerStatus_ShutdownReason,
		OpcuaNodeIdServicesVariableServer_Server_Auditing,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_SoftwareCertificates,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_StartTime,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_CurrentTime,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_State,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ProductUri,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ManufacturerName,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_ProductName,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_SoftwareVersion,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_BuildNumber,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_BuildInfo_BuildDate,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_SecondsTillShutdown,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus_ShutdownReason,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_ServerProfileArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_LocaleIdArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MinSupportedSampleRate,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxBrowseContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxQueryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxHistoryContinuationPoints,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_SoftwareCertificates,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SamplingIntervalDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerDiagnostics_EnabledFlag,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerRedundancy_RedundancySupport,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ProductUri,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ManufacturerName,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_ProductName,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_SoftwareVersion,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_BuildNumber,
		OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo_BuildDate,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_SoftwareCertificates,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_RedundancySupport,
		OpcuaNodeIdServicesVariableServer_ServerState_EnumStrings,
		OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_CurrentServerId,
		OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_RedundantServerArray,
		OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerUriArray,
		OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_OutputArguments,
		OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxArrayLength,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxStringLength,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxArrayLength,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxStringLength,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRead,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_VendorCapability_Placeholder,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxArrayLength,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxStringLength,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRead,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_SupportedPrivateKeyFormats,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MaxTrustListSize,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MulticastDnsEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_SupportedPrivateKeyFormats,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_MaxTrustListSize,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_MulticastDnsEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ServerCapabilities,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_ServerCapabilities,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_OutputArguments,
		OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_ResendData_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_ResendData_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_EstimatedReturnTime,
		OpcuaNodeIdServicesVariableServer_ServerType_RequestServerStateChange_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_EstimatedReturnTime,
		OpcuaNodeIdServicesVariableServer_Server_RequestServerStateChange_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerNetworkGroups,
		OpcuaNodeIdServicesVariableServer_ServerType_UrisVersion,
		OpcuaNodeIdServicesVariableServer_Server_UrisVersion,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_OutputArguments,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerType_LocalTime,
		OpcuaNodeIdServicesVariableServer_Server_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_HasSecureElement,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_HasSecureElement,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSessions,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSubscriptions,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItems,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSubscriptionsPerSession,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxSelectClauseParameters,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxWhereClauseParameters,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_ConformanceUnits,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSessions,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSubscriptions,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItems,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSubscriptionsPerSession,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxSelectClauseParameters,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxWhereClauseParameters,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_ConformanceUnits,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSessions,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSubscriptions,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItems,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSubscriptionsPerSession,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxSelectClauseParameters,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxWhereClauseParameters,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_ConformanceUnits,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItemsPerSubscription,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItemsPerSubscription,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItemsPerSubscription,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ApplicationUri,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ApplicationType,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_ApplicationUri,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_ApplicationType,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ProductUri,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_ProductUri,
		OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxMonitoredItemsQueueSize,
		OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxMonitoredItemsQueueSize,
		OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxMonitoredItemsQueueSize,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetCertificates_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetCertificates_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_StartTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_EndTime,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_Result,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_AffectedTrustLists,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_AffectedCertificateGroups,
		OpcuaNodeIdServicesVariableServer_ServerConfigurationType_TransactionDiagnostics_Errors,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetCertificates_InputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetCertificates_OutputArguments,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_StartTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_EndTime,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_Result,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_AffectedTrustLists,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_AffectedCertificateGroups,
		OpcuaNodeIdServicesVariableServer_ServerConfiguration_TransactionDiagnostics_Errors,
	}
}

func OpcuaNodeIdServicesVariableServerByValue(value int32) (enum OpcuaNodeIdServicesVariableServer, ok bool) {
	switch value {
	case 11312:
		return OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_CurrentServerId, true
	case 11313:
		return OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_RedundantServerArray, true
	case 11314:
		return OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerUriArray, true
	case 11490:
		return OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_InputArguments, true
	case 11491:
		return OpcuaNodeIdServicesVariableServer_ServerType_GetMonitoredItems_OutputArguments, true
	case 11493:
		return OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_InputArguments, true
	case 11494:
		return OpcuaNodeIdServicesVariableServer_Server_GetMonitoredItems_OutputArguments, true
	case 11514:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxArrayLength, true
	case 11515:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxStringLength, true
	case 11517:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead, true
	case 11519:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite, true
	case 11521:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall, true
	case 11522:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse, true
	case 11523:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes, true
	case 11524:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, true
	case 11525:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement, true
	case 11526:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall, true
	case 11549:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxArrayLength, true
	case 11550:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxStringLength, true
	case 11552:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRead, true
	case 11554:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite, true
	case 11556:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall, true
	case 11557:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse, true
	case 11558:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes, true
	case 11559:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, true
	case 11560:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement, true
	case 11561:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall, true
	case 11562:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_VendorCapability_Placeholder, true
	case 11702:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxArrayLength, true
	case 11703:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxStringLength, true
	case 11705:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRead, true
	case 11707:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite, true
	case 11709:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall, true
	case 11710:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse, true
	case 11711:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes, true
	case 11712:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, true
	case 11713:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement, true
	case 11714:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall, true
	case 12153:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData, true
	case 12154:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents, true
	case 12155:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData, true
	case 12156:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents, true
	case 12157:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData, true
	case 12158:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents, true
	case 12159:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData, true
	case 12160:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents, true
	case 12165:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData, true
	case 12166:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents, true
	case 12167:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData, true
	case 12168:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents, true
	case 12583:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_SupportedPrivateKeyFormats, true
	case 12584:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MaxTrustListSize, true
	case 12585:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_MulticastDnsEnabled, true
	case 12617:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_InputArguments, true
	case 12618:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_UpdateCertificate_OutputArguments, true
	case 12639:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_SupportedPrivateKeyFormats, true
	case 12640:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_MaxTrustListSize, true
	case 12641:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_MulticastDnsEnabled, true
	case 12643:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case 12646:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case 12648:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case 12649:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case 12651:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case 12653:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case 12654:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case 12656:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case 12658:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case 12659:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case 12661:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case 12662:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case 12664:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case 12665:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 12667:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 12669:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case 12671:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case 12708:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_ServerCapabilities, true
	case 12710:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_ServerCapabilities, true
	case 12732:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_InputArguments, true
	case 12733:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CreateSigningRequest_OutputArguments, true
	case 12738:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_InputArguments, true
	case 12739:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CreateSigningRequest_OutputArguments, true
	case 12747:
		return OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_InputArguments, true
	case 12748:
		return OpcuaNodeIdServicesVariableServer_ServerType_SetSubscriptionDurable_OutputArguments, true
	case 12750:
		return OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_InputArguments, true
	case 12751:
		return OpcuaNodeIdServicesVariableServer_Server_SetSubscriptionDurable_OutputArguments, true
	case 12776:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_GetRejectedList_OutputArguments, true
	case 12778:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_GetRejectedList_OutputArguments, true
	case 12872:
		return OpcuaNodeIdServicesVariableServer_ServerType_ResendData_InputArguments, true
	case 12874:
		return OpcuaNodeIdServicesVariableServer_Server_ResendData_InputArguments, true
	case 12882:
		return OpcuaNodeIdServicesVariableServer_ServerType_EstimatedReturnTime, true
	case 12884:
		return OpcuaNodeIdServicesVariableServer_ServerType_RequestServerStateChange_InputArguments, true
	case 12885:
		return OpcuaNodeIdServicesVariableServer_Server_EstimatedReturnTime, true
	case 12887:
		return OpcuaNodeIdServicesVariableServer_Server_RequestServerStateChange_InputArguments, true
	case 12909:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_MaxByteStringLength, true
	case 12910:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MaxByteStringLength, true
	case 12911:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MaxByteStringLength, true
	case 13738:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_InputArguments, true
	case 13739:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_UpdateCertificate_OutputArguments, true
	case 13953:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case 13954:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case 13955:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case 13956:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case 13957:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case 13959:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case 13960:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case 13962:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case 13964:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case 13965:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case 13967:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case 13969:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case 13970:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case 13972:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case 13973:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case 13975:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case 13976:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 13978:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 13979:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 13981:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case 13983:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case 13984:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case 13987:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case 13988:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case 13989:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case 13990:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case 13991:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case 13993:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case 13994:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case 13996:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case 13998:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case 13999:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case 14001:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case 14003:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case 14004:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case 14006:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case 14007:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case 14009:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case 14010:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 14012:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 14013:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 14015:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case 14017:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case 14018:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case 14021:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case 14022:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case 14023:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case 14024:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case 14025:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case 14027:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case 14028:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case 14030:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case 14032:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case 14033:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case 14035:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case 14037:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case 14038:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case 14040:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case 14041:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case 14043:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case 14044:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 14046:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 14047:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 14049:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case 14051:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case 14052:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case 14090:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case 14091:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case 14092:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case 14093:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case 14094:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case 14096:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case 14097:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case 14099:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case 14101:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case 14102:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case 14104:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case 14106:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case 14107:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case 14109:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case 14110:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case 14112:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case 14113:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 14115:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 14116:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 14118:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case 14120:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case 14121:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case 14124:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case 14125:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case 14126:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case 14127:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case 14128:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case 14130:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case 14131:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case 14133:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case 14135:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case 14136:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case 14138:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case 14140:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case 14141:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case 14143:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case 14144:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case 14146:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case 14147:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 14149:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 14150:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 14152:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case 14154:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case 14155:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case 14157:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case 14158:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case 14159:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case 14160:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 14161:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case 14415:
		return OpcuaNodeIdServicesVariableServer_Server_ServerRedundancy_ServerNetworkGroups, true
	case 15003:
		return OpcuaNodeIdServicesVariableServer_ServerType_UrisVersion, true
	case 15004:
		return OpcuaNodeIdServicesVariableServer_Server_UrisVersion, true
	case 16291:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments, true
	case 16292:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments, true
	case 16294:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments, true
	case 16297:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_InputArguments, true
	case 16298:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_AddRole_OutputArguments, true
	case 16300:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments, true
	case 16302:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_InputArguments, true
	case 16303:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_AddRole_OutputArguments, true
	case 16305:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments, true
	case 17612:
		return OpcuaNodeIdServicesVariableServer_ServerType_LocalTime, true
	case 17634:
		return OpcuaNodeIdServicesVariableServer_Server_LocalTime, true
	case 2005:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerArray, true
	case 2006:
		return OpcuaNodeIdServicesVariableServer_ServerType_NamespaceArray, true
	case 2007:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServerStatus, true
	case 2008:
		return OpcuaNodeIdServicesVariableServer_ServerType_ServiceLevel, true
	case 2014:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_ServerProfileArray, true
	case 2016:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_LocaleIdArray, true
	case 2017:
		return OpcuaNodeIdServicesVariableServer_ServerCapabilitiesType_MinSupportedSampleRate, true
	case 2021:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_ServerDiagnosticsSummary, true
	case 2022:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SamplingIntervalDiagnosticsArray, true
	case 2023:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_SubscriptionDiagnosticsArray, true
	case 2025:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsType_EnabledFlag, true
	case 2035:
		return OpcuaNodeIdServicesVariableServer_ServerRedundancyType_RedundancySupport, true
	case 2139:
		return OpcuaNodeIdServicesVariableServer_ServerStatusType_StartTime, true
	case 2140:
		return OpcuaNodeIdServicesVariableServer_ServerStatusType_CurrentTime, true
	case 2141:
		return OpcuaNodeIdServicesVariableServer_ServerStatusType_State, true
	case 2142:
		return OpcuaNodeIdServicesVariableServer_ServerStatusType_BuildInfo, true
	case 2151:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_ServerViewCount, true
	case 2152:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSessionCount, true
	case 2153:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSessionCount, true
	case 2154:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedSessionCount, true
	case 2155:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedSessionCount, true
	case 2156:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionTimeoutCount, true
	case 2157:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SessionAbortCount, true
	case 2159:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_PublishingIntervalCount, true
	case 2160:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CurrentSubscriptionCount, true
	case 2161:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_CumulatedSubscriptionCount, true
	case 2162:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount, true
	case 2163:
		return OpcuaNodeIdServicesVariableServer_ServerDiagnosticsSummaryType_RejectedRequestsCount, true
	case 21679:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case 21681:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case 21682:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case 21683:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case 21684:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case 21685:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case 21686:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case 21687:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case 21688:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case 21689:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case 21690:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case 21691:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case 21692:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case 21693:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case 21694:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case 21695:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case 21696:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case 21697:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case 21698:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case 21699:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case 21700:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case 21701:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 21702:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 21703:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 21704:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case 21705:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case 21706:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case 21707:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 21708:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case 21709:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 21710:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case 21711:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 21712:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case 21716:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case 21717:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case 21718:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case 21719:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case 21720:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case 21721:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 21722:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case 21723:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 21724:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case 21725:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case 21726:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case 21727:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case 21728:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case 21729:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case 21730:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 21731:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 21732:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 21733:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 21734:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 21736:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 21738:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case 21739:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case 21740:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case 21741:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case 21742:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case 21743:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 21744:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 21745:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 21746:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case 21747:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case 21748:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case 21749:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case 21750:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case 21751:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case 21752:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case 21753:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 21754:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 21755:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 21756:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case 21757:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case 21758:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case 21759:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case 21760:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case 21761:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case 21762:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 21763:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 21764:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 21765:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 21766:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 21768:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 21769:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 21770:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 21771:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 21772:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 21773:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 21774:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 21775:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 21776:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 21777:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 21778:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 21779:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 21780:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 21781:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 21783:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 21786:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case 21787:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case 21788:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case 21789:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case 21790:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case 21791:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 21792:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case 21793:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case 21794:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case 21795:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case 21796:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case 21797:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 21798:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 21799:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 21800:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case 21801:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case 21802:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case 21803:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case 21804:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case 21806:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case 21807:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case 21808:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case 21809:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case 21810:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 21811:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 21812:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 21813:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case 21814:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case 21815:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case 21816:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 21823:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case 21824:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case 21825:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case 21826:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case 21827:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case 21829:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case 21830:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case 21831:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case 21832:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case 21833:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case 21834:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case 21835:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case 21836:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case 21837:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case 21838:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case 21839:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case 21840:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 21841:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 21842:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case 21843:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case 21844:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case 21845:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case 21846:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case 21847:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case 21848:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case 21849:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 21850:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 21851:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 21852:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 21853:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 21854:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case 21855:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 21856:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case 21857:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 21858:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case 21859:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 21860:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case 21864:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 21865:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case 21866:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case 21867:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case 21868:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case 21869:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 21870:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 21871:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 21872:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 21873:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 21874:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case 21875:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 21876:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 21877:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 21878:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 21879:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 21880:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 21881:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 21882:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 21884:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 21886:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 21887:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case 21888:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case 21889:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case 21890:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case 21891:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 21892:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 21893:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 21894:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 21895:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 21896:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case 21897:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case 21898:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 21899:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 21900:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 21901:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 21902:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 21903:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 21904:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 21905:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 21906:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case 21907:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 21908:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 21909:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 21910:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 21911:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 21912:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 21913:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 21914:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 21916:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 21917:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 21918:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 21919:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 21920:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 21921:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 21922:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 21923:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 21924:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 21925:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 21926:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 21927:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 21928:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 21929:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 21931:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 21934:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 21935:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 21936:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case 21937:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case 21938:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 21939:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 21940:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 21941:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case 21942:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case 21943:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case 21944:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case 21945:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 21946:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 21947:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 21948:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 21949:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 21950:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case 21951:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case 21952:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 21954:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case 21955:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case 21956:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case 21957:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case 21958:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 21959:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 21960:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 21961:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 21962:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 21963:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case 21964:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 21971:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case 21972:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case 21973:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case 21974:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case 21975:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case 21977:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case 21978:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case 21979:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case 21980:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case 21981:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case 21982:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case 21983:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case 21984:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case 21985:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case 21986:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case 21987:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case 21988:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case 21989:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case 21990:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case 21991:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case 21992:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case 21993:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case 21994:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case 21995:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case 21996:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case 21997:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 21998:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 21999:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 22000:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case 22001:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case 22002:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case 22003:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 22004:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case 22005:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 22006:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case 22007:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 22008:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case 22012:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case 22013:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case 22014:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case 22015:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case 22016:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case 22017:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 22018:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case 22019:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 22020:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case 22021:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case 22022:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case 22023:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case 22024:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case 22025:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case 22026:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 22027:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 22028:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 22029:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 22030:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 22032:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 22034:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case 22035:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case 22036:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case 22037:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case 22038:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case 22039:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 22040:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 22041:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 22042:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case 22043:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case 22044:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case 22045:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case 22046:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case 22047:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case 22048:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case 22049:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 22050:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 22051:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 22052:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case 22053:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case 22054:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case 22055:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case 22056:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case 22057:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case 22058:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 22059:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 22060:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 22061:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 22062:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 22064:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 22065:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 22066:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 22067:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 22068:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22069:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 22070:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 22071:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 22072:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 22073:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 22074:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22075:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 22076:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 22077:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 22079:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 22082:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case 22083:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case 22084:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case 22085:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case 22086:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case 22087:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 22088:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case 22089:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case 22090:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case 22091:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case 22092:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case 22093:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 22094:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 22095:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 22096:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case 22097:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case 22098:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case 22099:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case 22100:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case 22102:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case 22103:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case 22104:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case 22105:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case 22106:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 22107:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 22108:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 22109:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case 22110:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case 22111:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case 22112:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 22119:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case 22120:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case 22121:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case 22122:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case 22123:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case 22125:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case 22126:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case 22127:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case 22128:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case 22129:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case 22130:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case 22131:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case 22132:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case 22133:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case 22134:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case 22135:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case 22136:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 22137:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 22138:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case 22139:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case 22140:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case 22141:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case 22142:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case 22143:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case 22144:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case 22145:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 22146:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 22147:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 22148:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 22149:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 22150:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case 22151:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 22152:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case 22153:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 22154:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case 22155:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 22156:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case 22160:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 22161:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case 22162:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case 22163:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case 22164:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case 22165:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 22166:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 22167:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 22168:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 22169:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 22170:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case 22171:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 22172:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 22173:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 22174:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 22175:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 22176:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 22177:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 22178:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 22180:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 22182:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 22183:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case 22184:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case 22185:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case 22186:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case 22187:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 22188:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 22189:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 22190:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 22191:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 22192:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case 22193:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case 22194:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 22195:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 22196:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 22197:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 22198:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 22199:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 22200:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 22201:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 22202:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case 22203:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 22204:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 22205:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 22206:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 22207:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 22208:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 22209:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 22210:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 22212:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 22213:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 22214:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 22215:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 22216:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22217:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 22218:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 22219:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 22220:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 22221:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 22222:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22223:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 22224:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 22225:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 22227:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 22230:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 22231:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 22232:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case 22233:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case 22234:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 22235:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 22236:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 22237:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case 22238:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case 22239:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case 22240:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case 22241:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 22242:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 22243:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 22244:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 22245:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 22246:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case 22247:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case 22248:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 22250:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case 22251:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case 22252:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case 22253:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case 22254:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 22255:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 22256:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 22257:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 22258:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 22259:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case 22260:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 22267:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case 22268:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case 22269:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case 22270:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case 22271:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case 22273:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case 22274:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case 22275:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case 22276:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case 22277:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case 22278:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case 22279:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case 22280:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case 22281:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case 22282:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case 22283:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case 22284:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case 22285:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case 22286:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case 22287:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case 22288:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case 22289:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case 22290:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case 22291:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case 22292:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case 22293:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 22294:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 22295:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 22296:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case 22297:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case 22298:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case 22299:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 22300:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case 22301:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 22302:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case 22303:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 22304:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case 22308:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case 22309:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case 22310:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case 22311:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case 22312:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case 22313:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 22314:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case 22315:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 22316:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case 22317:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case 22318:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case 22319:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case 22320:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case 22321:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case 22322:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 22323:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 22324:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 22325:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 22326:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 22328:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 22330:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case 22331:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case 22332:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case 22333:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case 22334:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case 22335:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 22336:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 22337:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 22338:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case 22339:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case 22340:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case 22341:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case 22342:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case 22343:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case 22344:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case 22345:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 22346:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 22347:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 22348:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case 22349:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case 22350:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case 22351:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case 22352:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case 22353:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case 22354:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 22355:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 22356:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 22357:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 22358:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 22360:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 22361:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 22362:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 22363:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 22364:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22365:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 22366:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 22367:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 22368:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 22369:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 22370:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22371:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 22372:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 22373:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 22375:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 22378:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case 22379:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case 22380:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case 22381:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case 22382:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case 22383:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 22384:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case 22385:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case 22386:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case 22387:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case 22388:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case 22389:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 22390:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 22391:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 22392:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case 22393:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case 22394:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case 22395:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case 22396:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case 22398:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case 22399:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case 22400:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case 22401:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case 22402:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 22403:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 22404:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 22405:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case 22406:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case 22407:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case 22408:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 22415:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case 22416:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case 22417:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case 22418:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case 22419:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case 22421:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case 22422:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case 22423:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case 22424:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case 22425:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case 22426:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case 22427:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case 22428:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case 22429:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case 22430:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case 22431:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case 22432:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 22433:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 22434:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case 22435:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case 22436:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case 22437:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case 22438:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case 22439:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case 22440:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case 22441:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 22442:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 22443:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 22444:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 22445:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 22446:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case 22447:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 22448:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case 22449:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 22450:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case 22451:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 22452:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case 22456:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 22457:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case 22458:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case 22459:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case 22460:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case 22461:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 22462:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 22463:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 22464:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 22465:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 22466:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case 22467:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 22468:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 22469:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 22470:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 22471:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 22472:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 22473:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 22474:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 22476:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 22478:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 22479:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case 22480:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case 22481:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case 22482:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case 22483:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 22484:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 22485:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 22486:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 22487:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 22488:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case 22489:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case 22490:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 22491:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 22492:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 22493:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 22494:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 22495:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 22496:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 22497:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 22498:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case 22499:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 22500:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 22501:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 22502:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 22503:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 22504:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 22505:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 22506:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 22508:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 22509:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 22510:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 22511:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 22512:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22513:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 22514:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 22515:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 22516:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 22517:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 22518:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22519:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 22520:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 22521:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 22523:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 22526:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 22527:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 22528:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case 22529:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case 22530:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 22531:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 22532:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 22533:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case 22534:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case 22535:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case 22536:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case 22537:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 22538:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 22539:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 2254:
		return OpcuaNodeIdServicesVariableServer_Server_ServerArray, true
	case 22540:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 22541:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 22542:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case 22543:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case 22544:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 22546:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case 22547:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case 22548:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case 22549:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case 2255:
		return OpcuaNodeIdServicesVariableServer_Server_NamespaceArray, true
	case 22550:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 22551:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 22552:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 22553:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 22554:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 22555:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case 22556:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 2256:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus, true
	case 22563:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case 22564:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case 22565:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case 22566:
		return OpcuaNodeIdServicesVariableServer_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case 22567:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case 22569:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case 2257:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_StartTime, true
	case 22570:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case 22571:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case 22572:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case 22573:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case 22574:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case 22575:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case 22576:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case 22577:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case 22578:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case 22579:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case 2258:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_CurrentTime, true
	case 22580:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case 22581:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case 22582:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case 22583:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case 22584:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case 22585:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case 22586:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case 22587:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case 22588:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case 22589:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 2259:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_State, true
	case 22590:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 22591:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 22592:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case 22593:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case 22594:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case 22595:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 22596:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case 22597:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 22598:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case 22599:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 2260:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo, true
	case 22600:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case 22604:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case 22605:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case 22606:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case 22607:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case 22608:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case 22609:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 2261:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductName, true
	case 22610:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case 22611:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 22612:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case 22613:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case 22614:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case 22615:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case 22616:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case 22617:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case 22618:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 22619:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 2262:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ProductUri, true
	case 22620:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 22621:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 22622:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 22624:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 22626:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case 22627:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case 22628:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case 22629:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case 2263:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_ManufacturerName, true
	case 22630:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case 22631:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 22632:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 22633:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 22634:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case 22635:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case 22636:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case 22637:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case 22638:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case 22639:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case 2264:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_SoftwareVersion, true
	case 22640:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case 22641:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 22642:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 22643:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 22644:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case 22645:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case 22646:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case 22647:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case 22648:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case 22649:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case 2265:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildNumber, true
	case 22650:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 22651:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 22652:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 22653:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 22654:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 22656:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 22657:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 22658:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 22659:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 2266:
		return OpcuaNodeIdServicesVariableServer_Server_ServerStatus_BuildInfo_BuildDate, true
	case 22660:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22661:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 22662:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 22663:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 22664:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 22665:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 22666:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22667:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 22668:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 22669:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 2267:
		return OpcuaNodeIdServicesVariableServer_Server_ServiceLevel, true
	case 22671:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 22674:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case 22675:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case 22676:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case 22677:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case 22678:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case 22679:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 22680:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case 22681:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case 22682:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case 22683:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case 22684:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case 22685:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 22686:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 22687:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 22688:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case 22689:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case 2269:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_ServerProfileArray, true
	case 22690:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case 22691:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case 22692:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case 22694:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case 22695:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case 22696:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case 22697:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case 22698:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 22699:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 22700:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 22701:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case 22702:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case 22703:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case 22704:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 2271:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_LocaleIdArray, true
	case 22711:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case 22712:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case 22713:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case 22714:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case 22715:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case 22717:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case 22718:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case 22719:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case 2272:
		return OpcuaNodeIdServicesVariableServer_Server_ServerCapabilities_MinSupportedSampleRate, true
	case 22720:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case 22721:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case 22722:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case 22723:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case 22724:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case 22725:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case 22726:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case 22727:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case 22728:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 22729:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 22730:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case 22731:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case 22732:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case 22733:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case 22734:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case 22735:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case 22736:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case 22737:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 22738:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 22739:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 22740:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 22741:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 22742:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case 22743:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 22744:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case 22745:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 22746:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case 22747:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 22748:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case 2275:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary, true
	case 22752:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 22753:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case 22754:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case 22755:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case 22756:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case 22757:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 22758:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 22759:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 2276:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount, true
	case 22760:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 22761:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 22762:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case 22763:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 22764:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 22765:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 22766:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 22767:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 22768:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 22769:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 2277:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount, true
	case 22770:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 22772:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 22774:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 22775:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case 22776:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case 22777:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case 22778:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case 22779:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 2278:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount, true
	case 22780:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 22781:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 22782:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 22783:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 22784:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case 22785:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case 22786:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 22787:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 22788:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 22789:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 2279:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount, true
	case 22790:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 22791:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 22792:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 22793:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 22794:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case 22795:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 22796:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 22797:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 22798:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 22799:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 22800:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 22801:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 22802:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 22804:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 22805:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 22806:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 22807:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 22808:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22809:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 2281:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount, true
	case 22810:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 22811:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 22812:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 22813:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 22814:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22815:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 22816:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 22817:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 22819:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 2282:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount, true
	case 22822:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 22823:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 22824:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case 22825:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case 22826:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 22827:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 22828:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 22829:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case 22830:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case 22831:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case 22832:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case 22833:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 22834:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 22835:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 22836:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 22837:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 22838:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case 22839:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case 2284:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount, true
	case 22840:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 22842:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case 22843:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case 22844:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case 22845:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case 22846:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 22847:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 22848:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 22849:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 2285:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount, true
	case 22850:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 22851:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case 22852:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 22859:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case 2286:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount, true
	case 22860:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case 22861:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case 22862:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case 22863:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case 22865:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case 22866:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case 22867:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case 22868:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case 22869:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case 2287:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount, true
	case 22870:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case 22871:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case 22872:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case 22873:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case 22874:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case 22875:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case 22876:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case 22877:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case 22878:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case 22879:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case 2288:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount, true
	case 22880:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case 22881:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case 22882:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case 22883:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case 22884:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case 22885:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 22886:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 22887:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 22888:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case 22889:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case 2289:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray, true
	case 22890:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case 22891:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 22892:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case 22893:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 22894:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case 22895:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 22896:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case 2290:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_SubscriptionDiagnosticsArray, true
	case 22900:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case 22901:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case 22902:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case 22903:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case 22904:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case 22905:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 22906:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case 22907:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 22908:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case 22909:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case 22910:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case 22911:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case 22912:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case 22913:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case 22914:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 22915:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 22916:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 22917:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 22918:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 22920:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 22922:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case 22923:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case 22924:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case 22925:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case 22926:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case 22927:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 22928:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 22929:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 22930:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case 22931:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case 22932:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case 22933:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case 22934:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case 22935:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case 22936:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case 22937:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 22938:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 22939:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 2294:
		return OpcuaNodeIdServicesVariableServer_Server_ServerDiagnostics_EnabledFlag, true
	case 22940:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case 22941:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case 22942:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case 22943:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case 22944:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case 22945:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case 22946:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 22947:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 22948:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 22949:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 22950:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 22952:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 22953:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 22954:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 22955:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 22956:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 22957:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 22958:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 22959:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 22960:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 22961:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 22962:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 22963:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 22964:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 22965:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 22967:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 22970:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case 22971:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case 22972:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case 22973:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case 22974:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case 22975:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 22976:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case 22977:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case 22978:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case 22979:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case 22980:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case 22981:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 22982:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 22983:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 22984:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case 22985:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case 22986:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case 22987:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case 22988:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case 22990:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case 22991:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case 22992:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case 22993:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case 22994:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 22995:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 22996:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 22997:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case 22998:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case 22999:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case 23000:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 23007:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case 23008:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case 23009:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case 23010:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case 23011:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case 23013:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case 23014:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case 23015:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case 23016:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case 23017:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case 23018:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case 23019:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case 23020:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case 23021:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case 23022:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case 23023:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case 23024:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 23025:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 23026:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case 23027:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case 23028:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case 23029:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case 23030:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case 23031:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case 23032:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case 23033:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 23034:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 23035:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 23036:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 23037:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 23038:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case 23039:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 23040:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case 23041:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 23042:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case 23043:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 23044:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case 23048:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 23049:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case 23050:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case 23051:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case 23052:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case 23053:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 23054:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 23055:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 23056:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 23057:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 23058:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case 23059:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 23060:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 23061:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 23062:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 23063:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 23064:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 23065:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 23066:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 23068:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 23070:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 23071:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case 23072:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case 23073:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case 23074:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case 23075:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 23076:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 23077:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 23078:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 23079:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 23080:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case 23081:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case 23082:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 23083:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 23084:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 23085:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 23086:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 23087:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 23088:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 23089:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 23090:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case 23091:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 23092:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 23093:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 23094:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 23095:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 23096:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 23097:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 23098:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 23100:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 23101:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 23102:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 23103:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 23104:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 23105:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 23106:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 23107:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 23108:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 23109:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 23110:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 23111:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 23112:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 23113:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 23115:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 23118:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 23119:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 23120:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case 23121:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case 23122:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 23123:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 23124:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 23125:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case 23126:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case 23127:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case 23128:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case 23129:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 23130:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 23131:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 23132:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 23133:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 23134:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case 23135:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case 23136:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 23138:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case 23139:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case 23140:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case 23141:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case 23142:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 23143:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 23144:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 23145:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 23146:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 23147:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case 23148:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 23155:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case 23156:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case 23157:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case 23158:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case 23159:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case 23161:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case 23162:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case 23163:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case 23164:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case 23165:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case 23166:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case 23167:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case 23168:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case 23169:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case 23170:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case 23171:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case 23172:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case 23173:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case 23174:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case 23175:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case 23176:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case 23177:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case 23178:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case 23179:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case 23180:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case 23181:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 23182:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 23183:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 23184:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case 23185:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case 23186:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case 23187:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 23188:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case 23189:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 23190:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case 23191:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 23192:
		return OpcuaNodeIdServicesVariableServer_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case 23196:
		return OpcuaNodeIdServic