/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSampling is an enum
type OpcuaNodeIdServicesVariableSampling int32

type IOpcuaNodeIdServicesVariableSampling interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SamplingInterval                                                     OpcuaNodeIdServicesVariableSampling = 2166
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount                                           OpcuaNodeIdServicesVariableSampling = 11697
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount                                        OpcuaNodeIdServicesVariableSampling = 11698
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount                                  OpcuaNodeIdServicesVariableSampling = 11699
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics                                     OpcuaNodeIdServicesVariableSampling = 12779
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval                    OpcuaNodeIdServicesVariableSampling = 12780
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount          OpcuaNodeIdServicesVariableSampling = 12781
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount       OpcuaNodeIdServicesVariableSampling = 12782
	OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount OpcuaNodeIdServicesVariableSampling = 12783
)

var OpcuaNodeIdServicesVariableSamplingValues []OpcuaNodeIdServicesVariableSampling

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSamplingValues = []OpcuaNodeIdServicesVariableSampling{
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SamplingInterval,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount,
	}
}

func OpcuaNodeIdServicesVariableSamplingByValue(value int32) (enum OpcuaNodeIdServicesVariableSampling, ok bool) {
	switch value {
	case 11697:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount, true
	case 11698:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount, true
	case 11699:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount, true
	case 12779:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics, true
	case 12780:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval, true
	case 12781:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount, true
	case 12782:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount, true
	case 12783:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount, true
	case 2166:
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SamplingInterval, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSamplingByName(value string) (enum OpcuaNodeIdServicesVariableSampling, ok bool) {
	switch value {
	case "SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount, true
	case "SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount, true
	case "SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount, true
	case "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics, true
	case "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval, true
	case "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount, true
	case "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount, true
	case "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount, true
	case "SamplingIntervalDiagnosticsType_SamplingInterval":
		return OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SamplingInterval, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSamplingKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSamplingValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSampling(structType any) OpcuaNodeIdServicesVariableSampling {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSampling {
		if sOpcuaNodeIdServicesVariableSampling, ok := typ.(OpcuaNodeIdServicesVariableSampling); ok {
			return sOpcuaNodeIdServicesVariableSampling
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSampling) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSampling) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSamplingParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSampling, error) {
	return OpcuaNodeIdServicesVariableSamplingParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSamplingParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSampling, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSampling", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSampling")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSamplingByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSampling")
		return OpcuaNodeIdServicesVariableSampling(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSampling) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSampling) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSampling", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSampling) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount:
		return "SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount:
		return "SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount:
		return "SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics:
		return "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval:
		return "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount:
		return "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount:
		return "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount:
		return "SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount"
	case OpcuaNodeIdServicesVariableSampling_SamplingIntervalDiagnosticsType_SamplingInterval:
		return "SamplingIntervalDiagnosticsType_SamplingInterval"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSampling) String() string {
	return e.PLC4XEnumName()
}
