/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableRole is an enum
type OpcuaNodeIdServicesVariableRole int32

type IOpcuaNodeIdServicesVariableRole interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_ApplicationsExclude              OpcuaNodeIdServicesVariableRole = 15408
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_EndpointsExclude                 OpcuaNodeIdServicesVariableRole = 15409
	OpcuaNodeIdServicesVariableRole_RoleType_ApplicationsExclude                                      OpcuaNodeIdServicesVariableRole = 15410
	OpcuaNodeIdServicesVariableRole_RoleType_EndpointsExclude                                         OpcuaNodeIdServicesVariableRole = 15411
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments       OpcuaNodeIdServicesVariableRole = 15613
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments    OpcuaNodeIdServicesVariableRole = 15615
	OpcuaNodeIdServicesVariableRole_RoleType_AddIdentity_InputArguments                               OpcuaNodeIdServicesVariableRole = 15625
	OpcuaNodeIdServicesVariableRole_RoleType_RemoveIdentity_InputArguments                            OpcuaNodeIdServicesVariableRole = 15627
	OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_InputArguments                                OpcuaNodeIdServicesVariableRole = 15998
	OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_OutputArguments                               OpcuaNodeIdServicesVariableRole = 15999
	OpcuaNodeIdServicesVariableRole_RoleSetType_RemoveRole_InputArguments                             OpcuaNodeIdServicesVariableRole = 16001
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Identities                       OpcuaNodeIdServicesVariableRole = 16162
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Applications                     OpcuaNodeIdServicesVariableRole = 16163
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Endpoints                        OpcuaNodeIdServicesVariableRole = 16164
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments    OpcuaNodeIdServicesVariableRole = 16166
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments OpcuaNodeIdServicesVariableRole = 16168
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments       OpcuaNodeIdServicesVariableRole = 16170
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments    OpcuaNodeIdServicesVariableRole = 16172
	OpcuaNodeIdServicesVariableRole_RoleType_Identities                                               OpcuaNodeIdServicesVariableRole = 16173
	OpcuaNodeIdServicesVariableRole_RoleType_Applications                                             OpcuaNodeIdServicesVariableRole = 16174
	OpcuaNodeIdServicesVariableRole_RoleType_Endpoints                                                OpcuaNodeIdServicesVariableRole = 16175
	OpcuaNodeIdServicesVariableRole_RoleType_AddApplication_InputArguments                            OpcuaNodeIdServicesVariableRole = 16177
	OpcuaNodeIdServicesVariableRole_RoleType_RemoveApplication_InputArguments                         OpcuaNodeIdServicesVariableRole = 16179
	OpcuaNodeIdServicesVariableRole_RoleType_AddEndpoint_InputArguments                               OpcuaNodeIdServicesVariableRole = 16181
	OpcuaNodeIdServicesVariableRole_RoleType_RemoveEndpoint_InputArguments                            OpcuaNodeIdServicesVariableRole = 16183
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventId                      OpcuaNodeIdServicesVariableRole = 17642
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventType                    OpcuaNodeIdServicesVariableRole = 17643
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceNode                   OpcuaNodeIdServicesVariableRole = 17644
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceName                   OpcuaNodeIdServicesVariableRole = 17645
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Time                         OpcuaNodeIdServicesVariableRole = 17646
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ReceiveTime                  OpcuaNodeIdServicesVariableRole = 17647
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_LocalTime                    OpcuaNodeIdServicesVariableRole = 17648
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Message                      OpcuaNodeIdServicesVariableRole = 17649
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Severity                     OpcuaNodeIdServicesVariableRole = 17650
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ActionTimeStamp              OpcuaNodeIdServicesVariableRole = 17651
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Status                       OpcuaNodeIdServicesVariableRole = 17652
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ServerId                     OpcuaNodeIdServicesVariableRole = 17653
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientAuditEntryId           OpcuaNodeIdServicesVariableRole = 17654
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientUserId                 OpcuaNodeIdServicesVariableRole = 17655
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_MethodId                     OpcuaNodeIdServicesVariableRole = 17656
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_InputArguments               OpcuaNodeIdServicesVariableRole = 17657
	OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_CustomConfiguration              OpcuaNodeIdServicesVariableRole = 24138
	OpcuaNodeIdServicesVariableRole_RoleType_CustomConfiguration                                      OpcuaNodeIdServicesVariableRole = 24139
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassId             OpcuaNodeIdServicesVariableRole = 31927
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassName           OpcuaNodeIdServicesVariableRole = 31928
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassId          OpcuaNodeIdServicesVariableRole = 31929
	OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassName        OpcuaNodeIdServicesVariableRole = 31930
)

var OpcuaNodeIdServicesVariableRoleValues []OpcuaNodeIdServicesVariableRole

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableRoleValues = []OpcuaNodeIdServicesVariableRole{
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_ApplicationsExclude,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_EndpointsExclude,
		OpcuaNodeIdServicesVariableRole_RoleType_ApplicationsExclude,
		OpcuaNodeIdServicesVariableRole_RoleType_EndpointsExclude,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_OutputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RemoveRole_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Identities,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Applications,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Endpoints,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_Identities,
		OpcuaNodeIdServicesVariableRole_RoleType_Applications,
		OpcuaNodeIdServicesVariableRole_RoleType_Endpoints,
		OpcuaNodeIdServicesVariableRole_RoleType_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleType_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventType,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Time,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Message,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Severity,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Status,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_MethodId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_InputArguments,
		OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_CustomConfiguration,
		OpcuaNodeIdServicesVariableRole_RoleType_CustomConfiguration,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassName,
	}
}

func OpcuaNodeIdServicesVariableRoleByValue(value int32) (enum OpcuaNodeIdServicesVariableRole, ok bool) {
	switch value {
	case 15408:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_ApplicationsExclude, true
	case 15409:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_EndpointsExclude, true
	case 15410:
		return OpcuaNodeIdServicesVariableRole_RoleType_ApplicationsExclude, true
	case 15411:
		return OpcuaNodeIdServicesVariableRole_RoleType_EndpointsExclude, true
	case 15613:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments, true
	case 15615:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments, true
	case 15625:
		return OpcuaNodeIdServicesVariableRole_RoleType_AddIdentity_InputArguments, true
	case 15627:
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveIdentity_InputArguments, true
	case 15998:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_InputArguments, true
	case 15999:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_OutputArguments, true
	case 16001:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RemoveRole_InputArguments, true
	case 16162:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Identities, true
	case 16163:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Applications, true
	case 16164:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Endpoints, true
	case 16166:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments, true
	case 16168:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments, true
	case 16170:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments, true
	case 16172:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments, true
	case 16173:
		return OpcuaNodeIdServicesVariableRole_RoleType_Identities, true
	case 16174:
		return OpcuaNodeIdServicesVariableRole_RoleType_Applications, true
	case 16175:
		return OpcuaNodeIdServicesVariableRole_RoleType_Endpoints, true
	case 16177:
		return OpcuaNodeIdServicesVariableRole_RoleType_AddApplication_InputArguments, true
	case 16179:
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveApplication_InputArguments, true
	case 16181:
		return OpcuaNodeIdServicesVariableRole_RoleType_AddEndpoint_InputArguments, true
	case 16183:
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveEndpoint_InputArguments, true
	case 17642:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventId, true
	case 17643:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventType, true
	case 17644:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceNode, true
	case 17645:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceName, true
	case 17646:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Time, true
	case 17647:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ReceiveTime, true
	case 17648:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_LocalTime, true
	case 17649:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Message, true
	case 17650:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Severity, true
	case 17651:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ActionTimeStamp, true
	case 17652:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Status, true
	case 17653:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ServerId, true
	case 17654:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientAuditEntryId, true
	case 17655:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientUserId, true
	case 17656:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_MethodId, true
	case 17657:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_InputArguments, true
	case 24138:
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_CustomConfiguration, true
	case 24139:
		return OpcuaNodeIdServicesVariableRole_RoleType_CustomConfiguration, true
	case 31927:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassId, true
	case 31928:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassName, true
	case 31929:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassId, true
	case 31930:
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassName, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableRoleByName(value string) (enum OpcuaNodeIdServicesVariableRole, ok bool) {
	switch value {
	case "RoleSetType_RoleName_Placeholder_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_ApplicationsExclude, true
	case "RoleSetType_RoleName_Placeholder_EndpointsExclude":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_EndpointsExclude, true
	case "RoleType_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableRole_RoleType_ApplicationsExclude, true
	case "RoleType_EndpointsExclude":
		return OpcuaNodeIdServicesVariableRole_RoleType_EndpointsExclude, true
	case "RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments, true
	case "RoleType_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_AddIdentity_InputArguments, true
	case "RoleType_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveIdentity_InputArguments, true
	case "RoleSetType_AddRole_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_InputArguments, true
	case "RoleSetType_AddRole_OutputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_OutputArguments, true
	case "RoleSetType_RemoveRole_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RemoveRole_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_Identities":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Identities, true
	case "RoleSetType_RoleName_Placeholder_Applications":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Applications, true
	case "RoleSetType_RoleName_Placeholder_Endpoints":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Endpoints, true
	case "RoleSetType_RoleName_Placeholder_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments, true
	case "RoleType_Identities":
		return OpcuaNodeIdServicesVariableRole_RoleType_Identities, true
	case "RoleType_Applications":
		return OpcuaNodeIdServicesVariableRole_RoleType_Applications, true
	case "RoleType_Endpoints":
		return OpcuaNodeIdServicesVariableRole_RoleType_Endpoints, true
	case "RoleType_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_AddApplication_InputArguments, true
	case "RoleType_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveApplication_InputArguments, true
	case "RoleType_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_AddEndpoint_InputArguments, true
	case "RoleType_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleType_RemoveEndpoint_InputArguments, true
	case "RoleMappingRuleChangedAuditEventType_EventId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventId, true
	case "RoleMappingRuleChangedAuditEventType_EventType":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventType, true
	case "RoleMappingRuleChangedAuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceNode, true
	case "RoleMappingRuleChangedAuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceName, true
	case "RoleMappingRuleChangedAuditEventType_Time":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Time, true
	case "RoleMappingRuleChangedAuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ReceiveTime, true
	case "RoleMappingRuleChangedAuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_LocalTime, true
	case "RoleMappingRuleChangedAuditEventType_Message":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Message, true
	case "RoleMappingRuleChangedAuditEventType_Severity":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Severity, true
	case "RoleMappingRuleChangedAuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ActionTimeStamp, true
	case "RoleMappingRuleChangedAuditEventType_Status":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Status, true
	case "RoleMappingRuleChangedAuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ServerId, true
	case "RoleMappingRuleChangedAuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientAuditEntryId, true
	case "RoleMappingRuleChangedAuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientUserId, true
	case "RoleMappingRuleChangedAuditEventType_MethodId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_MethodId, true
	case "RoleMappingRuleChangedAuditEventType_InputArguments":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_InputArguments, true
	case "RoleSetType_RoleName_Placeholder_CustomConfiguration":
		return OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_CustomConfiguration, true
	case "RoleType_CustomConfiguration":
		return OpcuaNodeIdServicesVariableRole_RoleType_CustomConfiguration, true
	case "RoleMappingRuleChangedAuditEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassId, true
	case "RoleMappingRuleChangedAuditEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassName, true
	case "RoleMappingRuleChangedAuditEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassId, true
	case "RoleMappingRuleChangedAuditEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassName, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableRoleKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableRoleValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableRole(structType any) OpcuaNodeIdServicesVariableRole {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableRole {
		if sOpcuaNodeIdServicesVariableRole, ok := typ.(OpcuaNodeIdServicesVariableRole); ok {
			return sOpcuaNodeIdServicesVariableRole
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableRole) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableRole) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableRoleParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableRole, error) {
	return OpcuaNodeIdServicesVariableRoleParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableRoleParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableRole, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableRole", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableRole")
	}
	if enum, ok := OpcuaNodeIdServicesVariableRoleByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableRole")
		return OpcuaNodeIdServicesVariableRole(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableRole) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableRole) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableRole", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableRole) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_ApplicationsExclude:
		return "RoleSetType_RoleName_Placeholder_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_EndpointsExclude:
		return "RoleSetType_RoleName_Placeholder_EndpointsExclude"
	case OpcuaNodeIdServicesVariableRole_RoleType_ApplicationsExclude:
		return "RoleType_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableRole_RoleType_EndpointsExclude:
		return "RoleType_EndpointsExclude"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments:
		return "RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments:
		return "RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_AddIdentity_InputArguments:
		return "RoleType_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_RemoveIdentity_InputArguments:
		return "RoleType_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_InputArguments:
		return "RoleSetType_AddRole_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_AddRole_OutputArguments:
		return "RoleSetType_AddRole_OutputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RemoveRole_InputArguments:
		return "RoleSetType_RemoveRole_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Identities:
		return "RoleSetType_RoleName_Placeholder_Identities"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Applications:
		return "RoleSetType_RoleName_Placeholder_Applications"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_Endpoints:
		return "RoleSetType_RoleName_Placeholder_Endpoints"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments:
		return "RoleSetType_RoleName_Placeholder_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments:
		return "RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments:
		return "RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments:
		return "RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_Identities:
		return "RoleType_Identities"
	case OpcuaNodeIdServicesVariableRole_RoleType_Applications:
		return "RoleType_Applications"
	case OpcuaNodeIdServicesVariableRole_RoleType_Endpoints:
		return "RoleType_Endpoints"
	case OpcuaNodeIdServicesVariableRole_RoleType_AddApplication_InputArguments:
		return "RoleType_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_RemoveApplication_InputArguments:
		return "RoleType_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_AddEndpoint_InputArguments:
		return "RoleType_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleType_RemoveEndpoint_InputArguments:
		return "RoleType_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventId:
		return "RoleMappingRuleChangedAuditEventType_EventId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_EventType:
		return "RoleMappingRuleChangedAuditEventType_EventType"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceNode:
		return "RoleMappingRuleChangedAuditEventType_SourceNode"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_SourceName:
		return "RoleMappingRuleChangedAuditEventType_SourceName"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Time:
		return "RoleMappingRuleChangedAuditEventType_Time"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ReceiveTime:
		return "RoleMappingRuleChangedAuditEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_LocalTime:
		return "RoleMappingRuleChangedAuditEventType_LocalTime"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Message:
		return "RoleMappingRuleChangedAuditEventType_Message"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Severity:
		return "RoleMappingRuleChangedAuditEventType_Severity"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ActionTimeStamp:
		return "RoleMappingRuleChangedAuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_Status:
		return "RoleMappingRuleChangedAuditEventType_Status"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ServerId:
		return "RoleMappingRuleChangedAuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientAuditEntryId:
		return "RoleMappingRuleChangedAuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ClientUserId:
		return "RoleMappingRuleChangedAuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_MethodId:
		return "RoleMappingRuleChangedAuditEventType_MethodId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_InputArguments:
		return "RoleMappingRuleChangedAuditEventType_InputArguments"
	case OpcuaNodeIdServicesVariableRole_RoleSetType_RoleName_Placeholder_CustomConfiguration:
		return "RoleSetType_RoleName_Placeholder_CustomConfiguration"
	case OpcuaNodeIdServicesVariableRole_RoleType_CustomConfiguration:
		return "RoleType_CustomConfiguration"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassId:
		return "RoleMappingRuleChangedAuditEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionClassName:
		return "RoleMappingRuleChangedAuditEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassId:
		return "RoleMappingRuleChangedAuditEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableRole_RoleMappingRuleChangedAuditEventType_ConditionSubClassName:
		return "RoleMappingRuleChangedAuditEventType_ConditionSubClassName"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableRole) String() string {
	return e.PLC4XEnumName()
}
