/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableReader is an enum
type OpcuaNodeIdServicesVariableReader int32

type IOpcuaNodeIdServicesVariableReader interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_GroupProperties                                                                               OpcuaNodeIdServicesVariableReader = 17491
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties                                         OpcuaNodeIdServicesVariableReader = 17492
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount                                                   OpcuaNodeIdServicesVariableReader = 17560
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri                                                 OpcuaNodeIdServicesVariableReader = 17562
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityMode                                                                                  OpcuaNodeIdServicesVariableReader = 18000
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityGroupId                                                                               OpcuaNodeIdServicesVariableReader = 18002
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityKeyServices                                                                           OpcuaNodeIdServicesVariableReader = 18003
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_MaxNetworkMessageSize                                                                         OpcuaNodeIdServicesVariableReader = 18065
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Status_State                                                                                  OpcuaNodeIdServicesVariableReader = 18068
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId                                                     OpcuaNodeIdServicesVariableReader = 18077
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId                                                   OpcuaNodeIdServicesVariableReader = 18078
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId                                                 OpcuaNodeIdServicesVariableReader = 18079
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData                                                 OpcuaNodeIdServicesVariableReader = 18080
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask                                         OpcuaNodeIdServicesVariableReader = 18081
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout                                           OpcuaNodeIdServicesVariableReader = 18082
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode                                                    OpcuaNodeIdServicesVariableReader = 18083
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId                                                 OpcuaNodeIdServicesVariableReader = 18084
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices                                             OpcuaNodeIdServicesVariableReader = 18085
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Status_State                                                    OpcuaNodeIdServicesVariableReader = 18089
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel                                    OpcuaNodeIdServicesVariableReader = 18093
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation                                    OpcuaNodeIdServicesVariableReader = 18094
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active                             OpcuaNodeIdServicesVariableReader = 18095
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification                     OpcuaNodeIdServicesVariableReader = 18096
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                   OpcuaNodeIdServicesVariableReader = 18097
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                    OpcuaNodeIdServicesVariableReader = 18098
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError                                          OpcuaNodeIdServicesVariableReader = 18099
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active                                   OpcuaNodeIdServicesVariableReader = 18100
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification                           OpcuaNodeIdServicesVariableReader = 18101
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                         OpcuaNodeIdServicesVariableReader = 18102
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange                          OpcuaNodeIdServicesVariableReader = 18103
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError                                            OpcuaNodeIdServicesVariableReader = 18105
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError                                 OpcuaNodeIdServicesVariableReader = 18107
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active                          OpcuaNodeIdServicesVariableReader = 18108
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification                  OpcuaNodeIdServicesVariableReader = 18109
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                OpcuaNodeIdServicesVariableReader = 18110
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                 OpcuaNodeIdServicesVariableReader = 18111
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                   OpcuaNodeIdServicesVariableReader = 18112
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active            OpcuaNodeIdServicesVariableReader = 18113
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification    OpcuaNodeIdServicesVariableReader = 18114
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel  OpcuaNodeIdServicesVariableReader = 18115
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange   OpcuaNodeIdServicesVariableReader = 18116
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent                   OpcuaNodeIdServicesVariableReader = 18117
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active            OpcuaNodeIdServicesVariableReader = 18118
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification    OpcuaNodeIdServicesVariableReader = 18119
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel  OpcuaNodeIdServicesVariableReader = 18120
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange   OpcuaNodeIdServicesVariableReader = 18121
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError                  OpcuaNodeIdServicesVariableReader = 18122
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active           OpcuaNodeIdServicesVariableReader = 18123
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification   OpcuaNodeIdServicesVariableReader = 18124
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel OpcuaNodeIdServicesVariableReader = 18125
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange  OpcuaNodeIdServicesVariableReader = 18126
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent                        OpcuaNodeIdServicesVariableReader = 18127
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                 OpcuaNodeIdServicesVariableReader = 18128
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification         OpcuaNodeIdServicesVariableReader = 18129
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariableReader = 18130
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange        OpcuaNodeIdServicesVariableReader = 18131
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                      OpcuaNodeIdServicesVariableReader = 18132
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active               OpcuaNodeIdServicesVariableReader = 18133
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification       OpcuaNodeIdServicesVariableReader = 18134
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariableReader = 18135
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange      OpcuaNodeIdServicesVariableReader = 18136
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                      OpcuaNodeIdServicesVariableReader = 18138
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active               OpcuaNodeIdServicesVariableReader = 18139
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification       OpcuaNodeIdServicesVariableReader = 18140
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel     OpcuaNodeIdServicesVariableReader = 18141
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange      OpcuaNodeIdServicesVariableReader = 18142
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors                           OpcuaNodeIdServicesVariableReader = 18143
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active                    OpcuaNodeIdServicesVariableReader = 18144
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification            OpcuaNodeIdServicesVariableReader = 18145
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel          OpcuaNodeIdServicesVariableReader = 18146
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange           OpcuaNodeIdServicesVariableReader = 18147
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                    OpcuaNodeIdServicesVariableReader = 18148
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel   OpcuaNodeIdServicesVariableReader = 18149
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode                               OpcuaNodeIdServicesVariableReader = 18150
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel              OpcuaNodeIdServicesVariableReader = 18151
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion                             OpcuaNodeIdServicesVariableReader = 18152
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariableReader = 18153
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion                             OpcuaNodeIdServicesVariableReader = 18154
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariableReader = 18158
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID                          OpcuaNodeIdServicesVariableReader = 20409
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel         OpcuaNodeIdServicesVariableReader = 21003
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID                        OpcuaNodeIdServicesVariableReader = 21004
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel       OpcuaNodeIdServicesVariableReader = 21005
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments                            OpcuaNodeIdServicesVariableReader = 21010
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments                           OpcuaNodeIdServicesVariableReader = 21011
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments                              OpcuaNodeIdServicesVariableReader = 21013
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments                             OpcuaNodeIdServicesVariableReader = 21014
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_DiagnosticsLevel                                                                  OpcuaNodeIdServicesVariableReader = 21016
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation                                                                  OpcuaNodeIdServicesVariableReader = 21017
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Active                                                           OpcuaNodeIdServicesVariableReader = 21018
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Classification                                                   OpcuaNodeIdServicesVariableReader = 21019
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel                                                 OpcuaNodeIdServicesVariableReader = 21020
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange                                                  OpcuaNodeIdServicesVariableReader = 21021
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError                                                                        OpcuaNodeIdServicesVariableReader = 21022
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Active                                                                 OpcuaNodeIdServicesVariableReader = 21023
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Classification                                                         OpcuaNodeIdServicesVariableReader = 21024
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel                                                       OpcuaNodeIdServicesVariableReader = 21025
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_TimeFirstChange                                                        OpcuaNodeIdServicesVariableReader = 21026
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_SubError                                                                          OpcuaNodeIdServicesVariableReader = 21028
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError                                                               OpcuaNodeIdServicesVariableReader = 21030
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Active                                                        OpcuaNodeIdServicesVariableReader = 21031
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Classification                                                OpcuaNodeIdServicesVariableReader = 21032
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel                                              OpcuaNodeIdServicesVariableReader = 21033
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange                                               OpcuaNodeIdServicesVariableReader = 21034
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod                                                 OpcuaNodeIdServicesVariableReader = 21035
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active                                          OpcuaNodeIdServicesVariableReader = 21036
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification                                  OpcuaNodeIdServicesVariableReader = 21037
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel                                OpcuaNodeIdServicesVariableReader = 21038
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange                                 OpcuaNodeIdServicesVariableReader = 21039
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent                                                 OpcuaNodeIdServicesVariableReader = 21040
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active                                          OpcuaNodeIdServicesVariableReader = 21041
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification                                  OpcuaNodeIdServicesVariableReader = 21042
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel                                OpcuaNodeIdServicesVariableReader = 21043
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange                                 OpcuaNodeIdServicesVariableReader = 21044
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError                                                OpcuaNodeIdServicesVariableReader = 21045
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active                                         OpcuaNodeIdServicesVariableReader = 21046
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification                                 OpcuaNodeIdServicesVariableReader = 21047
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel                               OpcuaNodeIdServicesVariableReader = 21048
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange                                OpcuaNodeIdServicesVariableReader = 21049
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent                                                      OpcuaNodeIdServicesVariableReader = 21050
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active                                               OpcuaNodeIdServicesVariableReader = 21051
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification                                       OpcuaNodeIdServicesVariableReader = 21052
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel                                     OpcuaNodeIdServicesVariableReader = 21053
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange                                      OpcuaNodeIdServicesVariableReader = 21054
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod                                                    OpcuaNodeIdServicesVariableReader = 21055
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active                                             OpcuaNodeIdServicesVariableReader = 21056
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification                                     OpcuaNodeIdServicesVariableReader = 21057
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel                                   OpcuaNodeIdServicesVariableReader = 21058
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange                                    OpcuaNodeIdServicesVariableReader = 21059
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages                                                  OpcuaNodeIdServicesVariableReader = 21061
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active                                           OpcuaNodeIdServicesVariableReader = 21062
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification                                   OpcuaNodeIdServicesVariableReader = 21063
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel                                 OpcuaNodeIdServicesVariableReader = 21064
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange                                  OpcuaNodeIdServicesVariableReader = 21065
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages                                           OpcuaNodeIdServicesVariableReader = 21066
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active                                    OpcuaNodeIdServicesVariableReader = 21067
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification                            OpcuaNodeIdServicesVariableReader = 21068
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel                          OpcuaNodeIdServicesVariableReader = 21069
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange                           OpcuaNodeIdServicesVariableReader = 21070
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors                                                         OpcuaNodeIdServicesVariableReader = 21071
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active                                                  OpcuaNodeIdServicesVariableReader = 21072
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification                                          OpcuaNodeIdServicesVariableReader = 21073
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel                                        OpcuaNodeIdServicesVariableReader = 21074
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange                                         OpcuaNodeIdServicesVariableReader = 21075
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders                                               OpcuaNodeIdServicesVariableReader = 21076
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel                              OpcuaNodeIdServicesVariableReader = 21077
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders                                              OpcuaNodeIdServicesVariableReader = 21078
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel                             OpcuaNodeIdServicesVariableReader = 21079
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_InputArguments                                                               OpcuaNodeIdServicesVariableReader = 21083
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_OutputArguments                                                              OpcuaNodeIdServicesVariableReader = 21084
	OpcuaNodeIdServicesVariableReader_ReaderGroupType_RemoveDataSetReader_InputArguments                                                            OpcuaNodeIdServicesVariableReader = 21086
)

var OpcuaNodeIdServicesVariableReaderValues []OpcuaNodeIdServicesVariableReader

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableReaderValues = []OpcuaNodeIdServicesVariableReader{
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_GroupProperties,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityMode,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityGroupId,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityKeyServices,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_MaxNetworkMessageSize,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Status_State,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_SubError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_InputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_OutputArguments,
		OpcuaNodeIdServicesVariableReader_ReaderGroupType_RemoveDataSetReader_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableReaderByValue(value int32) (enum OpcuaNodeIdServicesVariableReader, ok bool) {
	switch value {
	case 17491:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_GroupProperties, true
	case 17492:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties, true
	case 17560:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount, true
	case 17562:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri, true
	case 18000:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityMode, true
	case 18002:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityGroupId, true
	case 18003:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityKeyServices, true
	case 18065:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_MaxNetworkMessageSize, true
	case 18068:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Status_State, true
	case 18077:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId, true
	case 18078:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId, true
	case 18079:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId, true
	case 18080:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData, true
	case 18081:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask, true
	case 18082:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout, true
	case 18083:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode, true
	case 18084:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId, true
	case 18085:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices, true
	case 18089:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Status_State, true
	case 18093:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18094:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation, true
	case 18095:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18096:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18097:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18098:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18099:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError, true
	case 18100:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active, true
	case 18101:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18102:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18103:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 18105:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError, true
	case 18107:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError, true
	case 18108:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 18109:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 18110:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18111:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18112:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 18113:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18114:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18115:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18116:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18117:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 18118:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18119:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18120:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18121:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18122:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 18123:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18124:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18125:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18126:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18127:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 18128:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18129:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18130:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18131:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18132:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 18133:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18134:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18135:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18136:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18138:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 18139:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 18140:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 18141:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 18142:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 18143:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors, true
	case 18144:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active, true
	case 18145:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification, true
	case 18146:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case 18147:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case 18148:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 18149:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 18150:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 18151:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 18152:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 18153:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 18154:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 18158:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 20409:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID, true
	case 21003:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case 21004:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID, true
	case 21005:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case 21010:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments, true
	case 21011:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments, true
	case 21013:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments, true
	case 21014:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments, true
	case 21016:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_DiagnosticsLevel, true
	case 21017:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation, true
	case 21018:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Active, true
	case 21019:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Classification, true
	case 21020:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 21021:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange, true
	case 21022:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError, true
	case 21023:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Active, true
	case 21024:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Classification, true
	case 21025:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel, true
	case 21026:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_TimeFirstChange, true
	case 21028:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_SubError, true
	case 21030:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError, true
	case 21031:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Active, true
	case 21032:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Classification, true
	case 21033:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 21034:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 21035:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod, true
	case 21036:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 21037:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 21038:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 21039:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 21040:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent, true
	case 21041:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 21042:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 21043:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 21044:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 21045:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError, true
	case 21046:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 21047:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 21048:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 21049:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 21050:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent, true
	case 21051:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active, true
	case 21052:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 21053:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 21054:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 21055:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod, true
	case 21056:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 21057:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 21058:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 21059:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 21061:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages, true
	case 21062:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active, true
	case 21063:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification, true
	case 21064:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case 21065:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case 21066:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages, true
	case 21067:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active, true
	case 21068:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case 21069:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case 21070:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case 21071:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors, true
	case 21072:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active, true
	case 21073:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification, true
	case 21074:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case 21075:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case 21076:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case 21077:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 21078:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case 21079:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 21083:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_InputArguments, true
	case 21084:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_OutputArguments, true
	case 21086:
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_RemoveDataSetReader_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableReaderByName(value string) (enum OpcuaNodeIdServicesVariableReader, ok bool) {
	switch value {
	case "ReaderGroupType_GroupProperties":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_GroupProperties, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri, true
	case "ReaderGroupType_SecurityMode":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityMode, true
	case "ReaderGroupType_SecurityGroupId":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityGroupId, true
	case "ReaderGroupType_SecurityKeyServices":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityKeyServices, true
	case "ReaderGroupType_MaxNetworkMessageSize":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_MaxNetworkMessageSize, true
	case "ReaderGroupType_Status_State":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Status_State, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_PublisherId":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Status_State, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments, true
	case "ReaderGroupType_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation, true
	case "ReaderGroupType_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Active, true
	case "ReaderGroupType_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Classification, true
	case "ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError, true
	case "ReaderGroupType_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Active, true
	case "ReaderGroupType_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Classification, true
	case "ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_SubError, true
	case "ReaderGroupType_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError, true
	case "ReaderGroupType_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent, true
	case "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod, true
	case "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_Counters_DecryptionErrors":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors, true
	case "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active, true
	case "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification, true
	case "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange, true
	case "ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case "ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case "ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "ReaderGroupType_AddDataSetReader_InputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_InputArguments, true
	case "ReaderGroupType_AddDataSetReader_OutputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_OutputArguments, true
	case "ReaderGroupType_RemoveDataSetReader_InputArguments":
		return OpcuaNodeIdServicesVariableReader_ReaderGroupType_RemoveDataSetReader_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableReaderKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableReaderValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableReader(structType any) OpcuaNodeIdServicesVariableReader {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableReader {
		if sOpcuaNodeIdServicesVariableReader, ok := typ.(OpcuaNodeIdServicesVariableReader); ok {
			return sOpcuaNodeIdServicesVariableReader
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableReader) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableReader) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableReaderParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableReader, error) {
	return OpcuaNodeIdServicesVariableReaderParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableReaderParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableReader, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableReader", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableReader")
	}
	if enum, ok := OpcuaNodeIdServicesVariableReaderByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableReader")
		return OpcuaNodeIdServicesVariableReader(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableReader) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableReader) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableReader", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableReader) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_GroupProperties:
		return "ReaderGroupType_GroupProperties"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties:
		return "ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount:
		return "ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri:
		return "ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityMode:
		return "ReaderGroupType_SecurityMode"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityGroupId:
		return "ReaderGroupType_SecurityGroupId"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_SecurityKeyServices:
		return "ReaderGroupType_SecurityKeyServices"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_MaxNetworkMessageSize:
		return "ReaderGroupType_MaxNetworkMessageSize"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Status_State:
		return "ReaderGroupType_Status_State"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId:
		return "ReaderGroupType_DataSetReaderName_Placeholder_PublisherId"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId:
		return "ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId:
		return "ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData:
		return "ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask:
		return "ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout:
		return "ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode:
		return "ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId:
		return "ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices:
		return "ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Status_State:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments:
		return "ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments:
		return "ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments:
		return "ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments:
		return "ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation:
		return "ReaderGroupType_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Active:
		return "ReaderGroupType_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_Classification:
		return "ReaderGroupType_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError:
		return "ReaderGroupType_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Active:
		return "ReaderGroupType_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_Classification:
		return "ReaderGroupType_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_TotalError_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_SubError:
		return "ReaderGroupType_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError:
		return "ReaderGroupType_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Active:
		return "ReaderGroupType_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent:
		return "ReaderGroupType_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active:
		return "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod:
		return "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors:
		return "ReaderGroupType_Diagnostics_Counters_DecryptionErrors"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active:
		return "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification:
		return "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange:
		return "ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders:
		return "ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders:
		return "ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_InputArguments:
		return "ReaderGroupType_AddDataSetReader_InputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_AddDataSetReader_OutputArguments:
		return "ReaderGroupType_AddDataSetReader_OutputArguments"
	case OpcuaNodeIdServicesVariableReader_ReaderGroupType_RemoveDataSetReader_InputArguments:
		return "ReaderGroupType_RemoveDataSetReader_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableReader) String() string {
	return e.PLC4XEnumName()
}
