/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableProgram is an enum
type OpcuaNodeIdServicesVariableProgram int32

type IOpcuaNodeIdServicesVariableProgram interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_IntermediateResult                       OpcuaNodeIdServicesVariableProgram = 2379
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateSessionId                               OpcuaNodeIdServicesVariableProgram = 2381
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateClientName                              OpcuaNodeIdServicesVariableProgram = 2382
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_InvocationCreationTime                        OpcuaNodeIdServicesVariableProgram = 2383
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastTransitionTime                            OpcuaNodeIdServicesVariableProgram = 2384
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCall                                OpcuaNodeIdServicesVariableProgram = 2385
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodSessionId                           OpcuaNodeIdServicesVariableProgram = 2386
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodInputArguments                      OpcuaNodeIdServicesVariableProgram = 2387
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodOutputArguments                     OpcuaNodeIdServicesVariableProgram = 2388
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCallTime                            OpcuaNodeIdServicesVariableProgram = 2389
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodReturnStatus                        OpcuaNodeIdServicesVariableProgram = 2390
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Creatable                                   OpcuaNodeIdServicesVariableProgram = 2392
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Deletable                                   OpcuaNodeIdServicesVariableProgram = 2393
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AutoDelete                                  OpcuaNodeIdServicesVariableProgram = 2394
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RecycleCount                                OpcuaNodeIdServicesVariableProgram = 2395
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_InstanceCount                               OpcuaNodeIdServicesVariableProgram = 2396
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxInstanceCount                            OpcuaNodeIdServicesVariableProgram = 2397
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxRecycleCount                             OpcuaNodeIdServicesVariableProgram = 2398
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic                           OpcuaNodeIdServicesVariableProgram = 2399
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Ready_StateNumber                           OpcuaNodeIdServicesVariableProgram = 2401
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Running_StateNumber                         OpcuaNodeIdServicesVariableProgram = 2403
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Suspended_StateNumber                       OpcuaNodeIdServicesVariableProgram = 2405
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Halted_StateNumber                          OpcuaNodeIdServicesVariableProgram = 2407
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_HaltedToReady_TransitionNumber              OpcuaNodeIdServicesVariableProgram = 2409
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToRunning_TransitionNumber             OpcuaNodeIdServicesVariableProgram = 2411
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToHalted_TransitionNumber            OpcuaNodeIdServicesVariableProgram = 2413
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToReady_TransitionNumber             OpcuaNodeIdServicesVariableProgram = 2415
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToSuspended_TransitionNumber         OpcuaNodeIdServicesVariableProgram = 2417
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToRunning_TransitionNumber         OpcuaNodeIdServicesVariableProgram = 2419
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToHalted_TransitionNumber          OpcuaNodeIdServicesVariableProgram = 2421
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToReady_TransitionNumber           OpcuaNodeIdServicesVariableProgram = 2423
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToHalted_TransitionNumber              OpcuaNodeIdServicesVariableProgram = 2425
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventId                                  OpcuaNodeIdServicesVariableProgram = 3782
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventType                                OpcuaNodeIdServicesVariableProgram = 3783
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceNode                               OpcuaNodeIdServicesVariableProgram = 3784
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceName                               OpcuaNodeIdServicesVariableProgram = 3785
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Time                                     OpcuaNodeIdServicesVariableProgram = 3786
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ReceiveTime                              OpcuaNodeIdServicesVariableProgram = 3787
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_LocalTime                                OpcuaNodeIdServicesVariableProgram = 3788
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Message                                  OpcuaNodeIdServicesVariableProgram = 3789
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Severity                                 OpcuaNodeIdServicesVariableProgram = 3790
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState                                OpcuaNodeIdServicesVariableProgram = 3791
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Id                             OpcuaNodeIdServicesVariableProgram = 3792
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Name                           OpcuaNodeIdServicesVariableProgram = 3793
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Number                         OpcuaNodeIdServicesVariableProgram = 3794
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_EffectiveDisplayName           OpcuaNodeIdServicesVariableProgram = 3795
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState                                  OpcuaNodeIdServicesVariableProgram = 3796
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Id                               OpcuaNodeIdServicesVariableProgram = 3797
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Name                             OpcuaNodeIdServicesVariableProgram = 3798
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Number                           OpcuaNodeIdServicesVariableProgram = 3799
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_EffectiveDisplayName             OpcuaNodeIdServicesVariableProgram = 3800
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition                               OpcuaNodeIdServicesVariableProgram = 3801
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Id                            OpcuaNodeIdServicesVariableProgram = 3802
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Name                          OpcuaNodeIdServicesVariableProgram = 3803
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Number                        OpcuaNodeIdServicesVariableProgram = 3804
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_TransitionTime                OpcuaNodeIdServicesVariableProgram = 3805
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventId                             OpcuaNodeIdServicesVariableProgram = 3807
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventType                           OpcuaNodeIdServicesVariableProgram = 3808
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceNode                          OpcuaNodeIdServicesVariableProgram = 3809
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceName                          OpcuaNodeIdServicesVariableProgram = 3810
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Time                                OpcuaNodeIdServicesVariableProgram = 3811
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ReceiveTime                         OpcuaNodeIdServicesVariableProgram = 3812
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_LocalTime                           OpcuaNodeIdServicesVariableProgram = 3813
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Message                             OpcuaNodeIdServicesVariableProgram = 3814
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Severity                            OpcuaNodeIdServicesVariableProgram = 3815
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ActionTimeStamp                     OpcuaNodeIdServicesVariableProgram = 3816
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Status                              OpcuaNodeIdServicesVariableProgram = 3817
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ServerId                            OpcuaNodeIdServicesVariableProgram = 3818
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientAuditEntryId                  OpcuaNodeIdServicesVariableProgram = 3819
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientUserId                        OpcuaNodeIdServicesVariableProgram = 3820
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_MethodId                            OpcuaNodeIdServicesVariableProgram = 3821
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_InputArguments                      OpcuaNodeIdServicesVariableProgram = 3822
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_OldStateId                          OpcuaNodeIdServicesVariableProgram = 3823
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_NewStateId                          OpcuaNodeIdServicesVariableProgram = 3824
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition                          OpcuaNodeIdServicesVariableProgram = 3825
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Id                       OpcuaNodeIdServicesVariableProgram = 3826
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Name                     OpcuaNodeIdServicesVariableProgram = 3827
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Number                   OpcuaNodeIdServicesVariableProgram = 3828
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_TransitionTime           OpcuaNodeIdServicesVariableProgram = 3829
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState                                OpcuaNodeIdServicesVariableProgram = 3830
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Id                             OpcuaNodeIdServicesVariableProgram = 3831
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Name                           OpcuaNodeIdServicesVariableProgram = 3832
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Number                         OpcuaNodeIdServicesVariableProgram = 3833
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_EffectiveDisplayName           OpcuaNodeIdServicesVariableProgram = 3834
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition                              OpcuaNodeIdServicesVariableProgram = 3835
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Id                           OpcuaNodeIdServicesVariableProgram = 3836
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Name                         OpcuaNodeIdServicesVariableProgram = 3837
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Number                       OpcuaNodeIdServicesVariableProgram = 3838
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_TransitionTime               OpcuaNodeIdServicesVariableProgram = 3839
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId           OpcuaNodeIdServicesVariableProgram = 3840
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateClientName          OpcuaNodeIdServicesVariableProgram = 3841
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime    OpcuaNodeIdServicesVariableProgram = 3842
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime        OpcuaNodeIdServicesVariableProgram = 3843
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall            OpcuaNodeIdServicesVariableProgram = 3844
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId       OpcuaNodeIdServicesVariableProgram = 3845
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments  OpcuaNodeIdServicesVariableProgram = 3846
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments OpcuaNodeIdServicesVariableProgram = 3847
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime        OpcuaNodeIdServicesVariableProgram = 3848
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus    OpcuaNodeIdServicesVariableProgram = 3849
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableProgram = 11462
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime  OpcuaNodeIdServicesVariableProgram = 11463
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_EffectiveTransitionTime      OpcuaNodeIdServicesVariableProgram = 11464
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues     OpcuaNodeIdServicesVariableProgram = 15038
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues    OpcuaNodeIdServicesVariableProgram = 15040
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateSessionId                              OpcuaNodeIdServicesVariableProgram = 15384
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateClientName                             OpcuaNodeIdServicesVariableProgram = 15385
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_InvocationCreationTime                       OpcuaNodeIdServicesVariableProgram = 15386
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastTransitionTime                           OpcuaNodeIdServicesVariableProgram = 15387
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCall                               OpcuaNodeIdServicesVariableProgram = 15388
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodSessionId                          OpcuaNodeIdServicesVariableProgram = 15389
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputArguments                     OpcuaNodeIdServicesVariableProgram = 15390
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputArguments                    OpcuaNodeIdServicesVariableProgram = 15391
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputValues                        OpcuaNodeIdServicesVariableProgram = 15392
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputValues                       OpcuaNodeIdServicesVariableProgram = 15393
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCallTime                           OpcuaNodeIdServicesVariableProgram = 15394
	OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodReturnStatus                       OpcuaNodeIdServicesVariableProgram = 15395
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableStates                             OpcuaNodeIdServicesVariableProgram = 17704
	OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableTransitions                        OpcuaNodeIdServicesVariableProgram = 17705
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassId                         OpcuaNodeIdServicesVariableProgram = 31987
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassName                       OpcuaNodeIdServicesVariableProgram = 31988
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassId                      OpcuaNodeIdServicesVariableProgram = 31989
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassName                    OpcuaNodeIdServicesVariableProgram = 31990
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassId                    OpcuaNodeIdServicesVariableProgram = 31995
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassName                  OpcuaNodeIdServicesVariableProgram = 31996
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassId                 OpcuaNodeIdServicesVariableProgram = 31997
	OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassName               OpcuaNodeIdServicesVariableProgram = 31998
)

var OpcuaNodeIdServicesVariableProgramValues []OpcuaNodeIdServicesVariableProgram

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableProgramValues = []OpcuaNodeIdServicesVariableProgram{
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_IntermediateResult,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateClientName,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_InvocationCreationTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCall,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodInputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodOutputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCallTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodReturnStatus,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Creatable,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Deletable,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AutoDelete,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RecycleCount,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_InstanceCount,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxInstanceCount,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxRecycleCount,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Ready_StateNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Running_StateNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Suspended_StateNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Halted_StateNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_HaltedToReady_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToRunning_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToHalted_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToReady_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToSuspended_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToRunning_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToHalted_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToReady_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToHalted_TransitionNumber,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventType,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceNode,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Time,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_LocalTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Message,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Severity,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_TransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventType,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Time,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Message,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Severity,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Status,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_MethodId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_InputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_OldStateId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_NewStateId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_TransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Id,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Name,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Number,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateClientName,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateClientName,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_InvocationCreationTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastTransitionTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCall,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodSessionId,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputArguments,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputValues,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputValues,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCallTime,
		OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodReturnStatus,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableStates,
		OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableTransitions,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassName,
	}
}

func OpcuaNodeIdServicesVariableProgramByValue(value int32) (enum OpcuaNodeIdServicesVariableProgram, ok bool) {
	switch value {
	case 11462:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_EffectiveTransitionTime, true
	case 11463:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime, true
	case 11464:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_EffectiveTransitionTime, true
	case 15038:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues, true
	case 15040:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues, true
	case 15384:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateSessionId, true
	case 15385:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateClientName, true
	case 15386:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_InvocationCreationTime, true
	case 15387:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastTransitionTime, true
	case 15388:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCall, true
	case 15389:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodSessionId, true
	case 15390:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputArguments, true
	case 15391:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputArguments, true
	case 15392:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputValues, true
	case 15393:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputValues, true
	case 15394:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCallTime, true
	case 15395:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodReturnStatus, true
	case 17704:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableStates, true
	case 17705:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableTransitions, true
	case 2379:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_IntermediateResult, true
	case 2381:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateSessionId, true
	case 2382:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateClientName, true
	case 2383:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_InvocationCreationTime, true
	case 2384:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastTransitionTime, true
	case 2385:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCall, true
	case 2386:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodSessionId, true
	case 2387:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodInputArguments, true
	case 2388:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodOutputArguments, true
	case 2389:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCallTime, true
	case 2390:
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodReturnStatus, true
	case 2392:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Creatable, true
	case 2393:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Deletable, true
	case 2394:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AutoDelete, true
	case 2395:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RecycleCount, true
	case 2396:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_InstanceCount, true
	case 2397:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxInstanceCount, true
	case 2398:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxRecycleCount, true
	case 2399:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic, true
	case 2401:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Ready_StateNumber, true
	case 2403:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Running_StateNumber, true
	case 2405:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Suspended_StateNumber, true
	case 2407:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Halted_StateNumber, true
	case 2409:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_HaltedToReady_TransitionNumber, true
	case 2411:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToRunning_TransitionNumber, true
	case 2413:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToHalted_TransitionNumber, true
	case 2415:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToReady_TransitionNumber, true
	case 2417:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToSuspended_TransitionNumber, true
	case 2419:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToRunning_TransitionNumber, true
	case 2421:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToHalted_TransitionNumber, true
	case 2423:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToReady_TransitionNumber, true
	case 2425:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToHalted_TransitionNumber, true
	case 31987:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassId, true
	case 31988:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassName, true
	case 31989:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassId, true
	case 31990:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassName, true
	case 31995:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassId, true
	case 31996:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassName, true
	case 31997:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassId, true
	case 31998:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassName, true
	case 3782:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventId, true
	case 3783:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventType, true
	case 3784:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceNode, true
	case 3785:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceName, true
	case 3786:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Time, true
	case 3787:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ReceiveTime, true
	case 3788:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_LocalTime, true
	case 3789:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Message, true
	case 3790:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Severity, true
	case 3791:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState, true
	case 3792:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Id, true
	case 3793:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Name, true
	case 3794:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Number, true
	case 3795:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_EffectiveDisplayName, true
	case 3796:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState, true
	case 3797:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Id, true
	case 3798:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Name, true
	case 3799:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Number, true
	case 3800:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_EffectiveDisplayName, true
	case 3801:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition, true
	case 3802:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Id, true
	case 3803:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Name, true
	case 3804:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Number, true
	case 3805:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_TransitionTime, true
	case 3807:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventId, true
	case 3808:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventType, true
	case 3809:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceNode, true
	case 3810:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceName, true
	case 3811:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Time, true
	case 3812:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ReceiveTime, true
	case 3813:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_LocalTime, true
	case 3814:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Message, true
	case 3815:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Severity, true
	case 3816:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ActionTimeStamp, true
	case 3817:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Status, true
	case 3818:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ServerId, true
	case 3819:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientAuditEntryId, true
	case 3820:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientUserId, true
	case 3821:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_MethodId, true
	case 3822:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_InputArguments, true
	case 3823:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_OldStateId, true
	case 3824:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_NewStateId, true
	case 3825:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition, true
	case 3826:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Id, true
	case 3827:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Name, true
	case 3828:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Number, true
	case 3829:
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_TransitionTime, true
	case 3830:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState, true
	case 3831:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Id, true
	case 3832:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Name, true
	case 3833:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Number, true
	case 3834:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_EffectiveDisplayName, true
	case 3835:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition, true
	case 3836:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Id, true
	case 3837:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Name, true
	case 3838:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Number, true
	case 3839:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_TransitionTime, true
	case 3840:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId, true
	case 3841:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateClientName, true
	case 3842:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime, true
	case 3843:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime, true
	case 3844:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall, true
	case 3845:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId, true
	case 3846:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments, true
	case 3847:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments, true
	case 3848:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime, true
	case 3849:
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableProgramByName(value string) (enum OpcuaNodeIdServicesVariableProgram, ok bool) {
	switch value {
	case "ProgramTransitionEventType_Transition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_EffectiveTransitionTime, true
	case "ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime, true
	case "ProgramStateMachineType_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_EffectiveTransitionTime, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues, true
	case "ProgramDiagnostic2Type_CreateSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateSessionId, true
	case "ProgramDiagnostic2Type_CreateClientName":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateClientName, true
	case "ProgramDiagnostic2Type_InvocationCreationTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_InvocationCreationTime, true
	case "ProgramDiagnostic2Type_LastTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastTransitionTime, true
	case "ProgramDiagnostic2Type_LastMethodCall":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCall, true
	case "ProgramDiagnostic2Type_LastMethodSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodSessionId, true
	case "ProgramDiagnostic2Type_LastMethodInputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputArguments, true
	case "ProgramDiagnostic2Type_LastMethodOutputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputArguments, true
	case "ProgramDiagnostic2Type_LastMethodInputValues":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputValues, true
	case "ProgramDiagnostic2Type_LastMethodOutputValues":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputValues, true
	case "ProgramDiagnostic2Type_LastMethodCallTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCallTime, true
	case "ProgramDiagnostic2Type_LastMethodReturnStatus":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodReturnStatus, true
	case "ProgramStateMachineType_AvailableStates":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableStates, true
	case "ProgramStateMachineType_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableTransitions, true
	case "ProgramTransitionEventType_IntermediateResult":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_IntermediateResult, true
	case "ProgramDiagnosticType_CreateSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateSessionId, true
	case "ProgramDiagnosticType_CreateClientName":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateClientName, true
	case "ProgramDiagnosticType_InvocationCreationTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_InvocationCreationTime, true
	case "ProgramDiagnosticType_LastTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastTransitionTime, true
	case "ProgramDiagnosticType_LastMethodCall":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCall, true
	case "ProgramDiagnosticType_LastMethodSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodSessionId, true
	case "ProgramDiagnosticType_LastMethodInputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodInputArguments, true
	case "ProgramDiagnosticType_LastMethodOutputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodOutputArguments, true
	case "ProgramDiagnosticType_LastMethodCallTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCallTime, true
	case "ProgramDiagnosticType_LastMethodReturnStatus":
		return OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodReturnStatus, true
	case "ProgramStateMachineType_Creatable":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Creatable, true
	case "ProgramStateMachineType_Deletable":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Deletable, true
	case "ProgramStateMachineType_AutoDelete":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AutoDelete, true
	case "ProgramStateMachineType_RecycleCount":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RecycleCount, true
	case "ProgramStateMachineType_InstanceCount":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_InstanceCount, true
	case "ProgramStateMachineType_MaxInstanceCount":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxInstanceCount, true
	case "ProgramStateMachineType_MaxRecycleCount":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxRecycleCount, true
	case "ProgramStateMachineType_ProgramDiagnostic":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic, true
	case "ProgramStateMachineType_Ready_StateNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Ready_StateNumber, true
	case "ProgramStateMachineType_Running_StateNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Running_StateNumber, true
	case "ProgramStateMachineType_Suspended_StateNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Suspended_StateNumber, true
	case "ProgramStateMachineType_Halted_StateNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Halted_StateNumber, true
	case "ProgramStateMachineType_HaltedToReady_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_HaltedToReady_TransitionNumber, true
	case "ProgramStateMachineType_ReadyToRunning_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToRunning_TransitionNumber, true
	case "ProgramStateMachineType_RunningToHalted_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToHalted_TransitionNumber, true
	case "ProgramStateMachineType_RunningToReady_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToReady_TransitionNumber, true
	case "ProgramStateMachineType_RunningToSuspended_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToSuspended_TransitionNumber, true
	case "ProgramStateMachineType_SuspendedToRunning_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToRunning_TransitionNumber, true
	case "ProgramStateMachineType_SuspendedToHalted_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToHalted_TransitionNumber, true
	case "ProgramStateMachineType_SuspendedToReady_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToReady_TransitionNumber, true
	case "ProgramStateMachineType_ReadyToHalted_TransitionNumber":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToHalted_TransitionNumber, true
	case "ProgramTransitionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassId, true
	case "ProgramTransitionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassName, true
	case "ProgramTransitionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassId, true
	case "ProgramTransitionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassName, true
	case "ProgramTransitionAuditEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassId, true
	case "ProgramTransitionAuditEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassName, true
	case "ProgramTransitionAuditEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassId, true
	case "ProgramTransitionAuditEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassName, true
	case "ProgramTransitionEventType_EventId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventId, true
	case "ProgramTransitionEventType_EventType":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventType, true
	case "ProgramTransitionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceNode, true
	case "ProgramTransitionEventType_SourceName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceName, true
	case "ProgramTransitionEventType_Time":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Time, true
	case "ProgramTransitionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ReceiveTime, true
	case "ProgramTransitionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_LocalTime, true
	case "ProgramTransitionEventType_Message":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Message, true
	case "ProgramTransitionEventType_Severity":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Severity, true
	case "ProgramTransitionEventType_FromState":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState, true
	case "ProgramTransitionEventType_FromState_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Id, true
	case "ProgramTransitionEventType_FromState_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Name, true
	case "ProgramTransitionEventType_FromState_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Number, true
	case "ProgramTransitionEventType_FromState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_EffectiveDisplayName, true
	case "ProgramTransitionEventType_ToState":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState, true
	case "ProgramTransitionEventType_ToState_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Id, true
	case "ProgramTransitionEventType_ToState_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Name, true
	case "ProgramTransitionEventType_ToState_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Number, true
	case "ProgramTransitionEventType_ToState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_EffectiveDisplayName, true
	case "ProgramTransitionEventType_Transition":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition, true
	case "ProgramTransitionEventType_Transition_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Id, true
	case "ProgramTransitionEventType_Transition_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Name, true
	case "ProgramTransitionEventType_Transition_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Number, true
	case "ProgramTransitionEventType_Transition_TransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_TransitionTime, true
	case "ProgramTransitionAuditEventType_EventId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventId, true
	case "ProgramTransitionAuditEventType_EventType":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventType, true
	case "ProgramTransitionAuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceNode, true
	case "ProgramTransitionAuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceName, true
	case "ProgramTransitionAuditEventType_Time":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Time, true
	case "ProgramTransitionAuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ReceiveTime, true
	case "ProgramTransitionAuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_LocalTime, true
	case "ProgramTransitionAuditEventType_Message":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Message, true
	case "ProgramTransitionAuditEventType_Severity":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Severity, true
	case "ProgramTransitionAuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ActionTimeStamp, true
	case "ProgramTransitionAuditEventType_Status":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Status, true
	case "ProgramTransitionAuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ServerId, true
	case "ProgramTransitionAuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientAuditEntryId, true
	case "ProgramTransitionAuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientUserId, true
	case "ProgramTransitionAuditEventType_MethodId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_MethodId, true
	case "ProgramTransitionAuditEventType_InputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_InputArguments, true
	case "ProgramTransitionAuditEventType_OldStateId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_OldStateId, true
	case "ProgramTransitionAuditEventType_NewStateId":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_NewStateId, true
	case "ProgramTransitionAuditEventType_Transition":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition, true
	case "ProgramTransitionAuditEventType_Transition_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Id, true
	case "ProgramTransitionAuditEventType_Transition_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Name, true
	case "ProgramTransitionAuditEventType_Transition_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Number, true
	case "ProgramTransitionAuditEventType_Transition_TransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_TransitionTime, true
	case "ProgramStateMachineType_CurrentState":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState, true
	case "ProgramStateMachineType_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Id, true
	case "ProgramStateMachineType_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Name, true
	case "ProgramStateMachineType_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Number, true
	case "ProgramStateMachineType_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_EffectiveDisplayName, true
	case "ProgramStateMachineType_LastTransition":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition, true
	case "ProgramStateMachineType_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Id, true
	case "ProgramStateMachineType_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Name, true
	case "ProgramStateMachineType_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Number, true
	case "ProgramStateMachineType_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_TransitionTime, true
	case "ProgramStateMachineType_ProgramDiagnostic_CreateSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId, true
	case "ProgramStateMachineType_ProgramDiagnostic_CreateClientName":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateClientName, true
	case "ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodCall":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime, true
	case "ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus":
		return OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableProgramKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableProgramValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableProgram(structType any) OpcuaNodeIdServicesVariableProgram {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableProgram {
		if sOpcuaNodeIdServicesVariableProgram, ok := typ.(OpcuaNodeIdServicesVariableProgram); ok {
			return sOpcuaNodeIdServicesVariableProgram
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableProgram) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableProgram) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableProgramParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableProgram, error) {
	return OpcuaNodeIdServicesVariableProgramParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableProgramParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableProgram, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableProgram", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableProgram")
	}
	if enum, ok := OpcuaNodeIdServicesVariableProgramByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableProgram")
		return OpcuaNodeIdServicesVariableProgram(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableProgram) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableProgram) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableProgram", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableProgram) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_EffectiveTransitionTime:
		return "ProgramTransitionEventType_Transition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime:
		return "ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_EffectiveTransitionTime:
		return "ProgramStateMachineType_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateSessionId:
		return "ProgramDiagnostic2Type_CreateSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_CreateClientName:
		return "ProgramDiagnostic2Type_CreateClientName"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_InvocationCreationTime:
		return "ProgramDiagnostic2Type_InvocationCreationTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastTransitionTime:
		return "ProgramDiagnostic2Type_LastTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCall:
		return "ProgramDiagnostic2Type_LastMethodCall"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodSessionId:
		return "ProgramDiagnostic2Type_LastMethodSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputArguments:
		return "ProgramDiagnostic2Type_LastMethodInputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputArguments:
		return "ProgramDiagnostic2Type_LastMethodOutputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodInputValues:
		return "ProgramDiagnostic2Type_LastMethodInputValues"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodOutputValues:
		return "ProgramDiagnostic2Type_LastMethodOutputValues"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodCallTime:
		return "ProgramDiagnostic2Type_LastMethodCallTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnostic2Type_LastMethodReturnStatus:
		return "ProgramDiagnostic2Type_LastMethodReturnStatus"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableStates:
		return "ProgramStateMachineType_AvailableStates"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AvailableTransitions:
		return "ProgramStateMachineType_AvailableTransitions"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_IntermediateResult:
		return "ProgramTransitionEventType_IntermediateResult"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateSessionId:
		return "ProgramDiagnosticType_CreateSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_CreateClientName:
		return "ProgramDiagnosticType_CreateClientName"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_InvocationCreationTime:
		return "ProgramDiagnosticType_InvocationCreationTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastTransitionTime:
		return "ProgramDiagnosticType_LastTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCall:
		return "ProgramDiagnosticType_LastMethodCall"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodSessionId:
		return "ProgramDiagnosticType_LastMethodSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodInputArguments:
		return "ProgramDiagnosticType_LastMethodInputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodOutputArguments:
		return "ProgramDiagnosticType_LastMethodOutputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodCallTime:
		return "ProgramDiagnosticType_LastMethodCallTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramDiagnosticType_LastMethodReturnStatus:
		return "ProgramDiagnosticType_LastMethodReturnStatus"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Creatable:
		return "ProgramStateMachineType_Creatable"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Deletable:
		return "ProgramStateMachineType_Deletable"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_AutoDelete:
		return "ProgramStateMachineType_AutoDelete"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RecycleCount:
		return "ProgramStateMachineType_RecycleCount"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_InstanceCount:
		return "ProgramStateMachineType_InstanceCount"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxInstanceCount:
		return "ProgramStateMachineType_MaxInstanceCount"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_MaxRecycleCount:
		return "ProgramStateMachineType_MaxRecycleCount"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic:
		return "ProgramStateMachineType_ProgramDiagnostic"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Ready_StateNumber:
		return "ProgramStateMachineType_Ready_StateNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Running_StateNumber:
		return "ProgramStateMachineType_Running_StateNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Suspended_StateNumber:
		return "ProgramStateMachineType_Suspended_StateNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_Halted_StateNumber:
		return "ProgramStateMachineType_Halted_StateNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_HaltedToReady_TransitionNumber:
		return "ProgramStateMachineType_HaltedToReady_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToRunning_TransitionNumber:
		return "ProgramStateMachineType_ReadyToRunning_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToHalted_TransitionNumber:
		return "ProgramStateMachineType_RunningToHalted_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToReady_TransitionNumber:
		return "ProgramStateMachineType_RunningToReady_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_RunningToSuspended_TransitionNumber:
		return "ProgramStateMachineType_RunningToSuspended_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToRunning_TransitionNumber:
		return "ProgramStateMachineType_SuspendedToRunning_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToHalted_TransitionNumber:
		return "ProgramStateMachineType_SuspendedToHalted_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_SuspendedToReady_TransitionNumber:
		return "ProgramStateMachineType_SuspendedToReady_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ReadyToHalted_TransitionNumber:
		return "ProgramStateMachineType_ReadyToHalted_TransitionNumber"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassId:
		return "ProgramTransitionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionClassName:
		return "ProgramTransitionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassId:
		return "ProgramTransitionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ConditionSubClassName:
		return "ProgramTransitionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassId:
		return "ProgramTransitionAuditEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionClassName:
		return "ProgramTransitionAuditEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassId:
		return "ProgramTransitionAuditEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ConditionSubClassName:
		return "ProgramTransitionAuditEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventId:
		return "ProgramTransitionEventType_EventId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_EventType:
		return "ProgramTransitionEventType_EventType"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceNode:
		return "ProgramTransitionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_SourceName:
		return "ProgramTransitionEventType_SourceName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Time:
		return "ProgramTransitionEventType_Time"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ReceiveTime:
		return "ProgramTransitionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_LocalTime:
		return "ProgramTransitionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Message:
		return "ProgramTransitionEventType_Message"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Severity:
		return "ProgramTransitionEventType_Severity"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState:
		return "ProgramTransitionEventType_FromState"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Id:
		return "ProgramTransitionEventType_FromState_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Name:
		return "ProgramTransitionEventType_FromState_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_Number:
		return "ProgramTransitionEventType_FromState_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_FromState_EffectiveDisplayName:
		return "ProgramTransitionEventType_FromState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState:
		return "ProgramTransitionEventType_ToState"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Id:
		return "ProgramTransitionEventType_ToState_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Name:
		return "ProgramTransitionEventType_ToState_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_Number:
		return "ProgramTransitionEventType_ToState_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_ToState_EffectiveDisplayName:
		return "ProgramTransitionEventType_ToState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition:
		return "ProgramTransitionEventType_Transition"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Id:
		return "ProgramTransitionEventType_Transition_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Name:
		return "ProgramTransitionEventType_Transition_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_Number:
		return "ProgramTransitionEventType_Transition_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionEventType_Transition_TransitionTime:
		return "ProgramTransitionEventType_Transition_TransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventId:
		return "ProgramTransitionAuditEventType_EventId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_EventType:
		return "ProgramTransitionAuditEventType_EventType"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceNode:
		return "ProgramTransitionAuditEventType_SourceNode"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_SourceName:
		return "ProgramTransitionAuditEventType_SourceName"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Time:
		return "ProgramTransitionAuditEventType_Time"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ReceiveTime:
		return "ProgramTransitionAuditEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_LocalTime:
		return "ProgramTransitionAuditEventType_LocalTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Message:
		return "ProgramTransitionAuditEventType_Message"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Severity:
		return "ProgramTransitionAuditEventType_Severity"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ActionTimeStamp:
		return "ProgramTransitionAuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Status:
		return "ProgramTransitionAuditEventType_Status"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ServerId:
		return "ProgramTransitionAuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientAuditEntryId:
		return "ProgramTransitionAuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_ClientUserId:
		return "ProgramTransitionAuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_MethodId:
		return "ProgramTransitionAuditEventType_MethodId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_InputArguments:
		return "ProgramTransitionAuditEventType_InputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_OldStateId:
		return "ProgramTransitionAuditEventType_OldStateId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_NewStateId:
		return "ProgramTransitionAuditEventType_NewStateId"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition:
		return "ProgramTransitionAuditEventType_Transition"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Id:
		return "ProgramTransitionAuditEventType_Transition_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Name:
		return "ProgramTransitionAuditEventType_Transition_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_Number:
		return "ProgramTransitionAuditEventType_Transition_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramTransitionAuditEventType_Transition_TransitionTime:
		return "ProgramTransitionAuditEventType_Transition_TransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState:
		return "ProgramStateMachineType_CurrentState"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Id:
		return "ProgramStateMachineType_CurrentState_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Name:
		return "ProgramStateMachineType_CurrentState_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_Number:
		return "ProgramStateMachineType_CurrentState_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_CurrentState_EffectiveDisplayName:
		return "ProgramStateMachineType_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition:
		return "ProgramStateMachineType_LastTransition"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Id:
		return "ProgramStateMachineType_LastTransition_Id"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Name:
		return "ProgramStateMachineType_LastTransition_Name"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_Number:
		return "ProgramStateMachineType_LastTransition_Number"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_LastTransition_TransitionTime:
		return "ProgramStateMachineType_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId:
		return "ProgramStateMachineType_ProgramDiagnostic_CreateSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_CreateClientName:
		return "ProgramStateMachineType_ProgramDiagnostic_CreateClientName"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime:
		return "ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime:
		return "ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodCall"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime"
	case OpcuaNodeIdServicesVariableProgram_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus:
		return "ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableProgram) String() string {
	return e.PLC4XEnumName()
}
