/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableFile is an enum
type OpcuaNodeIdServicesVariableFile int32

type IOpcuaNodeIdServicesVariableFile interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableFile_FileType_Size                                                                         OpcuaNodeIdServicesVariableFile = 11576
	OpcuaNodeIdServicesVariableFile_FileType_OpenCount                                                                    OpcuaNodeIdServicesVariableFile = 11579
	OpcuaNodeIdServicesVariableFile_FileType_Open_InputArguments                                                          OpcuaNodeIdServicesVariableFile = 11581
	OpcuaNodeIdServicesVariableFile_FileType_Open_OutputArguments                                                         OpcuaNodeIdServicesVariableFile = 11582
	OpcuaNodeIdServicesVariableFile_FileType_Close_InputArguments                                                         OpcuaNodeIdServicesVariableFile = 11584
	OpcuaNodeIdServicesVariableFile_FileType_Read_InputArguments                                                          OpcuaNodeIdServicesVariableFile = 11586
	OpcuaNodeIdServicesVariableFile_FileType_Read_OutputArguments                                                         OpcuaNodeIdServicesVariableFile = 11587
	OpcuaNodeIdServicesVariableFile_FileType_Write_InputArguments                                                         OpcuaNodeIdServicesVariableFile = 11589
	OpcuaNodeIdServicesVariableFile_FileType_GetPosition_InputArguments                                                   OpcuaNodeIdServicesVariableFile = 11591
	OpcuaNodeIdServicesVariableFile_FileType_GetPosition_OutputArguments                                                  OpcuaNodeIdServicesVariableFile = 11592
	OpcuaNodeIdServicesVariableFile_FileType_SetPosition_InputArguments                                                   OpcuaNodeIdServicesVariableFile = 11594
	OpcuaNodeIdServicesVariableFile_FileType_Writable                                                                     OpcuaNodeIdServicesVariableFile = 12686
	OpcuaNodeIdServicesVariableFile_FileType_UserWritable                                                                 OpcuaNodeIdServicesVariableFile = 12687
	OpcuaNodeIdServicesVariableFile_FileType_MimeType                                                                     OpcuaNodeIdServicesVariableFile = 13341
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments        OpcuaNodeIdServicesVariableFile = 13356
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments       OpcuaNodeIdServicesVariableFile = 13357
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments             OpcuaNodeIdServicesVariableFile = 13359
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments            OpcuaNodeIdServicesVariableFile = 13360
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments             OpcuaNodeIdServicesVariableFile = 13364
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments            OpcuaNodeIdServicesVariableFile = 13365
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Size                                           OpcuaNodeIdServicesVariableFile = 13367
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Writable                                       OpcuaNodeIdServicesVariableFile = 13368
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_UserWritable                                   OpcuaNodeIdServicesVariableFile = 13369
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_OpenCount                                      OpcuaNodeIdServicesVariableFile = 13370
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MimeType                                       OpcuaNodeIdServicesVariableFile = 13371
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_InputArguments                            OpcuaNodeIdServicesVariableFile = 13373
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_OutputArguments                           OpcuaNodeIdServicesVariableFile = 13374
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Close_InputArguments                           OpcuaNodeIdServicesVariableFile = 13376
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_InputArguments                            OpcuaNodeIdServicesVariableFile = 13378
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_OutputArguments                           OpcuaNodeIdServicesVariableFile = 13379
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Write_InputArguments                           OpcuaNodeIdServicesVariableFile = 13381
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments                     OpcuaNodeIdServicesVariableFile = 13383
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments                    OpcuaNodeIdServicesVariableFile = 13384
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments                     OpcuaNodeIdServicesVariableFile = 13386
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_InputArguments                                      OpcuaNodeIdServicesVariableFile = 13388
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_OutputArguments                                     OpcuaNodeIdServicesVariableFile = 13389
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_InputArguments                                           OpcuaNodeIdServicesVariableFile = 13391
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_OutputArguments                                          OpcuaNodeIdServicesVariableFile = 13392
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_DeleteFileSystemObject_InputArguments                               OpcuaNodeIdServicesVariableFile = 13394
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_InputArguments                                           OpcuaNodeIdServicesVariableFile = 13396
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_OutputArguments                                          OpcuaNodeIdServicesVariableFile = 13397
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState                                             OpcuaNodeIdServicesVariableFile = 15804
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Id                                          OpcuaNodeIdServicesVariableFile = 15805
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Name                                        OpcuaNodeIdServicesVariableFile = 15806
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Number                                      OpcuaNodeIdServicesVariableFile = 15807
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableFile = 15808
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition                                           OpcuaNodeIdServicesVariableFile = 15809
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Id                                        OpcuaNodeIdServicesVariableFile = 15810
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Name                                      OpcuaNodeIdServicesVariableFile = 15811
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Number                                    OpcuaNodeIdServicesVariableFile = 15812
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_TransitionTime                            OpcuaNodeIdServicesVariableFile = 15813
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableFile = 15814
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Idle_StateNumber                                         OpcuaNodeIdServicesVariableFile = 15816
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepare_StateNumber                                  OpcuaNodeIdServicesVariableFile = 15818
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransfer_StateNumber                                 OpcuaNodeIdServicesVariableFile = 15820
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWrite_StateNumber                                   OpcuaNodeIdServicesVariableFile = 15822
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Error_StateNumber                                        OpcuaNodeIdServicesVariableFile = 15824
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber                       OpcuaNodeIdServicesVariableFile = 15826
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber               OpcuaNodeIdServicesVariableFile = 15828
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber                      OpcuaNodeIdServicesVariableFile = 15830
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber                        OpcuaNodeIdServicesVariableFile = 15832
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber                        OpcuaNodeIdServicesVariableFile = 15834
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber                      OpcuaNodeIdServicesVariableFile = 15836
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToError_TransitionNumber                     OpcuaNodeIdServicesVariableFile = 15838
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber                       OpcuaNodeIdServicesVariableFile = 15840
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ErrorToIdle_TransitionNumber                             OpcuaNodeIdServicesVariableFile = 15842
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments               OpcuaNodeIdServicesVariableFile = 16317
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments              OpcuaNodeIdServicesVariableFile = 16318
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments                    OpcuaNodeIdServicesVariableFile = 16320
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments                   OpcuaNodeIdServicesVariableFile = 16321
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments                    OpcuaNodeIdServicesVariableFile = 16325
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments                   OpcuaNodeIdServicesVariableFile = 16326
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Size                                                  OpcuaNodeIdServicesVariableFile = 16328
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Writable                                              OpcuaNodeIdServicesVariableFile = 16329
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_UserWritable                                          OpcuaNodeIdServicesVariableFile = 16330
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_OpenCount                                             OpcuaNodeIdServicesVariableFile = 16331
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MimeType                                              OpcuaNodeIdServicesVariableFile = 16332
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_InputArguments                                   OpcuaNodeIdServicesVariableFile = 16334
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_OutputArguments                                  OpcuaNodeIdServicesVariableFile = 16335
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Close_InputArguments                                  OpcuaNodeIdServicesVariableFile = 16337
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_InputArguments                                   OpcuaNodeIdServicesVariableFile = 16339
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_OutputArguments                                  OpcuaNodeIdServicesVariableFile = 16340
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Write_InputArguments                                  OpcuaNodeIdServicesVariableFile = 16342
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_InputArguments                            OpcuaNodeIdServicesVariableFile = 16344
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_OutputArguments                           OpcuaNodeIdServicesVariableFile = 16345
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_SetPosition_InputArguments                            OpcuaNodeIdServicesVariableFile = 16347
	OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_InputArguments                                             OpcuaNodeIdServicesVariableFile = 16349
	OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_OutputArguments                                            OpcuaNodeIdServicesVariableFile = 16350
	OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_InputArguments                                                  OpcuaNodeIdServicesVariableFile = 16352
	OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_OutputArguments                                                 OpcuaNodeIdServicesVariableFile = 16353
	OpcuaNodeIdServicesVariableFile_FileSystem_DeleteFileSystemObject_InputArguments                                      OpcuaNodeIdServicesVariableFile = 16355
	OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_InputArguments                                                  OpcuaNodeIdServicesVariableFile = 16357
	OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_OutputArguments                                                 OpcuaNodeIdServicesVariableFile = 16358
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableStates                                          OpcuaNodeIdServicesVariableFile = 17639
	OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableTransitions                                     OpcuaNodeIdServicesVariableFile = 17640
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments OpcuaNodeIdServicesVariableFile = 17719
	OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments        OpcuaNodeIdServicesVariableFile = 17723
	OpcuaNodeIdServicesVariableFile_FileType_MaxByteStringLength                                                          OpcuaNodeIdServicesVariableFile = 24244
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MaxByteStringLength                            OpcuaNodeIdServicesVariableFile = 24248
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MaxByteStringLength                                   OpcuaNodeIdServicesVariableFile = 24249
	OpcuaNodeIdServicesVariableFile_FileType_LastModifiedTime                                                             OpcuaNodeIdServicesVariableFile = 25200
	OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_LastModifiedTime                               OpcuaNodeIdServicesVariableFile = 25204
	OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_LastModifiedTime                                      OpcuaNodeIdServicesVariableFile = 25205
)

var OpcuaNodeIdServicesVariableFileValues []OpcuaNodeIdServicesVariableFile

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableFileValues = []OpcuaNodeIdServicesVariableFile{
		OpcuaNodeIdServicesVariableFile_FileType_Size,
		OpcuaNodeIdServicesVariableFile_FileType_OpenCount,
		OpcuaNodeIdServicesVariableFile_FileType_Open_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Open_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Close_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Read_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Read_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Write_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_Writable,
		OpcuaNodeIdServicesVariableFile_FileType_UserWritable,
		OpcuaNodeIdServicesVariableFile_FileType_MimeType,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Size,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Writable,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_UserWritable,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_OpenCount,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MimeType,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Close_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Write_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_DeleteFileSystemObject_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Id,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Name,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Number,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Id,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Name,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Number,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Idle_StateNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepare_StateNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransfer_StateNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWrite_StateNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Error_StateNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToError_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ErrorToIdle_TransitionNumber,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Size,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Writable,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_UserWritable,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_OpenCount,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MimeType,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Close_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Write_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_DeleteFileSystemObject_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_OutputArguments,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableStates,
		OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableTransitions,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments,
		OpcuaNodeIdServicesVariableFile_FileType_MaxByteStringLength,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MaxByteStringLength,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MaxByteStringLength,
		OpcuaNodeIdServicesVariableFile_FileType_LastModifiedTime,
		OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_LastModifiedTime,
		OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_LastModifiedTime,
	}
}

func OpcuaNodeIdServicesVariableFileByValue(value int32) (enum OpcuaNodeIdServicesVariableFile, ok bool) {
	switch value {
	case 11576:
		return OpcuaNodeIdServicesVariableFile_FileType_Size, true
	case 11579:
		return OpcuaNodeIdServicesVariableFile_FileType_OpenCount, true
	case 11581:
		return OpcuaNodeIdServicesVariableFile_FileType_Open_InputArguments, true
	case 11582:
		return OpcuaNodeIdServicesVariableFile_FileType_Open_OutputArguments, true
	case 11584:
		return OpcuaNodeIdServicesVariableFile_FileType_Close_InputArguments, true
	case 11586:
		return OpcuaNodeIdServicesVariableFile_FileType_Read_InputArguments, true
	case 11587:
		return OpcuaNodeIdServicesVariableFile_FileType_Read_OutputArguments, true
	case 11589:
		return OpcuaNodeIdServicesVariableFile_FileType_Write_InputArguments, true
	case 11591:
		return OpcuaNodeIdServicesVariableFile_FileType_GetPosition_InputArguments, true
	case 11592:
		return OpcuaNodeIdServicesVariableFile_FileType_GetPosition_OutputArguments, true
	case 11594:
		return OpcuaNodeIdServicesVariableFile_FileType_SetPosition_InputArguments, true
	case 12686:
		return OpcuaNodeIdServicesVariableFile_FileType_Writable, true
	case 12687:
		return OpcuaNodeIdServicesVariableFile_FileType_UserWritable, true
	case 13341:
		return OpcuaNodeIdServicesVariableFile_FileType_MimeType, true
	case 13356:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments, true
	case 13357:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments, true
	case 13359:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments, true
	case 13360:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments, true
	case 13364:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments, true
	case 13365:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments, true
	case 13367:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Size, true
	case 13368:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Writable, true
	case 13369:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_UserWritable, true
	case 13370:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_OpenCount, true
	case 13371:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MimeType, true
	case 13373:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_InputArguments, true
	case 13374:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_OutputArguments, true
	case 13376:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Close_InputArguments, true
	case 13378:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_InputArguments, true
	case 13379:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_OutputArguments, true
	case 13381:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Write_InputArguments, true
	case 13383:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments, true
	case 13384:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments, true
	case 13386:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments, true
	case 13388:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_InputArguments, true
	case 13389:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_OutputArguments, true
	case 13391:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_InputArguments, true
	case 13392:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_OutputArguments, true
	case 13394:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_DeleteFileSystemObject_InputArguments, true
	case 13396:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_InputArguments, true
	case 13397:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_OutputArguments, true
	case 15804:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState, true
	case 15805:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Id, true
	case 15806:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Name, true
	case 15807:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Number, true
	case 15808:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_EffectiveDisplayName, true
	case 15809:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition, true
	case 15810:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Id, true
	case 15811:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Name, true
	case 15812:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Number, true
	case 15813:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_TransitionTime, true
	case 15814:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_EffectiveTransitionTime, true
	case 15816:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Idle_StateNumber, true
	case 15818:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepare_StateNumber, true
	case 15820:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransfer_StateNumber, true
	case 15822:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWrite_StateNumber, true
	case 15824:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Error_StateNumber, true
	case 15826:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber, true
	case 15828:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber, true
	case 15830:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber, true
	case 15832:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber, true
	case 15834:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber, true
	case 15836:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber, true
	case 15838:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToError_TransitionNumber, true
	case 15840:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber, true
	case 15842:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ErrorToIdle_TransitionNumber, true
	case 16317:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments, true
	case 16318:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments, true
	case 16320:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments, true
	case 16321:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments, true
	case 16325:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments, true
	case 16326:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments, true
	case 16328:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Size, true
	case 16329:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Writable, true
	case 16330:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_UserWritable, true
	case 16331:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_OpenCount, true
	case 16332:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MimeType, true
	case 16334:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_InputArguments, true
	case 16335:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_OutputArguments, true
	case 16337:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Close_InputArguments, true
	case 16339:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_InputArguments, true
	case 16340:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_OutputArguments, true
	case 16342:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Write_InputArguments, true
	case 16344:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_InputArguments, true
	case 16345:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_OutputArguments, true
	case 16347:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_SetPosition_InputArguments, true
	case 16349:
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_InputArguments, true
	case 16350:
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_OutputArguments, true
	case 16352:
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_InputArguments, true
	case 16353:
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_OutputArguments, true
	case 16355:
		return OpcuaNodeIdServicesVariableFile_FileSystem_DeleteFileSystemObject_InputArguments, true
	case 16357:
		return OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_InputArguments, true
	case 16358:
		return OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_OutputArguments, true
	case 17639:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableStates, true
	case 17640:
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableTransitions, true
	case 17719:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments, true
	case 17723:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments, true
	case 24244:
		return OpcuaNodeIdServicesVariableFile_FileType_MaxByteStringLength, true
	case 24248:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MaxByteStringLength, true
	case 24249:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MaxByteStringLength, true
	case 25200:
		return OpcuaNodeIdServicesVariableFile_FileType_LastModifiedTime, true
	case 25204:
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_LastModifiedTime, true
	case 25205:
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_LastModifiedTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableFileByName(value string) (enum OpcuaNodeIdServicesVariableFile, ok bool) {
	switch value {
	case "FileType_Size":
		return OpcuaNodeIdServicesVariableFile_FileType_Size, true
	case "FileType_OpenCount":
		return OpcuaNodeIdServicesVariableFile_FileType_OpenCount, true
	case "FileType_Open_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Open_InputArguments, true
	case "FileType_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Open_OutputArguments, true
	case "FileType_Close_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Close_InputArguments, true
	case "FileType_Read_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Read_InputArguments, true
	case "FileType_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Read_OutputArguments, true
	case "FileType_Write_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_Write_InputArguments, true
	case "FileType_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_GetPosition_InputArguments, true
	case "FileType_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_GetPosition_OutputArguments, true
	case "FileType_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileType_SetPosition_InputArguments, true
	case "FileType_Writable":
		return OpcuaNodeIdServicesVariableFile_FileType_Writable, true
	case "FileType_UserWritable":
		return OpcuaNodeIdServicesVariableFile_FileType_UserWritable, true
	case "FileType_MimeType":
		return OpcuaNodeIdServicesVariableFile_FileType_MimeType, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Size":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Size, true
	case "FileDirectoryType_FileName_Placeholder_Writable":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Writable, true
	case "FileDirectoryType_FileName_Placeholder_UserWritable":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_UserWritable, true
	case "FileDirectoryType_FileName_Placeholder_OpenCount":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_OpenCount, true
	case "FileDirectoryType_FileName_Placeholder_MimeType":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MimeType, true
	case "FileDirectoryType_FileName_Placeholder_Open_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_InputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_OutputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Close_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Close_InputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Read_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_InputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_OutputArguments, true
	case "FileDirectoryType_FileName_Placeholder_Write_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Write_InputArguments, true
	case "FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments, true
	case "FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments, true
	case "FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments, true
	case "FileDirectoryType_CreateDirectory_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_InputArguments, true
	case "FileDirectoryType_CreateDirectory_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_OutputArguments, true
	case "FileDirectoryType_CreateFile_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_InputArguments, true
	case "FileDirectoryType_CreateFile_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_OutputArguments, true
	case "FileDirectoryType_DeleteFileSystemObject_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_DeleteFileSystemObject_InputArguments, true
	case "FileDirectoryType_MoveOrCopy_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_InputArguments, true
	case "FileDirectoryType_MoveOrCopy_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_OutputArguments, true
	case "FileTransferStateMachineType_CurrentState":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState, true
	case "FileTransferStateMachineType_CurrentState_Id":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Id, true
	case "FileTransferStateMachineType_CurrentState_Name":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Name, true
	case "FileTransferStateMachineType_CurrentState_Number":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Number, true
	case "FileTransferStateMachineType_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_EffectiveDisplayName, true
	case "FileTransferStateMachineType_LastTransition":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition, true
	case "FileTransferStateMachineType_LastTransition_Id":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Id, true
	case "FileTransferStateMachineType_LastTransition_Name":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Name, true
	case "FileTransferStateMachineType_LastTransition_Number":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Number, true
	case "FileTransferStateMachineType_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_TransitionTime, true
	case "FileTransferStateMachineType_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_EffectiveTransitionTime, true
	case "FileTransferStateMachineType_Idle_StateNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Idle_StateNumber, true
	case "FileTransferStateMachineType_ReadPrepare_StateNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepare_StateNumber, true
	case "FileTransferStateMachineType_ReadTransfer_StateNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransfer_StateNumber, true
	case "FileTransferStateMachineType_ApplyWrite_StateNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWrite_StateNumber, true
	case "FileTransferStateMachineType_Error_StateNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Error_StateNumber, true
	case "FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber, true
	case "FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber, true
	case "FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber, true
	case "FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber, true
	case "FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber, true
	case "FileTransferStateMachineType_ReadPrepareToError_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber, true
	case "FileTransferStateMachineType_ReadTransferToError_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToError_TransitionNumber, true
	case "FileTransferStateMachineType_ApplyWriteToError_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber, true
	case "FileTransferStateMachineType_ErrorToIdle_TransitionNumber":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ErrorToIdle_TransitionNumber, true
	case "FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments, true
	case "FileSystem_FileName_Placeholder_Size":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Size, true
	case "FileSystem_FileName_Placeholder_Writable":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Writable, true
	case "FileSystem_FileName_Placeholder_UserWritable":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_UserWritable, true
	case "FileSystem_FileName_Placeholder_OpenCount":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_OpenCount, true
	case "FileSystem_FileName_Placeholder_MimeType":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MimeType, true
	case "FileSystem_FileName_Placeholder_Open_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_InputArguments, true
	case "FileSystem_FileName_Placeholder_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_OutputArguments, true
	case "FileSystem_FileName_Placeholder_Close_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Close_InputArguments, true
	case "FileSystem_FileName_Placeholder_Read_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_InputArguments, true
	case "FileSystem_FileName_Placeholder_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_OutputArguments, true
	case "FileSystem_FileName_Placeholder_Write_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Write_InputArguments, true
	case "FileSystem_FileName_Placeholder_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_InputArguments, true
	case "FileSystem_FileName_Placeholder_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_OutputArguments, true
	case "FileSystem_FileName_Placeholder_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_SetPosition_InputArguments, true
	case "FileSystem_CreateDirectory_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_InputArguments, true
	case "FileSystem_CreateDirectory_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_OutputArguments, true
	case "FileSystem_CreateFile_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_InputArguments, true
	case "FileSystem_CreateFile_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_OutputArguments, true
	case "FileSystem_DeleteFileSystemObject_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_DeleteFileSystemObject_InputArguments, true
	case "FileSystem_MoveOrCopy_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_InputArguments, true
	case "FileSystem_MoveOrCopy_OutputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_OutputArguments, true
	case "FileTransferStateMachineType_AvailableStates":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableStates, true
	case "FileTransferStateMachineType_AvailableTransitions":
		return OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableTransitions, true
	case "FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments, true
	case "FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments, true
	case "FileType_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableFile_FileType_MaxByteStringLength, true
	case "FileDirectoryType_FileName_Placeholder_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MaxByteStringLength, true
	case "FileSystem_FileName_Placeholder_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MaxByteStringLength, true
	case "FileType_LastModifiedTime":
		return OpcuaNodeIdServicesVariableFile_FileType_LastModifiedTime, true
	case "FileDirectoryType_FileName_Placeholder_LastModifiedTime":
		return OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_LastModifiedTime, true
	case "FileSystem_FileName_Placeholder_LastModifiedTime":
		return OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_LastModifiedTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableFileKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableFileValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableFile(structType any) OpcuaNodeIdServicesVariableFile {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableFile {
		if sOpcuaNodeIdServicesVariableFile, ok := typ.(OpcuaNodeIdServicesVariableFile); ok {
			return sOpcuaNodeIdServicesVariableFile
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableFile) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableFile) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableFileParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableFile, error) {
	return OpcuaNodeIdServicesVariableFileParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableFileParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableFile, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableFile", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableFile")
	}
	if enum, ok := OpcuaNodeIdServicesVariableFileByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableFile")
		return OpcuaNodeIdServicesVariableFile(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableFile) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableFile) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableFile", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableFile) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableFile_FileType_Size:
		return "FileType_Size"
	case OpcuaNodeIdServicesVariableFile_FileType_OpenCount:
		return "FileType_OpenCount"
	case OpcuaNodeIdServicesVariableFile_FileType_Open_InputArguments:
		return "FileType_Open_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Open_OutputArguments:
		return "FileType_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Close_InputArguments:
		return "FileType_Close_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Read_InputArguments:
		return "FileType_Read_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Read_OutputArguments:
		return "FileType_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Write_InputArguments:
		return "FileType_Write_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_GetPosition_InputArguments:
		return "FileType_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_GetPosition_OutputArguments:
		return "FileType_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_SetPosition_InputArguments:
		return "FileType_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_Writable:
		return "FileType_Writable"
	case OpcuaNodeIdServicesVariableFile_FileType_UserWritable:
		return "FileType_UserWritable"
	case OpcuaNodeIdServicesVariableFile_FileType_MimeType:
		return "FileType_MimeType"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Size:
		return "FileDirectoryType_FileName_Placeholder_Size"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Writable:
		return "FileDirectoryType_FileName_Placeholder_Writable"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_UserWritable:
		return "FileDirectoryType_FileName_Placeholder_UserWritable"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_OpenCount:
		return "FileDirectoryType_FileName_Placeholder_OpenCount"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MimeType:
		return "FileDirectoryType_FileName_Placeholder_MimeType"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_Open_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Open_OutputArguments:
		return "FileDirectoryType_FileName_Placeholder_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Close_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_Close_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_Read_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Read_OutputArguments:
		return "FileDirectoryType_FileName_Placeholder_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_Write_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_Write_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments:
		return "FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments:
		return "FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_InputArguments:
		return "FileDirectoryType_CreateDirectory_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateDirectory_OutputArguments:
		return "FileDirectoryType_CreateDirectory_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_InputArguments:
		return "FileDirectoryType_CreateFile_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_CreateFile_OutputArguments:
		return "FileDirectoryType_CreateFile_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_DeleteFileSystemObject_InputArguments:
		return "FileDirectoryType_DeleteFileSystemObject_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_InputArguments:
		return "FileDirectoryType_MoveOrCopy_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_MoveOrCopy_OutputArguments:
		return "FileDirectoryType_MoveOrCopy_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState:
		return "FileTransferStateMachineType_CurrentState"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Id:
		return "FileTransferStateMachineType_CurrentState_Id"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Name:
		return "FileTransferStateMachineType_CurrentState_Name"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_Number:
		return "FileTransferStateMachineType_CurrentState_Number"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_CurrentState_EffectiveDisplayName:
		return "FileTransferStateMachineType_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition:
		return "FileTransferStateMachineType_LastTransition"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Id:
		return "FileTransferStateMachineType_LastTransition_Id"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Name:
		return "FileTransferStateMachineType_LastTransition_Name"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_Number:
		return "FileTransferStateMachineType_LastTransition_Number"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_TransitionTime:
		return "FileTransferStateMachineType_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_LastTransition_EffectiveTransitionTime:
		return "FileTransferStateMachineType_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Idle_StateNumber:
		return "FileTransferStateMachineType_Idle_StateNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepare_StateNumber:
		return "FileTransferStateMachineType_ReadPrepare_StateNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransfer_StateNumber:
		return "FileTransferStateMachineType_ReadTransfer_StateNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWrite_StateNumber:
		return "FileTransferStateMachineType_ApplyWrite_StateNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_Error_StateNumber:
		return "FileTransferStateMachineType_Error_StateNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber:
		return "FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber:
		return "FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber:
		return "FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber:
		return "FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber:
		return "FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber:
		return "FileTransferStateMachineType_ReadPrepareToError_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ReadTransferToError_TransitionNumber:
		return "FileTransferStateMachineType_ReadTransferToError_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber:
		return "FileTransferStateMachineType_ApplyWriteToError_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_ErrorToIdle_TransitionNumber:
		return "FileTransferStateMachineType_ErrorToIdle_TransitionNumber"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Size:
		return "FileSystem_FileName_Placeholder_Size"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Writable:
		return "FileSystem_FileName_Placeholder_Writable"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_UserWritable:
		return "FileSystem_FileName_Placeholder_UserWritable"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_OpenCount:
		return "FileSystem_FileName_Placeholder_OpenCount"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MimeType:
		return "FileSystem_FileName_Placeholder_MimeType"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_InputArguments:
		return "FileSystem_FileName_Placeholder_Open_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Open_OutputArguments:
		return "FileSystem_FileName_Placeholder_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Close_InputArguments:
		return "FileSystem_FileName_Placeholder_Close_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_InputArguments:
		return "FileSystem_FileName_Placeholder_Read_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Read_OutputArguments:
		return "FileSystem_FileName_Placeholder_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_Write_InputArguments:
		return "FileSystem_FileName_Placeholder_Write_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_InputArguments:
		return "FileSystem_FileName_Placeholder_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_GetPosition_OutputArguments:
		return "FileSystem_FileName_Placeholder_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_SetPosition_InputArguments:
		return "FileSystem_FileName_Placeholder_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_InputArguments:
		return "FileSystem_CreateDirectory_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_CreateDirectory_OutputArguments:
		return "FileSystem_CreateDirectory_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_InputArguments:
		return "FileSystem_CreateFile_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_CreateFile_OutputArguments:
		return "FileSystem_CreateFile_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_DeleteFileSystemObject_InputArguments:
		return "FileSystem_DeleteFileSystemObject_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_InputArguments:
		return "FileSystem_MoveOrCopy_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_MoveOrCopy_OutputArguments:
		return "FileSystem_MoveOrCopy_OutputArguments"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableStates:
		return "FileTransferStateMachineType_AvailableStates"
	case OpcuaNodeIdServicesVariableFile_FileTransferStateMachineType_AvailableTransitions:
		return "FileTransferStateMachineType_AvailableTransitions"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments:
		return "FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments:
		return "FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments"
	case OpcuaNodeIdServicesVariableFile_FileType_MaxByteStringLength:
		return "FileType_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_MaxByteStringLength:
		return "FileDirectoryType_FileName_Placeholder_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_MaxByteStringLength:
		return "FileSystem_FileName_Placeholder_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableFile_FileType_LastModifiedTime:
		return "FileType_LastModifiedTime"
	case OpcuaNodeIdServicesVariableFile_FileDirectoryType_FileName_Placeholder_LastModifiedTime:
		return "FileDirectoryType_FileName_Placeholder_LastModifiedTime"
	case OpcuaNodeIdServicesVariableFile_FileSystem_FileName_Placeholder_LastModifiedTime:
		return "FileSystem_FileName_Placeholder_LastModifiedTime"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableFile) String() string {
	return e.PLC4XEnumName()
}
