/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableExclusive is an enum
type OpcuaNodeIdServicesVariableExclusive int32

type IOpcuaNodeIdServicesVariableExclusive interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState                                         OpcuaNodeIdServicesVariableExclusive = 9319
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Id                                      OpcuaNodeIdServicesVariableExclusive = 9320
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Name                                    OpcuaNodeIdServicesVariableExclusive = 9321
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Number                                  OpcuaNodeIdServicesVariableExclusive = 9322
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableExclusive = 9323
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition                                       OpcuaNodeIdServicesVariableExclusive = 9324
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Id                                    OpcuaNodeIdServicesVariableExclusive = 9325
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Name                                  OpcuaNodeIdServicesVariableExclusive = 9326
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Number                                OpcuaNodeIdServicesVariableExclusive = 9327
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_TransitionTime                        OpcuaNodeIdServicesVariableExclusive = 9328
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHigh_StateNumber                                 OpcuaNodeIdServicesVariableExclusive = 9330
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_High_StateNumber                                     OpcuaNodeIdServicesVariableExclusive = 9332
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_Low_StateNumber                                      OpcuaNodeIdServicesVariableExclusive = 9334
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLow_StateNumber                                   OpcuaNodeIdServicesVariableExclusive = 9336
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventId                                                     OpcuaNodeIdServicesVariableExclusive = 9342
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventType                                                   OpcuaNodeIdServicesVariableExclusive = 9343
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceNode                                                  OpcuaNodeIdServicesVariableExclusive = 9344
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceName                                                  OpcuaNodeIdServicesVariableExclusive = 9345
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Time                                                        OpcuaNodeIdServicesVariableExclusive = 9346
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReceiveTime                                                 OpcuaNodeIdServicesVariableExclusive = 9347
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LocalTime                                                   OpcuaNodeIdServicesVariableExclusive = 9348
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Message                                                     OpcuaNodeIdServicesVariableExclusive = 9349
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Severity                                                    OpcuaNodeIdServicesVariableExclusive = 9350
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionName                                               OpcuaNodeIdServicesVariableExclusive = 9351
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BranchId                                                    OpcuaNodeIdServicesVariableExclusive = 9352
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Retain                                                      OpcuaNodeIdServicesVariableExclusive = 9353
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState                                                OpcuaNodeIdServicesVariableExclusive = 9354
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Id                                             OpcuaNodeIdServicesVariableExclusive = 9355
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Name                                           OpcuaNodeIdServicesVariableExclusive = 9356
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Number                                         OpcuaNodeIdServicesVariableExclusive = 9357
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 9358
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 9359
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 9360
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 9361
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 9362
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality                                                     OpcuaNodeIdServicesVariableExclusive = 9363
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality_SourceTimestamp                                     OpcuaNodeIdServicesVariableExclusive = 9364
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity                                                OpcuaNodeIdServicesVariableExclusive = 9365
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp                                OpcuaNodeIdServicesVariableExclusive = 9366
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment                                                     OpcuaNodeIdServicesVariableExclusive = 9367
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment_SourceTimestamp                                     OpcuaNodeIdServicesVariableExclusive = 9368
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ClientUserId                                                OpcuaNodeIdServicesVariableExclusive = 9369
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AddComment_InputArguments                                   OpcuaNodeIdServicesVariableExclusive = 9373
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments                             OpcuaNodeIdServicesVariableExclusive = 9375
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState                                                  OpcuaNodeIdServicesVariableExclusive = 9376
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Id                                               OpcuaNodeIdServicesVariableExclusive = 9377
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Name                                             OpcuaNodeIdServicesVariableExclusive = 9378
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Number                                           OpcuaNodeIdServicesVariableExclusive = 9379
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName                             OpcuaNodeIdServicesVariableExclusive = 9380
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TransitionTime                                   OpcuaNodeIdServicesVariableExclusive = 9381
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime                          OpcuaNodeIdServicesVariableExclusive = 9382
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TrueState                                        OpcuaNodeIdServicesVariableExclusive = 9383
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_FalseState                                       OpcuaNodeIdServicesVariableExclusive = 9384
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState                                              OpcuaNodeIdServicesVariableExclusive = 9385
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Id                                           OpcuaNodeIdServicesVariableExclusive = 9386
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Name                                         OpcuaNodeIdServicesVariableExclusive = 9387
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Number                                       OpcuaNodeIdServicesVariableExclusive = 9388
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableExclusive = 9389
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TransitionTime                               OpcuaNodeIdServicesVariableExclusive = 9390
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableExclusive = 9391
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TrueState                                    OpcuaNodeIdServicesVariableExclusive = 9392
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_FalseState                                   OpcuaNodeIdServicesVariableExclusive = 9393
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Acknowledge_InputArguments                                  OpcuaNodeIdServicesVariableExclusive = 9395
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Confirm_InputArguments                                      OpcuaNodeIdServicesVariableExclusive = 9397
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState                                                 OpcuaNodeIdServicesVariableExclusive = 9398
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Id                                              OpcuaNodeIdServicesVariableExclusive = 9399
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Name                                            OpcuaNodeIdServicesVariableExclusive = 9400
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Number                                          OpcuaNodeIdServicesVariableExclusive = 9401
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableExclusive = 9402
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TransitionTime                                  OpcuaNodeIdServicesVariableExclusive = 9403
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableExclusive = 9404
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TrueState                                       OpcuaNodeIdServicesVariableExclusive = 9405
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_FalseState                                      OpcuaNodeIdServicesVariableExclusive = 9406
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState                                             OpcuaNodeIdServicesVariableExclusive = 9407
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Id                                          OpcuaNodeIdServicesVariableExclusive = 9408
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Name                                        OpcuaNodeIdServicesVariableExclusive = 9409
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Number                                      OpcuaNodeIdServicesVariableExclusive = 9410
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableExclusive = 9411
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TransitionTime                              OpcuaNodeIdServicesVariableExclusive = 9412
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableExclusive = 9413
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TrueState                                   OpcuaNodeIdServicesVariableExclusive = 9414
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_FalseState                                  OpcuaNodeIdServicesVariableExclusive = 9415
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState                                  OpcuaNodeIdServicesVariableExclusive = 9417
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id                               OpcuaNodeIdServicesVariableExclusive = 9418
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name                             OpcuaNodeIdServicesVariableExclusive = 9419
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number                           OpcuaNodeIdServicesVariableExclusive = 9420
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName             OpcuaNodeIdServicesVariableExclusive = 9421
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition                                OpcuaNodeIdServicesVariableExclusive = 9422
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id                             OpcuaNodeIdServicesVariableExclusive = 9423
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name                           OpcuaNodeIdServicesVariableExclusive = 9424
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number                         OpcuaNodeIdServicesVariableExclusive = 9425
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime                 OpcuaNodeIdServicesVariableExclusive = 9426
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime                                  OpcuaNodeIdServicesVariableExclusive = 9427
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments                    OpcuaNodeIdServicesVariableExclusive = 9452
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedOrShelved                                         OpcuaNodeIdServicesVariableExclusive = 9453
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_MaxTimeShelved                                              OpcuaNodeIdServicesVariableExclusive = 9454
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState                                     OpcuaNodeIdServicesVariableExclusive = 9456
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Id                                  OpcuaNodeIdServicesVariableExclusive = 9457
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Name                                OpcuaNodeIdServicesVariableExclusive = 9458
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Number                              OpcuaNodeIdServicesVariableExclusive = 9459
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableExclusive = 9460
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition                                   OpcuaNodeIdServicesVariableExclusive = 9461
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Id                                OpcuaNodeIdServicesVariableExclusive = 9462
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Name                              OpcuaNodeIdServicesVariableExclusive = 9463
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Number                            OpcuaNodeIdServicesVariableExclusive = 9464
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableExclusive = 9465
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighLimit                                               OpcuaNodeIdServicesVariableExclusive = 9478
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighLimit                                                   OpcuaNodeIdServicesVariableExclusive = 9479
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLimit                                                    OpcuaNodeIdServicesVariableExclusive = 9480
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowLimit                                                 OpcuaNodeIdServicesVariableExclusive = 9481
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventId                                                     OpcuaNodeIdServicesVariableExclusive = 9483
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventType                                                   OpcuaNodeIdServicesVariableExclusive = 9484
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceNode                                                  OpcuaNodeIdServicesVariableExclusive = 9485
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceName                                                  OpcuaNodeIdServicesVariableExclusive = 9486
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Time                                                        OpcuaNodeIdServicesVariableExclusive = 9487
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReceiveTime                                                 OpcuaNodeIdServicesVariableExclusive = 9488
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LocalTime                                                   OpcuaNodeIdServicesVariableExclusive = 9489
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Message                                                     OpcuaNodeIdServicesVariableExclusive = 9490
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Severity                                                    OpcuaNodeIdServicesVariableExclusive = 9491
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionName                                               OpcuaNodeIdServicesVariableExclusive = 9492
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BranchId                                                    OpcuaNodeIdServicesVariableExclusive = 9493
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Retain                                                      OpcuaNodeIdServicesVariableExclusive = 9494
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState                                                OpcuaNodeIdServicesVariableExclusive = 9495
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Id                                             OpcuaNodeIdServicesVariableExclusive = 9496
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Name                                           OpcuaNodeIdServicesVariableExclusive = 9497
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Number                                         OpcuaNodeIdServicesVariableExclusive = 9498
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 9499
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 9500
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 9501
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 9502
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 9503
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality                                                     OpcuaNodeIdServicesVariableExclusive = 9504
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality_SourceTimestamp                                     OpcuaNodeIdServicesVariableExclusive = 9505
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity                                                OpcuaNodeIdServicesVariableExclusive = 9506
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp                                OpcuaNodeIdServicesVariableExclusive = 9507
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment                                                     OpcuaNodeIdServicesVariableExclusive = 9508
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment_SourceTimestamp                                     OpcuaNodeIdServicesVariableExclusive = 9509
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ClientUserId                                                OpcuaNodeIdServicesVariableExclusive = 9510
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AddComment_InputArguments                                   OpcuaNodeIdServicesVariableExclusive = 9514
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments                             OpcuaNodeIdServicesVariableExclusive = 9516
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState                                                  OpcuaNodeIdServicesVariableExclusive = 9517
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Id                                               OpcuaNodeIdServicesVariableExclusive = 9518
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Name                                             OpcuaNodeIdServicesVariableExclusive = 9519
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Number                                           OpcuaNodeIdServicesVariableExclusive = 9520
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName                             OpcuaNodeIdServicesVariableExclusive = 9521
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TransitionTime                                   OpcuaNodeIdServicesVariableExclusive = 9522
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime                          OpcuaNodeIdServicesVariableExclusive = 9523
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TrueState                                        OpcuaNodeIdServicesVariableExclusive = 9524
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_FalseState                                       OpcuaNodeIdServicesVariableExclusive = 9525
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState                                              OpcuaNodeIdServicesVariableExclusive = 9526
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Id                                           OpcuaNodeIdServicesVariableExclusive = 9527
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Name                                         OpcuaNodeIdServicesVariableExclusive = 9528
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Number                                       OpcuaNodeIdServicesVariableExclusive = 9529
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableExclusive = 9530
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TransitionTime                               OpcuaNodeIdServicesVariableExclusive = 9531
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableExclusive = 9532
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TrueState                                    OpcuaNodeIdServicesVariableExclusive = 9533
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_FalseState                                   OpcuaNodeIdServicesVariableExclusive = 9534
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Acknowledge_InputArguments                                  OpcuaNodeIdServicesVariableExclusive = 9536
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Confirm_InputArguments                                      OpcuaNodeIdServicesVariableExclusive = 9538
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState                                                 OpcuaNodeIdServicesVariableExclusive = 9539
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Id                                              OpcuaNodeIdServicesVariableExclusive = 9540
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Name                                            OpcuaNodeIdServicesVariableExclusive = 9541
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Number                                          OpcuaNodeIdServicesVariableExclusive = 9542
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableExclusive = 9543
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TransitionTime                                  OpcuaNodeIdServicesVariableExclusive = 9544
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableExclusive = 9545
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TrueState                                       OpcuaNodeIdServicesVariableExclusive = 9546
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_FalseState                                      OpcuaNodeIdServicesVariableExclusive = 9547
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState                                             OpcuaNodeIdServicesVariableExclusive = 9548
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Id                                          OpcuaNodeIdServicesVariableExclusive = 9549
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Name                                        OpcuaNodeIdServicesVariableExclusive = 9550
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Number                                      OpcuaNodeIdServicesVariableExclusive = 9551
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableExclusive = 9552
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TransitionTime                              OpcuaNodeIdServicesVariableExclusive = 9553
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableExclusive = 9554
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TrueState                                   OpcuaNodeIdServicesVariableExclusive = 9555
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_FalseState                                  OpcuaNodeIdServicesVariableExclusive = 9556
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState                                  OpcuaNodeIdServicesVariableExclusive = 9558
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id                               OpcuaNodeIdServicesVariableExclusive = 9559
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name                             OpcuaNodeIdServicesVariableExclusive = 9560
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number                           OpcuaNodeIdServicesVariableExclusive = 9561
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName             OpcuaNodeIdServicesVariableExclusive = 9562
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition                                OpcuaNodeIdServicesVariableExclusive = 9563
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id                             OpcuaNodeIdServicesVariableExclusive = 9564
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name                           OpcuaNodeIdServicesVariableExclusive = 9565
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number                         OpcuaNodeIdServicesVariableExclusive = 9566
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime                 OpcuaNodeIdServicesVariableExclusive = 9567
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime                                  OpcuaNodeIdServicesVariableExclusive = 9568
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments                    OpcuaNodeIdServicesVariableExclusive = 9593
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedOrShelved                                         OpcuaNodeIdServicesVariableExclusive = 9594
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_MaxTimeShelved                                              OpcuaNodeIdServicesVariableExclusive = 9595
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState                                     OpcuaNodeIdServicesVariableExclusive = 9597
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Id                                  OpcuaNodeIdServicesVariableExclusive = 9598
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Name                                OpcuaNodeIdServicesVariableExclusive = 9599
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Number                              OpcuaNodeIdServicesVariableExclusive = 9600
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableExclusive = 9601
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition                                   OpcuaNodeIdServicesVariableExclusive = 9602
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Id                                OpcuaNodeIdServicesVariableExclusive = 9603
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Name                              OpcuaNodeIdServicesVariableExclusive = 9604
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Number                            OpcuaNodeIdServicesVariableExclusive = 9605
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableExclusive = 9606
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighLimit                                               OpcuaNodeIdServicesVariableExclusive = 9619
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighLimit                                                   OpcuaNodeIdServicesVariableExclusive = 9620
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLimit                                                    OpcuaNodeIdServicesVariableExclusive = 9621
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowLimit                                                 OpcuaNodeIdServicesVariableExclusive = 9622
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventId                                              OpcuaNodeIdServicesVariableExclusive = 9624
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventType                                            OpcuaNodeIdServicesVariableExclusive = 9625
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableExclusive = 9626
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceName                                           OpcuaNodeIdServicesVariableExclusive = 9627
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Time                                                 OpcuaNodeIdServicesVariableExclusive = 9628
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableExclusive = 9629
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableExclusive = 9630
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Message                                              OpcuaNodeIdServicesVariableExclusive = 9631
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Severity                                             OpcuaNodeIdServicesVariableExclusive = 9632
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableExclusive = 9633
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BranchId                                             OpcuaNodeIdServicesVariableExclusive = 9634
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Retain                                               OpcuaNodeIdServicesVariableExclusive = 9635
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableExclusive = 9636
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableExclusive = 9637
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableExclusive = 9638
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableExclusive = 9639
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableExclusive = 9640
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableExclusive = 9641
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableExclusive = 9642
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableExclusive = 9643
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableExclusive = 9644
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality                                              OpcuaNodeIdServicesVariableExclusive = 9645
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableExclusive = 9646
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableExclusive = 9647
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableExclusive = 9648
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment                                              OpcuaNodeIdServicesVariableExclusive = 9649
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableExclusive = 9650
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableExclusive = 9651
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableExclusive = 9655
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableExclusive = 9657
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState                                           OpcuaNodeIdServicesVariableExclusive = 9658
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableExclusive = 9659
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableExclusive = 9660
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableExclusive = 9661
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableExclusive = 9662
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableExclusive = 9663
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableExclusive = 9664
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableExclusive = 9665
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableExclusive = 9666
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableExclusive = 9667
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableExclusive = 9668
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableExclusive = 9669
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableExclusive = 9670
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableExclusive = 9671
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableExclusive = 9672
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableExclusive = 9673
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableExclusive = 9674
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableExclusive = 9675
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableExclusive = 9677
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableExclusive = 9679
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableExclusive = 9680
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableExclusive = 9681
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableExclusive = 9682
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableExclusive = 9683
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableExclusive = 9684
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableExclusive = 9685
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableExclusive = 9686
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableExclusive = 9687
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableExclusive = 9688
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableExclusive = 9689
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableExclusive = 9690
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableExclusive = 9691
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableExclusive = 9692
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableExclusive = 9693
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableExclusive = 9694
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableExclusive = 9695
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableExclusive = 9696
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableExclusive = 9697
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableExclusive = 9699
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableExclusive = 9700
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableExclusive = 9701
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableExclusive = 9702
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableExclusive = 9703
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableExclusive = 9704
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableExclusive = 9705
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableExclusive = 9706
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableExclusive = 9707
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableExclusive = 9708
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableExclusive = 9709
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableExclusive = 9734
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableExclusive = 9735
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableExclusive = 9736
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState                              OpcuaNodeIdServicesVariableExclusive = 9738
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id                           OpcuaNodeIdServicesVariableExclusive = 9739
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name                         OpcuaNodeIdServicesVariableExclusive = 9740
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number                       OpcuaNodeIdServicesVariableExclusive = 9741
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName         OpcuaNodeIdServicesVariableExclusive = 9742
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition                            OpcuaNodeIdServicesVariableExclusive = 9743
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id                         OpcuaNodeIdServicesVariableExclusive = 9744
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name                       OpcuaNodeIdServicesVariableExclusive = 9745
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number                     OpcuaNodeIdServicesVariableExclusive = 9746
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime             OpcuaNodeIdServicesVariableExclusive = 9747
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighLimit                                        OpcuaNodeIdServicesVariableExclusive = 9760
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighLimit                                            OpcuaNodeIdServicesVariableExclusive = 9761
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLimit                                             OpcuaNodeIdServicesVariableExclusive = 9762
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowLimit                                          OpcuaNodeIdServicesVariableExclusive = 9763
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventId                                                 OpcuaNodeIdServicesVariableExclusive = 9765
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventType                                               OpcuaNodeIdServicesVariableExclusive = 9766
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceNode                                              OpcuaNodeIdServicesVariableExclusive = 9767
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceName                                              OpcuaNodeIdServicesVariableExclusive = 9768
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Time                                                    OpcuaNodeIdServicesVariableExclusive = 9769
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReceiveTime                                             OpcuaNodeIdServicesVariableExclusive = 9770
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LocalTime                                               OpcuaNodeIdServicesVariableExclusive = 9771
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Message                                                 OpcuaNodeIdServicesVariableExclusive = 9772
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Severity                                                OpcuaNodeIdServicesVariableExclusive = 9773
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionName                                           OpcuaNodeIdServicesVariableExclusive = 9774
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BranchId                                                OpcuaNodeIdServicesVariableExclusive = 9775
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Retain                                                  OpcuaNodeIdServicesVariableExclusive = 9776
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState                                            OpcuaNodeIdServicesVariableExclusive = 9777
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Id                                         OpcuaNodeIdServicesVariableExclusive = 9778
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Name                                       OpcuaNodeIdServicesVariableExclusive = 9779
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Number                                     OpcuaNodeIdServicesVariableExclusive = 9780
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableExclusive = 9781
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TransitionTime                             OpcuaNodeIdServicesVariableExclusive = 9782
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableExclusive = 9783
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TrueState                                  OpcuaNodeIdServicesVariableExclusive = 9784
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_FalseState                                 OpcuaNodeIdServicesVariableExclusive = 9785
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality                                                 OpcuaNodeIdServicesVariableExclusive = 9786
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality_SourceTimestamp                                 OpcuaNodeIdServicesVariableExclusive = 9787
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity                                            OpcuaNodeIdServicesVariableExclusive = 9788
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp                            OpcuaNodeIdServicesVariableExclusive = 9789
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment                                                 OpcuaNodeIdServicesVariableExclusive = 9790
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment_SourceTimestamp                                 OpcuaNodeIdServicesVariableExclusive = 9791
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ClientUserId                                            OpcuaNodeIdServicesVariableExclusive = 9792
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AddComment_InputArguments                               OpcuaNodeIdServicesVariableExclusive = 9796
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments                         OpcuaNodeIdServicesVariableExclusive = 9798
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState                                              OpcuaNodeIdServicesVariableExclusive = 9799
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Id                                           OpcuaNodeIdServicesVariableExclusive = 9800
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Name                                         OpcuaNodeIdServicesVariableExclusive = 9801
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Number                                       OpcuaNodeIdServicesVariableExclusive = 9802
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableExclusive = 9803
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TransitionTime                               OpcuaNodeIdServicesVariableExclusive = 9804
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableExclusive = 9805
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TrueState                                    OpcuaNodeIdServicesVariableExclusive = 9806
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_FalseState                                   OpcuaNodeIdServicesVariableExclusive = 9807
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState                                          OpcuaNodeIdServicesVariableExclusive = 9808
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Id                                       OpcuaNodeIdServicesVariableExclusive = 9809
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Name                                     OpcuaNodeIdServicesVariableExclusive = 9810
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Number                                   OpcuaNodeIdServicesVariableExclusive = 9811
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableExclusive = 9812
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime                           OpcuaNodeIdServicesVariableExclusive = 9813
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableExclusive = 9814
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TrueState                                OpcuaNodeIdServicesVariableExclusive = 9815
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_FalseState                               OpcuaNodeIdServicesVariableExclusive = 9816
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Acknowledge_InputArguments                              OpcuaNodeIdServicesVariableExclusive = 9818
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Confirm_InputArguments                                  OpcuaNodeIdServicesVariableExclusive = 9820
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState                                             OpcuaNodeIdServicesVariableExclusive = 9821
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Id                                          OpcuaNodeIdServicesVariableExclusive = 9822
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Name                                        OpcuaNodeIdServicesVariableExclusive = 9823
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Number                                      OpcuaNodeIdServicesVariableExclusive = 9824
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableExclusive = 9825
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TransitionTime                              OpcuaNodeIdServicesVariableExclusive = 9826
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableExclusive = 9827
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TrueState                                   OpcuaNodeIdServicesVariableExclusive = 9828
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_FalseState                                  OpcuaNodeIdServicesVariableExclusive = 9829
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState                                         OpcuaNodeIdServicesVariableExclusive = 9830
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Id                                      OpcuaNodeIdServicesVariableExclusive = 9831
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Name                                    OpcuaNodeIdServicesVariableExclusive = 9832
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Number                                  OpcuaNodeIdServicesVariableExclusive = 9833
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableExclusive = 9834
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TransitionTime                          OpcuaNodeIdServicesVariableExclusive = 9835
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableExclusive = 9836
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TrueState                               OpcuaNodeIdServicesVariableExclusive = 9837
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_FalseState                              OpcuaNodeIdServicesVariableExclusive = 9838
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState                              OpcuaNodeIdServicesVariableExclusive = 9840
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id                           OpcuaNodeIdServicesVariableExclusive = 9841
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name                         OpcuaNodeIdServicesVariableExclusive = 9842
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number                       OpcuaNodeIdServicesVariableExclusive = 9843
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName         OpcuaNodeIdServicesVariableExclusive = 9844
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition                            OpcuaNodeIdServicesVariableExclusive = 9845
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id                         OpcuaNodeIdServicesVariableExclusive = 9846
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name                       OpcuaNodeIdServicesVariableExclusive = 9847
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number                     OpcuaNodeIdServicesVariableExclusive = 9848
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime             OpcuaNodeIdServicesVariableExclusive = 9849
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime                              OpcuaNodeIdServicesVariableExclusive = 9850
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments                OpcuaNodeIdServicesVariableExclusive = 9875
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedOrShelved                                     OpcuaNodeIdServicesVariableExclusive = 9876
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_MaxTimeShelved                                          OpcuaNodeIdServicesVariableExclusive = 9877
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState                                 OpcuaNodeIdServicesVariableExclusive = 9879
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id                              OpcuaNodeIdServicesVariableExclusive = 9880
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Name                            OpcuaNodeIdServicesVariableExclusive = 9881
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Number                          OpcuaNodeIdServicesVariableExclusive = 9882
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableExclusive = 9883
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition                               OpcuaNodeIdServicesVariableExclusive = 9884
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id                            OpcuaNodeIdServicesVariableExclusive = 9885
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Name                          OpcuaNodeIdServicesVariableExclusive = 9886
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Number                        OpcuaNodeIdServicesVariableExclusive = 9887
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableExclusive = 9888
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighLimit                                           OpcuaNodeIdServicesVariableExclusive = 9901
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighLimit                                               OpcuaNodeIdServicesVariableExclusive = 9902
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLimit                                                OpcuaNodeIdServicesVariableExclusive = 9903
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowLimit                                             OpcuaNodeIdServicesVariableExclusive = 9904
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SetpointNode                                            OpcuaNodeIdServicesVariableExclusive = 9905
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassId                                            OpcuaNodeIdServicesVariableExclusive = 11128
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassName                                          OpcuaNodeIdServicesVariableExclusive = 11129
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_InputNode                                                   OpcuaNodeIdServicesVariableExclusive = 11130
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassId                                            OpcuaNodeIdServicesVariableExclusive = 11131
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassName                                          OpcuaNodeIdServicesVariableExclusive = 11132
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_InputNode                                                   OpcuaNodeIdServicesVariableExclusive = 11133
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableExclusive = 11134
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableExclusive = 11135
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_InputNode                                            OpcuaNodeIdServicesVariableExclusive = 11136
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassId                                        OpcuaNodeIdServicesVariableExclusive = 11137
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassName                                      OpcuaNodeIdServicesVariableExclusive = 11138
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_InputNode                                               OpcuaNodeIdServicesVariableExclusive = 11139
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber                         OpcuaNodeIdServicesVariableExclusive = 11340
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber                         OpcuaNodeIdServicesVariableExclusive = 11341
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber                      OpcuaNodeIdServicesVariableExclusive = 11342
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber                      OpcuaNodeIdServicesVariableExclusive = 11343
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime               OpcuaNodeIdServicesVariableExclusive = 11468
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime        OpcuaNodeIdServicesVariableExclusive = 11469
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableExclusive = 11470
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime        OpcuaNodeIdServicesVariableExclusive = 11471
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableExclusive = 11472
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableExclusive = 11473
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime    OpcuaNodeIdServicesVariableExclusive = 11474
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime    OpcuaNodeIdServicesVariableExclusive = 11475
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableExclusive = 11476
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments                            OpcuaNodeIdServicesVariableExclusive = 12989
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments                            OpcuaNodeIdServicesVariableExclusive = 12995
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments                        OpcuaNodeIdServicesVariableExclusive = 12999
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableExclusive = 13003
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassId                                         OpcuaNodeIdServicesVariableExclusive = 16576
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassName                                       OpcuaNodeIdServicesVariableExclusive = 16577
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState                                           OpcuaNodeIdServicesVariableExclusive = 16578
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Id                                        OpcuaNodeIdServicesVariableExclusive = 16579
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Name                                      OpcuaNodeIdServicesVariableExclusive = 16580
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Number                                    OpcuaNodeIdServicesVariableExclusive = 16581
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableExclusive = 16582
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime                            OpcuaNodeIdServicesVariableExclusive = 16583
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableExclusive = 16584
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TrueState                                 OpcuaNodeIdServicesVariableExclusive = 16585
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_FalseState                                OpcuaNodeIdServicesVariableExclusive = 16586
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState                                                OpcuaNodeIdServicesVariableExclusive = 16587
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Id                                             OpcuaNodeIdServicesVariableExclusive = 16588
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Name                                           OpcuaNodeIdServicesVariableExclusive = 16589
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Number                                         OpcuaNodeIdServicesVariableExclusive = 16590
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 16591
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 16592
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 16593
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 16594
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 16595
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleEnabled                                              OpcuaNodeIdServicesVariableExclusive = 16596
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound                                                OpcuaNodeIdServicesVariableExclusive = 16597
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OnDelay                                                     OpcuaNodeIdServicesVariableExclusive = 16602
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OffDelay                                                    OpcuaNodeIdServicesVariableExclusive = 16603
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_FirstInGroupFlag                                            OpcuaNodeIdServicesVariableExclusive = 16604
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmTime                                                 OpcuaNodeIdServicesVariableExclusive = 16607
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmRepeatCount                                          OpcuaNodeIdServicesVariableExclusive = 16608
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighHighLimit                                           OpcuaNodeIdServicesVariableExclusive = 16612
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighLimit                                               OpcuaNodeIdServicesVariableExclusive = 16613
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLimit                                                OpcuaNodeIdServicesVariableExclusive = 16614
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLowLimit                                             OpcuaNodeIdServicesVariableExclusive = 16615
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassId                                         OpcuaNodeIdServicesVariableExclusive = 16696
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassName                                       OpcuaNodeIdServicesVariableExclusive = 16697
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState                                           OpcuaNodeIdServicesVariableExclusive = 16698
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Id                                        OpcuaNodeIdServicesVariableExclusive = 16699
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Name                                      OpcuaNodeIdServicesVariableExclusive = 16700
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Number                                    OpcuaNodeIdServicesVariableExclusive = 16701
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableExclusive = 16702
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime                            OpcuaNodeIdServicesVariableExclusive = 16703
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableExclusive = 16704
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TrueState                                 OpcuaNodeIdServicesVariableExclusive = 16705
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_FalseState                                OpcuaNodeIdServicesVariableExclusive = 16706
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState                                                OpcuaNodeIdServicesVariableExclusive = 16707
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Id                                             OpcuaNodeIdServicesVariableExclusive = 16708
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Name                                           OpcuaNodeIdServicesVariableExclusive = 16709
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Number                                         OpcuaNodeIdServicesVariableExclusive = 16710
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 16711
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 16712
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 16713
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 16714
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 16715
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleEnabled                                              OpcuaNodeIdServicesVariableExclusive = 16716
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound                                                OpcuaNodeIdServicesVariableExclusive = 16717
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OnDelay                                                     OpcuaNodeIdServicesVariableExclusive = 16722
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OffDelay                                                    OpcuaNodeIdServicesVariableExclusive = 16723
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_FirstInGroupFlag                                            OpcuaNodeIdServicesVariableExclusive = 16724
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmTime                                                 OpcuaNodeIdServicesVariableExclusive = 16727
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmRepeatCount                                          OpcuaNodeIdServicesVariableExclusive = 16728
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighHighLimit                                           OpcuaNodeIdServicesVariableExclusive = 16732
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighLimit                                               OpcuaNodeIdServicesVariableExclusive = 16733
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLimit                                                OpcuaNodeIdServicesVariableExclusive = 16734
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLowLimit                                             OpcuaNodeIdServicesVariableExclusive = 16735
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassId                                     OpcuaNodeIdServicesVariableExclusive = 16777
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassName                                   OpcuaNodeIdServicesVariableExclusive = 16778
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState                                       OpcuaNodeIdServicesVariableExclusive = 16779
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Id                                    OpcuaNodeIdServicesVariableExclusive = 16780
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Name                                  OpcuaNodeIdServicesVariableExclusive = 16781
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Number                                OpcuaNodeIdServicesVariableExclusive = 16782
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableExclusive = 16783
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime                        OpcuaNodeIdServicesVariableExclusive = 16784
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableExclusive = 16785
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TrueState                             OpcuaNodeIdServicesVariableExclusive = 16786
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_FalseState                            OpcuaNodeIdServicesVariableExclusive = 16787
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState                                            OpcuaNodeIdServicesVariableExclusive = 16788
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Id                                         OpcuaNodeIdServicesVariableExclusive = 16789
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Name                                       OpcuaNodeIdServicesVariableExclusive = 16790
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Number                                     OpcuaNodeIdServicesVariableExclusive = 16791
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableExclusive = 16792
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TransitionTime                             OpcuaNodeIdServicesVariableExclusive = 16793
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableExclusive = 16794
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TrueState                                  OpcuaNodeIdServicesVariableExclusive = 16795
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_FalseState                                 OpcuaNodeIdServicesVariableExclusive = 16796
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleEnabled                                          OpcuaNodeIdServicesVariableExclusive = 16797
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound                                            OpcuaNodeIdServicesVariableExclusive = 16798
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OnDelay                                                 OpcuaNodeIdServicesVariableExclusive = 16803
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OffDelay                                                OpcuaNodeIdServicesVariableExclusive = 16804
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_FirstInGroupFlag                                        OpcuaNodeIdServicesVariableExclusive = 16805
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmTime                                             OpcuaNodeIdServicesVariableExclusive = 16808
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmRepeatCount                                      OpcuaNodeIdServicesVariableExclusive = 16809
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighHighLimit                                       OpcuaNodeIdServicesVariableExclusive = 16813
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighLimit                                           OpcuaNodeIdServicesVariableExclusive = 16814
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLimit                                            OpcuaNodeIdServicesVariableExclusive = 16815
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLowLimit                                         OpcuaNodeIdServicesVariableExclusive = 16816
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseSetpointNode                                        OpcuaNodeIdServicesVariableExclusive = 16817
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableExclusive = 16859
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableExclusive = 16860
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableExclusive = 16861
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableExclusive = 16862
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableExclusive = 16863
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableExclusive = 16864
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableExclusive = 16865
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableExclusive = 16866
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableExclusive = 16867
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableExclusive = 16868
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableExclusive = 16869
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableExclusive = 16870
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableExclusive = 16871
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableExclusive = 16872
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableExclusive = 16873
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableExclusive = 16874
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableExclusive = 16875
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableExclusive = 16876
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableExclusive = 16877
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableExclusive = 16878
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableExclusive = 16879
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableExclusive = 16880
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableExclusive = 16885
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableExclusive = 16886
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableExclusive = 16887
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableExclusive = 16890
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableExclusive = 16891
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighHighLimit                                    OpcuaNodeIdServicesVariableExclusive = 16895
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighLimit                                        OpcuaNodeIdServicesVariableExclusive = 16896
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLimit                                         OpcuaNodeIdServicesVariableExclusive = 16897
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLowLimit                                      OpcuaNodeIdServicesVariableExclusive = 16898
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EngineeringUnits                                     OpcuaNodeIdServicesVariableExclusive = 16899
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableStates                                      OpcuaNodeIdServicesVariableExclusive = 17666
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableTransitions                                 OpcuaNodeIdServicesVariableExclusive = 17667
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableStates                               OpcuaNodeIdServicesVariableExclusive = 17668
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions                          OpcuaNodeIdServicesVariableExclusive = 17669
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableStates                                  OpcuaNodeIdServicesVariableExclusive = 17670
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableTransitions                             OpcuaNodeIdServicesVariableExclusive = 17671
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableStates                               OpcuaNodeIdServicesVariableExclusive = 17676
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions                          OpcuaNodeIdServicesVariableExclusive = 17677
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableStates                                  OpcuaNodeIdServicesVariableExclusive = 17678
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableTransitions                             OpcuaNodeIdServicesVariableExclusive = 17679
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableStates                           OpcuaNodeIdServicesVariableExclusive = 17682
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions                      OpcuaNodeIdServicesVariableExclusive = 17683
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableStates                              OpcuaNodeIdServicesVariableExclusive = 17684
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableTransitions                         OpcuaNodeIdServicesVariableExclusive = 17685
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableExclusive = 17688
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableExclusive = 17689
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates                           OpcuaNodeIdServicesVariableExclusive = 17690
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions                      OpcuaNodeIdServicesVariableExclusive = 17691
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_ListId                                         OpcuaNodeIdServicesVariableExclusive = 17886
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_AgencyId                                       OpcuaNodeIdServicesVariableExclusive = 17887
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_VersionId                                      OpcuaNodeIdServicesVariableExclusive = 17888
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_ListId                                         OpcuaNodeIdServicesVariableExclusive = 17907
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_AgencyId                                       OpcuaNodeIdServicesVariableExclusive = 17908
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_VersionId                                      OpcuaNodeIdServicesVariableExclusive = 17909
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_ListId                                     OpcuaNodeIdServicesVariableExclusive = 17928
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_AgencyId                                   OpcuaNodeIdServicesVariableExclusive = 17929
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_VersionId                                  OpcuaNodeIdServicesVariableExclusive = 17930
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableExclusive = 17935
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableExclusive = 17936
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableExclusive = 17937
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState                                                OpcuaNodeIdServicesVariableExclusive = 18223
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Id                                             OpcuaNodeIdServicesVariableExclusive = 18224
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Name                                           OpcuaNodeIdServicesVariableExclusive = 18225
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Number                                         OpcuaNodeIdServicesVariableExclusive = 18226
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 18227
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 18228
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 18229
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 18230
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 18231
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState                                                OpcuaNodeIdServicesVariableExclusive = 18257
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Id                                             OpcuaNodeIdServicesVariableExclusive = 18258
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Name                                           OpcuaNodeIdServicesVariableExclusive = 18259
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Number                                         OpcuaNodeIdServicesVariableExclusive = 18260
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableExclusive = 18261
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TransitionTime                                 OpcuaNodeIdServicesVariableExclusive = 18262
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableExclusive = 18263
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TrueState                                      OpcuaNodeIdServicesVariableExclusive = 18264
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_FalseState                                     OpcuaNodeIdServicesVariableExclusive = 18265
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState                                            OpcuaNodeIdServicesVariableExclusive = 18287
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Id                                         OpcuaNodeIdServicesVariableExclusive = 18288
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Name                                       OpcuaNodeIdServicesVariableExclusive = 18289
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Number                                     OpcuaNodeIdServicesVariableExclusive = 18290
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableExclusive = 18291
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TransitionTime                             OpcuaNodeIdServicesVariableExclusive = 18292
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableExclusive = 18293
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TrueState                                  OpcuaNodeIdServicesVariableExclusive = 18294
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_FalseState                                 OpcuaNodeIdServicesVariableExclusive = 18295
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableExclusive = 18297
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableExclusive = 18298
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableExclusive = 18299
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableExclusive = 18300
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableExclusive = 18301
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableExclusive = 18302
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableExclusive = 18303
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableExclusive = 18304
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableExclusive = 18305
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Suppress2_InputArguments                                    OpcuaNodeIdServicesVariableExclusive = 24349
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Unsuppress2_InputArguments                                  OpcuaNodeIdServicesVariableExclusive = 24351
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments                           OpcuaNodeIdServicesVariableExclusive = 24353
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_PlaceInService2_InputArguments                              OpcuaNodeIdServicesVariableExclusive = 24355
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Reset2_InputArguments                                       OpcuaNodeIdServicesVariableExclusive = 24357
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Suppress2_InputArguments                                    OpcuaNodeIdServicesVariableExclusive = 24379
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Unsuppress2_InputArguments                                  OpcuaNodeIdServicesVariableExclusive = 24381
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments                           OpcuaNodeIdServicesVariableExclusive = 24383
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_PlaceInService2_InputArguments                              OpcuaNodeIdServicesVariableExclusive = 24385
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Reset2_InputArguments                                       OpcuaNodeIdServicesVariableExclusive = 24387
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Suppress2_InputArguments                                OpcuaNodeIdServicesVariableExclusive = 24409
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments                              OpcuaNodeIdServicesVariableExclusive = 24411
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments                       OpcuaNodeIdServicesVariableExclusive = 24413
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments                          OpcuaNodeIdServicesVariableExclusive = 24415
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Reset2_InputArguments                                   OpcuaNodeIdServicesVariableExclusive = 24417
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableExclusive = 24419
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableExclusive = 24421
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableExclusive = 24423
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableExclusive = 24425
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableExclusive = 24427
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments                   OpcuaNodeIdServicesVariableExclusive = 24779
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments                      OpcuaNodeIdServicesVariableExclusive = 24781
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments                 OpcuaNodeIdServicesVariableExclusive = 24783
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHighHigh                                            OpcuaNodeIdServicesVariableExclusive = 24786
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHigh                                                OpcuaNodeIdServicesVariableExclusive = 24787
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLow                                                 OpcuaNodeIdServicesVariableExclusive = 24788
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLowLow                                              OpcuaNodeIdServicesVariableExclusive = 24789
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighDeadband                                            OpcuaNodeIdServicesVariableExclusive = 24790
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighDeadband                                                OpcuaNodeIdServicesVariableExclusive = 24791
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowDeadband                                                 OpcuaNodeIdServicesVariableExclusive = 24792
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowDeadband                                              OpcuaNodeIdServicesVariableExclusive = 24793
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments                   OpcuaNodeIdServicesVariableExclusive = 24827
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments                      OpcuaNodeIdServicesVariableExclusive = 24829
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments                 OpcuaNodeIdServicesVariableExclusive = 24831
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHighHigh                                            OpcuaNodeIdServicesVariableExclusive = 24834
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHigh                                                OpcuaNodeIdServicesVariableExclusive = 24835
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLow                                                 OpcuaNodeIdServicesVariableExclusive = 24836
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLowLow                                              OpcuaNodeIdServicesVariableExclusive = 24837
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighDeadband                                            OpcuaNodeIdServicesVariableExclusive = 24838
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighDeadband                                                OpcuaNodeIdServicesVariableExclusive = 24839
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowDeadband                                                 OpcuaNodeIdServicesVariableExclusive = 24840
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowDeadband                                              OpcuaNodeIdServicesVariableExclusive = 24841
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments               OpcuaNodeIdServicesVariableExclusive = 24875
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments                  OpcuaNodeIdServicesVariableExclusive = 24877
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments             OpcuaNodeIdServicesVariableExclusive = 24879
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHighHigh                                        OpcuaNodeIdServicesVariableExclusive = 24882
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHigh                                            OpcuaNodeIdServicesVariableExclusive = 24883
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLow                                             OpcuaNodeIdServicesVariableExclusive = 24884
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLowLow                                          OpcuaNodeIdServicesVariableExclusive = 24885
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighDeadband                                        OpcuaNodeIdServicesVariableExclusive = 24886
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighDeadband                                            OpcuaNodeIdServicesVariableExclusive = 24887
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowDeadband                                             OpcuaNodeIdServicesVariableExclusive = 24888
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowDeadband                                          OpcuaNodeIdServicesVariableExclusive = 24889
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableExclusive = 24891
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableExclusive = 24893
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableExclusive = 24895
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHighHigh                                     OpcuaNodeIdServicesVariableExclusive = 24898
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHigh                                         OpcuaNodeIdServicesVariableExclusive = 24899
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLow                                          OpcuaNodeIdServicesVariableExclusive = 24900
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLowLow                                       OpcuaNodeIdServicesVariableExclusive = 24901
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighDeadband                                     OpcuaNodeIdServicesVariableExclusive = 24902
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighDeadband                                         OpcuaNodeIdServicesVariableExclusive = 24903
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowDeadband                                          OpcuaNodeIdServicesVariableExclusive = 24904
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowDeadband                                       OpcuaNodeIdServicesVariableExclusive = 24905
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments                         OpcuaNodeIdServicesVariableExclusive = 25160
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments                         OpcuaNodeIdServicesVariableExclusive = 25163
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments                     OpcuaNodeIdServicesVariableExclusive = 25166
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableExclusive = 25167
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SupportsFilteredRetain                                      OpcuaNodeIdServicesVariableExclusive = 32228
	OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SupportsFilteredRetain                                      OpcuaNodeIdServicesVariableExclusive = 32231
	OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SupportsFilteredRetain                                  OpcuaNodeIdServicesVariableExclusive = 32234
	OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableExclusive = 32235
)

var OpcuaNodeIdServicesVariableExclusiveValues []OpcuaNodeIdServicesVariableExclusive

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableExclusiveValues = []OpcuaNodeIdServicesVariableExclusive{
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHigh_StateNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_High_StateNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_Low_StateNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLow_StateNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventType,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Time,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Message,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Severity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BranchId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Retain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventType,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Time,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Message,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Severity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BranchId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Retain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventType,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Time,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Message,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Severity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BranchId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Retain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventType,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Time,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Message,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Severity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BranchId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Retain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SetpointNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_InputNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_InputNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_InputNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_InputNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseSetpointNode,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EngineeringUnits,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableExclusiveByValue(value int32) (enum OpcuaNodeIdServicesVariableExclusive, ok bool) {
	switch value {
	case 11128:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassId, true
	case 11129:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassName, true
	case 11130:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_InputNode, true
	case 11131:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassId, true
	case 11132:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassName, true
	case 11133:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_InputNode, true
	case 11134:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassId, true
	case 11135:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassName, true
	case 11136:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_InputNode, true
	case 11137:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassId, true
	case 11138:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassName, true
	case 11139:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_InputNode, true
	case 11340:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber, true
	case 11341:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber, true
	case 11342:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber, true
	case 11343:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber, true
	case 11468:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime, true
	case 11469:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11470:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case 11471:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11472:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case 11473:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11474:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case 11475:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11476:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case 12989:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments, true
	case 12995:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments, true
	case 12999:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments, true
	case 13003:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments, true
	case 16576:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassId, true
	case 16577:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassName, true
	case 16578:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState, true
	case 16579:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Id, true
	case 16580:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Name, true
	case 16581:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Number, true
	case 16582:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16583:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime, true
	case 16584:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16585:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TrueState, true
	case 16586:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_FalseState, true
	case 16587:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState, true
	case 16588:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Id, true
	case 16589:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Name, true
	case 16590:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Number, true
	case 16591:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName, true
	case 16592:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TransitionTime, true
	case 16593:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16594:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TrueState, true
	case 16595:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_FalseState, true
	case 16596:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleEnabled, true
	case 16597:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound, true
	case 16602:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OnDelay, true
	case 16603:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OffDelay, true
	case 16604:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_FirstInGroupFlag, true
	case 16607:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmTime, true
	case 16608:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmRepeatCount, true
	case 16612:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighHighLimit, true
	case 16613:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighLimit, true
	case 16614:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLimit, true
	case 16615:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLowLimit, true
	case 16696:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassId, true
	case 16697:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassName, true
	case 16698:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState, true
	case 16699:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Id, true
	case 16700:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Name, true
	case 16701:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Number, true
	case 16702:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16703:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime, true
	case 16704:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16705:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TrueState, true
	case 16706:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_FalseState, true
	case 16707:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState, true
	case 16708:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Id, true
	case 16709:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Name, true
	case 16710:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Number, true
	case 16711:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName, true
	case 16712:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TransitionTime, true
	case 16713:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16714:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TrueState, true
	case 16715:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_FalseState, true
	case 16716:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleEnabled, true
	case 16717:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound, true
	case 16722:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OnDelay, true
	case 16723:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OffDelay, true
	case 16724:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_FirstInGroupFlag, true
	case 16727:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmTime, true
	case 16728:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmRepeatCount, true
	case 16732:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighHighLimit, true
	case 16733:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighLimit, true
	case 16734:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLimit, true
	case 16735:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLowLimit, true
	case 16777:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassId, true
	case 16778:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassName, true
	case 16779:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState, true
	case 16780:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Id, true
	case 16781:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Name, true
	case 16782:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Number, true
	case 16783:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16784:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime, true
	case 16785:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16786:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TrueState, true
	case 16787:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_FalseState, true
	case 16788:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState, true
	case 16789:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Id, true
	case 16790:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Name, true
	case 16791:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Number, true
	case 16792:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName, true
	case 16793:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TransitionTime, true
	case 16794:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16795:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TrueState, true
	case 16796:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_FalseState, true
	case 16797:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleEnabled, true
	case 16798:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound, true
	case 16803:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OnDelay, true
	case 16804:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OffDelay, true
	case 16805:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_FirstInGroupFlag, true
	case 16808:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmTime, true
	case 16809:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmRepeatCount, true
	case 16813:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighHighLimit, true
	case 16814:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighLimit, true
	case 16815:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLimit, true
	case 16816:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLowLimit, true
	case 16817:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseSetpointNode, true
	case 16859:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassId, true
	case 16860:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassName, true
	case 16861:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState, true
	case 16862:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id, true
	case 16863:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name, true
	case 16864:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number, true
	case 16865:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16866:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime, true
	case 16867:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16868:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState, true
	case 16869:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState, true
	case 16870:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState, true
	case 16871:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Id, true
	case 16872:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Name, true
	case 16873:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Number, true
	case 16874:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName, true
	case 16875:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime, true
	case 16876:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16877:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TrueState, true
	case 16878:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_FalseState, true
	case 16879:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleEnabled, true
	case 16880:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound, true
	case 16885:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OnDelay, true
	case 16886:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OffDelay, true
	case 16887:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_FirstInGroupFlag, true
	case 16890:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmTime, true
	case 16891:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount, true
	case 16895:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighHighLimit, true
	case 16896:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighLimit, true
	case 16897:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLimit, true
	case 16898:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLowLimit, true
	case 16899:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case 17666:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableStates, true
	case 17667:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableTransitions, true
	case 17668:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableStates, true
	case 17669:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions, true
	case 17670:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableStates, true
	case 17671:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableTransitions, true
	case 17676:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableStates, true
	case 17677:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions, true
	case 17678:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableStates, true
	case 17679:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableTransitions, true
	case 17682:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableStates, true
	case 17683:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions, true
	case 17684:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableStates, true
	case 17685:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableTransitions, true
	case 17688:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates, true
	case 17689:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions, true
	case 17690:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates, true
	case 17691:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions, true
	case 17886:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_ListId, true
	case 17887:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_AgencyId, true
	case 17888:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_VersionId, true
	case 17907:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_ListId, true
	case 17908:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_AgencyId, true
	case 17909:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_VersionId, true
	case 17928:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_ListId, true
	case 17929:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_AgencyId, true
	case 17930:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_VersionId, true
	case 17935:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_ListId, true
	case 17936:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId, true
	case 17937:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId, true
	case 18223:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState, true
	case 18224:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Id, true
	case 18225:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Name, true
	case 18226:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Number, true
	case 18227:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName, true
	case 18228:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TransitionTime, true
	case 18229:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18230:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TrueState, true
	case 18231:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_FalseState, true
	case 18257:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState, true
	case 18258:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Id, true
	case 18259:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Name, true
	case 18260:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Number, true
	case 18261:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName, true
	case 18262:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TransitionTime, true
	case 18263:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18264:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TrueState, true
	case 18265:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_FalseState, true
	case 18287:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState, true
	case 18288:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Id, true
	case 18289:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Name, true
	case 18290:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Number, true
	case 18291:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName, true
	case 18292:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TransitionTime, true
	case 18293:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18294:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TrueState, true
	case 18295:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_FalseState, true
	case 18297:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState, true
	case 18298:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Id, true
	case 18299:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Name, true
	case 18300:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Number, true
	case 18301:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName, true
	case 18302:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime, true
	case 18303:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18304:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TrueState, true
	case 18305:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_FalseState, true
	case 24349:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Suppress2_InputArguments, true
	case 24351:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Unsuppress2_InputArguments, true
	case 24353:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments, true
	case 24355:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_PlaceInService2_InputArguments, true
	case 24357:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Reset2_InputArguments, true
	case 24379:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Suppress2_InputArguments, true
	case 24381:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Unsuppress2_InputArguments, true
	case 24383:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments, true
	case 24385:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_PlaceInService2_InputArguments, true
	case 24387:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Reset2_InputArguments, true
	case 24409:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Suppress2_InputArguments, true
	case 24411:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments, true
	case 24413:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments, true
	case 24415:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments, true
	case 24417:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Reset2_InputArguments, true
	case 24419:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments, true
	case 24421:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments, true
	case 24423:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments, true
	case 24425:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments, true
	case 24427:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments, true
	case 24779:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24781:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24783:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24786:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHighHigh, true
	case 24787:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHigh, true
	case 24788:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLow, true
	case 24789:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLowLow, true
	case 24790:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighDeadband, true
	case 24791:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighDeadband, true
	case 24792:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowDeadband, true
	case 24793:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowDeadband, true
	case 24827:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24829:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24831:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24834:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHighHigh, true
	case 24835:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHigh, true
	case 24836:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLow, true
	case 24837:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLowLow, true
	case 24838:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighDeadband, true
	case 24839:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighDeadband, true
	case 24840:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowDeadband, true
	case 24841:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowDeadband, true
	case 24875:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24877:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24879:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24882:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHighHigh, true
	case 24883:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHigh, true
	case 24884:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLow, true
	case 24885:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLowLow, true
	case 24886:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighDeadband, true
	case 24887:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighDeadband, true
	case 24888:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowDeadband, true
	case 24889:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowDeadband, true
	case 24891:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24893:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24895:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24898:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHighHigh, true
	case 24899:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHigh, true
	case 24900:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLow, true
	case 24901:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLowLow, true
	case 24902:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighDeadband, true
	case 24903:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighDeadband, true
	case 24904:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowDeadband, true
	case 24905:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowDeadband, true
	case 25160:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments, true
	case 25163:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments, true
	case 25166:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments, true
	case 25167:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments, true
	case 32228:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SupportsFilteredRetain, true
	case 32231:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SupportsFilteredRetain, true
	case 32234:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SupportsFilteredRetain, true
	case 32235:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain, true
	case 9319:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState, true
	case 9320:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Id, true
	case 9321:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Name, true
	case 9322:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Number, true
	case 9323:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName, true
	case 9324:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition, true
	case 9325:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Id, true
	case 9326:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Name, true
	case 9327:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Number, true
	case 9328:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_TransitionTime, true
	case 9330:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHigh_StateNumber, true
	case 9332:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_High_StateNumber, true
	case 9334:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_Low_StateNumber, true
	case 9336:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLow_StateNumber, true
	case 9342:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventId, true
	case 9343:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventType, true
	case 9344:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceNode, true
	case 9345:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceName, true
	case 9346:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Time, true
	case 9347:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReceiveTime, true
	case 9348:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LocalTime, true
	case 9349:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Message, true
	case 9350:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Severity, true
	case 9351:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionName, true
	case 9352:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BranchId, true
	case 9353:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Retain, true
	case 9354:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState, true
	case 9355:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Id, true
	case 9356:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Name, true
	case 9357:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Number, true
	case 9358:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName, true
	case 9359:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TransitionTime, true
	case 9360:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime, true
	case 9361:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TrueState, true
	case 9362:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_FalseState, true
	case 9363:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality, true
	case 9364:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality_SourceTimestamp, true
	case 9365:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity, true
	case 9366:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp, true
	case 9367:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment, true
	case 9368:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment_SourceTimestamp, true
	case 9369:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ClientUserId, true
	case 9373:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AddComment_InputArguments, true
	case 9375:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments, true
	case 9376:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState, true
	case 9377:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Id, true
	case 9378:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Name, true
	case 9379:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Number, true
	case 9380:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName, true
	case 9381:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TransitionTime, true
	case 9382:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime, true
	case 9383:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TrueState, true
	case 9384:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_FalseState, true
	case 9385:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState, true
	case 9386:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Id, true
	case 9387:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Name, true
	case 9388:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Number, true
	case 9389:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 9390:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TransitionTime, true
	case 9391:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 9392:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TrueState, true
	case 9393:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_FalseState, true
	case 9395:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Acknowledge_InputArguments, true
	case 9397:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Confirm_InputArguments, true
	case 9398:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState, true
	case 9399:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Id, true
	case 9400:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Name, true
	case 9401:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Number, true
	case 9402:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case 9403:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case 9404:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9405:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TrueState, true
	case 9406:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_FalseState, true
	case 9407:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState, true
	case 9408:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Id, true
	case 9409:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Name, true
	case 9410:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Number, true
	case 9411:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName, true
	case 9412:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TransitionTime, true
	case 9413:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 9414:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TrueState, true
	case 9415:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_FalseState, true
	case 9417:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState, true
	case 9418:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id, true
	case 9419:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name, true
	case 9420:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number, true
	case 9421:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 9422:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition, true
	case 9423:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id, true
	case 9424:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name, true
	case 9425:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number, true
	case 9426:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 9427:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime, true
	case 9452:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 9453:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedOrShelved, true
	case 9454:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_MaxTimeShelved, true
	case 9456:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState, true
	case 9457:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Id, true
	case 9458:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Name, true
	case 9459:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Number, true
	case 9460:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case 9461:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition, true
	case 9462:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Id, true
	case 9463:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Name, true
	case 9464:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Number, true
	case 9465:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime, true
	case 9478:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighLimit, true
	case 9479:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighLimit, true
	case 9480:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLimit, true
	case 9481:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowLimit, true
	case 9483:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventId, true
	case 9484:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventType, true
	case 9485:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceNode, true
	case 9486:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceName, true
	case 9487:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Time, true
	case 9488:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReceiveTime, true
	case 9489:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LocalTime, true
	case 9490:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Message, true
	case 9491:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Severity, true
	case 9492:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionName, true
	case 9493:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BranchId, true
	case 9494:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Retain, true
	case 9495:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState, true
	case 9496:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Id, true
	case 9497:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Name, true
	case 9498:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Number, true
	case 9499:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName, true
	case 9500:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TransitionTime, true
	case 9501:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime, true
	case 9502:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TrueState, true
	case 9503:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_FalseState, true
	case 9504:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality, true
	case 9505:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality_SourceTimestamp, true
	case 9506:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity, true
	case 9507:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp, true
	case 9508:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment, true
	case 9509:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment_SourceTimestamp, true
	case 9510:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ClientUserId, true
	case 9514:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AddComment_InputArguments, true
	case 9516:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments, true
	case 9517:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState, true
	case 9518:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Id, true
	case 9519:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Name, true
	case 9520:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Number, true
	case 9521:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName, true
	case 9522:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TransitionTime, true
	case 9523:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime, true
	case 9524:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TrueState, true
	case 9525:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_FalseState, true
	case 9526:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState, true
	case 9527:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Id, true
	case 9528:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Name, true
	case 9529:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Number, true
	case 9530:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 9531:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TransitionTime, true
	case 9532:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 9533:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TrueState, true
	case 9534:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_FalseState, true
	case 9536:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Acknowledge_InputArguments, true
	case 9538:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Confirm_InputArguments, true
	case 9539:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState, true
	case 9540:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Id, true
	case 9541:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Name, true
	case 9542:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Number, true
	case 9543:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName, true
	case 9544:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TransitionTime, true
	case 9545:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9546:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TrueState, true
	case 9547:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_FalseState, true
	case 9548:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState, true
	case 9549:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Id, true
	case 9550:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Name, true
	case 9551:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Number, true
	case 9552:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName, true
	case 9553:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TransitionTime, true
	case 9554:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 9555:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TrueState, true
	case 9556:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_FalseState, true
	case 9558:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState, true
	case 9559:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id, true
	case 9560:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name, true
	case 9561:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number, true
	case 9562:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 9563:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition, true
	case 9564:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id, true
	case 9565:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name, true
	case 9566:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number, true
	case 9567:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 9568:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime, true
	case 9593:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 9594:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedOrShelved, true
	case 9595:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_MaxTimeShelved, true
	case 9597:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState, true
	case 9598:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Id, true
	case 9599:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Name, true
	case 9600:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Number, true
	case 9601:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case 9602:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition, true
	case 9603:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Id, true
	case 9604:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Name, true
	case 9605:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Number, true
	case 9606:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime, true
	case 9619:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighLimit, true
	case 9620:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighLimit, true
	case 9621:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLimit, true
	case 9622:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowLimit, true
	case 9624:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventId, true
	case 9625:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventType, true
	case 9626:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceNode, true
	case 9627:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceName, true
	case 9628:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Time, true
	case 9629:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReceiveTime, true
	case 9630:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LocalTime, true
	case 9631:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Message, true
	case 9632:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Severity, true
	case 9633:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionName, true
	case 9634:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BranchId, true
	case 9635:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Retain, true
	case 9636:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState, true
	case 9637:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Id, true
	case 9638:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Name, true
	case 9639:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Number, true
	case 9640:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName, true
	case 9641:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime, true
	case 9642:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime, true
	case 9643:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TrueState, true
	case 9644:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_FalseState, true
	case 9645:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality, true
	case 9646:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp, true
	case 9647:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity, true
	case 9648:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp, true
	case 9649:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment, true
	case 9650:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp, true
	case 9651:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ClientUserId, true
	case 9655:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments, true
	case 9657:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments, true
	case 9658:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState, true
	case 9659:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Id, true
	case 9660:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Name, true
	case 9661:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Number, true
	case 9662:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName, true
	case 9663:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime, true
	case 9664:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime, true
	case 9665:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TrueState, true
	case 9666:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_FalseState, true
	case 9667:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState, true
	case 9668:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id, true
	case 9669:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Name, true
	case 9670:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Number, true
	case 9671:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 9672:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime, true
	case 9673:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 9674:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState, true
	case 9675:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState, true
	case 9677:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments, true
	case 9679:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments, true
	case 9680:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState, true
	case 9681:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Id, true
	case 9682:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Name, true
	case 9683:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Number, true
	case 9684:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName, true
	case 9685:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime, true
	case 9686:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9687:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TrueState, true
	case 9688:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_FalseState, true
	case 9689:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState, true
	case 9690:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Id, true
	case 9691:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Name, true
	case 9692:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Number, true
	case 9693:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName, true
	case 9694:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime, true
	case 9695:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 9696:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState, true
	case 9697:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState, true
	case 9699:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState, true
	case 9700:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id, true
	case 9701:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name, true
	case 9702:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number, true
	case 9703:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 9704:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition, true
	case 9705:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id, true
	case 9706:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name, true
	case 9707:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number, true
	case 9708:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 9709:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime, true
	case 9734:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 9735:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedOrShelved, true
	case 9736:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_MaxTimeShelved, true
	case 9738:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState, true
	case 9739:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id, true
	case 9740:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name, true
	case 9741:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number, true
	case 9742:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case 9743:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition, true
	case 9744:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id, true
	case 9745:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name, true
	case 9746:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number, true
	case 9747:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime, true
	case 9760:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighLimit, true
	case 9761:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighLimit, true
	case 9762:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLimit, true
	case 9763:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowLimit, true
	case 9765:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventId, true
	case 9766:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventType, true
	case 9767:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceNode, true
	case 9768:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceName, true
	case 9769:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Time, true
	case 9770:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReceiveTime, true
	case 9771:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LocalTime, true
	case 9772:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Message, true
	case 9773:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Severity, true
	case 9774:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionName, true
	case 9775:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BranchId, true
	case 9776:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Retain, true
	case 9777:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState, true
	case 9778:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Id, true
	case 9779:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Name, true
	case 9780:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Number, true
	case 9781:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName, true
	case 9782:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TransitionTime, true
	case 9783:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime, true
	case 9784:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TrueState, true
	case 9785:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_FalseState, true
	case 9786:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality, true
	case 9787:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality_SourceTimestamp, true
	case 9788:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity, true
	case 9789:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp, true
	case 9790:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment, true
	case 9791:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment_SourceTimestamp, true
	case 9792:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ClientUserId, true
	case 9796:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AddComment_InputArguments, true
	case 9798:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments, true
	case 9799:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState, true
	case 9800:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Id, true
	case 9801:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Name, true
	case 9802:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Number, true
	case 9803:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName, true
	case 9804:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TransitionTime, true
	case 9805:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime, true
	case 9806:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TrueState, true
	case 9807:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_FalseState, true
	case 9808:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState, true
	case 9809:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Id, true
	case 9810:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Name, true
	case 9811:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Number, true
	case 9812:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 9813:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime, true
	case 9814:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 9815:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TrueState, true
	case 9816:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_FalseState, true
	case 9818:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Acknowledge_InputArguments, true
	case 9820:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Confirm_InputArguments, true
	case 9821:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState, true
	case 9822:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Id, true
	case 9823:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Name, true
	case 9824:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Number, true
	case 9825:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName, true
	case 9826:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TransitionTime, true
	case 9827:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9828:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TrueState, true
	case 9829:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_FalseState, true
	case 9830:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState, true
	case 9831:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Id, true
	case 9832:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Name, true
	case 9833:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Number, true
	case 9834:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName, true
	case 9835:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TransitionTime, true
	case 9836:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 9837:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TrueState, true
	case 9838:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_FalseState, true
	case 9840:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState, true
	case 9841:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id, true
	case 9842:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name, true
	case 9843:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number, true
	case 9844:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 9845:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition, true
	case 9846:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id, true
	case 9847:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name, true
	case 9848:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number, true
	case 9849:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 9850:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime, true
	case 9875:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 9876:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedOrShelved, true
	case 9877:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_MaxTimeShelved, true
	case 9879:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState, true
	case 9880:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id, true
	case 9881:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Name, true
	case 9882:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Number, true
	case 9883:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case 9884:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition, true
	case 9885:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id, true
	case 9886:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Name, true
	case 9887:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Number, true
	case 9888:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime, true
	case 9901:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighLimit, true
	case 9902:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighLimit, true
	case 9903:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLimit, true
	case 9904:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowLimit, true
	case 9905:
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SetpointNode, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableExclusiveByName(value string) (enum OpcuaNodeIdServicesVariableExclusive, ok bool) {
	switch value {
	case "ExclusiveLimitAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassId, true
	case "ExclusiveLimitAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassName, true
	case "ExclusiveLimitAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_InputNode, true
	case "ExclusiveLevelAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassId, true
	case "ExclusiveLevelAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassName, true
	case "ExclusiveLevelAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_InputNode, true
	case "ExclusiveRateOfChangeAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassId, true
	case "ExclusiveRateOfChangeAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassName, true
	case "ExclusiveRateOfChangeAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_InputNode, true
	case "ExclusiveDeviationAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassId, true
	case "ExclusiveDeviationAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassName, true
	case "ExclusiveDeviationAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_InputNode, true
	case "ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber, true
	case "ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber, true
	case "ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber, true
	case "ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber, true
	case "ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments, true
	case "ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments, true
	case "ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments, true
	case "ExclusiveLimitAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassId, true
	case "ExclusiveLimitAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassName, true
	case "ExclusiveLimitAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Id, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Name, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Number, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TrueState, true
	case "ExclusiveLimitAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_FalseState, true
	case "ExclusiveLimitAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState, true
	case "ExclusiveLimitAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Id, true
	case "ExclusiveLimitAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Name, true
	case "ExclusiveLimitAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Number, true
	case "ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TransitionTime, true
	case "ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TrueState, true
	case "ExclusiveLimitAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_FalseState, true
	case "ExclusiveLimitAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleEnabled, true
	case "ExclusiveLimitAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound, true
	case "ExclusiveLimitAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OnDelay, true
	case "ExclusiveLimitAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OffDelay, true
	case "ExclusiveLimitAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_FirstInGroupFlag, true
	case "ExclusiveLimitAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmTime, true
	case "ExclusiveLimitAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmRepeatCount, true
	case "ExclusiveLimitAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighHighLimit, true
	case "ExclusiveLimitAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighLimit, true
	case "ExclusiveLimitAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLimit, true
	case "ExclusiveLimitAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLowLimit, true
	case "ExclusiveLevelAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassId, true
	case "ExclusiveLevelAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassName, true
	case "ExclusiveLevelAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Id, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Name, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Number, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TrueState, true
	case "ExclusiveLevelAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_FalseState, true
	case "ExclusiveLevelAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState, true
	case "ExclusiveLevelAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Id, true
	case "ExclusiveLevelAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Name, true
	case "ExclusiveLevelAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Number, true
	case "ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TransitionTime, true
	case "ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TrueState, true
	case "ExclusiveLevelAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_FalseState, true
	case "ExclusiveLevelAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleEnabled, true
	case "ExclusiveLevelAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound, true
	case "ExclusiveLevelAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OnDelay, true
	case "ExclusiveLevelAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OffDelay, true
	case "ExclusiveLevelAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_FirstInGroupFlag, true
	case "ExclusiveLevelAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmTime, true
	case "ExclusiveLevelAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmRepeatCount, true
	case "ExclusiveLevelAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighHighLimit, true
	case "ExclusiveLevelAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighLimit, true
	case "ExclusiveLevelAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLimit, true
	case "ExclusiveLevelAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLowLimit, true
	case "ExclusiveDeviationAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassId, true
	case "ExclusiveDeviationAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassName, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Id, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Name, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Number, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TrueState, true
	case "ExclusiveDeviationAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_FalseState, true
	case "ExclusiveDeviationAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState, true
	case "ExclusiveDeviationAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Id, true
	case "ExclusiveDeviationAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Name, true
	case "ExclusiveDeviationAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Number, true
	case "ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TrueState, true
	case "ExclusiveDeviationAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_FalseState, true
	case "ExclusiveDeviationAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleEnabled, true
	case "ExclusiveDeviationAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound, true
	case "ExclusiveDeviationAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OnDelay, true
	case "ExclusiveDeviationAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OffDelay, true
	case "ExclusiveDeviationAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_FirstInGroupFlag, true
	case "ExclusiveDeviationAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmTime, true
	case "ExclusiveDeviationAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmRepeatCount, true
	case "ExclusiveDeviationAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighHighLimit, true
	case "ExclusiveDeviationAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighLimit, true
	case "ExclusiveDeviationAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLimit, true
	case "ExclusiveDeviationAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLowLimit, true
	case "ExclusiveDeviationAlarmType_BaseSetpointNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseSetpointNode, true
	case "ExclusiveRateOfChangeAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassId, true
	case "ExclusiveRateOfChangeAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassName, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Id, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Name, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Number, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleEnabled, true
	case "ExclusiveRateOfChangeAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound, true
	case "ExclusiveRateOfChangeAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OnDelay, true
	case "ExclusiveRateOfChangeAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OffDelay, true
	case "ExclusiveRateOfChangeAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_FirstInGroupFlag, true
	case "ExclusiveRateOfChangeAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmTime, true
	case "ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount, true
	case "ExclusiveRateOfChangeAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighHighLimit, true
	case "ExclusiveRateOfChangeAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighLimit, true
	case "ExclusiveRateOfChangeAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLimit, true
	case "ExclusiveRateOfChangeAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLowLimit, true
	case "ExclusiveRateOfChangeAlarmType_EngineeringUnits":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case "ExclusiveLimitStateMachineType_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableStates, true
	case "ExclusiveLimitStateMachineType_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableTransitions, true
	case "ExclusiveLimitAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableStates, true
	case "ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions, true
	case "ExclusiveLimitAlarmType_LimitState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableStates, true
	case "ExclusiveLimitAlarmType_LimitState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableTransitions, true
	case "ExclusiveLevelAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableStates, true
	case "ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions, true
	case "ExclusiveLevelAlarmType_LimitState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableStates, true
	case "ExclusiveLevelAlarmType_LimitState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableTransitions, true
	case "ExclusiveDeviationAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableStates, true
	case "ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions, true
	case "ExclusiveDeviationAlarmType_LimitState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableStates, true
	case "ExclusiveDeviationAlarmType_LimitState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableTransitions, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions, true
	case "ExclusiveLimitAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_ListId, true
	case "ExclusiveLimitAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_AgencyId, true
	case "ExclusiveLimitAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_VersionId, true
	case "ExclusiveLevelAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_ListId, true
	case "ExclusiveLevelAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_AgencyId, true
	case "ExclusiveLevelAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_VersionId, true
	case "ExclusiveDeviationAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_ListId, true
	case "ExclusiveDeviationAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_AgencyId, true
	case "ExclusiveDeviationAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_VersionId, true
	case "ExclusiveRateOfChangeAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_ListId, true
	case "ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId, true
	case "ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId, true
	case "ExclusiveLimitAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState, true
	case "ExclusiveLimitAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Id, true
	case "ExclusiveLimitAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Name, true
	case "ExclusiveLimitAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Number, true
	case "ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TransitionTime, true
	case "ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TrueState, true
	case "ExclusiveLimitAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_FalseState, true
	case "ExclusiveLevelAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState, true
	case "ExclusiveLevelAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Id, true
	case "ExclusiveLevelAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Name, true
	case "ExclusiveLevelAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Number, true
	case "ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TransitionTime, true
	case "ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TrueState, true
	case "ExclusiveLevelAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_FalseState, true
	case "ExclusiveDeviationAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState, true
	case "ExclusiveDeviationAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Id, true
	case "ExclusiveDeviationAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Name, true
	case "ExclusiveDeviationAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Number, true
	case "ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TrueState, true
	case "ExclusiveDeviationAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Id, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Name, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Number, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_FalseState, true
	case "ExclusiveLimitAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Suppress2_InputArguments, true
	case "ExclusiveLimitAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Unsuppress2_InputArguments, true
	case "ExclusiveLimitAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments, true
	case "ExclusiveLimitAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_PlaceInService2_InputArguments, true
	case "ExclusiveLimitAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Reset2_InputArguments, true
	case "ExclusiveLevelAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Suppress2_InputArguments, true
	case "ExclusiveLevelAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Unsuppress2_InputArguments, true
	case "ExclusiveLevelAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments, true
	case "ExclusiveLevelAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_PlaceInService2_InputArguments, true
	case "ExclusiveLevelAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Reset2_InputArguments, true
	case "ExclusiveDeviationAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Suppress2_InputArguments, true
	case "ExclusiveDeviationAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments, true
	case "ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments, true
	case "ExclusiveDeviationAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments, true
	case "ExclusiveDeviationAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Reset2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments, true
	case "ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "ExclusiveLimitAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHighHigh, true
	case "ExclusiveLimitAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHigh, true
	case "ExclusiveLimitAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLow, true
	case "ExclusiveLimitAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLowLow, true
	case "ExclusiveLimitAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighDeadband, true
	case "ExclusiveLimitAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighDeadband, true
	case "ExclusiveLimitAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowDeadband, true
	case "ExclusiveLimitAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowDeadband, true
	case "ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "ExclusiveLevelAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHighHigh, true
	case "ExclusiveLevelAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHigh, true
	case "ExclusiveLevelAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLow, true
	case "ExclusiveLevelAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLowLow, true
	case "ExclusiveLevelAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighDeadband, true
	case "ExclusiveLevelAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighDeadband, true
	case "ExclusiveLevelAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowDeadband, true
	case "ExclusiveLevelAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowDeadband, true
	case "ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "ExclusiveDeviationAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHighHigh, true
	case "ExclusiveDeviationAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHigh, true
	case "ExclusiveDeviationAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLow, true
	case "ExclusiveDeviationAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLowLow, true
	case "ExclusiveDeviationAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighDeadband, true
	case "ExclusiveDeviationAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighDeadband, true
	case "ExclusiveDeviationAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowDeadband, true
	case "ExclusiveDeviationAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowDeadband, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHighHigh, true
	case "ExclusiveRateOfChangeAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHigh, true
	case "ExclusiveRateOfChangeAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLow, true
	case "ExclusiveRateOfChangeAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLowLow, true
	case "ExclusiveRateOfChangeAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighDeadband, true
	case "ExclusiveRateOfChangeAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighDeadband, true
	case "ExclusiveRateOfChangeAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowDeadband, true
	case "ExclusiveRateOfChangeAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowDeadband, true
	case "ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments, true
	case "ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments, true
	case "ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments, true
	case "ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments, true
	case "ExclusiveLimitAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SupportsFilteredRetain, true
	case "ExclusiveLevelAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SupportsFilteredRetain, true
	case "ExclusiveDeviationAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SupportsFilteredRetain, true
	case "ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain, true
	case "ExclusiveLimitStateMachineType_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState, true
	case "ExclusiveLimitStateMachineType_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Id, true
	case "ExclusiveLimitStateMachineType_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Name, true
	case "ExclusiveLimitStateMachineType_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Number, true
	case "ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName, true
	case "ExclusiveLimitStateMachineType_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition, true
	case "ExclusiveLimitStateMachineType_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Id, true
	case "ExclusiveLimitStateMachineType_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Name, true
	case "ExclusiveLimitStateMachineType_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Number, true
	case "ExclusiveLimitStateMachineType_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_TransitionTime, true
	case "ExclusiveLimitStateMachineType_HighHigh_StateNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHigh_StateNumber, true
	case "ExclusiveLimitStateMachineType_High_StateNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_High_StateNumber, true
	case "ExclusiveLimitStateMachineType_Low_StateNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_Low_StateNumber, true
	case "ExclusiveLimitStateMachineType_LowLow_StateNumber":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLow_StateNumber, true
	case "ExclusiveLimitAlarmType_EventId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventId, true
	case "ExclusiveLimitAlarmType_EventType":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventType, true
	case "ExclusiveLimitAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceNode, true
	case "ExclusiveLimitAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceName, true
	case "ExclusiveLimitAlarmType_Time":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Time, true
	case "ExclusiveLimitAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReceiveTime, true
	case "ExclusiveLimitAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LocalTime, true
	case "ExclusiveLimitAlarmType_Message":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Message, true
	case "ExclusiveLimitAlarmType_Severity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Severity, true
	case "ExclusiveLimitAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionName, true
	case "ExclusiveLimitAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BranchId, true
	case "ExclusiveLimitAlarmType_Retain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Retain, true
	case "ExclusiveLimitAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState, true
	case "ExclusiveLimitAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Id, true
	case "ExclusiveLimitAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Name, true
	case "ExclusiveLimitAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Number, true
	case "ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TransitionTime, true
	case "ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TrueState, true
	case "ExclusiveLimitAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_FalseState, true
	case "ExclusiveLimitAlarmType_Quality":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality, true
	case "ExclusiveLimitAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality_SourceTimestamp, true
	case "ExclusiveLimitAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity, true
	case "ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp, true
	case "ExclusiveLimitAlarmType_Comment":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment, true
	case "ExclusiveLimitAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment_SourceTimestamp, true
	case "ExclusiveLimitAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ClientUserId, true
	case "ExclusiveLimitAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AddComment_InputArguments, true
	case "ExclusiveLimitAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments, true
	case "ExclusiveLimitAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState, true
	case "ExclusiveLimitAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Id, true
	case "ExclusiveLimitAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Name, true
	case "ExclusiveLimitAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Number, true
	case "ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TransitionTime, true
	case "ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TrueState, true
	case "ExclusiveLimitAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_FalseState, true
	case "ExclusiveLimitAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState, true
	case "ExclusiveLimitAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Id, true
	case "ExclusiveLimitAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Name, true
	case "ExclusiveLimitAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Number, true
	case "ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TransitionTime, true
	case "ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TrueState, true
	case "ExclusiveLimitAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_FalseState, true
	case "ExclusiveLimitAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Acknowledge_InputArguments, true
	case "ExclusiveLimitAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Confirm_InputArguments, true
	case "ExclusiveLimitAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState, true
	case "ExclusiveLimitAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Id, true
	case "ExclusiveLimitAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Name, true
	case "ExclusiveLimitAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Number, true
	case "ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case "ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TrueState, true
	case "ExclusiveLimitAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_FalseState, true
	case "ExclusiveLimitAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState, true
	case "ExclusiveLimitAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Id, true
	case "ExclusiveLimitAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Name, true
	case "ExclusiveLimitAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Number, true
	case "ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TransitionTime, true
	case "ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "ExclusiveLimitAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TrueState, true
	case "ExclusiveLimitAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_FalseState, true
	case "ExclusiveLimitAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState, true
	case "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id, true
	case "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name, true
	case "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number, true
	case "ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number, true
	case "ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "ExclusiveLimitAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime, true
	case "ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "ExclusiveLimitAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedOrShelved, true
	case "ExclusiveLimitAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_MaxTimeShelved, true
	case "ExclusiveLimitAlarmType_LimitState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState, true
	case "ExclusiveLimitAlarmType_LimitState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Id, true
	case "ExclusiveLimitAlarmType_LimitState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Name, true
	case "ExclusiveLimitAlarmType_LimitState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Number, true
	case "ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Id, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Name, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Number, true
	case "ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime, true
	case "ExclusiveLimitAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighLimit, true
	case "ExclusiveLimitAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighLimit, true
	case "ExclusiveLimitAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLimit, true
	case "ExclusiveLimitAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowLimit, true
	case "ExclusiveLevelAlarmType_EventId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventId, true
	case "ExclusiveLevelAlarmType_EventType":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventType, true
	case "ExclusiveLevelAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceNode, true
	case "ExclusiveLevelAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceName, true
	case "ExclusiveLevelAlarmType_Time":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Time, true
	case "ExclusiveLevelAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReceiveTime, true
	case "ExclusiveLevelAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LocalTime, true
	case "ExclusiveLevelAlarmType_Message":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Message, true
	case "ExclusiveLevelAlarmType_Severity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Severity, true
	case "ExclusiveLevelAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionName, true
	case "ExclusiveLevelAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BranchId, true
	case "ExclusiveLevelAlarmType_Retain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Retain, true
	case "ExclusiveLevelAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState, true
	case "ExclusiveLevelAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Id, true
	case "ExclusiveLevelAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Name, true
	case "ExclusiveLevelAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Number, true
	case "ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TransitionTime, true
	case "ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TrueState, true
	case "ExclusiveLevelAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_FalseState, true
	case "ExclusiveLevelAlarmType_Quality":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality, true
	case "ExclusiveLevelAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality_SourceTimestamp, true
	case "ExclusiveLevelAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity, true
	case "ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp, true
	case "ExclusiveLevelAlarmType_Comment":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment, true
	case "ExclusiveLevelAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment_SourceTimestamp, true
	case "ExclusiveLevelAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ClientUserId, true
	case "ExclusiveLevelAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AddComment_InputArguments, true
	case "ExclusiveLevelAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments, true
	case "ExclusiveLevelAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState, true
	case "ExclusiveLevelAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Id, true
	case "ExclusiveLevelAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Name, true
	case "ExclusiveLevelAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Number, true
	case "ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TransitionTime, true
	case "ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TrueState, true
	case "ExclusiveLevelAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_FalseState, true
	case "ExclusiveLevelAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState, true
	case "ExclusiveLevelAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Id, true
	case "ExclusiveLevelAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Name, true
	case "ExclusiveLevelAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Number, true
	case "ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TransitionTime, true
	case "ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TrueState, true
	case "ExclusiveLevelAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_FalseState, true
	case "ExclusiveLevelAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Acknowledge_InputArguments, true
	case "ExclusiveLevelAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Confirm_InputArguments, true
	case "ExclusiveLevelAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState, true
	case "ExclusiveLevelAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Id, true
	case "ExclusiveLevelAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Name, true
	case "ExclusiveLevelAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Number, true
	case "ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TransitionTime, true
	case "ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TrueState, true
	case "ExclusiveLevelAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_FalseState, true
	case "ExclusiveLevelAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState, true
	case "ExclusiveLevelAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Id, true
	case "ExclusiveLevelAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Name, true
	case "ExclusiveLevelAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Number, true
	case "ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TransitionTime, true
	case "ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "ExclusiveLevelAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TrueState, true
	case "ExclusiveLevelAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_FalseState, true
	case "ExclusiveLevelAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState, true
	case "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id, true
	case "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name, true
	case "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number, true
	case "ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number, true
	case "ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "ExclusiveLevelAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime, true
	case "ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "ExclusiveLevelAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedOrShelved, true
	case "ExclusiveLevelAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_MaxTimeShelved, true
	case "ExclusiveLevelAlarmType_LimitState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState, true
	case "ExclusiveLevelAlarmType_LimitState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Id, true
	case "ExclusiveLevelAlarmType_LimitState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Name, true
	case "ExclusiveLevelAlarmType_LimitState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Number, true
	case "ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Id, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Name, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Number, true
	case "ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime, true
	case "ExclusiveLevelAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighLimit, true
	case "ExclusiveLevelAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighLimit, true
	case "ExclusiveLevelAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLimit, true
	case "ExclusiveLevelAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowLimit, true
	case "ExclusiveRateOfChangeAlarmType_EventId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventId, true
	case "ExclusiveRateOfChangeAlarmType_EventType":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventType, true
	case "ExclusiveRateOfChangeAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceNode, true
	case "ExclusiveRateOfChangeAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceName, true
	case "ExclusiveRateOfChangeAlarmType_Time":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Time, true
	case "ExclusiveRateOfChangeAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReceiveTime, true
	case "ExclusiveRateOfChangeAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LocalTime, true
	case "ExclusiveRateOfChangeAlarmType_Message":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Message, true
	case "ExclusiveRateOfChangeAlarmType_Severity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Severity, true
	case "ExclusiveRateOfChangeAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionName, true
	case "ExclusiveRateOfChangeAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BranchId, true
	case "ExclusiveRateOfChangeAlarmType_Retain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Retain, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Id, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Name, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Number, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_Quality":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality, true
	case "ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp, true
	case "ExclusiveRateOfChangeAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity, true
	case "ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp, true
	case "ExclusiveRateOfChangeAlarmType_Comment":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment, true
	case "ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp, true
	case "ExclusiveRateOfChangeAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ClientUserId, true
	case "ExclusiveRateOfChangeAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Id, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Name, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Number, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Name, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Number, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Id, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Name, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Number, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Id, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Name, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Number, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime, true
	case "ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "ExclusiveRateOfChangeAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedOrShelved, true
	case "ExclusiveRateOfChangeAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_MaxTimeShelved, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number, true
	case "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime, true
	case "ExclusiveRateOfChangeAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighLimit, true
	case "ExclusiveRateOfChangeAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighLimit, true
	case "ExclusiveRateOfChangeAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLimit, true
	case "ExclusiveRateOfChangeAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowLimit, true
	case "ExclusiveDeviationAlarmType_EventId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventId, true
	case "ExclusiveDeviationAlarmType_EventType":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventType, true
	case "ExclusiveDeviationAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceNode, true
	case "ExclusiveDeviationAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceName, true
	case "ExclusiveDeviationAlarmType_Time":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Time, true
	case "ExclusiveDeviationAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReceiveTime, true
	case "ExclusiveDeviationAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LocalTime, true
	case "ExclusiveDeviationAlarmType_Message":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Message, true
	case "ExclusiveDeviationAlarmType_Severity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Severity, true
	case "ExclusiveDeviationAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionName, true
	case "ExclusiveDeviationAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BranchId, true
	case "ExclusiveDeviationAlarmType_Retain":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Retain, true
	case "ExclusiveDeviationAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState, true
	case "ExclusiveDeviationAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Id, true
	case "ExclusiveDeviationAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Name, true
	case "ExclusiveDeviationAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Number, true
	case "ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TrueState, true
	case "ExclusiveDeviationAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_FalseState, true
	case "ExclusiveDeviationAlarmType_Quality":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality, true
	case "ExclusiveDeviationAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality_SourceTimestamp, true
	case "ExclusiveDeviationAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity, true
	case "ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp, true
	case "ExclusiveDeviationAlarmType_Comment":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment, true
	case "ExclusiveDeviationAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment_SourceTimestamp, true
	case "ExclusiveDeviationAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ClientUserId, true
	case "ExclusiveDeviationAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AddComment_InputArguments, true
	case "ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments, true
	case "ExclusiveDeviationAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState, true
	case "ExclusiveDeviationAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Id, true
	case "ExclusiveDeviationAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Name, true
	case "ExclusiveDeviationAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Number, true
	case "ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TrueState, true
	case "ExclusiveDeviationAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_FalseState, true
	case "ExclusiveDeviationAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Id, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Name, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Number, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TrueState, true
	case "ExclusiveDeviationAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_FalseState, true
	case "ExclusiveDeviationAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Acknowledge_InputArguments, true
	case "ExclusiveDeviationAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Confirm_InputArguments, true
	case "ExclusiveDeviationAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState, true
	case "ExclusiveDeviationAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Id, true
	case "ExclusiveDeviationAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Name, true
	case "ExclusiveDeviationAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Number, true
	case "ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TrueState, true
	case "ExclusiveDeviationAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_FalseState, true
	case "ExclusiveDeviationAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState, true
	case "ExclusiveDeviationAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Id, true
	case "ExclusiveDeviationAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Name, true
	case "ExclusiveDeviationAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Number, true
	case "ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TransitionTime, true
	case "ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "ExclusiveDeviationAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TrueState, true
	case "ExclusiveDeviationAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_FalseState, true
	case "ExclusiveDeviationAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState, true
	case "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id, true
	case "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name, true
	case "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number, true
	case "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number, true
	case "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime, true
	case "ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "ExclusiveDeviationAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedOrShelved, true
	case "ExclusiveDeviationAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_MaxTimeShelved, true
	case "ExclusiveDeviationAlarmType_LimitState_CurrentState":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState, true
	case "ExclusiveDeviationAlarmType_LimitState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id, true
	case "ExclusiveDeviationAlarmType_LimitState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Name, true
	case "ExclusiveDeviationAlarmType_LimitState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Number, true
	case "ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Name, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Number, true
	case "ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime, true
	case "ExclusiveDeviationAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighLimit, true
	case "ExclusiveDeviationAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighLimit, true
	case "ExclusiveDeviationAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLimit, true
	case "ExclusiveDeviationAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowLimit, true
	case "ExclusiveDeviationAlarmType_SetpointNode":
		return OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SetpointNode, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableExclusiveKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableExclusiveValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableExclusive(structType any) OpcuaNodeIdServicesVariableExclusive {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableExclusive {
		if sOpcuaNodeIdServicesVariableExclusive, ok := typ.(OpcuaNodeIdServicesVariableExclusive); ok {
			return sOpcuaNodeIdServicesVariableExclusive
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableExclusive) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableExclusive) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableExclusiveParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableExclusive, error) {
	return OpcuaNodeIdServicesVariableExclusiveParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableExclusiveParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableExclusive, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableExclusive", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableExclusive")
	}
	if enum, ok := OpcuaNodeIdServicesVariableExclusiveByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableExclusive")
		return OpcuaNodeIdServicesVariableExclusive(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableExclusive) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableExclusive) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableExclusive", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableExclusive) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassId:
		return "ExclusiveLimitAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionClassName:
		return "ExclusiveLimitAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_InputNode:
		return "ExclusiveLimitAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassId:
		return "ExclusiveLevelAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionClassName:
		return "ExclusiveLevelAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_InputNode:
		return "ExclusiveLevelAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassId:
		return "ExclusiveRateOfChangeAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionClassName:
		return "ExclusiveRateOfChangeAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_InputNode:
		return "ExclusiveRateOfChangeAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassId:
		return "ExclusiveDeviationAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionClassName:
		return "ExclusiveDeviationAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_InputNode:
		return "ExclusiveDeviationAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber:
		return "ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber:
		return "ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber:
		return "ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber:
		return "ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime:
		return "ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments:
		return "ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments:
		return "ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments:
		return "ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassId:
		return "ExclusiveLimitAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionSubClassName:
		return "ExclusiveLimitAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState:
		return "ExclusiveLimitAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Id:
		return "ExclusiveLimitAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Name:
		return "ExclusiveLimitAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_Number:
		return "ExclusiveLimitAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime:
		return "ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_TrueState:
		return "ExclusiveLimitAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OutOfServiceState_FalseState:
		return "ExclusiveLimitAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState:
		return "ExclusiveLimitAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Id:
		return "ExclusiveLimitAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Name:
		return "ExclusiveLimitAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_Number:
		return "ExclusiveLimitAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TransitionTime:
		return "ExclusiveLimitAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_TrueState:
		return "ExclusiveLimitAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SilenceState_FalseState:
		return "ExclusiveLimitAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleEnabled:
		return "ExclusiveLimitAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound:
		return "ExclusiveLimitAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OnDelay:
		return "ExclusiveLimitAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_OffDelay:
		return "ExclusiveLimitAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_FirstInGroupFlag:
		return "ExclusiveLimitAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmTime:
		return "ExclusiveLimitAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReAlarmRepeatCount:
		return "ExclusiveLimitAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighHighLimit:
		return "ExclusiveLimitAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseHighLimit:
		return "ExclusiveLimitAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLimit:
		return "ExclusiveLimitAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BaseLowLowLimit:
		return "ExclusiveLimitAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassId:
		return "ExclusiveLevelAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionSubClassName:
		return "ExclusiveLevelAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState:
		return "ExclusiveLevelAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Id:
		return "ExclusiveLevelAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Name:
		return "ExclusiveLevelAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_Number:
		return "ExclusiveLevelAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime:
		return "ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_TrueState:
		return "ExclusiveLevelAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OutOfServiceState_FalseState:
		return "ExclusiveLevelAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState:
		return "ExclusiveLevelAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Id:
		return "ExclusiveLevelAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Name:
		return "ExclusiveLevelAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_Number:
		return "ExclusiveLevelAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TransitionTime:
		return "ExclusiveLevelAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_TrueState:
		return "ExclusiveLevelAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SilenceState_FalseState:
		return "ExclusiveLevelAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleEnabled:
		return "ExclusiveLevelAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound:
		return "ExclusiveLevelAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OnDelay:
		return "ExclusiveLevelAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_OffDelay:
		return "ExclusiveLevelAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_FirstInGroupFlag:
		return "ExclusiveLevelAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmTime:
		return "ExclusiveLevelAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReAlarmRepeatCount:
		return "ExclusiveLevelAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighHighLimit:
		return "ExclusiveLevelAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseHighLimit:
		return "ExclusiveLevelAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLimit:
		return "ExclusiveLevelAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BaseLowLowLimit:
		return "ExclusiveLevelAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassId:
		return "ExclusiveDeviationAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionSubClassName:
		return "ExclusiveDeviationAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState:
		return "ExclusiveDeviationAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Id:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Name:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_Number:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_TrueState:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OutOfServiceState_FalseState:
		return "ExclusiveDeviationAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState:
		return "ExclusiveDeviationAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Id:
		return "ExclusiveDeviationAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Name:
		return "ExclusiveDeviationAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_Number:
		return "ExclusiveDeviationAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TransitionTime:
		return "ExclusiveDeviationAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_TrueState:
		return "ExclusiveDeviationAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SilenceState_FalseState:
		return "ExclusiveDeviationAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleEnabled:
		return "ExclusiveDeviationAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound:
		return "ExclusiveDeviationAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OnDelay:
		return "ExclusiveDeviationAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_OffDelay:
		return "ExclusiveDeviationAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_FirstInGroupFlag:
		return "ExclusiveDeviationAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmTime:
		return "ExclusiveDeviationAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReAlarmRepeatCount:
		return "ExclusiveDeviationAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighHighLimit:
		return "ExclusiveDeviationAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseHighLimit:
		return "ExclusiveDeviationAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLimit:
		return "ExclusiveDeviationAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseLowLowLimit:
		return "ExclusiveDeviationAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BaseSetpointNode:
		return "ExclusiveDeviationAlarmType_BaseSetpointNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassId:
		return "ExclusiveRateOfChangeAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionSubClassName:
		return "ExclusiveRateOfChangeAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState:
		return "ExclusiveRateOfChangeAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Id:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Name:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_Number:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SilenceState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleEnabled:
		return "ExclusiveRateOfChangeAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound:
		return "ExclusiveRateOfChangeAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OnDelay:
		return "ExclusiveRateOfChangeAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_OffDelay:
		return "ExclusiveRateOfChangeAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_FirstInGroupFlag:
		return "ExclusiveRateOfChangeAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmTime:
		return "ExclusiveRateOfChangeAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount:
		return "ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighHighLimit:
		return "ExclusiveRateOfChangeAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseHighLimit:
		return "ExclusiveRateOfChangeAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLimit:
		return "ExclusiveRateOfChangeAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BaseLowLowLimit:
		return "ExclusiveRateOfChangeAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EngineeringUnits:
		return "ExclusiveRateOfChangeAlarmType_EngineeringUnits"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableStates:
		return "ExclusiveLimitStateMachineType_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_AvailableTransitions:
		return "ExclusiveLimitStateMachineType_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableStates:
		return "ExclusiveLimitAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions:
		return "ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableStates:
		return "ExclusiveLimitAlarmType_LimitState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_AvailableTransitions:
		return "ExclusiveLimitAlarmType_LimitState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableStates:
		return "ExclusiveLevelAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions:
		return "ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableStates:
		return "ExclusiveLevelAlarmType_LimitState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_AvailableTransitions:
		return "ExclusiveLevelAlarmType_LimitState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableStates:
		return "ExclusiveDeviationAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions:
		return "ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableStates:
		return "ExclusiveDeviationAlarmType_LimitState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_AvailableTransitions:
		return "ExclusiveDeviationAlarmType_LimitState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates:
		return "ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions:
		return "ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_ListId:
		return "ExclusiveLimitAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_AgencyId:
		return "ExclusiveLimitAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AudibleSound_VersionId:
		return "ExclusiveLimitAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_ListId:
		return "ExclusiveLevelAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_AgencyId:
		return "ExclusiveLevelAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AudibleSound_VersionId:
		return "ExclusiveLevelAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_ListId:
		return "ExclusiveDeviationAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_AgencyId:
		return "ExclusiveDeviationAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AudibleSound_VersionId:
		return "ExclusiveDeviationAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_ListId:
		return "ExclusiveRateOfChangeAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId:
		return "ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId:
		return "ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState:
		return "ExclusiveLimitAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Id:
		return "ExclusiveLimitAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Name:
		return "ExclusiveLimitAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_Number:
		return "ExclusiveLimitAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TransitionTime:
		return "ExclusiveLimitAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_TrueState:
		return "ExclusiveLimitAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LatchedState_FalseState:
		return "ExclusiveLimitAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState:
		return "ExclusiveLevelAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Id:
		return "ExclusiveLevelAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Name:
		return "ExclusiveLevelAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_Number:
		return "ExclusiveLevelAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TransitionTime:
		return "ExclusiveLevelAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_TrueState:
		return "ExclusiveLevelAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LatchedState_FalseState:
		return "ExclusiveLevelAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState:
		return "ExclusiveDeviationAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Id:
		return "ExclusiveDeviationAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Name:
		return "ExclusiveDeviationAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_Number:
		return "ExclusiveDeviationAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TransitionTime:
		return "ExclusiveDeviationAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_TrueState:
		return "ExclusiveDeviationAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LatchedState_FalseState:
		return "ExclusiveDeviationAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState:
		return "ExclusiveRateOfChangeAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Id:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Name:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_Number:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LatchedState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Suppress2_InputArguments:
		return "ExclusiveLimitAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Unsuppress2_InputArguments:
		return "ExclusiveLimitAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments:
		return "ExclusiveLimitAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_PlaceInService2_InputArguments:
		return "ExclusiveLimitAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Reset2_InputArguments:
		return "ExclusiveLimitAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Suppress2_InputArguments:
		return "ExclusiveLevelAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Unsuppress2_InputArguments:
		return "ExclusiveLevelAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments:
		return "ExclusiveLevelAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_PlaceInService2_InputArguments:
		return "ExclusiveLevelAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Reset2_InputArguments:
		return "ExclusiveLevelAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Suppress2_InputArguments:
		return "ExclusiveDeviationAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments:
		return "ExclusiveDeviationAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments:
		return "ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments:
		return "ExclusiveDeviationAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Reset2_InputArguments:
		return "ExclusiveDeviationAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHighHigh:
		return "ExclusiveLimitAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityHigh:
		return "ExclusiveLimitAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLow:
		return "ExclusiveLimitAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SeverityLowLow:
		return "ExclusiveLimitAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighDeadband:
		return "ExclusiveLimitAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighDeadband:
		return "ExclusiveLimitAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowDeadband:
		return "ExclusiveLimitAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowDeadband:
		return "ExclusiveLimitAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHighHigh:
		return "ExclusiveLevelAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityHigh:
		return "ExclusiveLevelAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLow:
		return "ExclusiveLevelAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SeverityLowLow:
		return "ExclusiveLevelAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighDeadband:
		return "ExclusiveLevelAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighDeadband:
		return "ExclusiveLevelAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowDeadband:
		return "ExclusiveLevelAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowDeadband:
		return "ExclusiveLevelAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHighHigh:
		return "ExclusiveDeviationAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityHigh:
		return "ExclusiveDeviationAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLow:
		return "ExclusiveDeviationAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SeverityLowLow:
		return "ExclusiveDeviationAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighDeadband:
		return "ExclusiveDeviationAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighDeadband:
		return "ExclusiveDeviationAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowDeadband:
		return "ExclusiveDeviationAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowDeadband:
		return "ExclusiveDeviationAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHighHigh:
		return "ExclusiveRateOfChangeAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityHigh:
		return "ExclusiveRateOfChangeAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLow:
		return "ExclusiveRateOfChangeAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SeverityLowLow:
		return "ExclusiveRateOfChangeAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighDeadband:
		return "ExclusiveRateOfChangeAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighDeadband:
		return "ExclusiveRateOfChangeAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowDeadband:
		return "ExclusiveRateOfChangeAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowDeadband:
		return "ExclusiveRateOfChangeAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments:
		return "ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments:
		return "ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments:
		return "ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments:
		return "ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SupportsFilteredRetain:
		return "ExclusiveLimitAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SupportsFilteredRetain:
		return "ExclusiveLevelAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SupportsFilteredRetain:
		return "ExclusiveDeviationAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain:
		return "ExclusiveRateOfChangeAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState:
		return "ExclusiveLimitStateMachineType_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Id:
		return "ExclusiveLimitStateMachineType_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Name:
		return "ExclusiveLimitStateMachineType_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_Number:
		return "ExclusiveLimitStateMachineType_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName:
		return "ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition:
		return "ExclusiveLimitStateMachineType_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Id:
		return "ExclusiveLimitStateMachineType_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Name:
		return "ExclusiveLimitStateMachineType_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_Number:
		return "ExclusiveLimitStateMachineType_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LastTransition_TransitionTime:
		return "ExclusiveLimitStateMachineType_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_HighHigh_StateNumber:
		return "ExclusiveLimitStateMachineType_HighHigh_StateNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_High_StateNumber:
		return "ExclusiveLimitStateMachineType_High_StateNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_Low_StateNumber:
		return "ExclusiveLimitStateMachineType_Low_StateNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitStateMachineType_LowLow_StateNumber:
		return "ExclusiveLimitStateMachineType_LowLow_StateNumber"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventId:
		return "ExclusiveLimitAlarmType_EventId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EventType:
		return "ExclusiveLimitAlarmType_EventType"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceNode:
		return "ExclusiveLimitAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SourceName:
		return "ExclusiveLimitAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Time:
		return "ExclusiveLimitAlarmType_Time"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ReceiveTime:
		return "ExclusiveLimitAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LocalTime:
		return "ExclusiveLimitAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Message:
		return "ExclusiveLimitAlarmType_Message"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Severity:
		return "ExclusiveLimitAlarmType_Severity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionName:
		return "ExclusiveLimitAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_BranchId:
		return "ExclusiveLimitAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Retain:
		return "ExclusiveLimitAlarmType_Retain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState:
		return "ExclusiveLimitAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Id:
		return "ExclusiveLimitAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Name:
		return "ExclusiveLimitAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_Number:
		return "ExclusiveLimitAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TransitionTime:
		return "ExclusiveLimitAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_TrueState:
		return "ExclusiveLimitAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_EnabledState_FalseState:
		return "ExclusiveLimitAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality:
		return "ExclusiveLimitAlarmType_Quality"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Quality_SourceTimestamp:
		return "ExclusiveLimitAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity:
		return "ExclusiveLimitAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp:
		return "ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment:
		return "ExclusiveLimitAlarmType_Comment"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Comment_SourceTimestamp:
		return "ExclusiveLimitAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ClientUserId:
		return "ExclusiveLimitAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AddComment_InputArguments:
		return "ExclusiveLimitAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments:
		return "ExclusiveLimitAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState:
		return "ExclusiveLimitAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Id:
		return "ExclusiveLimitAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Name:
		return "ExclusiveLimitAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_Number:
		return "ExclusiveLimitAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TransitionTime:
		return "ExclusiveLimitAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_TrueState:
		return "ExclusiveLimitAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_AckedState_FalseState:
		return "ExclusiveLimitAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState:
		return "ExclusiveLimitAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Id:
		return "ExclusiveLimitAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Name:
		return "ExclusiveLimitAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_Number:
		return "ExclusiveLimitAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TransitionTime:
		return "ExclusiveLimitAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_TrueState:
		return "ExclusiveLimitAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ConfirmedState_FalseState:
		return "ExclusiveLimitAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Acknowledge_InputArguments:
		return "ExclusiveLimitAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_Confirm_InputArguments:
		return "ExclusiveLimitAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState:
		return "ExclusiveLimitAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Id:
		return "ExclusiveLimitAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Name:
		return "ExclusiveLimitAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_Number:
		return "ExclusiveLimitAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TransitionTime:
		return "ExclusiveLimitAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_TrueState:
		return "ExclusiveLimitAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ActiveState_FalseState:
		return "ExclusiveLimitAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState:
		return "ExclusiveLimitAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Id:
		return "ExclusiveLimitAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Name:
		return "ExclusiveLimitAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_Number:
		return "ExclusiveLimitAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TransitionTime:
		return "ExclusiveLimitAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime:
		return "ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_TrueState:
		return "ExclusiveLimitAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedState_FalseState:
		return "ExclusiveLimitAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState:
		return "ExclusiveLimitAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id:
		return "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name:
		return "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number:
		return "ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime:
		return "ExclusiveLimitAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_SuppressedOrShelved:
		return "ExclusiveLimitAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_MaxTimeShelved:
		return "ExclusiveLimitAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState:
		return "ExclusiveLimitAlarmType_LimitState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Id:
		return "ExclusiveLimitAlarmType_LimitState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Name:
		return "ExclusiveLimitAlarmType_LimitState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_Number:
		return "ExclusiveLimitAlarmType_LimitState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName:
		return "ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Id:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Name:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_Number:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime:
		return "ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighHighLimit:
		return "ExclusiveLimitAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_HighLimit:
		return "ExclusiveLimitAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLimit:
		return "ExclusiveLimitAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLimitAlarmType_LowLowLimit:
		return "ExclusiveLimitAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventId:
		return "ExclusiveLevelAlarmType_EventId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EventType:
		return "ExclusiveLevelAlarmType_EventType"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceNode:
		return "ExclusiveLevelAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SourceName:
		return "ExclusiveLevelAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Time:
		return "ExclusiveLevelAlarmType_Time"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ReceiveTime:
		return "ExclusiveLevelAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LocalTime:
		return "ExclusiveLevelAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Message:
		return "ExclusiveLevelAlarmType_Message"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Severity:
		return "ExclusiveLevelAlarmType_Severity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionName:
		return "ExclusiveLevelAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_BranchId:
		return "ExclusiveLevelAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Retain:
		return "ExclusiveLevelAlarmType_Retain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState:
		return "ExclusiveLevelAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Id:
		return "ExclusiveLevelAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Name:
		return "ExclusiveLevelAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_Number:
		return "ExclusiveLevelAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TransitionTime:
		return "ExclusiveLevelAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_TrueState:
		return "ExclusiveLevelAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_EnabledState_FalseState:
		return "ExclusiveLevelAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality:
		return "ExclusiveLevelAlarmType_Quality"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Quality_SourceTimestamp:
		return "ExclusiveLevelAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity:
		return "ExclusiveLevelAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp:
		return "ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment:
		return "ExclusiveLevelAlarmType_Comment"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Comment_SourceTimestamp:
		return "ExclusiveLevelAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ClientUserId:
		return "ExclusiveLevelAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AddComment_InputArguments:
		return "ExclusiveLevelAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments:
		return "ExclusiveLevelAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState:
		return "ExclusiveLevelAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Id:
		return "ExclusiveLevelAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Name:
		return "ExclusiveLevelAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_Number:
		return "ExclusiveLevelAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TransitionTime:
		return "ExclusiveLevelAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_TrueState:
		return "ExclusiveLevelAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_AckedState_FalseState:
		return "ExclusiveLevelAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState:
		return "ExclusiveLevelAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Id:
		return "ExclusiveLevelAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Name:
		return "ExclusiveLevelAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_Number:
		return "ExclusiveLevelAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TransitionTime:
		return "ExclusiveLevelAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_TrueState:
		return "ExclusiveLevelAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ConfirmedState_FalseState:
		return "ExclusiveLevelAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Acknowledge_InputArguments:
		return "ExclusiveLevelAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_Confirm_InputArguments:
		return "ExclusiveLevelAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState:
		return "ExclusiveLevelAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Id:
		return "ExclusiveLevelAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Name:
		return "ExclusiveLevelAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_Number:
		return "ExclusiveLevelAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TransitionTime:
		return "ExclusiveLevelAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_TrueState:
		return "ExclusiveLevelAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ActiveState_FalseState:
		return "ExclusiveLevelAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState:
		return "ExclusiveLevelAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Id:
		return "ExclusiveLevelAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Name:
		return "ExclusiveLevelAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_Number:
		return "ExclusiveLevelAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TransitionTime:
		return "ExclusiveLevelAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime:
		return "ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_TrueState:
		return "ExclusiveLevelAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedState_FalseState:
		return "ExclusiveLevelAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState:
		return "ExclusiveLevelAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id:
		return "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name:
		return "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number:
		return "ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime:
		return "ExclusiveLevelAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_SuppressedOrShelved:
		return "ExclusiveLevelAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_MaxTimeShelved:
		return "ExclusiveLevelAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState:
		return "ExclusiveLevelAlarmType_LimitState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Id:
		return "ExclusiveLevelAlarmType_LimitState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Name:
		return "ExclusiveLevelAlarmType_LimitState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_Number:
		return "ExclusiveLevelAlarmType_LimitState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName:
		return "ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Id:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Name:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_Number:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime:
		return "ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighHighLimit:
		return "ExclusiveLevelAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_HighLimit:
		return "ExclusiveLevelAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLimit:
		return "ExclusiveLevelAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveLevelAlarmType_LowLowLimit:
		return "ExclusiveLevelAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventId:
		return "ExclusiveRateOfChangeAlarmType_EventId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EventType:
		return "ExclusiveRateOfChangeAlarmType_EventType"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceNode:
		return "ExclusiveRateOfChangeAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SourceName:
		return "ExclusiveRateOfChangeAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Time:
		return "ExclusiveRateOfChangeAlarmType_Time"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ReceiveTime:
		return "ExclusiveRateOfChangeAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LocalTime:
		return "ExclusiveRateOfChangeAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Message:
		return "ExclusiveRateOfChangeAlarmType_Message"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Severity:
		return "ExclusiveRateOfChangeAlarmType_Severity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionName:
		return "ExclusiveRateOfChangeAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_BranchId:
		return "ExclusiveRateOfChangeAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Retain:
		return "ExclusiveRateOfChangeAlarmType_Retain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState:
		return "ExclusiveRateOfChangeAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Id:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Name:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_Number:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_EnabledState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality:
		return "ExclusiveRateOfChangeAlarmType_Quality"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp:
		return "ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity:
		return "ExclusiveRateOfChangeAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp:
		return "ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment:
		return "ExclusiveRateOfChangeAlarmType_Comment"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp:
		return "ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ClientUserId:
		return "ExclusiveRateOfChangeAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState:
		return "ExclusiveRateOfChangeAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Id:
		return "ExclusiveRateOfChangeAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Name:
		return "ExclusiveRateOfChangeAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_Number:
		return "ExclusiveRateOfChangeAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_AckedState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Name:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_Number:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState:
		return "ExclusiveRateOfChangeAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Id:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Name:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_Number:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ActiveState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Id:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Name:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_Number:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState:
		return "ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_SuppressedOrShelved:
		return "ExclusiveRateOfChangeAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_MaxTimeShelved:
		return "ExclusiveRateOfChangeAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState:
		return "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id:
		return "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name:
		return "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number:
		return "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName:
		return "ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime:
		return "ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighHighLimit:
		return "ExclusiveRateOfChangeAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_HighLimit:
		return "ExclusiveRateOfChangeAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLimit:
		return "ExclusiveRateOfChangeAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveRateOfChangeAlarmType_LowLowLimit:
		return "ExclusiveRateOfChangeAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventId:
		return "ExclusiveDeviationAlarmType_EventId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EventType:
		return "ExclusiveDeviationAlarmType_EventType"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceNode:
		return "ExclusiveDeviationAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SourceName:
		return "ExclusiveDeviationAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Time:
		return "ExclusiveDeviationAlarmType_Time"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ReceiveTime:
		return "ExclusiveDeviationAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LocalTime:
		return "ExclusiveDeviationAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Message:
		return "ExclusiveDeviationAlarmType_Message"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Severity:
		return "ExclusiveDeviationAlarmType_Severity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionName:
		return "ExclusiveDeviationAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_BranchId:
		return "ExclusiveDeviationAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Retain:
		return "ExclusiveDeviationAlarmType_Retain"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState:
		return "ExclusiveDeviationAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Id:
		return "ExclusiveDeviationAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Name:
		return "ExclusiveDeviationAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_Number:
		return "ExclusiveDeviationAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TransitionTime:
		return "ExclusiveDeviationAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_TrueState:
		return "ExclusiveDeviationAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_EnabledState_FalseState:
		return "ExclusiveDeviationAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality:
		return "ExclusiveDeviationAlarmType_Quality"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Quality_SourceTimestamp:
		return "ExclusiveDeviationAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity:
		return "ExclusiveDeviationAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp:
		return "ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment:
		return "ExclusiveDeviationAlarmType_Comment"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Comment_SourceTimestamp:
		return "ExclusiveDeviationAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ClientUserId:
		return "ExclusiveDeviationAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AddComment_InputArguments:
		return "ExclusiveDeviationAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments:
		return "ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState:
		return "ExclusiveDeviationAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Id:
		return "ExclusiveDeviationAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Name:
		return "ExclusiveDeviationAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_Number:
		return "ExclusiveDeviationAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TransitionTime:
		return "ExclusiveDeviationAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_TrueState:
		return "ExclusiveDeviationAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_AckedState_FalseState:
		return "ExclusiveDeviationAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState:
		return "ExclusiveDeviationAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Id:
		return "ExclusiveDeviationAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Name:
		return "ExclusiveDeviationAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_Number:
		return "ExclusiveDeviationAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime:
		return "ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_TrueState:
		return "ExclusiveDeviationAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ConfirmedState_FalseState:
		return "ExclusiveDeviationAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Acknowledge_InputArguments:
		return "ExclusiveDeviationAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_Confirm_InputArguments:
		return "ExclusiveDeviationAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState:
		return "ExclusiveDeviationAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Id:
		return "ExclusiveDeviationAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Name:
		return "ExclusiveDeviationAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_Number:
		return "ExclusiveDeviationAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TransitionTime:
		return "ExclusiveDeviationAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_TrueState:
		return "ExclusiveDeviationAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ActiveState_FalseState:
		return "ExclusiveDeviationAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState:
		return "ExclusiveDeviationAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Id:
		return "ExclusiveDeviationAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Name:
		return "ExclusiveDeviationAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_Number:
		return "ExclusiveDeviationAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TransitionTime:
		return "ExclusiveDeviationAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime:
		return "ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_TrueState:
		return "ExclusiveDeviationAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedState_FalseState:
		return "ExclusiveDeviationAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState:
		return "ExclusiveDeviationAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id:
		return "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name:
		return "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number:
		return "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime:
		return "ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SuppressedOrShelved:
		return "ExclusiveDeviationAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_MaxTimeShelved:
		return "ExclusiveDeviationAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState:
		return "ExclusiveDeviationAlarmType_LimitState_CurrentState"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id:
		return "ExclusiveDeviationAlarmType_LimitState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Name:
		return "ExclusiveDeviationAlarmType_LimitState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_Number:
		return "ExclusiveDeviationAlarmType_LimitState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName:
		return "ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Name:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_Number:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime:
		return "ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighHighLimit:
		return "ExclusiveDeviationAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_HighLimit:
		return "ExclusiveDeviationAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLimit:
		return "ExclusiveDeviationAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_LowLowLimit:
		return "ExclusiveDeviationAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableExclusive_ExclusiveDeviationAlarmType_SetpointNode:
		return "ExclusiveDeviationAlarmType_SetpointNode"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableExclusive) String() string {
	return e.PLC4XEnumName()
}
