/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableCertificate is an enum
type OpcuaNodeIdServicesVariableCertificate int32

type IOpcuaNodeIdServicesVariableCertificate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventId                                                                                       OpcuaNodeIdServicesVariableCertificate = 12621
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventType                                                                                     OpcuaNodeIdServicesVariableCertificate = 12622
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceNode                                                                                    OpcuaNodeIdServicesVariableCertificate = 12623
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceName                                                                                    OpcuaNodeIdServicesVariableCertificate = 12624
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Time                                                                                          OpcuaNodeIdServicesVariableCertificate = 12625
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ReceiveTime                                                                                   OpcuaNodeIdServicesVariableCertificate = 12626
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_LocalTime                                                                                     OpcuaNodeIdServicesVariableCertificate = 12627
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Message                                                                                       OpcuaNodeIdServicesVariableCertificate = 12628
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Severity                                                                                      OpcuaNodeIdServicesVariableCertificate = 12629
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ActionTimeStamp                                                                               OpcuaNodeIdServicesVariableCertificate = 12630
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Status                                                                                        OpcuaNodeIdServicesVariableCertificate = 12631
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ServerId                                                                                      OpcuaNodeIdServicesVariableCertificate = 12632
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientAuditEntryId                                                                            OpcuaNodeIdServicesVariableCertificate = 12633
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientUserId                                                                                  OpcuaNodeIdServicesVariableCertificate = 12634
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventId                                                                                         OpcuaNodeIdServicesVariableCertificate = 13226
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventType                                                                                       OpcuaNodeIdServicesVariableCertificate = 13227
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceNode                                                                                      OpcuaNodeIdServicesVariableCertificate = 13228
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceName                                                                                      OpcuaNodeIdServicesVariableCertificate = 13229
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Time                                                                                            OpcuaNodeIdServicesVariableCertificate = 13230
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReceiveTime                                                                                     OpcuaNodeIdServicesVariableCertificate = 13231
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LocalTime                                                                                       OpcuaNodeIdServicesVariableCertificate = 13232
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Message                                                                                         OpcuaNodeIdServicesVariableCertificate = 13233
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Severity                                                                                        OpcuaNodeIdServicesVariableCertificate = 13234
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassId                                                                                OpcuaNodeIdServicesVariableCertificate = 13235
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassName                                                                              OpcuaNodeIdServicesVariableCertificate = 13236
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionName                                                                                   OpcuaNodeIdServicesVariableCertificate = 13237
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_BranchId                                                                                        OpcuaNodeIdServicesVariableCertificate = 13238
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Retain                                                                                          OpcuaNodeIdServicesVariableCertificate = 13239
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState                                                                                    OpcuaNodeIdServicesVariableCertificate = 13240
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Id                                                                                 OpcuaNodeIdServicesVariableCertificate = 13241
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Name                                                                               OpcuaNodeIdServicesVariableCertificate = 13242
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Number                                                                             OpcuaNodeIdServicesVariableCertificate = 13243
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName                                                               OpcuaNodeIdServicesVariableCertificate = 13244
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TransitionTime                                                                     OpcuaNodeIdServicesVariableCertificate = 13245
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 13246
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TrueState                                                                          OpcuaNodeIdServicesVariableCertificate = 13247
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_FalseState                                                                         OpcuaNodeIdServicesVariableCertificate = 13248
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality                                                                                         OpcuaNodeIdServicesVariableCertificate = 13249
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality_SourceTimestamp                                                                         OpcuaNodeIdServicesVariableCertificate = 13250
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity                                                                                    OpcuaNodeIdServicesVariableCertificate = 13251
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity_SourceTimestamp                                                                    OpcuaNodeIdServicesVariableCertificate = 13252
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment                                                                                         OpcuaNodeIdServicesVariableCertificate = 13253
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment_SourceTimestamp                                                                         OpcuaNodeIdServicesVariableCertificate = 13254
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ClientUserId                                                                                    OpcuaNodeIdServicesVariableCertificate = 13255
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AddComment_InputArguments                                                                       OpcuaNodeIdServicesVariableCertificate = 13259
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh_InputArguments                                                                 OpcuaNodeIdServicesVariableCertificate = 13261
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh2_InputArguments                                                                OpcuaNodeIdServicesVariableCertificate = 13263
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState                                                                                      OpcuaNodeIdServicesVariableCertificate = 13264
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Id                                                                                   OpcuaNodeIdServicesVariableCertificate = 13265
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Name                                                                                 OpcuaNodeIdServicesVariableCertificate = 13266
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Number                                                                               OpcuaNodeIdServicesVariableCertificate = 13267
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveDisplayName                                                                 OpcuaNodeIdServicesVariableCertificate = 13268
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TransitionTime                                                                       OpcuaNodeIdServicesVariableCertificate = 13269
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime                                                              OpcuaNodeIdServicesVariableCertificate = 13270
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TrueState                                                                            OpcuaNodeIdServicesVariableCertificate = 13271
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_FalseState                                                                           OpcuaNodeIdServicesVariableCertificate = 13272
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState                                                                                  OpcuaNodeIdServicesVariableCertificate = 13273
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Id                                                                               OpcuaNodeIdServicesVariableCertificate = 13274
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Name                                                                             OpcuaNodeIdServicesVariableCertificate = 13275
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Number                                                                           OpcuaNodeIdServicesVariableCertificate = 13276
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName                                                             OpcuaNodeIdServicesVariableCertificate = 13277
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TransitionTime                                                                   OpcuaNodeIdServicesVariableCertificate = 13278
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime                                                          OpcuaNodeIdServicesVariableCertificate = 13279
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TrueState                                                                        OpcuaNodeIdServicesVariableCertificate = 13280
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_FalseState                                                                       OpcuaNodeIdServicesVariableCertificate = 13281
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Acknowledge_InputArguments                                                                      OpcuaNodeIdServicesVariableCertificate = 13283
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Confirm_InputArguments                                                                          OpcuaNodeIdServicesVariableCertificate = 13285
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState                                                                                     OpcuaNodeIdServicesVariableCertificate = 13286
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Id                                                                                  OpcuaNodeIdServicesVariableCertificate = 13287
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Name                                                                                OpcuaNodeIdServicesVariableCertificate = 13288
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Number                                                                              OpcuaNodeIdServicesVariableCertificate = 13289
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName                                                                OpcuaNodeIdServicesVariableCertificate = 13290
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TransitionTime                                                                      OpcuaNodeIdServicesVariableCertificate = 13291
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime                                                             OpcuaNodeIdServicesVariableCertificate = 13292
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TrueState                                                                           OpcuaNodeIdServicesVariableCertificate = 13293
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_FalseState                                                                          OpcuaNodeIdServicesVariableCertificate = 13294
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_InputNode                                                                                       OpcuaNodeIdServicesVariableCertificate = 13295
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState                                                                                 OpcuaNodeIdServicesVariableCertificate = 13296
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Id                                                                              OpcuaNodeIdServicesVariableCertificate = 13297
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Name                                                                            OpcuaNodeIdServicesVariableCertificate = 13298
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Number                                                                          OpcuaNodeIdServicesVariableCertificate = 13299
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName                                                            OpcuaNodeIdServicesVariableCertificate = 13300
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TransitionTime                                                                  OpcuaNodeIdServicesVariableCertificate = 13301
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime                                                         OpcuaNodeIdServicesVariableCertificate = 13302
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TrueState                                                                       OpcuaNodeIdServicesVariableCertificate = 13303
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_FalseState                                                                      OpcuaNodeIdServicesVariableCertificate = 13304
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState                                                                      OpcuaNodeIdServicesVariableCertificate = 13306
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Id                                                                   OpcuaNodeIdServicesVariableCertificate = 13307
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Name                                                                 OpcuaNodeIdServicesVariableCertificate = 13308
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Number                                                               OpcuaNodeIdServicesVariableCertificate = 13309
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                                 OpcuaNodeIdServicesVariableCertificate = 13310
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition                                                                    OpcuaNodeIdServicesVariableCertificate = 13311
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Id                                                                 OpcuaNodeIdServicesVariableCertificate = 13312
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Name                                                               OpcuaNodeIdServicesVariableCertificate = 13313
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Number                                                             OpcuaNodeIdServicesVariableCertificate = 13314
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime                                                     OpcuaNodeIdServicesVariableCertificate = 13315
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                            OpcuaNodeIdServicesVariableCertificate = 13316
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_UnshelveTime                                                                      OpcuaNodeIdServicesVariableCertificate = 13317
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments                                                        OpcuaNodeIdServicesVariableCertificate = 13321
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedOrShelved                                                                             OpcuaNodeIdServicesVariableCertificate = 13322
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_MaxTimeShelved                                                                                  OpcuaNodeIdServicesVariableCertificate = 13323
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_NormalState                                                                                     OpcuaNodeIdServicesVariableCertificate = 13324
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationDate                                                                                  OpcuaNodeIdServicesVariableCertificate = 13325
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_CertificateType                                                                                 OpcuaNodeIdServicesVariableCertificate = 13326
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Certificate                                                                                     OpcuaNodeIdServicesVariableCertificate = 13327
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Size                                                                                            OpcuaNodeIdServicesVariableCertificate = 13600
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Writable                                                                                        OpcuaNodeIdServicesVariableCertificate = 13601
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UserWritable                                                                                    OpcuaNodeIdServicesVariableCertificate = 13602
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenCount                                                                                       OpcuaNodeIdServicesVariableCertificate = 13603
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MimeType                                                                                        OpcuaNodeIdServicesVariableCertificate = 13604
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_InputArguments                                                                             OpcuaNodeIdServicesVariableCertificate = 13606
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_OutputArguments                                                                            OpcuaNodeIdServicesVariableCertificate = 13607
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Close_InputArguments                                                                            OpcuaNodeIdServicesVariableCertificate = 13609
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_InputArguments                                                                             OpcuaNodeIdServicesVariableCertificate = 13611
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_OutputArguments                                                                            OpcuaNodeIdServicesVariableCertificate = 13612
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Write_InputArguments                                                                            OpcuaNodeIdServicesVariableCertificate = 13614
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_InputArguments                                                                      OpcuaNodeIdServicesVariableCertificate = 13616
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_OutputArguments                                                                     OpcuaNodeIdServicesVariableCertificate = 13617
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_SetPosition_InputArguments                                                                      OpcuaNodeIdServicesVariableCertificate = 13619
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastUpdateTime                                                                                  OpcuaNodeIdServicesVariableCertificate = 13620
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_InputArguments                                                                    OpcuaNodeIdServicesVariableCertificate = 13622
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_OutputArguments                                                                   OpcuaNodeIdServicesVariableCertificate = 13623
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_InputArguments                                                                   OpcuaNodeIdServicesVariableCertificate = 13625
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments                                                                  OpcuaNodeIdServicesVariableCertificate = 13626
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_AddCertificate_InputArguments                                                                   OpcuaNodeIdServicesVariableCertificate = 13628
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_RemoveCertificate_InputArguments                                                                OpcuaNodeIdServicesVariableCertificate = 13630
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateTypes                                                                                          OpcuaNodeIdServicesVariableCertificate = 13631
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateGroup                                                                              OpcuaNodeIdServicesVariableCertificate = 13735
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateType                                                                               OpcuaNodeIdServicesVariableCertificate = 13736
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size                                                              OpcuaNodeIdServicesVariableCertificate = 13816
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable                                                          OpcuaNodeIdServicesVariableCertificate = 13817
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable                                                      OpcuaNodeIdServicesVariableCertificate = 13818
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount                                                         OpcuaNodeIdServicesVariableCertificate = 13819
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType                                                          OpcuaNodeIdServicesVariableCertificate = 13820
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments                                               OpcuaNodeIdServicesVariableCertificate = 13822
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13823
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13825
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments                                               OpcuaNodeIdServicesVariableCertificate = 13827
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13828
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13830
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                                        OpcuaNodeIdServicesVariableCertificate = 13832
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                                       OpcuaNodeIdServicesVariableCertificate = 13833
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                                        OpcuaNodeIdServicesVariableCertificate = 13835
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime                                                    OpcuaNodeIdServicesVariableCertificate = 13836
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                                      OpcuaNodeIdServicesVariableCertificate = 13838
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                                     OpcuaNodeIdServicesVariableCertificate = 13839
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 13841
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                                    OpcuaNodeIdServicesVariableCertificate = 13842
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 13844
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                                  OpcuaNodeIdServicesVariableCertificate = 13846
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes                                                            OpcuaNodeIdServicesVariableCertificate = 13847
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size                                                                    OpcuaNodeIdServicesVariableCertificate = 13850
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable                                                                OpcuaNodeIdServicesVariableCertificate = 13851
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable                                                            OpcuaNodeIdServicesVariableCertificate = 13852
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount                                                               OpcuaNodeIdServicesVariableCertificate = 13853
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType                                                                OpcuaNodeIdServicesVariableCertificate = 13854
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments                                                     OpcuaNodeIdServicesVariableCertificate = 13856
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 13857
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 13859
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments                                                     OpcuaNodeIdServicesVariableCertificate = 13861
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 13862
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 13864
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13866
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                             OpcuaNodeIdServicesVariableCertificate = 13867
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 13869
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime                                                          OpcuaNodeIdServicesVariableCertificate = 13870
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                            OpcuaNodeIdServicesVariableCertificate = 13872
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                           OpcuaNodeIdServicesVariableCertificate = 13873
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                           OpcuaNodeIdServicesVariableCertificate = 13875
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13876
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                           OpcuaNodeIdServicesVariableCertificate = 13878
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                                        OpcuaNodeIdServicesVariableCertificate = 13880
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes                                                                  OpcuaNodeIdServicesVariableCertificate = 13881
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size                                                                OpcuaNodeIdServicesVariableCertificate = 13884
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable                                                            OpcuaNodeIdServicesVariableCertificate = 13885
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable                                                        OpcuaNodeIdServicesVariableCertificate = 13886
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount                                                           OpcuaNodeIdServicesVariableCertificate = 13887
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType                                                            OpcuaNodeIdServicesVariableCertificate = 13888
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments                                                 OpcuaNodeIdServicesVariableCertificate = 13890
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                                OpcuaNodeIdServicesVariableCertificate = 13891
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments                                                OpcuaNodeIdServicesVariableCertificate = 13893
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments                                                 OpcuaNodeIdServicesVariableCertificate = 13895
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                                OpcuaNodeIdServicesVariableCertificate = 13896
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments                                                OpcuaNodeIdServicesVariableCertificate = 13898
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13900
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                         OpcuaNodeIdServicesVariableCertificate = 13901
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13903
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime                                                      OpcuaNodeIdServicesVariableCertificate = 13904
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                                        OpcuaNodeIdServicesVariableCertificate = 13906
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                                       OpcuaNodeIdServicesVariableCertificate = 13907
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                                       OpcuaNodeIdServicesVariableCertificate = 13909
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                                      OpcuaNodeIdServicesVariableCertificate = 13910
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                                       OpcuaNodeIdServicesVariableCertificate = 13912
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                                    OpcuaNodeIdServicesVariableCertificate = 13914
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes                                                              OpcuaNodeIdServicesVariableCertificate = 13915
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size                                                          OpcuaNodeIdServicesVariableCertificate = 13918
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable                                                      OpcuaNodeIdServicesVariableCertificate = 13919
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable                                                  OpcuaNodeIdServicesVariableCertificate = 13920
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount                                                     OpcuaNodeIdServicesVariableCertificate = 13921
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType                                                      OpcuaNodeIdServicesVariableCertificate = 13922
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments                                           OpcuaNodeIdServicesVariableCertificate = 13924
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13925
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13927
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments                                           OpcuaNodeIdServicesVariableCertificate = 13929
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13930
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 13932
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments                                    OpcuaNodeIdServicesVariableCertificate = 13934
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments                                   OpcuaNodeIdServicesVariableCertificate = 13935
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments                                    OpcuaNodeIdServicesVariableCertificate = 13937
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime                                                OpcuaNodeIdServicesVariableCertificate = 13938
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments                                  OpcuaNodeIdServicesVariableCertificate = 13940
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments                                 OpcuaNodeIdServicesVariableCertificate = 13941
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 13943
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments                                OpcuaNodeIdServicesVariableCertificate = 13944
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 13946
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments                              OpcuaNodeIdServicesVariableCertificate = 13948
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes                                                        OpcuaNodeIdServicesVariableCertificate = 13949
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationLimit                                                                                 OpcuaNodeIdServicesVariableCertificate = 14900
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassId                                                                             OpcuaNodeIdServicesVariableCertificate = 17044
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassName                                                                           OpcuaNodeIdServicesVariableCertificate = 17045
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState                                                                               OpcuaNodeIdServicesVariableCertificate = 17046
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Id                                                                            OpcuaNodeIdServicesVariableCertificate = 17047
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Name                                                                          OpcuaNodeIdServicesVariableCertificate = 17048
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Number                                                                        OpcuaNodeIdServicesVariableCertificate = 17049
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName                                                          OpcuaNodeIdServicesVariableCertificate = 17050
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TransitionTime                                                                OpcuaNodeIdServicesVariableCertificate = 17051
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime                                                       OpcuaNodeIdServicesVariableCertificate = 17052
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TrueState                                                                     OpcuaNodeIdServicesVariableCertificate = 17053
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_FalseState                                                                    OpcuaNodeIdServicesVariableCertificate = 17054
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState                                                                                    OpcuaNodeIdServicesVariableCertificate = 17055
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Id                                                                                 OpcuaNodeIdServicesVariableCertificate = 17056
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Name                                                                               OpcuaNodeIdServicesVariableCertificate = 17057
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Number                                                                             OpcuaNodeIdServicesVariableCertificate = 17058
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName                                                               OpcuaNodeIdServicesVariableCertificate = 17059
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TransitionTime                                                                     OpcuaNodeIdServicesVariableCertificate = 17060
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 17061
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TrueState                                                                          OpcuaNodeIdServicesVariableCertificate = 17062
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_FalseState                                                                         OpcuaNodeIdServicesVariableCertificate = 17063
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleEnabled                                                                                  OpcuaNodeIdServicesVariableCertificate = 17064
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound                                                                                    OpcuaNodeIdServicesVariableCertificate = 17065
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OnDelay                                                                                         OpcuaNodeIdServicesVariableCertificate = 17070
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OffDelay                                                                                        OpcuaNodeIdServicesVariableCertificate = 17071
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_FirstInGroupFlag                                                                                OpcuaNodeIdServicesVariableCertificate = 17072
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmTime                                                                                     OpcuaNodeIdServicesVariableCertificate = 17075
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmRepeatCount                                                                              OpcuaNodeIdServicesVariableCertificate = 17076
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableStates                                                                   OpcuaNodeIdServicesVariableCertificate = 17700
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableTransitions                                                              OpcuaNodeIdServicesVariableCertificate = 17701
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_ListId                                                                             OpcuaNodeIdServicesVariableCertificate = 17970
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_AgencyId                                                                           OpcuaNodeIdServicesVariableCertificate = 17971
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_VersionId                                                                          OpcuaNodeIdServicesVariableCertificate = 17972
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState                                                                                    OpcuaNodeIdServicesVariableCertificate = 18645
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Id                                                                                 OpcuaNodeIdServicesVariableCertificate = 18646
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Name                                                                               OpcuaNodeIdServicesVariableCertificate = 18647
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Number                                                                             OpcuaNodeIdServicesVariableCertificate = 18648
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName                                                               OpcuaNodeIdServicesVariableCertificate = 18649
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TransitionTime                                                                     OpcuaNodeIdServicesVariableCertificate = 18650
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 18651
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TrueState                                                                          OpcuaNodeIdServicesVariableCertificate = 18652
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_FalseState                                                                         OpcuaNodeIdServicesVariableCertificate = 18653
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UpdateFrequency                                                                                 OpcuaNodeIdServicesVariableCertificate = 19449
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventId                                                                                OpcuaNodeIdServicesVariableCertificate = 19451
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventType                                                                              OpcuaNodeIdServicesVariableCertificate = 19452
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceNode                                                                             OpcuaNodeIdServicesVariableCertificate = 19453
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceName                                                                             OpcuaNodeIdServicesVariableCertificate = 19454
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Time                                                                                   OpcuaNodeIdServicesVariableCertificate = 19455
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReceiveTime                                                                            OpcuaNodeIdServicesVariableCertificate = 19456
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LocalTime                                                                              OpcuaNodeIdServicesVariableCertificate = 19457
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Message                                                                                OpcuaNodeIdServicesVariableCertificate = 19458
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Severity                                                                               OpcuaNodeIdServicesVariableCertificate = 19459
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassId                                                                       OpcuaNodeIdServicesVariableCertificate = 19460
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassName                                                                     OpcuaNodeIdServicesVariableCertificate = 19461
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassId                                                                    OpcuaNodeIdServicesVariableCertificate = 19462
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassName                                                                  OpcuaNodeIdServicesVariableCertificate = 19463
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionName                                                                          OpcuaNodeIdServicesVariableCertificate = 19464
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_BranchId                                                                               OpcuaNodeIdServicesVariableCertificate = 19465
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Retain                                                                                 OpcuaNodeIdServicesVariableCertificate = 19466
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState                                                                           OpcuaNodeIdServicesVariableCertificate = 19467
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 19468
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 19469
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 19470
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 19471
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 19472
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 19473
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 19474
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 19475
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality                                                                                OpcuaNodeIdServicesVariableCertificate = 19476
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality_SourceTimestamp                                                                OpcuaNodeIdServicesVariableCertificate = 19477
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity                                                                           OpcuaNodeIdServicesVariableCertificate = 19478
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp                                                           OpcuaNodeIdServicesVariableCertificate = 19479
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment                                                                                OpcuaNodeIdServicesVariableCertificate = 19480
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment_SourceTimestamp                                                                OpcuaNodeIdServicesVariableCertificate = 19481
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ClientUserId                                                                           OpcuaNodeIdServicesVariableCertificate = 19482
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AddComment_InputArguments                                                              OpcuaNodeIdServicesVariableCertificate = 19486
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState                                                                             OpcuaNodeIdServicesVariableCertificate = 19487
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Id                                                                          OpcuaNodeIdServicesVariableCertificate = 19488
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Name                                                                        OpcuaNodeIdServicesVariableCertificate = 19489
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Number                                                                      OpcuaNodeIdServicesVariableCertificate = 19490
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName                                                        OpcuaNodeIdServicesVariableCertificate = 19491
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TransitionTime                                                              OpcuaNodeIdServicesVariableCertificate = 19492
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime                                                     OpcuaNodeIdServicesVariableCertificate = 19493
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TrueState                                                                   OpcuaNodeIdServicesVariableCertificate = 19494
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_FalseState                                                                  OpcuaNodeIdServicesVariableCertificate = 19495
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState                                                                         OpcuaNodeIdServicesVariableCertificate = 19496
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Id                                                                      OpcuaNodeIdServicesVariableCertificate = 19497
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Name                                                                    OpcuaNodeIdServicesVariableCertificate = 19498
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Number                                                                  OpcuaNodeIdServicesVariableCertificate = 19499
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName                                                    OpcuaNodeIdServicesVariableCertificate = 19500
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime                                                          OpcuaNodeIdServicesVariableCertificate = 19501
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime                                                 OpcuaNodeIdServicesVariableCertificate = 19502
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TrueState                                                               OpcuaNodeIdServicesVariableCertificate = 19503
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_FalseState                                                              OpcuaNodeIdServicesVariableCertificate = 19504
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Acknowledge_InputArguments                                                             OpcuaNodeIdServicesVariableCertificate = 19506
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Confirm_InputArguments                                                                 OpcuaNodeIdServicesVariableCertificate = 19508
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState                                                                            OpcuaNodeIdServicesVariableCertificate = 19509
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Id                                                                         OpcuaNodeIdServicesVariableCertificate = 19510
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Name                                                                       OpcuaNodeIdServicesVariableCertificate = 19511
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Number                                                                     OpcuaNodeIdServicesVariableCertificate = 19512
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName                                                       OpcuaNodeIdServicesVariableCertificate = 19513
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TransitionTime                                                             OpcuaNodeIdServicesVariableCertificate = 19514
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime                                                    OpcuaNodeIdServicesVariableCertificate = 19515
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TrueState                                                                  OpcuaNodeIdServicesVariableCertificate = 19516
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_FalseState                                                                 OpcuaNodeIdServicesVariableCertificate = 19517
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_InputNode                                                                              OpcuaNodeIdServicesVariableCertificate = 19518
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState                                                                        OpcuaNodeIdServicesVariableCertificate = 19519
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Id                                                                     OpcuaNodeIdServicesVariableCertificate = 19520
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Name                                                                   OpcuaNodeIdServicesVariableCertificate = 19521
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Number                                                                 OpcuaNodeIdServicesVariableCertificate = 19522
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName                                                   OpcuaNodeIdServicesVariableCertificate = 19523
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime                                                         OpcuaNodeIdServicesVariableCertificate = 19524
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime                                                OpcuaNodeIdServicesVariableCertificate = 19525
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TrueState                                                              OpcuaNodeIdServicesVariableCertificate = 19526
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_FalseState                                                             OpcuaNodeIdServicesVariableCertificate = 19527
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState                                                                      OpcuaNodeIdServicesVariableCertificate = 19528
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Id                                                                   OpcuaNodeIdServicesVariableCertificate = 19529
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Name                                                                 OpcuaNodeIdServicesVariableCertificate = 19530
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Number                                                               OpcuaNodeIdServicesVariableCertificate = 19531
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName                                                 OpcuaNodeIdServicesVariableCertificate = 19532
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime                                                       OpcuaNodeIdServicesVariableCertificate = 19533
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                                              OpcuaNodeIdServicesVariableCertificate = 19534
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState                                                            OpcuaNodeIdServicesVariableCertificate = 19535
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState                                                           OpcuaNodeIdServicesVariableCertificate = 19536
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState                                                             OpcuaNodeIdServicesVariableCertificate = 19538
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id                                                          OpcuaNodeIdServicesVariableCertificate = 19539
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name                                                        OpcuaNodeIdServicesVariableCertificate = 19540
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number                                                      OpcuaNodeIdServicesVariableCertificate = 19541
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName                                        OpcuaNodeIdServicesVariableCertificate = 19542
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition                                                           OpcuaNodeIdServicesVariableCertificate = 19543
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id                                                        OpcuaNodeIdServicesVariableCertificate = 19544
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name                                                      OpcuaNodeIdServicesVariableCertificate = 19545
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number                                                    OpcuaNodeIdServicesVariableCertificate = 19546
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime                                            OpcuaNodeIdServicesVariableCertificate = 19547
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime                                   OpcuaNodeIdServicesVariableCertificate = 19548
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates                                                          OpcuaNodeIdServicesVariableCertificate = 19549
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions                                                     OpcuaNodeIdServicesVariableCertificate = 20095
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime                                                             OpcuaNodeIdServicesVariableCertificate = 20096
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments                                               OpcuaNodeIdServicesVariableCertificate = 20098
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedOrShelved                                                                    OpcuaNodeIdServicesVariableCertificate = 20101
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_MaxTimeShelved                                                                         OpcuaNodeIdServicesVariableCertificate = 20102
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleEnabled                                                                         OpcuaNodeIdServicesVariableCertificate = 20103
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound                                                                           OpcuaNodeIdServicesVariableCertificate = 20104
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_ListId                                                                    OpcuaNodeIdServicesVariableCertificate = 20105
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_AgencyId                                                                  OpcuaNodeIdServicesVariableCertificate = 20106
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_VersionId                                                                 OpcuaNodeIdServicesVariableCertificate = 20107
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState                                                                           OpcuaNodeIdServicesVariableCertificate = 20108
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 20109
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 20110
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 20111
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 20112
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 20113
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 20114
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 20115
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 20116
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OnDelay                                                                                OpcuaNodeIdServicesVariableCertificate = 20117
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OffDelay                                                                               OpcuaNodeIdServicesVariableCertificate = 20118
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_FirstInGroupFlag                                                                       OpcuaNodeIdServicesVariableCertificate = 20119
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState                                                                           OpcuaNodeIdServicesVariableCertificate = 20121
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 20122
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 20123
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 20124
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 20125
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 20126
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 20127
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 20128
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 20129
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmTime                                                                            OpcuaNodeIdServicesVariableCertificate = 20130
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmRepeatCount                                                                     OpcuaNodeIdServicesVariableCertificate = 20131
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_NormalState                                                                            OpcuaNodeIdServicesVariableCertificate = 20138
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationDate                                                                         OpcuaNodeIdServicesVariableCertificate = 20139
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationLimit                                                                        OpcuaNodeIdServicesVariableCertificate = 20140
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_CertificateType                                                                        OpcuaNodeIdServicesVariableCertificate = 20141
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Certificate                                                                            OpcuaNodeIdServicesVariableCertificate = 20142
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventId                                                                                OpcuaNodeIdServicesVariableCertificate = 20144
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventType                                                                              OpcuaNodeIdServicesVariableCertificate = 20145
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceNode                                                                             OpcuaNodeIdServicesVariableCertificate = 20146
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceName                                                                             OpcuaNodeIdServicesVariableCertificate = 20147
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Time                                                                                   OpcuaNodeIdServicesVariableCertificate = 20148
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReceiveTime                                                                            OpcuaNodeIdServicesVariableCertificate = 20149
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LocalTime                                                                              OpcuaNodeIdServicesVariableCertificate = 20150
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Message                                                                                OpcuaNodeIdServicesVariableCertificate = 20151
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Severity                                                                               OpcuaNodeIdServicesVariableCertificate = 20152
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassId                                                                       OpcuaNodeIdServicesVariableCertificate = 20153
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassName                                                                     OpcuaNodeIdServicesVariableCertificate = 20154
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassId                                                                    OpcuaNodeIdServicesVariableCertificate = 20155
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassName                                                                  OpcuaNodeIdServicesVariableCertificate = 20156
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionName                                                                          OpcuaNodeIdServicesVariableCertificate = 20157
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_BranchId                                                                               OpcuaNodeIdServicesVariableCertificate = 20158
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Retain                                                                                 OpcuaNodeIdServicesVariableCertificate = 20159
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState                                                                           OpcuaNodeIdServicesVariableCertificate = 20160
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 20161
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 20162
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 20163
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 20164
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 20165
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 20166
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 20167
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 20168
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality                                                                                OpcuaNodeIdServicesVariableCertificate = 20169
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp                                                                OpcuaNodeIdServicesVariableCertificate = 20170
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity                                                                           OpcuaNodeIdServicesVariableCertificate = 20171
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp                                                           OpcuaNodeIdServicesVariableCertificate = 20172
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment                                                                                OpcuaNodeIdServicesVariableCertificate = 20173
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp                                                                OpcuaNodeIdServicesVariableCertificate = 20174
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ClientUserId                                                                           OpcuaNodeIdServicesVariableCertificate = 20175
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments                                                              OpcuaNodeIdServicesVariableCertificate = 20179
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState                                                                             OpcuaNodeIdServicesVariableCertificate = 20180
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Id                                                                          OpcuaNodeIdServicesVariableCertificate = 20181
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Name                                                                        OpcuaNodeIdServicesVariableCertificate = 20182
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Number                                                                      OpcuaNodeIdServicesVariableCertificate = 20183
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName                                                        OpcuaNodeIdServicesVariableCertificate = 20184
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime                                                              OpcuaNodeIdServicesVariableCertificate = 20185
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime                                                     OpcuaNodeIdServicesVariableCertificate = 20186
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TrueState                                                                   OpcuaNodeIdServicesVariableCertificate = 20187
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_FalseState                                                                  OpcuaNodeIdServicesVariableCertificate = 20188
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState                                                                         OpcuaNodeIdServicesVariableCertificate = 20189
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id                                                                      OpcuaNodeIdServicesVariableCertificate = 20190
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name                                                                    OpcuaNodeIdServicesVariableCertificate = 20191
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number                                                                  OpcuaNodeIdServicesVariableCertificate = 20192
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                                                    OpcuaNodeIdServicesVariableCertificate = 20193
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime                                                          OpcuaNodeIdServicesVariableCertificate = 20194
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                                                 OpcuaNodeIdServicesVariableCertificate = 20195
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState                                                               OpcuaNodeIdServicesVariableCertificate = 20196
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState                                                              OpcuaNodeIdServicesVariableCertificate = 20197
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments                                                             OpcuaNodeIdServicesVariableCertificate = 20199
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments                                                                 OpcuaNodeIdServicesVariableCertificate = 20201
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState                                                                            OpcuaNodeIdServicesVariableCertificate = 20202
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Id                                                                         OpcuaNodeIdServicesVariableCertificate = 20203
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Name                                                                       OpcuaNodeIdServicesVariableCertificate = 20204
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Number                                                                     OpcuaNodeIdServicesVariableCertificate = 20205
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName                                                       OpcuaNodeIdServicesVariableCertificate = 20206
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime                                                             OpcuaNodeIdServicesVariableCertificate = 20207
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                                                    OpcuaNodeIdServicesVariableCertificate = 20208
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState                                                                  OpcuaNodeIdServicesVariableCertificate = 20209
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState                                                                 OpcuaNodeIdServicesVariableCertificate = 20210
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_InputNode                                                                              OpcuaNodeIdServicesVariableCertificate = 20211
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState                                                                        OpcuaNodeIdServicesVariableCertificate = 20212
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Id                                                                     OpcuaNodeIdServicesVariableCertificate = 20213
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Name                                                                   OpcuaNodeIdServicesVariableCertificate = 20214
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Number                                                                 OpcuaNodeIdServicesVariableCertificate = 20215
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                                                   OpcuaNodeIdServicesVariableCertificate = 20216
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime                                                         OpcuaNodeIdServicesVariableCertificate = 20217
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                                                OpcuaNodeIdServicesVariableCertificate = 20218
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState                                                              OpcuaNodeIdServicesVariableCertificate = 20219
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState                                                             OpcuaNodeIdServicesVariableCertificate = 20220
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState                                                                      OpcuaNodeIdServicesVariableCertificate = 20221
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id                                                                   OpcuaNodeIdServicesVariableCertificate = 20222
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name                                                                 OpcuaNodeIdServicesVariableCertificate = 20223
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number                                                               OpcuaNodeIdServicesVariableCertificate = 20224
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                                                 OpcuaNodeIdServicesVariableCertificate = 20225
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime                                                       OpcuaNodeIdServicesVariableCertificate = 20226
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                                              OpcuaNodeIdServicesVariableCertificate = 20227
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState                                                            OpcuaNodeIdServicesVariableCertificate = 20228
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState                                                           OpcuaNodeIdServicesVariableCertificate = 20229
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState                                                             OpcuaNodeIdServicesVariableCertificate = 20231
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id                                                          OpcuaNodeIdServicesVariableCertificate = 20232
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name                                                        OpcuaNodeIdServicesVariableCertificate = 20233
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number                                                      OpcuaNodeIdServicesVariableCertificate = 20234
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName                                        OpcuaNodeIdServicesVariableCertificate = 20235
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition                                                           OpcuaNodeIdServicesVariableCertificate = 20236
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id                                                        OpcuaNodeIdServicesVariableCertificate = 20237
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name                                                      OpcuaNodeIdServicesVariableCertificate = 20238
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number                                                    OpcuaNodeIdServicesVariableCertificate = 20239
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                                            OpcuaNodeIdServicesVariableCertificate = 20240
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime                                   OpcuaNodeIdServicesVariableCertificate = 20241
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates                                                          OpcuaNodeIdServicesVariableCertificate = 20242
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions                                                     OpcuaNodeIdServicesVariableCertificate = 20243
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime                                                             OpcuaNodeIdServicesVariableCertificate = 20244
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                                               OpcuaNodeIdServicesVariableCertificate = 20246
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved                                                                    OpcuaNodeIdServicesVariableCertificate = 20249
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_MaxTimeShelved                                                                         OpcuaNodeIdServicesVariableCertificate = 20250
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleEnabled                                                                         OpcuaNodeIdServicesVariableCertificate = 20251
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound                                                                           OpcuaNodeIdServicesVariableCertificate = 20252
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId                                                                    OpcuaNodeIdServicesVariableCertificate = 20253
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId                                                                  OpcuaNodeIdServicesVariableCertificate = 20254
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId                                                                 OpcuaNodeIdServicesVariableCertificate = 20255
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState                                                                           OpcuaNodeIdServicesVariableCertificate = 20256
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 20257
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 20258
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 20259
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 20260
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 20261
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 20262
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 20263
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 20264
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OnDelay                                                                                OpcuaNodeIdServicesVariableCertificate = 20265
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OffDelay                                                                               OpcuaNodeIdServicesVariableCertificate = 20266
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag                                                                       OpcuaNodeIdServicesVariableCertificate = 20267
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState                                                                           OpcuaNodeIdServicesVariableCertificate = 20269
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Id                                                                        OpcuaNodeIdServicesVariableCertificate = 20270
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Name                                                                      OpcuaNodeIdServicesVariableCertificate = 20271
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Number                                                                    OpcuaNodeIdServicesVariableCertificate = 20272
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName                                                      OpcuaNodeIdServicesVariableCertificate = 20273
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime                                                            OpcuaNodeIdServicesVariableCertificate = 20274
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                                                   OpcuaNodeIdServicesVariableCertificate = 20275
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState                                                                 OpcuaNodeIdServicesVariableCertificate = 20276
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState                                                                OpcuaNodeIdServicesVariableCertificate = 20277
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmTime                                                                            OpcuaNodeIdServicesVariableCertificate = 20278
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount                                                                     OpcuaNodeIdServicesVariableCertificate = 20279
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_NormalState                                                                            OpcuaNodeIdServicesVariableCertificate = 20286
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_TrustListId                                                                            OpcuaNodeIdServicesVariableCertificate = 20287
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastUpdateTime                                                                         OpcuaNodeIdServicesVariableCertificate = 20288
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_UpdateFrequency                                                                        OpcuaNodeIdServicesVariableCertificate = 20289
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency                                                   OpcuaNodeIdServicesVariableCertificate = 20290
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId                                                  OpcuaNodeIdServicesVariableCertificate = 20292
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType                                                OpcuaNodeIdServicesVariableCertificate = 20293
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode                                               OpcuaNodeIdServicesVariableCertificate = 20294
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName                                               OpcuaNodeIdServicesVariableCertificate = 20295
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time                                                     OpcuaNodeIdServicesVariableCertificate = 20296
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime                                              OpcuaNodeIdServicesVariableCertificate = 20297
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime                                                OpcuaNodeIdServicesVariableCertificate = 20298
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message                                                  OpcuaNodeIdServicesVariableCertificate = 20299
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity                                                 OpcuaNodeIdServicesVariableCertificate = 20300
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId                                         OpcuaNodeIdServicesVariableCertificate = 20301
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName                                       OpcuaNodeIdServicesVariableCertificate = 20302
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId                                      OpcuaNodeIdServicesVariableCertificate = 20303
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName                                    OpcuaNodeIdServicesVariableCertificate = 20304
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName                                            OpcuaNodeIdServicesVariableCertificate = 20305
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId                                                 OpcuaNodeIdServicesVariableCertificate = 20306
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain                                                   OpcuaNodeIdServicesVariableCertificate = 20307
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState                                             OpcuaNodeIdServicesVariableCertificate = 20308
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20309
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20310
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20311
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20312
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20313
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20314
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20315
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20316
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality                                                  OpcuaNodeIdServicesVariableCertificate = 20317
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp                                  OpcuaNodeIdServicesVariableCertificate = 20318
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity                                             OpcuaNodeIdServicesVariableCertificate = 20319
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp                             OpcuaNodeIdServicesVariableCertificate = 20320
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment                                                  OpcuaNodeIdServicesVariableCertificate = 20321
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp                                  OpcuaNodeIdServicesVariableCertificate = 20322
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId                                             OpcuaNodeIdServicesVariableCertificate = 20323
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments                                OpcuaNodeIdServicesVariableCertificate = 20327
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState                                               OpcuaNodeIdServicesVariableCertificate = 20328
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id                                            OpcuaNodeIdServicesVariableCertificate = 20329
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name                                          OpcuaNodeIdServicesVariableCertificate = 20330
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number                                        OpcuaNodeIdServicesVariableCertificate = 20331
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 20332
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 20333
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 20334
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 20335
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 20336
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState                                           OpcuaNodeIdServicesVariableCertificate = 20337
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id                                        OpcuaNodeIdServicesVariableCertificate = 20338
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name                                      OpcuaNodeIdServicesVariableCertificate = 20339
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number                                    OpcuaNodeIdServicesVariableCertificate = 20340
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableCertificate = 20341
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime                            OpcuaNodeIdServicesVariableCertificate = 20342
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableCertificate = 20343
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState                                 OpcuaNodeIdServicesVariableCertificate = 20344
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState                                OpcuaNodeIdServicesVariableCertificate = 20345
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 20347
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments                                   OpcuaNodeIdServicesVariableCertificate = 20349
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState                                              OpcuaNodeIdServicesVariableCertificate = 20350
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id                                           OpcuaNodeIdServicesVariableCertificate = 20351
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name                                         OpcuaNodeIdServicesVariableCertificate = 20352
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number                                       OpcuaNodeIdServicesVariableCertificate = 20353
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableCertificate = 20354
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime                               OpcuaNodeIdServicesVariableCertificate = 20355
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableCertificate = 20356
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState                                    OpcuaNodeIdServicesVariableCertificate = 20357
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState                                   OpcuaNodeIdServicesVariableCertificate = 20358
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode                                                OpcuaNodeIdServicesVariableCertificate = 20359
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState                                          OpcuaNodeIdServicesVariableCertificate = 20360
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id                                       OpcuaNodeIdServicesVariableCertificate = 20361
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name                                     OpcuaNodeIdServicesVariableCertificate = 20362
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number                                   OpcuaNodeIdServicesVariableCertificate = 20363
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 20364
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20365
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 20366
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 20367
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 20368
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState                                        OpcuaNodeIdServicesVariableCertificate = 20369
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id                                     OpcuaNodeIdServicesVariableCertificate = 20370
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name                                   OpcuaNodeIdServicesVariableCertificate = 20371
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number                                 OpcuaNodeIdServicesVariableCertificate = 20372
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableCertificate = 20373
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime                         OpcuaNodeIdServicesVariableCertificate = 20374
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableCertificate = 20375
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState                              OpcuaNodeIdServicesVariableCertificate = 20376
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState                             OpcuaNodeIdServicesVariableCertificate = 20377
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState                               OpcuaNodeIdServicesVariableCertificate = 20379
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id                            OpcuaNodeIdServicesVariableCertificate = 20380
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name                          OpcuaNodeIdServicesVariableCertificate = 20381
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number                        OpcuaNodeIdServicesVariableCertificate = 20382
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName          OpcuaNodeIdServicesVariableCertificate = 20383
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition                             OpcuaNodeIdServicesVariableCertificate = 20384
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id                          OpcuaNodeIdServicesVariableCertificate = 20385
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name                        OpcuaNodeIdServicesVariableCertificate = 20386
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number                      OpcuaNodeIdServicesVariableCertificate = 20387
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime              OpcuaNodeIdServicesVariableCertificate = 20388
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime     OpcuaNodeIdServicesVariableCertificate = 20389
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates                            OpcuaNodeIdServicesVariableCertificate = 20390
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions                       OpcuaNodeIdServicesVariableCertificate = 20391
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime                               OpcuaNodeIdServicesVariableCertificate = 20392
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                 OpcuaNodeIdServicesVariableCertificate = 20394
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved                                      OpcuaNodeIdServicesVariableCertificate = 20397
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved                                           OpcuaNodeIdServicesVariableCertificate = 20398
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled                                           OpcuaNodeIdServicesVariableCertificate = 20399
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound                                             OpcuaNodeIdServicesVariableCertificate = 20400
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId                                      OpcuaNodeIdServicesVariableCertificate = 20401
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId                                    OpcuaNodeIdServicesVariableCertificate = 20402
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId                                   OpcuaNodeIdServicesVariableCertificate = 20403
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState                                             OpcuaNodeIdServicesVariableCertificate = 20404
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20405
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20406
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20407
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20410
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20411
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20412
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20413
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20414
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay                                                  OpcuaNodeIdServicesVariableCertificate = 20415
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay                                                 OpcuaNodeIdServicesVariableCertificate = 20416
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag                                         OpcuaNodeIdServicesVariableCertificate = 20417
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState                                             OpcuaNodeIdServicesVariableCertificate = 20419
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20420
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20421
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20422
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20423
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20424
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20425
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20426
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20427
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime                                              OpcuaNodeIdServicesVariableCertificate = 20428
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount                                       OpcuaNodeIdServicesVariableCertificate = 20429
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState                                              OpcuaNodeIdServicesVariableCertificate = 20436
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate                                           OpcuaNodeIdServicesVariableCertificate = 20437
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit                                          OpcuaNodeIdServicesVariableCertificate = 20438
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType                                          OpcuaNodeIdServicesVariableCertificate = 20439
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate                                              OpcuaNodeIdServicesVariableCertificate = 20440
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId                                                  OpcuaNodeIdServicesVariableCertificate = 20442
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType                                                OpcuaNodeIdServicesVariableCertificate = 20443
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode                                               OpcuaNodeIdServicesVariableCertificate = 20444
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName                                               OpcuaNodeIdServicesVariableCertificate = 20445
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time                                                     OpcuaNodeIdServicesVariableCertificate = 20446
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime                                              OpcuaNodeIdServicesVariableCertificate = 20447
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime                                                OpcuaNodeIdServicesVariableCertificate = 20448
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message                                                  OpcuaNodeIdServicesVariableCertificate = 20449
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity                                                 OpcuaNodeIdServicesVariableCertificate = 20450
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId                                         OpcuaNodeIdServicesVariableCertificate = 20451
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName                                       OpcuaNodeIdServicesVariableCertificate = 20452
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId                                      OpcuaNodeIdServicesVariableCertificate = 20453
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName                                    OpcuaNodeIdServicesVariableCertificate = 20454
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName                                            OpcuaNodeIdServicesVariableCertificate = 20455
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId                                                 OpcuaNodeIdServicesVariableCertificate = 20456
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain                                                   OpcuaNodeIdServicesVariableCertificate = 20457
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState                                             OpcuaNodeIdServicesVariableCertificate = 20458
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20459
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20460
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20461
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20462
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20463
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20464
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20465
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20466
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality                                                  OpcuaNodeIdServicesVariableCertificate = 20467
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp                                  OpcuaNodeIdServicesVariableCertificate = 20468
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity                                             OpcuaNodeIdServicesVariableCertificate = 20469
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                             OpcuaNodeIdServicesVariableCertificate = 20470
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment                                                  OpcuaNodeIdServicesVariableCertificate = 20471
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp                                  OpcuaNodeIdServicesVariableCertificate = 20472
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId                                             OpcuaNodeIdServicesVariableCertificate = 20473
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments                                OpcuaNodeIdServicesVariableCertificate = 20477
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState                                               OpcuaNodeIdServicesVariableCertificate = 20478
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id                                            OpcuaNodeIdServicesVariableCertificate = 20479
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name                                          OpcuaNodeIdServicesVariableCertificate = 20480
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number                                        OpcuaNodeIdServicesVariableCertificate = 20481
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 20482
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 20483
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 20484
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 20485
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 20486
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState                                           OpcuaNodeIdServicesVariableCertificate = 20487
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id                                        OpcuaNodeIdServicesVariableCertificate = 20488
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name                                      OpcuaNodeIdServicesVariableCertificate = 20489
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number                                    OpcuaNodeIdServicesVariableCertificate = 20490
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableCertificate = 20491
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                            OpcuaNodeIdServicesVariableCertificate = 20492
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableCertificate = 20493
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState                                 OpcuaNodeIdServicesVariableCertificate = 20494
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState                                OpcuaNodeIdServicesVariableCertificate = 20495
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 20497
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments                                   OpcuaNodeIdServicesVariableCertificate = 20499
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState                                              OpcuaNodeIdServicesVariableCertificate = 20500
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id                                           OpcuaNodeIdServicesVariableCertificate = 20501
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name                                         OpcuaNodeIdServicesVariableCertificate = 20502
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number                                       OpcuaNodeIdServicesVariableCertificate = 20503
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableCertificate = 20504
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime                               OpcuaNodeIdServicesVariableCertificate = 20505
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableCertificate = 20506
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState                                    OpcuaNodeIdServicesVariableCertificate = 20507
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState                                   OpcuaNodeIdServicesVariableCertificate = 20508
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode                                                OpcuaNodeIdServicesVariableCertificate = 20509
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState                                          OpcuaNodeIdServicesVariableCertificate = 20510
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id                                       OpcuaNodeIdServicesVariableCertificate = 20511
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name                                     OpcuaNodeIdServicesVariableCertificate = 20512
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number                                   OpcuaNodeIdServicesVariableCertificate = 20513
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 20514
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20515
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 20516
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 20517
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 20518
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState                                        OpcuaNodeIdServicesVariableCertificate = 20519
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id                                     OpcuaNodeIdServicesVariableCertificate = 20520
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name                                   OpcuaNodeIdServicesVariableCertificate = 20521
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number                                 OpcuaNodeIdServicesVariableCertificate = 20522
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableCertificate = 20523
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                         OpcuaNodeIdServicesVariableCertificate = 20524
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableCertificate = 20525
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState                              OpcuaNodeIdServicesVariableCertificate = 20526
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState                             OpcuaNodeIdServicesVariableCertificate = 20527
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState                               OpcuaNodeIdServicesVariableCertificate = 20529
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                            OpcuaNodeIdServicesVariableCertificate = 20530
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                          OpcuaNodeIdServicesVariableCertificate = 20531
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                        OpcuaNodeIdServicesVariableCertificate = 20532
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName          OpcuaNodeIdServicesVariableCertificate = 20533
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition                             OpcuaNodeIdServicesVariableCertificate = 20534
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                          OpcuaNodeIdServicesVariableCertificate = 20535
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                        OpcuaNodeIdServicesVariableCertificate = 20536
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                      OpcuaNodeIdServicesVariableCertificate = 20537
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime              OpcuaNodeIdServicesVariableCertificate = 20538
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime     OpcuaNodeIdServicesVariableCertificate = 20539
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates                            OpcuaNodeIdServicesVariableCertificate = 20540
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                       OpcuaNodeIdServicesVariableCertificate = 20541
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                               OpcuaNodeIdServicesVariableCertificate = 20542
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                 OpcuaNodeIdServicesVariableCertificate = 20544
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved                                      OpcuaNodeIdServicesVariableCertificate = 20547
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved                                           OpcuaNodeIdServicesVariableCertificate = 20548
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled                                           OpcuaNodeIdServicesVariableCertificate = 20549
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound                                             OpcuaNodeIdServicesVariableCertificate = 20550
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId                                      OpcuaNodeIdServicesVariableCertificate = 20551
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId                                    OpcuaNodeIdServicesVariableCertificate = 20552
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId                                   OpcuaNodeIdServicesVariableCertificate = 20553
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState                                             OpcuaNodeIdServicesVariableCertificate = 20554
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20555
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20556
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20557
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20558
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20559
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20560
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20561
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20562
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay                                                  OpcuaNodeIdServicesVariableCertificate = 20563
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay                                                 OpcuaNodeIdServicesVariableCertificate = 20564
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag                                         OpcuaNodeIdServicesVariableCertificate = 20565
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState                                             OpcuaNodeIdServicesVariableCertificate = 20567
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20568
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20569
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20570
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20571
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20572
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20573
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20574
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20575
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime                                              OpcuaNodeIdServicesVariableCertificate = 20576
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount                                       OpcuaNodeIdServicesVariableCertificate = 20577
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState                                              OpcuaNodeIdServicesVariableCertificate = 20584
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId                                              OpcuaNodeIdServicesVariableCertificate = 20585
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime                                           OpcuaNodeIdServicesVariableCertificate = 20586
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency                                          OpcuaNodeIdServicesVariableCertificate = 20587
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UpdateFrequency                                                         OpcuaNodeIdServicesVariableCertificate = 20588
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId                                                        OpcuaNodeIdServicesVariableCertificate = 20590
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType                                                      OpcuaNodeIdServicesVariableCertificate = 20591
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode                                                     OpcuaNodeIdServicesVariableCertificate = 20592
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName                                                     OpcuaNodeIdServicesVariableCertificate = 20593
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time                                                           OpcuaNodeIdServicesVariableCertificate = 20594
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime                                                    OpcuaNodeIdServicesVariableCertificate = 20595
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LocalTime                                                      OpcuaNodeIdServicesVariableCertificate = 20596
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message                                                        OpcuaNodeIdServicesVariableCertificate = 20597
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity                                                       OpcuaNodeIdServicesVariableCertificate = 20598
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId                                               OpcuaNodeIdServicesVariableCertificate = 20599
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName                                             OpcuaNodeIdServicesVariableCertificate = 20600
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId                                            OpcuaNodeIdServicesVariableCertificate = 20601
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName                                          OpcuaNodeIdServicesVariableCertificate = 20602
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName                                                  OpcuaNodeIdServicesVariableCertificate = 20603
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId                                                       OpcuaNodeIdServicesVariableCertificate = 20604
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain                                                         OpcuaNodeIdServicesVariableCertificate = 20605
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState                                                   OpcuaNodeIdServicesVariableCertificate = 20606
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20607
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20608
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20609
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20610
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20611
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20612
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20613
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20614
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality                                                        OpcuaNodeIdServicesVariableCertificate = 20615
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp                                        OpcuaNodeIdServicesVariableCertificate = 20616
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity                                                   OpcuaNodeIdServicesVariableCertificate = 20617
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp                                   OpcuaNodeIdServicesVariableCertificate = 20618
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment                                                        OpcuaNodeIdServicesVariableCertificate = 20619
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp                                        OpcuaNodeIdServicesVariableCertificate = 20620
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId                                                   OpcuaNodeIdServicesVariableCertificate = 20621
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments                                      OpcuaNodeIdServicesVariableCertificate = 20625
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState                                                     OpcuaNodeIdServicesVariableCertificate = 20626
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id                                                  OpcuaNodeIdServicesVariableCertificate = 20627
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Name                                                OpcuaNodeIdServicesVariableCertificate = 20628
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Number                                              OpcuaNodeIdServicesVariableCertificate = 20629
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName                                OpcuaNodeIdServicesVariableCertificate = 20630
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime                                      OpcuaNodeIdServicesVariableCertificate = 20631
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime                             OpcuaNodeIdServicesVariableCertificate = 20632
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState                                           OpcuaNodeIdServicesVariableCertificate = 20633
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState                                          OpcuaNodeIdServicesVariableCertificate = 20634
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState                                                 OpcuaNodeIdServicesVariableCertificate = 20635
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id                                              OpcuaNodeIdServicesVariableCertificate = 20636
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name                                            OpcuaNodeIdServicesVariableCertificate = 20637
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number                                          OpcuaNodeIdServicesVariableCertificate = 20638
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableCertificate = 20639
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime                                  OpcuaNodeIdServicesVariableCertificate = 20640
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableCertificate = 20641
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState                                       OpcuaNodeIdServicesVariableCertificate = 20642
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState                                      OpcuaNodeIdServicesVariableCertificate = 20643
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 20645
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments                                         OpcuaNodeIdServicesVariableCertificate = 20647
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState                                                    OpcuaNodeIdServicesVariableCertificate = 20648
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id                                                 OpcuaNodeIdServicesVariableCertificate = 20649
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Name                                               OpcuaNodeIdServicesVariableCertificate = 20650
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Number                                             OpcuaNodeIdServicesVariableCertificate = 20651
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableCertificate = 20652
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime                                     OpcuaNodeIdServicesVariableCertificate = 20653
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableCertificate = 20654
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState                                          OpcuaNodeIdServicesVariableCertificate = 20655
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState                                         OpcuaNodeIdServicesVariableCertificate = 20656
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode                                                      OpcuaNodeIdServicesVariableCertificate = 20657
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState                                                OpcuaNodeIdServicesVariableCertificate = 20658
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id                                             OpcuaNodeIdServicesVariableCertificate = 20659
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name                                           OpcuaNodeIdServicesVariableCertificate = 20660
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number                                         OpcuaNodeIdServicesVariableCertificate = 20661
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableCertificate = 20662
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime                                 OpcuaNodeIdServicesVariableCertificate = 20663
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableCertificate = 20664
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState                                      OpcuaNodeIdServicesVariableCertificate = 20665
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState                                     OpcuaNodeIdServicesVariableCertificate = 20666
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState                                              OpcuaNodeIdServicesVariableCertificate = 20667
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id                                           OpcuaNodeIdServicesVariableCertificate = 20668
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name                                         OpcuaNodeIdServicesVariableCertificate = 20669
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number                                       OpcuaNodeIdServicesVariableCertificate = 20670
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableCertificate = 20671
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime                               OpcuaNodeIdServicesVariableCertificate = 20672
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableCertificate = 20673
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState                                    OpcuaNodeIdServicesVariableCertificate = 20674
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState                                   OpcuaNodeIdServicesVariableCertificate = 20675
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState                                     OpcuaNodeIdServicesVariableCertificate = 20677
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id                                  OpcuaNodeIdServicesVariableCertificate = 20678
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name                                OpcuaNodeIdServicesVariableCertificate = 20679
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number                              OpcuaNodeIdServicesVariableCertificate = 20680
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableCertificate = 20681
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition                                   OpcuaNodeIdServicesVariableCertificate = 20682
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id                                OpcuaNodeIdServicesVariableCertificate = 20683
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name                              OpcuaNodeIdServicesVariableCertificate = 20684
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number                            OpcuaNodeIdServicesVariableCertificate = 20685
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableCertificate = 20686
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableCertificate = 20687
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates                                  OpcuaNodeIdServicesVariableCertificate = 20688
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions                             OpcuaNodeIdServicesVariableCertificate = 20689
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime                                     OpcuaNodeIdServicesVariableCertificate = 20690
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                       OpcuaNodeIdServicesVariableCertificate = 20692
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved                                            OpcuaNodeIdServicesVariableCertificate = 20695
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved                                                 OpcuaNodeIdServicesVariableCertificate = 20696
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleEnabled                                                 OpcuaNodeIdServicesVariableCertificate = 20697
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound                                                   OpcuaNodeIdServicesVariableCertificate = 20698
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId                                            OpcuaNodeIdServicesVariableCertificate = 20699
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId                                          OpcuaNodeIdServicesVariableCertificate = 20700
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId                                         OpcuaNodeIdServicesVariableCertificate = 20701
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState                                                   OpcuaNodeIdServicesVariableCertificate = 20702
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20703
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20704
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20705
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20706
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20707
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20708
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20709
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20710
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OnDelay                                                        OpcuaNodeIdServicesVariableCertificate = 20711
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OffDelay                                                       OpcuaNodeIdServicesVariableCertificate = 20712
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag                                               OpcuaNodeIdServicesVariableCertificate = 20713
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState                                                   OpcuaNodeIdServicesVariableCertificate = 20715
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20716
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20717
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20718
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20719
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20720
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20721
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20722
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20723
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmTime                                                    OpcuaNodeIdServicesVariableCertificate = 20724
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount                                             OpcuaNodeIdServicesVariableCertificate = 20725
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState                                                    OpcuaNodeIdServicesVariableCertificate = 20732
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate                                                 OpcuaNodeIdServicesVariableCertificate = 20733
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationLimit                                                OpcuaNodeIdServicesVariableCertificate = 20734
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType                                                OpcuaNodeIdServicesVariableCertificate = 20735
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate                                                    OpcuaNodeIdServicesVariableCertificate = 20736
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId                                                        OpcuaNodeIdServicesVariableCertificate = 20738
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType                                                      OpcuaNodeIdServicesVariableCertificate = 20739
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode                                                     OpcuaNodeIdServicesVariableCertificate = 20740
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName                                                     OpcuaNodeIdServicesVariableCertificate = 20741
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time                                                           OpcuaNodeIdServicesVariableCertificate = 20742
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime                                                    OpcuaNodeIdServicesVariableCertificate = 20743
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LocalTime                                                      OpcuaNodeIdServicesVariableCertificate = 20744
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message                                                        OpcuaNodeIdServicesVariableCertificate = 20745
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity                                                       OpcuaNodeIdServicesVariableCertificate = 20746
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId                                               OpcuaNodeIdServicesVariableCertificate = 20747
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName                                             OpcuaNodeIdServicesVariableCertificate = 20748
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId                                            OpcuaNodeIdServicesVariableCertificate = 20749
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName                                          OpcuaNodeIdServicesVariableCertificate = 20750
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName                                                  OpcuaNodeIdServicesVariableCertificate = 20751
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId                                                       OpcuaNodeIdServicesVariableCertificate = 20752
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain                                                         OpcuaNodeIdServicesVariableCertificate = 20753
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState                                                   OpcuaNodeIdServicesVariableCertificate = 20754
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20755
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20756
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20757
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20758
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20759
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20760
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20761
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20762
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality                                                        OpcuaNodeIdServicesVariableCertificate = 20763
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp                                        OpcuaNodeIdServicesVariableCertificate = 20764
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity                                                   OpcuaNodeIdServicesVariableCertificate = 20765
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                                   OpcuaNodeIdServicesVariableCertificate = 20766
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment                                                        OpcuaNodeIdServicesVariableCertificate = 20767
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp                                        OpcuaNodeIdServicesVariableCertificate = 20768
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId                                                   OpcuaNodeIdServicesVariableCertificate = 20769
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments                                      OpcuaNodeIdServicesVariableCertificate = 20773
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState                                                     OpcuaNodeIdServicesVariableCertificate = 20774
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id                                                  OpcuaNodeIdServicesVariableCertificate = 20775
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name                                                OpcuaNodeIdServicesVariableCertificate = 20776
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number                                              OpcuaNodeIdServicesVariableCertificate = 20777
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                                OpcuaNodeIdServicesVariableCertificate = 20778
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime                                      OpcuaNodeIdServicesVariableCertificate = 20779
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                             OpcuaNodeIdServicesVariableCertificate = 20780
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState                                           OpcuaNodeIdServicesVariableCertificate = 20781
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState                                          OpcuaNodeIdServicesVariableCertificate = 20782
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState                                                 OpcuaNodeIdServicesVariableCertificate = 20783
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id                                              OpcuaNodeIdServicesVariableCertificate = 20784
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name                                            OpcuaNodeIdServicesVariableCertificate = 20785
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number                                          OpcuaNodeIdServicesVariableCertificate = 20786
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableCertificate = 20787
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                                  OpcuaNodeIdServicesVariableCertificate = 20788
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableCertificate = 20789
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState                                       OpcuaNodeIdServicesVariableCertificate = 20790
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState                                      OpcuaNodeIdServicesVariableCertificate = 20791
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 20793
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments                                         OpcuaNodeIdServicesVariableCertificate = 20795
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState                                                    OpcuaNodeIdServicesVariableCertificate = 20796
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id                                                 OpcuaNodeIdServicesVariableCertificate = 20797
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name                                               OpcuaNodeIdServicesVariableCertificate = 20798
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number                                             OpcuaNodeIdServicesVariableCertificate = 20799
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableCertificate = 20800
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime                                     OpcuaNodeIdServicesVariableCertificate = 20801
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableCertificate = 20802
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState                                          OpcuaNodeIdServicesVariableCertificate = 20803
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState                                         OpcuaNodeIdServicesVariableCertificate = 20804
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode                                                      OpcuaNodeIdServicesVariableCertificate = 20805
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState                                                OpcuaNodeIdServicesVariableCertificate = 20806
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id                                             OpcuaNodeIdServicesVariableCertificate = 20807
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name                                           OpcuaNodeIdServicesVariableCertificate = 20808
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number                                         OpcuaNodeIdServicesVariableCertificate = 20809
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableCertificate = 20810
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime                                 OpcuaNodeIdServicesVariableCertificate = 20811
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableCertificate = 20812
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState                                      OpcuaNodeIdServicesVariableCertificate = 20813
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState                                     OpcuaNodeIdServicesVariableCertificate = 20814
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState                                              OpcuaNodeIdServicesVariableCertificate = 20815
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id                                           OpcuaNodeIdServicesVariableCertificate = 20816
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name                                         OpcuaNodeIdServicesVariableCertificate = 20817
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number                                       OpcuaNodeIdServicesVariableCertificate = 20818
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableCertificate = 20819
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                               OpcuaNodeIdServicesVariableCertificate = 20820
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableCertificate = 20821
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                    OpcuaNodeIdServicesVariableCertificate = 20822
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState                                   OpcuaNodeIdServicesVariableCertificate = 20823
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState                                     OpcuaNodeIdServicesVariableCertificate = 20825
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                                  OpcuaNodeIdServicesVariableCertificate = 20826
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                                OpcuaNodeIdServicesVariableCertificate = 20827
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                              OpcuaNodeIdServicesVariableCertificate = 20828
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName                OpcuaNodeIdServicesVariableCertificate = 20829
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition                                   OpcuaNodeIdServicesVariableCertificate = 20830
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                                OpcuaNodeIdServicesVariableCertificate = 20831
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                              OpcuaNodeIdServicesVariableCertificate = 20832
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                            OpcuaNodeIdServicesVariableCertificate = 20833
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                    OpcuaNodeIdServicesVariableCertificate = 20834
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime           OpcuaNodeIdServicesVariableCertificate = 20835
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates                                  OpcuaNodeIdServicesVariableCertificate = 20836
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                             OpcuaNodeIdServicesVariableCertificate = 20837
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                     OpcuaNodeIdServicesVariableCertificate = 20838
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                       OpcuaNodeIdServicesVariableCertificate = 20840
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved                                            OpcuaNodeIdServicesVariableCertificate = 20843
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved                                                 OpcuaNodeIdServicesVariableCertificate = 20844
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled                                                 OpcuaNodeIdServicesVariableCertificate = 20845
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound                                                   OpcuaNodeIdServicesVariableCertificate = 20846
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId                                            OpcuaNodeIdServicesVariableCertificate = 20847
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId                                          OpcuaNodeIdServicesVariableCertificate = 20848
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId                                         OpcuaNodeIdServicesVariableCertificate = 20849
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState                                                   OpcuaNodeIdServicesVariableCertificate = 20850
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20851
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20852
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20853
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20854
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20855
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20856
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20857
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20858
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OnDelay                                                        OpcuaNodeIdServicesVariableCertificate = 20859
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OffDelay                                                       OpcuaNodeIdServicesVariableCertificate = 20860
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag                                               OpcuaNodeIdServicesVariableCertificate = 20861
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState                                                   OpcuaNodeIdServicesVariableCertificate = 20863
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id                                                OpcuaNodeIdServicesVariableCertificate = 20864
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name                                              OpcuaNodeIdServicesVariableCertificate = 20865
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number                                            OpcuaNodeIdServicesVariableCertificate = 20866
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableCertificate = 20867
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime                                    OpcuaNodeIdServicesVariableCertificate = 20868
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20869
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState                                         OpcuaNodeIdServicesVariableCertificate = 20870
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState                                        OpcuaNodeIdServicesVariableCertificate = 20871
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime                                                    OpcuaNodeIdServicesVariableCertificate = 20872
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount                                             OpcuaNodeIdServicesVariableCertificate = 20873
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState                                                    OpcuaNodeIdServicesVariableCertificate = 20880
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId                                                    OpcuaNodeIdServicesVariableCertificate = 20881
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime                                                 OpcuaNodeIdServicesVariableCertificate = 20882
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency                                                OpcuaNodeIdServicesVariableCertificate = 20883
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UpdateFrequency                                                     OpcuaNodeIdServicesVariableCertificate = 20884
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId                                                    OpcuaNodeIdServicesVariableCertificate = 20886
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType                                                  OpcuaNodeIdServicesVariableCertificate = 20887
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode                                                 OpcuaNodeIdServicesVariableCertificate = 20888
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName                                                 OpcuaNodeIdServicesVariableCertificate = 20889
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time                                                       OpcuaNodeIdServicesVariableCertificate = 20890
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime                                                OpcuaNodeIdServicesVariableCertificate = 20891
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LocalTime                                                  OpcuaNodeIdServicesVariableCertificate = 20892
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message                                                    OpcuaNodeIdServicesVariableCertificate = 20893
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity                                                   OpcuaNodeIdServicesVariableCertificate = 20894
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId                                           OpcuaNodeIdServicesVariableCertificate = 20895
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName                                         OpcuaNodeIdServicesVariableCertificate = 20896
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId                                        OpcuaNodeIdServicesVariableCertificate = 20897
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName                                      OpcuaNodeIdServicesVariableCertificate = 20898
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName                                              OpcuaNodeIdServicesVariableCertificate = 20899
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId                                                   OpcuaNodeIdServicesVariableCertificate = 20900
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain                                                     OpcuaNodeIdServicesVariableCertificate = 20901
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState                                               OpcuaNodeIdServicesVariableCertificate = 20902
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id                                            OpcuaNodeIdServicesVariableCertificate = 20903
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name                                          OpcuaNodeIdServicesVariableCertificate = 20904
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number                                        OpcuaNodeIdServicesVariableCertificate = 20905
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 20906
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 20907
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 20908
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 20909
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 20910
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality                                                    OpcuaNodeIdServicesVariableCertificate = 20911
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableCertificate = 20912
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity                                               OpcuaNodeIdServicesVariableCertificate = 20913
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableCertificate = 20914
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment                                                    OpcuaNodeIdServicesVariableCertificate = 20915
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableCertificate = 20916
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId                                               OpcuaNodeIdServicesVariableCertificate = 20917
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableCertificate = 20921
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState                                                 OpcuaNodeIdServicesVariableCertificate = 20922
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id                                              OpcuaNodeIdServicesVariableCertificate = 20923
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Name                                            OpcuaNodeIdServicesVariableCertificate = 20924
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Number                                          OpcuaNodeIdServicesVariableCertificate = 20925
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableCertificate = 20926
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableCertificate = 20927
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableCertificate = 20928
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState                                       OpcuaNodeIdServicesVariableCertificate = 20929
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState                                      OpcuaNodeIdServicesVariableCertificate = 20930
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState                                             OpcuaNodeIdServicesVariableCertificate = 20931
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableCertificate = 20932
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableCertificate = 20933
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableCertificate = 20934
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 20935
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 20936
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 20937
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 20938
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 20939
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 20941
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 20943
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState                                                OpcuaNodeIdServicesVariableCertificate = 20944
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id                                             OpcuaNodeIdServicesVariableCertificate = 20945
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name                                           OpcuaNodeIdServicesVariableCertificate = 20946
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number                                         OpcuaNodeIdServicesVariableCertificate = 20947
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableCertificate = 20948
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableCertificate = 20949
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableCertificate = 20950
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableCertificate = 20951
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableCertificate = 20952
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode                                                  OpcuaNodeIdServicesVariableCertificate = 20953
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState                                            OpcuaNodeIdServicesVariableCertificate = 20954
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id                                         OpcuaNodeIdServicesVariableCertificate = 20955
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name                                       OpcuaNodeIdServicesVariableCertificate = 20956
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number                                     OpcuaNodeIdServicesVariableCertificate = 20957
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableCertificate = 20958
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableCertificate = 20959
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableCertificate = 20960
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableCertificate = 20961
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableCertificate = 20962
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState                                          OpcuaNodeIdServicesVariableCertificate = 20963
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableCertificate = 20964
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableCertificate = 20965
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableCertificate = 20966
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 20967
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 20968
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 20969
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 20970
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 20971
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableCertificate = 20973
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableCertificate = 20974
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableCertificate = 20975
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableCertificate = 20976
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableCertificate = 20977
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableCertificate = 20978
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableCertificate = 20979
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableCertificate = 20980
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableCertificate = 20981
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableCertificate = 20982
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableCertificate = 20983
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableCertificate = 20984
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableCertificate = 20985
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableCertificate = 20986
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableCertificate = 20988
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableCertificate = 20991
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved                                             OpcuaNodeIdServicesVariableCertificate = 20992
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled                                             OpcuaNodeIdServicesVariableCertificate = 20993
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound                                               OpcuaNodeIdServicesVariableCertificate = 20994
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableCertificate = 20995
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableCertificate = 20996
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableCertificate = 20997
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState                                               OpcuaNodeIdServicesVariableCertificate = 21007
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id                                            OpcuaNodeIdServicesVariableCertificate = 21008
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name                                          OpcuaNodeIdServicesVariableCertificate = 21118
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number                                        OpcuaNodeIdServicesVariableCertificate = 21204
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 21205
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 21206
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21207
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 21208
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 21209
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OnDelay                                                    OpcuaNodeIdServicesVariableCertificate = 21210
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OffDelay                                                   OpcuaNodeIdServicesVariableCertificate = 21211
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableCertificate = 21212
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState                                               OpcuaNodeIdServicesVariableCertificate = 21214
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id                                            OpcuaNodeIdServicesVariableCertificate = 21215
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name                                          OpcuaNodeIdServicesVariableCertificate = 21216
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number                                        OpcuaNodeIdServicesVariableCertificate = 21217
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 21218
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 21219
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21220
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 21221
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 21222
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime                                                OpcuaNodeIdServicesVariableCertificate = 21223
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableCertificate = 21224
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState                                                OpcuaNodeIdServicesVariableCertificate = 21231
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate                                             OpcuaNodeIdServicesVariableCertificate = 21232
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit                                            OpcuaNodeIdServicesVariableCertificate = 21233
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType                                            OpcuaNodeIdServicesVariableCertificate = 21234
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate                                                OpcuaNodeIdServicesVariableCertificate = 21235
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId                                                    OpcuaNodeIdServicesVariableCertificate = 21237
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType                                                  OpcuaNodeIdServicesVariableCertificate = 21238
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode                                                 OpcuaNodeIdServicesVariableCertificate = 21239
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName                                                 OpcuaNodeIdServicesVariableCertificate = 21240
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time                                                       OpcuaNodeIdServicesVariableCertificate = 21241
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime                                                OpcuaNodeIdServicesVariableCertificate = 21242
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime                                                  OpcuaNodeIdServicesVariableCertificate = 21243
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message                                                    OpcuaNodeIdServicesVariableCertificate = 21244
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity                                                   OpcuaNodeIdServicesVariableCertificate = 21245
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId                                           OpcuaNodeIdServicesVariableCertificate = 21246
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName                                         OpcuaNodeIdServicesVariableCertificate = 21247
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId                                        OpcuaNodeIdServicesVariableCertificate = 21248
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName                                      OpcuaNodeIdServicesVariableCertificate = 21249
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName                                              OpcuaNodeIdServicesVariableCertificate = 21250
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId                                                   OpcuaNodeIdServicesVariableCertificate = 21251
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain                                                     OpcuaNodeIdServicesVariableCertificate = 21252
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState                                               OpcuaNodeIdServicesVariableCertificate = 21253
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id                                            OpcuaNodeIdServicesVariableCertificate = 21254
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name                                          OpcuaNodeIdServicesVariableCertificate = 21255
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number                                        OpcuaNodeIdServicesVariableCertificate = 21256
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 21257
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 21258
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21259
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 21260
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 21261
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality                                                    OpcuaNodeIdServicesVariableCertificate = 21262
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableCertificate = 21263
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity                                               OpcuaNodeIdServicesVariableCertificate = 21264
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableCertificate = 21265
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment                                                    OpcuaNodeIdServicesVariableCertificate = 21266
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableCertificate = 21267
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId                                               OpcuaNodeIdServicesVariableCertificate = 21268
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableCertificate = 21272
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState                                                 OpcuaNodeIdServicesVariableCertificate = 21273
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id                                              OpcuaNodeIdServicesVariableCertificate = 21274
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name                                            OpcuaNodeIdServicesVariableCertificate = 21275
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number                                          OpcuaNodeIdServicesVariableCertificate = 21276
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableCertificate = 21277
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableCertificate = 21278
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableCertificate = 21279
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState                                       OpcuaNodeIdServicesVariableCertificate = 21280
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState                                      OpcuaNodeIdServicesVariableCertificate = 21281
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState                                             OpcuaNodeIdServicesVariableCertificate = 21282
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableCertificate = 21283
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableCertificate = 21284
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableCertificate = 21285
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableCertificate = 21286
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableCertificate = 21287
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableCertificate = 21288
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableCertificate = 21289
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableCertificate = 21290
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 21292
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 21294
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState                                                OpcuaNodeIdServicesVariableCertificate = 21295
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id                                             OpcuaNodeIdServicesVariableCertificate = 21296
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name                                           OpcuaNodeIdServicesVariableCertificate = 21297
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number                                         OpcuaNodeIdServicesVariableCertificate = 21298
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableCertificate = 21299
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableCertificate = 21300
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableCertificate = 21301
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableCertificate = 21302
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableCertificate = 21303
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode                                                  OpcuaNodeIdServicesVariableCertificate = 21304
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState                                            OpcuaNodeIdServicesVariableCertificate = 21305
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id                                         OpcuaNodeIdServicesVariableCertificate = 21306
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name                                       OpcuaNodeIdServicesVariableCertificate = 21307
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number                                     OpcuaNodeIdServicesVariableCertificate = 21308
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableCertificate = 21309
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableCertificate = 21310
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableCertificate = 21311
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableCertificate = 21312
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableCertificate = 21313
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState                                          OpcuaNodeIdServicesVariableCertificate = 21314
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableCertificate = 21315
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableCertificate = 21316
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableCertificate = 21317
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 21318
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 21319
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 21320
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 21321
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 21322
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableCertificate = 21324
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableCertificate = 21325
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableCertificate = 21326
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableCertificate = 21327
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableCertificate = 21328
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableCertificate = 21329
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableCertificate = 21330
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableCertificate = 21331
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableCertificate = 21332
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableCertificate = 21333
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableCertificate = 21334
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableCertificate = 21335
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableCertificate = 21336
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableCertificate = 21337
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableCertificate = 21339
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableCertificate = 21342
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved                                             OpcuaNodeIdServicesVariableCertificate = 21343
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled                                             OpcuaNodeIdServicesVariableCertificate = 21344
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound                                               OpcuaNodeIdServicesVariableCertificate = 21345
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableCertificate = 21346
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableCertificate = 21347
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableCertificate = 21348
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState                                               OpcuaNodeIdServicesVariableCertificate = 21349
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id                                            OpcuaNodeIdServicesVariableCertificate = 21350
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name                                          OpcuaNodeIdServicesVariableCertificate = 21351
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number                                        OpcuaNodeIdServicesVariableCertificate = 21352
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 21353
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 21354
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21355
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 21356
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 21357
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay                                                    OpcuaNodeIdServicesVariableCertificate = 21358
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay                                                   OpcuaNodeIdServicesVariableCertificate = 21359
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableCertificate = 21360
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState                                               OpcuaNodeIdServicesVariableCertificate = 21362
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id                                            OpcuaNodeIdServicesVariableCertificate = 21363
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name                                          OpcuaNodeIdServicesVariableCertificate = 21364
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number                                        OpcuaNodeIdServicesVariableCertificate = 21365
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableCertificate = 21366
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableCertificate = 21367
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21368
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableCertificate = 21369
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableCertificate = 21370
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime                                                OpcuaNodeIdServicesVariableCertificate = 21371
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableCertificate = 21372
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState                                                OpcuaNodeIdServicesVariableCertificate = 21379
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId                                                OpcuaNodeIdServicesVariableCertificate = 21380
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime                                             OpcuaNodeIdServicesVariableCertificate = 21381
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency                                            OpcuaNodeIdServicesVariableCertificate = 21382
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UpdateFrequency                                               OpcuaNodeIdServicesVariableCertificate = 21383
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId                                              OpcuaNodeIdServicesVariableCertificate = 21385
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType                                            OpcuaNodeIdServicesVariableCertificate = 21386
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode                                           OpcuaNodeIdServicesVariableCertificate = 21387
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName                                           OpcuaNodeIdServicesVariableCertificate = 21388
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time                                                 OpcuaNodeIdServicesVariableCertificate = 21389
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime                                          OpcuaNodeIdServicesVariableCertificate = 21390
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LocalTime                                            OpcuaNodeIdServicesVariableCertificate = 21391
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message                                              OpcuaNodeIdServicesVariableCertificate = 21392
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity                                             OpcuaNodeIdServicesVariableCertificate = 21393
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId                                     OpcuaNodeIdServicesVariableCertificate = 21394
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName                                   OpcuaNodeIdServicesVariableCertificate = 21395
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassId                                  OpcuaNodeIdServicesVariableCertificate = 21396
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassName                                OpcuaNodeIdServicesVariableCertificate = 21397
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName                                        OpcuaNodeIdServicesVariableCertificate = 21398
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId                                             OpcuaNodeIdServicesVariableCertificate = 21399
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain                                               OpcuaNodeIdServicesVariableCertificate = 21400
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState                                         OpcuaNodeIdServicesVariableCertificate = 21401
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21402
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21403
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21404
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21405
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21406
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21407
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21408
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21409
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality                                              OpcuaNodeIdServicesVariableCertificate = 21410
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableCertificate = 21411
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity                                         OpcuaNodeIdServicesVariableCertificate = 21412
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableCertificate = 21413
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment                                              OpcuaNodeIdServicesVariableCertificate = 21414
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableCertificate = 21415
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId                                         OpcuaNodeIdServicesVariableCertificate = 21416
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments                            OpcuaNodeIdServicesVariableCertificate = 21420
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState                                           OpcuaNodeIdServicesVariableCertificate = 21421
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id                                        OpcuaNodeIdServicesVariableCertificate = 21422
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Name                                      OpcuaNodeIdServicesVariableCertificate = 21423
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Number                                    OpcuaNodeIdServicesVariableCertificate = 21424
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableCertificate = 21425
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableCertificate = 21426
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableCertificate = 21427
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TrueState                                 OpcuaNodeIdServicesVariableCertificate = 21428
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_FalseState                                OpcuaNodeIdServicesVariableCertificate = 21429
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState                                       OpcuaNodeIdServicesVariableCertificate = 21430
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableCertificate = 21431
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableCertificate = 21432
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Number                                OpcuaNodeIdServicesVariableCertificate = 21433
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableCertificate = 21434
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableCertificate = 21435
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableCertificate = 21436
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableCertificate = 21437
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableCertificate = 21438
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 21440
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 21442
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState                                          OpcuaNodeIdServicesVariableCertificate = 21443
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id                                       OpcuaNodeIdServicesVariableCertificate = 21444
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Name                                     OpcuaNodeIdServicesVariableCertificate = 21445
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Number                                   OpcuaNodeIdServicesVariableCertificate = 21446
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 21447
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 21448
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 21449
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 21450
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 21451
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode                                            OpcuaNodeIdServicesVariableCertificate = 21452
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState                                      OpcuaNodeIdServicesVariableCertificate = 21453
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id                                   OpcuaNodeIdServicesVariableCertificate = 21454
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Name                                 OpcuaNodeIdServicesVariableCertificate = 21455
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Number                               OpcuaNodeIdServicesVariableCertificate = 21456
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableCertificate = 21457
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21458
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableCertificate = 21459
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableCertificate = 21460
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableCertificate = 21461
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState                                    OpcuaNodeIdServicesVariableCertificate = 21462
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableCertificate = 21463
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableCertificate = 21464
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableCertificate = 21465
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableCertificate = 21466
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableCertificate = 21467
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableCertificate = 21468
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableCertificate = 21469
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableCertificate = 21470
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableCertificate = 21472
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableCertificate = 21473
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableCertificate = 21474
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableCertificate = 21475
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableCertificate = 21476
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableCertificate = 21477
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableCertificate = 21478
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableCertificate = 21479
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableCertificate = 21480
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableCertificate = 21481
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableCertificate = 21482
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableCertificate = 21483
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableCertificate = 21484
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableCertificate = 21485
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableCertificate = 21487
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableCertificate = 21490
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_MaxTimeShelved                                       OpcuaNodeIdServicesVariableCertificate = 21491
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleEnabled                                       OpcuaNodeIdServicesVariableCertificate = 21492
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound                                         OpcuaNodeIdServicesVariableCertificate = 21493
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableCertificate = 21494
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableCertificate = 21495
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableCertificate = 21496
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState                                         OpcuaNodeIdServicesVariableCertificate = 21497
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21498
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21499
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21500
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21501
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21502
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21503
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21504
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21505
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OnDelay                                              OpcuaNodeIdServicesVariableCertificate = 21506
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OffDelay                                             OpcuaNodeIdServicesVariableCertificate = 21507
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableCertificate = 21508
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState                                         OpcuaNodeIdServicesVariableCertificate = 21510
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21511
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21512
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21513
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21514
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21515
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21516
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21517
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21518
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmTime                                          OpcuaNodeIdServicesVariableCertificate = 21519
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableCertificate = 21520
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState                                          OpcuaNodeIdServicesVariableCertificate = 21527
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate                                       OpcuaNodeIdServicesVariableCertificate = 21528
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationLimit                                      OpcuaNodeIdServicesVariableCertificate = 21529
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType                                      OpcuaNodeIdServicesVariableCertificate = 21530
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate                                          OpcuaNodeIdServicesVariableCertificate = 21531
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId                                              OpcuaNodeIdServicesVariableCertificate = 21533
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType                                            OpcuaNodeIdServicesVariableCertificate = 21534
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode                                           OpcuaNodeIdServicesVariableCertificate = 21535
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName                                           OpcuaNodeIdServicesVariableCertificate = 21536
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time                                                 OpcuaNodeIdServicesVariableCertificate = 21537
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime                                          OpcuaNodeIdServicesVariableCertificate = 21538
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LocalTime                                            OpcuaNodeIdServicesVariableCertificate = 21539
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message                                              OpcuaNodeIdServicesVariableCertificate = 21540
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity                                             OpcuaNodeIdServicesVariableCertificate = 21541
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId                                     OpcuaNodeIdServicesVariableCertificate = 21542
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName                                   OpcuaNodeIdServicesVariableCertificate = 21543
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassId                                  OpcuaNodeIdServicesVariableCertificate = 21544
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassName                                OpcuaNodeIdServicesVariableCertificate = 21545
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName                                        OpcuaNodeIdServicesVariableCertificate = 21546
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId                                             OpcuaNodeIdServicesVariableCertificate = 21547
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain                                               OpcuaNodeIdServicesVariableCertificate = 21548
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState                                         OpcuaNodeIdServicesVariableCertificate = 21549
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21550
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21551
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21552
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21553
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21554
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21555
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21556
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21557
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality                                              OpcuaNodeIdServicesVariableCertificate = 21558
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableCertificate = 21559
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity                                         OpcuaNodeIdServicesVariableCertificate = 21560
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableCertificate = 21561
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment                                              OpcuaNodeIdServicesVariableCertificate = 21562
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableCertificate = 21563
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId                                         OpcuaNodeIdServicesVariableCertificate = 21564
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments                            OpcuaNodeIdServicesVariableCertificate = 21568
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState                                           OpcuaNodeIdServicesVariableCertificate = 21569
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id                                        OpcuaNodeIdServicesVariableCertificate = 21570
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Name                                      OpcuaNodeIdServicesVariableCertificate = 21571
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Number                                    OpcuaNodeIdServicesVariableCertificate = 21572
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableCertificate = 21573
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableCertificate = 21574
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableCertificate = 21575
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TrueState                                 OpcuaNodeIdServicesVariableCertificate = 21576
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_FalseState                                OpcuaNodeIdServicesVariableCertificate = 21577
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState                                       OpcuaNodeIdServicesVariableCertificate = 21578
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableCertificate = 21579
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableCertificate = 21580
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Number                                OpcuaNodeIdServicesVariableCertificate = 21581
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableCertificate = 21582
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableCertificate = 21583
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableCertificate = 21584
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableCertificate = 21585
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableCertificate = 21586
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 21588
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 21590
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState                                          OpcuaNodeIdServicesVariableCertificate = 21591
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id                                       OpcuaNodeIdServicesVariableCertificate = 21592
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Name                                     OpcuaNodeIdServicesVariableCertificate = 21593
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Number                                   OpcuaNodeIdServicesVariableCertificate = 21594
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableCertificate = 21595
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableCertificate = 21596
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableCertificate = 21597
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TrueState                                OpcuaNodeIdServicesVariableCertificate = 21598
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_FalseState                               OpcuaNodeIdServicesVariableCertificate = 21599
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode                                            OpcuaNodeIdServicesVariableCertificate = 21600
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState                                      OpcuaNodeIdServicesVariableCertificate = 21601
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id                                   OpcuaNodeIdServicesVariableCertificate = 21602
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Name                                 OpcuaNodeIdServicesVariableCertificate = 21603
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Number                               OpcuaNodeIdServicesVariableCertificate = 21604
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableCertificate = 21605
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableCertificate = 21606
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableCertificate = 21607
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableCertificate = 21608
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableCertificate = 21609
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState                                    OpcuaNodeIdServicesVariableCertificate = 21610
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableCertificate = 21611
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableCertificate = 21612
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableCertificate = 21613
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableCertificate = 21614
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableCertificate = 21615
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableCertificate = 21616
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableCertificate = 21617
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableCertificate = 21618
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableCertificate = 21620
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableCertificate = 21621
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableCertificate = 21622
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableCertificate = 21623
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableCertificate = 21624
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableCertificate = 21625
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableCertificate = 21626
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableCertificate = 21627
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableCertificate = 21628
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableCertificate = 21629
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableCertificate = 21630
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableCertificate = 21631
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableCertificate = 21632
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableCertificate = 21633
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableCertificate = 21635
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableCertificate = 21638
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_MaxTimeShelved                                       OpcuaNodeIdServicesVariableCertificate = 21639
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleEnabled                                       OpcuaNodeIdServicesVariableCertificate = 21640
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound                                         OpcuaNodeIdServicesVariableCertificate = 21641
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableCertificate = 21642
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableCertificate = 21643
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableCertificate = 21644
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState                                         OpcuaNodeIdServicesVariableCertificate = 21645
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21646
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21647
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21648
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21649
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21650
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21651
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21652
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21653
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OnDelay                                              OpcuaNodeIdServicesVariableCertificate = 21654
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OffDelay                                             OpcuaNodeIdServicesVariableCertificate = 21655
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableCertificate = 21656
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState                                         OpcuaNodeIdServicesVariableCertificate = 21658
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id                                      OpcuaNodeIdServicesVariableCertificate = 21659
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Name                                    OpcuaNodeIdServicesVariableCertificate = 21660
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Number                                  OpcuaNodeIdServicesVariableCertificate = 21661
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableCertificate = 21662
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableCertificate = 21663
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableCertificate = 21664
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TrueState                               OpcuaNodeIdServicesVariableCertificate = 21665
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_FalseState                              OpcuaNodeIdServicesVariableCertificate = 21666
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmTime                                          OpcuaNodeIdServicesVariableCertificate = 21667
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableCertificate = 21668
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState                                          OpcuaNodeIdServicesVariableCertificate = 21675
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId                                          OpcuaNodeIdServicesVariableCertificate = 21676
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime                                       OpcuaNodeIdServicesVariableCertificate = 21677
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency                                      OpcuaNodeIdServicesVariableCertificate = 21678
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_GetRejectedList_OutputArguments                                                                           OpcuaNodeIdServicesVariableCertificate = 23527
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments                                             OpcuaNodeIdServicesVariableCertificate = 23530
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments                                                   OpcuaNodeIdServicesVariableCertificate = 23532
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList_OutputArguments                                               OpcuaNodeIdServicesVariableCertificate = 23534
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList_OutputArguments                                         OpcuaNodeIdServicesVariableCertificate = 23536
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_DefaultValidationOptions                                                                        OpcuaNodeIdServicesVariableCertificate = 23566
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_DefaultValidationOptions                                          OpcuaNodeIdServicesVariableCertificate = 23567
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_DefaultValidationOptions                                                OpcuaNodeIdServicesVariableCertificate = 23568
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_DefaultValidationOptions                                            OpcuaNodeIdServicesVariableCertificate = 23569
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_DefaultValidationOptions                                      OpcuaNodeIdServicesVariableCertificate = 23570
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MaxByteStringLength                                                                             OpcuaNodeIdServicesVariableCertificate = 24251
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MaxByteStringLength                                               OpcuaNodeIdServicesVariableCertificate = 24252
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MaxByteStringLength                                                     OpcuaNodeIdServicesVariableCertificate = 24253
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MaxByteStringLength                                                 OpcuaNodeIdServicesVariableCertificate = 24254
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MaxByteStringLength                                           OpcuaNodeIdServicesVariableCertificate = 24255
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Suppress2_InputArguments                                                                        OpcuaNodeIdServicesVariableCertificate = 24489
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Unsuppress2_InputArguments                                                                      OpcuaNodeIdServicesVariableCertificate = 24491
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_RemoveFromService2_InputArguments                                                               OpcuaNodeIdServicesVariableCertificate = 24493
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_PlaceInService2_InputArguments                                                                  OpcuaNodeIdServicesVariableCertificate = 24495
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Reset2_InputArguments                                                                           OpcuaNodeIdServicesVariableCertificate = 24497
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Suppress2_InputArguments                                                               OpcuaNodeIdServicesVariableCertificate = 24519
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Unsuppress2_InputArguments                                                             OpcuaNodeIdServicesVariableCertificate = 24521
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_RemoveFromService2_InputArguments                                                      OpcuaNodeIdServicesVariableCertificate = 24523
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_PlaceInService2_InputArguments                                                         OpcuaNodeIdServicesVariableCertificate = 24525
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Reset2_InputArguments                                                                  OpcuaNodeIdServicesVariableCertificate = 24527
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Suppress2_InputArguments                                                               OpcuaNodeIdServicesVariableCertificate = 24529
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Unsuppress2_InputArguments                                                             OpcuaNodeIdServicesVariableCertificate = 24531
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_RemoveFromService2_InputArguments                                                      OpcuaNodeIdServicesVariableCertificate = 24533
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_PlaceInService2_InputArguments                                                         OpcuaNodeIdServicesVariableCertificate = 24535
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Reset2_InputArguments                                                                  OpcuaNodeIdServicesVariableCertificate = 24537
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24539
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 24541
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments                        OpcuaNodeIdServicesVariableCertificate = 24543
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 24545
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments                                    OpcuaNodeIdServicesVariableCertificate = 24547
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24549
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments                               OpcuaNodeIdServicesVariableCertificate = 24551
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                        OpcuaNodeIdServicesVariableCertificate = 24553
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 24555
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments                                    OpcuaNodeIdServicesVariableCertificate = 24557
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments                                       OpcuaNodeIdServicesVariableCertificate = 24559
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 24561
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments                              OpcuaNodeIdServicesVariableCertificate = 24563
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24565
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 24567
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments                                       OpcuaNodeIdServicesVariableCertificate = 24569
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                     OpcuaNodeIdServicesVariableCertificate = 24571
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                              OpcuaNodeIdServicesVariableCertificate = 24573
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24575
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments                                          OpcuaNodeIdServicesVariableCertificate = 24577
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableCertificate = 24579
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24581
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableCertificate = 24583
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableCertificate = 24585
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableCertificate = 24587
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableCertificate = 24589
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableCertificate = 24591
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableCertificate = 24593
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableCertificate = 24595
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableCertificate = 24597
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableCertificate = 24599
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 24601
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableCertificate = 24603
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableCertificate = 24605
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2_InputArguments                                OpcuaNodeIdServicesVariableCertificate = 24607
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableCertificate = 24609
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableCertificate = 24611
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableCertificate = 24613
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableCertificate = 24615
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2_InputArguments                                OpcuaNodeIdServicesVariableCertificate = 24617
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve2_InputArguments                                                       OpcuaNodeIdServicesVariableCertificate = 24955
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_Unshelve2_InputArguments                                                          OpcuaNodeIdServicesVariableCertificate = 24957
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2_InputArguments                                                     OpcuaNodeIdServicesVariableCertificate = 24959
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 24979
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2_InputArguments                                                 OpcuaNodeIdServicesVariableCertificate = 24981
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                                            OpcuaNodeIdServicesVariableCertificate = 24983
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                                              OpcuaNodeIdServicesVariableCertificate = 24987
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                                                 OpcuaNodeIdServicesVariableCertificate = 24989
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                                            OpcuaNodeIdServicesVariableCertificate = 24991
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                OpcuaNodeIdServicesVariableCertificate = 24995
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                   OpcuaNodeIdServicesVariableCertificate = 24997
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments              OpcuaNodeIdServicesVariableCertificate = 24999
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                OpcuaNodeIdServicesVariableCertificate = 25003
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                   OpcuaNodeIdServicesVariableCertificate = 25005
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments              OpcuaNodeIdServicesVariableCertificate = 25007
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                      OpcuaNodeIdServicesVariableCertificate = 25011
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                         OpcuaNodeIdServicesVariableCertificate = 25013
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                    OpcuaNodeIdServicesVariableCertificate = 25015
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                      OpcuaNodeIdServicesVariableCertificate = 25019
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                         OpcuaNodeIdServicesVariableCertificate = 25021
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                    OpcuaNodeIdServicesVariableCertificate = 25023
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableCertificate = 25027
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableCertificate = 25029
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableCertificate = 25031
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableCertificate = 25035
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableCertificate = 25037
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableCertificate = 25039
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableCertificate = 25043
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableCertificate = 25045
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableCertificate = 25047
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableCertificate = 25051
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableCertificate = 25053
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableCertificate = 25055
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_GetGroupMemberships_OutputArguments                                                             OpcuaNodeIdServicesVariableCertificate = 25174
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_GetGroupMemberships_OutputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 25177
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships_OutputArguments                                                    OpcuaNodeIdServicesVariableCertificate = 25178
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments                      OpcuaNodeIdServicesVariableCertificate = 25179
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                      OpcuaNodeIdServicesVariableCertificate = 25180
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments                            OpcuaNodeIdServicesVariableCertificate = 25181
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                            OpcuaNodeIdServicesVariableCertificate = 25182
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableCertificate = 25183
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableCertificate = 25184
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableCertificate = 25185
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableCertificate = 25186
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastModifiedTime                                                                                OpcuaNodeIdServicesVariableCertificate = 25207
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastModifiedTime                                                  OpcuaNodeIdServicesVariableCertificate = 25208
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastModifiedTime                                                        OpcuaNodeIdServicesVariableCertificate = 25209
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastModifiedTime                                                    OpcuaNodeIdServicesVariableCertificate = 25210
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastModifiedTime                                              OpcuaNodeIdServicesVariableCertificate = 25211
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassId                                                                              OpcuaNodeIdServicesVariableCertificate = 32031
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassName                                                                            OpcuaNodeIdServicesVariableCertificate = 32032
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassId                                                                           OpcuaNodeIdServicesVariableCertificate = 32033
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassName                                                                         OpcuaNodeIdServicesVariableCertificate = 32034
	OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SupportsFilteredRetain                                                                          OpcuaNodeIdServicesVariableCertificate = 32242
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_ActivityTimeout                                                                                 OpcuaNodeIdServicesVariableCertificate = 32255
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_ActivityTimeout                                                   OpcuaNodeIdServicesVariableCertificate = 32256
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_ActivityTimeout                                                         OpcuaNodeIdServicesVariableCertificate = 32257
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_ActivityTimeout                                                     OpcuaNodeIdServicesVariableCertificate = 32258
	OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_ActivityTimeout                                               OpcuaNodeIdServicesVariableCertificate = 32259
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventId                                                                               OpcuaNodeIdServicesVariableCertificate = 32307
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventType                                                                             OpcuaNodeIdServicesVariableCertificate = 32308
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceNode                                                                            OpcuaNodeIdServicesVariableCertificate = 32309
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceName                                                                            OpcuaNodeIdServicesVariableCertificate = 32310
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Time                                                                                  OpcuaNodeIdServicesVariableCertificate = 32311
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ReceiveTime                                                                           OpcuaNodeIdServicesVariableCertificate = 32312
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_LocalTime                                                                             OpcuaNodeIdServicesVariableCertificate = 32313
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Message                                                                               OpcuaNodeIdServicesVariableCertificate = 32314
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Severity                                                                              OpcuaNodeIdServicesVariableCertificate = 32315
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassId                                                                      OpcuaNodeIdServicesVariableCertificate = 32316
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassName                                                                    OpcuaNodeIdServicesVariableCertificate = 32317
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassId                                                                   OpcuaNodeIdServicesVariableCertificate = 32318
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassName                                                                 OpcuaNodeIdServicesVariableCertificate = 32319
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ActionTimeStamp                                                                       OpcuaNodeIdServicesVariableCertificate = 32320
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Status                                                                                OpcuaNodeIdServicesVariableCertificate = 32321
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ServerId                                                                              OpcuaNodeIdServicesVariableCertificate = 32322
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientAuditEntryId                                                                    OpcuaNodeIdServicesVariableCertificate = 32323
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientUserId                                                                          OpcuaNodeIdServicesVariableCertificate = 32324
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_MethodId                                                                              OpcuaNodeIdServicesVariableCertificate = 32325
	OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_InputArguments                                                                        OpcuaNodeIdServicesVariableCertificate = 32326
)

var OpcuaNodeIdServicesVariableCertificateValues []OpcuaNodeIdServicesVariableCertificate

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableCertificateValues = []OpcuaNodeIdServicesVariableCertificate{
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Status,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Size,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Writable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MimeType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateTypes,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateGroup,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventType,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceName,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Time,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Message,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Severity,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Status,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ServerId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_MethodId,
		OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableCertificateByValue(value int32) (enum OpcuaNodeIdServicesVariableCertificate, ok bool) {
	switch value {
	case 12621:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventId, true
	case 12622:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventType, true
	case 12623:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceNode, true
	case 12624:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceName, true
	case 12625:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Time, true
	case 12626:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ReceiveTime, true
	case 12627:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_LocalTime, true
	case 12628:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Message, true
	case 12629:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Severity, true
	case 12630:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ActionTimeStamp, true
	case 12631:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Status, true
	case 12632:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ServerId, true
	case 12633:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientAuditEntryId, true
	case 12634:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientUserId, true
	case 13226:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventId, true
	case 13227:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventType, true
	case 13228:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceNode, true
	case 13229:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceName, true
	case 13230:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Time, true
	case 13231:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReceiveTime, true
	case 13232:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LocalTime, true
	case 13233:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Message, true
	case 13234:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Severity, true
	case 13235:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassId, true
	case 13236:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassName, true
	case 13237:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionName, true
	case 13238:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_BranchId, true
	case 13239:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Retain, true
	case 13240:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState, true
	case 13241:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Id, true
	case 13242:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Name, true
	case 13243:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Number, true
	case 13244:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName, true
	case 13245:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TransitionTime, true
	case 13246:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime, true
	case 13247:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TrueState, true
	case 13248:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_FalseState, true
	case 13249:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality, true
	case 13250:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality_SourceTimestamp, true
	case 13251:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity, true
	case 13252:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity_SourceTimestamp, true
	case 13253:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment, true
	case 13254:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment_SourceTimestamp, true
	case 13255:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ClientUserId, true
	case 13259:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AddComment_InputArguments, true
	case 13261:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh_InputArguments, true
	case 13263:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh2_InputArguments, true
	case 13264:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState, true
	case 13265:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Id, true
	case 13266:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Name, true
	case 13267:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Number, true
	case 13268:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveDisplayName, true
	case 13269:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TransitionTime, true
	case 13270:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime, true
	case 13271:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TrueState, true
	case 13272:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_FalseState, true
	case 13273:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState, true
	case 13274:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Id, true
	case 13275:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Name, true
	case 13276:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Number, true
	case 13277:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 13278:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TransitionTime, true
	case 13279:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 13280:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TrueState, true
	case 13281:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_FalseState, true
	case 13283:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Acknowledge_InputArguments, true
	case 13285:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Confirm_InputArguments, true
	case 13286:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState, true
	case 13287:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Id, true
	case 13288:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Name, true
	case 13289:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Number, true
	case 13290:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName, true
	case 13291:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TransitionTime, true
	case 13292:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime, true
	case 13293:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TrueState, true
	case 13294:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_FalseState, true
	case 13295:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_InputNode, true
	case 13296:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState, true
	case 13297:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Id, true
	case 13298:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Name, true
	case 13299:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Number, true
	case 13300:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName, true
	case 13301:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TransitionTime, true
	case 13302:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 13303:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TrueState, true
	case 13304:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_FalseState, true
	case 13306:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState, true
	case 13307:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Id, true
	case 13308:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Name, true
	case 13309:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Number, true
	case 13310:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 13311:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition, true
	case 13312:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Id, true
	case 13313:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Name, true
	case 13314:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Number, true
	case 13315:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 13316:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 13317:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_UnshelveTime, true
	case 13321:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 13322:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedOrShelved, true
	case 13323:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_MaxTimeShelved, true
	case 13324:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_NormalState, true
	case 13325:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationDate, true
	case 13326:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_CertificateType, true
	case 13327:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Certificate, true
	case 13600:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Size, true
	case 13601:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Writable, true
	case 13602:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UserWritable, true
	case 13603:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenCount, true
	case 13604:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MimeType, true
	case 13606:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_InputArguments, true
	case 13607:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_OutputArguments, true
	case 13609:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Close_InputArguments, true
	case 13611:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_InputArguments, true
	case 13612:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_OutputArguments, true
	case 13614:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Write_InputArguments, true
	case 13616:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_InputArguments, true
	case 13617:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_OutputArguments, true
	case 13619:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_SetPosition_InputArguments, true
	case 13620:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastUpdateTime, true
	case 13622:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_InputArguments, true
	case 13623:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_OutputArguments, true
	case 13625:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_InputArguments, true
	case 13626:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments, true
	case 13628:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_AddCertificate_InputArguments, true
	case 13630:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_RemoveCertificate_InputArguments, true
	case 13631:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateTypes, true
	case 13735:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateGroup, true
	case 13736:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateType, true
	case 13816:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size, true
	case 13817:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable, true
	case 13818:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable, true
	case 13819:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount, true
	case 13820:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType, true
	case 13822:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case 13823:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case 13825:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case 13827:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case 13828:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case 13830:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case 13832:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case 13833:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case 13835:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case 13836:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case 13838:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case 13839:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 13841:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 13842:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 13844:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case 13846:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case 13847:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes, true
	case 13850:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size, true
	case 13851:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable, true
	case 13852:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable, true
	case 13853:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount, true
	case 13854:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType, true
	case 13856:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case 13857:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case 13859:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case 13861:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case 13862:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case 13864:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case 13866:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case 13867:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case 13869:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case 13870:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case 13872:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case 13873:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 13875:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 13876:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 13878:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case 13880:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case 13881:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes, true
	case 13884:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size, true
	case 13885:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable, true
	case 13886:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable, true
	case 13887:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount, true
	case 13888:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType, true
	case 13890:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case 13891:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case 13893:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case 13895:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case 13896:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case 13898:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case 13900:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case 13901:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case 13903:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case 13904:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case 13906:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case 13907:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 13909:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 13910:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 13912:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case 13914:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case 13915:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes, true
	case 13918:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size, true
	case 13919:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable, true
	case 13920:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable, true
	case 13921:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount, true
	case 13922:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType, true
	case 13924:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments, true
	case 13925:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments, true
	case 13927:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments, true
	case 13929:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments, true
	case 13930:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments, true
	case 13932:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments, true
	case 13934:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments, true
	case 13935:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments, true
	case 13937:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments, true
	case 13938:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime, true
	case 13940:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments, true
	case 13941:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments, true
	case 13943:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments, true
	case 13944:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments, true
	case 13946:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments, true
	case 13948:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments, true
	case 13949:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes, true
	case 14900:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationLimit, true
	case 17044:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassId, true
	case 17045:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassName, true
	case 17046:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState, true
	case 17047:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Id, true
	case 17048:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Name, true
	case 17049:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Number, true
	case 17050:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 17051:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TransitionTime, true
	case 17052:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 17053:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TrueState, true
	case 17054:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_FalseState, true
	case 17055:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState, true
	case 17056:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Id, true
	case 17057:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Name, true
	case 17058:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Number, true
	case 17059:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName, true
	case 17060:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TransitionTime, true
	case 17061:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime, true
	case 17062:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TrueState, true
	case 17063:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_FalseState, true
	case 17064:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleEnabled, true
	case 17065:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound, true
	case 17070:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OnDelay, true
	case 17071:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OffDelay, true
	case 17072:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_FirstInGroupFlag, true
	case 17075:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmTime, true
	case 17076:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmRepeatCount, true
	case 17700:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableStates, true
	case 17701:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableTransitions, true
	case 17970:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_ListId, true
	case 17971:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_AgencyId, true
	case 17972:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_VersionId, true
	case 18645:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState, true
	case 18646:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Id, true
	case 18647:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Name, true
	case 18648:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Number, true
	case 18649:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName, true
	case 18650:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TransitionTime, true
	case 18651:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18652:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TrueState, true
	case 18653:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_FalseState, true
	case 19449:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UpdateFrequency, true
	case 19451:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventId, true
	case 19452:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventType, true
	case 19453:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceNode, true
	case 19454:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceName, true
	case 19455:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Time, true
	case 19456:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReceiveTime, true
	case 19457:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LocalTime, true
	case 19458:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Message, true
	case 19459:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Severity, true
	case 19460:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassId, true
	case 19461:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassName, true
	case 19462:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassId, true
	case 19463:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassName, true
	case 19464:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionName, true
	case 19465:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_BranchId, true
	case 19466:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Retain, true
	case 19467:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState, true
	case 19468:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Id, true
	case 19469:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Name, true
	case 19470:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Number, true
	case 19471:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 19472:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TransitionTime, true
	case 19473:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 19474:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TrueState, true
	case 19475:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_FalseState, true
	case 19476:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality, true
	case 19477:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality_SourceTimestamp, true
	case 19478:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity, true
	case 19479:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 19480:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment, true
	case 19481:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment_SourceTimestamp, true
	case 19482:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ClientUserId, true
	case 19486:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AddComment_InputArguments, true
	case 19487:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState, true
	case 19488:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Id, true
	case 19489:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Name, true
	case 19490:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Number, true
	case 19491:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 19492:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TransitionTime, true
	case 19493:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 19494:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TrueState, true
	case 19495:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_FalseState, true
	case 19496:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState, true
	case 19497:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Id, true
	case 19498:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Name, true
	case 19499:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Number, true
	case 19500:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 19501:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime, true
	case 19502:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 19503:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TrueState, true
	case 19504:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_FalseState, true
	case 19506:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Acknowledge_InputArguments, true
	case 19508:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Confirm_InputArguments, true
	case 19509:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState, true
	case 19510:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Id, true
	case 19511:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Name, true
	case 19512:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Number, true
	case 19513:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 19514:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TransitionTime, true
	case 19515:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 19516:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TrueState, true
	case 19517:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_FalseState, true
	case 19518:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_InputNode, true
	case 19519:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState, true
	case 19520:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Id, true
	case 19521:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Name, true
	case 19522:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Number, true
	case 19523:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 19524:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime, true
	case 19525:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 19526:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TrueState, true
	case 19527:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_FalseState, true
	case 19528:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState, true
	case 19529:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Id, true
	case 19530:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Name, true
	case 19531:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Number, true
	case 19532:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 19533:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 19534:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 19535:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState, true
	case 19536:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState, true
	case 19538:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState, true
	case 19539:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 19540:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 19541:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 19542:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 19543:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition, true
	case 19544:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 19545:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 19546:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 19547:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 19548:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 19549:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates, true
	case 20095:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 20096:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime, true
	case 20098:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 20101:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedOrShelved, true
	case 20102:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_MaxTimeShelved, true
	case 20103:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleEnabled, true
	case 20104:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound, true
	case 20105:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_ListId, true
	case 20106:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_AgencyId, true
	case 20107:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_VersionId, true
	case 20108:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState, true
	case 20109:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Id, true
	case 20110:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Name, true
	case 20111:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Number, true
	case 20112:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 20113:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TransitionTime, true
	case 20114:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 20115:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TrueState, true
	case 20116:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_FalseState, true
	case 20117:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OnDelay, true
	case 20118:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OffDelay, true
	case 20119:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_FirstInGroupFlag, true
	case 20121:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState, true
	case 20122:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Id, true
	case 20123:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Name, true
	case 20124:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Number, true
	case 20125:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 20126:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TransitionTime, true
	case 20127:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 20128:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TrueState, true
	case 20129:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_FalseState, true
	case 20130:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmTime, true
	case 20131:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmRepeatCount, true
	case 20138:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_NormalState, true
	case 20139:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationDate, true
	case 20140:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationLimit, true
	case 20141:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_CertificateType, true
	case 20142:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Certificate, true
	case 20144:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventId, true
	case 20145:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventType, true
	case 20146:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceNode, true
	case 20147:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceName, true
	case 20148:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Time, true
	case 20149:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReceiveTime, true
	case 20150:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LocalTime, true
	case 20151:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Message, true
	case 20152:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Severity, true
	case 20153:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassId, true
	case 20154:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassName, true
	case 20155:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassId, true
	case 20156:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassName, true
	case 20157:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionName, true
	case 20158:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_BranchId, true
	case 20159:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Retain, true
	case 20160:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState, true
	case 20161:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Id, true
	case 20162:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Name, true
	case 20163:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Number, true
	case 20164:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 20165:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 20166:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 20167:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState, true
	case 20168:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState, true
	case 20169:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality, true
	case 20170:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 20171:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity, true
	case 20172:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 20173:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment, true
	case 20174:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 20175:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ClientUserId, true
	case 20179:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments, true
	case 20180:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState, true
	case 20181:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Id, true
	case 20182:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Name, true
	case 20183:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Number, true
	case 20184:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 20185:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime, true
	case 20186:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 20187:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TrueState, true
	case 20188:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_FalseState, true
	case 20189:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState, true
	case 20190:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id, true
	case 20191:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name, true
	case 20192:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number, true
	case 20193:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 20194:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 20195:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 20196:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 20197:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 20199:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 20201:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments, true
	case 20202:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState, true
	case 20203:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Id, true
	case 20204:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Name, true
	case 20205:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Number, true
	case 20206:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 20207:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 20208:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 20209:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState, true
	case 20210:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState, true
	case 20211:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_InputNode, true
	case 20212:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState, true
	case 20213:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Id, true
	case 20214:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Name, true
	case 20215:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Number, true
	case 20216:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 20217:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 20218:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 20219:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState, true
	case 20220:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState, true
	case 20221:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState, true
	case 20222:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id, true
	case 20223:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name, true
	case 20224:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number, true
	case 20225:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 20226:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 20227:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 20228:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 20229:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 20231:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 20232:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 20233:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 20234:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 20235:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20236:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 20237:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 20238:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 20239:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 20240:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 20241:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20242:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 20243:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 20244:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 20246:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 20249:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved, true
	case 20250:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_MaxTimeShelved, true
	case 20251:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleEnabled, true
	case 20252:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound, true
	case 20253:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId, true
	case 20254:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 20255:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId, true
	case 20256:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState, true
	case 20257:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Id, true
	case 20258:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Name, true
	case 20259:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Number, true
	case 20260:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 20261:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 20262:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 20263:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState, true
	case 20264:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState, true
	case 20265:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OnDelay, true
	case 20266:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OffDelay, true
	case 20267:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag, true
	case 20269:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState, true
	case 20270:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Id, true
	case 20271:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Name, true
	case 20272:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Number, true
	case 20273:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 20274:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 20275:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 20276:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState, true
	case 20277:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState, true
	case 20278:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmTime, true
	case 20279:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 20286:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_NormalState, true
	case 20287:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_TrustListId, true
	case 20288:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastUpdateTime, true
	case 20289:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_UpdateFrequency, true
	case 20290:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case 20292:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId, true
	case 20293:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType, true
	case 20294:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case 20295:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case 20296:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time, true
	case 20297:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case 20298:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case 20299:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message, true
	case 20300:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity, true
	case 20301:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case 20302:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case 20303:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case 20304:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case 20305:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case 20306:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case 20307:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain, true
	case 20308:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case 20309:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case 20310:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case 20311:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case 20312:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 20313:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 20314:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 20315:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case 20316:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case 20317:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality, true
	case 20318:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 20319:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case 20320:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 20321:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment, true
	case 20322:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 20323:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case 20327:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case 20328:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case 20329:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case 20330:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case 20331:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case 20332:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 20333:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case 20334:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 20335:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case 20336:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case 20337:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case 20338:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case 20339:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case 20340:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case 20341:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 20342:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 20343:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 20344:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 20345:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 20347:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 20349:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case 20350:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case 20351:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case 20352:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case 20353:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case 20354:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 20355:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 20356:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 20357:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case 20358:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case 20359:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case 20360:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case 20361:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case 20362:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case 20363:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case 20364:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 20365:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 20366:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 20367:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case 20368:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case 20369:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case 20370:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case 20371:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case 20372:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case 20373:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 20374:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 20375:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 20376:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 20377:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 20379:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 20380:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 20381:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 20382:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 20383:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20384:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 20385:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 20386:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 20387:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 20388:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 20389:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20390:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 20391:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 20392:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 20394:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 20397:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case 20398:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case 20399:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case 20400:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case 20401:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case 20402:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 20403:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case 20404:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case 20405:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case 20406:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case 20407:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case 20410:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 20411:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 20412:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 20413:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case 20414:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case 20415:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case 20416:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case 20417:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case 20419:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case 20420:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case 20421:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case 20422:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case 20423:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 20424:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 20425:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 20426:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case 20427:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case 20428:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case 20429:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 20436:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case 20437:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case 20438:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case 20439:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case 20440:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case 20442:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case 20443:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case 20444:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case 20445:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case 20446:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case 20447:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case 20448:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case 20449:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case 20450:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case 20451:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case 20452:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case 20453:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 20454:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 20455:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case 20456:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case 20457:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case 20458:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case 20459:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case 20460:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case 20461:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case 20462:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 20463:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 20464:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 20465:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 20466:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 20467:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case 20468:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 20469:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case 20470:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 20471:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case 20472:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 20473:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case 20477:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 20478:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case 20479:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case 20480:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case 20481:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case 20482:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 20483:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 20484:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 20485:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 20486:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 20487:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case 20488:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 20489:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 20490:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 20491:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 20492:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 20493:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 20494:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 20495:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 20497:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 20499:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 20500:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case 20501:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case 20502:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case 20503:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case 20504:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 20505:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 20506:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 20507:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 20508:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 20509:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case 20510:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case 20511:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 20512:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 20513:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 20514:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 20515:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 20516:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 20517:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 20518:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 20519:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case 20520:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 20521:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 20522:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 20523:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 20524:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 20525:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 20526:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 20527:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 20529:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 20530:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 20531:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 20532:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 20533:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20534:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 20535:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 20536:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 20537:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 20538:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 20539:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20540:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 20541:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 20542:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 20544:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 20547:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 20548:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 20549:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case 20550:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case 20551:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 20552:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 20553:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 20554:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case 20555:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case 20556:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case 20557:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case 20558:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 20559:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 20560:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 20561:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 20562:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 20563:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case 20564:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case 20565:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 20567:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case 20568:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case 20569:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case 20570:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case 20571:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 20572:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 20573:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 20574:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 20575:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 20576:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case 20577:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 20584:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case 20585:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case 20586:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case 20587:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case 20588:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case 20590:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId, true
	case 20591:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType, true
	case 20592:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case 20593:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case 20594:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time, true
	case 20595:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case 20596:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case 20597:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message, true
	case 20598:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity, true
	case 20599:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case 20600:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case 20601:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case 20602:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case 20603:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case 20604:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case 20605:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain, true
	case 20606:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case 20607:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case 20608:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case 20609:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case 20610:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 20611:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 20612:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 20613:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case 20614:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case 20615:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality, true
	case 20616:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 20617:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case 20618:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 20619:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment, true
	case 20620:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 20621:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case 20625:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case 20626:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case 20627:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case 20628:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case 20629:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case 20630:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 20631:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case 20632:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 20633:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case 20634:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case 20635:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case 20636:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case 20637:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case 20638:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case 20639:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 20640:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 20641:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 20642:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 20643:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 20645:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 20647:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case 20648:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case 20649:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case 20650:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case 20651:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case 20652:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 20653:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 20654:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 20655:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case 20656:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case 20657:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case 20658:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case 20659:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case 20660:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case 20661:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case 20662:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 20663:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 20664:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 20665:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case 20666:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case 20667:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case 20668:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case 20669:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case 20670:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case 20671:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 20672:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 20673:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 20674:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 20675:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 20677:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 20678:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 20679:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 20680:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 20681:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20682:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 20683:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 20684:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 20685:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 20686:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 20687:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20688:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 20689:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 20690:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 20692:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 20695:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case 20696:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case 20697:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case 20698:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case 20699:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case 20700:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 20701:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case 20702:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case 20703:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case 20704:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case 20705:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case 20706:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 20707:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 20708:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 20709:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case 20710:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case 20711:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case 20712:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case 20713:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case 20715:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case 20716:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case 20717:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case 20718:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case 20719:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 20720:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 20721:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 20722:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case 20723:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case 20724:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case 20725:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 20732:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case 20733:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case 20734:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case 20735:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case 20736:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case 20738:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case 20739:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case 20740:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case 20741:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case 20742:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case 20743:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case 20744:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case 20745:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case 20746:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case 20747:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case 20748:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case 20749:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 20750:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 20751:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case 20752:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case 20753:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case 20754:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case 20755:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case 20756:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case 20757:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case 20758:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 20759:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 20760:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 20761:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 20762:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 20763:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case 20764:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 20765:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case 20766:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 20767:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case 20768:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 20769:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case 20773:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 20774:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case 20775:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case 20776:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case 20777:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case 20778:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 20779:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 20780:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 20781:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 20782:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 20783:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case 20784:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 20785:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 20786:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 20787:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 20788:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 20789:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 20790:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 20791:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 20793:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 20795:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 20796:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case 20797:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case 20798:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case 20799:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case 20800:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 20801:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 20802:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 20803:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 20804:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 20805:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case 20806:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case 20807:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 20808:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 20809:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 20810:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 20811:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 20812:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 20813:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 20814:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 20815:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case 20816:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 20817:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 20818:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 20819:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 20820:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 20821:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 20822:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 20823:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 20825:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 20826:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 20827:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 20828:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 20829:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20830:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 20831:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 20832:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 20833:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 20834:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 20835:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20836:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 20837:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 20838:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 20840:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 20843:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 20844:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 20845:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case 20846:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case 20847:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 20848:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 20849:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 20850:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case 20851:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case 20852:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case 20853:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case 20854:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 20855:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 20856:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 20857:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 20858:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 20859:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case 20860:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case 20861:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 20863:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case 20864:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case 20865:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case 20866:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case 20867:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 20868:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 20869:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 20870:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 20871:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 20872:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case 20873:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 20880:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case 20881:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case 20882:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case 20883:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case 20884:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case 20886:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case 20887:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case 20888:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case 20889:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case 20890:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time, true
	case 20891:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case 20892:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case 20893:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message, true
	case 20894:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case 20895:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case 20896:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case 20897:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case 20898:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case 20899:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case 20900:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case 20901:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case 20902:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case 20903:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case 20904:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case 20905:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case 20906:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 20907:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 20908:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 20909:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case 20910:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case 20911:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case 20912:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 20913:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case 20914:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 20915:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case 20916:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 20917:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case 20921:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case 20922:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case 20923:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case 20924:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case 20925:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case 20926:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 20927:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case 20928:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 20929:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case 20930:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case 20931:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case 20932:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case 20933:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case 20934:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case 20935:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 20936:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 20937:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 20938:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 20939:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 20941:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 20943:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case 20944:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case 20945:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case 20946:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case 20947:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case 20948:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 20949:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 20950:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 20951:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case 20952:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case 20953:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case 20954:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case 20955:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case 20956:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case 20957:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case 20958:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 20959:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 20960:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 20961:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case 20962:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case 20963:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case 20964:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case 20965:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case 20966:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case 20967:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 20968:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 20969:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 20970:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 20971:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 20973:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 20974:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 20975:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 20976:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 20977:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 20978:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 20979:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 20980:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 20981:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 20982:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 20983:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 20984:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 20985:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 20986:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 20988:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 20991:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case 20992:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case 20993:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case 20994:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case 20995:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case 20996:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 20997:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case 21007:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case 21008:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case 21118:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case 21204:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case 21205:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 21206:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 21207:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 21208:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case 21209:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case 21210:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case 21211:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case 21212:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case 21214:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case 21215:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case 21216:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case 21217:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case 21218:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 21219:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 21220:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 21221:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case 21222:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case 21223:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case 21224:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 21231:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case 21232:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case 21233:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case 21234:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case 21235:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case 21237:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case 21238:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case 21239:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case 21240:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case 21241:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case 21242:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case 21243:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case 21244:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case 21245:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case 21246:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case 21247:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case 21248:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 21249:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 21250:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case 21251:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case 21252:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case 21253:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case 21254:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case 21255:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case 21256:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case 21257:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 21258:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 21259:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 21260:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 21261:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 21262:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case 21263:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 21264:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case 21265:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 21266:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case 21267:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 21268:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case 21272:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 21273:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case 21274:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case 21275:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case 21276:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case 21277:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 21278:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 21279:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 21280:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 21281:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 21282:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case 21283:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 21284:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 21285:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 21286:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 21287:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 21288:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 21289:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 21290:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 21292:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 21294:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 21295:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case 21296:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case 21297:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case 21298:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case 21299:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 21300:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 21301:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 21302:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 21303:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 21304:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case 21305:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case 21306:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 21307:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 21308:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 21309:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 21310:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 21311:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 21312:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 21313:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 21314:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case 21315:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 21316:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 21317:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 21318:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 21319:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 21320:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 21321:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 21322:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 21324:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 21325:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 21326:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 21327:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 21328:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 21329:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 21330:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 21331:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 21332:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 21333:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 21334:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 21335:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 21336:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 21337:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 21339:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 21342:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 21343:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 21344:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case 21345:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case 21346:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 21347:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 21348:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 21349:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case 21350:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case 21351:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case 21352:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case 21353:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 21354:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 21355:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 21356:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 21357:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 21358:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case 21359:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case 21360:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 21362:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case 21363:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case 21364:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case 21365:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case 21366:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 21367:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 21368:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 21369:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 21370:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 21371:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case 21372:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 21379:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case 21380:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case 21381:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case 21382:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case 21383:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UpdateFrequency, true
	case 21385:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId, true
	case 21386:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType, true
	case 21387:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode, true
	case 21388:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName, true
	case 21389:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time, true
	case 21390:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime, true
	case 21391:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LocalTime, true
	case 21392:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message, true
	case 21393:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity, true
	case 21394:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId, true
	case 21395:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName, true
	case 21396:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassId, true
	case 21397:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassName, true
	case 21398:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName, true
	case 21399:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId, true
	case 21400:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain, true
	case 21401:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState, true
	case 21402:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id, true
	case 21403:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Name, true
	case 21404:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Number, true
	case 21405:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 21406:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TransitionTime, true
	case 21407:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 21408:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TrueState, true
	case 21409:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_FalseState, true
	case 21410:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality, true
	case 21411:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp, true
	case 21412:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity, true
	case 21413:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 21414:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment, true
	case 21415:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp, true
	case 21416:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId, true
	case 21420:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments, true
	case 21421:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState, true
	case 21422:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id, true
	case 21423:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Name, true
	case 21424:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Number, true
	case 21425:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 21426:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TransitionTime, true
	case 21427:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 21428:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TrueState, true
	case 21429:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_FalseState, true
	case 21430:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState, true
	case 21431:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id, true
	case 21432:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Name, true
	case 21433:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Number, true
	case 21434:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 21435:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TransitionTime, true
	case 21436:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 21437:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TrueState, true
	case 21438:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_FalseState, true
	case 21440:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments, true
	case 21442:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments, true
	case 21443:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState, true
	case 21444:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id, true
	case 21445:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Name, true
	case 21446:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Number, true
	case 21447:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 21448:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TransitionTime, true
	case 21449:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 21450:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TrueState, true
	case 21451:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_FalseState, true
	case 21452:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode, true
	case 21453:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState, true
	case 21454:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id, true
	case 21455:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Name, true
	case 21456:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Number, true
	case 21457:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 21458:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TransitionTime, true
	case 21459:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 21460:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TrueState, true
	case 21461:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_FalseState, true
	case 21462:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState, true
	case 21463:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id, true
	case 21464:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Name, true
	case 21465:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Number, true
	case 21466:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 21467:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 21468:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 21469:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TrueState, true
	case 21470:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_FalseState, true
	case 21472:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState, true
	case 21473:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 21474:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 21475:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 21476:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 21477:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition, true
	case 21478:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 21479:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 21480:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 21481:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 21482:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 21483:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableStates, true
	case 21484:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 21485:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime, true
	case 21487:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 21490:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved, true
	case 21491:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_MaxTimeShelved, true
	case 21492:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleEnabled, true
	case 21493:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound, true
	case 21494:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_ListId, true
	case 21495:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_AgencyId, true
	case 21496:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_VersionId, true
	case 21497:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState, true
	case 21498:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id, true
	case 21499:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Name, true
	case 21500:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Number, true
	case 21501:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 21502:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TransitionTime, true
	case 21503:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 21504:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TrueState, true
	case 21505:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_FalseState, true
	case 21506:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OnDelay, true
	case 21507:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OffDelay, true
	case 21508:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroupFlag, true
	case 21510:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState, true
	case 21511:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id, true
	case 21512:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Name, true
	case 21513:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Number, true
	case 21514:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 21515:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TransitionTime, true
	case 21516:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 21517:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TrueState, true
	case 21518:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_FalseState, true
	case 21519:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmTime, true
	case 21520:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmRepeatCount, true
	case 21527:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState, true
	case 21528:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate, true
	case 21529:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationLimit, true
	case 21530:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType, true
	case 21531:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate, true
	case 21533:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId, true
	case 21534:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType, true
	case 21535:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode, true
	case 21536:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName, true
	case 21537:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time, true
	case 21538:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime, true
	case 21539:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LocalTime, true
	case 21540:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message, true
	case 21541:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity, true
	case 21542:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId, true
	case 21543:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName, true
	case 21544:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassId, true
	case 21545:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassName, true
	case 21546:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName, true
	case 21547:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId, true
	case 21548:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain, true
	case 21549:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState, true
	case 21550:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id, true
	case 21551:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Name, true
	case 21552:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Number, true
	case 21553:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 21554:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 21555:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 21556:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TrueState, true
	case 21557:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_FalseState, true
	case 21558:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality, true
	case 21559:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 21560:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity, true
	case 21561:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 21562:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment, true
	case 21563:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 21564:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId, true
	case 21568:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments, true
	case 21569:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState, true
	case 21570:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id, true
	case 21571:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Name, true
	case 21572:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Number, true
	case 21573:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 21574:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TransitionTime, true
	case 21575:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 21576:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TrueState, true
	case 21577:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_FalseState, true
	case 21578:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState, true
	case 21579:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id, true
	case 21580:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Name, true
	case 21581:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Number, true
	case 21582:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 21583:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 21584:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 21585:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 21586:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 21588:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 21590:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments, true
	case 21591:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState, true
	case 21592:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id, true
	case 21593:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Name, true
	case 21594:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Number, true
	case 21595:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 21596:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 21597:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 21598:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TrueState, true
	case 21599:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_FalseState, true
	case 21600:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode, true
	case 21601:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState, true
	case 21602:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id, true
	case 21603:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Name, true
	case 21604:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Number, true
	case 21605:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 21606:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 21607:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 21608:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TrueState, true
	case 21609:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_FalseState, true
	case 21610:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState, true
	case 21611:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id, true
	case 21612:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Name, true
	case 21613:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Number, true
	case 21614:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 21615:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 21616:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 21617:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 21618:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 21620:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 21621:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 21622:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 21623:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 21624:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 21625:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 21626:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 21627:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 21628:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 21629:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 21630:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 21631:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 21632:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 21633:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 21635:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 21638:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved, true
	case 21639:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_MaxTimeShelved, true
	case 21640:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleEnabled, true
	case 21641:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound, true
	case 21642:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_ListId, true
	case 21643:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 21644:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_VersionId, true
	case 21645:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState, true
	case 21646:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id, true
	case 21647:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Name, true
	case 21648:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Number, true
	case 21649:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 21650:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 21651:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 21652:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TrueState, true
	case 21653:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_FalseState, true
	case 21654:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OnDelay, true
	case 21655:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OffDelay, true
	case 21656:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroupFlag, true
	case 21658:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState, true
	case 21659:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id, true
	case 21660:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Name, true
	case 21661:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Number, true
	case 21662:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 21663:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 21664:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 21665:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TrueState, true
	case 21666:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_FalseState, true
	case 21667:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmTime, true
	case 21668:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 21675:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState, true
	case 21676:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId, true
	case 21677:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime, true
	case 21678:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency, true
	case 23527:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_GetRejectedList_OutputArguments, true
	case 23530:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments, true
	case 23532:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments, true
	case 23534:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList_OutputArguments, true
	case 23536:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList_OutputArguments, true
	case 23566:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_DefaultValidationOptions, true
	case 23567:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_DefaultValidationOptions, true
	case 23568:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_DefaultValidationOptions, true
	case 23569:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_DefaultValidationOptions, true
	case 23570:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_DefaultValidationOptions, true
	case 24251:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MaxByteStringLength, true
	case 24252:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MaxByteStringLength, true
	case 24253:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MaxByteStringLength, true
	case 24254:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MaxByteStringLength, true
	case 24255:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MaxByteStringLength, true
	case 24489:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Suppress2_InputArguments, true
	case 24491:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Unsuppress2_InputArguments, true
	case 24493:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_RemoveFromService2_InputArguments, true
	case 24495:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_PlaceInService2_InputArguments, true
	case 24497:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Reset2_InputArguments, true
	case 24519:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Suppress2_InputArguments, true
	case 24521:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Unsuppress2_InputArguments, true
	case 24523:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_RemoveFromService2_InputArguments, true
	case 24525:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_PlaceInService2_InputArguments, true
	case 24527:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Reset2_InputArguments, true
	case 24529:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Suppress2_InputArguments, true
	case 24531:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 24533:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 24535:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 24537:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Reset2_InputArguments, true
	case 24539:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments, true
	case 24541:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 24543:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 24545:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 24547:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments, true
	case 24549:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 24551:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 24553:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 24555:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 24557:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 24559:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments, true
	case 24561:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 24563:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 24565:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 24567:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments, true
	case 24569:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 24571:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 24573:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 24575:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 24577:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 24579:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments, true
	case 24581:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 24583:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 24585:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 24587:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments, true
	case 24589:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 24591:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 24593:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 24595:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 24597:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 24599:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2_InputArguments, true
	case 24601:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2_InputArguments, true
	case 24603:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2_InputArguments, true
	case 24605:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2_InputArguments, true
	case 24607:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2_InputArguments, true
	case 24609:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2_InputArguments, true
	case 24611:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 24613:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 24615:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 24617:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2_InputArguments, true
	case 24955:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24957:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24959:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24979:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 24981:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 24983:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 24987:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 24989:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 24991:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 24995:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 24997:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 24999:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 25003:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 25005:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 25007:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 25011:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 25013:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 25015:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 25019:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 25021:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 25023:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 25027:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 25029:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 25031:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 25035:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 25037:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 25039:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 25043:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 25045:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 25047:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 25051:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 25053:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 25055:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 25174:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_GetGroupMemberships_OutputArguments, true
	case 25177:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25178:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 25179:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25180:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 25181:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25182:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 25183:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25184:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 25185:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25186:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 25207:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastModifiedTime, true
	case 25208:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastModifiedTime, true
	case 25209:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastModifiedTime, true
	case 25210:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastModifiedTime, true
	case 25211:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastModifiedTime, true
	case 32031:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassId, true
	case 32032:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionClassName, true
	case 32033:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassId, true
	case 32034:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ConditionSubClassName, true
	case 32242:
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SupportsFilteredRetain, true
	case 32255:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_ActivityTimeout, true
	case 32256:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_ActivityTimeout, true
	case 32257:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_ActivityTimeout, true
	case 32258:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_ActivityTimeout, true
	case 32259:
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_ActivityTimeout, true
	case 32307:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventId, true
	case 32308:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_EventType, true
	case 32309:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceNode, true
	case 32310:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_SourceName, true
	case 32311:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Time, true
	case 32312:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ReceiveTime, true
	case 32313:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_LocalTime, true
	case 32314:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Message, true
	case 32315:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Severity, true
	case 32316:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassId, true
	case 32317:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionClassName, true
	case 32318:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassId, true
	case 32319:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ConditionSubClassName, true
	case 32320:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ActionTimeStamp, true
	case 32321:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_Status, true
	case 32322:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ServerId, true
	case 32323:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientAuditEntryId, true
	case 32324:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_ClientUserId, true
	case 32325:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_MethodId, true
	case 32326:
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdateRequestedAuditEventType_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableCertificateByName(value string) (enum OpcuaNodeIdServicesVariableCertificate, ok bool) {
	switch value {
	case "CertificateUpdatedAuditEventType_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventId, true
	case "CertificateUpdatedAuditEventType_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_EventType, true
	case "CertificateUpdatedAuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceNode, true
	case "CertificateUpdatedAuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_SourceName, true
	case "CertificateUpdatedAuditEventType_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Time, true
	case "CertificateUpdatedAuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ReceiveTime, true
	case "CertificateUpdatedAuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_LocalTime, true
	case "CertificateUpdatedAuditEventType_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Message, true
	case "CertificateUpdatedAuditEventType_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Severity, true
	case "CertificateUpdatedAuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ActionTimeStamp, true
	case "CertificateUpdatedAuditEventType_Status":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_Status, true
	case "CertificateUpdatedAuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ServerId, true
	case "CertificateUpdatedAuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientAuditEntryId, true
	case "CertificateUpdatedAuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_ClientUserId, true
	case "CertificateExpirationAlarmType_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventId, true
	case "CertificateExpirationAlarmType_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EventType, true
	case "CertificateExpirationAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceNode, true
	case "CertificateExpirationAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SourceName, true
	case "CertificateExpirationAlarmType_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Time, true
	case "CertificateExpirationAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReceiveTime, true
	case "CertificateExpirationAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LocalTime, true
	case "CertificateExpirationAlarmType_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Message, true
	case "CertificateExpirationAlarmType_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Severity, true
	case "CertificateExpirationAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassId, true
	case "CertificateExpirationAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionClassName, true
	case "CertificateExpirationAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionName, true
	case "CertificateExpirationAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_BranchId, true
	case "CertificateExpirationAlarmType_Retain":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Retain, true
	case "CertificateExpirationAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState, true
	case "CertificateExpirationAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Id, true
	case "CertificateExpirationAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Name, true
	case "CertificateExpirationAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_Number, true
	case "CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TransitionTime, true
	case "CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_TrueState, true
	case "CertificateExpirationAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_EnabledState_FalseState, true
	case "CertificateExpirationAlarmType_Quality":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality, true
	case "CertificateExpirationAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Quality_SourceTimestamp, true
	case "CertificateExpirationAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity, true
	case "CertificateExpirationAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LastSeverity_SourceTimestamp, true
	case "CertificateExpirationAlarmType_Comment":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment, true
	case "CertificateExpirationAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Comment_SourceTimestamp, true
	case "CertificateExpirationAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ClientUserId, true
	case "CertificateExpirationAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AddComment_InputArguments, true
	case "CertificateExpirationAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh_InputArguments, true
	case "CertificateExpirationAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionRefresh2_InputArguments, true
	case "CertificateExpirationAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState, true
	case "CertificateExpirationAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Id, true
	case "CertificateExpirationAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Name, true
	case "CertificateExpirationAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_Number, true
	case "CertificateExpirationAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TransitionTime, true
	case "CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_TrueState, true
	case "CertificateExpirationAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AckedState_FalseState, true
	case "CertificateExpirationAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState, true
	case "CertificateExpirationAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Id, true
	case "CertificateExpirationAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Name, true
	case "CertificateExpirationAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_Number, true
	case "CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TransitionTime, true
	case "CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_TrueState, true
	case "CertificateExpirationAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConfirmedState_FalseState, true
	case "CertificateExpirationAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Acknowledge_InputArguments, true
	case "CertificateExpirationAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Confirm_InputArguments, true
	case "CertificateExpirationAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState, true
	case "CertificateExpirationAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Id, true
	case "CertificateExpirationAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Name, true
	case "CertificateExpirationAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_Number, true
	case "CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TransitionTime, true
	case "CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_TrueState, true
	case "CertificateExpirationAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ActiveState_FalseState, true
	case "CertificateExpirationAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_InputNode, true
	case "CertificateExpirationAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState, true
	case "CertificateExpirationAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Id, true
	case "CertificateExpirationAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Name, true
	case "CertificateExpirationAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_Number, true
	case "CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TransitionTime, true
	case "CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_TrueState, true
	case "CertificateExpirationAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedState_FalseState, true
	case "CertificateExpirationAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState, true
	case "CertificateExpirationAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Id, true
	case "CertificateExpirationAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Name, true
	case "CertificateExpirationAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_Number, true
	case "CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Id, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Name, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_Number, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_UnshelveTime, true
	case "CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "CertificateExpirationAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SuppressedOrShelved, true
	case "CertificateExpirationAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_MaxTimeShelved, true
	case "CertificateExpirationAlarmType_NormalState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_NormalState, true
	case "CertificateExpirationAlarmType_ExpirationDate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationDate, true
	case "CertificateExpirationAlarmType_CertificateType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_CertificateType, true
	case "CertificateExpirationAlarmType_Certificate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_Certificate, true
	case "CertificateGroupType_TrustList_Size":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Size, true
	case "CertificateGroupType_TrustList_Writable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Writable, true
	case "CertificateGroupType_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UserWritable, true
	case "CertificateGroupType_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenCount, true
	case "CertificateGroupType_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_MimeType, true
	case "CertificateGroupType_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_InputArguments, true
	case "CertificateGroupType_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Open_OutputArguments, true
	case "CertificateGroupType_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Close_InputArguments, true
	case "CertificateGroupType_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_InputArguments, true
	case "CertificateGroupType_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Read_OutputArguments, true
	case "CertificateGroupType_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_Write_InputArguments, true
	case "CertificateGroupType_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_InputArguments, true
	case "CertificateGroupType_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_GetPosition_OutputArguments, true
	case "CertificateGroupType_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_SetPosition_InputArguments, true
	case "CertificateGroupType_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_LastUpdateTime, true
	case "CertificateGroupType_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_InputArguments, true
	case "CertificateGroupType_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_OpenWithMasks_OutputArguments, true
	case "CertificateGroupType_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_InputArguments, true
	case "CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments, true
	case "CertificateGroupType_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_AddCertificate_InputArguments, true
	case "CertificateGroupType_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_RemoveCertificate_InputArguments, true
	case "CertificateGroupType_CertificateTypes":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateTypes, true
	case "CertificateUpdatedAuditEventType_CertificateGroup":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateGroup, true
	case "CertificateUpdatedAuditEventType_CertificateType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateUpdatedAuditEventType_CertificateType, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes, true
	case "CertificateExpirationAlarmType_ExpirationLimit":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ExpirationLimit, true
	case "CertificateExpirationAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassId, true
	case "CertificateExpirationAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ConditionSubClassName, true
	case "CertificateExpirationAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState, true
	case "CertificateExpirationAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Id, true
	case "CertificateExpirationAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Name, true
	case "CertificateExpirationAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_Number, true
	case "CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TransitionTime, true
	case "CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_TrueState, true
	case "CertificateExpirationAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OutOfServiceState_FalseState, true
	case "CertificateExpirationAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState, true
	case "CertificateExpirationAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Id, true
	case "CertificateExpirationAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Name, true
	case "CertificateExpirationAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_Number, true
	case "CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TransitionTime, true
	case "CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_TrueState, true
	case "CertificateExpirationAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_SilenceState_FalseState, true
	case "CertificateExpirationAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleEnabled, true
	case "CertificateExpirationAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound, true
	case "CertificateExpirationAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OnDelay, true
	case "CertificateExpirationAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_OffDelay, true
	case "CertificateExpirationAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_FirstInGroupFlag, true
	case "CertificateExpirationAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmTime, true
	case "CertificateExpirationAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ReAlarmRepeatCount, true
	case "CertificateExpirationAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableStates, true
	case "CertificateExpirationAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_ShelvingState_AvailableTransitions, true
	case "CertificateExpirationAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_ListId, true
	case "CertificateExpirationAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_AgencyId, true
	case "CertificateExpirationAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_AudibleSound_VersionId, true
	case "CertificateExpirationAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState, true
	case "CertificateExpirationAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Id, true
	case "CertificateExpirationAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Name, true
	case "CertificateExpirationAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_Number, true
	case "CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName, true
	case "CertificateExpirationAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TransitionTime, true
	case "CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime, true
	case "CertificateExpirationAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_TrueState, true
	case "CertificateExpirationAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateExpirationAlarmType_LatchedState_FalseState, true
	case "CertificateGroupType_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustList_UpdateFrequency, true
	case "CertificateGroupType_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventId, true
	case "CertificateGroupType_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EventType, true
	case "CertificateGroupType_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceNode, true
	case "CertificateGroupType_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SourceName, true
	case "CertificateGroupType_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Time, true
	case "CertificateGroupType_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReceiveTime, true
	case "CertificateGroupType_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LocalTime, true
	case "CertificateGroupType_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Message, true
	case "CertificateGroupType_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Severity, true
	case "CertificateGroupType_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassId, true
	case "CertificateGroupType_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionClassName, true
	case "CertificateGroupType_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassId, true
	case "CertificateGroupType_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionSubClassName, true
	case "CertificateGroupType_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConditionName, true
	case "CertificateGroupType_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_BranchId, true
	case "CertificateGroupType_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Retain, true
	case "CertificateGroupType_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState, true
	case "CertificateGroupType_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Id, true
	case "CertificateGroupType_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Name, true
	case "CertificateGroupType_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_Number, true
	case "CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_TrueState, true
	case "CertificateGroupType_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_EnabledState_FalseState, true
	case "CertificateGroupType_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality, true
	case "CertificateGroupType_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Quality_SourceTimestamp, true
	case "CertificateGroupType_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity, true
	case "CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "CertificateGroupType_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment, true
	case "CertificateGroupType_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Comment_SourceTimestamp, true
	case "CertificateGroupType_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ClientUserId, true
	case "CertificateGroupType_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AddComment_InputArguments, true
	case "CertificateGroupType_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState, true
	case "CertificateGroupType_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Id, true
	case "CertificateGroupType_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Name, true
	case "CertificateGroupType_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_Number, true
	case "CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_TrueState, true
	case "CertificateGroupType_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AckedState_FalseState, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Id, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Name, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_Number, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_TrueState, true
	case "CertificateGroupType_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ConfirmedState_FalseState, true
	case "CertificateGroupType_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Acknowledge_InputArguments, true
	case "CertificateGroupType_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Confirm_InputArguments, true
	case "CertificateGroupType_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState, true
	case "CertificateGroupType_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Id, true
	case "CertificateGroupType_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Name, true
	case "CertificateGroupType_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_Number, true
	case "CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_TrueState, true
	case "CertificateGroupType_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ActiveState_FalseState, true
	case "CertificateGroupType_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_InputNode, true
	case "CertificateGroupType_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Id, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Name, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_Number, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_TrueState, true
	case "CertificateGroupType_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedState_FalseState, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Id, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Name, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_Number, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState, true
	case "CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime, true
	case "CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "CertificateGroupType_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SuppressedOrShelved, true
	case "CertificateGroupType_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_MaxTimeShelved, true
	case "CertificateGroupType_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleEnabled, true
	case "CertificateGroupType_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound, true
	case "CertificateGroupType_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_ListId, true
	case "CertificateGroupType_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_AgencyId, true
	case "CertificateGroupType_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_AudibleSound_VersionId, true
	case "CertificateGroupType_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState, true
	case "CertificateGroupType_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Id, true
	case "CertificateGroupType_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Name, true
	case "CertificateGroupType_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_Number, true
	case "CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_TrueState, true
	case "CertificateGroupType_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_SilenceState_FalseState, true
	case "CertificateGroupType_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OnDelay, true
	case "CertificateGroupType_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_OffDelay, true
	case "CertificateGroupType_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_FirstInGroupFlag, true
	case "CertificateGroupType_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState, true
	case "CertificateGroupType_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Id, true
	case "CertificateGroupType_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Name, true
	case "CertificateGroupType_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_Number, true
	case "CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "CertificateGroupType_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TransitionTime, true
	case "CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "CertificateGroupType_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_TrueState, true
	case "CertificateGroupType_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_LatchedState_FalseState, true
	case "CertificateGroupType_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmTime, true
	case "CertificateGroupType_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ReAlarmRepeatCount, true
	case "CertificateGroupType_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_NormalState, true
	case "CertificateGroupType_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationDate, true
	case "CertificateGroupType_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_ExpirationLimit, true
	case "CertificateGroupType_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_CertificateType, true
	case "CertificateGroupType_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_CertificateExpired_Certificate, true
	case "CertificateGroupType_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventId, true
	case "CertificateGroupType_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EventType, true
	case "CertificateGroupType_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceNode, true
	case "CertificateGroupType_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SourceName, true
	case "CertificateGroupType_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Time, true
	case "CertificateGroupType_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReceiveTime, true
	case "CertificateGroupType_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LocalTime, true
	case "CertificateGroupType_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Message, true
	case "CertificateGroupType_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Severity, true
	case "CertificateGroupType_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassId, true
	case "CertificateGroupType_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionClassName, true
	case "CertificateGroupType_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassId, true
	case "CertificateGroupType_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionSubClassName, true
	case "CertificateGroupType_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConditionName, true
	case "CertificateGroupType_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_BranchId, true
	case "CertificateGroupType_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Retain, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality, true
	case "CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "CertificateGroupType_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity, true
	case "CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "CertificateGroupType_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment, true
	case "CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "CertificateGroupType_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ClientUserId, true
	case "CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AckedState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_InputNode, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved, true
	case "CertificateGroupType_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_MaxTimeShelved, true
	case "CertificateGroupType_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleEnabled, true
	case "CertificateGroupType_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound, true
	case "CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId, true
	case "CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OnDelay, true
	case "CertificateGroupType_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_OffDelay, true
	case "CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Id, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Name, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_Number, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState, true
	case "CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState, true
	case "CertificateGroupType_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmTime, true
	case "CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "CertificateGroupType_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_NormalState, true
	case "CertificateGroupType_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_TrustListId, true
	case "CertificateGroupType_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_LastUpdateTime, true
	case "CertificateGroupType_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupType_TrustListOutOfDate_UpdateFrequency, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableCertificate_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime":
		ret