/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAudit is an enum
type OpcuaNodeIdServicesVariableAudit int32

type IOpcuaNodeIdServicesVariableAudit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp                               OpcuaNodeIdServicesVariableAudit = 2053
	OpcuaNodeIdServicesVariableAudit_AuditEventType_Status                                        OpcuaNodeIdServicesVariableAudit = 2054
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId                                      OpcuaNodeIdServicesVariableAudit = 2055
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId                            OpcuaNodeIdServicesVariableAudit = 2056
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId                                  OpcuaNodeIdServicesVariableAudit = 2057
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate            OpcuaNodeIdServicesVariableAudit = 2061
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType                  OpcuaNodeIdServicesVariableAudit = 2062
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri            OpcuaNodeIdServicesVariableAudit = 2063
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode                 OpcuaNodeIdServicesVariableAudit = 2065
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime            OpcuaNodeIdServicesVariableAudit = 2066
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId                              OpcuaNodeIdServicesVariableAudit = 2070
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId                  OpcuaNodeIdServicesVariableAudit = 2072
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate                OpcuaNodeIdServicesVariableAudit = 2073
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout            OpcuaNodeIdServicesVariableAudit = 2074
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates     OpcuaNodeIdServicesVariableAudit = 2076
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken              OpcuaNodeIdServicesVariableAudit = 2077
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle                           OpcuaNodeIdServicesVariableAudit = 2079
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate                        OpcuaNodeIdServicesVariableAudit = 2081
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname        OpcuaNodeIdServicesVariableAudit = 2083
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri             OpcuaNodeIdServicesVariableAudit = 2084
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd                            OpcuaNodeIdServicesVariableAudit = 2092
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete                      OpcuaNodeIdServicesVariableAudit = 2094
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd                  OpcuaNodeIdServicesVariableAudit = 2096
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete            OpcuaNodeIdServicesVariableAudit = 2098
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange                         OpcuaNodeIdServicesVariableAudit = 2101
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue                           OpcuaNodeIdServicesVariableAudit = 2102
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue                           OpcuaNodeIdServicesVariableAudit = 2103
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId                          OpcuaNodeIdServicesVariableAudit = 2128
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments                    OpcuaNodeIdServicesVariableAudit = 2129
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId                        OpcuaNodeIdServicesVariableAudit = 2745
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint  OpcuaNodeIdServicesVariableAudit = 2746
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint      OpcuaNodeIdServicesVariableAudit = 2747
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl                        OpcuaNodeIdServicesVariableAudit = 2749
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId                        OpcuaNodeIdServicesVariableAudit = 2750
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId              OpcuaNodeIdServicesVariableAudit = 2751
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId                         OpcuaNodeIdServicesVariableAudit = 2777
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId                         OpcuaNodeIdServicesVariableAudit = 2778
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter                      OpcuaNodeIdServicesVariableAudit = 3003
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified        OpcuaNodeIdServicesVariableAudit = 3015
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime               OpcuaNodeIdServicesVariableAudit = 3016
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime                 OpcuaNodeIdServicesVariableAudit = 3017
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes                   OpcuaNodeIdServicesVariableAudit = 3020
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues                  OpcuaNodeIdServicesVariableAudit = 3021
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds                    OpcuaNodeIdServicesVariableAudit = 3023
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues                   OpcuaNodeIdServicesVariableAudit = 3024
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode                 OpcuaNodeIdServicesVariableAudit = 3025
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode                 OpcuaNodeIdServicesVariableAudit = 3026
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode                      OpcuaNodeIdServicesVariableAudit = 3027
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace        OpcuaNodeIdServicesVariableAudit = 3028
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues                   OpcuaNodeIdServicesVariableAudit = 3029
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues                   OpcuaNodeIdServicesVariableAudit = 3030
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace        OpcuaNodeIdServicesVariableAudit = 3031
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues                   OpcuaNodeIdServicesVariableAudit = 3032
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues                   OpcuaNodeIdServicesVariableAudit = 3033
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues               OpcuaNodeIdServicesVariableAudit = 3034
	OpcuaNodeIdServicesVariableAudit_AuditEventType_EventId                                       OpcuaNodeIdServicesVariableAudit = 3200
	OpcuaNodeIdServicesVariableAudit_AuditEventType_EventType                                     OpcuaNodeIdServicesVariableAudit = 3201
	OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceNode                                    OpcuaNodeIdServicesVariableAudit = 3202
	OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceName                                    OpcuaNodeIdServicesVariableAudit = 3203
	OpcuaNodeIdServicesVariableAudit_AuditEventType_Time                                          OpcuaNodeIdServicesVariableAudit = 3204
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ReceiveTime                                   OpcuaNodeIdServicesVariableAudit = 3205
	OpcuaNodeIdServicesVariableAudit_AuditEventType_LocalTime                                     OpcuaNodeIdServicesVariableAudit = 3206
	OpcuaNodeIdServicesVariableAudit_AuditEventType_Message                                       OpcuaNodeIdServicesVariableAudit = 3207
	OpcuaNodeIdServicesVariableAudit_AuditEventType_Severity                                      OpcuaNodeIdServicesVariableAudit = 3208
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventId                               OpcuaNodeIdServicesVariableAudit = 3209
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventType                             OpcuaNodeIdServicesVariableAudit = 3210
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceNode                            OpcuaNodeIdServicesVariableAudit = 3211
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceName                            OpcuaNodeIdServicesVariableAudit = 3212
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Time                                  OpcuaNodeIdServicesVariableAudit = 3213
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ReceiveTime                           OpcuaNodeIdServicesVariableAudit = 3214
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_LocalTime                             OpcuaNodeIdServicesVariableAudit = 3215
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Message                               OpcuaNodeIdServicesVariableAudit = 3216
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Severity                              OpcuaNodeIdServicesVariableAudit = 3217
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ActionTimeStamp                       OpcuaNodeIdServicesVariableAudit = 3218
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Status                                OpcuaNodeIdServicesVariableAudit = 3219
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ServerId                              OpcuaNodeIdServicesVariableAudit = 3220
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientAuditEntryId                    OpcuaNodeIdServicesVariableAudit = 3221
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientUserId                          OpcuaNodeIdServicesVariableAudit = 3222
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventId                                OpcuaNodeIdServicesVariableAudit = 3223
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventType                              OpcuaNodeIdServicesVariableAudit = 3224
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceNode                             OpcuaNodeIdServicesVariableAudit = 3225
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceName                             OpcuaNodeIdServicesVariableAudit = 3226
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Time                                   OpcuaNodeIdServicesVariableAudit = 3227
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ReceiveTime                            OpcuaNodeIdServicesVariableAudit = 3228
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_LocalTime                              OpcuaNodeIdServicesVariableAudit = 3229
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Message                                OpcuaNodeIdServicesVariableAudit = 3230
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Severity                               OpcuaNodeIdServicesVariableAudit = 3231
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ActionTimeStamp                        OpcuaNodeIdServicesVariableAudit = 3232
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Status                                 OpcuaNodeIdServicesVariableAudit = 3233
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ServerId                               OpcuaNodeIdServicesVariableAudit = 3234
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientAuditEntryId                     OpcuaNodeIdServicesVariableAudit = 3235
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientUserId                           OpcuaNodeIdServicesVariableAudit = 3236
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventId                      OpcuaNodeIdServicesVariableAudit = 3237
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventType                    OpcuaNodeIdServicesVariableAudit = 3238
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceNode                   OpcuaNodeIdServicesVariableAudit = 3239
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceName                   OpcuaNodeIdServicesVariableAudit = 3240
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Time                         OpcuaNodeIdServicesVariableAudit = 3241
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ReceiveTime                  OpcuaNodeIdServicesVariableAudit = 3242
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_LocalTime                    OpcuaNodeIdServicesVariableAudit = 3243
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Message                      OpcuaNodeIdServicesVariableAudit = 3244
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Severity                     OpcuaNodeIdServicesVariableAudit = 3245
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ActionTimeStamp              OpcuaNodeIdServicesVariableAudit = 3246
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Status                       OpcuaNodeIdServicesVariableAudit = 3247
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ServerId                     OpcuaNodeIdServicesVariableAudit = 3248
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientAuditEntryId           OpcuaNodeIdServicesVariableAudit = 3249
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientUserId                 OpcuaNodeIdServicesVariableAudit = 3250
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecureChannelId              OpcuaNodeIdServicesVariableAudit = 3251
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventId                                OpcuaNodeIdServicesVariableAudit = 3252
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventType                              OpcuaNodeIdServicesVariableAudit = 3253
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceNode                             OpcuaNodeIdServicesVariableAudit = 3254
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceName                             OpcuaNodeIdServicesVariableAudit = 3255
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Time                                   OpcuaNodeIdServicesVariableAudit = 3256
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ReceiveTime                            OpcuaNodeIdServicesVariableAudit = 3257
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_LocalTime                              OpcuaNodeIdServicesVariableAudit = 3258
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Message                                OpcuaNodeIdServicesVariableAudit = 3259
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Severity                               OpcuaNodeIdServicesVariableAudit = 3260
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ActionTimeStamp                        OpcuaNodeIdServicesVariableAudit = 3261
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Status                                 OpcuaNodeIdServicesVariableAudit = 3262
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ServerId                               OpcuaNodeIdServicesVariableAudit = 3263
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientAuditEntryId                     OpcuaNodeIdServicesVariableAudit = 3264
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientUserId                           OpcuaNodeIdServicesVariableAudit = 3265
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventId                          OpcuaNodeIdServicesVariableAudit = 3266
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventType                        OpcuaNodeIdServicesVariableAudit = 3267
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceNode                       OpcuaNodeIdServicesVariableAudit = 3268
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceName                       OpcuaNodeIdServicesVariableAudit = 3269
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Time                             OpcuaNodeIdServicesVariableAudit = 3270
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ReceiveTime                      OpcuaNodeIdServicesVariableAudit = 3271
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_LocalTime                        OpcuaNodeIdServicesVariableAudit = 3272
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Message                          OpcuaNodeIdServicesVariableAudit = 3273
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Severity                         OpcuaNodeIdServicesVariableAudit = 3274
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ActionTimeStamp                  OpcuaNodeIdServicesVariableAudit = 3275
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Status                           OpcuaNodeIdServicesVariableAudit = 3276
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ServerId                         OpcuaNodeIdServicesVariableAudit = 3277
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientAuditEntryId               OpcuaNodeIdServicesVariableAudit = 3278
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientUserId                     OpcuaNodeIdServicesVariableAudit = 3279
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventId                            OpcuaNodeIdServicesVariableAudit = 3281
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventType                          OpcuaNodeIdServicesVariableAudit = 3282
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceNode                         OpcuaNodeIdServicesVariableAudit = 3283
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceName                         OpcuaNodeIdServicesVariableAudit = 3284
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Time                               OpcuaNodeIdServicesVariableAudit = 3285
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ReceiveTime                        OpcuaNodeIdServicesVariableAudit = 3286
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_LocalTime                          OpcuaNodeIdServicesVariableAudit = 3287
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Message                            OpcuaNodeIdServicesVariableAudit = 3288
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Severity                           OpcuaNodeIdServicesVariableAudit = 3289
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ActionTimeStamp                    OpcuaNodeIdServicesVariableAudit = 3290
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Status                             OpcuaNodeIdServicesVariableAudit = 3291
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ServerId                           OpcuaNodeIdServicesVariableAudit = 3292
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientAuditEntryId                 OpcuaNodeIdServicesVariableAudit = 3293
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientUserId                       OpcuaNodeIdServicesVariableAudit = 3294
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SecureChannelId                    OpcuaNodeIdServicesVariableAudit = 3296
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificate                  OpcuaNodeIdServicesVariableAudit = 3297
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificateThumbprint        OpcuaNodeIdServicesVariableAudit = 3298
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_RevisedSessionTimeout              OpcuaNodeIdServicesVariableAudit = 3299
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventId                        OpcuaNodeIdServicesVariableAudit = 3300
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventType                      OpcuaNodeIdServicesVariableAudit = 3301
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceNode                     OpcuaNodeIdServicesVariableAudit = 3302
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceName                     OpcuaNodeIdServicesVariableAudit = 3303
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Time                           OpcuaNodeIdServicesVariableAudit = 3304
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ReceiveTime                    OpcuaNodeIdServicesVariableAudit = 3305
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_LocalTime                      OpcuaNodeIdServicesVariableAudit = 3306
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Message                        OpcuaNodeIdServicesVariableAudit = 3307
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Severity                       OpcuaNodeIdServicesVariableAudit = 3308
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ActionTimeStamp                OpcuaNodeIdServicesVariableAudit = 3309
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Status                         OpcuaNodeIdServicesVariableAudit = 3310
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ServerId                       OpcuaNodeIdServicesVariableAudit = 3311
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientAuditEntryId             OpcuaNodeIdServicesVariableAudit = 3312
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientUserId                   OpcuaNodeIdServicesVariableAudit = 3313
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SessionId                      OpcuaNodeIdServicesVariableAudit = 3314
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventId                                 OpcuaNodeIdServicesVariableAudit = 3315
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventType                               OpcuaNodeIdServicesVariableAudit = 3316
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceNode                              OpcuaNodeIdServicesVariableAudit = 3317
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceName                              OpcuaNodeIdServicesVariableAudit = 3318
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Time                                    OpcuaNodeIdServicesVariableAudit = 3319
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ReceiveTime                             OpcuaNodeIdServicesVariableAudit = 3320
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_LocalTime                               OpcuaNodeIdServicesVariableAudit = 3321
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Message                                 OpcuaNodeIdServicesVariableAudit = 3322
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Severity                                OpcuaNodeIdServicesVariableAudit = 3323
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ActionTimeStamp                         OpcuaNodeIdServicesVariableAudit = 3324
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Status                                  OpcuaNodeIdServicesVariableAudit = 3325
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ServerId                                OpcuaNodeIdServicesVariableAudit = 3326
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientAuditEntryId                      OpcuaNodeIdServicesVariableAudit = 3327
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientUserId                            OpcuaNodeIdServicesVariableAudit = 3328
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SessionId                               OpcuaNodeIdServicesVariableAudit = 3329
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventId                            OpcuaNodeIdServicesVariableAudit = 3330
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventType                          OpcuaNodeIdServicesVariableAudit = 3331
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceNode                         OpcuaNodeIdServicesVariableAudit = 3332
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceName                         OpcuaNodeIdServicesVariableAudit = 3333
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Time                               OpcuaNodeIdServicesVariableAudit = 3334
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ReceiveTime                        OpcuaNodeIdServicesVariableAudit = 3335
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_LocalTime                          OpcuaNodeIdServicesVariableAudit = 3336
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Message                            OpcuaNodeIdServicesVariableAudit = 3337
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Severity                           OpcuaNodeIdServicesVariableAudit = 3338
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ActionTimeStamp                    OpcuaNodeIdServicesVariableAudit = 3339
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Status                             OpcuaNodeIdServicesVariableAudit = 3340
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ServerId                           OpcuaNodeIdServicesVariableAudit = 3341
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientAuditEntryId                 OpcuaNodeIdServicesVariableAudit = 3342
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientUserId                       OpcuaNodeIdServicesVariableAudit = 3343
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventId                OpcuaNodeIdServicesVariableAudit = 3344
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventType              OpcuaNodeIdServicesVariableAudit = 3345
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceNode             OpcuaNodeIdServicesVariableAudit = 3346
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceName             OpcuaNodeIdServicesVariableAudit = 3347
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Time                   OpcuaNodeIdServicesVariableAudit = 3348
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ReceiveTime            OpcuaNodeIdServicesVariableAudit = 3349
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_LocalTime              OpcuaNodeIdServicesVariableAudit = 3350
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Message                OpcuaNodeIdServicesVariableAudit = 3351
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Severity               OpcuaNodeIdServicesVariableAudit = 3352
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ActionTimeStamp        OpcuaNodeIdServicesVariableAudit = 3353
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Status                 OpcuaNodeIdServicesVariableAudit = 3354
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ServerId               OpcuaNodeIdServicesVariableAudit = 3355
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientAuditEntryId     OpcuaNodeIdServicesVariableAudit = 3356
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientUserId           OpcuaNodeIdServicesVariableAudit = 3357
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Certificate            OpcuaNodeIdServicesVariableAudit = 3358
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3359
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3360
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3361
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3362
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3363
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3364
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3365
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3366
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3367
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3368
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3369
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3370
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3371
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3372
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Certificate                 OpcuaNodeIdServicesVariableAudit = 3373
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3374
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3375
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3376
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3377
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3378
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3379
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3380
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3381
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3382
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3383
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3384
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3385
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3386
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3387
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Certificate                 OpcuaNodeIdServicesVariableAudit = 3388
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventId                   OpcuaNodeIdServicesVariableAudit = 3389
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventType                 OpcuaNodeIdServicesVariableAudit = 3390
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceNode                OpcuaNodeIdServicesVariableAudit = 3391
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceName                OpcuaNodeIdServicesVariableAudit = 3392
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Time                      OpcuaNodeIdServicesVariableAudit = 3393
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ReceiveTime               OpcuaNodeIdServicesVariableAudit = 3394
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_LocalTime                 OpcuaNodeIdServicesVariableAudit = 3395
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Message                   OpcuaNodeIdServicesVariableAudit = 3396
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Severity                  OpcuaNodeIdServicesVariableAudit = 3397
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ActionTimeStamp           OpcuaNodeIdServicesVariableAudit = 3398
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Status                    OpcuaNodeIdServicesVariableAudit = 3399
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ServerId                  OpcuaNodeIdServicesVariableAudit = 3400
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientAuditEntryId        OpcuaNodeIdServicesVariableAudit = 3401
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientUserId              OpcuaNodeIdServicesVariableAudit = 3402
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Certificate               OpcuaNodeIdServicesVariableAudit = 3403
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3404
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3405
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3406
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3407
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3408
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3409
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3410
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3411
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3412
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3413
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3414
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3415
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3416
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3417
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Certificate                 OpcuaNodeIdServicesVariableAudit = 3418
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventId                    OpcuaNodeIdServicesVariableAudit = 3419
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventType                  OpcuaNodeIdServicesVariableAudit = 3420
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceNode                 OpcuaNodeIdServicesVariableAudit = 3421
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceName                 OpcuaNodeIdServicesVariableAudit = 3422
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Time                       OpcuaNodeIdServicesVariableAudit = 3423
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ReceiveTime                OpcuaNodeIdServicesVariableAudit = 3424
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_LocalTime                  OpcuaNodeIdServicesVariableAudit = 3425
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Message                    OpcuaNodeIdServicesVariableAudit = 3426
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Severity                   OpcuaNodeIdServicesVariableAudit = 3427
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ActionTimeStamp            OpcuaNodeIdServicesVariableAudit = 3428
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Status                     OpcuaNodeIdServicesVariableAudit = 3429
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ServerId                   OpcuaNodeIdServicesVariableAudit = 3430
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientAuditEntryId         OpcuaNodeIdServicesVariableAudit = 3431
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientUserId               OpcuaNodeIdServicesVariableAudit = 3432
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Certificate                OpcuaNodeIdServicesVariableAudit = 3433
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventId                         OpcuaNodeIdServicesVariableAudit = 3434
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventType                       OpcuaNodeIdServicesVariableAudit = 3435
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceNode                      OpcuaNodeIdServicesVariableAudit = 3436
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceName                      OpcuaNodeIdServicesVariableAudit = 3437
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Time                            OpcuaNodeIdServicesVariableAudit = 3438
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ReceiveTime                     OpcuaNodeIdServicesVariableAudit = 3439
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_LocalTime                       OpcuaNodeIdServicesVariableAudit = 3440
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Message                         OpcuaNodeIdServicesVariableAudit = 3441
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Severity                        OpcuaNodeIdServicesVariableAudit = 3442
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ActionTimeStamp                 OpcuaNodeIdServicesVariableAudit = 3443
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Status                          OpcuaNodeIdServicesVariableAudit = 3444
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ServerId                        OpcuaNodeIdServicesVariableAudit = 3445
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientAuditEntryId              OpcuaNodeIdServicesVariableAudit = 3446
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientUserId                    OpcuaNodeIdServicesVariableAudit = 3447
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventId                               OpcuaNodeIdServicesVariableAudit = 3448
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventType                             OpcuaNodeIdServicesVariableAudit = 3449
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceNode                            OpcuaNodeIdServicesVariableAudit = 3450
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceName                            OpcuaNodeIdServicesVariableAudit = 3451
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Time                                  OpcuaNodeIdServicesVariableAudit = 3452
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ReceiveTime                           OpcuaNodeIdServicesVariableAudit = 3453
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_LocalTime                             OpcuaNodeIdServicesVariableAudit = 3454
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Message                               OpcuaNodeIdServicesVariableAudit = 3455
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Severity                              OpcuaNodeIdServicesVariableAudit = 3456
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ActionTimeStamp                       OpcuaNodeIdServicesVariableAudit = 3457
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Status                                OpcuaNodeIdServicesVariableAudit = 3458
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ServerId                              OpcuaNodeIdServicesVariableAudit = 3459
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientAuditEntryId                    OpcuaNodeIdServicesVariableAudit = 3460
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientUserId                          OpcuaNodeIdServicesVariableAudit = 3461
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventId                            OpcuaNodeIdServicesVariableAudit = 3462
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventType                          OpcuaNodeIdServicesVariableAudit = 3463
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceNode                         OpcuaNodeIdServicesVariableAudit = 3464
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceName                         OpcuaNodeIdServicesVariableAudit = 3465
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Time                               OpcuaNodeIdServicesVariableAudit = 3466
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ReceiveTime                        OpcuaNodeIdServicesVariableAudit = 3467
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_LocalTime                          OpcuaNodeIdServicesVariableAudit = 3468
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Message                            OpcuaNodeIdServicesVariableAudit = 3469
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Severity                           OpcuaNodeIdServicesVariableAudit = 3470
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ActionTimeStamp                    OpcuaNodeIdServicesVariableAudit = 3471
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Status                             OpcuaNodeIdServicesVariableAudit = 3472
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ServerId                           OpcuaNodeIdServicesVariableAudit = 3473
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientAuditEntryId                 OpcuaNodeIdServicesVariableAudit = 3474
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientUserId                       OpcuaNodeIdServicesVariableAudit = 3475
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventId                          OpcuaNodeIdServicesVariableAudit = 3476
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventType                        OpcuaNodeIdServicesVariableAudit = 3477
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceNode                       OpcuaNodeIdServicesVariableAudit = 3478
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceName                       OpcuaNodeIdServicesVariableAudit = 3479
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Time                             OpcuaNodeIdServicesVariableAudit = 3480
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReceiveTime                      OpcuaNodeIdServicesVariableAudit = 3481
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_LocalTime                        OpcuaNodeIdServicesVariableAudit = 3482
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Message                          OpcuaNodeIdServicesVariableAudit = 3483
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Severity                         OpcuaNodeIdServicesVariableAudit = 3484
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ActionTimeStamp                  OpcuaNodeIdServicesVariableAudit = 3485
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Status                           OpcuaNodeIdServicesVariableAudit = 3486
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ServerId                         OpcuaNodeIdServicesVariableAudit = 3487
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientAuditEntryId               OpcuaNodeIdServicesVariableAudit = 3488
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientUserId                     OpcuaNodeIdServicesVariableAudit = 3489
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventId                       OpcuaNodeIdServicesVariableAudit = 3490
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventType                     OpcuaNodeIdServicesVariableAudit = 3491
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceNode                    OpcuaNodeIdServicesVariableAudit = 3492
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceName                    OpcuaNodeIdServicesVariableAudit = 3493
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Time                          OpcuaNodeIdServicesVariableAudit = 3494
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReceiveTime                   OpcuaNodeIdServicesVariableAudit = 3495
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_LocalTime                     OpcuaNodeIdServicesVariableAudit = 3496
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Message                       OpcuaNodeIdServicesVariableAudit = 3497
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Severity                      OpcuaNodeIdServicesVariableAudit = 3498
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ActionTimeStamp               OpcuaNodeIdServicesVariableAudit = 3499
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Status                        OpcuaNodeIdServicesVariableAudit = 3500
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ServerId                      OpcuaNodeIdServicesVariableAudit = 3501
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientAuditEntryId            OpcuaNodeIdServicesVariableAudit = 3502
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientUserId                  OpcuaNodeIdServicesVariableAudit = 3503
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventId                                 OpcuaNodeIdServicesVariableAudit = 3504
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventType                               OpcuaNodeIdServicesVariableAudit = 3505
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceNode                              OpcuaNodeIdServicesVariableAudit = 3506
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceName                              OpcuaNodeIdServicesVariableAudit = 3507
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Time                                    OpcuaNodeIdServicesVariableAudit = 3508
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ReceiveTime                             OpcuaNodeIdServicesVariableAudit = 3509
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_LocalTime                               OpcuaNodeIdServicesVariableAudit = 3510
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Message                                 OpcuaNodeIdServicesVariableAudit = 3511
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Severity                                OpcuaNodeIdServicesVariableAudit = 3512
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ActionTimeStamp                         OpcuaNodeIdServicesVariableAudit = 3513
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Status                                  OpcuaNodeIdServicesVariableAudit = 3514
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ServerId                                OpcuaNodeIdServicesVariableAudit = 3515
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientAuditEntryId                      OpcuaNodeIdServicesVariableAudit = 3516
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientUserId                            OpcuaNodeIdServicesVariableAudit = 3517
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventId                            OpcuaNodeIdServicesVariableAudit = 3518
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventType                          OpcuaNodeIdServicesVariableAudit = 3519
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceNode                         OpcuaNodeIdServicesVariableAudit = 3520
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceName                         OpcuaNodeIdServicesVariableAudit = 3521
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Time                               OpcuaNodeIdServicesVariableAudit = 3522
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ReceiveTime                        OpcuaNodeIdServicesVariableAudit = 3523
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_LocalTime                          OpcuaNodeIdServicesVariableAudit = 3524
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Message                            OpcuaNodeIdServicesVariableAudit = 3525
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Severity                           OpcuaNodeIdServicesVariableAudit = 3526
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ActionTimeStamp                    OpcuaNodeIdServicesVariableAudit = 3527
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Status                             OpcuaNodeIdServicesVariableAudit = 3528
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ServerId                           OpcuaNodeIdServicesVariableAudit = 3529
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientAuditEntryId                 OpcuaNodeIdServicesVariableAudit = 3530
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientUserId                       OpcuaNodeIdServicesVariableAudit = 3531
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventId                          OpcuaNodeIdServicesVariableAudit = 3532
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventType                        OpcuaNodeIdServicesVariableAudit = 3533
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceNode                       OpcuaNodeIdServicesVariableAudit = 3534
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceName                       OpcuaNodeIdServicesVariableAudit = 3535
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Time                             OpcuaNodeIdServicesVariableAudit = 3536
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ReceiveTime                      OpcuaNodeIdServicesVariableAudit = 3537
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_LocalTime                        OpcuaNodeIdServicesVariableAudit = 3538
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Message                          OpcuaNodeIdServicesVariableAudit = 3539
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Severity                         OpcuaNodeIdServicesVariableAudit = 3540
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ActionTimeStamp                  OpcuaNodeIdServicesVariableAudit = 3541
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Status                           OpcuaNodeIdServicesVariableAudit = 3542
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ServerId                         OpcuaNodeIdServicesVariableAudit = 3543
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientAuditEntryId               OpcuaNodeIdServicesVariableAudit = 3544
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientUserId                     OpcuaNodeIdServicesVariableAudit = 3545
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3546
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3547
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3548
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3549
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3550
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3551
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3552
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3553
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3554
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3555
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3556
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3557
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3558
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3559
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ParameterDataTypeId         OpcuaNodeIdServicesVariableAudit = 3560
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3561
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3562
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3563
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3564
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3565
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3566
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3567
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3568
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3569
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3570
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3571
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3572
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3573
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3574
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ParameterDataTypeId         OpcuaNodeIdServicesVariableAudit = 3575
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventId                          OpcuaNodeIdServicesVariableAudit = 3576
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventType                        OpcuaNodeIdServicesVariableAudit = 3577
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceNode                       OpcuaNodeIdServicesVariableAudit = 3578
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceName                       OpcuaNodeIdServicesVariableAudit = 3579
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Time                             OpcuaNodeIdServicesVariableAudit = 3580
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ReceiveTime                      OpcuaNodeIdServicesVariableAudit = 3581
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_LocalTime                        OpcuaNodeIdServicesVariableAudit = 3582
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Message                          OpcuaNodeIdServicesVariableAudit = 3583
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Severity                         OpcuaNodeIdServicesVariableAudit = 3584
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ActionTimeStamp                  OpcuaNodeIdServicesVariableAudit = 3585
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Status                           OpcuaNodeIdServicesVariableAudit = 3586
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ServerId                         OpcuaNodeIdServicesVariableAudit = 3587
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientAuditEntryId               OpcuaNodeIdServicesVariableAudit = 3588
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientUserId                     OpcuaNodeIdServicesVariableAudit = 3589
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ParameterDataTypeId              OpcuaNodeIdServicesVariableAudit = 3590
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventId                 OpcuaNodeIdServicesVariableAudit = 3591
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventType               OpcuaNodeIdServicesVariableAudit = 3592
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceNode              OpcuaNodeIdServicesVariableAudit = 3593
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceName              OpcuaNodeIdServicesVariableAudit = 3594
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Time                    OpcuaNodeIdServicesVariableAudit = 3595
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ReceiveTime             OpcuaNodeIdServicesVariableAudit = 3596
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_LocalTime               OpcuaNodeIdServicesVariableAudit = 3597
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Message                 OpcuaNodeIdServicesVariableAudit = 3598
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Severity                OpcuaNodeIdServicesVariableAudit = 3599
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ActionTimeStamp         OpcuaNodeIdServicesVariableAudit = 3600
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Status                  OpcuaNodeIdServicesVariableAudit = 3601
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ServerId                OpcuaNodeIdServicesVariableAudit = 3602
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId      OpcuaNodeIdServicesVariableAudit = 3603
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientUserId            OpcuaNodeIdServicesVariableAudit = 3604
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId     OpcuaNodeIdServicesVariableAudit = 3605
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_UpdatedNode             OpcuaNodeIdServicesVariableAudit = 3606
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventId                    OpcuaNodeIdServicesVariableAudit = 3607
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventType                  OpcuaNodeIdServicesVariableAudit = 3608
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceNode                 OpcuaNodeIdServicesVariableAudit = 3609
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceName                 OpcuaNodeIdServicesVariableAudit = 3610
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Time                       OpcuaNodeIdServicesVariableAudit = 3611
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReceiveTime                OpcuaNodeIdServicesVariableAudit = 3612
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_LocalTime                  OpcuaNodeIdServicesVariableAudit = 3613
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Message                    OpcuaNodeIdServicesVariableAudit = 3614
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Severity                   OpcuaNodeIdServicesVariableAudit = 3615
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ActionTimeStamp            OpcuaNodeIdServicesVariableAudit = 3616
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Status                     OpcuaNodeIdServicesVariableAudit = 3617
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ServerId                   OpcuaNodeIdServicesVariableAudit = 3618
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId         OpcuaNodeIdServicesVariableAudit = 3619
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientUserId               OpcuaNodeIdServicesVariableAudit = 3620
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId        OpcuaNodeIdServicesVariableAudit = 3621
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_UpdatedNode                OpcuaNodeIdServicesVariableAudit = 3622
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventId                     OpcuaNodeIdServicesVariableAudit = 3623
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventType                   OpcuaNodeIdServicesVariableAudit = 3624
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceNode                  OpcuaNodeIdServicesVariableAudit = 3625
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceName                  OpcuaNodeIdServicesVariableAudit = 3626
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Time                        OpcuaNodeIdServicesVariableAudit = 3627
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ReceiveTime                 OpcuaNodeIdServicesVariableAudit = 3628
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_LocalTime                   OpcuaNodeIdServicesVariableAudit = 3629
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Message                     OpcuaNodeIdServicesVariableAudit = 3630
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Severity                    OpcuaNodeIdServicesVariableAudit = 3631
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ActionTimeStamp             OpcuaNodeIdServicesVariableAudit = 3632
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Status                      OpcuaNodeIdServicesVariableAudit = 3633
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ServerId                    OpcuaNodeIdServicesVariableAudit = 3634
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientAuditEntryId          OpcuaNodeIdServicesVariableAudit = 3635
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientUserId                OpcuaNodeIdServicesVariableAudit = 3636
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ParameterDataTypeId         OpcuaNodeIdServicesVariableAudit = 3637
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_UpdatedNode                 OpcuaNodeIdServicesVariableAudit = 3638
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventId                           OpcuaNodeIdServicesVariableAudit = 3639
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventType                         OpcuaNodeIdServicesVariableAudit = 3640
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceNode                        OpcuaNodeIdServicesVariableAudit = 3641
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceName                        OpcuaNodeIdServicesVariableAudit = 3642
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Time                              OpcuaNodeIdServicesVariableAudit = 3643
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ReceiveTime                       OpcuaNodeIdServicesVariableAudit = 3644
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_LocalTime                         OpcuaNodeIdServicesVariableAudit = 3645
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Message                           OpcuaNodeIdServicesVariableAudit = 3646
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Severity                          OpcuaNodeIdServicesVariableAudit = 3647
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ActionTimeStamp                   OpcuaNodeIdServicesVariableAudit = 3648
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Status                            OpcuaNodeIdServicesVariableAudit = 3649
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ServerId                          OpcuaNodeIdServicesVariableAudit = 3650
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientAuditEntryId                OpcuaNodeIdServicesVariableAudit = 3651
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientUserId                      OpcuaNodeIdServicesVariableAudit = 3652
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventId                            OpcuaNodeIdServicesVariableAudit = 3758
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventType                          OpcuaNodeIdServicesVariableAudit = 3759
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceNode                         OpcuaNodeIdServicesVariableAudit = 3760
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceName                         OpcuaNodeIdServicesVariableAudit = 3761
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Time                               OpcuaNodeIdServicesVariableAudit = 3762
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ReceiveTime                        OpcuaNodeIdServicesVariableAudit = 3763
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_LocalTime                          OpcuaNodeIdServicesVariableAudit = 3764
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Message                            OpcuaNodeIdServicesVariableAudit = 3765
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Severity                           OpcuaNodeIdServicesVariableAudit = 3766
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ActionTimeStamp                    OpcuaNodeIdServicesVariableAudit = 3767
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Status                             OpcuaNodeIdServicesVariableAudit = 3768
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ServerId                           OpcuaNodeIdServicesVariableAudit = 3769
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientAuditEntryId                 OpcuaNodeIdServicesVariableAudit = 3770
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientUserId                       OpcuaNodeIdServicesVariableAudit = 3771
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_MethodId                           OpcuaNodeIdServicesVariableAudit = 3772
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_InputArguments                     OpcuaNodeIdServicesVariableAudit = 3773
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventId                              OpcuaNodeIdServicesVariableAudit = 3996
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventType                            OpcuaNodeIdServicesVariableAudit = 3997
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceNode                           OpcuaNodeIdServicesVariableAudit = 3998
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceName                           OpcuaNodeIdServicesVariableAudit = 3999
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Time                                 OpcuaNodeIdServicesVariableAudit = 4000
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ReceiveTime                          OpcuaNodeIdServicesVariableAudit = 4001
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_LocalTime                            OpcuaNodeIdServicesVariableAudit = 4002
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Message                              OpcuaNodeIdServicesVariableAudit = 4003
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Severity                             OpcuaNodeIdServicesVariableAudit = 4004
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ActionTimeStamp                      OpcuaNodeIdServicesVariableAudit = 4005
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Status                               OpcuaNodeIdServicesVariableAudit = 4006
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ServerId                             OpcuaNodeIdServicesVariableAudit = 4007
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientAuditEntryId                   OpcuaNodeIdServicesVariableAudit = 4008
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientUserId                         OpcuaNodeIdServicesVariableAudit = 4009
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_MethodId                             OpcuaNodeIdServicesVariableAudit = 4010
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_InputArguments                       OpcuaNodeIdServicesVariableAudit = 4011
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventId                        OpcuaNodeIdServicesVariableAudit = 4106
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventType                      OpcuaNodeIdServicesVariableAudit = 4107
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceNode                     OpcuaNodeIdServicesVariableAudit = 4108
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceName                     OpcuaNodeIdServicesVariableAudit = 4109
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Time                           OpcuaNodeIdServicesVariableAudit = 4110
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ReceiveTime                    OpcuaNodeIdServicesVariableAudit = 4111
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_LocalTime                      OpcuaNodeIdServicesVariableAudit = 4112
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Message                        OpcuaNodeIdServicesVariableAudit = 4113
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Severity                       OpcuaNodeIdServicesVariableAudit = 4114
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ActionTimeStamp                OpcuaNodeIdServicesVariableAudit = 4115
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Status                         OpcuaNodeIdServicesVariableAudit = 4116
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ServerId                       OpcuaNodeIdServicesVariableAudit = 4117
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientAuditEntryId             OpcuaNodeIdServicesVariableAudit = 4118
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientUserId                   OpcuaNodeIdServicesVariableAudit = 4119
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_MethodId                       OpcuaNodeIdServicesVariableAudit = 4120
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_InputArguments                 OpcuaNodeIdServicesVariableAudit = 4121
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventId                       OpcuaNodeIdServicesVariableAudit = 4170
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventType                     OpcuaNodeIdServicesVariableAudit = 4171
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceNode                    OpcuaNodeIdServicesVariableAudit = 4172
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceName                    OpcuaNodeIdServicesVariableAudit = 4173
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Time                          OpcuaNodeIdServicesVariableAudit = 4174
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ReceiveTime                   OpcuaNodeIdServicesVariableAudit = 4175
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_LocalTime                     OpcuaNodeIdServicesVariableAudit = 4176
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Message                       OpcuaNodeIdServicesVariableAudit = 4177
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Severity                      OpcuaNodeIdServicesVariableAudit = 4178
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ActionTimeStamp               OpcuaNodeIdServicesVariableAudit = 4179
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Status                        OpcuaNodeIdServicesVariableAudit = 4180
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ServerId                      OpcuaNodeIdServicesVariableAudit = 4181
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientAuditEntryId            OpcuaNodeIdServicesVariableAudit = 4182
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientUserId                  OpcuaNodeIdServicesVariableAudit = 4183
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_MethodId                      OpcuaNodeIdServicesVariableAudit = 4184
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_InputArguments                OpcuaNodeIdServicesVariableAudit = 4185
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventId                       OpcuaNodeIdServicesVariableAudit = 8928
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventType                     OpcuaNodeIdServicesVariableAudit = 8929
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceNode                    OpcuaNodeIdServicesVariableAudit = 8930
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceName                    OpcuaNodeIdServicesVariableAudit = 8931
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Time                          OpcuaNodeIdServicesVariableAudit = 8932
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ReceiveTime                   OpcuaNodeIdServicesVariableAudit = 8933
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_LocalTime                     OpcuaNodeIdServicesVariableAudit = 8934
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Message                       OpcuaNodeIdServicesVariableAudit = 8935
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Severity                      OpcuaNodeIdServicesVariableAudit = 8936
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ActionTimeStamp               OpcuaNodeIdServicesVariableAudit = 8937
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Status                        OpcuaNodeIdServicesVariableAudit = 8938
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ServerId                      OpcuaNodeIdServicesVariableAudit = 8939
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientAuditEntryId            OpcuaNodeIdServicesVariableAudit = 8940
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientUserId                  OpcuaNodeIdServicesVariableAudit = 8941
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_MethodId                      OpcuaNodeIdServicesVariableAudit = 8942
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_InputArguments                OpcuaNodeIdServicesVariableAudit = 8943
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventId                   OpcuaNodeIdServicesVariableAudit = 8945
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventType                 OpcuaNodeIdServicesVariableAudit = 8946
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceNode                OpcuaNodeIdServicesVariableAudit = 8947
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceName                OpcuaNodeIdServicesVariableAudit = 8948
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Time                      OpcuaNodeIdServicesVariableAudit = 8949
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ReceiveTime               OpcuaNodeIdServicesVariableAudit = 8950
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_LocalTime                 OpcuaNodeIdServicesVariableAudit = 8951
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Message                   OpcuaNodeIdServicesVariableAudit = 8952
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Severity                  OpcuaNodeIdServicesVariableAudit = 8953
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ActionTimeStamp           OpcuaNodeIdServicesVariableAudit = 8954
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Status                    OpcuaNodeIdServicesVariableAudit = 8955
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ServerId                  OpcuaNodeIdServicesVariableAudit = 8956
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientAuditEntryId        OpcuaNodeIdServicesVariableAudit = 8957
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientUserId              OpcuaNodeIdServicesVariableAudit = 8958
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_MethodId                  OpcuaNodeIdServicesVariableAudit = 8959
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_InputArguments            OpcuaNodeIdServicesVariableAudit = 8960
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventId                       OpcuaNodeIdServicesVariableAudit = 8962
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventType                     OpcuaNodeIdServicesVariableAudit = 8963
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceNode                    OpcuaNodeIdServicesVariableAudit = 8964
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceName                    OpcuaNodeIdServicesVariableAudit = 8965
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Time                          OpcuaNodeIdServicesVariableAudit = 8966
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ReceiveTime                   OpcuaNodeIdServicesVariableAudit = 8967
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_LocalTime                     OpcuaNodeIdServicesVariableAudit = 8968
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Message                       OpcuaNodeIdServicesVariableAudit = 8969
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Severity                      OpcuaNodeIdServicesVariableAudit = 8970
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ActionTimeStamp               OpcuaNodeIdServicesVariableAudit = 8971
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Status                        OpcuaNodeIdServicesVariableAudit = 8972
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ServerId                      OpcuaNodeIdServicesVariableAudit = 8973
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientAuditEntryId            OpcuaNodeIdServicesVariableAudit = 8974
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientUserId                  OpcuaNodeIdServicesVariableAudit = 8975
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_MethodId                      OpcuaNodeIdServicesVariableAudit = 8976
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_InputArguments                OpcuaNodeIdServicesVariableAudit = 8977
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventId                      OpcuaNodeIdServicesVariableAudit = 11094
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventType                    OpcuaNodeIdServicesVariableAudit = 11095
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceNode                   OpcuaNodeIdServicesVariableAudit = 11096
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceName                   OpcuaNodeIdServicesVariableAudit = 11097
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Time                         OpcuaNodeIdServicesVariableAudit = 11098
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ReceiveTime                  OpcuaNodeIdServicesVariableAudit = 11099
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_LocalTime                    OpcuaNodeIdServicesVariableAudit = 11100
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Message                      OpcuaNodeIdServicesVariableAudit = 11101
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Severity                     OpcuaNodeIdServicesVariableAudit = 11102
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ActionTimeStamp              OpcuaNodeIdServicesVariableAudit = 11103
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Status                       OpcuaNodeIdServicesVariableAudit = 11104
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ServerId                     OpcuaNodeIdServicesVariableAudit = 11105
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientAuditEntryId           OpcuaNodeIdServicesVariableAudit = 11106
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientUserId                 OpcuaNodeIdServicesVariableAudit = 11107
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_MethodId                     OpcuaNodeIdServicesVariableAudit = 11108
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_InputArguments               OpcuaNodeIdServicesVariableAudit = 11109
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId                OpcuaNodeIdServicesVariableAudit = 11485
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment                       OpcuaNodeIdServicesVariableAudit = 11851
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse              OpcuaNodeIdServicesVariableAudit = 11852
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment                   OpcuaNodeIdServicesVariableAudit = 11853
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment                       OpcuaNodeIdServicesVariableAudit = 11854
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime                 OpcuaNodeIdServicesVariableAudit = 11855
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventId                      OpcuaNodeIdServicesVariableAudit = 11857
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventType                    OpcuaNodeIdServicesVariableAudit = 11858
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceNode                   OpcuaNodeIdServicesVariableAudit = 11859
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceName                   OpcuaNodeIdServicesVariableAudit = 11860
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Time                         OpcuaNodeIdServicesVariableAudit = 11861
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ReceiveTime                  OpcuaNodeIdServicesVariableAudit = 11862
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_LocalTime                    OpcuaNodeIdServicesVariableAudit = 11863
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Message                      OpcuaNodeIdServicesVariableAudit = 11864
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Severity                     OpcuaNodeIdServicesVariableAudit = 11865
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ActionTimeStamp              OpcuaNodeIdServicesVariableAudit = 11866
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Status                       OpcuaNodeIdServicesVariableAudit = 11867
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ServerId                     OpcuaNodeIdServicesVariableAudit = 11868
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientAuditEntryId           OpcuaNodeIdServicesVariableAudit = 11869
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientUserId                 OpcuaNodeIdServicesVariableAudit = 11870
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_MethodId                     OpcuaNodeIdServicesVariableAudit = 11871
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_InputArguments               OpcuaNodeIdServicesVariableAudit = 11872
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_OldStateId                   OpcuaNodeIdServicesVariableAudit = 11873
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_NewStateId                   OpcuaNodeIdServicesVariableAudit = 11874
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber             OpcuaNodeIdServicesVariableAudit = 11875
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SessionId                        OpcuaNodeIdServicesVariableAudit = 14413
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SessionId                          OpcuaNodeIdServicesVariableAudit = 14414
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventId                         OpcuaNodeIdServicesVariableAudit = 15014
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventType                       OpcuaNodeIdServicesVariableAudit = 15015
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceNode                      OpcuaNodeIdServicesVariableAudit = 15016
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceName                      OpcuaNodeIdServicesVariableAudit = 15017
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Time                            OpcuaNodeIdServicesVariableAudit = 15018
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ReceiveTime                     OpcuaNodeIdServicesVariableAudit = 15019
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_LocalTime                       OpcuaNodeIdServicesVariableAudit = 15020
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Message                         OpcuaNodeIdServicesVariableAudit = 15021
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Severity                        OpcuaNodeIdServicesVariableAudit = 15022
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ActionTimeStamp                 OpcuaNodeIdServicesVariableAudit = 15023
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Status                          OpcuaNodeIdServicesVariableAudit = 15024
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ServerId                        OpcuaNodeIdServicesVariableAudit = 15025
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientAuditEntryId              OpcuaNodeIdServicesVariableAudit = 15026
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientUserId                    OpcuaNodeIdServicesVariableAudit = 15027
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_MethodId                        OpcuaNodeIdServicesVariableAudit = 15028
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_InputArguments                  OpcuaNodeIdServicesVariableAudit = 15029
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId              OpcuaNodeIdServicesVariableAudit = 17222
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId          OpcuaNodeIdServicesVariableAudit = 17223
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId              OpcuaNodeIdServicesVariableAudit = 17224
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventId                   OpcuaNodeIdServicesVariableAudit = 17226
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventType                 OpcuaNodeIdServicesVariableAudit = 17227
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceNode                OpcuaNodeIdServicesVariableAudit = 17228
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceName                OpcuaNodeIdServicesVariableAudit = 17229
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Time                      OpcuaNodeIdServicesVariableAudit = 17230
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ReceiveTime               OpcuaNodeIdServicesVariableAudit = 17231
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_LocalTime                 OpcuaNodeIdServicesVariableAudit = 17232
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Message                   OpcuaNodeIdServicesVariableAudit = 17233
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Severity                  OpcuaNodeIdServicesVariableAudit = 17234
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ActionTimeStamp           OpcuaNodeIdServicesVariableAudit = 17235
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Status                    OpcuaNodeIdServicesVariableAudit = 17236
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ServerId                  OpcuaNodeIdServicesVariableAudit = 17237
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientAuditEntryId        OpcuaNodeIdServicesVariableAudit = 17238
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientUserId              OpcuaNodeIdServicesVariableAudit = 17239
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_MethodId                  OpcuaNodeIdServicesVariableAudit = 17240
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_InputArguments            OpcuaNodeIdServicesVariableAudit = 17241
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventId                       OpcuaNodeIdServicesVariableAudit = 17243
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventType                     OpcuaNodeIdServicesVariableAudit = 17244
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceNode                    OpcuaNodeIdServicesVariableAudit = 17245
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceName                    OpcuaNodeIdServicesVariableAudit = 17246
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Time                          OpcuaNodeIdServicesVariableAudit = 17247
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ReceiveTime                   OpcuaNodeIdServicesVariableAudit = 17248
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_LocalTime                     OpcuaNodeIdServicesVariableAudit = 17249
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Message                       OpcuaNodeIdServicesVariableAudit = 17250
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Severity                      OpcuaNodeIdServicesVariableAudit = 17251
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ActionTimeStamp               OpcuaNodeIdServicesVariableAudit = 17252
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Status                        OpcuaNodeIdServicesVariableAudit = 17253
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ServerId                      OpcuaNodeIdServicesVariableAudit = 17254
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientAuditEntryId            OpcuaNodeIdServicesVariableAudit = 17255
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientUserId                  OpcuaNodeIdServicesVariableAudit = 17256
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_MethodId                      OpcuaNodeIdServicesVariableAudit = 17257
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_InputArguments                OpcuaNodeIdServicesVariableAudit = 17258
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventId                  OpcuaNodeIdServicesVariableAudit = 17260
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventType                OpcuaNodeIdServicesVariableAudit = 17261
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceNode               OpcuaNodeIdServicesVariableAudit = 17262
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceName               OpcuaNodeIdServicesVariableAudit = 17263
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Time                     OpcuaNodeIdServicesVariableAudit = 17264
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ReceiveTime              OpcuaNodeIdServicesVariableAudit = 17265
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_LocalTime                OpcuaNodeIdServicesVariableAudit = 17266
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Message                  OpcuaNodeIdServicesVariableAudit = 17267
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Severity                 OpcuaNodeIdServicesVariableAudit = 17268
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ActionTimeStamp          OpcuaNodeIdServicesVariableAudit = 17269
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Status                   OpcuaNodeIdServicesVariableAudit = 17270
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ServerId                 OpcuaNodeIdServicesVariableAudit = 17271
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientAuditEntryId       OpcuaNodeIdServicesVariableAudit = 17272
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientUserId             OpcuaNodeIdServicesVariableAudit = 17273
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_MethodId                 OpcuaNodeIdServicesVariableAudit = 17274
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_InputArguments           OpcuaNodeIdServicesVariableAudit = 17275
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId                          OpcuaNodeIdServicesVariableAudit = 17615
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_StatusCodeId                           OpcuaNodeIdServicesVariableAudit = 17616
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_StatusCodeId                 OpcuaNodeIdServicesVariableAudit = 17617
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_StatusCodeId                           OpcuaNodeIdServicesVariableAudit = 17618
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_StatusCodeId                     OpcuaNodeIdServicesVariableAudit = 17619
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_StatusCodeId                       OpcuaNodeIdServicesVariableAudit = 17620
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_StatusCodeId                   OpcuaNodeIdServicesVariableAudit = 17621
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_StatusCodeId                            OpcuaNodeIdServicesVariableAudit = 17622
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_StatusCodeId                       OpcuaNodeIdServicesVariableAudit = 17623
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_StatusCodeId           OpcuaNodeIdServicesVariableAudit = 17624
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_StatusCodeId                OpcuaNodeIdServicesVariableAudit = 17625
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_StatusCodeId                OpcuaNodeIdServicesVariableAudit = 17626
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_StatusCodeId              OpcuaNodeIdServicesVariableAudit = 17627
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_StatusCodeId                OpcuaNodeIdServicesVariableAudit = 17628
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_StatusCodeId               OpcuaNodeIdServicesVariableAudit = 17629
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventId                OpcuaNodeIdServicesVariableAudit = 19096
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventType              OpcuaNodeIdServicesVariableAudit = 19097
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceNode             OpcuaNodeIdServicesVariableAudit = 19098
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceName             OpcuaNodeIdServicesVariableAudit = 19099
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Time                   OpcuaNodeIdServicesVariableAudit = 19100
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ReceiveTime            OpcuaNodeIdServicesVariableAudit = 19101
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_LocalTime              OpcuaNodeIdServicesVariableAudit = 19102
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Message                OpcuaNodeIdServicesVariableAudit = 19103
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Severity               OpcuaNodeIdServicesVariableAudit = 19104
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ActionTimeStamp        OpcuaNodeIdServicesVariableAudit = 19105
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Status                 OpcuaNodeIdServicesVariableAudit = 19106
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ServerId               OpcuaNodeIdServicesVariableAudit = 19289
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId     OpcuaNodeIdServicesVariableAudit = 19290
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientUserId           OpcuaNodeIdServicesVariableAudit = 19291
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId    OpcuaNodeIdServicesVariableAudit = 19292
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace   OpcuaNodeIdServicesVariableAudit = 19293
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues              OpcuaNodeIdServicesVariableAudit = 19294
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues              OpcuaNodeIdServicesVariableAudit = 19295
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventId                                 OpcuaNodeIdServicesVariableAudit = 23607
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventType                               OpcuaNodeIdServicesVariableAudit = 23610
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceNode                              OpcuaNodeIdServicesVariableAudit = 23611
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceName                              OpcuaNodeIdServicesVariableAudit = 23891
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Time                                    OpcuaNodeIdServicesVariableAudit = 23892
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ReceiveTime                             OpcuaNodeIdServicesVariableAudit = 23893
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_LocalTime                               OpcuaNodeIdServicesVariableAudit = 23894
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Message                                 OpcuaNodeIdServicesVariableAudit = 23895
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Severity                                OpcuaNodeIdServicesVariableAudit = 23896
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ActionTimeStamp                         OpcuaNodeIdServicesVariableAudit = 23903
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Status                                  OpcuaNodeIdServicesVariableAudit = 23904
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerId                                OpcuaNodeIdServicesVariableAudit = 23905
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientAuditEntryId                      OpcuaNodeIdServicesVariableAudit = 23906
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientUserId                            OpcuaNodeIdServicesVariableAudit = 23907
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri                               OpcuaNodeIdServicesVariableAudit = 23908
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventId               OpcuaNodeIdServicesVariableAudit = 23927
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventType             OpcuaNodeIdServicesVariableAudit = 23930
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceNode            OpcuaNodeIdServicesVariableAudit = 23931
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceName            OpcuaNodeIdServicesVariableAudit = 23959
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Time                  OpcuaNodeIdServicesVariableAudit = 23960
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ReceiveTime           OpcuaNodeIdServicesVariableAudit = 23961
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_LocalTime             OpcuaNodeIdServicesVariableAudit = 23962
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Message               OpcuaNodeIdServicesVariableAudit = 23963
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Severity              OpcuaNodeIdServicesVariableAudit = 23964
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ActionTimeStamp       OpcuaNodeIdServicesVariableAudit = 23971
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Status                OpcuaNodeIdServicesVariableAudit = 23972
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerId              OpcuaNodeIdServicesVariableAudit = 23973
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientAuditEntryId    OpcuaNodeIdServicesVariableAudit = 23974
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientUserId          OpcuaNodeIdServicesVariableAudit = 23975
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerUri             OpcuaNodeIdServicesVariableAudit = 23976
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId              OpcuaNodeIdServicesVariableAudit = 23994
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId              OpcuaNodeIdServicesVariableAudit = 23995
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId          OpcuaNodeIdServicesVariableAudit = 23998
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments        OpcuaNodeIdServicesVariableAudit = 23999
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId      OpcuaNodeIdServicesVariableAudit = 24135
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments       OpcuaNodeIdServicesVariableAudit = 25684
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassId                              OpcuaNodeIdServicesVariableAudit = 31775
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassName                            OpcuaNodeIdServicesVariableAudit = 31776
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassId                           OpcuaNodeIdServicesVariableAudit = 31777
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassName                         OpcuaNodeIdServicesVariableAudit = 31778
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassId                      OpcuaNodeIdServicesVariableAudit = 31779
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassName                    OpcuaNodeIdServicesVariableAudit = 31780
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassId                   OpcuaNodeIdServicesVariableAudit = 31781
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassName                 OpcuaNodeIdServicesVariableAudit = 31782
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassId                       OpcuaNodeIdServicesVariableAudit = 31783
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassName                     OpcuaNodeIdServicesVariableAudit = 31784
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassId                    OpcuaNodeIdServicesVariableAudit = 31785
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassName                  OpcuaNodeIdServicesVariableAudit = 31786
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassId             OpcuaNodeIdServicesVariableAudit = 31787
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassName           OpcuaNodeIdServicesVariableAudit = 31788
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassId          OpcuaNodeIdServicesVariableAudit = 31789
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassName        OpcuaNodeIdServicesVariableAudit = 31790
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassId                       OpcuaNodeIdServicesVariableAudit = 31791
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassName                     OpcuaNodeIdServicesVariableAudit = 31792
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassId                    OpcuaNodeIdServicesVariableAudit = 31793
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassName                  OpcuaNodeIdServicesVariableAudit = 31794
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassId                 OpcuaNodeIdServicesVariableAudit = 31795
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassName               OpcuaNodeIdServicesVariableAudit = 31796
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassId              OpcuaNodeIdServicesVariableAudit = 31797
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassName            OpcuaNodeIdServicesVariableAudit = 31798
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassId                   OpcuaNodeIdServicesVariableAudit = 31799
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassName                 OpcuaNodeIdServicesVariableAudit = 31800
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableAudit = 31801
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableAudit = 31802
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassId               OpcuaNodeIdServicesVariableAudit = 31803
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassName             OpcuaNodeIdServicesVariableAudit = 31804
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassId            OpcuaNodeIdServicesVariableAudit = 31805
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassName          OpcuaNodeIdServicesVariableAudit = 31806
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassId                        OpcuaNodeIdServicesVariableAudit = 31807
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassName                      OpcuaNodeIdServicesVariableAudit = 31808
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassId                     OpcuaNodeIdServicesVariableAudit = 31809
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassName                   OpcuaNodeIdServicesVariableAudit = 31810
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassId                   OpcuaNodeIdServicesVariableAudit = 31811
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassName                 OpcuaNodeIdServicesVariableAudit = 31812
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableAudit = 31813
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableAudit = 31814
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassId       OpcuaNodeIdServicesVariableAudit = 31815
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassName     OpcuaNodeIdServicesVariableAudit = 31816
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassId    OpcuaNodeIdServicesVariableAudit = 31817
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassName  OpcuaNodeIdServicesVariableAudit = 31818
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 31819
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 31820
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 31821
	OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 31822
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 31823
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 31824
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 31825
	OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 31826
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassId          OpcuaNodeIdServicesVariableAudit = 31827
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassName        OpcuaNodeIdServicesVariableAudit = 31828
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassId       OpcuaNodeIdServicesVariableAudit = 31829
	OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassName     OpcuaNodeIdServicesVariableAudit = 31830
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 31831
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 31832
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 31833
	OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 31834
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassId           OpcuaNodeIdServicesVariableAudit = 31835
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassName         OpcuaNodeIdServicesVariableAudit = 31836
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassId        OpcuaNodeIdServicesVariableAudit = 31837
	OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassName      OpcuaNodeIdServicesVariableAudit = 31838
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassId                OpcuaNodeIdServicesVariableAudit = 31839
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassName              OpcuaNodeIdServicesVariableAudit = 31840
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassId             OpcuaNodeIdServicesVariableAudit = 31841
	OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassName           OpcuaNodeIdServicesVariableAudit = 31842
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassId                      OpcuaNodeIdServicesVariableAudit = 31843
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassName                    OpcuaNodeIdServicesVariableAudit = 31844
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassId                   OpcuaNodeIdServicesVariableAudit = 31845
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassName                 OpcuaNodeIdServicesVariableAudit = 31846
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassId                   OpcuaNodeIdServicesVariableAudit = 31847
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassName                 OpcuaNodeIdServicesVariableAudit = 31848
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableAudit = 31849
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableAudit = 31850
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassId                 OpcuaNodeIdServicesVariableAudit = 31851
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassName               OpcuaNodeIdServicesVariableAudit = 31852
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassId              OpcuaNodeIdServicesVariableAudit = 31853
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassName            OpcuaNodeIdServicesVariableAudit = 31854
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassId              OpcuaNodeIdServicesVariableAudit = 31855
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassName            OpcuaNodeIdServicesVariableAudit = 31856
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassId           OpcuaNodeIdServicesVariableAudit = 31857
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassName         OpcuaNodeIdServicesVariableAudit = 31858
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassId                        OpcuaNodeIdServicesVariableAudit = 31859
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassName                      OpcuaNodeIdServicesVariableAudit = 31860
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassId                     OpcuaNodeIdServicesVariableAudit = 31861
	OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassName                   OpcuaNodeIdServicesVariableAudit = 31862
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassId                   OpcuaNodeIdServicesVariableAudit = 31863
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassName                 OpcuaNodeIdServicesVariableAudit = 31864
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableAudit = 31865
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableAudit = 31866
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassId                 OpcuaNodeIdServicesVariableAudit = 31867
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassName               OpcuaNodeIdServicesVariableAudit = 31868
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassId              OpcuaNodeIdServicesVariableAudit = 31869
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassName            OpcuaNodeIdServicesVariableAudit = 31870
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassId                  OpcuaNodeIdServicesVariableAudit = 31871
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassName                OpcuaNodeIdServicesVariableAudit = 31872
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassId               OpcuaNodeIdServicesVariableAudit = 31873
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassName             OpcuaNodeIdServicesVariableAudit = 31874
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassId                        OpcuaNodeIdServicesVariableAudit = 31907
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassName                      OpcuaNodeIdServicesVariableAudit = 31908
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassId                     OpcuaNodeIdServicesVariableAudit = 31909
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassName                   OpcuaNodeIdServicesVariableAudit = 31910
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassId      OpcuaNodeIdServicesVariableAudit = 31911
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassName    OpcuaNodeIdServicesVariableAudit = 31912
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassId   OpcuaNodeIdServicesVariableAudit = 31913
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassName OpcuaNodeIdServicesVariableAudit = 31914
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassId                   OpcuaNodeIdServicesVariableAudit = 31923
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassName                 OpcuaNodeIdServicesVariableAudit = 31924
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableAudit = 31925
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableAudit = 31926
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassId                     OpcuaNodeIdServicesVariableAudit = 31931
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassName                   OpcuaNodeIdServicesVariableAudit = 31932
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassId                  OpcuaNodeIdServicesVariableAudit = 31933
	OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassName                OpcuaNodeIdServicesVariableAudit = 31934
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassId               OpcuaNodeIdServicesVariableAudit = 31935
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassName             OpcuaNodeIdServicesVariableAudit = 31936
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassId            OpcuaNodeIdServicesVariableAudit = 31937
	OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassName          OpcuaNodeIdServicesVariableAudit = 31938
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassId              OpcuaNodeIdServicesVariableAudit = 31939
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassName            OpcuaNodeIdServicesVariableAudit = 31940
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassId           OpcuaNodeIdServicesVariableAudit = 31941
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassName         OpcuaNodeIdServicesVariableAudit = 31942
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassId              OpcuaNodeIdServicesVariableAudit = 31943
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassName            OpcuaNodeIdServicesVariableAudit = 31944
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassId           OpcuaNodeIdServicesVariableAudit = 31945
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassName         OpcuaNodeIdServicesVariableAudit = 31946
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassId          OpcuaNodeIdServicesVariableAudit = 31947
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassName        OpcuaNodeIdServicesVariableAudit = 31948
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassId       OpcuaNodeIdServicesVariableAudit = 31949
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassName     OpcuaNodeIdServicesVariableAudit = 31950
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassId              OpcuaNodeIdServicesVariableAudit = 31951
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassName            OpcuaNodeIdServicesVariableAudit = 31952
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassId           OpcuaNodeIdServicesVariableAudit = 31953
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassName         OpcuaNodeIdServicesVariableAudit = 31954
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassId             OpcuaNodeIdServicesVariableAudit = 31955
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassName           OpcuaNodeIdServicesVariableAudit = 31956
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassId          OpcuaNodeIdServicesVariableAudit = 31957
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassName        OpcuaNodeIdServicesVariableAudit = 31958
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassId          OpcuaNodeIdServicesVariableAudit = 31959
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassName        OpcuaNodeIdServicesVariableAudit = 31960
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassId       OpcuaNodeIdServicesVariableAudit = 31961
	OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassName     OpcuaNodeIdServicesVariableAudit = 31962
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassId              OpcuaNodeIdServicesVariableAudit = 31963
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassName            OpcuaNodeIdServicesVariableAudit = 31964
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassId           OpcuaNodeIdServicesVariableAudit = 31965
	OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassName         OpcuaNodeIdServicesVariableAudit = 31966
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassId                OpcuaNodeIdServicesVariableAudit = 31967
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassName              OpcuaNodeIdServicesVariableAudit = 31968
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassId             OpcuaNodeIdServicesVariableAudit = 31969
	OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassName           OpcuaNodeIdServicesVariableAudit = 31970
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassId         OpcuaNodeIdServicesVariableAudit = 31971
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassName       OpcuaNodeIdServicesVariableAudit = 31972
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassId      OpcuaNodeIdServicesVariableAudit = 31973
	OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassName    OpcuaNodeIdServicesVariableAudit = 31974
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassId             OpcuaNodeIdServicesVariableAudit = 31991
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassName           OpcuaNodeIdServicesVariableAudit = 31992
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassId          OpcuaNodeIdServicesVariableAudit = 31993
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassName        OpcuaNodeIdServicesVariableAudit = 31994
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 31999
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 32000
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 32001
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 32002
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 32003
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 32004
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 32005
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 32006
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassId       OpcuaNodeIdServicesVariableAudit = 32007
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassName     OpcuaNodeIdServicesVariableAudit = 32008
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassId    OpcuaNodeIdServicesVariableAudit = 32009
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassName  OpcuaNodeIdServicesVariableAudit = 32010
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassId                 OpcuaNodeIdServicesVariableAudit = 32011
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassName               OpcuaNodeIdServicesVariableAudit = 32012
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassId              OpcuaNodeIdServicesVariableAudit = 32013
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassName            OpcuaNodeIdServicesVariableAudit = 32014
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassId        OpcuaNodeIdServicesVariableAudit = 32015
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassName      OpcuaNodeIdServicesVariableAudit = 32016
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassId     OpcuaNodeIdServicesVariableAudit = 32017
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassName   OpcuaNodeIdServicesVariableAudit = 32018
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassId           OpcuaNodeIdServicesVariableAudit = 32019
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassName         OpcuaNodeIdServicesVariableAudit = 32020
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassId        OpcuaNodeIdServicesVariableAudit = 32021
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassName      OpcuaNodeIdServicesVariableAudit = 32022
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassId            OpcuaNodeIdServicesVariableAudit = 32023
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassName          OpcuaNodeIdServicesVariableAudit = 32024
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassId         OpcuaNodeIdServicesVariableAudit = 32025
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassName       OpcuaNodeIdServicesVariableAudit = 32026
)

var OpcuaNodeIdServicesVariableAuditValues []OpcuaNodeIdServicesVariableAudit

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAuditValues = []OpcuaNodeIdServicesVariableAudit{
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificate,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificateThumbprint,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_RevisedSessionTimeout,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_OldStateId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_NewStateId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventType,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceNode,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceName,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Time,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_LocalTime,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Message,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Severity,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerUri,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassName,
	}
}

func OpcuaNodeIdServicesVariableAuditByValue(value int32) (enum OpcuaNodeIdServicesVariableAudit, ok bool) {
	switch value {
	case 11094:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventId, true
	case 11095:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventType, true
	case 11096:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceNode, true
	case 11097:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceName, true
	case 11098:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Time, true
	case 11099:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ReceiveTime, true
	case 11100:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_LocalTime, true
	case 11101:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Message, true
	case 11102:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Severity, true
	case 11103:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ActionTimeStamp, true
	case 11104:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Status, true
	case 11105:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ServerId, true
	case 11106:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientAuditEntryId, true
	case 11107:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientUserId, true
	case 11108:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_MethodId, true
	case 11109:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_InputArguments, true
	case 11485:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId, true
	case 11851:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment, true
	case 11852:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse, true
	case 11853:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment, true
	case 11854:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment, true
	case 11855:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime, true
	case 11857:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventId, true
	case 11858:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventType, true
	case 11859:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceNode, true
	case 11860:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceName, true
	case 11861:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Time, true
	case 11862:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ReceiveTime, true
	case 11863:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_LocalTime, true
	case 11864:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Message, true
	case 11865:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Severity, true
	case 11866:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ActionTimeStamp, true
	case 11867:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Status, true
	case 11868:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ServerId, true
	case 11869:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientAuditEntryId, true
	case 11870:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientUserId, true
	case 11871:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_MethodId, true
	case 11872:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_InputArguments, true
	case 11873:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_OldStateId, true
	case 11874:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_NewStateId, true
	case 11875:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber, true
	case 14413:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SessionId, true
	case 14414:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SessionId, true
	case 15014:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventId, true
	case 15015:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventType, true
	case 15016:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceNode, true
	case 15017:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceName, true
	case 15018:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Time, true
	case 15019:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ReceiveTime, true
	case 15020:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_LocalTime, true
	case 15021:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Message, true
	case 15022:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Severity, true
	case 15023:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ActionTimeStamp, true
	case 15024:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Status, true
	case 15025:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ServerId, true
	case 15026:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientAuditEntryId, true
	case 15027:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientUserId, true
	case 15028:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_MethodId, true
	case 15029:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_InputArguments, true
	case 17222:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId, true
	case 17223:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId, true
	case 17224:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId, true
	case 17226:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventId, true
	case 17227:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventType, true
	case 17228:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceNode, true
	case 17229:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceName, true
	case 17230:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Time, true
	case 17231:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ReceiveTime, true
	case 17232:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_LocalTime, true
	case 17233:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Message, true
	case 17234:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Severity, true
	case 17235:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ActionTimeStamp, true
	case 17236:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Status, true
	case 17237:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ServerId, true
	case 17238:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientAuditEntryId, true
	case 17239:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientUserId, true
	case 17240:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_MethodId, true
	case 17241:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_InputArguments, true
	case 17243:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventId, true
	case 17244:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventType, true
	case 17245:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceNode, true
	case 17246:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceName, true
	case 17247:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Time, true
	case 17248:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ReceiveTime, true
	case 17249:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_LocalTime, true
	case 17250:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Message, true
	case 17251:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Severity, true
	case 17252:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ActionTimeStamp, true
	case 17253:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Status, true
	case 17254:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ServerId, true
	case 17255:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientAuditEntryId, true
	case 17256:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientUserId, true
	case 17257:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_MethodId, true
	case 17258:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_InputArguments, true
	case 17260:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventId, true
	case 17261:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventType, true
	case 17262:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceNode, true
	case 17263:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceName, true
	case 17264:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Time, true
	case 17265:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ReceiveTime, true
	case 17266:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_LocalTime, true
	case 17267:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Message, true
	case 17268:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Severity, true
	case 17269:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ActionTimeStamp, true
	case 17270:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Status, true
	case 17271:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ServerId, true
	case 17272:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientAuditEntryId, true
	case 17273:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientUserId, true
	case 17274:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_MethodId, true
	case 17275:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_InputArguments, true
	case 17615:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId, true
	case 17616:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_StatusCodeId, true
	case 17617:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_StatusCodeId, true
	case 17618:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_StatusCodeId, true
	case 17619:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_StatusCodeId, true
	case 17620:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_StatusCodeId, true
	case 17621:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_StatusCodeId, true
	case 17622:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_StatusCodeId, true
	case 17623:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_StatusCodeId, true
	case 17624:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_StatusCodeId, true
	case 17625:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_StatusCodeId, true
	case 17626:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_StatusCodeId, true
	case 17627:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_StatusCodeId, true
	case 17628:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_StatusCodeId, true
	case 17629:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_StatusCodeId, true
	case 19096:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventId, true
	case 19097:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventType, true
	case 19098:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceNode, true
	case 19099:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceName, true
	case 19100:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Time, true
	case 19101:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ReceiveTime, true
	case 19102:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_LocalTime, true
	case 19103:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Message, true
	case 19104:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Severity, true
	case 19105:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ActionTimeStamp, true
	case 19106:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Status, true
	case 19289:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ServerId, true
	case 19290:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId, true
	case 19291:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientUserId, true
	case 19292:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId, true
	case 19293:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace, true
	case 19294:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues, true
	case 19295:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues, true
	case 2053:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp, true
	case 2054:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Status, true
	case 2055:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId, true
	case 2056:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId, true
	case 2057:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId, true
	case 2061:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate, true
	case 2062:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType, true
	case 2063:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri, true
	case 2065:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode, true
	case 2066:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime, true
	case 2070:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId, true
	case 2072:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId, true
	case 2073:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate, true
	case 2074:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout, true
	case 2076:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates, true
	case 2077:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken, true
	case 2079:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle, true
	case 2081:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate, true
	case 2083:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname, true
	case 2084:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri, true
	case 2092:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd, true
	case 2094:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete, true
	case 2096:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd, true
	case 2098:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete, true
	case 2101:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange, true
	case 2102:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue, true
	case 2103:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue, true
	case 2128:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId, true
	case 2129:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments, true
	case 23607:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventId, true
	case 23610:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventType, true
	case 23611:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceNode, true
	case 23891:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceName, true
	case 23892:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Time, true
	case 23893:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ReceiveTime, true
	case 23894:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_LocalTime, true
	case 23895:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Message, true
	case 23896:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Severity, true
	case 23903:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ActionTimeStamp, true
	case 23904:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Status, true
	case 23905:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerId, true
	case 23906:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientAuditEntryId, true
	case 23907:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientUserId, true
	case 23908:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri, true
	case 23927:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventId, true
	case 23930:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventType, true
	case 23931:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceNode, true
	case 23959:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceName, true
	case 23960:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Time, true
	case 23961:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ReceiveTime, true
	case 23962:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_LocalTime, true
	case 23963:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Message, true
	case 23964:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Severity, true
	case 23971:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ActionTimeStamp, true
	case 23972:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Status, true
	case 23973:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerId, true
	case 23974:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientAuditEntryId, true
	case 23975:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientUserId, true
	case 23976:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerUri, true
	case 23994:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId, true
	case 23995:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId, true
	case 23998:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId, true
	case 23999:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments, true
	case 24135:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId, true
	case 25684:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments, true
	case 2745:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId, true
	case 2746:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint, true
	case 2747:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint, true
	case 2749:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl, true
	case 2750:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId, true
	case 2751:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId, true
	case 2777:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId, true
	case 2778:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId, true
	case 3003:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter, true
	case 3015:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified, true
	case 3016:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime, true
	case 3017:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime, true
	case 3020:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes, true
	case 3021:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues, true
	case 3023:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds, true
	case 3024:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues, true
	case 3025:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode, true
	case 3026:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode, true
	case 3027:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode, true
	case 3028:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace, true
	case 3029:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues, true
	case 3030:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues, true
	case 3031:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace, true
	case 3032:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues, true
	case 3033:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues, true
	case 3034:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues, true
	case 31775:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassId, true
	case 31776:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassName, true
	case 31777:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassId, true
	case 31778:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassName, true
	case 31779:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassId, true
	case 31780:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassName, true
	case 31781:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassId, true
	case 31782:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassName, true
	case 31783:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassId, true
	case 31784:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassName, true
	case 31785:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassId, true
	case 31786:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassName, true
	case 31787:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassId, true
	case 31788:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassName, true
	case 31789:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassId, true
	case 31790:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassName, true
	case 31791:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassId, true
	case 31792:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassName, true
	case 31793:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassId, true
	case 31794:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassName, true
	case 31795:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassId, true
	case 31796:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassName, true
	case 31797:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassId, true
	case 31798:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassName, true
	case 31799:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassId, true
	case 31800:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassName, true
	case 31801:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassId, true
	case 31802:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassName, true
	case 31803:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassId, true
	case 31804:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassName, true
	case 31805:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassId, true
	case 31806:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassName, true
	case 31807:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassId, true
	case 31808:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassName, true
	case 31809:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassId, true
	case 31810:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassName, true
	case 31811:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassId, true
	case 31812:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassName, true
	case 31813:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassId, true
	case 31814:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassName, true
	case 31815:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassId, true
	case 31816:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassName, true
	case 31817:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassId, true
	case 31818:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassName, true
	case 31819:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassId, true
	case 31820:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassName, true
	case 31821:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassId, true
	case 31822:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassName, true
	case 31823:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassId, true
	case 31824:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassName, true
	case 31825:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassId, true
	case 31826:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassName, true
	case 31827:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassId, true
	case 31828:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassName, true
	case 31829:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassId, true
	case 31830:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassName, true
	case 31831:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassId, true
	case 31832:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassName, true
	case 31833:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassId, true
	case 31834:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassName, true
	case 31835:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassId, true
	case 31836:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassName, true
	case 31837:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassId, true
	case 31838:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassName, true
	case 31839:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassId, true
	case 31840:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassName, true
	case 31841:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassId, true
	case 31842:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassName, true
	case 31843:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassId, true
	case 31844:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassName, true
	case 31845:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassId, true
	case 31846:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassName, true
	case 31847:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassId, true
	case 31848:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassName, true
	case 31849:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassId, true
	case 31850:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassName, true
	case 31851:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassId, true
	case 31852:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassName, true
	case 31853:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassId, true
	case 31854:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassName, true
	case 31855:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassId, true
	case 31856:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassName, true
	case 31857:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassId, true
	case 31858:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassName, true
	case 31859:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassId, true
	case 31860:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassName, true
	case 31861:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassId, true
	case 31862:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassName, true
	case 31863:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassId, true
	case 31864:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassName, true
	case 31865:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassId, true
	case 31866:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassName, true
	case 31867:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassId, true
	case 31868:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassName, true
	case 31869:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassId, true
	case 31870:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassName, true
	case 31871:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassId, true
	case 31872:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassName, true
	case 31873:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassId, true
	case 31874:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassName, true
	case 31907:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassId, true
	case 31908:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassName, true
	case 31909:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassId, true
	case 31910:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassName, true
	case 31911:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassId, true
	case 31912:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassName, true
	case 31913:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassId, true
	case 31914:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassName, true
	case 31923:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassId, true
	case 31924:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassName, true
	case 31925:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassId, true
	case 31926:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassName, true
	case 31931:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassId, true
	case 31932:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassName, true
	case 31933:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassId, true
	case 31934:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassName, true
	case 31935:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassId, true
	case 31936:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassName, true
	case 31937:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassId, true
	case 31938:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassName, true
	case 31939:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassId, true
	case 31940:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassName, true
	case 31941:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassId, true
	case 31942:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassName, true
	case 31943:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassId, true
	case 31944:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassName, true
	case 31945:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassId, true
	case 31946:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassName, true
	case 31947:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassId, true
	case 31948:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassName, true
	case 31949:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassId, true
	case 31950:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassName, true
	case 31951:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassId, true
	case 31952:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassName, true
	case 31953:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassId, true
	case 31954:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassName, true
	case 31955:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassId, true
	case 31956:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassName, true
	case 31957:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassId, true
	case 31958:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassName, true
	case 31959:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassId, true
	case 31960:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassName, true
	case 31961:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassId, true
	case 31962:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassName, true
	case 31963:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassId, true
	case 31964:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassName, true
	case 31965:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassId, true
	case 31966:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassName, true
	case 31967:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassId, true
	case 31968:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassName, true
	case 31969:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassId, true
	case 31970:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassName, true
	case 31971:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassId, true
	case 31972:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassName, true
	case 31973:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassId, true
	case 31974:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassName, true
	case 31991:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassId, true
	case 31992:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassName, true
	case 31993:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassId, true
	case 31994:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassName, true
	case 31999:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassId, true
	case 3200:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_EventId, true
	case 32000:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassName, true
	case 32001:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassId, true
	case 32002:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassName, true
	case 32003:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassId, true
	case 32004:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassName, true
	case 32005:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassId, true
	case 32006:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassName, true
	case 32007:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassId, true
	case 32008:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassName, true
	case 32009:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassId, true
	case 3201:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_EventType, true
	case 32010:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassName, true
	case 32011:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassId, true
	case 32012:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassName, true
	case 32013:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassId, true
	case 32014:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassName, true
	case 32015:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassId, true
	case 32016:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassName, true
	case 32017:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassId, true
	case 32018:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassName, true
	case 32019:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassId, true
	case 3202:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceNode, true
	case 32020:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassName, true
	case 32021:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassId, true
	case 32022:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassName, true
	case 32023:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassId, true
	case 32024:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassName, true
	case 32025:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassId, true
	case 32026:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassName, true
	case 3203:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceName, true
	case 3204:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Time, true
	case 3205:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ReceiveTime, true
	case 3206:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_LocalTime, true
	case 3207:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Message, true
	case 3208:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Severity, true
	case 3209:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventId, true
	case 3210:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventType, true
	case 3211:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceNode, true
	case 3212:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceName, true
	case 3213:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Time, true
	case 3214:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ReceiveTime, true
	case 3215:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_LocalTime, true
	case 3216:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Message, true
	case 3217:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Severity, true
	case 3218:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ActionTimeStamp, true
	case 3219:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Status, true
	case 3220:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ServerId, true
	case 3221:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientAuditEntryId, true
	case 3222:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientUserId, true
	case 3223:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventId, true
	case 3224:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventType, true
	case 3225:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceNode, true
	case 3226:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceName, true
	case 3227:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Time, true
	case 3228:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ReceiveTime, true
	case 3229:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_LocalTime, true
	case 3230:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Message, true
	case 3231:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Severity, true
	case 3232:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ActionTimeStamp, true
	case 3233:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Status, true
	case 3234:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ServerId, true
	case 3235:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientAuditEntryId, true
	case 3236:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientUserId, true
	case 3237:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventId, true
	case 3238:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventType, true
	case 3239:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceNode, true
	case 3240:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceName, true
	case 3241:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Time, true
	case 3242:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ReceiveTime, true
	case 3243:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_LocalTime, true
	case 3244:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Message, true
	case 3245:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Severity, true
	case 3246:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ActionTimeStamp, true
	case 3247:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Status, true
	case 3248:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ServerId, true
	case 3249:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientAuditEntryId, true
	case 3250:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientUserId, true
	case 3251:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecureChannelId, true
	case 3252:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventId, true
	case 3253:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventType, true
	case 3254:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceNode, true
	case 3255:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceName, true
	case 3256:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Time, true
	case 3257:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ReceiveTime, true
	case 3258:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_LocalTime, true
	case 3259:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Message, true
	case 3260:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Severity, true
	case 3261:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ActionTimeStamp, true
	case 3262:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Status, true
	case 3263:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ServerId, true
	case 3264:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientAuditEntryId, true
	case 3265:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientUserId, true
	case 3266:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventId, true
	case 3267:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventType, true
	case 3268:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceNode, true
	case 3269:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceName, true
	case 3270:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Time, true
	case 3271:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ReceiveTime, true
	case 3272:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_LocalTime, true
	case 3273:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Message, true
	case 3274:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Severity, true
	case 3275:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ActionTimeStamp, true
	case 3276:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Status, true
	case 3277:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ServerId, true
	case 3278:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientAuditEntryId, true
	case 3279:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientUserId, true
	case 3281:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventId, true
	case 3282:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventType, true
	case 3283:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceNode, true
	case 3284:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceName, true
	case 3285:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Time, true
	case 3286:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ReceiveTime, true
	case 3287:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_LocalTime, true
	case 3288:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Message, true
	case 3289:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Severity, true
	case 3290:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ActionTimeStamp, true
	case 3291:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Status, true
	case 3292:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ServerId, true
	case 3293:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientAuditEntryId, true
	case 3294:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientUserId, true
	case 3296:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SecureChannelId, true
	case 3297:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificate, true
	case 3298:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificateThumbprint, true
	case 3299:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_RevisedSessionTimeout, true
	case 3300:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventId, true
	case 3301:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventType, true
	case 3302:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceNode, true
	case 3303:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceName, true
	case 3304:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Time, true
	case 3305:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ReceiveTime, true
	case 3306:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_LocalTime, true
	case 3307:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Message, true
	case 3308:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Severity, true
	case 3309:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ActionTimeStamp, true
	case 3310:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Status, true
	case 3311:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ServerId, true
	case 3312:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientAuditEntryId, true
	case 3313:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientUserId, true
	case 3314:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SessionId, true
	case 3315:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventId, true
	case 3316:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventType, true
	case 3317:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceNode, true
	case 3318:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceName, true
	case 3319:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Time, true
	case 3320:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ReceiveTime, true
	case 3321:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_LocalTime, true
	case 3322:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Message, true
	case 3323:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Severity, true
	case 3324:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ActionTimeStamp, true
	case 3325:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Status, true
	case 3326:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ServerId, true
	case 3327:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientAuditEntryId, true
	case 3328:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientUserId, true
	case 3329:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SessionId, true
	case 3330:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventId, true
	case 3331:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventType, true
	case 3332:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceNode, true
	case 3333:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceName, true
	case 3334:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Time, true
	case 3335:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ReceiveTime, true
	case 3336:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_LocalTime, true
	case 3337:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Message, true
	case 3338:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Severity, true
	case 3339:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ActionTimeStamp, true
	case 3340:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Status, true
	case 3341:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ServerId, true
	case 3342:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientAuditEntryId, true
	case 3343:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientUserId, true
	case 3344:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventId, true
	case 3345:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventType, true
	case 3346:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceNode, true
	case 3347:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceName, true
	case 3348:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Time, true
	case 3349:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ReceiveTime, true
	case 3350:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_LocalTime, true
	case 3351:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Message, true
	case 3352:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Severity, true
	case 3353:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ActionTimeStamp, true
	case 3354:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Status, true
	case 3355:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ServerId, true
	case 3356:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientAuditEntryId, true
	case 3357:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientUserId, true
	case 3358:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Certificate, true
	case 3359:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventId, true
	case 3360:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventType, true
	case 3361:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceNode, true
	case 3362:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceName, true
	case 3363:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Time, true
	case 3364:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ReceiveTime, true
	case 3365:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_LocalTime, true
	case 3366:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Message, true
	case 3367:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Severity, true
	case 3368:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ActionTimeStamp, true
	case 3369:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Status, true
	case 3370:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ServerId, true
	case 3371:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientAuditEntryId, true
	case 3372:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientUserId, true
	case 3373:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Certificate, true
	case 3374:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventId, true
	case 3375:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventType, true
	case 3376:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceNode, true
	case 3377:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceName, true
	case 3378:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Time, true
	case 3379:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ReceiveTime, true
	case 3380:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_LocalTime, true
	case 3381:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Message, true
	case 3382:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Severity, true
	case 3383:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ActionTimeStamp, true
	case 3384:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Status, true
	case 3385:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ServerId, true
	case 3386:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientAuditEntryId, true
	case 3387:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientUserId, true
	case 3388:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Certificate, true
	case 3389:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventId, true
	case 3390:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventType, true
	case 3391:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceNode, true
	case 3392:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceName, true
	case 3393:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Time, true
	case 3394:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ReceiveTime, true
	case 3395:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_LocalTime, true
	case 3396:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Message, true
	case 3397:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Severity, true
	case 3398:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ActionTimeStamp, true
	case 3399:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Status, true
	case 3400:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ServerId, true
	case 3401:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientAuditEntryId, true
	case 3402:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientUserId, true
	case 3403:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Certificate, true
	case 3404:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventId, true
	case 3405:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventType, true
	case 3406:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceNode, true
	case 3407:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceName, true
	case 3408:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Time, true
	case 3409:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ReceiveTime, true
	case 3410:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_LocalTime, true
	case 3411:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Message, true
	case 3412:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Severity, true
	case 3413:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ActionTimeStamp, true
	case 3414:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Status, true
	case 3415:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ServerId, true
	case 3416:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientAuditEntryId, true
	case 3417:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientUserId, true
	case 3418:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Certificate, true
	case 3419:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventId, true
	case 3420:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventType, true
	case 3421:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceNode, true
	case 3422:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceName, true
	case 3423:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Time, true
	case 3424:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ReceiveTime, true
	case 3425:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_LocalTime, true
	case 3426:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Message, true
	case 3427:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Severity, true
	case 3428:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ActionTimeStamp, true
	case 3429:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Status, true
	case 3430:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ServerId, true
	case 3431:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientAuditEntryId, true
	case 3432:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientUserId, true
	case 3433:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Certificate, true
	case 3434:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventId, true
	case 3435:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventType, true
	case 3436:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceNode, true
	case 3437:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceName, true
	case 3438:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Time, true
	case 3439:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ReceiveTime, true
	case 3440:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_LocalTime, true
	case 3441:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Message, true
	case 3442:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Severity, true
	case 3443:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ActionTimeStamp, true
	case 3444:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Status, true
	case 3445:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ServerId, true
	case 3446:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientAuditEntryId, true
	case 3447:
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientUserId, true
	case 3448:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventId, true
	case 3449:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventType, true
	case 3450:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceNode, true
	case 3451:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceName, true
	case 3452:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Time, true
	case 3453:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ReceiveTime, true
	case 3454:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_LocalTime, true
	case 3455:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Message, true
	case 3456:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Severity, true
	case 3457:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ActionTimeStamp, true
	case 3458:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Status, true
	case 3459:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ServerId, true
	case 3460:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientAuditEntryId, true
	case 3461:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientUserId, true
	case 3462:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventId, true
	case 3463:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventType, true
	case 3464:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceNode, true
	case 3465:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceName, true
	case 3466:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Time, true
	case 3467:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ReceiveTime, true
	case 3468:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_LocalTime, true
	case 3469:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Message, true
	case 3470:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Severity, true
	case 3471:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ActionTimeStamp, true
	case 3472:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Status, true
	case 3473:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ServerId, true
	case 3474:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientAuditEntryId, true
	case 3475:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientUserId, true
	case 3476:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventId, true
	case 3477:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventType, true
	case 3478:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceNode, true
	case 3479:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceName, true
	case 3480:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Time, true
	case 3481:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReceiveTime, true
	case 3482:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_LocalTime, true
	case 3483:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Message, true
	case 3484:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Severity, true
	case 3485:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ActionTimeStamp, true
	case 3486:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Status, true
	case 3487:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ServerId, true
	case 3488:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientAuditEntryId, true
	case 3489:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientUserId, true
	case 3490:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventId, true
	case 3491:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventType, true
	case 3492:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceNode, true
	case 3493:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceName, true
	case 3494:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Time, true
	case 3495:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReceiveTime, true
	case 3496:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_LocalTime, true
	case 3497:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Message, true
	case 3498:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Severity, true
	case 3499:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ActionTimeStamp, true
	case 3500:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Status, true
	case 3501:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ServerId, true
	case 3502:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientAuditEntryId, true
	case 3503:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientUserId, true
	case 3504:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventId, true
	case 3505:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventType, true
	case 3506:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceNode, true
	case 3507:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceName, true
	case 3508:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Time, true
	case 3509:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ReceiveTime, true
	case 3510:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_LocalTime, true
	case 3511:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Message, true
	case 3512:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Severity, true
	case 3513:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ActionTimeStamp, true
	case 3514:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Status, true
	case 3515:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ServerId, true
	case 3516:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientAuditEntryId, true
	case 3517:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientUserId, true
	case 3518:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventId, true
	case 3519:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventType, true
	case 3520:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceNode, true
	case 3521:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceName, true
	case 3522:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Time, true
	case 3523:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ReceiveTime, true
	case 3524:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_LocalTime, true
	case 3525:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Message, true
	case 3526:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Severity, true
	case 3527:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ActionTimeStamp, true
	case 3528:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Status, true
	case 3529:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ServerId, true
	case 3530:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientAuditEntryId, true
	case 3531:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientUserId, true
	case 3532:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventId, true
	case 3533:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventType, true
	case 3534:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceNode, true
	case 3535:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceName, true
	case 3536:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Time, true
	case 3537:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ReceiveTime, true
	case 3538:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_LocalTime, true
	case 3539:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Message, true
	case 3540:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Severity, true
	case 3541:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ActionTimeStamp, true
	case 3542:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Status, true
	case 3543:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ServerId, true
	case 3544:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientAuditEntryId, true
	case 3545:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientUserId, true
	case 3546:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventId, true
	case 3547:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventType, true
	case 3548:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceNode, true
	case 3549:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceName, true
	case 3550:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Time, true
	case 3551:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ReceiveTime, true
	case 3552:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_LocalTime, true
	case 3553:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Message, true
	case 3554:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Severity, true
	case 3555:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ActionTimeStamp, true
	case 3556:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Status, true
	case 3557:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ServerId, true
	case 3558:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientAuditEntryId, true
	case 3559:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientUserId, true
	case 3560:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ParameterDataTypeId, true
	case 3561:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventId, true
	case 3562:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventType, true
	case 3563:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceNode, true
	case 3564:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceName, true
	case 3565:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Time, true
	case 3566:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ReceiveTime, true
	case 3567:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_LocalTime, true
	case 3568:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Message, true
	case 3569:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Severity, true
	case 3570:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ActionTimeStamp, true
	case 3571:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Status, true
	case 3572:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ServerId, true
	case 3573:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientAuditEntryId, true
	case 3574:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientUserId, true
	case 3575:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ParameterDataTypeId, true
	case 3576:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventId, true
	case 3577:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventType, true
	case 3578:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceNode, true
	case 3579:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceName, true
	case 3580:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Time, true
	case 3581:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ReceiveTime, true
	case 3582:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_LocalTime, true
	case 3583:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Message, true
	case 3584:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Severity, true
	case 3585:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ActionTimeStamp, true
	case 3586:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Status, true
	case 3587:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ServerId, true
	case 3588:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientAuditEntryId, true
	case 3589:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientUserId, true
	case 3590:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ParameterDataTypeId, true
	case 3591:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventId, true
	case 3592:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventType, true
	case 3593:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceNode, true
	case 3594:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceName, true
	case 3595:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Time, true
	case 3596:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ReceiveTime, true
	case 3597:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_LocalTime, true
	case 3598:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Message, true
	case 3599:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Severity, true
	case 3600:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ActionTimeStamp, true
	case 3601:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Status, true
	case 3602:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ServerId, true
	case 3603:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId, true
	case 3604:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientUserId, true
	case 3605:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId, true
	case 3606:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_UpdatedNode, true
	case 3607:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventId, true
	case 3608:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventType, true
	case 3609:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceNode, true
	case 3610:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceName, true
	case 3611:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Time, true
	case 3612:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReceiveTime, true
	case 3613:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_LocalTime, true
	case 3614:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Message, true
	case 3615:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Severity, true
	case 3616:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ActionTimeStamp, true
	case 3617:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Status, true
	case 3618:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ServerId, true
	case 3619:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId, true
	case 3620:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientUserId, true
	case 3621:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId, true
	case 3622:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_UpdatedNode, true
	case 3623:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventId, true
	case 3624:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventType, true
	case 3625:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceNode, true
	case 3626:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceName, true
	case 3627:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Time, true
	case 3628:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ReceiveTime, true
	case 3629:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_LocalTime, true
	case 3630:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Message, true
	case 3631:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Severity, true
	case 3632:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ActionTimeStamp, true
	case 3633:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Status, true
	case 3634:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ServerId, true
	case 3635:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientAuditEntryId, true
	case 3636:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientUserId, true
	case 3637:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ParameterDataTypeId, true
	case 3638:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_UpdatedNode, true
	case 3639:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventId, true
	case 3640:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventType, true
	case 3641:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceNode, true
	case 3642:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceName, true
	case 3643:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Time, true
	case 3644:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ReceiveTime, true
	case 3645:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_LocalTime, true
	case 3646:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Message, true
	case 3647:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Severity, true
	case 3648:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ActionTimeStamp, true
	case 3649:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Status, true
	case 3650:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ServerId, true
	case 3651:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientAuditEntryId, true
	case 3652:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientUserId, true
	case 3758:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventId, true
	case 3759:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventType, true
	case 3760:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceNode, true
	case 3761:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceName, true
	case 3762:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Time, true
	case 3763:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ReceiveTime, true
	case 3764:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_LocalTime, true
	case 3765:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Message, true
	case 3766:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Severity, true
	case 3767:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ActionTimeStamp, true
	case 3768:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Status, true
	case 3769:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ServerId, true
	case 3770:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientAuditEntryId, true
	case 3771:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientUserId, true
	case 3772:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_MethodId, true
	case 3773:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_InputArguments, true
	case 3996:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventId, true
	case 3997:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventType, true
	case 3998:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceNode, true
	case 3999:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceName, true
	case 4000:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Time, true
	case 4001:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ReceiveTime, true
	case 4002:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_LocalTime, true
	case 4003:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Message, true
	case 4004:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Severity, true
	case 4005:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ActionTimeStamp, true
	case 4006:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Status, true
	case 4007:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ServerId, true
	case 4008:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientAuditEntryId, true
	case 4009:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientUserId, true
	case 4010:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_MethodId, true
	case 4011:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_InputArguments, true
	case 4106:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventId, true
	case 4107:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventType, true
	case 4108:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceNode, true
	case 4109:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceName, true
	case 4110:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Time, true
	case 4111:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ReceiveTime, true
	case 4112:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_LocalTime, true
	case 4113:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Message, true
	case 4114:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Severity, true
	case 4115:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ActionTimeStamp, true
	case 4116:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Status, true
	case 4117:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ServerId, true
	case 4118:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientAuditEntryId, true
	case 4119:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientUserId, true
	case 4120:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_MethodId, true
	case 4121:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_InputArguments, true
	case 4170:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventId, true
	case 4171:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventType, true
	case 4172:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceNode, true
	case 4173:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceName, true
	case 4174:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Time, true
	case 4175:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ReceiveTime, true
	case 4176:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_LocalTime, true
	case 4177:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Message, true
	case 4178:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Severity, true
	case 4179:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ActionTimeStamp, true
	case 4180:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Status, true
	case 4181:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ServerId, true
	case 4182:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientAuditEntryId, true
	case 4183:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientUserId, true
	case 4184:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_MethodId, true
	case 4185:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_InputArguments, true
	case 8928:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventId, true
	case 8929:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventType, true
	case 8930:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceNode, true
	case 8931:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceName, true
	case 8932:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Time, true
	case 8933:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ReceiveTime, true
	case 8934:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_LocalTime, true
	case 8935:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Message, true
	case 8936:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Severity, true
	case 8937:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ActionTimeStamp, true
	case 8938:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Status, true
	case 8939:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ServerId, true
	case 8940:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientAuditEntryId, true
	case 8941:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientUserId, true
	case 8942:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_MethodId, true
	case 8943:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_InputArguments, true
	case 8945:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventId, true
	case 8946:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventType, true
	case 8947:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceNode, true
	case 8948:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceName, true
	case 8949:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Time, true
	case 8950:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ReceiveTime, true
	case 8951:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_LocalTime, true
	case 8952:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Message, true
	case 8953:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Severity, true
	case 8954:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ActionTimeStamp, true
	case 8955:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Status, true
	case 8956:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ServerId, true
	case 8957:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientAuditEntryId, true
	case 8958:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientUserId, true
	case 8959:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_MethodId, true
	case 8960:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_InputArguments, true
	case 8962:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventId, true
	case 8963:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventType, true
	case 8964:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceNode, true
	case 8965:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceName, true
	case 8966:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Time, true
	case 8967:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ReceiveTime, true
	case 8968:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_LocalTime, true
	case 8969:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Message, true
	case 8970:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Severity, true
	case 8971:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ActionTimeStamp, true
	case 8972:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Status, true
	case 8973:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ServerId, true
	case 8974:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientAuditEntryId, true
	case 8975:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientUserId, true
	case 8976:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_MethodId, true
	case 8977:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAuditByName(value string) (enum OpcuaNodeIdServicesVariableAudit, ok bool) {
	switch value {
	case "AuditConditionShelvingEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventId, true
	case "AuditConditionShelvingEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventType, true
	case "AuditConditionShelvingEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceNode, true
	case "AuditConditionShelvingEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceName, true
	case "AuditConditionShelvingEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Time, true
	case "AuditConditionShelvingEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ReceiveTime, true
	case "AuditConditionShelvingEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_LocalTime, true
	case "AuditConditionShelvingEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Message, true
	case "AuditConditionShelvingEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Severity, true
	case "AuditConditionShelvingEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ActionTimeStamp, true
	case "AuditConditionShelvingEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Status, true
	case "AuditConditionShelvingEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ServerId, true
	case "AuditConditionShelvingEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientAuditEntryId, true
	case "AuditConditionShelvingEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientUserId, true
	case "AuditConditionShelvingEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_MethodId, true
	case "AuditConditionShelvingEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_InputArguments, true
	case "AuditActivateSessionEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId, true
	case "AuditConditionCommentEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment, true
	case "AuditConditionRespondEventType_SelectedResponse":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse, true
	case "AuditConditionAcknowledgeEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment, true
	case "AuditConditionConfirmEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment, true
	case "AuditConditionShelvingEventType_ShelvingTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime, true
	case "AuditProgramTransitionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventId, true
	case "AuditProgramTransitionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventType, true
	case "AuditProgramTransitionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceNode, true
	case "AuditProgramTransitionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceName, true
	case "AuditProgramTransitionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Time, true
	case "AuditProgramTransitionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ReceiveTime, true
	case "AuditProgramTransitionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_LocalTime, true
	case "AuditProgramTransitionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Message, true
	case "AuditProgramTransitionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Severity, true
	case "AuditProgramTransitionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ActionTimeStamp, true
	case "AuditProgramTransitionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Status, true
	case "AuditProgramTransitionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ServerId, true
	case "AuditProgramTransitionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientAuditEntryId, true
	case "AuditProgramTransitionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientUserId, true
	case "AuditProgramTransitionEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_MethodId, true
	case "AuditProgramTransitionEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_InputArguments, true
	case "AuditProgramTransitionEventType_OldStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_OldStateId, true
	case "AuditProgramTransitionEventType_NewStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_NewStateId, true
	case "AuditProgramTransitionEventType_TransitionNumber":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber, true
	case "AuditCreateSessionEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SessionId, true
	case "AuditUrlMismatchEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SessionId, true
	case "AuditConditionResetEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventId, true
	case "AuditConditionResetEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventType, true
	case "AuditConditionResetEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceNode, true
	case "AuditConditionResetEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceName, true
	case "AuditConditionResetEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Time, true
	case "AuditConditionResetEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ReceiveTime, true
	case "AuditConditionResetEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_LocalTime, true
	case "AuditConditionResetEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Message, true
	case "AuditConditionResetEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Severity, true
	case "AuditConditionResetEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ActionTimeStamp, true
	case "AuditConditionResetEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Status, true
	case "AuditConditionResetEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ServerId, true
	case "AuditConditionResetEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientAuditEntryId, true
	case "AuditConditionResetEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientUserId, true
	case "AuditConditionResetEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_MethodId, true
	case "AuditConditionResetEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_InputArguments, true
	case "AuditConditionCommentEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId, true
	case "AuditConditionAcknowledgeEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId, true
	case "AuditConditionConfirmEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId, true
	case "AuditConditionSuppressionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventId, true
	case "AuditConditionSuppressionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventType, true
	case "AuditConditionSuppressionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceNode, true
	case "AuditConditionSuppressionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceName, true
	case "AuditConditionSuppressionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Time, true
	case "AuditConditionSuppressionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ReceiveTime, true
	case "AuditConditionSuppressionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_LocalTime, true
	case "AuditConditionSuppressionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Message, true
	case "AuditConditionSuppressionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Severity, true
	case "AuditConditionSuppressionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ActionTimeStamp, true
	case "AuditConditionSuppressionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Status, true
	case "AuditConditionSuppressionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ServerId, true
	case "AuditConditionSuppressionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientAuditEntryId, true
	case "AuditConditionSuppressionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientUserId, true
	case "AuditConditionSuppressionEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_MethodId, true
	case "AuditConditionSuppressionEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_InputArguments, true
	case "AuditConditionSilenceEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventId, true
	case "AuditConditionSilenceEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventType, true
	case "AuditConditionSilenceEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceNode, true
	case "AuditConditionSilenceEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceName, true
	case "AuditConditionSilenceEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Time, true
	case "AuditConditionSilenceEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ReceiveTime, true
	case "AuditConditionSilenceEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_LocalTime, true
	case "AuditConditionSilenceEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Message, true
	case "AuditConditionSilenceEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Severity, true
	case "AuditConditionSilenceEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ActionTimeStamp, true
	case "AuditConditionSilenceEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Status, true
	case "AuditConditionSilenceEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ServerId, true
	case "AuditConditionSilenceEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientAuditEntryId, true
	case "AuditConditionSilenceEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientUserId, true
	case "AuditConditionSilenceEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_MethodId, true
	case "AuditConditionSilenceEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_InputArguments, true
	case "AuditConditionOutOfServiceEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventId, true
	case "AuditConditionOutOfServiceEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventType, true
	case "AuditConditionOutOfServiceEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceNode, true
	case "AuditConditionOutOfServiceEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceName, true
	case "AuditConditionOutOfServiceEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Time, true
	case "AuditConditionOutOfServiceEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ReceiveTime, true
	case "AuditConditionOutOfServiceEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_LocalTime, true
	case "AuditConditionOutOfServiceEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Message, true
	case "AuditConditionOutOfServiceEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Severity, true
	case "AuditConditionOutOfServiceEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ActionTimeStamp, true
	case "AuditConditionOutOfServiceEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Status, true
	case "AuditConditionOutOfServiceEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ServerId, true
	case "AuditConditionOutOfServiceEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientAuditEntryId, true
	case "AuditConditionOutOfServiceEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientUserId, true
	case "AuditConditionOutOfServiceEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_MethodId, true
	case "AuditConditionOutOfServiceEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_InputArguments, true
	case "AuditSecurityEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId, true
	case "AuditChannelEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_StatusCodeId, true
	case "AuditOpenSecureChannelEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_StatusCodeId, true
	case "AuditSessionEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_StatusCodeId, true
	case "AuditCreateSessionEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_StatusCodeId, true
	case "AuditUrlMismatchEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_StatusCodeId, true
	case "AuditActivateSessionEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_StatusCodeId, true
	case "AuditCancelEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_StatusCodeId, true
	case "AuditCertificateEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_StatusCodeId, true
	case "AuditCertificateDataMismatchEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_StatusCodeId, true
	case "AuditCertificateExpiredEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_StatusCodeId, true
	case "AuditCertificateInvalidEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_StatusCodeId, true
	case "AuditCertificateUntrustedEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_StatusCodeId, true
	case "AuditCertificateRevokedEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_StatusCodeId, true
	case "AuditCertificateMismatchEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_StatusCodeId, true
	case "AuditHistoryAnnotationUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventId, true
	case "AuditHistoryAnnotationUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventType, true
	case "AuditHistoryAnnotationUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceNode, true
	case "AuditHistoryAnnotationUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceName, true
	case "AuditHistoryAnnotationUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Time, true
	case "AuditHistoryAnnotationUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ReceiveTime, true
	case "AuditHistoryAnnotationUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_LocalTime, true
	case "AuditHistoryAnnotationUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Message, true
	case "AuditHistoryAnnotationUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Severity, true
	case "AuditHistoryAnnotationUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ActionTimeStamp, true
	case "AuditHistoryAnnotationUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Status, true
	case "AuditHistoryAnnotationUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ServerId, true
	case "AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId, true
	case "AuditHistoryAnnotationUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientUserId, true
	case "AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId, true
	case "AuditHistoryAnnotationUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryAnnotationUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues, true
	case "AuditHistoryAnnotationUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues, true
	case "AuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp, true
	case "AuditEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Status, true
	case "AuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId, true
	case "AuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId, true
	case "AuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId, true
	case "AuditOpenSecureChannelEventType_ClientCertificate":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate, true
	case "AuditOpenSecureChannelEventType_RequestType":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType, true
	case "AuditOpenSecureChannelEventType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri, true
	case "AuditOpenSecureChannelEventType_SecurityMode":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode, true
	case "AuditOpenSecureChannelEventType_RequestedLifetime":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime, true
	case "AuditSessionEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId, true
	case "AuditCreateSessionEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId, true
	case "AuditCreateSessionEventType_ClientCertificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate, true
	case "AuditCreateSessionEventType_RevisedSessionTimeout":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout, true
	case "AuditActivateSessionEventType_ClientSoftwareCertificates":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates, true
	case "AuditActivateSessionEventType_UserIdentityToken":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken, true
	case "AuditCancelEventType_RequestHandle":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle, true
	case "AuditCertificateEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate, true
	case "AuditCertificateDataMismatchEventType_InvalidHostname":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname, true
	case "AuditCertificateDataMismatchEventType_InvalidUri":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri, true
	case "AuditAddNodesEventType_NodesToAdd":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd, true
	case "AuditDeleteNodesEventType_NodesToDelete":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete, true
	case "AuditAddReferencesEventType_ReferencesToAdd":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd, true
	case "AuditDeleteReferencesEventType_ReferencesToDelete":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete, true
	case "AuditWriteUpdateEventType_IndexRange":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange, true
	case "AuditWriteUpdateEventType_OldValue":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue, true
	case "AuditWriteUpdateEventType_NewValue":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue, true
	case "AuditUpdateMethodEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId, true
	case "AuditUpdateMethodEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments, true
	case "AuditClientEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventId, true
	case "AuditClientEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventType, true
	case "AuditClientEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceNode, true
	case "AuditClientEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceName, true
	case "AuditClientEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Time, true
	case "AuditClientEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ReceiveTime, true
	case "AuditClientEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_LocalTime, true
	case "AuditClientEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Message, true
	case "AuditClientEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Severity, true
	case "AuditClientEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ActionTimeStamp, true
	case "AuditClientEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Status, true
	case "AuditClientEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerId, true
	case "AuditClientEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientAuditEntryId, true
	case "AuditClientEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientUserId, true
	case "AuditClientEventType_ServerUri":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri, true
	case "AuditClientUpdateMethodResultEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventId, true
	case "AuditClientUpdateMethodResultEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventType, true
	case "AuditClientUpdateMethodResultEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceNode, true
	case "AuditClientUpdateMethodResultEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceName, true
	case "AuditClientUpdateMethodResultEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Time, true
	case "AuditClientUpdateMethodResultEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ReceiveTime, true
	case "AuditClientUpdateMethodResultEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_LocalTime, true
	case "AuditClientUpdateMethodResultEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Message, true
	case "AuditClientUpdateMethodResultEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Severity, true
	case "AuditClientUpdateMethodResultEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ActionTimeStamp, true
	case "AuditClientUpdateMethodResultEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Status, true
	case "AuditClientUpdateMethodResultEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerId, true
	case "AuditClientUpdateMethodResultEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientAuditEntryId, true
	case "AuditClientUpdateMethodResultEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientUserId, true
	case "AuditClientUpdateMethodResultEventType_ServerUri":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerUri, true
	case "AuditClientUpdateMethodResultEventType_ObjectId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId, true
	case "AuditClientUpdateMethodResultEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId, true
	case "AuditClientUpdateMethodResultEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId, true
	case "AuditClientUpdateMethodResultEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments, true
	case "AuditOpenSecureChannelEventType_CertificateErrorEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId, true
	case "AuditClientUpdateMethodResultEventType_OutputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments, true
	case "AuditChannelEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId, true
	case "AuditOpenSecureChannelEventType_ClientCertificateThumbprint":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint, true
	case "AuditCreateSessionEventType_ClientCertificateThumbprint":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint, true
	case "AuditUrlMismatchEventType_EndpointUrl":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl, true
	case "AuditWriteUpdateEventType_AttributeId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId, true
	case "AuditHistoryUpdateEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId, true
	case "AuditUpdateStateEventType_OldStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId, true
	case "AuditUpdateStateEventType_NewStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId, true
	case "AuditHistoryEventUpdateEventType_Filter":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter, true
	case "AuditHistoryRawModifyDeleteEventType_IsDeleteModified":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified, true
	case "AuditHistoryRawModifyDeleteEventType_StartTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime, true
	case "AuditHistoryRawModifyDeleteEventType_EndTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime, true
	case "AuditHistoryAtTimeDeleteEventType_ReqTimes":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes, true
	case "AuditHistoryAtTimeDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues, true
	case "AuditHistoryEventDeleteEventType_EventIds":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds, true
	case "AuditHistoryEventDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues, true
	case "AuditHistoryEventUpdateEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode, true
	case "AuditHistoryValueUpdateEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode, true
	case "AuditHistoryDeleteEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode, true
	case "AuditHistoryEventUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryEventUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues, true
	case "AuditHistoryEventUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues, true
	case "AuditHistoryValueUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryValueUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues, true
	case "AuditHistoryValueUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues, true
	case "AuditHistoryRawModifyDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues, true
	case "AuditEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassId, true
	case "AuditEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassName, true
	case "AuditEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassId, true
	case "AuditEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassName, true
	case "AuditSecurityEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassId, true
	case "AuditSecurityEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassName, true
	case "AuditSecurityEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassId, true
	case "AuditSecurityEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassName, true
	case "AuditChannelEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassId, true
	case "AuditChannelEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassName, true
	case "AuditChannelEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassId, true
	case "AuditChannelEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassName, true
	case "AuditOpenSecureChannelEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassId, true
	case "AuditOpenSecureChannelEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassName, true
	case "AuditOpenSecureChannelEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassId, true
	case "AuditOpenSecureChannelEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassName, true
	case "AuditSessionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassId, true
	case "AuditSessionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassName, true
	case "AuditSessionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassId, true
	case "AuditSessionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassName, true
	case "AuditCreateSessionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassId, true
	case "AuditCreateSessionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassName, true
	case "AuditCreateSessionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassId, true
	case "AuditCreateSessionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassName, true
	case "AuditUrlMismatchEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassId, true
	case "AuditUrlMismatchEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassName, true
	case "AuditUrlMismatchEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassId, true
	case "AuditUrlMismatchEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassName, true
	case "AuditActivateSessionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassId, true
	case "AuditActivateSessionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassName, true
	case "AuditActivateSessionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassId, true
	case "AuditActivateSessionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassName, true
	case "AuditCancelEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassId, true
	case "AuditCancelEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassName, true
	case "AuditCancelEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassId, true
	case "AuditCancelEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassName, true
	case "AuditCertificateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassId, true
	case "AuditCertificateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassName, true
	case "AuditCertificateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassId, true
	case "AuditCertificateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassName, true
	case "AuditCertificateDataMismatchEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassId, true
	case "AuditCertificateDataMismatchEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassName, true
	case "AuditCertificateDataMismatchEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassId, true
	case "AuditCertificateDataMismatchEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassName, true
	case "AuditCertificateExpiredEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassId, true
	case "AuditCertificateExpiredEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassName, true
	case "AuditCertificateExpiredEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassId, true
	case "AuditCertificateExpiredEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassName, true
	case "AuditCertificateInvalidEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassId, true
	case "AuditCertificateInvalidEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassName, true
	case "AuditCertificateInvalidEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassId, true
	case "AuditCertificateInvalidEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassName, true
	case "AuditCertificateUntrustedEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassId, true
	case "AuditCertificateUntrustedEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassName, true
	case "AuditCertificateUntrustedEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassId, true
	case "AuditCertificateUntrustedEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassName, true
	case "AuditCertificateRevokedEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassId, true
	case "AuditCertificateRevokedEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassName, true
	case "AuditCertificateRevokedEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassId, true
	case "AuditCertificateRevokedEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassName, true
	case "AuditCertificateMismatchEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassId, true
	case "AuditCertificateMismatchEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassName, true
	case "AuditCertificateMismatchEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassId, true
	case "AuditCertificateMismatchEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassName, true
	case "AuditNodeManagementEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassId, true
	case "AuditNodeManagementEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassName, true
	case "AuditNodeManagementEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassId, true
	case "AuditNodeManagementEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassName, true
	case "AuditAddNodesEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassId, true
	case "AuditAddNodesEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassName, true
	case "AuditAddNodesEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassId, true
	case "AuditAddNodesEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassName, true
	case "AuditDeleteNodesEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassId, true
	case "AuditDeleteNodesEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassName, true
	case "AuditDeleteNodesEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassId, true
	case "AuditDeleteNodesEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassName, true
	case "AuditAddReferencesEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassId, true
	case "AuditAddReferencesEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassName, true
	case "AuditAddReferencesEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassId, true
	case "AuditAddReferencesEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassName, true
	case "AuditDeleteReferencesEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassId, true
	case "AuditDeleteReferencesEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassName, true
	case "AuditDeleteReferencesEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassId, true
	case "AuditDeleteReferencesEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassName, true
	case "AuditUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassId, true
	case "AuditUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassName, true
	case "AuditUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassId, true
	case "AuditUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassName, true
	case "AuditWriteUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassId, true
	case "AuditWriteUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassName, true
	case "AuditWriteUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassId, true
	case "AuditWriteUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassName, true
	case "AuditHistoryUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassId, true
	case "AuditHistoryUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassName, true
	case "AuditHistoryUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassId, true
	case "AuditHistoryUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassName, true
	case "AuditUpdateMethodEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassId, true
	case "AuditUpdateMethodEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassName, true
	case "AuditUpdateMethodEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassId, true
	case "AuditUpdateMethodEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassName, true
	case "AuditClientEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassId, true
	case "AuditClientEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassName, true
	case "AuditClientEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassId, true
	case "AuditClientEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassName, true
	case "AuditClientUpdateMethodResultEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassId, true
	case "AuditClientUpdateMethodResultEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassName, true
	case "AuditClientUpdateMethodResultEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassId, true
	case "AuditClientUpdateMethodResultEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassName, true
	case "AuditUpdateStateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassId, true
	case "AuditUpdateStateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassName, true
	case "AuditUpdateStateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassId, true
	case "AuditUpdateStateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassName, true
	case "AuditConditionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassId, true
	case "AuditConditionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassName, true
	case "AuditConditionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassId, true
	case "AuditConditionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassName, true
	case "AuditConditionEnableEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassId, true
	case "AuditConditionEnableEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassName, true
	case "AuditConditionEnableEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassId, true
	case "AuditConditionEnableEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassName, true
	case "AuditConditionCommentEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassId, true
	case "AuditConditionCommentEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassName, true
	case "AuditConditionCommentEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassId, true
	case "AuditConditionCommentEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassName, true
	case "AuditConditionRespondEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassId, true
	case "AuditConditionRespondEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassName, true
	case "AuditConditionRespondEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassId, true
	case "AuditConditionRespondEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassName, true
	case "AuditConditionAcknowledgeEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassId, true
	case "AuditConditionAcknowledgeEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassName, true
	case "AuditConditionAcknowledgeEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassId, true
	case "AuditConditionAcknowledgeEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassName, true
	case "AuditConditionConfirmEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassId, true
	case "AuditConditionConfirmEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassName, true
	case "AuditConditionConfirmEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassId, true
	case "AuditConditionConfirmEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassName, true
	case "AuditConditionShelvingEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassId, true
	case "AuditConditionShelvingEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassName, true
	case "AuditConditionShelvingEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassId, true
	case "AuditConditionShelvingEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassName, true
	case "AuditConditionSuppressionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassId, true
	case "AuditConditionSuppressionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassName, true
	case "AuditConditionSuppressionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassId, true
	case "AuditConditionSuppressionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassName, true
	case "AuditConditionSilenceEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassId, true
	case "AuditConditionSilenceEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassName, true
	case "AuditConditionSilenceEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassId, true
	case "AuditConditionSilenceEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassName, true
	case "AuditConditionResetEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassId, true
	case "AuditConditionResetEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassName, true
	case "AuditConditionResetEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassId, true
	case "AuditConditionResetEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassName, true
	case "AuditConditionOutOfServiceEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassId, true
	case "AuditConditionOutOfServiceEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassName, true
	case "AuditConditionOutOfServiceEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassId, true
	case "AuditConditionOutOfServiceEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassName, true
	case "AuditProgramTransitionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassId, true
	case "AuditProgramTransitionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassName, true
	case "AuditProgramTransitionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassId, true
	case "AuditProgramTransitionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassName, true
	case "AuditHistoryEventUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassId, true
	case "AuditEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_EventId, true
	case "AuditHistoryEventUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassName, true
	case "AuditHistoryEventUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassId, true
	case "AuditHistoryEventUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassName, true
	case "AuditHistoryValueUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassId, true
	case "AuditHistoryValueUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassName, true
	case "AuditHistoryValueUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassId, true
	case "AuditHistoryValueUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassName, true
	case "AuditHistoryAnnotationUpdateEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassId, true
	case "AuditHistoryAnnotationUpdateEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassName, true
	case "AuditHistoryAnnotationUpdateEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassId, true
	case "AuditEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_EventType, true
	case "AuditHistoryAnnotationUpdateEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassName, true
	case "AuditHistoryDeleteEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassId, true
	case "AuditHistoryDeleteEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassName, true
	case "AuditHistoryDeleteEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassId, true
	case "AuditHistoryDeleteEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassName, true
	case "AuditHistoryRawModifyDeleteEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassId, true
	case "AuditHistoryRawModifyDeleteEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassName, true
	case "AuditHistoryRawModifyDeleteEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassId, true
	case "AuditHistoryRawModifyDeleteEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassName, true
	case "AuditHistoryAtTimeDeleteEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassId, true
	case "AuditEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceNode, true
	case "AuditHistoryAtTimeDeleteEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassName, true
	case "AuditHistoryAtTimeDeleteEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassId, true
	case "AuditHistoryAtTimeDeleteEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassName, true
	case "AuditHistoryEventDeleteEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassId, true
	case "AuditHistoryEventDeleteEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassName, true
	case "AuditHistoryEventDeleteEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassId, true
	case "AuditHistoryEventDeleteEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassName, true
	case "AuditEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceName, true
	case "AuditEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Time, true
	case "AuditEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ReceiveTime, true
	case "AuditEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_LocalTime, true
	case "AuditEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Message, true
	case "AuditEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Severity, true
	case "AuditSecurityEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventId, true
	case "AuditSecurityEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventType, true
	case "AuditSecurityEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceNode, true
	case "AuditSecurityEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceName, true
	case "AuditSecurityEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Time, true
	case "AuditSecurityEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ReceiveTime, true
	case "AuditSecurityEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_LocalTime, true
	case "AuditSecurityEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Message, true
	case "AuditSecurityEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Severity, true
	case "AuditSecurityEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ActionTimeStamp, true
	case "AuditSecurityEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Status, true
	case "AuditSecurityEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ServerId, true
	case "AuditSecurityEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientAuditEntryId, true
	case "AuditSecurityEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientUserId, true
	case "AuditChannelEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventId, true
	case "AuditChannelEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventType, true
	case "AuditChannelEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceNode, true
	case "AuditChannelEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceName, true
	case "AuditChannelEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Time, true
	case "AuditChannelEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ReceiveTime, true
	case "AuditChannelEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_LocalTime, true
	case "AuditChannelEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Message, true
	case "AuditChannelEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Severity, true
	case "AuditChannelEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ActionTimeStamp, true
	case "AuditChannelEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Status, true
	case "AuditChannelEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ServerId, true
	case "AuditChannelEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientAuditEntryId, true
	case "AuditChannelEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientUserId, true
	case "AuditOpenSecureChannelEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventId, true
	case "AuditOpenSecureChannelEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventType, true
	case "AuditOpenSecureChannelEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceNode, true
	case "AuditOpenSecureChannelEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceName, true
	case "AuditOpenSecureChannelEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Time, true
	case "AuditOpenSecureChannelEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ReceiveTime, true
	case "AuditOpenSecureChannelEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_LocalTime, true
	case "AuditOpenSecureChannelEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Message, true
	case "AuditOpenSecureChannelEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Severity, true
	case "AuditOpenSecureChannelEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ActionTimeStamp, true
	case "AuditOpenSecureChannelEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Status, true
	case "AuditOpenSecureChannelEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ServerId, true
	case "AuditOpenSecureChannelEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientAuditEntryId, true
	case "AuditOpenSecureChannelEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientUserId, true
	case "AuditOpenSecureChannelEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecureChannelId, true
	case "AuditSessionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventId, true
	case "AuditSessionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventType, true
	case "AuditSessionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceNode, true
	case "AuditSessionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceName, true
	case "AuditSessionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Time, true
	case "AuditSessionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ReceiveTime, true
	case "AuditSessionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_LocalTime, true
	case "AuditSessionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Message, true
	case "AuditSessionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Severity, true
	case "AuditSessionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ActionTimeStamp, true
	case "AuditSessionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Status, true
	case "AuditSessionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ServerId, true
	case "AuditSessionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientAuditEntryId, true
	case "AuditSessionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientUserId, true
	case "AuditCreateSessionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventId, true
	case "AuditCreateSessionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventType, true
	case "AuditCreateSessionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceNode, true
	case "AuditCreateSessionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceName, true
	case "AuditCreateSessionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Time, true
	case "AuditCreateSessionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ReceiveTime, true
	case "AuditCreateSessionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_LocalTime, true
	case "AuditCreateSessionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Message, true
	case "AuditCreateSessionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Severity, true
	case "AuditCreateSessionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ActionTimeStamp, true
	case "AuditCreateSessionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Status, true
	case "AuditCreateSessionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ServerId, true
	case "AuditCreateSessionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientAuditEntryId, true
	case "AuditCreateSessionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientUserId, true
	case "AuditUrlMismatchEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventId, true
	case "AuditUrlMismatchEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventType, true
	case "AuditUrlMismatchEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceNode, true
	case "AuditUrlMismatchEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceName, true
	case "AuditUrlMismatchEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Time, true
	case "AuditUrlMismatchEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ReceiveTime, true
	case "AuditUrlMismatchEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_LocalTime, true
	case "AuditUrlMismatchEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Message, true
	case "AuditUrlMismatchEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Severity, true
	case "AuditUrlMismatchEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ActionTimeStamp, true
	case "AuditUrlMismatchEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Status, true
	case "AuditUrlMismatchEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ServerId, true
	case "AuditUrlMismatchEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientAuditEntryId, true
	case "AuditUrlMismatchEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientUserId, true
	case "AuditUrlMismatchEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SecureChannelId, true
	case "AuditUrlMismatchEventType_ClientCertificate":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificate, true
	case "AuditUrlMismatchEventType_ClientCertificateThumbprint":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificateThumbprint, true
	case "AuditUrlMismatchEventType_RevisedSessionTimeout":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_RevisedSessionTimeout, true
	case "AuditActivateSessionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventId, true
	case "AuditActivateSessionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventType, true
	case "AuditActivateSessionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceNode, true
	case "AuditActivateSessionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceName, true
	case "AuditActivateSessionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Time, true
	case "AuditActivateSessionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ReceiveTime, true
	case "AuditActivateSessionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_LocalTime, true
	case "AuditActivateSessionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Message, true
	case "AuditActivateSessionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Severity, true
	case "AuditActivateSessionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ActionTimeStamp, true
	case "AuditActivateSessionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Status, true
	case "AuditActivateSessionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ServerId, true
	case "AuditActivateSessionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientAuditEntryId, true
	case "AuditActivateSessionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientUserId, true
	case "AuditActivateSessionEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SessionId, true
	case "AuditCancelEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventId, true
	case "AuditCancelEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventType, true
	case "AuditCancelEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceNode, true
	case "AuditCancelEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceName, true
	case "AuditCancelEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Time, true
	case "AuditCancelEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ReceiveTime, true
	case "AuditCancelEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_LocalTime, true
	case "AuditCancelEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Message, true
	case "AuditCancelEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Severity, true
	case "AuditCancelEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ActionTimeStamp, true
	case "AuditCancelEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Status, true
	case "AuditCancelEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ServerId, true
	case "AuditCancelEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientAuditEntryId, true
	case "AuditCancelEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientUserId, true
	case "AuditCancelEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SessionId, true
	case "AuditCertificateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventId, true
	case "AuditCertificateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventType, true
	case "AuditCertificateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceNode, true
	case "AuditCertificateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceName, true
	case "AuditCertificateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Time, true
	case "AuditCertificateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ReceiveTime, true
	case "AuditCertificateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_LocalTime, true
	case "AuditCertificateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Message, true
	case "AuditCertificateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Severity, true
	case "AuditCertificateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ActionTimeStamp, true
	case "AuditCertificateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Status, true
	case "AuditCertificateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ServerId, true
	case "AuditCertificateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientAuditEntryId, true
	case "AuditCertificateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientUserId, true
	case "AuditCertificateDataMismatchEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventId, true
	case "AuditCertificateDataMismatchEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventType, true
	case "AuditCertificateDataMismatchEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceNode, true
	case "AuditCertificateDataMismatchEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceName, true
	case "AuditCertificateDataMismatchEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Time, true
	case "AuditCertificateDataMismatchEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ReceiveTime, true
	case "AuditCertificateDataMismatchEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_LocalTime, true
	case "AuditCertificateDataMismatchEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Message, true
	case "AuditCertificateDataMismatchEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Severity, true
	case "AuditCertificateDataMismatchEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ActionTimeStamp, true
	case "AuditCertificateDataMismatchEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Status, true
	case "AuditCertificateDataMismatchEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ServerId, true
	case "AuditCertificateDataMismatchEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientAuditEntryId, true
	case "AuditCertificateDataMismatchEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientUserId, true
	case "AuditCertificateDataMismatchEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Certificate, true
	case "AuditCertificateExpiredEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventId, true
	case "AuditCertificateExpiredEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventType, true
	case "AuditCertificateExpiredEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceNode, true
	case "AuditCertificateExpiredEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceName, true
	case "AuditCertificateExpiredEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Time, true
	case "AuditCertificateExpiredEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ReceiveTime, true
	case "AuditCertificateExpiredEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_LocalTime, true
	case "AuditCertificateExpiredEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Message, true
	case "AuditCertificateExpiredEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Severity, true
	case "AuditCertificateExpiredEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ActionTimeStamp, true
	case "AuditCertificateExpiredEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Status, true
	case "AuditCertificateExpiredEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ServerId, true
	case "AuditCertificateExpiredEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientAuditEntryId, true
	case "AuditCertificateExpiredEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientUserId, true
	case "AuditCertificateExpiredEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Certificate, true
	case "AuditCertificateInvalidEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventId, true
	case "AuditCertificateInvalidEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventType, true
	case "AuditCertificateInvalidEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceNode, true
	case "AuditCertificateInvalidEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceName, true
	case "AuditCertificateInvalidEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Time, true
	case "AuditCertificateInvalidEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ReceiveTime, true
	case "AuditCertificateInvalidEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_LocalTime, true
	case "AuditCertificateInvalidEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Message, true
	case "AuditCertificateInvalidEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Severity, true
	case "AuditCertificateInvalidEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ActionTimeStamp, true
	case "AuditCertificateInvalidEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Status, true
	case "AuditCertificateInvalidEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ServerId, true
	case "AuditCertificateInvalidEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientAuditEntryId, true
	case "AuditCertificateInvalidEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientUserId, true
	case "AuditCertificateInvalidEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Certificate, true
	case "AuditCertificateUntrustedEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventId, true
	case "AuditCertificateUntrustedEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventType, true
	case "AuditCertificateUntrustedEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceNode, true
	case "AuditCertificateUntrustedEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceName, true
	case "AuditCertificateUntrustedEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Time, true
	case "AuditCertificateUntrustedEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ReceiveTime, true
	case "AuditCertificateUntrustedEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_LocalTime, true
	case "AuditCertificateUntrustedEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Message, true
	case "AuditCertificateUntrustedEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Severity, true
	case "AuditCertificateUntrustedEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ActionTimeStamp, true
	case "AuditCertificateUntrustedEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Status, true
	case "AuditCertificateUntrustedEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ServerId, true
	case "AuditCertificateUntrustedEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientAuditEntryId, true
	case "AuditCertificateUntrustedEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientUserId, true
	case "AuditCertificateUntrustedEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Certificate, true
	case "AuditCertificateRevokedEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventId, true
	case "AuditCertificateRevokedEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventType, true
	case "AuditCertificateRevokedEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceNode, true
	case "AuditCertificateRevokedEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceName, true
	case "AuditCertificateRevokedEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Time, true
	case "AuditCertificateRevokedEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ReceiveTime, true
	case "AuditCertificateRevokedEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_LocalTime, true
	case "AuditCertificateRevokedEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Message, true
	case "AuditCertificateRevokedEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Severity, true
	case "AuditCertificateRevokedEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ActionTimeStamp, true
	case "AuditCertificateRevokedEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Status, true
	case "AuditCertificateRevokedEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ServerId, true
	case "AuditCertificateRevokedEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientAuditEntryId, true
	case "AuditCertificateRevokedEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientUserId, true
	case "AuditCertificateRevokedEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Certificate, true
	case "AuditCertificateMismatchEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventId, true
	case "AuditCertificateMismatchEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventType, true
	case "AuditCertificateMismatchEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceNode, true
	case "AuditCertificateMismatchEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceName, true
	case "AuditCertificateMismatchEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Time, true
	case "AuditCertificateMismatchEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ReceiveTime, true
	case "AuditCertificateMismatchEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_LocalTime, true
	case "AuditCertificateMismatchEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Message, true
	case "AuditCertificateMismatchEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Severity, true
	case "AuditCertificateMismatchEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ActionTimeStamp, true
	case "AuditCertificateMismatchEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Status, true
	case "AuditCertificateMismatchEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ServerId, true
	case "AuditCertificateMismatchEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientAuditEntryId, true
	case "AuditCertificateMismatchEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientUserId, true
	case "AuditCertificateMismatchEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Certificate, true
	case "AuditNodeManagementEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventId, true
	case "AuditNodeManagementEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventType, true
	case "AuditNodeManagementEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceNode, true
	case "AuditNodeManagementEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceName, true
	case "AuditNodeManagementEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Time, true
	case "AuditNodeManagementEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ReceiveTime, true
	case "AuditNodeManagementEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_LocalTime, true
	case "AuditNodeManagementEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Message, true
	case "AuditNodeManagementEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Severity, true
	case "AuditNodeManagementEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ActionTimeStamp, true
	case "AuditNodeManagementEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Status, true
	case "AuditNodeManagementEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ServerId, true
	case "AuditNodeManagementEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientAuditEntryId, true
	case "AuditNodeManagementEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientUserId, true
	case "AuditAddNodesEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventId, true
	case "AuditAddNodesEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventType, true
	case "AuditAddNodesEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceNode, true
	case "AuditAddNodesEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceName, true
	case "AuditAddNodesEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Time, true
	case "AuditAddNodesEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ReceiveTime, true
	case "AuditAddNodesEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_LocalTime, true
	case "AuditAddNodesEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Message, true
	case "AuditAddNodesEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Severity, true
	case "AuditAddNodesEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ActionTimeStamp, true
	case "AuditAddNodesEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Status, true
	case "AuditAddNodesEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ServerId, true
	case "AuditAddNodesEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientAuditEntryId, true
	case "AuditAddNodesEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientUserId, true
	case "AuditDeleteNodesEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventId, true
	case "AuditDeleteNodesEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventType, true
	case "AuditDeleteNodesEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceNode, true
	case "AuditDeleteNodesEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceName, true
	case "AuditDeleteNodesEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Time, true
	case "AuditDeleteNodesEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ReceiveTime, true
	case "AuditDeleteNodesEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_LocalTime, true
	case "AuditDeleteNodesEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Message, true
	case "AuditDeleteNodesEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Severity, true
	case "AuditDeleteNodesEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ActionTimeStamp, true
	case "AuditDeleteNodesEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Status, true
	case "AuditDeleteNodesEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ServerId, true
	case "AuditDeleteNodesEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientAuditEntryId, true
	case "AuditDeleteNodesEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientUserId, true
	case "AuditAddReferencesEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventId, true
	case "AuditAddReferencesEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventType, true
	case "AuditAddReferencesEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceNode, true
	case "AuditAddReferencesEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceName, true
	case "AuditAddReferencesEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Time, true
	case "AuditAddReferencesEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReceiveTime, true
	case "AuditAddReferencesEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_LocalTime, true
	case "AuditAddReferencesEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Message, true
	case "AuditAddReferencesEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Severity, true
	case "AuditAddReferencesEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ActionTimeStamp, true
	case "AuditAddReferencesEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Status, true
	case "AuditAddReferencesEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ServerId, true
	case "AuditAddReferencesEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientAuditEntryId, true
	case "AuditAddReferencesEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientUserId, true
	case "AuditDeleteReferencesEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventId, true
	case "AuditDeleteReferencesEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventType, true
	case "AuditDeleteReferencesEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceNode, true
	case "AuditDeleteReferencesEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceName, true
	case "AuditDeleteReferencesEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Time, true
	case "AuditDeleteReferencesEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReceiveTime, true
	case "AuditDeleteReferencesEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_LocalTime, true
	case "AuditDeleteReferencesEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Message, true
	case "AuditDeleteReferencesEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Severity, true
	case "AuditDeleteReferencesEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ActionTimeStamp, true
	case "AuditDeleteReferencesEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Status, true
	case "AuditDeleteReferencesEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ServerId, true
	case "AuditDeleteReferencesEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientAuditEntryId, true
	case "AuditDeleteReferencesEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientUserId, true
	case "AuditUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventId, true
	case "AuditUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventType, true
	case "AuditUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceNode, true
	case "AuditUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceName, true
	case "AuditUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Time, true
	case "AuditUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ReceiveTime, true
	case "AuditUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_LocalTime, true
	case "AuditUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Message, true
	case "AuditUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Severity, true
	case "AuditUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ActionTimeStamp, true
	case "AuditUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Status, true
	case "AuditUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ServerId, true
	case "AuditUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientAuditEntryId, true
	case "AuditUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientUserId, true
	case "AuditWriteUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventId, true
	case "AuditWriteUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventType, true
	case "AuditWriteUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceNode, true
	case "AuditWriteUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceName, true
	case "AuditWriteUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Time, true
	case "AuditWriteUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ReceiveTime, true
	case "AuditWriteUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_LocalTime, true
	case "AuditWriteUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Message, true
	case "AuditWriteUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Severity, true
	case "AuditWriteUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ActionTimeStamp, true
	case "AuditWriteUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Status, true
	case "AuditWriteUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ServerId, true
	case "AuditWriteUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientAuditEntryId, true
	case "AuditWriteUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientUserId, true
	case "AuditHistoryUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventId, true
	case "AuditHistoryUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventType, true
	case "AuditHistoryUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceNode, true
	case "AuditHistoryUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceName, true
	case "AuditHistoryUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Time, true
	case "AuditHistoryUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ReceiveTime, true
	case "AuditHistoryUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_LocalTime, true
	case "AuditHistoryUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Message, true
	case "AuditHistoryUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Severity, true
	case "AuditHistoryUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ActionTimeStamp, true
	case "AuditHistoryUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Status, true
	case "AuditHistoryUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ServerId, true
	case "AuditHistoryUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientAuditEntryId, true
	case "AuditHistoryUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientUserId, true
	case "AuditHistoryEventUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventId, true
	case "AuditHistoryEventUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventType, true
	case "AuditHistoryEventUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceNode, true
	case "AuditHistoryEventUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceName, true
	case "AuditHistoryEventUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Time, true
	case "AuditHistoryEventUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ReceiveTime, true
	case "AuditHistoryEventUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_LocalTime, true
	case "AuditHistoryEventUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Message, true
	case "AuditHistoryEventUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Severity, true
	case "AuditHistoryEventUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ActionTimeStamp, true
	case "AuditHistoryEventUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Status, true
	case "AuditHistoryEventUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ServerId, true
	case "AuditHistoryEventUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientAuditEntryId, true
	case "AuditHistoryEventUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientUserId, true
	case "AuditHistoryEventUpdateEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ParameterDataTypeId, true
	case "AuditHistoryValueUpdateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventId, true
	case "AuditHistoryValueUpdateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventType, true
	case "AuditHistoryValueUpdateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceNode, true
	case "AuditHistoryValueUpdateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceName, true
	case "AuditHistoryValueUpdateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Time, true
	case "AuditHistoryValueUpdateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ReceiveTime, true
	case "AuditHistoryValueUpdateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_LocalTime, true
	case "AuditHistoryValueUpdateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Message, true
	case "AuditHistoryValueUpdateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Severity, true
	case "AuditHistoryValueUpdateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ActionTimeStamp, true
	case "AuditHistoryValueUpdateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Status, true
	case "AuditHistoryValueUpdateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ServerId, true
	case "AuditHistoryValueUpdateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientAuditEntryId, true
	case "AuditHistoryValueUpdateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientUserId, true
	case "AuditHistoryValueUpdateEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ParameterDataTypeId, true
	case "AuditHistoryDeleteEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventId, true
	case "AuditHistoryDeleteEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventType, true
	case "AuditHistoryDeleteEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceNode, true
	case "AuditHistoryDeleteEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceName, true
	case "AuditHistoryDeleteEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Time, true
	case "AuditHistoryDeleteEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ReceiveTime, true
	case "AuditHistoryDeleteEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_LocalTime, true
	case "AuditHistoryDeleteEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Message, true
	case "AuditHistoryDeleteEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Severity, true
	case "AuditHistoryDeleteEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ActionTimeStamp, true
	case "AuditHistoryDeleteEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Status, true
	case "AuditHistoryDeleteEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ServerId, true
	case "AuditHistoryDeleteEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientAuditEntryId, true
	case "AuditHistoryDeleteEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientUserId, true
	case "AuditHistoryDeleteEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ParameterDataTypeId, true
	case "AuditHistoryRawModifyDeleteEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventId, true
	case "AuditHistoryRawModifyDeleteEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventType, true
	case "AuditHistoryRawModifyDeleteEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceNode, true
	case "AuditHistoryRawModifyDeleteEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceName, true
	case "AuditHistoryRawModifyDeleteEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Time, true
	case "AuditHistoryRawModifyDeleteEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ReceiveTime, true
	case "AuditHistoryRawModifyDeleteEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_LocalTime, true
	case "AuditHistoryRawModifyDeleteEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Message, true
	case "AuditHistoryRawModifyDeleteEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Severity, true
	case "AuditHistoryRawModifyDeleteEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ActionTimeStamp, true
	case "AuditHistoryRawModifyDeleteEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Status, true
	case "AuditHistoryRawModifyDeleteEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ServerId, true
	case "AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId, true
	case "AuditHistoryRawModifyDeleteEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientUserId, true
	case "AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId, true
	case "AuditHistoryRawModifyDeleteEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_UpdatedNode, true
	case "AuditHistoryAtTimeDeleteEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventId, true
	case "AuditHistoryAtTimeDeleteEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventType, true
	case "AuditHistoryAtTimeDeleteEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceNode, true
	case "AuditHistoryAtTimeDeleteEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceName, true
	case "AuditHistoryAtTimeDeleteEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Time, true
	case "AuditHistoryAtTimeDeleteEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReceiveTime, true
	case "AuditHistoryAtTimeDeleteEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_LocalTime, true
	case "AuditHistoryAtTimeDeleteEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Message, true
	case "AuditHistoryAtTimeDeleteEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Severity, true
	case "AuditHistoryAtTimeDeleteEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ActionTimeStamp, true
	case "AuditHistoryAtTimeDeleteEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Status, true
	case "AuditHistoryAtTimeDeleteEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ServerId, true
	case "AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId, true
	case "AuditHistoryAtTimeDeleteEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientUserId, true
	case "AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId, true
	case "AuditHistoryAtTimeDeleteEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_UpdatedNode, true
	case "AuditHistoryEventDeleteEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventId, true
	case "AuditHistoryEventDeleteEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventType, true
	case "AuditHistoryEventDeleteEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceNode, true
	case "AuditHistoryEventDeleteEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceName, true
	case "AuditHistoryEventDeleteEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Time, true
	case "AuditHistoryEventDeleteEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ReceiveTime, true
	case "AuditHistoryEventDeleteEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_LocalTime, true
	case "AuditHistoryEventDeleteEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Message, true
	case "AuditHistoryEventDeleteEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Severity, true
	case "AuditHistoryEventDeleteEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ActionTimeStamp, true
	case "AuditHistoryEventDeleteEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Status, true
	case "AuditHistoryEventDeleteEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ServerId, true
	case "AuditHistoryEventDeleteEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientAuditEntryId, true
	case "AuditHistoryEventDeleteEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientUserId, true
	case "AuditHistoryEventDeleteEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ParameterDataTypeId, true
	case "AuditHistoryEventDeleteEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_UpdatedNode, true
	case "AuditUpdateMethodEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventId, true
	case "AuditUpdateMethodEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventType, true
	case "AuditUpdateMethodEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceNode, true
	case "AuditUpdateMethodEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceName, true
	case "AuditUpdateMethodEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Time, true
	case "AuditUpdateMethodEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ReceiveTime, true
	case "AuditUpdateMethodEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_LocalTime, true
	case "AuditUpdateMethodEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Message, true
	case "AuditUpdateMethodEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Severity, true
	case "AuditUpdateMethodEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ActionTimeStamp, true
	case "AuditUpdateMethodEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Status, true
	case "AuditUpdateMethodEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ServerId, true
	case "AuditUpdateMethodEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientAuditEntryId, true
	case "AuditUpdateMethodEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientUserId, true
	case "AuditUpdateStateEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventId, true
	case "AuditUpdateStateEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventType, true
	case "AuditUpdateStateEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceNode, true
	case "AuditUpdateStateEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceName, true
	case "AuditUpdateStateEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Time, true
	case "AuditUpdateStateEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ReceiveTime, true
	case "AuditUpdateStateEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_LocalTime, true
	case "AuditUpdateStateEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Message, true
	case "AuditUpdateStateEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Severity, true
	case "AuditUpdateStateEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ActionTimeStamp, true
	case "AuditUpdateStateEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Status, true
	case "AuditUpdateStateEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ServerId, true
	case "AuditUpdateStateEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientAuditEntryId, true
	case "AuditUpdateStateEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientUserId, true
	case "AuditUpdateStateEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_MethodId, true
	case "AuditUpdateStateEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_InputArguments, true
	case "AuditConditionEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventId, true
	case "AuditConditionEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventType, true
	case "AuditConditionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceNode, true
	case "AuditConditionEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceName, true
	case "AuditConditionEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Time, true
	case "AuditConditionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ReceiveTime, true
	case "AuditConditionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_LocalTime, true
	case "AuditConditionEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Message, true
	case "AuditConditionEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Severity, true
	case "AuditConditionEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ActionTimeStamp, true
	case "AuditConditionEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Status, true
	case "AuditConditionEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ServerId, true
	case "AuditConditionEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientAuditEntryId, true
	case "AuditConditionEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientUserId, true
	case "AuditConditionEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_MethodId, true
	case "AuditConditionEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_InputArguments, true
	case "AuditConditionEnableEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventId, true
	case "AuditConditionEnableEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventType, true
	case "AuditConditionEnableEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceNode, true
	case "AuditConditionEnableEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceName, true
	case "AuditConditionEnableEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Time, true
	case "AuditConditionEnableEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ReceiveTime, true
	case "AuditConditionEnableEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_LocalTime, true
	case "AuditConditionEnableEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Message, true
	case "AuditConditionEnableEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Severity, true
	case "AuditConditionEnableEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ActionTimeStamp, true
	case "AuditConditionEnableEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Status, true
	case "AuditConditionEnableEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ServerId, true
	case "AuditConditionEnableEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientAuditEntryId, true
	case "AuditConditionEnableEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientUserId, true
	case "AuditConditionEnableEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_MethodId, true
	case "AuditConditionEnableEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_InputArguments, true
	case "AuditConditionCommentEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventId, true
	case "AuditConditionCommentEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventType, true
	case "AuditConditionCommentEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceNode, true
	case "AuditConditionCommentEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceName, true
	case "AuditConditionCommentEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Time, true
	case "AuditConditionCommentEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ReceiveTime, true
	case "AuditConditionCommentEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_LocalTime, true
	case "AuditConditionCommentEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Message, true
	case "AuditConditionCommentEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Severity, true
	case "AuditConditionCommentEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ActionTimeStamp, true
	case "AuditConditionCommentEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Status, true
	case "AuditConditionCommentEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ServerId, true
	case "AuditConditionCommentEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientAuditEntryId, true
	case "AuditConditionCommentEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientUserId, true
	case "AuditConditionCommentEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_MethodId, true
	case "AuditConditionCommentEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_InputArguments, true
	case "AuditConditionRespondEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventId, true
	case "AuditConditionRespondEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventType, true
	case "AuditConditionRespondEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceNode, true
	case "AuditConditionRespondEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceName, true
	case "AuditConditionRespondEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Time, true
	case "AuditConditionRespondEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ReceiveTime, true
	case "AuditConditionRespondEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_LocalTime, true
	case "AuditConditionRespondEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Message, true
	case "AuditConditionRespondEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Severity, true
	case "AuditConditionRespondEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ActionTimeStamp, true
	case "AuditConditionRespondEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Status, true
	case "AuditConditionRespondEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ServerId, true
	case "AuditConditionRespondEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientAuditEntryId, true
	case "AuditConditionRespondEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientUserId, true
	case "AuditConditionRespondEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_MethodId, true
	case "AuditConditionRespondEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_InputArguments, true
	case "AuditConditionAcknowledgeEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventId, true
	case "AuditConditionAcknowledgeEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventType, true
	case "AuditConditionAcknowledgeEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceNode, true
	case "AuditConditionAcknowledgeEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceName, true
	case "AuditConditionAcknowledgeEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Time, true
	case "AuditConditionAcknowledgeEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ReceiveTime, true
	case "AuditConditionAcknowledgeEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_LocalTime, true
	case "AuditConditionAcknowledgeEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Message, true
	case "AuditConditionAcknowledgeEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Severity, true
	case "AuditConditionAcknowledgeEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ActionTimeStamp, true
	case "AuditConditionAcknowledgeEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Status, true
	case "AuditConditionAcknowledgeEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ServerId, true
	case "AuditConditionAcknowledgeEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientAuditEntryId, true
	case "AuditConditionAcknowledgeEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientUserId, true
	case "AuditConditionAcknowledgeEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_MethodId, true
	case "AuditConditionAcknowledgeEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_InputArguments, true
	case "AuditConditionConfirmEventType_EventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventId, true
	case "AuditConditionConfirmEventType_EventType":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventType, true
	case "AuditConditionConfirmEventType_SourceNode":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceNode, true
	case "AuditConditionConfirmEventType_SourceName":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceName, true
	case "AuditConditionConfirmEventType_Time":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Time, true
	case "AuditConditionConfirmEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ReceiveTime, true
	case "AuditConditionConfirmEventType_LocalTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_LocalTime, true
	case "AuditConditionConfirmEventType_Message":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Message, true
	case "AuditConditionConfirmEventType_Severity":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Severity, true
	case "AuditConditionConfirmEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ActionTimeStamp, true
	case "AuditConditionConfirmEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Status, true
	case "AuditConditionConfirmEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ServerId, true
	case "AuditConditionConfirmEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientAuditEntryId, true
	case "AuditConditionConfirmEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientUserId, true
	case "AuditConditionConfirmEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_MethodId, true
	case "AuditConditionConfirmEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAuditKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAuditValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAudit(structType any) OpcuaNodeIdServicesVariableAudit {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAudit {
		if sOpcuaNodeIdServicesVariableAudit, ok := typ.(OpcuaNodeIdServicesVariableAudit); ok {
			return sOpcuaNodeIdServicesVariableAudit
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAudit) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAudit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAuditParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAudit, error) {
	return OpcuaNodeIdServicesVariableAuditParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAuditParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAudit, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAudit", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAudit")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAuditByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAudit")
		return OpcuaNodeIdServicesVariableAudit(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAudit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAudit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAudit", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAudit) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventId:
		return "AuditConditionShelvingEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_EventType:
		return "AuditConditionShelvingEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceNode:
		return "AuditConditionShelvingEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_SourceName:
		return "AuditConditionShelvingEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Time:
		return "AuditConditionShelvingEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ReceiveTime:
		return "AuditConditionShelvingEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_LocalTime:
		return "AuditConditionShelvingEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Message:
		return "AuditConditionShelvingEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Severity:
		return "AuditConditionShelvingEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ActionTimeStamp:
		return "AuditConditionShelvingEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_Status:
		return "AuditConditionShelvingEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ServerId:
		return "AuditConditionShelvingEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientAuditEntryId:
		return "AuditConditionShelvingEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ClientUserId:
		return "AuditConditionShelvingEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_MethodId:
		return "AuditConditionShelvingEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_InputArguments:
		return "AuditConditionShelvingEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId:
		return "AuditActivateSessionEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment:
		return "AuditConditionCommentEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse:
		return "AuditConditionRespondEventType_SelectedResponse"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment:
		return "AuditConditionAcknowledgeEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment:
		return "AuditConditionConfirmEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime:
		return "AuditConditionShelvingEventType_ShelvingTime"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventId:
		return "AuditProgramTransitionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_EventType:
		return "AuditProgramTransitionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceNode:
		return "AuditProgramTransitionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_SourceName:
		return "AuditProgramTransitionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Time:
		return "AuditProgramTransitionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ReceiveTime:
		return "AuditProgramTransitionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_LocalTime:
		return "AuditProgramTransitionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Message:
		return "AuditProgramTransitionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Severity:
		return "AuditProgramTransitionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ActionTimeStamp:
		return "AuditProgramTransitionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_Status:
		return "AuditProgramTransitionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ServerId:
		return "AuditProgramTransitionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientAuditEntryId:
		return "AuditProgramTransitionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ClientUserId:
		return "AuditProgramTransitionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_MethodId:
		return "AuditProgramTransitionEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_InputArguments:
		return "AuditProgramTransitionEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_OldStateId:
		return "AuditProgramTransitionEventType_OldStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_NewStateId:
		return "AuditProgramTransitionEventType_NewStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber:
		return "AuditProgramTransitionEventType_TransitionNumber"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SessionId:
		return "AuditCreateSessionEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SessionId:
		return "AuditUrlMismatchEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventId:
		return "AuditConditionResetEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_EventType:
		return "AuditConditionResetEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceNode:
		return "AuditConditionResetEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_SourceName:
		return "AuditConditionResetEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Time:
		return "AuditConditionResetEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ReceiveTime:
		return "AuditConditionResetEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_LocalTime:
		return "AuditConditionResetEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Message:
		return "AuditConditionResetEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Severity:
		return "AuditConditionResetEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ActionTimeStamp:
		return "AuditConditionResetEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_Status:
		return "AuditConditionResetEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ServerId:
		return "AuditConditionResetEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientAuditEntryId:
		return "AuditConditionResetEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ClientUserId:
		return "AuditConditionResetEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_MethodId:
		return "AuditConditionResetEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_InputArguments:
		return "AuditConditionResetEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId:
		return "AuditConditionCommentEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId:
		return "AuditConditionAcknowledgeEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId:
		return "AuditConditionConfirmEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventId:
		return "AuditConditionSuppressionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_EventType:
		return "AuditConditionSuppressionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceNode:
		return "AuditConditionSuppressionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_SourceName:
		return "AuditConditionSuppressionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Time:
		return "AuditConditionSuppressionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ReceiveTime:
		return "AuditConditionSuppressionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_LocalTime:
		return "AuditConditionSuppressionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Message:
		return "AuditConditionSuppressionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Severity:
		return "AuditConditionSuppressionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ActionTimeStamp:
		return "AuditConditionSuppressionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_Status:
		return "AuditConditionSuppressionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ServerId:
		return "AuditConditionSuppressionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientAuditEntryId:
		return "AuditConditionSuppressionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ClientUserId:
		return "AuditConditionSuppressionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_MethodId:
		return "AuditConditionSuppressionEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_InputArguments:
		return "AuditConditionSuppressionEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventId:
		return "AuditConditionSilenceEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_EventType:
		return "AuditConditionSilenceEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceNode:
		return "AuditConditionSilenceEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_SourceName:
		return "AuditConditionSilenceEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Time:
		return "AuditConditionSilenceEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ReceiveTime:
		return "AuditConditionSilenceEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_LocalTime:
		return "AuditConditionSilenceEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Message:
		return "AuditConditionSilenceEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Severity:
		return "AuditConditionSilenceEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ActionTimeStamp:
		return "AuditConditionSilenceEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_Status:
		return "AuditConditionSilenceEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ServerId:
		return "AuditConditionSilenceEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientAuditEntryId:
		return "AuditConditionSilenceEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ClientUserId:
		return "AuditConditionSilenceEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_MethodId:
		return "AuditConditionSilenceEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_InputArguments:
		return "AuditConditionSilenceEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventId:
		return "AuditConditionOutOfServiceEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_EventType:
		return "AuditConditionOutOfServiceEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceNode:
		return "AuditConditionOutOfServiceEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_SourceName:
		return "AuditConditionOutOfServiceEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Time:
		return "AuditConditionOutOfServiceEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ReceiveTime:
		return "AuditConditionOutOfServiceEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_LocalTime:
		return "AuditConditionOutOfServiceEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Message:
		return "AuditConditionOutOfServiceEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Severity:
		return "AuditConditionOutOfServiceEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ActionTimeStamp:
		return "AuditConditionOutOfServiceEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_Status:
		return "AuditConditionOutOfServiceEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ServerId:
		return "AuditConditionOutOfServiceEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientAuditEntryId:
		return "AuditConditionOutOfServiceEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ClientUserId:
		return "AuditConditionOutOfServiceEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_MethodId:
		return "AuditConditionOutOfServiceEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_InputArguments:
		return "AuditConditionOutOfServiceEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId:
		return "AuditSecurityEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_StatusCodeId:
		return "AuditChannelEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_StatusCodeId:
		return "AuditOpenSecureChannelEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_StatusCodeId:
		return "AuditSessionEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_StatusCodeId:
		return "AuditCreateSessionEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_StatusCodeId:
		return "AuditUrlMismatchEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_StatusCodeId:
		return "AuditActivateSessionEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_StatusCodeId:
		return "AuditCancelEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_StatusCodeId:
		return "AuditCertificateEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_StatusCodeId:
		return "AuditCertificateDataMismatchEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_StatusCodeId:
		return "AuditCertificateExpiredEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_StatusCodeId:
		return "AuditCertificateInvalidEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_StatusCodeId:
		return "AuditCertificateUntrustedEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_StatusCodeId:
		return "AuditCertificateRevokedEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_StatusCodeId:
		return "AuditCertificateMismatchEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventId:
		return "AuditHistoryAnnotationUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_EventType:
		return "AuditHistoryAnnotationUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceNode:
		return "AuditHistoryAnnotationUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_SourceName:
		return "AuditHistoryAnnotationUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Time:
		return "AuditHistoryAnnotationUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ReceiveTime:
		return "AuditHistoryAnnotationUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_LocalTime:
		return "AuditHistoryAnnotationUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Message:
		return "AuditHistoryAnnotationUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Severity:
		return "AuditHistoryAnnotationUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ActionTimeStamp:
		return "AuditHistoryAnnotationUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_Status:
		return "AuditHistoryAnnotationUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ServerId:
		return "AuditHistoryAnnotationUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId:
		return "AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ClientUserId:
		return "AuditHistoryAnnotationUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId:
		return "AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace:
		return "AuditHistoryAnnotationUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues:
		return "AuditHistoryAnnotationUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues:
		return "AuditHistoryAnnotationUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp:
		return "AuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_Status:
		return "AuditEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId:
		return "AuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId:
		return "AuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId:
		return "AuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate:
		return "AuditOpenSecureChannelEventType_ClientCertificate"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType:
		return "AuditOpenSecureChannelEventType_RequestType"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri:
		return "AuditOpenSecureChannelEventType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode:
		return "AuditOpenSecureChannelEventType_SecurityMode"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime:
		return "AuditOpenSecureChannelEventType_RequestedLifetime"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId:
		return "AuditSessionEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId:
		return "AuditCreateSessionEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate:
		return "AuditCreateSessionEventType_ClientCertificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout:
		return "AuditCreateSessionEventType_RevisedSessionTimeout"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates:
		return "AuditActivateSessionEventType_ClientSoftwareCertificates"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken:
		return "AuditActivateSessionEventType_UserIdentityToken"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle:
		return "AuditCancelEventType_RequestHandle"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate:
		return "AuditCertificateEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname:
		return "AuditCertificateDataMismatchEventType_InvalidHostname"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri:
		return "AuditCertificateDataMismatchEventType_InvalidUri"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd:
		return "AuditAddNodesEventType_NodesToAdd"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete:
		return "AuditDeleteNodesEventType_NodesToDelete"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd:
		return "AuditAddReferencesEventType_ReferencesToAdd"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete:
		return "AuditDeleteReferencesEventType_ReferencesToDelete"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange:
		return "AuditWriteUpdateEventType_IndexRange"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue:
		return "AuditWriteUpdateEventType_OldValue"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue:
		return "AuditWriteUpdateEventType_NewValue"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId:
		return "AuditUpdateMethodEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments:
		return "AuditUpdateMethodEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventId:
		return "AuditClientEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_EventType:
		return "AuditClientEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceNode:
		return "AuditClientEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_SourceName:
		return "AuditClientEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Time:
		return "AuditClientEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ReceiveTime:
		return "AuditClientEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_LocalTime:
		return "AuditClientEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Message:
		return "AuditClientEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Severity:
		return "AuditClientEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ActionTimeStamp:
		return "AuditClientEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_Status:
		return "AuditClientEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerId:
		return "AuditClientEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientAuditEntryId:
		return "AuditClientEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ClientUserId:
		return "AuditClientEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri:
		return "AuditClientEventType_ServerUri"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventId:
		return "AuditClientUpdateMethodResultEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_EventType:
		return "AuditClientUpdateMethodResultEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceNode:
		return "AuditClientUpdateMethodResultEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_SourceName:
		return "AuditClientUpdateMethodResultEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Time:
		return "AuditClientUpdateMethodResultEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ReceiveTime:
		return "AuditClientUpdateMethodResultEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_LocalTime:
		return "AuditClientUpdateMethodResultEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Message:
		return "AuditClientUpdateMethodResultEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Severity:
		return "AuditClientUpdateMethodResultEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ActionTimeStamp:
		return "AuditClientUpdateMethodResultEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_Status:
		return "AuditClientUpdateMethodResultEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerId:
		return "AuditClientUpdateMethodResultEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientAuditEntryId:
		return "AuditClientUpdateMethodResultEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ClientUserId:
		return "AuditClientUpdateMethodResultEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ServerUri:
		return "AuditClientUpdateMethodResultEventType_ServerUri"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId:
		return "AuditClientUpdateMethodResultEventType_ObjectId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId:
		return "AuditClientUpdateMethodResultEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId:
		return "AuditClientUpdateMethodResultEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments:
		return "AuditClientUpdateMethodResultEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId:
		return "AuditOpenSecureChannelEventType_CertificateErrorEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments:
		return "AuditClientUpdateMethodResultEventType_OutputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId:
		return "AuditChannelEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint:
		return "AuditOpenSecureChannelEventType_ClientCertificateThumbprint"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint:
		return "AuditCreateSessionEventType_ClientCertificateThumbprint"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl:
		return "AuditUrlMismatchEventType_EndpointUrl"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId:
		return "AuditWriteUpdateEventType_AttributeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId:
		return "AuditHistoryUpdateEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId:
		return "AuditUpdateStateEventType_OldStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId:
		return "AuditUpdateStateEventType_NewStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter:
		return "AuditHistoryEventUpdateEventType_Filter"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified:
		return "AuditHistoryRawModifyDeleteEventType_IsDeleteModified"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime:
		return "AuditHistoryRawModifyDeleteEventType_StartTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime:
		return "AuditHistoryRawModifyDeleteEventType_EndTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes:
		return "AuditHistoryAtTimeDeleteEventType_ReqTimes"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues:
		return "AuditHistoryAtTimeDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds:
		return "AuditHistoryEventDeleteEventType_EventIds"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues:
		return "AuditHistoryEventDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode:
		return "AuditHistoryEventUpdateEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode:
		return "AuditHistoryValueUpdateEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode:
		return "AuditHistoryDeleteEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace:
		return "AuditHistoryEventUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues:
		return "AuditHistoryEventUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues:
		return "AuditHistoryEventUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace:
		return "AuditHistoryValueUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues:
		return "AuditHistoryValueUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues:
		return "AuditHistoryValueUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues:
		return "AuditHistoryRawModifyDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassId:
		return "AuditEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionClassName:
		return "AuditEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassId:
		return "AuditEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ConditionSubClassName:
		return "AuditEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassId:
		return "AuditSecurityEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionClassName:
		return "AuditSecurityEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassId:
		return "AuditSecurityEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ConditionSubClassName:
		return "AuditSecurityEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassId:
		return "AuditChannelEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionClassName:
		return "AuditChannelEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassId:
		return "AuditChannelEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ConditionSubClassName:
		return "AuditChannelEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassId:
		return "AuditOpenSecureChannelEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionClassName:
		return "AuditOpenSecureChannelEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassId:
		return "AuditOpenSecureChannelEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ConditionSubClassName:
		return "AuditOpenSecureChannelEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassId:
		return "AuditSessionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionClassName:
		return "AuditSessionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassId:
		return "AuditSessionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ConditionSubClassName:
		return "AuditSessionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassId:
		return "AuditCreateSessionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionClassName:
		return "AuditCreateSessionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassId:
		return "AuditCreateSessionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ConditionSubClassName:
		return "AuditCreateSessionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassId:
		return "AuditUrlMismatchEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionClassName:
		return "AuditUrlMismatchEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassId:
		return "AuditUrlMismatchEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ConditionSubClassName:
		return "AuditUrlMismatchEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassId:
		return "AuditActivateSessionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionClassName:
		return "AuditActivateSessionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassId:
		return "AuditActivateSessionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ConditionSubClassName:
		return "AuditActivateSessionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassId:
		return "AuditCancelEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionClassName:
		return "AuditCancelEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassId:
		return "AuditCancelEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ConditionSubClassName:
		return "AuditCancelEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassId:
		return "AuditCertificateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionClassName:
		return "AuditCertificateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassId:
		return "AuditCertificateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ConditionSubClassName:
		return "AuditCertificateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassId:
		return "AuditCertificateDataMismatchEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionClassName:
		return "AuditCertificateDataMismatchEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassId:
		return "AuditCertificateDataMismatchEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ConditionSubClassName:
		return "AuditCertificateDataMismatchEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassId:
		return "AuditCertificateExpiredEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionClassName:
		return "AuditCertificateExpiredEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassId:
		return "AuditCertificateExpiredEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ConditionSubClassName:
		return "AuditCertificateExpiredEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassId:
		return "AuditCertificateInvalidEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionClassName:
		return "AuditCertificateInvalidEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassId:
		return "AuditCertificateInvalidEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ConditionSubClassName:
		return "AuditCertificateInvalidEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassId:
		return "AuditCertificateUntrustedEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionClassName:
		return "AuditCertificateUntrustedEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassId:
		return "AuditCertificateUntrustedEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ConditionSubClassName:
		return "AuditCertificateUntrustedEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassId:
		return "AuditCertificateRevokedEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionClassName:
		return "AuditCertificateRevokedEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassId:
		return "AuditCertificateRevokedEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ConditionSubClassName:
		return "AuditCertificateRevokedEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassId:
		return "AuditCertificateMismatchEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionClassName:
		return "AuditCertificateMismatchEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassId:
		return "AuditCertificateMismatchEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ConditionSubClassName:
		return "AuditCertificateMismatchEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassId:
		return "AuditNodeManagementEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionClassName:
		return "AuditNodeManagementEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassId:
		return "AuditNodeManagementEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ConditionSubClassName:
		return "AuditNodeManagementEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassId:
		return "AuditAddNodesEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionClassName:
		return "AuditAddNodesEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassId:
		return "AuditAddNodesEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ConditionSubClassName:
		return "AuditAddNodesEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassId:
		return "AuditDeleteNodesEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionClassName:
		return "AuditDeleteNodesEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassId:
		return "AuditDeleteNodesEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ConditionSubClassName:
		return "AuditDeleteNodesEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassId:
		return "AuditAddReferencesEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionClassName:
		return "AuditAddReferencesEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassId:
		return "AuditAddReferencesEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ConditionSubClassName:
		return "AuditAddReferencesEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassId:
		return "AuditDeleteReferencesEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionClassName:
		return "AuditDeleteReferencesEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassId:
		return "AuditDeleteReferencesEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ConditionSubClassName:
		return "AuditDeleteReferencesEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassId:
		return "AuditUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionClassName:
		return "AuditUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassId:
		return "AuditUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ConditionSubClassName:
		return "AuditUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassId:
		return "AuditWriteUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionClassName:
		return "AuditWriteUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassId:
		return "AuditWriteUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ConditionSubClassName:
		return "AuditWriteUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassId:
		return "AuditHistoryUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionClassName:
		return "AuditHistoryUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassId:
		return "AuditHistoryUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ConditionSubClassName:
		return "AuditHistoryUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassId:
		return "AuditUpdateMethodEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionClassName:
		return "AuditUpdateMethodEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassId:
		return "AuditUpdateMethodEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ConditionSubClassName:
		return "AuditUpdateMethodEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassId:
		return "AuditClientEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionClassName:
		return "AuditClientEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassId:
		return "AuditClientEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ConditionSubClassName:
		return "AuditClientEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassId:
		return "AuditClientUpdateMethodResultEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionClassName:
		return "AuditClientUpdateMethodResultEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassId:
		return "AuditClientUpdateMethodResultEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ConditionSubClassName:
		return "AuditClientUpdateMethodResultEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassId:
		return "AuditUpdateStateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionClassName:
		return "AuditUpdateStateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassId:
		return "AuditUpdateStateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ConditionSubClassName:
		return "AuditUpdateStateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassId:
		return "AuditConditionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionClassName:
		return "AuditConditionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassId:
		return "AuditConditionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ConditionSubClassName:
		return "AuditConditionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassId:
		return "AuditConditionEnableEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionClassName:
		return "AuditConditionEnableEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassId:
		return "AuditConditionEnableEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ConditionSubClassName:
		return "AuditConditionEnableEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassId:
		return "AuditConditionCommentEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionClassName:
		return "AuditConditionCommentEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassId:
		return "AuditConditionCommentEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionSubClassName:
		return "AuditConditionCommentEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassId:
		return "AuditConditionRespondEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionClassName:
		return "AuditConditionRespondEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassId:
		return "AuditConditionRespondEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ConditionSubClassName:
		return "AuditConditionRespondEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassId:
		return "AuditConditionAcknowledgeEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionClassName:
		return "AuditConditionAcknowledgeEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassId:
		return "AuditConditionAcknowledgeEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionSubClassName:
		return "AuditConditionAcknowledgeEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassId:
		return "AuditConditionConfirmEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionClassName:
		return "AuditConditionConfirmEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassId:
		return "AuditConditionConfirmEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionSubClassName:
		return "AuditConditionConfirmEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassId:
		return "AuditConditionShelvingEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionClassName:
		return "AuditConditionShelvingEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassId:
		return "AuditConditionShelvingEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ConditionSubClassName:
		return "AuditConditionShelvingEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassId:
		return "AuditConditionSuppressionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionClassName:
		return "AuditConditionSuppressionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassId:
		return "AuditConditionSuppressionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSuppressionEventType_ConditionSubClassName:
		return "AuditConditionSuppressionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassId:
		return "AuditConditionSilenceEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionClassName:
		return "AuditConditionSilenceEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassId:
		return "AuditConditionSilenceEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionSilenceEventType_ConditionSubClassName:
		return "AuditConditionSilenceEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassId:
		return "AuditConditionResetEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionClassName:
		return "AuditConditionResetEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassId:
		return "AuditConditionResetEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionResetEventType_ConditionSubClassName:
		return "AuditConditionResetEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassId:
		return "AuditConditionOutOfServiceEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionClassName:
		return "AuditConditionOutOfServiceEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassId:
		return "AuditConditionOutOfServiceEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionOutOfServiceEventType_ConditionSubClassName:
		return "AuditConditionOutOfServiceEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassId:
		return "AuditProgramTransitionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionClassName:
		return "AuditProgramTransitionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassId:
		return "AuditProgramTransitionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_ConditionSubClassName:
		return "AuditProgramTransitionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassId:
		return "AuditHistoryEventUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_EventId:
		return "AuditEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionClassName:
		return "AuditHistoryEventUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassId:
		return "AuditHistoryEventUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ConditionSubClassName:
		return "AuditHistoryEventUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassId:
		return "AuditHistoryValueUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionClassName:
		return "AuditHistoryValueUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassId:
		return "AuditHistoryValueUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ConditionSubClassName:
		return "AuditHistoryValueUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassId:
		return "AuditHistoryAnnotationUpdateEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionClassName:
		return "AuditHistoryAnnotationUpdateEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassId:
		return "AuditHistoryAnnotationUpdateEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_EventType:
		return "AuditEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_ConditionSubClassName:
		return "AuditHistoryAnnotationUpdateEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassId:
		return "AuditHistoryDeleteEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionClassName:
		return "AuditHistoryDeleteEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassId:
		return "AuditHistoryDeleteEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ConditionSubClassName:
		return "AuditHistoryDeleteEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassId:
		return "AuditHistoryRawModifyDeleteEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionClassName:
		return "AuditHistoryRawModifyDeleteEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassId:
		return "AuditHistoryRawModifyDeleteEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ConditionSubClassName:
		return "AuditHistoryRawModifyDeleteEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassId:
		return "AuditHistoryAtTimeDeleteEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceNode:
		return "AuditEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionClassName:
		return "AuditHistoryAtTimeDeleteEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassId:
		return "AuditHistoryAtTimeDeleteEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ConditionSubClassName:
		return "AuditHistoryAtTimeDeleteEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassId:
		return "AuditHistoryEventDeleteEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionClassName:
		return "AuditHistoryEventDeleteEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassId:
		return "AuditHistoryEventDeleteEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ConditionSubClassName:
		return "AuditHistoryEventDeleteEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_SourceName:
		return "AuditEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_Time:
		return "AuditEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ReceiveTime:
		return "AuditEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_LocalTime:
		return "AuditEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_Message:
		return "AuditEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_Severity:
		return "AuditEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventId:
		return "AuditSecurityEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_EventType:
		return "AuditSecurityEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceNode:
		return "AuditSecurityEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_SourceName:
		return "AuditSecurityEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Time:
		return "AuditSecurityEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ReceiveTime:
		return "AuditSecurityEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_LocalTime:
		return "AuditSecurityEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Message:
		return "AuditSecurityEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Severity:
		return "AuditSecurityEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ActionTimeStamp:
		return "AuditSecurityEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_Status:
		return "AuditSecurityEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ServerId:
		return "AuditSecurityEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientAuditEntryId:
		return "AuditSecurityEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_ClientUserId:
		return "AuditSecurityEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventId:
		return "AuditChannelEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_EventType:
		return "AuditChannelEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceNode:
		return "AuditChannelEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SourceName:
		return "AuditChannelEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Time:
		return "AuditChannelEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ReceiveTime:
		return "AuditChannelEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_LocalTime:
		return "AuditChannelEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Message:
		return "AuditChannelEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Severity:
		return "AuditChannelEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ActionTimeStamp:
		return "AuditChannelEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_Status:
		return "AuditChannelEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ServerId:
		return "AuditChannelEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientAuditEntryId:
		return "AuditChannelEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_ClientUserId:
		return "AuditChannelEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventId:
		return "AuditOpenSecureChannelEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_EventType:
		return "AuditOpenSecureChannelEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceNode:
		return "AuditOpenSecureChannelEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SourceName:
		return "AuditOpenSecureChannelEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Time:
		return "AuditOpenSecureChannelEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ReceiveTime:
		return "AuditOpenSecureChannelEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_LocalTime:
		return "AuditOpenSecureChannelEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Message:
		return "AuditOpenSecureChannelEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Severity:
		return "AuditOpenSecureChannelEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ActionTimeStamp:
		return "AuditOpenSecureChannelEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_Status:
		return "AuditOpenSecureChannelEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ServerId:
		return "AuditOpenSecureChannelEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientAuditEntryId:
		return "AuditOpenSecureChannelEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientUserId:
		return "AuditOpenSecureChannelEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecureChannelId:
		return "AuditOpenSecureChannelEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventId:
		return "AuditSessionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_EventType:
		return "AuditSessionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceNode:
		return "AuditSessionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SourceName:
		return "AuditSessionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Time:
		return "AuditSessionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ReceiveTime:
		return "AuditSessionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_LocalTime:
		return "AuditSessionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Message:
		return "AuditSessionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Severity:
		return "AuditSessionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ActionTimeStamp:
		return "AuditSessionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_Status:
		return "AuditSessionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ServerId:
		return "AuditSessionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientAuditEntryId:
		return "AuditSessionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_ClientUserId:
		return "AuditSessionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventId:
		return "AuditCreateSessionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_EventType:
		return "AuditCreateSessionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceNode:
		return "AuditCreateSessionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SourceName:
		return "AuditCreateSessionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Time:
		return "AuditCreateSessionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ReceiveTime:
		return "AuditCreateSessionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_LocalTime:
		return "AuditCreateSessionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Message:
		return "AuditCreateSessionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Severity:
		return "AuditCreateSessionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ActionTimeStamp:
		return "AuditCreateSessionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_Status:
		return "AuditCreateSessionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ServerId:
		return "AuditCreateSessionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientAuditEntryId:
		return "AuditCreateSessionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientUserId:
		return "AuditCreateSessionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventId:
		return "AuditUrlMismatchEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EventType:
		return "AuditUrlMismatchEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceNode:
		return "AuditUrlMismatchEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SourceName:
		return "AuditUrlMismatchEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Time:
		return "AuditUrlMismatchEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ReceiveTime:
		return "AuditUrlMismatchEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_LocalTime:
		return "AuditUrlMismatchEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Message:
		return "AuditUrlMismatchEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Severity:
		return "AuditUrlMismatchEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ActionTimeStamp:
		return "AuditUrlMismatchEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_Status:
		return "AuditUrlMismatchEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ServerId:
		return "AuditUrlMismatchEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientAuditEntryId:
		return "AuditUrlMismatchEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientUserId:
		return "AuditUrlMismatchEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_SecureChannelId:
		return "AuditUrlMismatchEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificate:
		return "AuditUrlMismatchEventType_ClientCertificate"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_ClientCertificateThumbprint:
		return "AuditUrlMismatchEventType_ClientCertificateThumbprint"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_RevisedSessionTimeout:
		return "AuditUrlMismatchEventType_RevisedSessionTimeout"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventId:
		return "AuditActivateSessionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_EventType:
		return "AuditActivateSessionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceNode:
		return "AuditActivateSessionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SourceName:
		return "AuditActivateSessionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Time:
		return "AuditActivateSessionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ReceiveTime:
		return "AuditActivateSessionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_LocalTime:
		return "AuditActivateSessionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Message:
		return "AuditActivateSessionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Severity:
		return "AuditActivateSessionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ActionTimeStamp:
		return "AuditActivateSessionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_Status:
		return "AuditActivateSessionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ServerId:
		return "AuditActivateSessionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientAuditEntryId:
		return "AuditActivateSessionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientUserId:
		return "AuditActivateSessionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SessionId:
		return "AuditActivateSessionEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventId:
		return "AuditCancelEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_EventType:
		return "AuditCancelEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceNode:
		return "AuditCancelEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SourceName:
		return "AuditCancelEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Time:
		return "AuditCancelEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ReceiveTime:
		return "AuditCancelEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_LocalTime:
		return "AuditCancelEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Message:
		return "AuditCancelEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Severity:
		return "AuditCancelEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ActionTimeStamp:
		return "AuditCancelEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_Status:
		return "AuditCancelEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ServerId:
		return "AuditCancelEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientAuditEntryId:
		return "AuditCancelEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_ClientUserId:
		return "AuditCancelEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_SessionId:
		return "AuditCancelEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventId:
		return "AuditCertificateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_EventType:
		return "AuditCertificateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceNode:
		return "AuditCertificateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_SourceName:
		return "AuditCertificateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Time:
		return "AuditCertificateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ReceiveTime:
		return "AuditCertificateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_LocalTime:
		return "AuditCertificateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Message:
		return "AuditCertificateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Severity:
		return "AuditCertificateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ActionTimeStamp:
		return "AuditCertificateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Status:
		return "AuditCertificateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ServerId:
		return "AuditCertificateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientAuditEntryId:
		return "AuditCertificateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_ClientUserId:
		return "AuditCertificateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventId:
		return "AuditCertificateDataMismatchEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_EventType:
		return "AuditCertificateDataMismatchEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceNode:
		return "AuditCertificateDataMismatchEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_SourceName:
		return "AuditCertificateDataMismatchEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Time:
		return "AuditCertificateDataMismatchEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ReceiveTime:
		return "AuditCertificateDataMismatchEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_LocalTime:
		return "AuditCertificateDataMismatchEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Message:
		return "AuditCertificateDataMismatchEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Severity:
		return "AuditCertificateDataMismatchEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ActionTimeStamp:
		return "AuditCertificateDataMismatchEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Status:
		return "AuditCertificateDataMismatchEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ServerId:
		return "AuditCertificateDataMismatchEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientAuditEntryId:
		return "AuditCertificateDataMismatchEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_ClientUserId:
		return "AuditCertificateDataMismatchEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_Certificate:
		return "AuditCertificateDataMismatchEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventId:
		return "AuditCertificateExpiredEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_EventType:
		return "AuditCertificateExpiredEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceNode:
		return "AuditCertificateExpiredEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_SourceName:
		return "AuditCertificateExpiredEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Time:
		return "AuditCertificateExpiredEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ReceiveTime:
		return "AuditCertificateExpiredEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_LocalTime:
		return "AuditCertificateExpiredEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Message:
		return "AuditCertificateExpiredEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Severity:
		return "AuditCertificateExpiredEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ActionTimeStamp:
		return "AuditCertificateExpiredEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Status:
		return "AuditCertificateExpiredEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ServerId:
		return "AuditCertificateExpiredEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientAuditEntryId:
		return "AuditCertificateExpiredEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_ClientUserId:
		return "AuditCertificateExpiredEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateExpiredEventType_Certificate:
		return "AuditCertificateExpiredEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventId:
		return "AuditCertificateInvalidEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_EventType:
		return "AuditCertificateInvalidEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceNode:
		return "AuditCertificateInvalidEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_SourceName:
		return "AuditCertificateInvalidEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Time:
		return "AuditCertificateInvalidEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ReceiveTime:
		return "AuditCertificateInvalidEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_LocalTime:
		return "AuditCertificateInvalidEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Message:
		return "AuditCertificateInvalidEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Severity:
		return "AuditCertificateInvalidEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ActionTimeStamp:
		return "AuditCertificateInvalidEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Status:
		return "AuditCertificateInvalidEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ServerId:
		return "AuditCertificateInvalidEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientAuditEntryId:
		return "AuditCertificateInvalidEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_ClientUserId:
		return "AuditCertificateInvalidEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateInvalidEventType_Certificate:
		return "AuditCertificateInvalidEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventId:
		return "AuditCertificateUntrustedEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_EventType:
		return "AuditCertificateUntrustedEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceNode:
		return "AuditCertificateUntrustedEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_SourceName:
		return "AuditCertificateUntrustedEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Time:
		return "AuditCertificateUntrustedEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ReceiveTime:
		return "AuditCertificateUntrustedEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_LocalTime:
		return "AuditCertificateUntrustedEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Message:
		return "AuditCertificateUntrustedEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Severity:
		return "AuditCertificateUntrustedEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ActionTimeStamp:
		return "AuditCertificateUntrustedEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Status:
		return "AuditCertificateUntrustedEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ServerId:
		return "AuditCertificateUntrustedEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientAuditEntryId:
		return "AuditCertificateUntrustedEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_ClientUserId:
		return "AuditCertificateUntrustedEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateUntrustedEventType_Certificate:
		return "AuditCertificateUntrustedEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventId:
		return "AuditCertificateRevokedEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_EventType:
		return "AuditCertificateRevokedEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceNode:
		return "AuditCertificateRevokedEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_SourceName:
		return "AuditCertificateRevokedEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Time:
		return "AuditCertificateRevokedEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ReceiveTime:
		return "AuditCertificateRevokedEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_LocalTime:
		return "AuditCertificateRevokedEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Message:
		return "AuditCertificateRevokedEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Severity:
		return "AuditCertificateRevokedEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ActionTimeStamp:
		return "AuditCertificateRevokedEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Status:
		return "AuditCertificateRevokedEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ServerId:
		return "AuditCertificateRevokedEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientAuditEntryId:
		return "AuditCertificateRevokedEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_ClientUserId:
		return "AuditCertificateRevokedEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateRevokedEventType_Certificate:
		return "AuditCertificateRevokedEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventId:
		return "AuditCertificateMismatchEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_EventType:
		return "AuditCertificateMismatchEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceNode:
		return "AuditCertificateMismatchEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_SourceName:
		return "AuditCertificateMismatchEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Time:
		return "AuditCertificateMismatchEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ReceiveTime:
		return "AuditCertificateMismatchEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_LocalTime:
		return "AuditCertificateMismatchEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Message:
		return "AuditCertificateMismatchEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Severity:
		return "AuditCertificateMismatchEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ActionTimeStamp:
		return "AuditCertificateMismatchEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Status:
		return "AuditCertificateMismatchEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ServerId:
		return "AuditCertificateMismatchEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientAuditEntryId:
		return "AuditCertificateMismatchEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_ClientUserId:
		return "AuditCertificateMismatchEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateMismatchEventType_Certificate:
		return "AuditCertificateMismatchEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventId:
		return "AuditNodeManagementEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_EventType:
		return "AuditNodeManagementEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceNode:
		return "AuditNodeManagementEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_SourceName:
		return "AuditNodeManagementEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Time:
		return "AuditNodeManagementEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ReceiveTime:
		return "AuditNodeManagementEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_LocalTime:
		return "AuditNodeManagementEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Message:
		return "AuditNodeManagementEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Severity:
		return "AuditNodeManagementEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ActionTimeStamp:
		return "AuditNodeManagementEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_Status:
		return "AuditNodeManagementEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ServerId:
		return "AuditNodeManagementEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientAuditEntryId:
		return "AuditNodeManagementEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditNodeManagementEventType_ClientUserId:
		return "AuditNodeManagementEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventId:
		return "AuditAddNodesEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_EventType:
		return "AuditAddNodesEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceNode:
		return "AuditAddNodesEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_SourceName:
		return "AuditAddNodesEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Time:
		return "AuditAddNodesEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ReceiveTime:
		return "AuditAddNodesEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_LocalTime:
		return "AuditAddNodesEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Message:
		return "AuditAddNodesEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Severity:
		return "AuditAddNodesEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ActionTimeStamp:
		return "AuditAddNodesEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_Status:
		return "AuditAddNodesEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ServerId:
		return "AuditAddNodesEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientAuditEntryId:
		return "AuditAddNodesEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_ClientUserId:
		return "AuditAddNodesEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventId:
		return "AuditDeleteNodesEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_EventType:
		return "AuditDeleteNodesEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceNode:
		return "AuditDeleteNodesEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_SourceName:
		return "AuditDeleteNodesEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Time:
		return "AuditDeleteNodesEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ReceiveTime:
		return "AuditDeleteNodesEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_LocalTime:
		return "AuditDeleteNodesEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Message:
		return "AuditDeleteNodesEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Severity:
		return "AuditDeleteNodesEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ActionTimeStamp:
		return "AuditDeleteNodesEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_Status:
		return "AuditDeleteNodesEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ServerId:
		return "AuditDeleteNodesEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientAuditEntryId:
		return "AuditDeleteNodesEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_ClientUserId:
		return "AuditDeleteNodesEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventId:
		return "AuditAddReferencesEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_EventType:
		return "AuditAddReferencesEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceNode:
		return "AuditAddReferencesEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_SourceName:
		return "AuditAddReferencesEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Time:
		return "AuditAddReferencesEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReceiveTime:
		return "AuditAddReferencesEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_LocalTime:
		return "AuditAddReferencesEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Message:
		return "AuditAddReferencesEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Severity:
		return "AuditAddReferencesEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ActionTimeStamp:
		return "AuditAddReferencesEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_Status:
		return "AuditAddReferencesEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ServerId:
		return "AuditAddReferencesEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientAuditEntryId:
		return "AuditAddReferencesEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ClientUserId:
		return "AuditAddReferencesEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventId:
		return "AuditDeleteReferencesEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_EventType:
		return "AuditDeleteReferencesEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceNode:
		return "AuditDeleteReferencesEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_SourceName:
		return "AuditDeleteReferencesEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Time:
		return "AuditDeleteReferencesEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReceiveTime:
		return "AuditDeleteReferencesEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_LocalTime:
		return "AuditDeleteReferencesEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Message:
		return "AuditDeleteReferencesEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Severity:
		return "AuditDeleteReferencesEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ActionTimeStamp:
		return "AuditDeleteReferencesEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_Status:
		return "AuditDeleteReferencesEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ServerId:
		return "AuditDeleteReferencesEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientAuditEntryId:
		return "AuditDeleteReferencesEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ClientUserId:
		return "AuditDeleteReferencesEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventId:
		return "AuditUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_EventType:
		return "AuditUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceNode:
		return "AuditUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_SourceName:
		return "AuditUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Time:
		return "AuditUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ReceiveTime:
		return "AuditUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_LocalTime:
		return "AuditUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Message:
		return "AuditUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Severity:
		return "AuditUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ActionTimeStamp:
		return "AuditUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_Status:
		return "AuditUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ServerId:
		return "AuditUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientAuditEntryId:
		return "AuditUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateEventType_ClientUserId:
		return "AuditUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventId:
		return "AuditWriteUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_EventType:
		return "AuditWriteUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceNode:
		return "AuditWriteUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_SourceName:
		return "AuditWriteUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Time:
		return "AuditWriteUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ReceiveTime:
		return "AuditWriteUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_LocalTime:
		return "AuditWriteUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Message:
		return "AuditWriteUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Severity:
		return "AuditWriteUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ActionTimeStamp:
		return "AuditWriteUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_Status:
		return "AuditWriteUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ServerId:
		return "AuditWriteUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientAuditEntryId:
		return "AuditWriteUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_ClientUserId:
		return "AuditWriteUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventId:
		return "AuditHistoryUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_EventType:
		return "AuditHistoryUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceNode:
		return "AuditHistoryUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_SourceName:
		return "AuditHistoryUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Time:
		return "AuditHistoryUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ReceiveTime:
		return "AuditHistoryUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_LocalTime:
		return "AuditHistoryUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Message:
		return "AuditHistoryUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Severity:
		return "AuditHistoryUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ActionTimeStamp:
		return "AuditHistoryUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_Status:
		return "AuditHistoryUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ServerId:
		return "AuditHistoryUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientAuditEntryId:
		return "AuditHistoryUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ClientUserId:
		return "AuditHistoryUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventId:
		return "AuditHistoryEventUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_EventType:
		return "AuditHistoryEventUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceNode:
		return "AuditHistoryEventUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_SourceName:
		return "AuditHistoryEventUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Time:
		return "AuditHistoryEventUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ReceiveTime:
		return "AuditHistoryEventUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_LocalTime:
		return "AuditHistoryEventUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Message:
		return "AuditHistoryEventUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Severity:
		return "AuditHistoryEventUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ActionTimeStamp:
		return "AuditHistoryEventUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Status:
		return "AuditHistoryEventUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ServerId:
		return "AuditHistoryEventUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientAuditEntryId:
		return "AuditHistoryEventUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ClientUserId:
		return "AuditHistoryEventUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_ParameterDataTypeId:
		return "AuditHistoryEventUpdateEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventId:
		return "AuditHistoryValueUpdateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_EventType:
		return "AuditHistoryValueUpdateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceNode:
		return "AuditHistoryValueUpdateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_SourceName:
		return "AuditHistoryValueUpdateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Time:
		return "AuditHistoryValueUpdateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ReceiveTime:
		return "AuditHistoryValueUpdateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_LocalTime:
		return "AuditHistoryValueUpdateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Message:
		return "AuditHistoryValueUpdateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Severity:
		return "AuditHistoryValueUpdateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ActionTimeStamp:
		return "AuditHistoryValueUpdateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_Status:
		return "AuditHistoryValueUpdateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ServerId:
		return "AuditHistoryValueUpdateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientAuditEntryId:
		return "AuditHistoryValueUpdateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ClientUserId:
		return "AuditHistoryValueUpdateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_ParameterDataTypeId:
		return "AuditHistoryValueUpdateEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventId:
		return "AuditHistoryDeleteEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_EventType:
		return "AuditHistoryDeleteEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceNode:
		return "AuditHistoryDeleteEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_SourceName:
		return "AuditHistoryDeleteEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Time:
		return "AuditHistoryDeleteEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ReceiveTime:
		return "AuditHistoryDeleteEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_LocalTime:
		return "AuditHistoryDeleteEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Message:
		return "AuditHistoryDeleteEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Severity:
		return "AuditHistoryDeleteEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ActionTimeStamp:
		return "AuditHistoryDeleteEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_Status:
		return "AuditHistoryDeleteEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ServerId:
		return "AuditHistoryDeleteEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientAuditEntryId:
		return "AuditHistoryDeleteEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ClientUserId:
		return "AuditHistoryDeleteEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_ParameterDataTypeId:
		return "AuditHistoryDeleteEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventId:
		return "AuditHistoryRawModifyDeleteEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EventType:
		return "AuditHistoryRawModifyDeleteEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceNode:
		return "AuditHistoryRawModifyDeleteEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_SourceName:
		return "AuditHistoryRawModifyDeleteEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Time:
		return "AuditHistoryRawModifyDeleteEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ReceiveTime:
		return "AuditHistoryRawModifyDeleteEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_LocalTime:
		return "AuditHistoryRawModifyDeleteEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Message:
		return "AuditHistoryRawModifyDeleteEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Severity:
		return "AuditHistoryRawModifyDeleteEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ActionTimeStamp:
		return "AuditHistoryRawModifyDeleteEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_Status:
		return "AuditHistoryRawModifyDeleteEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ServerId:
		return "AuditHistoryRawModifyDeleteEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId:
		return "AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ClientUserId:
		return "AuditHistoryRawModifyDeleteEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId:
		return "AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_UpdatedNode:
		return "AuditHistoryRawModifyDeleteEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventId:
		return "AuditHistoryAtTimeDeleteEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_EventType:
		return "AuditHistoryAtTimeDeleteEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceNode:
		return "AuditHistoryAtTimeDeleteEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_SourceName:
		return "AuditHistoryAtTimeDeleteEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Time:
		return "AuditHistoryAtTimeDeleteEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReceiveTime:
		return "AuditHistoryAtTimeDeleteEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_LocalTime:
		return "AuditHistoryAtTimeDeleteEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Message:
		return "AuditHistoryAtTimeDeleteEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Severity:
		return "AuditHistoryAtTimeDeleteEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ActionTimeStamp:
		return "AuditHistoryAtTimeDeleteEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_Status:
		return "AuditHistoryAtTimeDeleteEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ServerId:
		return "AuditHistoryAtTimeDeleteEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId:
		return "AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ClientUserId:
		return "AuditHistoryAtTimeDeleteEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId:
		return "AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_UpdatedNode:
		return "AuditHistoryAtTimeDeleteEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventId:
		return "AuditHistoryEventDeleteEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventType:
		return "AuditHistoryEventDeleteEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceNode:
		return "AuditHistoryEventDeleteEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_SourceName:
		return "AuditHistoryEventDeleteEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Time:
		return "AuditHistoryEventDeleteEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ReceiveTime:
		return "AuditHistoryEventDeleteEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_LocalTime:
		return "AuditHistoryEventDeleteEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Message:
		return "AuditHistoryEventDeleteEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Severity:
		return "AuditHistoryEventDeleteEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ActionTimeStamp:
		return "AuditHistoryEventDeleteEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_Status:
		return "AuditHistoryEventDeleteEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ServerId:
		return "AuditHistoryEventDeleteEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientAuditEntryId:
		return "AuditHistoryEventDeleteEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ClientUserId:
		return "AuditHistoryEventDeleteEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_ParameterDataTypeId:
		return "AuditHistoryEventDeleteEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_UpdatedNode:
		return "AuditHistoryEventDeleteEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventId:
		return "AuditUpdateMethodEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_EventType:
		return "AuditUpdateMethodEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceNode:
		return "AuditUpdateMethodEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_SourceName:
		return "AuditUpdateMethodEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Time:
		return "AuditUpdateMethodEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ReceiveTime:
		return "AuditUpdateMethodEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_LocalTime:
		return "AuditUpdateMethodEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Message:
		return "AuditUpdateMethodEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Severity:
		return "AuditUpdateMethodEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ActionTimeStamp:
		return "AuditUpdateMethodEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_Status:
		return "AuditUpdateMethodEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ServerId:
		return "AuditUpdateMethodEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientAuditEntryId:
		return "AuditUpdateMethodEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_ClientUserId:
		return "AuditUpdateMethodEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventId:
		return "AuditUpdateStateEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_EventType:
		return "AuditUpdateStateEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceNode:
		return "AuditUpdateStateEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_SourceName:
		return "AuditUpdateStateEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Time:
		return "AuditUpdateStateEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ReceiveTime:
		return "AuditUpdateStateEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_LocalTime:
		return "AuditUpdateStateEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Message:
		return "AuditUpdateStateEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Severity:
		return "AuditUpdateStateEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ActionTimeStamp:
		return "AuditUpdateStateEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_Status:
		return "AuditUpdateStateEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ServerId:
		return "AuditUpdateStateEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientAuditEntryId:
		return "AuditUpdateStateEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_ClientUserId:
		return "AuditUpdateStateEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_MethodId:
		return "AuditUpdateStateEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_InputArguments:
		return "AuditUpdateStateEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventId:
		return "AuditConditionEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_EventType:
		return "AuditConditionEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceNode:
		return "AuditConditionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_SourceName:
		return "AuditConditionEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Time:
		return "AuditConditionEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ReceiveTime:
		return "AuditConditionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_LocalTime:
		return "AuditConditionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Message:
		return "AuditConditionEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Severity:
		return "AuditConditionEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ActionTimeStamp:
		return "AuditConditionEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_Status:
		return "AuditConditionEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ServerId:
		return "AuditConditionEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientAuditEntryId:
		return "AuditConditionEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_ClientUserId:
		return "AuditConditionEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_MethodId:
		return "AuditConditionEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEventType_InputArguments:
		return "AuditConditionEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventId:
		return "AuditConditionEnableEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_EventType:
		return "AuditConditionEnableEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceNode:
		return "AuditConditionEnableEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_SourceName:
		return "AuditConditionEnableEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Time:
		return "AuditConditionEnableEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ReceiveTime:
		return "AuditConditionEnableEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_LocalTime:
		return "AuditConditionEnableEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Message:
		return "AuditConditionEnableEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Severity:
		return "AuditConditionEnableEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ActionTimeStamp:
		return "AuditConditionEnableEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_Status:
		return "AuditConditionEnableEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ServerId:
		return "AuditConditionEnableEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientAuditEntryId:
		return "AuditConditionEnableEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_ClientUserId:
		return "AuditConditionEnableEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_MethodId:
		return "AuditConditionEnableEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionEnableEventType_InputArguments:
		return "AuditConditionEnableEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventId:
		return "AuditConditionCommentEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_EventType:
		return "AuditConditionCommentEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceNode:
		return "AuditConditionCommentEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_SourceName:
		return "AuditConditionCommentEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Time:
		return "AuditConditionCommentEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ReceiveTime:
		return "AuditConditionCommentEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_LocalTime:
		return "AuditConditionCommentEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Message:
		return "AuditConditionCommentEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Severity:
		return "AuditConditionCommentEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ActionTimeStamp:
		return "AuditConditionCommentEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Status:
		return "AuditConditionCommentEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ServerId:
		return "AuditConditionCommentEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientAuditEntryId:
		return "AuditConditionCommentEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ClientUserId:
		return "AuditConditionCommentEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_MethodId:
		return "AuditConditionCommentEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_InputArguments:
		return "AuditConditionCommentEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventId:
		return "AuditConditionRespondEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_EventType:
		return "AuditConditionRespondEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceNode:
		return "AuditConditionRespondEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SourceName:
		return "AuditConditionRespondEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Time:
		return "AuditConditionRespondEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ReceiveTime:
		return "AuditConditionRespondEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_LocalTime:
		return "AuditConditionRespondEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Message:
		return "AuditConditionRespondEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Severity:
		return "AuditConditionRespondEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ActionTimeStamp:
		return "AuditConditionRespondEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_Status:
		return "AuditConditionRespondEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ServerId:
		return "AuditConditionRespondEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientAuditEntryId:
		return "AuditConditionRespondEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_ClientUserId:
		return "AuditConditionRespondEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_MethodId:
		return "AuditConditionRespondEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_InputArguments:
		return "AuditConditionRespondEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventId:
		return "AuditConditionAcknowledgeEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_EventType:
		return "AuditConditionAcknowledgeEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceNode:
		return "AuditConditionAcknowledgeEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_SourceName:
		return "AuditConditionAcknowledgeEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Time:
		return "AuditConditionAcknowledgeEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ReceiveTime:
		return "AuditConditionAcknowledgeEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_LocalTime:
		return "AuditConditionAcknowledgeEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Message:
		return "AuditConditionAcknowledgeEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Severity:
		return "AuditConditionAcknowledgeEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ActionTimeStamp:
		return "AuditConditionAcknowledgeEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Status:
		return "AuditConditionAcknowledgeEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ServerId:
		return "AuditConditionAcknowledgeEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientAuditEntryId:
		return "AuditConditionAcknowledgeEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ClientUserId:
		return "AuditConditionAcknowledgeEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_MethodId:
		return "AuditConditionAcknowledgeEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_InputArguments:
		return "AuditConditionAcknowledgeEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventId:
		return "AuditConditionConfirmEventType_EventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_EventType:
		return "AuditConditionConfirmEventType_EventType"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceNode:
		return "AuditConditionConfirmEventType_SourceNode"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_SourceName:
		return "AuditConditionConfirmEventType_SourceName"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Time:
		return "AuditConditionConfirmEventType_Time"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ReceiveTime:
		return "AuditConditionConfirmEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_LocalTime:
		return "AuditConditionConfirmEventType_LocalTime"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Message:
		return "AuditConditionConfirmEventType_Message"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Severity:
		return "AuditConditionConfirmEventType_Severity"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ActionTimeStamp:
		return "AuditConditionConfirmEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Status:
		return "AuditConditionConfirmEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ServerId:
		return "AuditConditionConfirmEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientAuditEntryId:
		return "AuditConditionConfirmEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ClientUserId:
		return "AuditConditionConfirmEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_MethodId:
		return "AuditConditionConfirmEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_InputArguments:
		return "AuditConditionConfirmEventType_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAudit) String() string {
	return e.PLC4XEnumName()
}
