/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableApplication is an enum
type OpcuaNodeIdServicesVariableApplication int32

type IOpcuaNodeIdServicesVariableApplication interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings                                                                                                                    OpcuaNodeIdServicesVariableApplication = 7597
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                                          OpcuaNodeIdServicesVariableApplication = 25735
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                                      OpcuaNodeIdServicesVariableApplication = 25736
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                                                  OpcuaNodeIdServicesVariableApplication = 25737
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                                     OpcuaNodeIdServicesVariableApplication = 25738
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                                      OpcuaNodeIdServicesVariableApplication = 25739
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength                                           OpcuaNodeIdServicesVariableApplication = 25740
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime                                              OpcuaNodeIdServicesVariableApplication = 25741
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                                           OpcuaNodeIdServicesVariableApplication = 25743
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                                          OpcuaNodeIdServicesVariableApplication = 25744
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                                          OpcuaNodeIdServicesVariableApplication = 25746
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                                           OpcuaNodeIdServicesVariableApplication = 25748
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                                          OpcuaNodeIdServicesVariableApplication = 25749
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                                          OpcuaNodeIdServicesVariableApplication = 25751
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                                    OpcuaNodeIdServicesVariableApplication = 25753
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                                   OpcuaNodeIdServicesVariableApplication = 25754
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                                    OpcuaNodeIdServicesVariableApplication = 25756
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                                                OpcuaNodeIdServicesVariableApplication = 25757
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency                                               OpcuaNodeIdServicesVariableApplication = 25758
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions                                      OpcuaNodeIdServicesVariableApplication = 25759
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                                  OpcuaNodeIdServicesVariableApplication = 25761
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                                 OpcuaNodeIdServicesVariableApplication = 25762
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 25764
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                                OpcuaNodeIdServicesVariableApplication = 25765
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 25767
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                              OpcuaNodeIdServicesVariableApplication = 25769
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                                        OpcuaNodeIdServicesVariableApplication = 25770
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments                                         OpcuaNodeIdServicesVariableApplication = 25773
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId                                              OpcuaNodeIdServicesVariableApplication = 25775
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType                                            OpcuaNodeIdServicesVariableApplication = 25776
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode                                           OpcuaNodeIdServicesVariableApplication = 25777
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName                                           OpcuaNodeIdServicesVariableApplication = 25778
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time                                                 OpcuaNodeIdServicesVariableApplication = 25779
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime                                          OpcuaNodeIdServicesVariableApplication = 25780
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime                                            OpcuaNodeIdServicesVariableApplication = 25781
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message                                              OpcuaNodeIdServicesVariableApplication = 25782
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity                                             OpcuaNodeIdServicesVariableApplication = 25783
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId                                     OpcuaNodeIdServicesVariableApplication = 25784
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName                                   OpcuaNodeIdServicesVariableApplication = 25785
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId                                  OpcuaNodeIdServicesVariableApplication = 25786
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName                                OpcuaNodeIdServicesVariableApplication = 25787
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName                                        OpcuaNodeIdServicesVariableApplication = 25788
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId                                             OpcuaNodeIdServicesVariableApplication = 25789
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain                                               OpcuaNodeIdServicesVariableApplication = 25790
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState                                         OpcuaNodeIdServicesVariableApplication = 25791
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id                                      OpcuaNodeIdServicesVariableApplication = 25792
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name                                    OpcuaNodeIdServicesVariableApplication = 25793
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number                                  OpcuaNodeIdServicesVariableApplication = 25794
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 25795
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 25796
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 25797
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState                               OpcuaNodeIdServicesVariableApplication = 25798
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState                              OpcuaNodeIdServicesVariableApplication = 25799
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality                                              OpcuaNodeIdServicesVariableApplication = 25800
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableApplication = 25801
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity                                         OpcuaNodeIdServicesVariableApplication = 25802
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableApplication = 25803
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment                                              OpcuaNodeIdServicesVariableApplication = 25804
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableApplication = 25805
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId                                         OpcuaNodeIdServicesVariableApplication = 25806
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments                            OpcuaNodeIdServicesVariableApplication = 25810
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState                                           OpcuaNodeIdServicesVariableApplication = 25811
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id                                        OpcuaNodeIdServicesVariableApplication = 25812
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name                                      OpcuaNodeIdServicesVariableApplication = 25813
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number                                    OpcuaNodeIdServicesVariableApplication = 25814
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 25815
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 25816
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 25817
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 25818
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState                                OpcuaNodeIdServicesVariableApplication = 25819
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState                                       OpcuaNodeIdServicesVariableApplication = 25820
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableApplication = 25821
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableApplication = 25822
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number                                OpcuaNodeIdServicesVariableApplication = 25823
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableApplication = 25824
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableApplication = 25825
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableApplication = 25826
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableApplication = 25827
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableApplication = 25828
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableApplication = 25830
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments                               OpcuaNodeIdServicesVariableApplication = 25832
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState                                          OpcuaNodeIdServicesVariableApplication = 25833
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id                                       OpcuaNodeIdServicesVariableApplication = 25834
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name                                     OpcuaNodeIdServicesVariableApplication = 25835
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number                                   OpcuaNodeIdServicesVariableApplication = 25836
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableApplication = 25837
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableApplication = 25838
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableApplication = 25839
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState                                OpcuaNodeIdServicesVariableApplication = 25840
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState                               OpcuaNodeIdServicesVariableApplication = 25841
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode                                            OpcuaNodeIdServicesVariableApplication = 25842
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState                                      OpcuaNodeIdServicesVariableApplication = 25843
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id                                   OpcuaNodeIdServicesVariableApplication = 25844
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name                                 OpcuaNodeIdServicesVariableApplication = 25845
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number                               OpcuaNodeIdServicesVariableApplication = 25846
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableApplication = 25847
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableApplication = 25848
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableApplication = 25849
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableApplication = 25850
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableApplication = 25851
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState                                    OpcuaNodeIdServicesVariableApplication = 25852
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableApplication = 25853
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableApplication = 25854
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableApplication = 25855
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableApplication = 25856
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableApplication = 25857
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableApplication = 25858
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableApplication = 25859
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableApplication = 25860
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableApplication = 25862
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableApplication = 25863
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableApplication = 25864
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableApplication = 25865
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableApplication = 25866
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableApplication = 25867
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableApplication = 25868
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableApplication = 25869
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableApplication = 25870
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableApplication = 25871
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableApplication = 25872
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableApplication = 25873
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableApplication = 25874
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableApplication = 25875
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableApplication = 25877
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableApplication = 25879
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableApplication = 25882
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableApplication = 25885
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableApplication = 25886
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved                                       OpcuaNodeIdServicesVariableApplication = 25887
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled                                       OpcuaNodeIdServicesVariableApplication = 25888
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound                                         OpcuaNodeIdServicesVariableApplication = 25889
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableApplication = 25890
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableApplication = 25891
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableApplication = 25892
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState                                         OpcuaNodeIdServicesVariableApplication = 25893
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id                                      OpcuaNodeIdServicesVariableApplication = 25894
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name                                    OpcuaNodeIdServicesVariableApplication = 25895
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number                                  OpcuaNodeIdServicesVariableApplication = 25896
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 25897
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 25898
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 25899
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState                               OpcuaNodeIdServicesVariableApplication = 25900
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState                              OpcuaNodeIdServicesVariableApplication = 25901
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay                                              OpcuaNodeIdServicesVariableApplication = 25902
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay                                             OpcuaNodeIdServicesVariableApplication = 25903
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableApplication = 25904
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState                                         OpcuaNodeIdServicesVariableApplication = 25906
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id                                      OpcuaNodeIdServicesVariableApplication = 25907
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name                                    OpcuaNodeIdServicesVariableApplication = 25908
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number                                  OpcuaNodeIdServicesVariableApplication = 25909
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 25910
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 25911
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 25912
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState                               OpcuaNodeIdServicesVariableApplication = 25913
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState                              OpcuaNodeIdServicesVariableApplication = 25914
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime                                          OpcuaNodeIdServicesVariableApplication = 25915
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableApplication = 25916
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 25920
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableApplication = 25923
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableApplication = 25926
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableApplication = 25929
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments                                OpcuaNodeIdServicesVariableApplication = 25932
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableApplication = 25934
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState                                          OpcuaNodeIdServicesVariableApplication = 25935
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate                                       OpcuaNodeIdServicesVariableApplication = 25936
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit                                      OpcuaNodeIdServicesVariableApplication = 25937
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType                                      OpcuaNodeIdServicesVariableApplication = 25938
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate                                          OpcuaNodeIdServicesVariableApplication = 25939
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId                                              OpcuaNodeIdServicesVariableApplication = 25941
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType                                            OpcuaNodeIdServicesVariableApplication = 25942
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode                                           OpcuaNodeIdServicesVariableApplication = 25943
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName                                           OpcuaNodeIdServicesVariableApplication = 25944
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time                                                 OpcuaNodeIdServicesVariableApplication = 25945
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime                                          OpcuaNodeIdServicesVariableApplication = 25946
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime                                            OpcuaNodeIdServicesVariableApplication = 25947
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message                                              OpcuaNodeIdServicesVariableApplication = 25948
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity                                             OpcuaNodeIdServicesVariableApplication = 25949
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId                                     OpcuaNodeIdServicesVariableApplication = 25950
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName                                   OpcuaNodeIdServicesVariableApplication = 25951
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId                                  OpcuaNodeIdServicesVariableApplication = 25952
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName                                OpcuaNodeIdServicesVariableApplication = 25953
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName                                        OpcuaNodeIdServicesVariableApplication = 25954
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId                                             OpcuaNodeIdServicesVariableApplication = 25955
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain                                               OpcuaNodeIdServicesVariableApplication = 25956
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState                                         OpcuaNodeIdServicesVariableApplication = 25957
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id                                      OpcuaNodeIdServicesVariableApplication = 25958
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name                                    OpcuaNodeIdServicesVariableApplication = 25959
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number                                  OpcuaNodeIdServicesVariableApplication = 25960
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 25961
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 25962
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 25963
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState                               OpcuaNodeIdServicesVariableApplication = 25964
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState                              OpcuaNodeIdServicesVariableApplication = 25965
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality                                              OpcuaNodeIdServicesVariableApplication = 25966
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableApplication = 25967
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity                                         OpcuaNodeIdServicesVariableApplication = 25968
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableApplication = 25969
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment                                              OpcuaNodeIdServicesVariableApplication = 25970
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableApplication = 25971
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId                                         OpcuaNodeIdServicesVariableApplication = 25972
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments                            OpcuaNodeIdServicesVariableApplication = 25976
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState                                           OpcuaNodeIdServicesVariableApplication = 25977
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id                                        OpcuaNodeIdServicesVariableApplication = 25978
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name                                      OpcuaNodeIdServicesVariableApplication = 25979
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number                                    OpcuaNodeIdServicesVariableApplication = 25980
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 25981
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 25982
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 25983
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 25984
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState                                OpcuaNodeIdServicesVariableApplication = 25985
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState                                       OpcuaNodeIdServicesVariableApplication = 25986
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableApplication = 25987
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableApplication = 25988
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number                                OpcuaNodeIdServicesVariableApplication = 25989
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableApplication = 25990
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableApplication = 25991
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableApplication = 25992
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableApplication = 25993
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableApplication = 25994
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableApplication = 25996
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments                               OpcuaNodeIdServicesVariableApplication = 25998
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState                                          OpcuaNodeIdServicesVariableApplication = 25999
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id                                       OpcuaNodeIdServicesVariableApplication = 26000
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name                                     OpcuaNodeIdServicesVariableApplication = 26001
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number                                   OpcuaNodeIdServicesVariableApplication = 26002
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableApplication = 26003
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableApplication = 26004
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableApplication = 26005
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState                                OpcuaNodeIdServicesVariableApplication = 26006
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState                               OpcuaNodeIdServicesVariableApplication = 26007
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode                                            OpcuaNodeIdServicesVariableApplication = 26008
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState                                      OpcuaNodeIdServicesVariableApplication = 26009
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id                                   OpcuaNodeIdServicesVariableApplication = 26010
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name                                 OpcuaNodeIdServicesVariableApplication = 26011
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number                               OpcuaNodeIdServicesVariableApplication = 26012
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableApplication = 26013
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableApplication = 26014
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableApplication = 26015
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableApplication = 26016
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableApplication = 26017
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState                                    OpcuaNodeIdServicesVariableApplication = 26018
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableApplication = 26019
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableApplication = 26020
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableApplication = 26021
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableApplication = 26022
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableApplication = 26023
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableApplication = 26024
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableApplication = 26025
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableApplication = 26026
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableApplication = 26028
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableApplication = 26029
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableApplication = 26030
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableApplication = 26031
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableApplication = 26032
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableApplication = 26033
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableApplication = 26034
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableApplication = 26035
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableApplication = 26036
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableApplication = 26037
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableApplication = 26038
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableApplication = 26039
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableApplication = 26040
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableApplication = 26041
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableApplication = 26043
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableApplication = 26045
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableApplication = 26048
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableApplication = 26051
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableApplication = 26052
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved                                       OpcuaNodeIdServicesVariableApplication = 26053
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled                                       OpcuaNodeIdServicesVariableApplication = 26054
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound                                         OpcuaNodeIdServicesVariableApplication = 26055
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableApplication = 26056
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableApplication = 26057
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableApplication = 26058
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState                                         OpcuaNodeIdServicesVariableApplication = 26059
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id                                      OpcuaNodeIdServicesVariableApplication = 26060
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name                                    OpcuaNodeIdServicesVariableApplication = 26061
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number                                  OpcuaNodeIdServicesVariableApplication = 26062
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 26063
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 26064
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 26065
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState                               OpcuaNodeIdServicesVariableApplication = 26066
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState                              OpcuaNodeIdServicesVariableApplication = 26067
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay                                              OpcuaNodeIdServicesVariableApplication = 26068
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay                                             OpcuaNodeIdServicesVariableApplication = 26069
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableApplication = 26070
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState                                         OpcuaNodeIdServicesVariableApplication = 26072
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id                                      OpcuaNodeIdServicesVariableApplication = 26073
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name                                    OpcuaNodeIdServicesVariableApplication = 26074
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number                                  OpcuaNodeIdServicesVariableApplication = 26075
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 26076
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 26077
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 26078
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState                               OpcuaNodeIdServicesVariableApplication = 26079
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState                              OpcuaNodeIdServicesVariableApplication = 26080
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime                                          OpcuaNodeIdServicesVariableApplication = 26081
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableApplication = 26082
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26086
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableApplication = 26089
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableApplication = 26092
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableApplication = 26095
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments                                OpcuaNodeIdServicesVariableApplication = 26098
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableApplication = 26100
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState                                          OpcuaNodeIdServicesVariableApplication = 26101
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId                                          OpcuaNodeIdServicesVariableApplication = 26102
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime                                       OpcuaNodeIdServicesVariableApplication = 26103
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency                                      OpcuaNodeIdServicesVariableApplication = 26104
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                                                OpcuaNodeIdServicesVariableApplication = 26107
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                                            OpcuaNodeIdServicesVariableApplication = 26108
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                                        OpcuaNodeIdServicesVariableApplication = 26109
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                                           OpcuaNodeIdServicesVariableApplication = 26110
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                                            OpcuaNodeIdServicesVariableApplication = 26111
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength                                                 OpcuaNodeIdServicesVariableApplication = 26112
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime                                                    OpcuaNodeIdServicesVariableApplication = 26113
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                                                 OpcuaNodeIdServicesVariableApplication = 26115
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                                                OpcuaNodeIdServicesVariableApplication = 26116
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                                                OpcuaNodeIdServicesVariableApplication = 26118
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                                                 OpcuaNodeIdServicesVariableApplication = 26120
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                                                OpcuaNodeIdServicesVariableApplication = 26121
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                                                OpcuaNodeIdServicesVariableApplication = 26123
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                          OpcuaNodeIdServicesVariableApplication = 26125
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                         OpcuaNodeIdServicesVariableApplication = 26126
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                          OpcuaNodeIdServicesVariableApplication = 26128
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                                      OpcuaNodeIdServicesVariableApplication = 26129
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency                                                     OpcuaNodeIdServicesVariableApplication = 26130
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions                                            OpcuaNodeIdServicesVariableApplication = 26131
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                        OpcuaNodeIdServicesVariableApplication = 26133
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                       OpcuaNodeIdServicesVariableApplication = 26134
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                       OpcuaNodeIdServicesVariableApplication = 26136
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                      OpcuaNodeIdServicesVariableApplication = 26137
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                       OpcuaNodeIdServicesVariableApplication = 26139
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                                    OpcuaNodeIdServicesVariableApplication = 26141
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                                              OpcuaNodeIdServicesVariableApplication = 26142
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments                                               OpcuaNodeIdServicesVariableApplication = 26145
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId                                                    OpcuaNodeIdServicesVariableApplication = 26147
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType                                                  OpcuaNodeIdServicesVariableApplication = 26148
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode                                                 OpcuaNodeIdServicesVariableApplication = 26149
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName                                                 OpcuaNodeIdServicesVariableApplication = 26150
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time                                                       OpcuaNodeIdServicesVariableApplication = 26151
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime                                                OpcuaNodeIdServicesVariableApplication = 26152
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime                                                  OpcuaNodeIdServicesVariableApplication = 26153
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message                                                    OpcuaNodeIdServicesVariableApplication = 26154
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity                                                   OpcuaNodeIdServicesVariableApplication = 26155
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId                                           OpcuaNodeIdServicesVariableApplication = 26156
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName                                         OpcuaNodeIdServicesVariableApplication = 26157
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId                                        OpcuaNodeIdServicesVariableApplication = 26158
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName                                      OpcuaNodeIdServicesVariableApplication = 26159
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName                                              OpcuaNodeIdServicesVariableApplication = 26160
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId                                                   OpcuaNodeIdServicesVariableApplication = 26161
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain                                                     OpcuaNodeIdServicesVariableApplication = 26162
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState                                               OpcuaNodeIdServicesVariableApplication = 26163
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id                                            OpcuaNodeIdServicesVariableApplication = 26164
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name                                          OpcuaNodeIdServicesVariableApplication = 26165
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number                                        OpcuaNodeIdServicesVariableApplication = 26166
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26167
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26168
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26169
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26170
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26171
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality                                                    OpcuaNodeIdServicesVariableApplication = 26172
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableApplication = 26173
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity                                               OpcuaNodeIdServicesVariableApplication = 26174
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableApplication = 26175
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment                                                    OpcuaNodeIdServicesVariableApplication = 26176
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableApplication = 26177
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId                                               OpcuaNodeIdServicesVariableApplication = 26178
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableApplication = 26182
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState                                                 OpcuaNodeIdServicesVariableApplication = 26183
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id                                              OpcuaNodeIdServicesVariableApplication = 26184
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name                                            OpcuaNodeIdServicesVariableApplication = 26185
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number                                          OpcuaNodeIdServicesVariableApplication = 26186
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableApplication = 26187
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableApplication = 26188
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableApplication = 26189
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState                                       OpcuaNodeIdServicesVariableApplication = 26190
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState                                      OpcuaNodeIdServicesVariableApplication = 26191
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState                                             OpcuaNodeIdServicesVariableApplication = 26192
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableApplication = 26193
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableApplication = 26194
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableApplication = 26195
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableApplication = 26196
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableApplication = 26197
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableApplication = 26198
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableApplication = 26199
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableApplication = 26200
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26202
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableApplication = 26204
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState                                                OpcuaNodeIdServicesVariableApplication = 26205
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id                                             OpcuaNodeIdServicesVariableApplication = 26206
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name                                           OpcuaNodeIdServicesVariableApplication = 26207
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number                                         OpcuaNodeIdServicesVariableApplication = 26208
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableApplication = 26209
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableApplication = 26210
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableApplication = 26211
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableApplication = 26212
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableApplication = 26213
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode                                                  OpcuaNodeIdServicesVariableApplication = 26214
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState                                            OpcuaNodeIdServicesVariableApplication = 26215
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id                                         OpcuaNodeIdServicesVariableApplication = 26216
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name                                       OpcuaNodeIdServicesVariableApplication = 26217
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number                                     OpcuaNodeIdServicesVariableApplication = 26218
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableApplication = 26219
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableApplication = 26220
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableApplication = 26221
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableApplication = 26222
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableApplication = 26223
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState                                          OpcuaNodeIdServicesVariableApplication = 26224
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableApplication = 26225
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableApplication = 26226
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableApplication = 26227
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableApplication = 26228
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableApplication = 26229
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableApplication = 26230
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableApplication = 26231
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableApplication = 26232
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableApplication = 26234
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableApplication = 26235
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableApplication = 26236
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableApplication = 26237
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableApplication = 26238
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableApplication = 26239
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableApplication = 26240
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableApplication = 26241
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableApplication = 26242
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableApplication = 26243
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableApplication = 26244
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableApplication = 26245
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableApplication = 26246
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableApplication = 26247
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableApplication = 26249
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableApplication = 26251
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableApplication = 26254
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableApplication = 26257
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableApplication = 26258
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved                                             OpcuaNodeIdServicesVariableApplication = 26259
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled                                             OpcuaNodeIdServicesVariableApplication = 26260
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound                                               OpcuaNodeIdServicesVariableApplication = 26261
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableApplication = 26262
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableApplication = 26263
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableApplication = 26264
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState                                               OpcuaNodeIdServicesVariableApplication = 26265
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id                                            OpcuaNodeIdServicesVariableApplication = 26266
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name                                          OpcuaNodeIdServicesVariableApplication = 26267
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number                                        OpcuaNodeIdServicesVariableApplication = 26268
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26269
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26270
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26271
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26272
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26273
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay                                                    OpcuaNodeIdServicesVariableApplication = 26274
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay                                                   OpcuaNodeIdServicesVariableApplication = 26275
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableApplication = 26276
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState                                               OpcuaNodeIdServicesVariableApplication = 26278
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id                                            OpcuaNodeIdServicesVariableApplication = 26279
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name                                          OpcuaNodeIdServicesVariableApplication = 26280
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number                                        OpcuaNodeIdServicesVariableApplication = 26281
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26282
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26283
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26284
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26285
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26286
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime                                                OpcuaNodeIdServicesVariableApplication = 26287
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableApplication = 26288
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableApplication = 26292
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26295
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableApplication = 26298
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26301
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableApplication = 26304
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableApplication = 26306
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState                                                OpcuaNodeIdServicesVariableApplication = 26307
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate                                             OpcuaNodeIdServicesVariableApplication = 26308
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit                                            OpcuaNodeIdServicesVariableApplication = 26309
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType                                            OpcuaNodeIdServicesVariableApplication = 26310
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate                                                OpcuaNodeIdServicesVariableApplication = 26311
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId                                                    OpcuaNodeIdServicesVariableApplication = 26313
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType                                                  OpcuaNodeIdServicesVariableApplication = 26314
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode                                                 OpcuaNodeIdServicesVariableApplication = 26315
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName                                                 OpcuaNodeIdServicesVariableApplication = 26316
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time                                                       OpcuaNodeIdServicesVariableApplication = 26317
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime                                                OpcuaNodeIdServicesVariableApplication = 26318
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime                                                  OpcuaNodeIdServicesVariableApplication = 26319
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message                                                    OpcuaNodeIdServicesVariableApplication = 26320
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity                                                   OpcuaNodeIdServicesVariableApplication = 26321
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId                                           OpcuaNodeIdServicesVariableApplication = 26322
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName                                         OpcuaNodeIdServicesVariableApplication = 26323
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId                                        OpcuaNodeIdServicesVariableApplication = 26324
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName                                      OpcuaNodeIdServicesVariableApplication = 26325
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName                                              OpcuaNodeIdServicesVariableApplication = 26326
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId                                                   OpcuaNodeIdServicesVariableApplication = 26327
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain                                                     OpcuaNodeIdServicesVariableApplication = 26328
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState                                               OpcuaNodeIdServicesVariableApplication = 26329
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id                                            OpcuaNodeIdServicesVariableApplication = 26330
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name                                          OpcuaNodeIdServicesVariableApplication = 26331
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number                                        OpcuaNodeIdServicesVariableApplication = 26332
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26333
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26334
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26335
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26336
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26337
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality                                                    OpcuaNodeIdServicesVariableApplication = 26338
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableApplication = 26339
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity                                               OpcuaNodeIdServicesVariableApplication = 26340
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableApplication = 26341
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment                                                    OpcuaNodeIdServicesVariableApplication = 26342
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableApplication = 26343
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId                                               OpcuaNodeIdServicesVariableApplication = 26344
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableApplication = 26348
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState                                                 OpcuaNodeIdServicesVariableApplication = 26349
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id                                              OpcuaNodeIdServicesVariableApplication = 26350
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name                                            OpcuaNodeIdServicesVariableApplication = 26351
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number                                          OpcuaNodeIdServicesVariableApplication = 26352
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableApplication = 26353
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableApplication = 26354
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableApplication = 26355
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState                                       OpcuaNodeIdServicesVariableApplication = 26356
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState                                      OpcuaNodeIdServicesVariableApplication = 26357
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState                                             OpcuaNodeIdServicesVariableApplication = 26358
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableApplication = 26359
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableApplication = 26360
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableApplication = 26361
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableApplication = 26362
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableApplication = 26363
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableApplication = 26364
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableApplication = 26365
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableApplication = 26366
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26368
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableApplication = 26370
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState                                                OpcuaNodeIdServicesVariableApplication = 26371
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id                                             OpcuaNodeIdServicesVariableApplication = 26372
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name                                           OpcuaNodeIdServicesVariableApplication = 26373
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number                                         OpcuaNodeIdServicesVariableApplication = 26374
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableApplication = 26375
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableApplication = 26376
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableApplication = 26377
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableApplication = 26378
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableApplication = 26379
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode                                                  OpcuaNodeIdServicesVariableApplication = 26380
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState                                            OpcuaNodeIdServicesVariableApplication = 26381
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id                                         OpcuaNodeIdServicesVariableApplication = 26382
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name                                       OpcuaNodeIdServicesVariableApplication = 26383
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number                                     OpcuaNodeIdServicesVariableApplication = 26384
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableApplication = 26385
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableApplication = 26386
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableApplication = 26387
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableApplication = 26388
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableApplication = 26389
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState                                          OpcuaNodeIdServicesVariableApplication = 26390
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableApplication = 26391
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableApplication = 26392
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableApplication = 26393
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableApplication = 26394
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableApplication = 26395
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableApplication = 26396
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableApplication = 26397
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableApplication = 26398
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableApplication = 26400
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableApplication = 26401
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableApplication = 26402
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableApplication = 26403
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableApplication = 26404
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableApplication = 26405
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableApplication = 26406
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableApplication = 26407
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableApplication = 26408
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableApplication = 26409
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableApplication = 26410
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableApplication = 26411
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableApplication = 26412
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableApplication = 26413
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableApplication = 26415
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableApplication = 26417
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableApplication = 26420
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableApplication = 26423
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableApplication = 26424
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved                                             OpcuaNodeIdServicesVariableApplication = 26425
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled                                             OpcuaNodeIdServicesVariableApplication = 26426
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound                                               OpcuaNodeIdServicesVariableApplication = 26427
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableApplication = 26428
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableApplication = 26429
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableApplication = 26430
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState                                               OpcuaNodeIdServicesVariableApplication = 26431
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id                                            OpcuaNodeIdServicesVariableApplication = 26432
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name                                          OpcuaNodeIdServicesVariableApplication = 26433
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number                                        OpcuaNodeIdServicesVariableApplication = 26434
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26435
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26436
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26437
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26438
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26439
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay                                                    OpcuaNodeIdServicesVariableApplication = 26440
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay                                                   OpcuaNodeIdServicesVariableApplication = 26441
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableApplication = 26442
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState                                               OpcuaNodeIdServicesVariableApplication = 26444
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id                                            OpcuaNodeIdServicesVariableApplication = 26445
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name                                          OpcuaNodeIdServicesVariableApplication = 26446
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number                                        OpcuaNodeIdServicesVariableApplication = 26447
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableApplication = 26448
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableApplication = 26449
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableApplication = 26450
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableApplication = 26451
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableApplication = 26452
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime                                                OpcuaNodeIdServicesVariableApplication = 26453
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableApplication = 26454
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableApplication = 26458
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26461
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableApplication = 26464
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26467
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableApplication = 26470
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableApplication = 26472
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState                                                OpcuaNodeIdServicesVariableApplication = 26473
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId                                                OpcuaNodeIdServicesVariableApplication = 26474
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime                                             OpcuaNodeIdServicesVariableApplication = 26475
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency                                            OpcuaNodeIdServicesVariableApplication = 26476
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                                            OpcuaNodeIdServicesVariableApplication = 26479
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                                        OpcuaNodeIdServicesVariableApplication = 26480
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                                    OpcuaNodeIdServicesVariableApplication = 26481
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                                       OpcuaNodeIdServicesVariableApplication = 26482
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                                        OpcuaNodeIdServicesVariableApplication = 26483
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength                                             OpcuaNodeIdServicesVariableApplication = 26484
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime                                                OpcuaNodeIdServicesVariableApplication = 26485
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                                             OpcuaNodeIdServicesVariableApplication = 26487
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                            OpcuaNodeIdServicesVariableApplication = 26488
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                                            OpcuaNodeIdServicesVariableApplication = 26490
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                                             OpcuaNodeIdServicesVariableApplication = 26492
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                            OpcuaNodeIdServicesVariableApplication = 26493
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                                            OpcuaNodeIdServicesVariableApplication = 26495
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                      OpcuaNodeIdServicesVariableApplication = 26497
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                     OpcuaNodeIdServicesVariableApplication = 26498
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                      OpcuaNodeIdServicesVariableApplication = 26500
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                                                  OpcuaNodeIdServicesVariableApplication = 26501
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency                                                 OpcuaNodeIdServicesVariableApplication = 26502
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions                                        OpcuaNodeIdServicesVariableApplication = 26503
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                                    OpcuaNodeIdServicesVariableApplication = 26505
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                                   OpcuaNodeIdServicesVariableApplication = 26506
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                                   OpcuaNodeIdServicesVariableApplication = 26508
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                                  OpcuaNodeIdServicesVariableApplication = 26509
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                                   OpcuaNodeIdServicesVariableApplication = 26511
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                                OpcuaNodeIdServicesVariableApplication = 26513
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                                          OpcuaNodeIdServicesVariableApplication = 26514
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments                                           OpcuaNodeIdServicesVariableApplication = 26517
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId                                                OpcuaNodeIdServicesVariableApplication = 26519
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType                                              OpcuaNodeIdServicesVariableApplication = 26520
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode                                             OpcuaNodeIdServicesVariableApplication = 26521
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName                                             OpcuaNodeIdServicesVariableApplication = 26522
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time                                                   OpcuaNodeIdServicesVariableApplication = 26523
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime                                            OpcuaNodeIdServicesVariableApplication = 26524
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime                                              OpcuaNodeIdServicesVariableApplication = 26525
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message                                                OpcuaNodeIdServicesVariableApplication = 26526
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity                                               OpcuaNodeIdServicesVariableApplication = 26527
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId                                       OpcuaNodeIdServicesVariableApplication = 26528
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName                                     OpcuaNodeIdServicesVariableApplication = 26529
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId                                    OpcuaNodeIdServicesVariableApplication = 26530
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName                                  OpcuaNodeIdServicesVariableApplication = 26531
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName                                          OpcuaNodeIdServicesVariableApplication = 26532
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId                                               OpcuaNodeIdServicesVariableApplication = 26533
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain                                                 OpcuaNodeIdServicesVariableApplication = 26534
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState                                           OpcuaNodeIdServicesVariableApplication = 26535
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id                                        OpcuaNodeIdServicesVariableApplication = 26536
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name                                      OpcuaNodeIdServicesVariableApplication = 26537
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number                                    OpcuaNodeIdServicesVariableApplication = 26538
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26539
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26540
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26541
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26542
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26543
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality                                                OpcuaNodeIdServicesVariableApplication = 26544
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableApplication = 26545
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity                                           OpcuaNodeIdServicesVariableApplication = 26546
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableApplication = 26547
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment                                                OpcuaNodeIdServicesVariableApplication = 26548
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableApplication = 26549
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId                                           OpcuaNodeIdServicesVariableApplication = 26550
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments                              OpcuaNodeIdServicesVariableApplication = 26554
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState                                             OpcuaNodeIdServicesVariableApplication = 26555
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id                                          OpcuaNodeIdServicesVariableApplication = 26556
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name                                        OpcuaNodeIdServicesVariableApplication = 26557
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number                                      OpcuaNodeIdServicesVariableApplication = 26558
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableApplication = 26559
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableApplication = 26560
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableApplication = 26561
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState                                   OpcuaNodeIdServicesVariableApplication = 26562
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState                                  OpcuaNodeIdServicesVariableApplication = 26563
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState                                         OpcuaNodeIdServicesVariableApplication = 26564
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableApplication = 26565
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableApplication = 26566
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableApplication = 26567
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 26568
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 26569
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 26570
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableApplication = 26571
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableApplication = 26572
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26574
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26576
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState                                            OpcuaNodeIdServicesVariableApplication = 26577
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id                                         OpcuaNodeIdServicesVariableApplication = 26578
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name                                       OpcuaNodeIdServicesVariableApplication = 26579
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number                                     OpcuaNodeIdServicesVariableApplication = 26580
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableApplication = 26581
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableApplication = 26582
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableApplication = 26583
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableApplication = 26584
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableApplication = 26585
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode                                              OpcuaNodeIdServicesVariableApplication = 26586
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState                                        OpcuaNodeIdServicesVariableApplication = 26587
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id                                     OpcuaNodeIdServicesVariableApplication = 26588
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name                                   OpcuaNodeIdServicesVariableApplication = 26589
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number                                 OpcuaNodeIdServicesVariableApplication = 26590
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableApplication = 26591
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableApplication = 26592
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableApplication = 26593
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableApplication = 26594
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableApplication = 26595
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState                                      OpcuaNodeIdServicesVariableApplication = 26596
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableApplication = 26597
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableApplication = 26598
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableApplication = 26599
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableApplication = 26600
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableApplication = 26601
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableApplication = 26602
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableApplication = 26603
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableApplication = 26604
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableApplication = 26606
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableApplication = 26607
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableApplication = 26608
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableApplication = 26609
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableApplication = 26610
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableApplication = 26611
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableApplication = 26612
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableApplication = 26613
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableApplication = 26614
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableApplication = 26615
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableApplication = 26616
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableApplication = 26617
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableApplication = 26618
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableApplication = 26619
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableApplication = 26621
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableApplication = 26623
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableApplication = 26626
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableApplication = 26629
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableApplication = 26630
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved                                         OpcuaNodeIdServicesVariableApplication = 26631
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled                                         OpcuaNodeIdServicesVariableApplication = 26632
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound                                           OpcuaNodeIdServicesVariableApplication = 26633
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableApplication = 26634
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableApplication = 26635
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableApplication = 26636
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState                                           OpcuaNodeIdServicesVariableApplication = 26637
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id                                        OpcuaNodeIdServicesVariableApplication = 26638
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name                                      OpcuaNodeIdServicesVariableApplication = 26639
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number                                    OpcuaNodeIdServicesVariableApplication = 26640
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26641
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26642
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26643
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26644
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26645
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay                                                OpcuaNodeIdServicesVariableApplication = 26646
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay                                               OpcuaNodeIdServicesVariableApplication = 26647
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableApplication = 26648
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState                                           OpcuaNodeIdServicesVariableApplication = 26650
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id                                        OpcuaNodeIdServicesVariableApplication = 26651
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name                                      OpcuaNodeIdServicesVariableApplication = 26652
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number                                    OpcuaNodeIdServicesVariableApplication = 26653
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26654
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26655
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26656
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26657
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26658
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime                                            OpcuaNodeIdServicesVariableApplication = 26659
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableApplication = 26660
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableApplication = 26664
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26667
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableApplication = 26670
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableApplication = 26673
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableApplication = 26676
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableApplication = 26678
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState                                            OpcuaNodeIdServicesVariableApplication = 26679
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate                                         OpcuaNodeIdServicesVariableApplication = 26680
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit                                        OpcuaNodeIdServicesVariableApplication = 26681
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType                                        OpcuaNodeIdServicesVariableApplication = 26682
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate                                            OpcuaNodeIdServicesVariableApplication = 26683
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId                                                OpcuaNodeIdServicesVariableApplication = 26685
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType                                              OpcuaNodeIdServicesVariableApplication = 26686
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode                                             OpcuaNodeIdServicesVariableApplication = 26687
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName                                             OpcuaNodeIdServicesVariableApplication = 26688
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time                                                   OpcuaNodeIdServicesVariableApplication = 26689
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime                                            OpcuaNodeIdServicesVariableApplication = 26690
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime                                              OpcuaNodeIdServicesVariableApplication = 26691
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message                                                OpcuaNodeIdServicesVariableApplication = 26692
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity                                               OpcuaNodeIdServicesVariableApplication = 26693
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId                                       OpcuaNodeIdServicesVariableApplication = 26694
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName                                     OpcuaNodeIdServicesVariableApplication = 26695
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId                                    OpcuaNodeIdServicesVariableApplication = 26696
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName                                  OpcuaNodeIdServicesVariableApplication = 26697
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName                                          OpcuaNodeIdServicesVariableApplication = 26698
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId                                               OpcuaNodeIdServicesVariableApplication = 26699
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain                                                 OpcuaNodeIdServicesVariableApplication = 26700
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState                                           OpcuaNodeIdServicesVariableApplication = 26701
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id                                        OpcuaNodeIdServicesVariableApplication = 26702
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name                                      OpcuaNodeIdServicesVariableApplication = 26703
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number                                    OpcuaNodeIdServicesVariableApplication = 26704
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26705
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26706
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26707
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26708
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26709
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality                                                OpcuaNodeIdServicesVariableApplication = 26710
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableApplication = 26711
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity                                           OpcuaNodeIdServicesVariableApplication = 26712
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableApplication = 26713
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment                                                OpcuaNodeIdServicesVariableApplication = 26714
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableApplication = 26715
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId                                           OpcuaNodeIdServicesVariableApplication = 26716
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments                              OpcuaNodeIdServicesVariableApplication = 26720
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState                                             OpcuaNodeIdServicesVariableApplication = 26721
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id                                          OpcuaNodeIdServicesVariableApplication = 26722
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name                                        OpcuaNodeIdServicesVariableApplication = 26723
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number                                      OpcuaNodeIdServicesVariableApplication = 26724
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableApplication = 26725
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableApplication = 26726
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableApplication = 26727
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState                                   OpcuaNodeIdServicesVariableApplication = 26728
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState                                  OpcuaNodeIdServicesVariableApplication = 26729
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState                                         OpcuaNodeIdServicesVariableApplication = 26730
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableApplication = 26731
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableApplication = 26732
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableApplication = 26733
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableApplication = 26734
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableApplication = 26735
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableApplication = 26736
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableApplication = 26737
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableApplication = 26738
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26740
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableApplication = 26742
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState                                            OpcuaNodeIdServicesVariableApplication = 26743
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id                                         OpcuaNodeIdServicesVariableApplication = 26744
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name                                       OpcuaNodeIdServicesVariableApplication = 26745
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number                                     OpcuaNodeIdServicesVariableApplication = 26746
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableApplication = 26747
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableApplication = 26748
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableApplication = 26749
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableApplication = 26750
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableApplication = 26751
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode                                              OpcuaNodeIdServicesVariableApplication = 26752
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState                                        OpcuaNodeIdServicesVariableApplication = 26753
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id                                     OpcuaNodeIdServicesVariableApplication = 26754
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name                                   OpcuaNodeIdServicesVariableApplication = 26755
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number                                 OpcuaNodeIdServicesVariableApplication = 26756
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableApplication = 26757
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableApplication = 26758
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableApplication = 26759
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableApplication = 26760
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableApplication = 26761
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState                                      OpcuaNodeIdServicesVariableApplication = 26762
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableApplication = 26763
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableApplication = 26764
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableApplication = 26765
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableApplication = 26766
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableApplication = 26767
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableApplication = 26768
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableApplication = 26769
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableApplication = 26770
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableApplication = 26772
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableApplication = 26773
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableApplication = 26774
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableApplication = 26775
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableApplication = 26776
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableApplication = 26777
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableApplication = 26778
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableApplication = 26779
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableApplication = 26780
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableApplication = 26781
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableApplication = 26782
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableApplication = 26783
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableApplication = 26784
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableApplication = 26785
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableApplication = 26787
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableApplication = 26789
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableApplication = 26792
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableApplication = 26795
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableApplication = 26796
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved                                         OpcuaNodeIdServicesVariableApplication = 26797
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled                                         OpcuaNodeIdServicesVariableApplication = 26798
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound                                           OpcuaNodeIdServicesVariableApplication = 26799
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableApplication = 26800
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableApplication = 26801
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableApplication = 26802
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState                                           OpcuaNodeIdServicesVariableApplication = 26803
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id                                        OpcuaNodeIdServicesVariableApplication = 26804
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name                                      OpcuaNodeIdServicesVariableApplication = 26805
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number                                    OpcuaNodeIdServicesVariableApplication = 26806
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26807
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26808
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26809
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26810
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26811
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay                                                OpcuaNodeIdServicesVariableApplication = 26812
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay                                               OpcuaNodeIdServicesVariableApplication = 26813
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableApplication = 26814
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState                                           OpcuaNodeIdServicesVariableApplication = 26816
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id                                        OpcuaNodeIdServicesVariableApplication = 26817
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name                                      OpcuaNodeIdServicesVariableApplication = 26818
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number                                    OpcuaNodeIdServicesVariableApplication = 26819
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableApplication = 26820
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableApplication = 26821
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableApplication = 26822
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableApplication = 26823
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState                                OpcuaNodeIdServicesVariableApplication = 26824
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime                                            OpcuaNodeIdServicesVariableApplication = 26825
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableApplication = 26826
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableApplication = 26830
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableApplication = 26833
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableApplication = 26836
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableApplication = 26839
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableApplication = 26842
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableApplication = 26844
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState                                            OpcuaNodeIdServicesVariableApplication = 26845
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId                                            OpcuaNodeIdServicesVariableApplication = 26846
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime                                         OpcuaNodeIdServicesVariableApplication = 26847
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency                                        OpcuaNodeIdServicesVariableApplication = 26848
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled                                                                                                           OpcuaNodeIdServicesVariableApplication = 26849
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri                                                                                                    OpcuaNodeIdServicesVariableApplication = 26850
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri                                                                                                        OpcuaNodeIdServicesVariableApplication = 26851
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType                                                                                                   OpcuaNodeIdServicesVariableApplication = 26852
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ServerCapabilities                                                                                                OpcuaNodeIdServicesVariableApplication = 26853
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_SupportedPrivateKeyFormats                                                                                        OpcuaNodeIdServicesVariableApplication = 26854
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MaxTrustListSize                                                                                                  OpcuaNodeIdServicesVariableApplication = 26855
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MulticastDnsEnabled                                                                                               OpcuaNodeIdServicesVariableApplication = 26856
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_HasSecureElement                                                                                                  OpcuaNodeIdServicesVariableApplication = 26857
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_InputArguments                                                                                  OpcuaNodeIdServicesVariableApplication = 26859
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_OutputArguments                                                                                 OpcuaNodeIdServicesVariableApplication = 26860
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_InputArguments                                                                               OpcuaNodeIdServicesVariableApplication = 26864
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_OutputArguments                                                                              OpcuaNodeIdServicesVariableApplication = 26865
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetRejectedList_OutputArguments                                                                                   OpcuaNodeIdServicesVariableApplication = 26867
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout                                               OpcuaNodeIdServicesVariableApplication = 32343
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout                                                     OpcuaNodeIdServicesVariableApplication = 32344
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout                                                 OpcuaNodeIdServicesVariableApplication = 32345
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_InputArguments                                                                                    OpcuaNodeIdServicesVariableApplication = 32347
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_OutputArguments                                                                                   OpcuaNodeIdServicesVariableApplication = 32348
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_StartTime                                                                                  OpcuaNodeIdServicesVariableApplication = 32350
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_EndTime                                                                                    OpcuaNodeIdServicesVariableApplication = 32351
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Result                                                                                     OpcuaNodeIdServicesVariableApplication = 32352
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists                                                                         OpcuaNodeIdServicesVariableApplication = 32353
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups                                                                  OpcuaNodeIdServicesVariableApplication = 32354
	OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Errors                                                                                     OpcuaNodeIdServicesVariableApplication = 32355
)

var OpcuaNodeIdServicesVariableApplicationValues []OpcuaNodeIdServicesVariableApplication

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableApplicationValues = []OpcuaNodeIdServicesVariableApplication{
		OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ServerCapabilities,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_SupportedPrivateKeyFormats,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MaxTrustListSize,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MulticastDnsEnabled,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_HasSecureElement,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_InputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_OutputArguments,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_StartTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_EndTime,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Result,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups,
		OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Errors,
	}
}

func OpcuaNodeIdServicesVariableApplicationByValue(value int32) (enum OpcuaNodeIdServicesVariableApplication, ok bool) {
	switch value {
	case 25735:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case 25736:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case 25737:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case 25738:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case 25739:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case 25740:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength, true
	case 25741:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime, true
	case 25743:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case 25744:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case 25746:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case 25748:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case 25749:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case 25751:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case 25753:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case 25754:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case 25756:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case 25757:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case 25758:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case 25759:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions, true
	case 25761:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case 25762:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 25764:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 25765:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 25767:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case 25769:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case 25770:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case 25773:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments, true
	case 25775:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case 25776:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case 25777:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case 25778:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case 25779:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case 25780:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case 25781:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case 25782:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case 25783:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case 25784:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case 25785:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case 25786:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case 25787:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case 25788:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case 25789:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case 25790:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case 25791:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case 25792:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case 25793:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case 25794:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case 25795:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 25796:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 25797:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 25798:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case 25799:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case 25800:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case 25801:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 25802:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case 25803:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 25804:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case 25805:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 25806:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case 25810:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case 25811:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case 25812:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case 25813:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case 25814:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case 25815:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 25816:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case 25817:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 25818:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case 25819:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case 25820:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case 25821:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case 25822:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case 25823:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case 25824:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 25825:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 25826:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 25827:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 25828:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 25830:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 25832:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case 25833:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case 25834:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case 25835:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case 25836:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case 25837:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 25838:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 25839:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 25840:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case 25841:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case 25842:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case 25843:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case 25844:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case 25845:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case 25846:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case 25847:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 25848:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 25849:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 25850:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case 25851:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case 25852:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case 25853:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case 25854:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case 25855:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case 25856:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 25857:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 25858:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 25859:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 25860:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 25862:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 25863:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 25864:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 25865:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 25866:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 25867:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 25868:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 25869:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 25870:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 25871:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 25872:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 25873:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 25874:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 25875:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 25877:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 25879:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 25882:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 25885:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 25886:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case 25887:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case 25888:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case 25889:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case 25890:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case 25891:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 25892:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case 25893:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case 25894:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case 25895:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case 25896:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case 25897:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 25898:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 25899:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 25900:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case 25901:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case 25902:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case 25903:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case 25904:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case 25906:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case 25907:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case 25908:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case 25909:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case 25910:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 25911:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 25912:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 25913:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case 25914:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case 25915:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case 25916:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 25920:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments, true
	case 25923:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 25926:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 25929:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 25932:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments, true
	case 25934:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 25935:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case 25936:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case 25937:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case 25938:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case 25939:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case 25941:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case 25942:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case 25943:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case 25944:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case 25945:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case 25946:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case 25947:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case 25948:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case 25949:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case 25950:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case 25951:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case 25952:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 25953:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 25954:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case 25955:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case 25956:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case 25957:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case 25958:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case 25959:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case 25960:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case 25961:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 25962:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 25963:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 25964:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 25965:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 25966:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case 25967:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 25968:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case 25969:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 25970:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case 25971:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 25972:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case 25976:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 25977:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case 25978:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case 25979:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case 25980:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case 25981:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 25982:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 25983:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 25984:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 25985:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 25986:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case 25987:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 25988:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 25989:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 25990:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 25991:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 25992:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 25993:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 25994:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 25996:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 25998:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 25999:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case 26000:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case 26001:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case 26002:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case 26003:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 26004:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 26005:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 26006:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 26007:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 26008:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case 26009:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case 26010:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 26011:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 26012:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 26013:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 26014:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 26015:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 26016:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 26017:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 26018:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case 26019:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 26020:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 26021:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 26022:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 26023:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 26024:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 26025:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 26026:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 26028:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 26029:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 26030:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 26031:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 26032:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 26033:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 26034:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 26035:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 26036:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 26037:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 26038:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 26039:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 26040:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 26041:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 26043:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 26045:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 26048:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 26051:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 26052:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 26053:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 26054:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case 26055:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case 26056:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 26057:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 26058:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 26059:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case 26060:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case 26061:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case 26062:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case 26063:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 26064:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 26065:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 26066:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 26067:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 26068:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case 26069:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case 26070:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 26072:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case 26073:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case 26074:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case 26075:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case 26076:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 26077:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 26078:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 26079:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 26080:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 26081:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case 26082:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 26086:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 26089:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 26092:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 26095:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 26098:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 26100:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 26101:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case 26102:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case 26103:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case 26104:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case 26107:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case 26108:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case 26109:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case 26110:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case 26111:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case 26112:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength, true
	case 26113:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime, true
	case 26115:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case 26116:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case 26118:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case 26120:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case 26121:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case 26123:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case 26125:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case 26126:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case 26128:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case 26129:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case 26130:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case 26131:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions, true
	case 26133:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case 26134:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 26136:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 26137:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 26139:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case 26141:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case 26142:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case 26145:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments, true
	case 26147:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case 26148:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case 26149:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case 26150:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case 26151:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case 26152:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case 26153:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case 26154:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case 26155:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case 26156:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case 26157:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case 26158:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case 26159:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case 26160:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case 26161:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case 26162:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case 26163:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case 26164:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case 26165:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case 26166:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case 26167:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 26168:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 26169:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 26170:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case 26171:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case 26172:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case 26173:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 26174:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case 26175:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 26176:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case 26177:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 26178:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case 26182:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case 26183:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case 26184:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case 26185:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case 26186:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case 26187:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 26188:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case 26189:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 26190:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case 26191:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case 26192:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case 26193:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case 26194:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case 26195:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case 26196:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 26197:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 26198:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 26199:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 26200:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 26202:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 26204:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case 26205:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case 26206:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case 26207:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case 26208:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case 26209:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 26210:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 26211:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 26212:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case 26213:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case 26214:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case 26215:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case 26216:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case 26217:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case 26218:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case 26219:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 26220:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 26221:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 26222:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case 26223:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case 26224:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case 26225:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case 26226:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case 26227:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case 26228:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 26229:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 26230:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 26231:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 26232:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 26234:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 26235:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 26236:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 26237:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 26238:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 26239:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 26240:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 26241:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 26242:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 26243:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 26244:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 26245:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 26246:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 26247:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 26249:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 26251:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 26254:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 26257:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 26258:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case 26259:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case 26260:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case 26261:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case 26262:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case 26263:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 26264:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case 26265:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case 26266:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case 26267:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case 26268:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case 26269:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 26270:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 26271:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 26272:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case 26273:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case 26274:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case 26275:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case 26276:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case 26278:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case 26279:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case 26280:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case 26281:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case 26282:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 26283:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 26284:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 26285:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case 26286:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case 26287:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case 26288:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 26292:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments, true
	case 26295:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 26298:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 26301:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 26304:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments, true
	case 26306:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 26307:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case 26308:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case 26309:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case 26310:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case 26311:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case 26313:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case 26314:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case 26315:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case 26316:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case 26317:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case 26318:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case 26319:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case 26320:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case 26321:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case 26322:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case 26323:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case 26324:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 26325:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 26326:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case 26327:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case 26328:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case 26329:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case 26330:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case 26331:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case 26332:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case 26333:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 26334:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 26335:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 26336:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 26337:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 26338:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case 26339:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 26340:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case 26341:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 26342:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case 26343:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 26344:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case 26348:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 26349:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case 26350:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case 26351:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case 26352:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case 26353:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 26354:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 26355:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 26356:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 26357:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 26358:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case 26359:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 26360:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 26361:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 26362:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 26363:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 26364:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 26365:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 26366:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 26368:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 26370:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 26371:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case 26372:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case 26373:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case 26374:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case 26375:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 26376:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 26377:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 26378:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 26379:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 26380:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case 26381:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case 26382:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 26383:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 26384:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 26385:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 26386:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 26387:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 26388:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 26389:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 26390:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case 26391:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 26392:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 26393:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 26394:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 26395:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 26396:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 26397:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 26398:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 26400:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 26401:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 26402:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 26403:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 26404:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 26405:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 26406:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 26407:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 26408:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 26409:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 26410:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 26411:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 26412:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 26413:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 26415:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 26417:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 26420:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 26423:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 26424:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 26425:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 26426:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case 26427:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case 26428:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 26429:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 26430:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 26431:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case 26432:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case 26433:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case 26434:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case 26435:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 26436:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 26437:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 26438:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 26439:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 26440:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case 26441:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case 26442:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 26444:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case 26445:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case 26446:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case 26447:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case 26448:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 26449:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 26450:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 26451:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 26452:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 26453:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case 26454:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 26458:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 26461:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 26464:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 26467:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 26470:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 26472:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 26473:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case 26474:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case 26475:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case 26476:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case 26479:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case 26480:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case 26481:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case 26482:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case 26483:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case 26484:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength, true
	case 26485:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime, true
	case 26487:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case 26488:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case 26490:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case 26492:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case 26493:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case 26495:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case 26497:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case 26498:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case 26500:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case 26501:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case 26502:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case 26503:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions, true
	case 26505:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case 26506:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 26508:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 26509:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 26511:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case 26513:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case 26514:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case 26517:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments, true
	case 26519:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case 26520:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case 26521:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case 26522:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case 26523:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case 26524:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case 26525:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case 26526:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case 26527:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case 26528:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case 26529:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case 26530:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case 26531:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case 26532:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case 26533:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case 26534:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case 26535:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case 26536:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case 26537:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case 26538:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case 26539:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 26540:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 26541:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 26542:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case 26543:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case 26544:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case 26545:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 26546:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case 26547:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 26548:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case 26549:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 26550:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case 26554:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case 26555:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case 26556:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case 26557:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case 26558:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case 26559:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 26560:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case 26561:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 26562:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case 26563:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case 26564:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case 26565:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case 26566:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case 26567:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case 26568:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 26569:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 26570:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 26571:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 26572:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 26574:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 26576:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case 26577:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case 26578:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case 26579:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case 26580:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case 26581:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 26582:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 26583:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 26584:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case 26585:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case 26586:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case 26587:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case 26588:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case 26589:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case 26590:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case 26591:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 26592:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 26593:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 26594:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case 26595:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case 26596:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case 26597:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case 26598:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case 26599:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case 26600:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 26601:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 26602:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 26603:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 26604:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 26606:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 26607:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 26608:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 26609:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 26610:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 26611:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 26612:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 26613:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 26614:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 26615:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 26616:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 26617:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 26618:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 26619:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 26621:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 26623:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 26626:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 26629:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 26630:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case 26631:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case 26632:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case 26633:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case 26634:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case 26635:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 26636:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case 26637:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case 26638:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case 26639:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case 26640:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case 26641:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 26642:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 26643:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 26644:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case 26645:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case 26646:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case 26647:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case 26648:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case 26650:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case 26651:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case 26652:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case 26653:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case 26654:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 26655:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 26656:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 26657:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case 26658:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case 26659:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case 26660:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 26664:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments, true
	case 26667:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 26670:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 26673:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 26676:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments, true
	case 26678:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 26679:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case 26680:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case 26681:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case 26682:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case 26683:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case 26685:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case 26686:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case 26687:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case 26688:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case 26689:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case 26690:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case 26691:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case 26692:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case 26693:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case 26694:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case 26695:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case 26696:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 26697:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 26698:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case 26699:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case 26700:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case 26701:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case 26702:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case 26703:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case 26704:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case 26705:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 26706:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 26707:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 26708:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 26709:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 26710:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case 26711:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 26712:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case 26713:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 26714:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case 26715:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 26716:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case 26720:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 26721:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case 26722:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case 26723:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case 26724:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case 26725:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 26726:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 26727:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 26728:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 26729:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 26730:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case 26731:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 26732:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 26733:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 26734:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 26735:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 26736:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 26737:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 26738:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 26740:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 26742:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 26743:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case 26744:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case 26745:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case 26746:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case 26747:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 26748:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 26749:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 26750:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 26751:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 26752:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case 26753:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case 26754:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 26755:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 26756:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 26757:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 26758:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 26759:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 26760:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 26761:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 26762:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case 26763:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 26764:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 26765:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 26766:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 26767:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 26768:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 26769:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 26770:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 26772:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 26773:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 26774:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 26775:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 26776:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 26777:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 26778:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 26779:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 26780:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 26781:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 26782:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 26783:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 26784:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 26785:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 26787:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 26789:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 26792:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 26795:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 26796:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 26797:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 26798:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case 26799:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case 26800:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 26801:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 26802:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 26803:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case 26804:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case 26805:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case 26806:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case 26807:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 26808:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 26809:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 26810:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 26811:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 26812:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case 26813:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case 26814:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 26816:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case 26817:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case 26818:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case 26819:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case 26820:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 26821:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 26822:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 26823:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 26824:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 26825:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case 26826:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 26830:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 26833:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 26836:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 26839:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 26842:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 26844:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 26845:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case 26846:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case 26847:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case 26848:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case 26849:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled, true
	case 26850:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri, true
	case 26851:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri, true
	case 26852:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType, true
	case 26853:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ServerCapabilities, true
	case 26854:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_SupportedPrivateKeyFormats, true
	case 26855:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MaxTrustListSize, true
	case 26856:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MulticastDnsEnabled, true
	case 26857:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_HasSecureElement, true
	case 26859:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_InputArguments, true
	case 26860:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_OutputArguments, true
	case 26864:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_InputArguments, true
	case 26865:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_OutputArguments, true
	case 26867:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetRejectedList_OutputArguments, true
	case 32343:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout, true
	case 32344:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout, true
	case 32345:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout, true
	case 32347:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_InputArguments, true
	case 32348:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_OutputArguments, true
	case 32350:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_StartTime, true
	case 32351:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_EndTime, true
	case 32352:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Result, true
	case 32353:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists, true
	case 32354:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups, true
	case 32355:
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Errors, true
	case 7597:
		return OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableApplicationByName(value string) (enum OpcuaNodeIdServicesVariableApplication, ok bool) {
	switch value {
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ApplicationConfigurationType_Enabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_Enabled, true
	case "ApplicationConfigurationType_ApplicationUri":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationUri, true
	case "ApplicationConfigurationType_ProductUri":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ProductUri, true
	case "ApplicationConfigurationType_ApplicationType":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ApplicationType, true
	case "ApplicationConfigurationType_ServerCapabilities":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_ServerCapabilities, true
	case "ApplicationConfigurationType_SupportedPrivateKeyFormats":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_SupportedPrivateKeyFormats, true
	case "ApplicationConfigurationType_MaxTrustListSize":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MaxTrustListSize, true
	case "ApplicationConfigurationType_MulticastDnsEnabled":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_MulticastDnsEnabled, true
	case "ApplicationConfigurationType_HasSecureElement":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_HasSecureElement, true
	case "ApplicationConfigurationType_UpdateCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_InputArguments, true
	case "ApplicationConfigurationType_UpdateCertificate_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_UpdateCertificate_OutputArguments, true
	case "ApplicationConfigurationType_CreateSigningRequest_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_InputArguments, true
	case "ApplicationConfigurationType_CreateSigningRequest_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CreateSigningRequest_OutputArguments, true
	case "ApplicationConfigurationType_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetRejectedList_OutputArguments, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout, true
	case "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout, true
	case "ApplicationConfigurationType_GetCertificates_InputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_InputArguments, true
	case "ApplicationConfigurationType_GetCertificates_OutputArguments":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_GetCertificates_OutputArguments, true
	case "ApplicationConfigurationType_TransactionDiagnostics_StartTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_StartTime, true
	case "ApplicationConfigurationType_TransactionDiagnostics_EndTime":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_EndTime, true
	case "ApplicationConfigurationType_TransactionDiagnostics_Result":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Result, true
	case "ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists, true
	case "ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups, true
	case "ApplicationConfigurationType_TransactionDiagnostics_Errors":
		return OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_TransactionDiagnostics_Errors, true
	case "ApplicationType_EnumStrings":
		return OpcuaNodeIdServicesVariableApplication_ApplicationType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableApplicationKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableApplicationValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableApplication(structType any) OpcuaNodeIdServicesVariableApplication {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableApplication {
		if sOpcuaNodeIdServicesVariableApplication, ok := typ.(OpcuaNodeIdServicesVariableApplication); ok {
			return sOpcuaNodeIdServicesVariableApplication
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableApplication) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableApplication) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableApplicationParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableApplication, error) {
	return OpcuaNodeIdServicesVariableApplicationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableApplicationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableApplication, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableApplication", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableApplication")
	}
	if enum, ok := OpcuaNodeIdServicesVariableApplicationByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableApplication")
		return OpcuaNodeIdServicesVariableApplication(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableApplication) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableApplication) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableApplication", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableApplication) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency:
		return "ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency:
		return "ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableApplication_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState:
		return "ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableApplicati