/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAcknowledgeable is an enum
type OpcuaNodeIdServicesVariableAcknowledgeable int32

type IOpcuaNodeIdServicesVariableAcknowledgeable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventId                                OpcuaNodeIdServicesVariableAcknowledgeable = 5113
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventType                              OpcuaNodeIdServicesVariableAcknowledgeable = 5114
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceNode                             OpcuaNodeIdServicesVariableAcknowledgeable = 5115
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceName                             OpcuaNodeIdServicesVariableAcknowledgeable = 5116
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Time                                   OpcuaNodeIdServicesVariableAcknowledgeable = 5117
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ReceiveTime                            OpcuaNodeIdServicesVariableAcknowledgeable = 5118
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LocalTime                              OpcuaNodeIdServicesVariableAcknowledgeable = 5119
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Message                                OpcuaNodeIdServicesVariableAcknowledgeable = 5120
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Severity                               OpcuaNodeIdServicesVariableAcknowledgeable = 5121
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Retain                                 OpcuaNodeIdServicesVariableAcknowledgeable = 5122
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh_InputArguments        OpcuaNodeIdServicesVariableAcknowledgeable = 5124
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionName                          OpcuaNodeIdServicesVariableAcknowledgeable = 9071
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_BranchId                               OpcuaNodeIdServicesVariableAcknowledgeable = 9072
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState                           OpcuaNodeIdServicesVariableAcknowledgeable = 9073
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id                        OpcuaNodeIdServicesVariableAcknowledgeable = 9074
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name                      OpcuaNodeIdServicesVariableAcknowledgeable = 9075
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number                    OpcuaNodeIdServicesVariableAcknowledgeable = 9076
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName      OpcuaNodeIdServicesVariableAcknowledgeable = 9077
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime            OpcuaNodeIdServicesVariableAcknowledgeable = 9078
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime   OpcuaNodeIdServicesVariableAcknowledgeable = 9079
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState                 OpcuaNodeIdServicesVariableAcknowledgeable = 9080
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState                OpcuaNodeIdServicesVariableAcknowledgeable = 9081
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality                                OpcuaNodeIdServicesVariableAcknowledgeable = 9082
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality_SourceTimestamp                OpcuaNodeIdServicesVariableAcknowledgeable = 9083
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity                           OpcuaNodeIdServicesVariableAcknowledgeable = 9084
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity_SourceTimestamp           OpcuaNodeIdServicesVariableAcknowledgeable = 9085
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment                                OpcuaNodeIdServicesVariableAcknowledgeable = 9086
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment_SourceTimestamp                OpcuaNodeIdServicesVariableAcknowledgeable = 9087
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ClientUserId                           OpcuaNodeIdServicesVariableAcknowledgeable = 9088
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AddComment_InputArguments              OpcuaNodeIdServicesVariableAcknowledgeable = 9092
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState                             OpcuaNodeIdServicesVariableAcknowledgeable = 9093
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id                          OpcuaNodeIdServicesVariableAcknowledgeable = 9094
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name                        OpcuaNodeIdServicesVariableAcknowledgeable = 9095
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number                      OpcuaNodeIdServicesVariableAcknowledgeable = 9096
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName        OpcuaNodeIdServicesVariableAcknowledgeable = 9097
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime              OpcuaNodeIdServicesVariableAcknowledgeable = 9098
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime     OpcuaNodeIdServicesVariableAcknowledgeable = 9099
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState                   OpcuaNodeIdServicesVariableAcknowledgeable = 9100
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState                  OpcuaNodeIdServicesVariableAcknowledgeable = 9101
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState                         OpcuaNodeIdServicesVariableAcknowledgeable = 9102
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id                      OpcuaNodeIdServicesVariableAcknowledgeable = 9103
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name                    OpcuaNodeIdServicesVariableAcknowledgeable = 9104
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number                  OpcuaNodeIdServicesVariableAcknowledgeable = 9105
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName    OpcuaNodeIdServicesVariableAcknowledgeable = 9106
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime          OpcuaNodeIdServicesVariableAcknowledgeable = 9107
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime OpcuaNodeIdServicesVariableAcknowledgeable = 9108
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState               OpcuaNodeIdServicesVariableAcknowledgeable = 9109
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState              OpcuaNodeIdServicesVariableAcknowledgeable = 9110
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments             OpcuaNodeIdServicesVariableAcknowledgeable = 9112
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments                 OpcuaNodeIdServicesVariableAcknowledgeable = 9114
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassId                       OpcuaNodeIdServicesVariableAcknowledgeable = 11116
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassName                     OpcuaNodeIdServicesVariableAcknowledgeable = 11117
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh2_InputArguments       OpcuaNodeIdServicesVariableAcknowledgeable = 12919
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassId                    OpcuaNodeIdServicesVariableAcknowledgeable = 16367
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassName                  OpcuaNodeIdServicesVariableAcknowledgeable = 16368
	OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SupportsFilteredRetain                 OpcuaNodeIdServicesVariableAcknowledgeable = 32062
)

var OpcuaNodeIdServicesVariableAcknowledgeableValues []OpcuaNodeIdServicesVariableAcknowledgeable

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAcknowledgeableValues = []OpcuaNodeIdServicesVariableAcknowledgeable{
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventId,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventType,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceNode,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Time,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ReceiveTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LocalTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Message,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Severity,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Retain,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_BranchId,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ClientUserId,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassId,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableAcknowledgeableByValue(value int32) (enum OpcuaNodeIdServicesVariableAcknowledgeable, ok bool) {
	switch value {
	case 11116:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassId, true
	case 11117:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassName, true
	case 12919:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh2_InputArguments, true
	case 16367:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassId, true
	case 16368:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassName, true
	case 32062:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SupportsFilteredRetain, true
	case 5113:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventId, true
	case 5114:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventType, true
	case 5115:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceNode, true
	case 5116:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceName, true
	case 5117:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Time, true
	case 5118:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ReceiveTime, true
	case 5119:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LocalTime, true
	case 5120:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Message, true
	case 5121:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Severity, true
	case 5122:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Retain, true
	case 5124:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh_InputArguments, true
	case 9071:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionName, true
	case 9072:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_BranchId, true
	case 9073:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState, true
	case 9074:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id, true
	case 9075:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name, true
	case 9076:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number, true
	case 9077:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName, true
	case 9078:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime, true
	case 9079:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime, true
	case 9080:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState, true
	case 9081:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState, true
	case 9082:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality, true
	case 9083:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality_SourceTimestamp, true
	case 9084:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity, true
	case 9085:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity_SourceTimestamp, true
	case 9086:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment, true
	case 9087:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment_SourceTimestamp, true
	case 9088:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ClientUserId, true
	case 9092:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AddComment_InputArguments, true
	case 9093:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState, true
	case 9094:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id, true
	case 9095:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name, true
	case 9096:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number, true
	case 9097:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName, true
	case 9098:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime, true
	case 9099:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime, true
	case 9100:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState, true
	case 9101:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState, true
	case 9102:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState, true
	case 9103:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id, true
	case 9104:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name, true
	case 9105:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number, true
	case 9106:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName, true
	case 9107:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime, true
	case 9108:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime, true
	case 9109:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState, true
	case 9110:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState, true
	case 9112:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments, true
	case 9114:
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAcknowledgeableByName(value string) (enum OpcuaNodeIdServicesVariableAcknowledgeable, ok bool) {
	switch value {
	case "AcknowledgeableConditionType_ConditionClassId":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassId, true
	case "AcknowledgeableConditionType_ConditionClassName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassName, true
	case "AcknowledgeableConditionType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh2_InputArguments, true
	case "AcknowledgeableConditionType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassId, true
	case "AcknowledgeableConditionType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassName, true
	case "AcknowledgeableConditionType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SupportsFilteredRetain, true
	case "AcknowledgeableConditionType_EventId":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventId, true
	case "AcknowledgeableConditionType_EventType":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventType, true
	case "AcknowledgeableConditionType_SourceNode":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceNode, true
	case "AcknowledgeableConditionType_SourceName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceName, true
	case "AcknowledgeableConditionType_Time":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Time, true
	case "AcknowledgeableConditionType_ReceiveTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ReceiveTime, true
	case "AcknowledgeableConditionType_LocalTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LocalTime, true
	case "AcknowledgeableConditionType_Message":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Message, true
	case "AcknowledgeableConditionType_Severity":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Severity, true
	case "AcknowledgeableConditionType_Retain":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Retain, true
	case "AcknowledgeableConditionType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh_InputArguments, true
	case "AcknowledgeableConditionType_ConditionName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionName, true
	case "AcknowledgeableConditionType_BranchId":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_BranchId, true
	case "AcknowledgeableConditionType_EnabledState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState, true
	case "AcknowledgeableConditionType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id, true
	case "AcknowledgeableConditionType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name, true
	case "AcknowledgeableConditionType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number, true
	case "AcknowledgeableConditionType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime, true
	case "AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState, true
	case "AcknowledgeableConditionType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState, true
	case "AcknowledgeableConditionType_Quality":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality, true
	case "AcknowledgeableConditionType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality_SourceTimestamp, true
	case "AcknowledgeableConditionType_LastSeverity":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity, true
	case "AcknowledgeableConditionType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity_SourceTimestamp, true
	case "AcknowledgeableConditionType_Comment":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment, true
	case "AcknowledgeableConditionType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment_SourceTimestamp, true
	case "AcknowledgeableConditionType_ClientUserId":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ClientUserId, true
	case "AcknowledgeableConditionType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AddComment_InputArguments, true
	case "AcknowledgeableConditionType_AckedState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState, true
	case "AcknowledgeableConditionType_AckedState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id, true
	case "AcknowledgeableConditionType_AckedState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name, true
	case "AcknowledgeableConditionType_AckedState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number, true
	case "AcknowledgeableConditionType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime, true
	case "AcknowledgeableConditionType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState, true
	case "AcknowledgeableConditionType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState, true
	case "AcknowledgeableConditionType_ConfirmedState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState, true
	case "AcknowledgeableConditionType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id, true
	case "AcknowledgeableConditionType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name, true
	case "AcknowledgeableConditionType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number, true
	case "AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName, true
	case "AcknowledgeableConditionType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime, true
	case "AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime, true
	case "AcknowledgeableConditionType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState, true
	case "AcknowledgeableConditionType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState, true
	case "AcknowledgeableConditionType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments, true
	case "AcknowledgeableConditionType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAcknowledgeableKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAcknowledgeableValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAcknowledgeable(structType any) OpcuaNodeIdServicesVariableAcknowledgeable {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAcknowledgeable {
		if sOpcuaNodeIdServicesVariableAcknowledgeable, ok := typ.(OpcuaNodeIdServicesVariableAcknowledgeable); ok {
			return sOpcuaNodeIdServicesVariableAcknowledgeable
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAcknowledgeable) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAcknowledgeable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAcknowledgeableParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAcknowledgeable, error) {
	return OpcuaNodeIdServicesVariableAcknowledgeableParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAcknowledgeableParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAcknowledgeable, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAcknowledgeable", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAcknowledgeable")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAcknowledgeableByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAcknowledgeable")
		return OpcuaNodeIdServicesVariableAcknowledgeable(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAcknowledgeable", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAcknowledgeable) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassId:
		return "AcknowledgeableConditionType_ConditionClassId"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionClassName:
		return "AcknowledgeableConditionType_ConditionClassName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh2_InputArguments:
		return "AcknowledgeableConditionType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassId:
		return "AcknowledgeableConditionType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionSubClassName:
		return "AcknowledgeableConditionType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SupportsFilteredRetain:
		return "AcknowledgeableConditionType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventId:
		return "AcknowledgeableConditionType_EventId"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EventType:
		return "AcknowledgeableConditionType_EventType"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceNode:
		return "AcknowledgeableConditionType_SourceNode"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_SourceName:
		return "AcknowledgeableConditionType_SourceName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Time:
		return "AcknowledgeableConditionType_Time"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ReceiveTime:
		return "AcknowledgeableConditionType_ReceiveTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LocalTime:
		return "AcknowledgeableConditionType_LocalTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Message:
		return "AcknowledgeableConditionType_Message"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Severity:
		return "AcknowledgeableConditionType_Severity"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Retain:
		return "AcknowledgeableConditionType_Retain"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionRefresh_InputArguments:
		return "AcknowledgeableConditionType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConditionName:
		return "AcknowledgeableConditionType_ConditionName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_BranchId:
		return "AcknowledgeableConditionType_BranchId"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState:
		return "AcknowledgeableConditionType_EnabledState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Id:
		return "AcknowledgeableConditionType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Name:
		return "AcknowledgeableConditionType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_Number:
		return "AcknowledgeableConditionType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TransitionTime:
		return "AcknowledgeableConditionType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_TrueState:
		return "AcknowledgeableConditionType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_EnabledState_FalseState:
		return "AcknowledgeableConditionType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality:
		return "AcknowledgeableConditionType_Quality"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Quality_SourceTimestamp:
		return "AcknowledgeableConditionType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity:
		return "AcknowledgeableConditionType_LastSeverity"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_LastSeverity_SourceTimestamp:
		return "AcknowledgeableConditionType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment:
		return "AcknowledgeableConditionType_Comment"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Comment_SourceTimestamp:
		return "AcknowledgeableConditionType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ClientUserId:
		return "AcknowledgeableConditionType_ClientUserId"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AddComment_InputArguments:
		return "AcknowledgeableConditionType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState:
		return "AcknowledgeableConditionType_AckedState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Id:
		return "AcknowledgeableConditionType_AckedState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Name:
		return "AcknowledgeableConditionType_AckedState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_Number:
		return "AcknowledgeableConditionType_AckedState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TransitionTime:
		return "AcknowledgeableConditionType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_TrueState:
		return "AcknowledgeableConditionType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_AckedState_FalseState:
		return "AcknowledgeableConditionType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState:
		return "AcknowledgeableConditionType_ConfirmedState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Id:
		return "AcknowledgeableConditionType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Name:
		return "AcknowledgeableConditionType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_Number:
		return "AcknowledgeableConditionType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName:
		return "AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TransitionTime:
		return "AcknowledgeableConditionType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime:
		return "AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_TrueState:
		return "AcknowledgeableConditionType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_ConfirmedState_FalseState:
		return "AcknowledgeableConditionType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Acknowledge_InputArguments:
		return "AcknowledgeableConditionType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableAcknowledgeable_AcknowledgeableConditionType_Confirm_InputArguments:
		return "AcknowledgeableConditionType_Confirm_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAcknowledgeable) String() string {
	return e.PLC4XEnumName()
}
