/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesMethod is an enum
type OpcuaNodeIdServicesMethod int32

type IOpcuaNodeIdServicesMethod interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start                                                                                                                 OpcuaNodeIdServicesMethod = 2426
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend                                                                                                               OpcuaNodeIdServicesMethod = 2427
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume                                                                                                                OpcuaNodeIdServicesMethod = 2428
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt                                                                                                                  OpcuaNodeIdServicesMethod = 2429
	OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset                                                                                                                 OpcuaNodeIdServicesMethod = 2430
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve                                                                                                              OpcuaNodeIdServicesMethod = 2947
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve                                                                                                         OpcuaNodeIdServicesMethod = 2948
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve                                                                                                           OpcuaNodeIdServicesMethod = 2949
	OpcuaNodeIdServicesMethod_AddCommentMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 3863
	OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh                                                                                                                OpcuaNodeIdServicesMethod = 3875
	OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh                                                                                                          OpcuaNodeIdServicesMethod = 4198
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh                                                                                                 OpcuaNodeIdServicesMethod = 5123
	OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh                                                                                                           OpcuaNodeIdServicesMethod = 5550
	OpcuaNodeIdServicesMethod_TimedShelveMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 6102
	OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh                                                                                                               OpcuaNodeIdServicesMethod = 6126
	OpcuaNodeIdServicesMethod_ConditionRefreshMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 9007
	OpcuaNodeIdServicesMethod_ConditionType_Enable                                                                                                                          OpcuaNodeIdServicesMethod = 9027
	OpcuaNodeIdServicesMethod_ConditionType_Disable                                                                                                                         OpcuaNodeIdServicesMethod = 9028
	OpcuaNodeIdServicesMethod_ConditionType_AddComment                                                                                                                      OpcuaNodeIdServicesMethod = 9029
	OpcuaNodeIdServicesMethod_DialogResponseMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 9031
	OpcuaNodeIdServicesMethod_DialogConditionType_Enable                                                                                                                    OpcuaNodeIdServicesMethod = 9051
	OpcuaNodeIdServicesMethod_DialogConditionType_Disable                                                                                                                   OpcuaNodeIdServicesMethod = 9052
	OpcuaNodeIdServicesMethod_DialogConditionType_AddComment                                                                                                                OpcuaNodeIdServicesMethod = 9053
	OpcuaNodeIdServicesMethod_DialogConditionType_Respond                                                                                                                   OpcuaNodeIdServicesMethod = 9069
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Enable                                                                                                           OpcuaNodeIdServicesMethod = 9089
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Disable                                                                                                          OpcuaNodeIdServicesMethod = 9090
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_AddComment                                                                                                       OpcuaNodeIdServicesMethod = 9091
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge                                                                                                      OpcuaNodeIdServicesMethod = 9111
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm                                                                                                          OpcuaNodeIdServicesMethod = 9113
	OpcuaNodeIdServicesMethod_AlarmConditionType_Enable                                                                                                                     OpcuaNodeIdServicesMethod = 9134
	OpcuaNodeIdServicesMethod_AlarmConditionType_Disable                                                                                                                    OpcuaNodeIdServicesMethod = 9135
	OpcuaNodeIdServicesMethod_AlarmConditionType_AddComment                                                                                                                 OpcuaNodeIdServicesMethod = 9136
	OpcuaNodeIdServicesMethod_AlarmConditionType_Acknowledge                                                                                                                OpcuaNodeIdServicesMethod = 9156
	OpcuaNodeIdServicesMethod_AlarmConditionType_Confirm                                                                                                                    OpcuaNodeIdServicesMethod = 9158
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve                                                                                                     OpcuaNodeIdServicesMethod = 9211
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve                                                                                                OpcuaNodeIdServicesMethod = 9212
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve                                                                                                  OpcuaNodeIdServicesMethod = 9213
	OpcuaNodeIdServicesMethod_LimitAlarmType_Enable                                                                                                                         OpcuaNodeIdServicesMethod = 9235
	OpcuaNodeIdServicesMethod_LimitAlarmType_Disable                                                                                                                        OpcuaNodeIdServicesMethod = 9236
	OpcuaNodeIdServicesMethod_LimitAlarmType_AddComment                                                                                                                     OpcuaNodeIdServicesMethod = 9237
	OpcuaNodeIdServicesMethod_LimitAlarmType_Acknowledge                                                                                                                    OpcuaNodeIdServicesMethod = 9257
	OpcuaNodeIdServicesMethod_LimitAlarmType_Confirm                                                                                                                        OpcuaNodeIdServicesMethod = 9259
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve                                                                                                         OpcuaNodeIdServicesMethod = 9312
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve                                                                                                    OpcuaNodeIdServicesMethod = 9313
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve                                                                                                      OpcuaNodeIdServicesMethod = 9314
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Enable                                                                                                                OpcuaNodeIdServicesMethod = 9370
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Disable                                                                                                               OpcuaNodeIdServicesMethod = 9371
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_AddComment                                                                                                            OpcuaNodeIdServicesMethod = 9372
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh                                                                                                      OpcuaNodeIdServicesMethod = 9374
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Acknowledge                                                                                                           OpcuaNodeIdServicesMethod = 9394
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Confirm                                                                                                               OpcuaNodeIdServicesMethod = 9396
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve                                                                                                OpcuaNodeIdServicesMethod = 9449
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve                                                                                           OpcuaNodeIdServicesMethod = 9450
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve                                                                                             OpcuaNodeIdServicesMethod = 9451
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Enable                                                                                                                OpcuaNodeIdServicesMethod = 9511
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Disable                                                                                                               OpcuaNodeIdServicesMethod = 9512
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_AddComment                                                                                                            OpcuaNodeIdServicesMethod = 9513
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh                                                                                                      OpcuaNodeIdServicesMethod = 9515
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Acknowledge                                                                                                           OpcuaNodeIdServicesMethod = 9535
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Confirm                                                                                                               OpcuaNodeIdServicesMethod = 9537
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve                                                                                                OpcuaNodeIdServicesMethod = 9590
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve                                                                                           OpcuaNodeIdServicesMethod = 9591
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve                                                                                             OpcuaNodeIdServicesMethod = 9592
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Enable                                                                                                         OpcuaNodeIdServicesMethod = 9652
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Disable                                                                                                        OpcuaNodeIdServicesMethod = 9653
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_AddComment                                                                                                     OpcuaNodeIdServicesMethod = 9654
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh                                                                                               OpcuaNodeIdServicesMethod = 9656
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Acknowledge                                                                                                    OpcuaNodeIdServicesMethod = 9676
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Confirm                                                                                                        OpcuaNodeIdServicesMethod = 9678
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve                                                                                         OpcuaNodeIdServicesMethod = 9731
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve                                                                                    OpcuaNodeIdServicesMethod = 9732
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve                                                                                      OpcuaNodeIdServicesMethod = 9733
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Enable                                                                                                            OpcuaNodeIdServicesMethod = 9793
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Disable                                                                                                           OpcuaNodeIdServicesMethod = 9794
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_AddComment                                                                                                        OpcuaNodeIdServicesMethod = 9795
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh                                                                                                  OpcuaNodeIdServicesMethod = 9797
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Acknowledge                                                                                                       OpcuaNodeIdServicesMethod = 9817
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Confirm                                                                                                           OpcuaNodeIdServicesMethod = 9819
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve                                                                                            OpcuaNodeIdServicesMethod = 9872
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve                                                                                       OpcuaNodeIdServicesMethod = 9873
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve                                                                                         OpcuaNodeIdServicesMethod = 9874
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Enable                                                                                                             OpcuaNodeIdServicesMethod = 9935
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Disable                                                                                                            OpcuaNodeIdServicesMethod = 9936
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_AddComment                                                                                                         OpcuaNodeIdServicesMethod = 9937
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh                                                                                                   OpcuaNodeIdServicesMethod = 9939
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Acknowledge                                                                                                        OpcuaNodeIdServicesMethod = 9959
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Confirm                                                                                                            OpcuaNodeIdServicesMethod = 9961
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve                                                                                             OpcuaNodeIdServicesMethod = 10014
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve                                                                                        OpcuaNodeIdServicesMethod = 10015
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve                                                                                          OpcuaNodeIdServicesMethod = 10016
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Enable                                                                                                             OpcuaNodeIdServicesMethod = 10089
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Disable                                                                                                            OpcuaNodeIdServicesMethod = 10090
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_AddComment                                                                                                         OpcuaNodeIdServicesMethod = 10091
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh                                                                                                   OpcuaNodeIdServicesMethod = 10093
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Acknowledge                                                                                                        OpcuaNodeIdServicesMethod = 10113
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Confirm                                                                                                            OpcuaNodeIdServicesMethod = 10115
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve                                                                                             OpcuaNodeIdServicesMethod = 10168
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve                                                                                        OpcuaNodeIdServicesMethod = 10169
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve                                                                                          OpcuaNodeIdServicesMethod = 10170
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Enable                                                                                                      OpcuaNodeIdServicesMethod = 10243
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Disable                                                                                                     OpcuaNodeIdServicesMethod = 10244
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_AddComment                                                                                                  OpcuaNodeIdServicesMethod = 10245
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh                                                                                            OpcuaNodeIdServicesMethod = 10247
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Acknowledge                                                                                                 OpcuaNodeIdServicesMethod = 10267
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Confirm                                                                                                     OpcuaNodeIdServicesMethod = 10269
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve                                                                                      OpcuaNodeIdServicesMethod = 10322
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve                                                                                 OpcuaNodeIdServicesMethod = 10323
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve                                                                                   OpcuaNodeIdServicesMethod = 10324
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Enable                                                                                                         OpcuaNodeIdServicesMethod = 10397
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Disable                                                                                                        OpcuaNodeIdServicesMethod = 10398
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_AddComment                                                                                                     OpcuaNodeIdServicesMethod = 10399
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh                                                                                               OpcuaNodeIdServicesMethod = 10401
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Acknowledge                                                                                                    OpcuaNodeIdServicesMethod = 10421
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Confirm                                                                                                        OpcuaNodeIdServicesMethod = 10423
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve                                                                                         OpcuaNodeIdServicesMethod = 10476
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve                                                                                    OpcuaNodeIdServicesMethod = 10477
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve                                                                                      OpcuaNodeIdServicesMethod = 10478
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Enable                                                                                                                      OpcuaNodeIdServicesMethod = 10552
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Disable                                                                                                                     OpcuaNodeIdServicesMethod = 10553
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_AddComment                                                                                                                  OpcuaNodeIdServicesMethod = 10554
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh                                                                                                            OpcuaNodeIdServicesMethod = 10556
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Acknowledge                                                                                                                 OpcuaNodeIdServicesMethod = 10576
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Confirm                                                                                                                     OpcuaNodeIdServicesMethod = 10578
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve                                                                                                      OpcuaNodeIdServicesMethod = 10631
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve                                                                                                 OpcuaNodeIdServicesMethod = 10632
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve                                                                                                   OpcuaNodeIdServicesMethod = 10633
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Enable                                                                                                                     OpcuaNodeIdServicesMethod = 10666
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Disable                                                                                                                    OpcuaNodeIdServicesMethod = 10667
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_AddComment                                                                                                                 OpcuaNodeIdServicesMethod = 10668
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh                                                                                                           OpcuaNodeIdServicesMethod = 10670
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Acknowledge                                                                                                                OpcuaNodeIdServicesMethod = 10690
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Confirm                                                                                                                    OpcuaNodeIdServicesMethod = 10692
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve                                                                                                     OpcuaNodeIdServicesMethod = 10745
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve                                                                                                OpcuaNodeIdServicesMethod = 10746
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve                                                                                                  OpcuaNodeIdServicesMethod = 10747
	OpcuaNodeIdServicesMethod_TripAlarmType_Enable                                                                                                                          OpcuaNodeIdServicesMethod = 10780
	OpcuaNodeIdServicesMethod_TripAlarmType_Disable                                                                                                                         OpcuaNodeIdServicesMethod = 10781
	OpcuaNodeIdServicesMethod_TripAlarmType_AddComment                                                                                                                      OpcuaNodeIdServicesMethod = 10782
	OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh                                                                                                                OpcuaNodeIdServicesMethod = 10784
	OpcuaNodeIdServicesMethod_TripAlarmType_Acknowledge                                                                                                                     OpcuaNodeIdServicesMethod = 10804
	OpcuaNodeIdServicesMethod_TripAlarmType_Confirm                                                                                                                         OpcuaNodeIdServicesMethod = 10806
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve                                                                                                          OpcuaNodeIdServicesMethod = 10859
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve                                                                                                     OpcuaNodeIdServicesMethod = 10860
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve                                                                                                       OpcuaNodeIdServicesMethod = 10861
	OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems                                                                                                                  OpcuaNodeIdServicesMethod = 11489
	OpcuaNodeIdServicesMethod_Server_GetMonitoredItems                                                                                                                      OpcuaNodeIdServicesMethod = 11492
	OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 11495
	OpcuaNodeIdServicesMethod_FileType_Open                                                                                                                                 OpcuaNodeIdServicesMethod = 11580
	OpcuaNodeIdServicesMethod_FileType_Close                                                                                                                                OpcuaNodeIdServicesMethod = 11583
	OpcuaNodeIdServicesMethod_FileType_Read                                                                                                                                 OpcuaNodeIdServicesMethod = 11585
	OpcuaNodeIdServicesMethod_FileType_Write                                                                                                                                OpcuaNodeIdServicesMethod = 11588
	OpcuaNodeIdServicesMethod_FileType_GetPosition                                                                                                                          OpcuaNodeIdServicesMethod = 11590
	OpcuaNodeIdServicesMethod_FileType_SetPosition                                                                                                                          OpcuaNodeIdServicesMethod = 11593
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_Open                                                                                                                     OpcuaNodeIdServicesMethod = 11600
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_Close                                                                                                                    OpcuaNodeIdServicesMethod = 11603
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_Read                                                                                                                     OpcuaNodeIdServicesMethod = 11605
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_Write                                                                                                                    OpcuaNodeIdServicesMethod = 11608
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_GetPosition                                                                                                              OpcuaNodeIdServicesMethod = 11610
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_SetPosition                                                                                                              OpcuaNodeIdServicesMethod = 11613
	OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace                                                                                                          OpcuaNodeIdServicesMethod = 11615
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open                                                                                                      OpcuaNodeIdServicesMethod = 11629
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close                                                                                                     OpcuaNodeIdServicesMethod = 11632
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read                                                                                                      OpcuaNodeIdServicesMethod = 11634
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write                                                                                                     OpcuaNodeIdServicesMethod = 11637
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition                                                                                               OpcuaNodeIdServicesMethod = 11639
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition                                                                                               OpcuaNodeIdServicesMethod = 11642
	OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace                                                                                           OpcuaNodeIdServicesMethod = 11644
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open                                                                             OpcuaNodeIdServicesMethod = 11659
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close                                                                            OpcuaNodeIdServicesMethod = 11662
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read                                                                             OpcuaNodeIdServicesMethod = 11664
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write                                                                            OpcuaNodeIdServicesMethod = 11667
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition                                                                      OpcuaNodeIdServicesMethod = 11669
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition                                                                      OpcuaNodeIdServicesMethod = 11672
	OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace                                                                  OpcuaNodeIdServicesMethod = 11674
	OpcuaNodeIdServicesMethod_OpenMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 11738
	OpcuaNodeIdServicesMethod_CloseMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 11741
	OpcuaNodeIdServicesMethod_ReadMethodType                                                                                                                                OpcuaNodeIdServicesMethod = 11743
	OpcuaNodeIdServicesMethod_WriteMethodType                                                                                                                               OpcuaNodeIdServicesMethod = 11746
	OpcuaNodeIdServicesMethod_GetPositionMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 11748
	OpcuaNodeIdServicesMethod_SetPositionMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 11751
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Disable                                                                                                              OpcuaNodeIdServicesMethod = 11784
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Enable                                                                                                               OpcuaNodeIdServicesMethod = 11785
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_AddComment                                                                                                           OpcuaNodeIdServicesMethod = 11786
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh                                                                                                     OpcuaNodeIdServicesMethod = 11788
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Acknowledge                                                                                                          OpcuaNodeIdServicesMethod = 11808
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Confirm                                                                                                              OpcuaNodeIdServicesMethod = 11810
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve                                                                                               OpcuaNodeIdServicesMethod = 11844
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve                                                                                          OpcuaNodeIdServicesMethod = 11845
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve                                                                                            OpcuaNodeIdServicesMethod = 11846
	OpcuaNodeIdServicesMethod_OpenWithMasksMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 12513
	OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 12516
	OpcuaNodeIdServicesMethod_AddCertificateMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 12518
	OpcuaNodeIdServicesMethod_RemoveCertificateMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 12520
	OpcuaNodeIdServicesMethod_TrustListType_Open                                                                                                                            OpcuaNodeIdServicesMethod = 12527
	OpcuaNodeIdServicesMethod_TrustListType_Close                                                                                                                           OpcuaNodeIdServicesMethod = 12530
	OpcuaNodeIdServicesMethod_TrustListType_Read                                                                                                                            OpcuaNodeIdServicesMethod = 12532
	OpcuaNodeIdServicesMethod_TrustListType_Write                                                                                                                           OpcuaNodeIdServicesMethod = 12535
	OpcuaNodeIdServicesMethod_TrustListType_GetPosition                                                                                                                     OpcuaNodeIdServicesMethod = 12537
	OpcuaNodeIdServicesMethod_TrustListType_SetPosition                                                                                                                     OpcuaNodeIdServicesMethod = 12540
	OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks                                                                                                                   OpcuaNodeIdServicesMethod = 12543
	OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate                                                                                                                  OpcuaNodeIdServicesMethod = 12546
	OpcuaNodeIdServicesMethod_TrustListType_AddCertificate                                                                                                                  OpcuaNodeIdServicesMethod = 12548
	OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate                                                                                                               OpcuaNodeIdServicesMethod = 12550
	OpcuaNodeIdServicesMethod_UpdateCertificateMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 12578
	OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate                                                                                                     OpcuaNodeIdServicesMethod = 12616
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                                                  OpcuaNodeIdServicesMethod = 12647
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                                                 OpcuaNodeIdServicesMethod = 12650
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                                                  OpcuaNodeIdServicesMethod = 12652
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                                                 OpcuaNodeIdServicesMethod = 12655
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                                           OpcuaNodeIdServicesMethod = 12657
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                                           OpcuaNodeIdServicesMethod = 12660
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                                         OpcuaNodeIdServicesMethod = 12663
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                        OpcuaNodeIdServicesMethod = 12666
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                                        OpcuaNodeIdServicesMethod = 12668
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                                     OpcuaNodeIdServicesMethod = 12670
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest                                                                                                  OpcuaNodeIdServicesMethod = 12731
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges                                                                                                          OpcuaNodeIdServicesMethod = 12734
	OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest                                                                                                      OpcuaNodeIdServicesMethod = 12737
	OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges                                                                                                              OpcuaNodeIdServicesMethod = 12740
	OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType                                                                                                                OpcuaNodeIdServicesMethod = 12741
	OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable                                                                                                             OpcuaNodeIdServicesMethod = 12746
	OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable                                                                                                                 OpcuaNodeIdServicesMethod = 12749
	OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType                                                                                                              OpcuaNodeIdServicesMethod = 12752
	OpcuaNodeIdServicesMethod_GetRejectedListMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 12773
	OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList                                                                                                       OpcuaNodeIdServicesMethod = 12775
	OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList                                                                                                           OpcuaNodeIdServicesMethod = 12777
	OpcuaNodeIdServicesMethod_ServerType_ResendData                                                                                                                         OpcuaNodeIdServicesMethod = 12871
	OpcuaNodeIdServicesMethod_Server_ResendData                                                                                                                             OpcuaNodeIdServicesMethod = 12873
	OpcuaNodeIdServicesMethod_ResendDataMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 12875
	OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange                                                                                                           OpcuaNodeIdServicesMethod = 12883
	OpcuaNodeIdServicesMethod_Server_RequestServerStateChange                                                                                                               OpcuaNodeIdServicesMethod = 12886
	OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType                                                                                                            OpcuaNodeIdServicesMethod = 12888
	OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2                                                                                                               OpcuaNodeIdServicesMethod = 12912
	OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType                                                                                                                   OpcuaNodeIdServicesMethod = 12914
	OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh2                                                                                                         OpcuaNodeIdServicesMethod = 12916
	OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh2                                                                                                OpcuaNodeIdServicesMethod = 12918
	OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh2                                                                                                          OpcuaNodeIdServicesMethod = 12984
	OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh2                                                                                                              OpcuaNodeIdServicesMethod = 12986
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh2                                                                                                     OpcuaNodeIdServicesMethod = 12988
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh2                                                                                                  OpcuaNodeIdServicesMethod = 12990
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh2                                                                                                  OpcuaNodeIdServicesMethod = 12992
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh2                                                                                                     OpcuaNodeIdServicesMethod = 12994
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh2                                                                                              OpcuaNodeIdServicesMethod = 12996
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh2                                                                                                 OpcuaNodeIdServicesMethod = 12998
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2                                                                                           OpcuaNodeIdServicesMethod = 13000
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh2                                                                                              OpcuaNodeIdServicesMethod = 13002
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh2                                                                                                           OpcuaNodeIdServicesMethod = 13004
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh2                                                                                                          OpcuaNodeIdServicesMethod = 13006
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh2                                                                                                    OpcuaNodeIdServicesMethod = 13008
	OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh2                                                                                                               OpcuaNodeIdServicesMethod = 13010
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Disable                                                                                                        OpcuaNodeIdServicesMethod = 13256
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Enable                                                                                                         OpcuaNodeIdServicesMethod = 13257
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_AddComment                                                                                                     OpcuaNodeIdServicesMethod = 13258
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh                                                                                               OpcuaNodeIdServicesMethod = 13260
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh2                                                                                              OpcuaNodeIdServicesMethod = 13262
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Acknowledge                                                                                                    OpcuaNodeIdServicesMethod = 13282
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Confirm                                                                                                        OpcuaNodeIdServicesMethod = 13284
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve                                                                                         OpcuaNodeIdServicesMethod = 13318
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve                                                                                    OpcuaNodeIdServicesMethod = 13319
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve                                                                                      OpcuaNodeIdServicesMethod = 13320
	OpcuaNodeIdServicesMethod_CreateDirectoryMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 13342
	OpcuaNodeIdServicesMethod_CreateFileMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 13345
	OpcuaNodeIdServicesMethod_DeleteFileMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 13348
	OpcuaNodeIdServicesMethod_MoveOrCopyMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 13350
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory                                                                               OpcuaNodeIdServicesMethod = 13355
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile                                                                                    OpcuaNodeIdServicesMethod = 13358
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy                                                                                    OpcuaNodeIdServicesMethod = 13363
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open                                                                                                   OpcuaNodeIdServicesMethod = 13372
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close                                                                                                  OpcuaNodeIdServicesMethod = 13375
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read                                                                                                   OpcuaNodeIdServicesMethod = 13377
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write                                                                                                  OpcuaNodeIdServicesMethod = 13380
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition                                                                                            OpcuaNodeIdServicesMethod = 13382
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition                                                                                            OpcuaNodeIdServicesMethod = 13385
	OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory                                                                                                             OpcuaNodeIdServicesMethod = 13387
	OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile                                                                                                                  OpcuaNodeIdServicesMethod = 13390
	OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject                                                                                                      OpcuaNodeIdServicesMethod = 13393
	OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy                                                                                                                  OpcuaNodeIdServicesMethod = 13395
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open                                                                                                           OpcuaNodeIdServicesMethod = 13605
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close                                                                                                          OpcuaNodeIdServicesMethod = 13608
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read                                                                                                           OpcuaNodeIdServicesMethod = 13610
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write                                                                                                          OpcuaNodeIdServicesMethod = 13613
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition                                                                                                    OpcuaNodeIdServicesMethod = 13615
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition                                                                                                    OpcuaNodeIdServicesMethod = 13618
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks                                                                                                  OpcuaNodeIdServicesMethod = 13621
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate                                                                                                 OpcuaNodeIdServicesMethod = 13624
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate                                                                                                 OpcuaNodeIdServicesMethod = 13627
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate                                                                                              OpcuaNodeIdServicesMethod = 13629
	OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate                                                                                                         OpcuaNodeIdServicesMethod = 13737
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open                                                                             OpcuaNodeIdServicesMethod = 13821
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close                                                                            OpcuaNodeIdServicesMethod = 13824
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read                                                                             OpcuaNodeIdServicesMethod = 13826
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write                                                                            OpcuaNodeIdServicesMethod = 13829
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition                                                                      OpcuaNodeIdServicesMethod = 13831
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition                                                                      OpcuaNodeIdServicesMethod = 13834
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks                                                                    OpcuaNodeIdServicesMethod = 13837
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                                   OpcuaNodeIdServicesMethod = 13840
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate                                                                   OpcuaNodeIdServicesMethod = 13843
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate                                                                OpcuaNodeIdServicesMethod = 13845
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open                                                                                   OpcuaNodeIdServicesMethod = 13855
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close                                                                                  OpcuaNodeIdServicesMethod = 13858
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read                                                                                   OpcuaNodeIdServicesMethod = 13860
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write                                                                                  OpcuaNodeIdServicesMethod = 13863
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition                                                                            OpcuaNodeIdServicesMethod = 13865
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition                                                                            OpcuaNodeIdServicesMethod = 13868
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks                                                                          OpcuaNodeIdServicesMethod = 13871
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                                         OpcuaNodeIdServicesMethod = 13874
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate                                                                         OpcuaNodeIdServicesMethod = 13877
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate                                                                      OpcuaNodeIdServicesMethod = 13879
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open                                                                               OpcuaNodeIdServicesMethod = 13889
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close                                                                              OpcuaNodeIdServicesMethod = 13892
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read                                                                               OpcuaNodeIdServicesMethod = 13894
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write                                                                              OpcuaNodeIdServicesMethod = 13897
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition                                                                        OpcuaNodeIdServicesMethod = 13899
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition                                                                        OpcuaNodeIdServicesMethod = 13902
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                                      OpcuaNodeIdServicesMethod = 13905
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                                     OpcuaNodeIdServicesMethod = 13908
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate                                                                     OpcuaNodeIdServicesMethod = 13911
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                                  OpcuaNodeIdServicesMethod = 13913
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open                                                                         OpcuaNodeIdServicesMethod = 13923
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close                                                                        OpcuaNodeIdServicesMethod = 13926
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read                                                                         OpcuaNodeIdServicesMethod = 13928
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write                                                                        OpcuaNodeIdServicesMethod = 13931
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition                                                                  OpcuaNodeIdServicesMethod = 13933
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition                                                                  OpcuaNodeIdServicesMethod = 13936
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks                                                                OpcuaNodeIdServicesMethod = 13939
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate                                                               OpcuaNodeIdServicesMethod = 13942
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate                                                               OpcuaNodeIdServicesMethod = 13945
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate                                                            OpcuaNodeIdServicesMethod = 13947
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                                              OpcuaNodeIdServicesMethod = 13958
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                                             OpcuaNodeIdServicesMethod = 13961
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                                              OpcuaNodeIdServicesMethod = 13963
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                                             OpcuaNodeIdServicesMethod = 13966
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                                       OpcuaNodeIdServicesMethod = 13968
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                                       OpcuaNodeIdServicesMethod = 13971
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                                     OpcuaNodeIdServicesMethod = 13974
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                                    OpcuaNodeIdServicesMethod = 13977
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                                    OpcuaNodeIdServicesMethod = 13980
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                                 OpcuaNodeIdServicesMethod = 13982
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                                    OpcuaNodeIdServicesMethod = 13992
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                                   OpcuaNodeIdServicesMethod = 13995
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                                    OpcuaNodeIdServicesMethod = 13997
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                                   OpcuaNodeIdServicesMethod = 14000
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                                             OpcuaNodeIdServicesMethod = 14002
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                                             OpcuaNodeIdServicesMethod = 14005
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                                           OpcuaNodeIdServicesMethod = 14008
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                          OpcuaNodeIdServicesMethod = 14011
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                                          OpcuaNodeIdServicesMethod = 14014
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                                       OpcuaNodeIdServicesMethod = 14016
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                                                OpcuaNodeIdServicesMethod = 14026
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                                               OpcuaNodeIdServicesMethod = 14029
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                                                OpcuaNodeIdServicesMethod = 14031
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                                               OpcuaNodeIdServicesMethod = 14034
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                                         OpcuaNodeIdServicesMethod = 14036
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                                         OpcuaNodeIdServicesMethod = 14039
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                       OpcuaNodeIdServicesMethod = 14042
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                      OpcuaNodeIdServicesMethod = 14045
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                                      OpcuaNodeIdServicesMethod = 14048
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                   OpcuaNodeIdServicesMethod = 14050
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                                        OpcuaNodeIdServicesMethod = 14095
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                                       OpcuaNodeIdServicesMethod = 14098
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                                        OpcuaNodeIdServicesMethod = 14100
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                                       OpcuaNodeIdServicesMethod = 14103
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                                                 OpcuaNodeIdServicesMethod = 14105
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                                                 OpcuaNodeIdServicesMethod = 14108
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                                               OpcuaNodeIdServicesMethod = 14111
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                              OpcuaNodeIdServicesMethod = 14114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                                              OpcuaNodeIdServicesMethod = 14117
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                                           OpcuaNodeIdServicesMethod = 14119
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                                                    OpcuaNodeIdServicesMethod = 14129
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                                                   OpcuaNodeIdServicesMethod = 14132
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                                                    OpcuaNodeIdServicesMethod = 14134
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                                                   OpcuaNodeIdServicesMethod = 14137
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                                             OpcuaNodeIdServicesMethod = 14139
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                                             OpcuaNodeIdServicesMethod = 14142
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                           OpcuaNodeIdServicesMethod = 14145
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                          OpcuaNodeIdServicesMethod = 14148
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                                          OpcuaNodeIdServicesMethod = 14151
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                                       OpcuaNodeIdServicesMethod = 14153
	OpcuaNodeIdServicesMethod_RemoveConnectionMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 14183
	OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup                                                                                                              OpcuaNodeIdServicesMethod = 14225
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable                                                                                 OpcuaNodeIdServicesMethod = 14421
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable                                                                                OpcuaNodeIdServicesMethod = 14422
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup                                                                                   OpcuaNodeIdServicesMethod = 14424
	OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection                                                                                                         OpcuaNodeIdServicesMethod = 14432
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems                                                                                  OpcuaNodeIdServicesMethod = 14435
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents                                                                                     OpcuaNodeIdServicesMethod = 14438
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet                                                                                 OpcuaNodeIdServicesMethod = 14441
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems                                                                         OpcuaNodeIdServicesMethod = 14479
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents                                                                            OpcuaNodeIdServicesMethod = 14482
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet                                                                        OpcuaNodeIdServicesMethod = 14485
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems                                                                                                       OpcuaNodeIdServicesMethod = 14493
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents                                                                                                          OpcuaNodeIdServicesMethod = 14496
	OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet                                                                                                      OpcuaNodeIdServicesMethod = 14499
	OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType                                                                                                               OpcuaNodeIdServicesMethod = 14501
	OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType                                                                                                                  OpcuaNodeIdServicesMethod = 14504
	OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType                                                                                                              OpcuaNodeIdServicesMethod = 14507
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables                                                                                                           OpcuaNodeIdServicesMethod = 14555
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables                                                                                                        OpcuaNodeIdServicesMethod = 14558
	OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType                                                                                                      OpcuaNodeIdServicesMethod = 14564
	OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType                                                                                                   OpcuaNodeIdServicesMethod = 14567
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable                                                                                                            OpcuaNodeIdServicesMethod = 14602
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable                                                                                                           OpcuaNodeIdServicesMethod = 14603
	OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType                                                                                                     OpcuaNodeIdServicesMethod = 14604
	OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType                                                                                                         OpcuaNodeIdServicesMethod = 14623
	OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType                                                                                                         OpcuaNodeIdServicesMethod = 14625
	OpcuaNodeIdServicesMethod_PubSubStatusType_Enable                                                                                                                       OpcuaNodeIdServicesMethod = 14645
	OpcuaNodeIdServicesMethod_PubSubStatusType_Disable                                                                                                                      OpcuaNodeIdServicesMethod = 14646
	OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection                                                                                                      OpcuaNodeIdServicesMethod = 15052
	OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType                                                                                             OpcuaNodeIdServicesMethod = 15054
	OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables                                                                                                        OpcuaNodeIdServicesMethod = 15115
	OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables                                                                                                     OpcuaNodeIdServicesMethod = 15118
	OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType                                                                                               OpcuaNodeIdServicesMethod = 15121
	OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType                                                                                            OpcuaNodeIdServicesMethod = 15124
	OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityKeys                                                                                                          OpcuaNodeIdServicesMethod = 15212
	OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys                                                                                                              OpcuaNodeIdServicesMethod = 15215
	OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 15218
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable                                                                              OpcuaNodeIdServicesMethod = 15225
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable                                                                             OpcuaNodeIdServicesMethod = 15226
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Enable                                                                            OpcuaNodeIdServicesMethod = 15233
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Disable                                                                           OpcuaNodeIdServicesMethod = 15234
	OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Enable                                                                               OpcuaNodeIdServicesMethod = 15241
	OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Disable                                                                              OpcuaNodeIdServicesMethod = 15242
	OpcuaNodeIdServicesMethod_CreateCredentialMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 15248
	OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable                                                                                                                 OpcuaNodeIdServicesMethod = 15267
	OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable                                                                                                                OpcuaNodeIdServicesMethod = 15268
	OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable                                                                                                               OpcuaNodeIdServicesMethod = 15301
	OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable                                                                                                              OpcuaNodeIdServicesMethod = 15302
	OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable                                                                                                               OpcuaNodeIdServicesMethod = 15309
	OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable                                                                                                              OpcuaNodeIdServicesMethod = 15310
	OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityGroup                                                                                                         OpcuaNodeIdServicesMethod = 15431
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroup                                                                                          OpcuaNodeIdServicesMethod = 15435
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup                                                                                       OpcuaNodeIdServicesMethod = 15438
	OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup                                                                                                             OpcuaNodeIdServicesMethod = 15440
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup                                                                                              OpcuaNodeIdServicesMethod = 15444
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup                                                                                           OpcuaNodeIdServicesMethod = 15447
	OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 15449
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup                                                                  OpcuaNodeIdServicesMethod = 15454
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup                                                               OpcuaNodeIdServicesMethod = 15457
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup                                                                                                      OpcuaNodeIdServicesMethod = 15461
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup                                                                                                   OpcuaNodeIdServicesMethod = 15464
	OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 15466
	OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 15469
	OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField                                                          OpcuaNodeIdServicesMethod = 15474
	OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField                                                       OpcuaNodeIdServicesMethod = 15477
	OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField                                                                                        OpcuaNodeIdServicesMethod = 15482
	OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField                                                                                     OpcuaNodeIdServicesMethod = 15485
	OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField                                                                                                         OpcuaNodeIdServicesMethod = 15491
	OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField                                                                                                      OpcuaNodeIdServicesMethod = 15494
	OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 15496
	OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType                                                                                                                OpcuaNodeIdServicesMethod = 15499
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_AddExtensionField                                                                                      OpcuaNodeIdServicesMethod = 15504
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_RemoveExtensionField                                                                                   OpcuaNodeIdServicesMethod = 15507
	OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_AddExtensionField                                                                                         OpcuaNodeIdServicesMethod = 15512
	OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_RemoveExtensionField                                                                                      OpcuaNodeIdServicesMethod = 15515
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity                                                                                                  OpcuaNodeIdServicesMethod = 15612
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity                                                                                               OpcuaNodeIdServicesMethod = 15614
	OpcuaNodeIdServicesMethod_RoleType_AddIdentity                                                                                                                          OpcuaNodeIdServicesMethod = 15624
	OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity                                                                                                                       OpcuaNodeIdServicesMethod = 15626
	OpcuaNodeIdServicesMethod_AddIdentityMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 15636
	OpcuaNodeIdServicesMethod_RemoveIdentityMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 15638
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity                                                                                                           OpcuaNodeIdServicesMethod = 15648
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity                                                                                                        OpcuaNodeIdServicesMethod = 15650
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity                                                                                                   OpcuaNodeIdServicesMethod = 15660
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity                                                                                                OpcuaNodeIdServicesMethod = 15662
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity                                                                                                            OpcuaNodeIdServicesMethod = 15672
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity                                                                                                         OpcuaNodeIdServicesMethod = 15674
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity                                                                                                            OpcuaNodeIdServicesMethod = 15684
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity                                                                                                         OpcuaNodeIdServicesMethod = 15686
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity                                                                                                          OpcuaNodeIdServicesMethod = 15696
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity                                                                                                       OpcuaNodeIdServicesMethod = 15698
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity                                                                                                       OpcuaNodeIdServicesMethod = 15708
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity                                                                                                    OpcuaNodeIdServicesMethod = 15710
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity                                                                                                      OpcuaNodeIdServicesMethod = 15720
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity                                                                                                   OpcuaNodeIdServicesMethod = 15722
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead                                                                                                 OpcuaNodeIdServicesMethod = 15746
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite                                                                                                OpcuaNodeIdServicesMethod = 15749
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit                                                                                                      OpcuaNodeIdServicesMethod = 15751
	OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset                                                                                     OpcuaNodeIdServicesMethod = 15794
	OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 15795
	OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType                                                                                                                OpcuaNodeIdServicesMethod = 15798
	OpcuaNodeIdServicesMethod_CloseAndCommitMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 15800
	OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset                                                                                                            OpcuaNodeIdServicesMethod = 15843
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable                                                                                                            OpcuaNodeIdServicesMethod = 15846
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable                                                                                                           OpcuaNodeIdServicesMethod = 15847
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Enable                                                                                     OpcuaNodeIdServicesMethod = 15893
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Disable                                                                                    OpcuaNodeIdServicesMethod = 15894
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys                                                                                                          OpcuaNodeIdServicesMethod = 15907
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup                                                                                                         OpcuaNodeIdServicesMethod = 15910
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup                                                                                          OpcuaNodeIdServicesMethod = 15914
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup                                                                                       OpcuaNodeIdServicesMethod = 15917
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open                                                                                                     OpcuaNodeIdServicesMethod = 15971
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close                                                                                                    OpcuaNodeIdServicesMethod = 15974
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read                                                                                                     OpcuaNodeIdServicesMethod = 15976
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write                                                                                                    OpcuaNodeIdServicesMethod = 15979
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition                                                                                              OpcuaNodeIdServicesMethod = 15981
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition                                                                                              OpcuaNodeIdServicesMethod = 15984
	OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace                                                                                          OpcuaNodeIdServicesMethod = 15986
	OpcuaNodeIdServicesMethod_RoleSetType_AddRole                                                                                                                           OpcuaNodeIdServicesMethod = 15997
	OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole                                                                                                                        OpcuaNodeIdServicesMethod = 16000
	OpcuaNodeIdServicesMethod_AddRoleMethodType                                                                                                                             OpcuaNodeIdServicesMethod = 16002
	OpcuaNodeIdServicesMethod_RemoveRoleMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 16005
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity                                                                                                            OpcuaNodeIdServicesMethod = 16041
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity                                                                                                         OpcuaNodeIdServicesMethod = 16043
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset                                                                                 OpcuaNodeIdServicesMethod = 16076
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication                                                                                               OpcuaNodeIdServicesMethod = 16165
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication                                                                                            OpcuaNodeIdServicesMethod = 16167
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint                                                                                                  OpcuaNodeIdServicesMethod = 16169
	OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint                                                                                               OpcuaNodeIdServicesMethod = 16171
	OpcuaNodeIdServicesMethod_RoleType_AddApplication                                                                                                                       OpcuaNodeIdServicesMethod = 16176
	OpcuaNodeIdServicesMethod_RoleType_RemoveApplication                                                                                                                    OpcuaNodeIdServicesMethod = 16178
	OpcuaNodeIdServicesMethod_RoleType_AddEndpoint                                                                                                                          OpcuaNodeIdServicesMethod = 16180
	OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint                                                                                                                       OpcuaNodeIdServicesMethod = 16182
	OpcuaNodeIdServicesMethod_AddApplicationMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 16184
	OpcuaNodeIdServicesMethod_RemoveApplicationMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 16186
	OpcuaNodeIdServicesMethod_AddEndpointMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 16188
	OpcuaNodeIdServicesMethod_RemoveEndpointMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 16190
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication                                                                                                        OpcuaNodeIdServicesMethod = 16195
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication                                                                                                     OpcuaNodeIdServicesMethod = 16197
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint                                                                                                           OpcuaNodeIdServicesMethod = 16199
	OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint                                                                                                        OpcuaNodeIdServicesMethod = 16201
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication                                                                                                OpcuaNodeIdServicesMethod = 16206
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication                                                                                             OpcuaNodeIdServicesMethod = 16208
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint                                                                                                   OpcuaNodeIdServicesMethod = 16210
	OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint                                                                                                OpcuaNodeIdServicesMethod = 16212
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication                                                                                                         OpcuaNodeIdServicesMethod = 16217
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication                                                                                                      OpcuaNodeIdServicesMethod = 16219
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint                                                                                                            OpcuaNodeIdServicesMethod = 16221
	OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint                                                                                                         OpcuaNodeIdServicesMethod = 16223
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication                                                                                                         OpcuaNodeIdServicesMethod = 16228
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication                                                                                                      OpcuaNodeIdServicesMethod = 16230
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint                                                                                                            OpcuaNodeIdServicesMethod = 16232
	OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint                                                                                                         OpcuaNodeIdServicesMethod = 16234
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication                                                                                                         OpcuaNodeIdServicesMethod = 16239
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication                                                                                                      OpcuaNodeIdServicesMethod = 16241
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint                                                                                                            OpcuaNodeIdServicesMethod = 16243
	OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint                                                                                                         OpcuaNodeIdServicesMethod = 16245
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication                                                                                                       OpcuaNodeIdServicesMethod = 16250
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication                                                                                                    OpcuaNodeIdServicesMethod = 16252
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint                                                                                                          OpcuaNodeIdServicesMethod = 16254
	OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint                                                                                                       OpcuaNodeIdServicesMethod = 16256
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication                                                                                                    OpcuaNodeIdServicesMethod = 16261
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication                                                                                                 OpcuaNodeIdServicesMethod = 16263
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint                                                                                                       OpcuaNodeIdServicesMethod = 16265
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint                                                                                                    OpcuaNodeIdServicesMethod = 16267
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication                                                                                                   OpcuaNodeIdServicesMethod = 16272
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication                                                                                                OpcuaNodeIdServicesMethod = 16274
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint                                                                                                      OpcuaNodeIdServicesMethod = 16276
	OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint                                                                                                   OpcuaNodeIdServicesMethod = 16278
	OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole                                                                                                 OpcuaNodeIdServicesMethod = 16290
	OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole                                                                                              OpcuaNodeIdServicesMethod = 16293
	OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole                                                                                                        OpcuaNodeIdServicesMethod = 16296
	OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole                                                                                                     OpcuaNodeIdServicesMethod = 16299
	OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole                                                                                                     OpcuaNodeIdServicesMethod = 16301
	OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole                                                                                                  OpcuaNodeIdServicesMethod = 16304
	OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateDirectory                                                                                      OpcuaNodeIdServicesMethod = 16316
	OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateFile                                                                                           OpcuaNodeIdServicesMethod = 16319
	OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy                                                                                           OpcuaNodeIdServicesMethod = 16324
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Open                                                                                                          OpcuaNodeIdServicesMethod = 16333
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Close                                                                                                         OpcuaNodeIdServicesMethod = 16336
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Read                                                                                                          OpcuaNodeIdServicesMethod = 16338
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Write                                                                                                         OpcuaNodeIdServicesMethod = 16341
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_GetPosition                                                                                                   OpcuaNodeIdServicesMethod = 16343
	OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_SetPosition                                                                                                   OpcuaNodeIdServicesMethod = 16346
	OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory                                                                                                                    OpcuaNodeIdServicesMethod = 16348
	OpcuaNodeIdServicesMethod_FileSystem_CreateFile                                                                                                                         OpcuaNodeIdServicesMethod = 16351
	OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject                                                                                                             OpcuaNodeIdServicesMethod = 16354
	OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy                                                                                                                         OpcuaNodeIdServicesMethod = 16356
	OpcuaNodeIdServicesMethod_AlarmConditionType_Silence                                                                                                                    OpcuaNodeIdServicesMethod = 16402
	OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress                                                                                                                   OpcuaNodeIdServicesMethod = 16403
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable                                                                                     OpcuaNodeIdServicesMethod = 16439
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable                                                                                      OpcuaNodeIdServicesMethod = 16440
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment                                                                                  OpcuaNodeIdServicesMethod = 16441
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge                                                                                 OpcuaNodeIdServicesMethod = 16461
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm                                                                                     OpcuaNodeIdServicesMethod = 16463
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve                                                                      OpcuaNodeIdServicesMethod = 16515
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve                                                                 OpcuaNodeIdServicesMethod = 16516
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve                                                                   OpcuaNodeIdServicesMethod = 16517
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence                                                                                     OpcuaNodeIdServicesMethod = 16533
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress                                                                                    OpcuaNodeIdServicesMethod = 16534
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup                                                                                OpcuaNodeIdServicesMethod = 16535
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup                                                                                OpcuaNodeIdServicesMethod = 16560
	OpcuaNodeIdServicesMethod_LimitAlarmType_Silence                                                                                                                        OpcuaNodeIdServicesMethod = 16569
	OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress                                                                                                                       OpcuaNodeIdServicesMethod = 16570
	OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection                                                                                                            OpcuaNodeIdServicesMethod = 16598
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate                                                                          OpcuaNodeIdServicesMethod = 16601
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Silence                                                                                                               OpcuaNodeIdServicesMethod = 16609
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress                                                                                                              OpcuaNodeIdServicesMethod = 16610
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate                                                                             OpcuaNodeIdServicesMethod = 16639
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Silence                                                                                                            OpcuaNodeIdServicesMethod = 16649
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress                                                                                                           OpcuaNodeIdServicesMethod = 16650
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder                                                                                       OpcuaNodeIdServicesMethod = 16651
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder                                                                                    OpcuaNodeIdServicesMethod = 16680
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Silence                                                                                                            OpcuaNodeIdServicesMethod = 16689
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress                                                                                                           OpcuaNodeIdServicesMethod = 16690
	OpcuaNodeIdServicesMethod_AddConnectionMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 16691
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Silence                                                                                                               OpcuaNodeIdServicesMethod = 16729
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress                                                                                                              OpcuaNodeIdServicesMethod = 16730
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Silence                                                                                                        OpcuaNodeIdServicesMethod = 16769
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress                                                                                                       OpcuaNodeIdServicesMethod = 16770
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Silence                                                                                                           OpcuaNodeIdServicesMethod = 16810
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress                                                                                                          OpcuaNodeIdServicesMethod = 16811
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate                                                                 OpcuaNodeIdServicesMethod = 16842
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Silence                                                                                                     OpcuaNodeIdServicesMethod = 16851
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress                                                                                                    OpcuaNodeIdServicesMethod = 16852
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate                                                                    OpcuaNodeIdServicesMethod = 16881
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder                                                                              OpcuaNodeIdServicesMethod = 16884
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Silence                                                                                                        OpcuaNodeIdServicesMethod = 16892
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress                                                                                                       OpcuaNodeIdServicesMethod = 16893
	OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder                                                                           OpcuaNodeIdServicesMethod = 16923
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Silence                                                                                                                     OpcuaNodeIdServicesMethod = 16933
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress                                                                                                                    OpcuaNodeIdServicesMethod = 16934
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate                                                                                               OpcuaNodeIdServicesMethod = 16935
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate                                                                                                  OpcuaNodeIdServicesMethod = 16960
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Silence                                                                                                                    OpcuaNodeIdServicesMethod = 16969
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress                                                                                                                   OpcuaNodeIdServicesMethod = 16970
	OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder                                                                                                            OpcuaNodeIdServicesMethod = 16994
	OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder                                                                                                         OpcuaNodeIdServicesMethod = 16997
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Silence                                                                                                              OpcuaNodeIdServicesMethod = 17005
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress                                                                                                             OpcuaNodeIdServicesMethod = 17006
	OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType                                                                                                       OpcuaNodeIdServicesMethod = 17030
	OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType                                                                                                          OpcuaNodeIdServicesMethod = 17033
	OpcuaNodeIdServicesMethod_TripAlarmType_Silence                                                                                                                         OpcuaNodeIdServicesMethod = 17041
	OpcuaNodeIdServicesMethod_TripAlarmType_Suppress                                                                                                                        OpcuaNodeIdServicesMethod = 17042
	OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 17067
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Silence                                                                                                        OpcuaNodeIdServicesMethod = 17077
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress                                                                                                       OpcuaNodeIdServicesMethod = 17078
	OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 17079
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Disable                                                                                                                  OpcuaNodeIdServicesMethod = 17113
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Enable                                                                                                                   OpcuaNodeIdServicesMethod = 17114
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_AddComment                                                                                                               OpcuaNodeIdServicesMethod = 17115
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh                                                                                                         OpcuaNodeIdServicesMethod = 17117
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh2                                                                                                        OpcuaNodeIdServicesMethod = 17119
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Acknowledge                                                                                                              OpcuaNodeIdServicesMethod = 17139
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Confirm                                                                                                                  OpcuaNodeIdServicesMethod = 17141
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve                                                                                                   OpcuaNodeIdServicesMethod = 17193
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve                                                                                              OpcuaNodeIdServicesMethod = 17194
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve                                                                                                OpcuaNodeIdServicesMethod = 17195
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Silence                                                                                                                  OpcuaNodeIdServicesMethod = 17212
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress                                                                                                                 OpcuaNodeIdServicesMethod = 17213
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter                                                                             OpcuaNodeIdServicesMethod = 17293
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys                                                                                                          OpcuaNodeIdServicesMethod = 17296
	OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 17298
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable                                                                                OpcuaNodeIdServicesMethod = 17316
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable                                                                               OpcuaNodeIdServicesMethod = 17317
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter                                                                          OpcuaNodeIdServicesMethod = 17323
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable                                                                                OpcuaNodeIdServicesMethod = 17331
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable                                                                               OpcuaNodeIdServicesMethod = 17332
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader                                                                          OpcuaNodeIdServicesMethod = 17333
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader                                                                             OpcuaNodeIdServicesMethod = 17355
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup                                                                                    OpcuaNodeIdServicesMethod = 17356
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup                                                                                    OpcuaNodeIdServicesMethod = 17359
	OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup                                                                                       OpcuaNodeIdServicesMethod = 17362
	OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys                                                                                                              OpcuaNodeIdServicesMethod = 17364
	OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection                                                                                                                OpcuaNodeIdServicesMethod = 17366
	OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection                                                                                                             OpcuaNodeIdServicesMethod = 17369
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems                                                                                      OpcuaNodeIdServicesMethod = 17372
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents                                                                                         OpcuaNodeIdServicesMethod = 17375
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate                                                                              OpcuaNodeIdServicesMethod = 17378
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate                                                                                 OpcuaNodeIdServicesMethod = 17381
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet                                                                                     OpcuaNodeIdServicesMethod = 17384
	OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables                                                                                                       OpcuaNodeIdServicesMethod = 17386
	OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror                                                                                                         OpcuaNodeIdServicesMethod = 17389
	OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType                                                                                              OpcuaNodeIdServicesMethod = 17392
	OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType                                                                                                OpcuaNodeIdServicesMethod = 17395
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder                                                                                           OpcuaNodeIdServicesMethod = 17398
	OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder                                                                                        OpcuaNodeIdServicesMethod = 17403
	OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable                                                                                                                OpcuaNodeIdServicesMethod = 17407
	OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable                                                                                                               OpcuaNodeIdServicesMethod = 17408
	OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset                                                                                                            OpcuaNodeIdServicesMethod = 17421
	OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup                                                                                                           OpcuaNodeIdServicesMethod = 17427
	OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup                                                                                                           OpcuaNodeIdServicesMethod = 17465
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey                                                                 OpcuaNodeIdServicesMethod = 17516
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential                                                                 OpcuaNodeIdServicesMethod = 17519
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential                                                                 OpcuaNodeIdServicesMethod = 17521
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential                                                                                         OpcuaNodeIdServicesMethod = 17522
	OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey                                                                           OpcuaNodeIdServicesMethod = 17525
	OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential                                                                                                   OpcuaNodeIdServicesMethod = 17528
	OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 17531
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey                                                                                               OpcuaNodeIdServicesMethod = 17534
	OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType                                                                                                  OpcuaNodeIdServicesMethod = 17561
	OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType                                                                                                 OpcuaNodeIdServicesMethod = 17630
	OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject                                                                        OpcuaNodeIdServicesMethod = 17718
	OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject                                                                               OpcuaNodeIdServicesMethod = 17722
	OpcuaNodeIdServicesMethod_WriterGroupType_Status_Enable                                                                                                                 OpcuaNodeIdServicesMethod = 17734
	OpcuaNodeIdServicesMethod_WriterGroupType_Status_Disable                                                                                                                OpcuaNodeIdServicesMethod = 17735
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable                                                                                   OpcuaNodeIdServicesMethod = 17751
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable                                                                                  OpcuaNodeIdServicesMethod = 17752
	OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                               OpcuaNodeIdServicesMethod = 17765
	OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset                                                                                                             OpcuaNodeIdServicesMethod = 17824
	OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress                                                                                                                 OpcuaNodeIdServicesMethod = 17868
	OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService                                                                                                          OpcuaNodeIdServicesMethod = 17869
	OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService                                                                                                             OpcuaNodeIdServicesMethod = 17870
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress                                                                                  OpcuaNodeIdServicesMethod = 17875
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService                                                                           OpcuaNodeIdServicesMethod = 17876
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService                                                                              OpcuaNodeIdServicesMethod = 17877
	OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress                                                                                                                     OpcuaNodeIdServicesMethod = 17882
	OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService                                                                                                              OpcuaNodeIdServicesMethod = 17883
	OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService                                                                                                                 OpcuaNodeIdServicesMethod = 17884
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress                                                                                                            OpcuaNodeIdServicesMethod = 17889
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService                                                                                                     OpcuaNodeIdServicesMethod = 17890
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService                                                                                                        OpcuaNodeIdServicesMethod = 17891
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress                                                                                                         OpcuaNodeIdServicesMethod = 17896
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService                                                                                                  OpcuaNodeIdServicesMethod = 17897
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService                                                                                                     OpcuaNodeIdServicesMethod = 17898
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService                                                                                                  OpcuaNodeIdServicesMethod = 17904
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService                                                                                                     OpcuaNodeIdServicesMethod = 17905
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress                                                                                                            OpcuaNodeIdServicesMethod = 17910
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService                                                                                                     OpcuaNodeIdServicesMethod = 17911
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService                                                                                                        OpcuaNodeIdServicesMethod = 17912
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress                                                                                                     OpcuaNodeIdServicesMethod = 17917
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService                                                                                              OpcuaNodeIdServicesMethod = 17918
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService                                                                                                 OpcuaNodeIdServicesMethod = 17919
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress                                                                                                  OpcuaNodeIdServicesMethod = 17924
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService                                                                                           OpcuaNodeIdServicesMethod = 17925
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService                                                                                              OpcuaNodeIdServicesMethod = 17926
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress                                                                                                        OpcuaNodeIdServicesMethod = 17931
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService                                                                                                 OpcuaNodeIdServicesMethod = 17932
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService                                                                                                    OpcuaNodeIdServicesMethod = 17933
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress                                                                                                     OpcuaNodeIdServicesMethod = 17938
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService                                                                                              OpcuaNodeIdServicesMethod = 17939
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService                                                                                                 OpcuaNodeIdServicesMethod = 17940
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress                                                                                                                  OpcuaNodeIdServicesMethod = 17945
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService                                                                                                           OpcuaNodeIdServicesMethod = 17946
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService                                                                                                              OpcuaNodeIdServicesMethod = 17947
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress                                                                                                                 OpcuaNodeIdServicesMethod = 17952
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService                                                                                                          OpcuaNodeIdServicesMethod = 17953
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService                                                                                                             OpcuaNodeIdServicesMethod = 17954
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress                                                                                                           OpcuaNodeIdServicesMethod = 17959
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService                                                                                                    OpcuaNodeIdServicesMethod = 17960
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService                                                                                                       OpcuaNodeIdServicesMethod = 17961
	OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress                                                                                                                      OpcuaNodeIdServicesMethod = 17966
	OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService                                                                                                               OpcuaNodeIdServicesMethod = 17967
	OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService                                                                                                                  OpcuaNodeIdServicesMethod = 17968
	OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter                                                                                                              OpcuaNodeIdServicesMethod = 17969
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress                                                                                                     OpcuaNodeIdServicesMethod = 17973
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService                                                                                              OpcuaNodeIdServicesMethod = 17974
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService                                                                                                 OpcuaNodeIdServicesMethod = 17975
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress                                                                                                               OpcuaNodeIdServicesMethod = 17980
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService                                                                                                        OpcuaNodeIdServicesMethod = 17981
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService                                                                                                           OpcuaNodeIdServicesMethod = 17982
	OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter                                                                                                           OpcuaNodeIdServicesMethod = 17992
	OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType                                                                                                            OpcuaNodeIdServicesMethod = 17994
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential                                                                                               OpcuaNodeIdServicesMethod = 18006
	OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential                                                                                               OpcuaNodeIdServicesMethod = 18008
	OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 18009
	OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Enable                                                                                                                 OpcuaNodeIdServicesMethod = 18074
	OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Disable                                                                                                                OpcuaNodeIdServicesMethod = 18075
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable                                                                                   OpcuaNodeIdServicesMethod = 18090
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable                                                                                  OpcuaNodeIdServicesMethod = 18091
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset                                                                               OpcuaNodeIdServicesMethod = 18104
	OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential                                                                           OpcuaNodeIdServicesMethod = 18161
	OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_DeleteCredential                                                                           OpcuaNodeIdServicesMethod = 18163
	OpcuaNodeIdServicesMethod_AlarmConditionType_Reset                                                                                                                      OpcuaNodeIdServicesMethod = 18199
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset                                                                                       OpcuaNodeIdServicesMethod = 18212
	OpcuaNodeIdServicesMethod_LimitAlarmType_Reset                                                                                                                          OpcuaNodeIdServicesMethod = 18222
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset                                                                                                                 OpcuaNodeIdServicesMethod = 18232
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset                                                                                                              OpcuaNodeIdServicesMethod = 18242
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress                                                                                                         OpcuaNodeIdServicesMethod = 18255
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset                                                                                                              OpcuaNodeIdServicesMethod = 18256
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset                                                                                                                 OpcuaNodeIdServicesMethod = 18266
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset                                                                                                          OpcuaNodeIdServicesMethod = 18276
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset                                                                                                       OpcuaNodeIdServicesMethod = 18286
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset                                                                                                             OpcuaNodeIdServicesMethod = 18296
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset                                                                                                          OpcuaNodeIdServicesMethod = 18306
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset                                                                                                                       OpcuaNodeIdServicesMethod = 18316
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset                                                                                                                      OpcuaNodeIdServicesMethod = 18326
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset                                                                                                                OpcuaNodeIdServicesMethod = 18336
	OpcuaNodeIdServicesMethod_TripAlarmType_Reset                                                                                                                           OpcuaNodeIdServicesMethod = 18346
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Disable                                                                                                         OpcuaNodeIdServicesMethod = 18380
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Enable                                                                                                          OpcuaNodeIdServicesMethod = 18381
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_AddComment                                                                                                      OpcuaNodeIdServicesMethod = 18382
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh                                                                                                OpcuaNodeIdServicesMethod = 18384
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh2                                                                                               OpcuaNodeIdServicesMethod = 18386
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Acknowledge                                                                                                     OpcuaNodeIdServicesMethod = 18406
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Confirm                                                                                                         OpcuaNodeIdServicesMethod = 18408
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve                                                                                       OpcuaNodeIdServicesMethod = 18453
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve                                                                                          OpcuaNodeIdServicesMethod = 18455
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve                                                                                     OpcuaNodeIdServicesMethod = 18456
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Silence                                                                                                         OpcuaNodeIdServicesMethod = 18489
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress                                                                                                        OpcuaNodeIdServicesMethod = 18490
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress                                                                                                      OpcuaNodeIdServicesMethod = 18491
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService                                                                                               OpcuaNodeIdServicesMethod = 18492
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService                                                                                                  OpcuaNodeIdServicesMethod = 18493
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset                                                                                                           OpcuaNodeIdServicesMethod = 18494
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Disable                                                                                                             OpcuaNodeIdServicesMethod = 18529
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Enable                                                                                                              OpcuaNodeIdServicesMethod = 18530
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_AddComment                                                                                                          OpcuaNodeIdServicesMethod = 18531
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh                                                                                                    OpcuaNodeIdServicesMethod = 18533
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh2                                                                                                   OpcuaNodeIdServicesMethod = 18535
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Acknowledge                                                                                                         OpcuaNodeIdServicesMethod = 18555
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Confirm                                                                                                             OpcuaNodeIdServicesMethod = 18557
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve                                                                                           OpcuaNodeIdServicesMethod = 18602
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve                                                                                              OpcuaNodeIdServicesMethod = 18604
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve                                                                                         OpcuaNodeIdServicesMethod = 18605
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Silence                                                                                                             OpcuaNodeIdServicesMethod = 18638
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress                                                                                                            OpcuaNodeIdServicesMethod = 18639
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress                                                                                                          OpcuaNodeIdServicesMethod = 18640
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService                                                                                                   OpcuaNodeIdServicesMethod = 18641
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService                                                                                                      OpcuaNodeIdServicesMethod = 18642
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset                                                                                                               OpcuaNodeIdServicesMethod = 18643
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset                                                                                                          OpcuaNodeIdServicesMethod = 18654
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset                                                                                                                    OpcuaNodeIdServicesMethod = 18664
	OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset                                                                                                                        OpcuaNodeIdServicesMethod = 18666
	OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset                                                                             OpcuaNodeIdServicesMethod = 18679
	OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset                                                                                                        OpcuaNodeIdServicesMethod = 18727
	OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                          OpcuaNodeIdServicesMethod = 18883
	OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                        OpcuaNodeIdServicesMethod = 18942
	OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset                                                                           OpcuaNodeIdServicesMethod = 19001
	OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset                                                                            OpcuaNodeIdServicesMethod = 19119
	OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset                                                                            OpcuaNodeIdServicesMethod = 19188
	OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset                                                                                                        OpcuaNodeIdServicesMethod = 19253
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Disable                                                                                                           OpcuaNodeIdServicesMethod = 19330
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Enable                                                                                                            OpcuaNodeIdServicesMethod = 19331
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_AddComment                                                                                                        OpcuaNodeIdServicesMethod = 19332
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh                                                                                                  OpcuaNodeIdServicesMethod = 19334
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh2                                                                                                 OpcuaNodeIdServicesMethod = 19336
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Acknowledge                                                                                                       OpcuaNodeIdServicesMethod = 19356
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Confirm                                                                                                           OpcuaNodeIdServicesMethod = 19358
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve                                                                                         OpcuaNodeIdServicesMethod = 19403
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve                                                                                            OpcuaNodeIdServicesMethod = 19405
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve                                                                                       OpcuaNodeIdServicesMethod = 19406
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Silence                                                                                                           OpcuaNodeIdServicesMethod = 19439
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress                                                                                                          OpcuaNodeIdServicesMethod = 19440
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress                                                                                                        OpcuaNodeIdServicesMethod = 19441
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService                                                                                                 OpcuaNodeIdServicesMethod = 19442
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService                                                                                                    OpcuaNodeIdServicesMethod = 19443
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset                                                                                                             OpcuaNodeIdServicesMethod = 19444
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable                                                                                               OpcuaNodeIdServicesMethod = 19483
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable                                                                                                OpcuaNodeIdServicesMethod = 19484
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment                                                                                            OpcuaNodeIdServicesMethod = 19485
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge                                                                                           OpcuaNodeIdServicesMethod = 19505
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm                                                                                               OpcuaNodeIdServicesMethod = 19507
	OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset                                                                                                           OpcuaNodeIdServicesMethod = 19562
	OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset                                                                                                           OpcuaNodeIdServicesMethod = 19621
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset                                                                                                                   OpcuaNodeIdServicesMethod = 19689
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsRootType_Reset                                                                                                               OpcuaNodeIdServicesMethod = 19744
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsConnectionType_Reset                                                                                                         OpcuaNodeIdServicesMethod = 19798
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsWriterGroupType_Reset                                                                                                        OpcuaNodeIdServicesMethod = 19846
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsReaderGroupType_Reset                                                                                                        OpcuaNodeIdServicesMethod = 19915
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetWriterType_Reset                                                                                                      OpcuaNodeIdServicesMethod = 19980
	OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetReaderType_Reset                                                                                                      OpcuaNodeIdServicesMethod = 20039
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve                                                                             OpcuaNodeIdServicesMethod = 20097
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve                                                                                OpcuaNodeIdServicesMethod = 20099
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve                                                                           OpcuaNodeIdServicesMethod = 20100
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence                                                                                               OpcuaNodeIdServicesMethod = 20132
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress                                                                                              OpcuaNodeIdServicesMethod = 20133
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress                                                                                            OpcuaNodeIdServicesMethod = 20134
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService                                                                                     OpcuaNodeIdServicesMethod = 20135
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService                                                                                        OpcuaNodeIdServicesMethod = 20136
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset                                                                                                 OpcuaNodeIdServicesMethod = 20137
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable                                                                                               OpcuaNodeIdServicesMethod = 20176
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable                                                                                                OpcuaNodeIdServicesMethod = 20177
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment                                                                                            OpcuaNodeIdServicesMethod = 20178
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge                                                                                           OpcuaNodeIdServicesMethod = 20198
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm                                                                                               OpcuaNodeIdServicesMethod = 20200
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve                                                                             OpcuaNodeIdServicesMethod = 20245
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve                                                                                OpcuaNodeIdServicesMethod = 20247
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve                                                                           OpcuaNodeIdServicesMethod = 20248
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence                                                                                               OpcuaNodeIdServicesMethod = 20280
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress                                                                                              OpcuaNodeIdServicesMethod = 20281
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress                                                                                            OpcuaNodeIdServicesMethod = 20282
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService                                                                                     OpcuaNodeIdServicesMethod = 20283
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService                                                                                        OpcuaNodeIdServicesMethod = 20284
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset                                                                                                 OpcuaNodeIdServicesMethod = 20285
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable                                                                 OpcuaNodeIdServicesMethod = 20324
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable                                                                  OpcuaNodeIdServicesMethod = 20325
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment                                                              OpcuaNodeIdServicesMethod = 20326
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge                                                             OpcuaNodeIdServicesMethod = 20346
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm                                                                 OpcuaNodeIdServicesMethod = 20348
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                               OpcuaNodeIdServicesMethod = 20393
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                                  OpcuaNodeIdServicesMethod = 20395
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                                             OpcuaNodeIdServicesMethod = 20396
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence                                                                 OpcuaNodeIdServicesMethod = 20430
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress                                                                OpcuaNodeIdServicesMethod = 20431
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress                                                              OpcuaNodeIdServicesMethod = 20432
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                                       OpcuaNodeIdServicesMethod = 20433
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService                                                          OpcuaNodeIdServicesMethod = 20434
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset                                                                   OpcuaNodeIdServicesMethod = 20435
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                                 OpcuaNodeIdServicesMethod = 20474
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                                  OpcuaNodeIdServicesMethod = 20475
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                                              OpcuaNodeIdServicesMethod = 20476
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                                             OpcuaNodeIdServicesMethod = 20496
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                                 OpcuaNodeIdServicesMethod = 20498
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                               OpcuaNodeIdServicesMethod = 20543
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                  OpcuaNodeIdServicesMethod = 20545
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                             OpcuaNodeIdServicesMethod = 20546
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                                 OpcuaNodeIdServicesMethod = 20578
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                                OpcuaNodeIdServicesMethod = 20579
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                                              OpcuaNodeIdServicesMethod = 20580
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                                       OpcuaNodeIdServicesMethod = 20581
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                                          OpcuaNodeIdServicesMethod = 20582
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                                   OpcuaNodeIdServicesMethod = 20583
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable                                                                       OpcuaNodeIdServicesMethod = 20622
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable                                                                        OpcuaNodeIdServicesMethod = 20623
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment                                                                    OpcuaNodeIdServicesMethod = 20624
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                                   OpcuaNodeIdServicesMethod = 20644
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm                                                                       OpcuaNodeIdServicesMethod = 20646
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                                     OpcuaNodeIdServicesMethod = 20691
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                                        OpcuaNodeIdServicesMethod = 20693
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                                   OpcuaNodeIdServicesMethod = 20694
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence                                                                       OpcuaNodeIdServicesMethod = 20726
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress                                                                      OpcuaNodeIdServicesMethod = 20727
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                                    OpcuaNodeIdServicesMethod = 20728
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                                             OpcuaNodeIdServicesMethod = 20729
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                                OpcuaNodeIdServicesMethod = 20730
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset                                                                         OpcuaNodeIdServicesMethod = 20731
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                                       OpcuaNodeIdServicesMethod = 20770
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                                        OpcuaNodeIdServicesMethod = 20771
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                                    OpcuaNodeIdServicesMethod = 20772
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                                   OpcuaNodeIdServicesMethod = 20792
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                                       OpcuaNodeIdServicesMethod = 20794
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                     OpcuaNodeIdServicesMethod = 20839
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                        OpcuaNodeIdServicesMethod = 20841
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                                   OpcuaNodeIdServicesMethod = 20842
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                                       OpcuaNodeIdServicesMethod = 20874
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                                      OpcuaNodeIdServicesMethod = 20875
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                                    OpcuaNodeIdServicesMethod = 20876
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                                             OpcuaNodeIdServicesMethod = 20877
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                                OpcuaNodeIdServicesMethod = 20878
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                                         OpcuaNodeIdServicesMethod = 20879
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable                                                                   OpcuaNodeIdServicesMethod = 20918
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable                                                                    OpcuaNodeIdServicesMethod = 20919
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment                                                                OpcuaNodeIdServicesMethod = 20920
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                               OpcuaNodeIdServicesMethod = 20940
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm                                                                   OpcuaNodeIdServicesMethod = 20942
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 20987
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 20989
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 20990
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables                                                                           OpcuaNodeIdServicesMethod = 21009
	OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror                                                                             OpcuaNodeIdServicesMethod = 21012
	OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset                                                                                                             OpcuaNodeIdServicesMethod = 21027
	OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader                                                                                                              OpcuaNodeIdServicesMethod = 21082
	OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader                                                                                                           OpcuaNodeIdServicesMethod = 21085
	OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType                                                                                                            OpcuaNodeIdServicesMethod = 21087
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence                                                                   OpcuaNodeIdServicesMethod = 21225
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress                                                                  OpcuaNodeIdServicesMethod = 21226
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                                OpcuaNodeIdServicesMethod = 21227
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 21228
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                                            OpcuaNodeIdServicesMethod = 21229
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset                                                                     OpcuaNodeIdServicesMethod = 21230
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                                   OpcuaNodeIdServicesMethod = 21269
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                                    OpcuaNodeIdServicesMethod = 21270
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                                OpcuaNodeIdServicesMethod = 21271
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                               OpcuaNodeIdServicesMethod = 21291
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                                   OpcuaNodeIdServicesMethod = 21293
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                                 OpcuaNodeIdServicesMethod = 21338
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                                    OpcuaNodeIdServicesMethod = 21340
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                               OpcuaNodeIdServicesMethod = 21341
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                                   OpcuaNodeIdServicesMethod = 21373
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                                  OpcuaNodeIdServicesMethod = 21374
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                                OpcuaNodeIdServicesMethod = 21375
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                                         OpcuaNodeIdServicesMethod = 21376
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                                            OpcuaNodeIdServicesMethod = 21377
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                                     OpcuaNodeIdServicesMethod = 21378
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable                                                             OpcuaNodeIdServicesMethod = 21417
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable                                                              OpcuaNodeIdServicesMethod = 21418
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment                                                          OpcuaNodeIdServicesMethod = 21419
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge                                                         OpcuaNodeIdServicesMethod = 21439
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm                                                             OpcuaNodeIdServicesMethod = 21441
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve                                           OpcuaNodeIdServicesMethod = 21486
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve                                              OpcuaNodeIdServicesMethod = 21488
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve                                         OpcuaNodeIdServicesMethod = 21489
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence                                                             OpcuaNodeIdServicesMethod = 21521
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress                                                            OpcuaNodeIdServicesMethod = 21522
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress                                                          OpcuaNodeIdServicesMethod = 21523
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService                                                   OpcuaNodeIdServicesMethod = 21524
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService                                                      OpcuaNodeIdServicesMethod = 21525
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset                                                               OpcuaNodeIdServicesMethod = 21526
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable                                                             OpcuaNodeIdServicesMethod = 21565
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable                                                              OpcuaNodeIdServicesMethod = 21566
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment                                                          OpcuaNodeIdServicesMethod = 21567
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge                                                         OpcuaNodeIdServicesMethod = 21587
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm                                                             OpcuaNodeIdServicesMethod = 21589
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve                                           OpcuaNodeIdServicesMethod = 21634
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve                                              OpcuaNodeIdServicesMethod = 21636
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve                                         OpcuaNodeIdServicesMethod = 21637
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence                                                             OpcuaNodeIdServicesMethod = 21669
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress                                                            OpcuaNodeIdServicesMethod = 21670
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress                                                          OpcuaNodeIdServicesMethod = 21671
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService                                                   OpcuaNodeIdServicesMethod = 21672
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService                                                      OpcuaNodeIdServicesMethod = 21673
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset                                                               OpcuaNodeIdServicesMethod = 21674
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                                  OpcuaNodeIdServicesMethod = 21713
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                                   OpcuaNodeIdServicesMethod = 21714
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                                               OpcuaNodeIdServicesMethod = 21715
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                                              OpcuaNodeIdServicesMethod = 21735
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                                  OpcuaNodeIdServicesMethod = 21737
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                OpcuaNodeIdServicesMethod = 21782
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                   OpcuaNodeIdServicesMethod = 21784
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                              OpcuaNodeIdServicesMethod = 21785
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                                  OpcuaNodeIdServicesMethod = 21817
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                                 OpcuaNodeIdServicesMethod = 21818
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                                               OpcuaNodeIdServicesMethod = 21819
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                        OpcuaNodeIdServicesMethod = 21820
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                                           OpcuaNodeIdServicesMethod = 21821
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                                    OpcuaNodeIdServicesMethod = 21822
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                  OpcuaNodeIdServicesMethod = 21861
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                   OpcuaNodeIdServicesMethod = 21862
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                               OpcuaNodeIdServicesMethod = 21863
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                              OpcuaNodeIdServicesMethod = 21883
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                  OpcuaNodeIdServicesMethod = 21885
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                OpcuaNodeIdServicesMethod = 21930
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                   OpcuaNodeIdServicesMethod = 21932
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                              OpcuaNodeIdServicesMethod = 21933
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                  OpcuaNodeIdServicesMethod = 21965
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                 OpcuaNodeIdServicesMethod = 21966
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                               OpcuaNodeIdServicesMethod = 21967
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                        OpcuaNodeIdServicesMethod = 21968
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                           OpcuaNodeIdServicesMethod = 21969
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                    OpcuaNodeIdServicesMethod = 21970
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                                        OpcuaNodeIdServicesMethod = 22009
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                                         OpcuaNodeIdServicesMethod = 22010
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                                     OpcuaNodeIdServicesMethod = 22011
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                    OpcuaNodeIdServicesMethod = 22031
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                                        OpcuaNodeIdServicesMethod = 22033
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                      OpcuaNodeIdServicesMethod = 22078
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                         OpcuaNodeIdServicesMethod = 22080
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                    OpcuaNodeIdServicesMethod = 22081
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                                        OpcuaNodeIdServicesMethod = 22113
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                                       OpcuaNodeIdServicesMethod = 22114
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                     OpcuaNodeIdServicesMethod = 22115
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                              OpcuaNodeIdServicesMethod = 22116
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                 OpcuaNodeIdServicesMethod = 22117
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                                          OpcuaNodeIdServicesMethod = 22118
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                        OpcuaNodeIdServicesMethod = 22157
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                         OpcuaNodeIdServicesMethod = 22158
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                     OpcuaNodeIdServicesMethod = 22159
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                    OpcuaNodeIdServicesMethod = 22179
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                        OpcuaNodeIdServicesMethod = 22181
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                      OpcuaNodeIdServicesMethod = 22226
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                         OpcuaNodeIdServicesMethod = 22228
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                    OpcuaNodeIdServicesMethod = 22229
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                        OpcuaNodeIdServicesMethod = 22261
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                       OpcuaNodeIdServicesMethod = 22262
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                     OpcuaNodeIdServicesMethod = 22263
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                              OpcuaNodeIdServicesMethod = 22264
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                 OpcuaNodeIdServicesMethod = 22265
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                          OpcuaNodeIdServicesMethod = 22266
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                                    OpcuaNodeIdServicesMethod = 22305
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                                     OpcuaNodeIdServicesMethod = 22306
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                                 OpcuaNodeIdServicesMethod = 22307
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                OpcuaNodeIdServicesMethod = 22327
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                                    OpcuaNodeIdServicesMethod = 22329
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                  OpcuaNodeIdServicesMethod = 22374
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                     OpcuaNodeIdServicesMethod = 22376
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                OpcuaNodeIdServicesMethod = 22377
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                                    OpcuaNodeIdServicesMethod = 22409
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                                   OpcuaNodeIdServicesMethod = 22410
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                 OpcuaNodeIdServicesMethod = 22411
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                          OpcuaNodeIdServicesMethod = 22412
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                             OpcuaNodeIdServicesMethod = 22413
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                                      OpcuaNodeIdServicesMethod = 22414
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                    OpcuaNodeIdServicesMethod = 22453
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                     OpcuaNodeIdServicesMethod = 22454
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                 OpcuaNodeIdServicesMethod = 22455
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                OpcuaNodeIdServicesMethod = 22475
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                    OpcuaNodeIdServicesMethod = 22477
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                  OpcuaNodeIdServicesMethod = 22522
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                     OpcuaNodeIdServicesMethod = 22524
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                OpcuaNodeIdServicesMethod = 22525
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                    OpcuaNodeIdServicesMethod = 22557
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                   OpcuaNodeIdServicesMethod = 22558
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                 OpcuaNodeIdServicesMethod = 22559
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                          OpcuaNodeIdServicesMethod = 22560
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                             OpcuaNodeIdServicesMethod = 22561
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                      OpcuaNodeIdServicesMethod = 22562
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                                      OpcuaNodeIdServicesMethod = 22601
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                                       OpcuaNodeIdServicesMethod = 22602
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                                                   OpcuaNodeIdServicesMethod = 22603
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                                                  OpcuaNodeIdServicesMethod = 22623
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                                      OpcuaNodeIdServicesMethod = 22625
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                                    OpcuaNodeIdServicesMethod = 22670
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                                       OpcuaNodeIdServicesMethod = 22672
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                                  OpcuaNodeIdServicesMethod = 22673
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                                      OpcuaNodeIdServicesMethod = 22705
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                                     OpcuaNodeIdServicesMethod = 22706
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                                                   OpcuaNodeIdServicesMethod = 22707
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                            OpcuaNodeIdServicesMethod = 22708
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                                               OpcuaNodeIdServicesMethod = 22709
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                                        OpcuaNodeIdServicesMethod = 22710
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                                      OpcuaNodeIdServicesMethod = 22749
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                                       OpcuaNodeIdServicesMethod = 22750
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                                   OpcuaNodeIdServicesMethod = 22751
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                                  OpcuaNodeIdServicesMethod = 22771
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                                      OpcuaNodeIdServicesMethod = 22773
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                    OpcuaNodeIdServicesMethod = 22818
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                                       OpcuaNodeIdServicesMethod = 22820
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                  OpcuaNodeIdServicesMethod = 22821
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                                      OpcuaNodeIdServicesMethod = 22853
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                                     OpcuaNodeIdServicesMethod = 22854
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                                   OpcuaNodeIdServicesMethod = 22855
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                            OpcuaNodeIdServicesMethod = 22856
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                               OpcuaNodeIdServicesMethod = 22857
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                                        OpcuaNodeIdServicesMethod = 22858
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                                            OpcuaNodeIdServicesMethod = 22897
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                                             OpcuaNodeIdServicesMethod = 22898
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                                         OpcuaNodeIdServicesMethod = 22899
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                                        OpcuaNodeIdServicesMethod = 22919
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                                            OpcuaNodeIdServicesMethod = 22921
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                          OpcuaNodeIdServicesMethod = 22966
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                             OpcuaNodeIdServicesMethod = 22968
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                                        OpcuaNodeIdServicesMethod = 22969
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                                            OpcuaNodeIdServicesMethod = 23001
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                                           OpcuaNodeIdServicesMethod = 23002
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                         OpcuaNodeIdServicesMethod = 23003
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                                  OpcuaNodeIdServicesMethod = 23004
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                                     OpcuaNodeIdServicesMethod = 23005
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                                              OpcuaNodeIdServicesMethod = 23006
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                            OpcuaNodeIdServicesMethod = 23045
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                             OpcuaNodeIdServicesMethod = 23046
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                         OpcuaNodeIdServicesMethod = 23047
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                                        OpcuaNodeIdServicesMethod = 23067
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                            OpcuaNodeIdServicesMethod = 23069
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                          OpcuaNodeIdServicesMethod = 23114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                             OpcuaNodeIdServicesMethod = 23116
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                        OpcuaNodeIdServicesMethod = 23117
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                            OpcuaNodeIdServicesMethod = 23149
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                           OpcuaNodeIdServicesMethod = 23150
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                         OpcuaNodeIdServicesMethod = 23151
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                                  OpcuaNodeIdServicesMethod = 23152
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                                     OpcuaNodeIdServicesMethod = 23153
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                              OpcuaNodeIdServicesMethod = 23154
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                                        OpcuaNodeIdServicesMethod = 23193
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                                         OpcuaNodeIdServicesMethod = 23194
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                                     OpcuaNodeIdServicesMethod = 23195
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                                    OpcuaNodeIdServicesMethod = 23215
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                                        OpcuaNodeIdServicesMethod = 23217
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                                      OpcuaNodeIdServicesMethod = 23262
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                         OpcuaNodeIdServicesMethod = 23264
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                                    OpcuaNodeIdServicesMethod = 23265
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                                        OpcuaNodeIdServicesMethod = 23297
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                                       OpcuaNodeIdServicesMethod = 23298
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                                     OpcuaNodeIdServicesMethod = 23299
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                              OpcuaNodeIdServicesMethod = 23300
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                                 OpcuaNodeIdServicesMethod = 23301
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                                          OpcuaNodeIdServicesMethod = 23302
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                                        OpcuaNodeIdServicesMethod = 23341
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                         OpcuaNodeIdServicesMethod = 23342
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                                     OpcuaNodeIdServicesMethod = 23343
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                                    OpcuaNodeIdServicesMethod = 23363
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                                        OpcuaNodeIdServicesMethod = 23365
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                      OpcuaNodeIdServicesMethod = 23410
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                         OpcuaNodeIdServicesMethod = 23412
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                                    OpcuaNodeIdServicesMethod = 23413
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                                        OpcuaNodeIdServicesMethod = 23445
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                                       OpcuaNodeIdServicesMethod = 23446
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                                     OpcuaNodeIdServicesMethod = 23447
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                              OpcuaNodeIdServicesMethod = 23448
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                                 OpcuaNodeIdServicesMethod = 23449
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                          OpcuaNodeIdServicesMethod = 23450
	OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias                                                                            OpcuaNodeIdServicesMethod = 23459
	OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias                                                                                                               OpcuaNodeIdServicesMethod = 23462
	OpcuaNodeIdServicesMethod_FindAliasMethodType                                                                                                                           OpcuaNodeIdServicesMethod = 23465
	OpcuaNodeIdServicesMethod_Aliases_SubAliasNameCategories_Placeholder_FindAlias                                                                                          OpcuaNodeIdServicesMethod = 23473
	OpcuaNodeIdServicesMethod_Aliases_FindAlias                                                                                                                             OpcuaNodeIdServicesMethod = 23476
	OpcuaNodeIdServicesMethod_TagVariables_SubAliasNameCategories_Placeholder_FindAlias                                                                                     OpcuaNodeIdServicesMethod = 23482
	OpcuaNodeIdServicesMethod_TagVariables_FindAlias                                                                                                                        OpcuaNodeIdServicesMethod = 23485
	OpcuaNodeIdServicesMethod_Topics_SubAliasNameCategories_Placeholder_FindAlias                                                                                           OpcuaNodeIdServicesMethod = 23491
	OpcuaNodeIdServicesMethod_Topics_FindAlias                                                                                                                              OpcuaNodeIdServicesMethod = 23494
	OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList                                                                                                          OpcuaNodeIdServicesMethod = 23526
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList                                                                            OpcuaNodeIdServicesMethod = 23529
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList                                                                                  OpcuaNodeIdServicesMethod = 23531
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList                                                                              OpcuaNodeIdServicesMethod = 23533
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList                                                                        OpcuaNodeIdServicesMethod = 23535
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                                             OpcuaNodeIdServicesMethod = 23544
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                                   OpcuaNodeIdServicesMethod = 23546
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                                               OpcuaNodeIdServicesMethod = 23548
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                                                 OpcuaNodeIdServicesMethod = 23550
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                                       OpcuaNodeIdServicesMethod = 23552
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                                                   OpcuaNodeIdServicesMethod = 23554
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder                                                                                      OpcuaNodeIdServicesMethod = 23637
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder                                                                                   OpcuaNodeIdServicesMethod = 23640
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder                                                                                          OpcuaNodeIdServicesMethod = 23673
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder                                                                                       OpcuaNodeIdServicesMethod = 23676
	OpcuaNodeIdServicesMethod_GetConnectionMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 23726
	OpcuaNodeIdServicesMethod_ModifyConnectionMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 23729
	OpcuaNodeIdServicesMethod_GetWriterGroupMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 23745
	OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 23748
	OpcuaNodeIdServicesMethod_GetReaderGroupMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 23767
	OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType                                                                                                                   OpcuaNodeIdServicesMethod = 23770
	OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 23779
	OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 23781
	OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 23790
	OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 23792
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet                                                      OpcuaNodeIdServicesMethod = 23797
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet                                                   OpcuaNodeIdServicesMethod = 23800
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder                                                          OpcuaNodeIdServicesMethod = 23802
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder                                                       OpcuaNodeIdServicesMethod = 23805
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet                                                                                              OpcuaNodeIdServicesMethod = 23811
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet                                                                                           OpcuaNodeIdServicesMethod = 23814
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder                                                                                                  OpcuaNodeIdServicesMethod = 23816
	OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder                                                                                               OpcuaNodeIdServicesMethod = 23819
	OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType                                                                                                                OpcuaNodeIdServicesMethod = 23821
	OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType                                                                                                             OpcuaNodeIdServicesMethod = 23824
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet                                                                                  OpcuaNodeIdServicesMethod = 24004
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet                                                                               OpcuaNodeIdServicesMethod = 24007
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet                                                                                      OpcuaNodeIdServicesMethod = 24010
	OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet                                                                                   OpcuaNodeIdServicesMethod = 24013
	OpcuaNodeIdServicesMethod_UserManagementType_AddUser                                                                                                                    OpcuaNodeIdServicesMethod = 24269
	OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser                                                                                                                 OpcuaNodeIdServicesMethod = 24271
	OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser                                                                                                                 OpcuaNodeIdServicesMethod = 24273
	OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword                                                                                                             OpcuaNodeIdServicesMethod = 24275
	OpcuaNodeIdServicesMethod_AddUserMethodType                                                                                                                             OpcuaNodeIdServicesMethod = 24282
	OpcuaNodeIdServicesMethod_ModifyUserMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 24284
	OpcuaNodeIdServicesMethod_RemoveUserMethodType                                                                                                                          OpcuaNodeIdServicesMethod = 24286
	OpcuaNodeIdServicesMethod_ChangePasswordMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 24288
	OpcuaNodeIdServicesMethod_UserManagement_AddUser                                                                                                                        OpcuaNodeIdServicesMethod = 24304
	OpcuaNodeIdServicesMethod_UserManagement_ModifyUser                                                                                                                     OpcuaNodeIdServicesMethod = 24306
	OpcuaNodeIdServicesMethod_UserManagement_RemoveUser                                                                                                                     OpcuaNodeIdServicesMethod = 24308
	OpcuaNodeIdServicesMethod_UserManagement_ChangePassword                                                                                                                 OpcuaNodeIdServicesMethod = 24310
	OpcuaNodeIdServicesMethod_DialogConditionType_Respond2                                                                                                                  OpcuaNodeIdServicesMethod = 24312
	OpcuaNodeIdServicesMethod_DialogResponse2MethodType                                                                                                                     OpcuaNodeIdServicesMethod = 24314
	OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2                                                                                                                  OpcuaNodeIdServicesMethod = 24316
	OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2                                                                                                                OpcuaNodeIdServicesMethod = 24318
	OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2                                                                                                         OpcuaNodeIdServicesMethod = 24320
	OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2                                                                                                            OpcuaNodeIdServicesMethod = 24322
	OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2                                                                                                                     OpcuaNodeIdServicesMethod = 24324
	OpcuaNodeIdServicesMethod_WithCommentMethodType                                                                                                                         OpcuaNodeIdServicesMethod = 24326
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2                                                                                   OpcuaNodeIdServicesMethod = 24328
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2                                                                                 OpcuaNodeIdServicesMethod = 24330
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2                                                                          OpcuaNodeIdServicesMethod = 24332
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2                                                                             OpcuaNodeIdServicesMethod = 24334
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2                                                                                      OpcuaNodeIdServicesMethod = 24336
	OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress2                                                                                                                      OpcuaNodeIdServicesMethod = 24338
	OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress2                                                                                                                    OpcuaNodeIdServicesMethod = 24340
	OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService2                                                                                                             OpcuaNodeIdServicesMethod = 24342
	OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService2                                                                                                                OpcuaNodeIdServicesMethod = 24344
	OpcuaNodeIdServicesMethod_LimitAlarmType_Reset2                                                                                                                         OpcuaNodeIdServicesMethod = 24346
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress2                                                                                                             OpcuaNodeIdServicesMethod = 24348
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress2                                                                                                           OpcuaNodeIdServicesMethod = 24350
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService2                                                                                                    OpcuaNodeIdServicesMethod = 24352
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService2                                                                                                       OpcuaNodeIdServicesMethod = 24354
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset2                                                                                                                OpcuaNodeIdServicesMethod = 24356
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress2                                                                                                          OpcuaNodeIdServicesMethod = 24358
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress2                                                                                                        OpcuaNodeIdServicesMethod = 24360
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService2                                                                                                 OpcuaNodeIdServicesMethod = 24362
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService2                                                                                                    OpcuaNodeIdServicesMethod = 24364
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset2                                                                                                             OpcuaNodeIdServicesMethod = 24366
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress2                                                                                                          OpcuaNodeIdServicesMethod = 24368
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress2                                                                                                        OpcuaNodeIdServicesMethod = 24370
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService2                                                                                                 OpcuaNodeIdServicesMethod = 24372
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService2                                                                                                    OpcuaNodeIdServicesMethod = 24374
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset2                                                                                                             OpcuaNodeIdServicesMethod = 24376
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress2                                                                                                             OpcuaNodeIdServicesMethod = 24378
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress2                                                                                                           OpcuaNodeIdServicesMethod = 24380
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService2                                                                                                    OpcuaNodeIdServicesMethod = 24382
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService2                                                                                                       OpcuaNodeIdServicesMethod = 24384
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset2                                                                                                                OpcuaNodeIdServicesMethod = 24386
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress2                                                                                                      OpcuaNodeIdServicesMethod = 24388
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress2                                                                                                    OpcuaNodeIdServicesMethod = 24390
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService2                                                                                             OpcuaNodeIdServicesMethod = 24392
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService2                                                                                                OpcuaNodeIdServicesMethod = 24394
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset2                                                                                                         OpcuaNodeIdServicesMethod = 24396
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress2                                                                                                   OpcuaNodeIdServicesMethod = 24398
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress2                                                                                                 OpcuaNodeIdServicesMethod = 24400
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService2                                                                                          OpcuaNodeIdServicesMethod = 24402
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService2                                                                                             OpcuaNodeIdServicesMethod = 24404
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset2                                                                                                      OpcuaNodeIdServicesMethod = 24406
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress2                                                                                                         OpcuaNodeIdServicesMethod = 24408
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress2                                                                                                       OpcuaNodeIdServicesMethod = 24410
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService2                                                                                                OpcuaNodeIdServicesMethod = 24412
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService2                                                                                                   OpcuaNodeIdServicesMethod = 24414
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset2                                                                                                            OpcuaNodeIdServicesMethod = 24416
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress2                                                                                                      OpcuaNodeIdServicesMethod = 24418
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress2                                                                                                    OpcuaNodeIdServicesMethod = 24420
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService2                                                                                             OpcuaNodeIdServicesMethod = 24422
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService2                                                                                                OpcuaNodeIdServicesMethod = 24424
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset2                                                                                                         OpcuaNodeIdServicesMethod = 24426
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress2                                                                                                                   OpcuaNodeIdServicesMethod = 24428
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress2                                                                                                                 OpcuaNodeIdServicesMethod = 24430
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService2                                                                                                          OpcuaNodeIdServicesMethod = 24432
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService2                                                                                                             OpcuaNodeIdServicesMethod = 24434
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset2                                                                                                                      OpcuaNodeIdServicesMethod = 24436
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress2                                                                                                                  OpcuaNodeIdServicesMethod = 24438
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress2                                                                                                                OpcuaNodeIdServicesMethod = 24440
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService2                                                                                                         OpcuaNodeIdServicesMethod = 24442
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService2                                                                                                            OpcuaNodeIdServicesMethod = 24444
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset2                                                                                                                     OpcuaNodeIdServicesMethod = 24446
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress2                                                                                                            OpcuaNodeIdServicesMethod = 24448
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress2                                                                                                          OpcuaNodeIdServicesMethod = 24450
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService2                                                                                                   OpcuaNodeIdServicesMethod = 24452
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService2                                                                                                      OpcuaNodeIdServicesMethod = 24454
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset2                                                                                                               OpcuaNodeIdServicesMethod = 24456
	OpcuaNodeIdServicesMethod_TripAlarmType_Suppress2                                                                                                                       OpcuaNodeIdServicesMethod = 24458
	OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress2                                                                                                                     OpcuaNodeIdServicesMethod = 24460
	OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService2                                                                                                              OpcuaNodeIdServicesMethod = 24462
	OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService2                                                                                                                 OpcuaNodeIdServicesMethod = 24464
	OpcuaNodeIdServicesMethod_TripAlarmType_Reset2                                                                                                                          OpcuaNodeIdServicesMethod = 24466
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress2                                                                                                       OpcuaNodeIdServicesMethod = 24468
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress2                                                                                                     OpcuaNodeIdServicesMethod = 24470
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService2                                                                                              OpcuaNodeIdServicesMethod = 24472
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService2                                                                                                 OpcuaNodeIdServicesMethod = 24474
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset2                                                                                                          OpcuaNodeIdServicesMethod = 24476
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress2                                                                                                           OpcuaNodeIdServicesMethod = 24478
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress2                                                                                                         OpcuaNodeIdServicesMethod = 24480
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService2                                                                                                  OpcuaNodeIdServicesMethod = 24482
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService2                                                                                                     OpcuaNodeIdServicesMethod = 24484
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset2                                                                                                              OpcuaNodeIdServicesMethod = 24486
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress2                                                                                                      OpcuaNodeIdServicesMethod = 24488
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress2                                                                                                    OpcuaNodeIdServicesMethod = 24490
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService2                                                                                             OpcuaNodeIdServicesMethod = 24492
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService2                                                                                                OpcuaNodeIdServicesMethod = 24494
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset2                                                                                                         OpcuaNodeIdServicesMethod = 24496
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress2                                                                                                                OpcuaNodeIdServicesMethod = 24498
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress2                                                                                                              OpcuaNodeIdServicesMethod = 24500
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService2                                                                                                       OpcuaNodeIdServicesMethod = 24502
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService2                                                                                                          OpcuaNodeIdServicesMethod = 24504
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset2                                                                                                                   OpcuaNodeIdServicesMethod = 24506
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress2                                                                                                         OpcuaNodeIdServicesMethod = 24508
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress2                                                                                                       OpcuaNodeIdServicesMethod = 24510
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService2                                                                                                OpcuaNodeIdServicesMethod = 24512
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService2                                                                                                   OpcuaNodeIdServicesMethod = 24514
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset2                                                                                                            OpcuaNodeIdServicesMethod = 24516
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2                                                                                             OpcuaNodeIdServicesMethod = 24518
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2                                                                                           OpcuaNodeIdServicesMethod = 24520
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2                                                                                    OpcuaNodeIdServicesMethod = 24522
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2                                                                                       OpcuaNodeIdServicesMethod = 24524
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2                                                                                                OpcuaNodeIdServicesMethod = 24526
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2                                                                                             OpcuaNodeIdServicesMethod = 24528
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2                                                                                           OpcuaNodeIdServicesMethod = 24530
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2                                                                                    OpcuaNodeIdServicesMethod = 24532
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2                                                                                       OpcuaNodeIdServicesMethod = 24534
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2                                                                                                OpcuaNodeIdServicesMethod = 24536
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2                                                               OpcuaNodeIdServicesMethod = 24538
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                                             OpcuaNodeIdServicesMethod = 24540
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                                      OpcuaNodeIdServicesMethod = 24542
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                                         OpcuaNodeIdServicesMethod = 24544
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2                                                                  OpcuaNodeIdServicesMethod = 24546
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                               OpcuaNodeIdServicesMethod = 24548
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                                             OpcuaNodeIdServicesMethod = 24550
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                                      OpcuaNodeIdServicesMethod = 24552
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                                         OpcuaNodeIdServicesMethod = 24554
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                                  OpcuaNodeIdServicesMethod = 24556
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2                                                                     OpcuaNodeIdServicesMethod = 24558
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                                   OpcuaNodeIdServicesMethod = 24560
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                                            OpcuaNodeIdServicesMethod = 24562
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                               OpcuaNodeIdServicesMethod = 24564
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2                                                                        OpcuaNodeIdServicesMethod = 24566
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                                     OpcuaNodeIdServicesMethod = 24568
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                                   OpcuaNodeIdServicesMethod = 24570
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                                            OpcuaNodeIdServicesMethod = 24572
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                               OpcuaNodeIdServicesMethod = 24574
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                                        OpcuaNodeIdServicesMethod = 24576
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24578
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24580
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24582
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24584
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2                                                                    OpcuaNodeIdServicesMethod = 24586
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                                 OpcuaNodeIdServicesMethod = 24588
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                               OpcuaNodeIdServicesMethod = 24590
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                                        OpcuaNodeIdServicesMethod = 24592
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                                           OpcuaNodeIdServicesMethod = 24594
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                                    OpcuaNodeIdServicesMethod = 24596
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2                                                           OpcuaNodeIdServicesMethod = 24598
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2                                                         OpcuaNodeIdServicesMethod = 24600
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2                                                  OpcuaNodeIdServicesMethod = 24602
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2                                                     OpcuaNodeIdServicesMethod = 24604
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2                                                              OpcuaNodeIdServicesMethod = 24606
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2                                                           OpcuaNodeIdServicesMethod = 24608
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2                                                         OpcuaNodeIdServicesMethod = 24610
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2                                                  OpcuaNodeIdServicesMethod = 24612
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2                                                     OpcuaNodeIdServicesMethod = 24614
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2                                                              OpcuaNodeIdServicesMethod = 24616
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                                                OpcuaNodeIdServicesMethod = 24618
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                              OpcuaNodeIdServicesMethod = 24620
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                       OpcuaNodeIdServicesMethod = 24622
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                          OpcuaNodeIdServicesMethod = 24624
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                                   OpcuaNodeIdServicesMethod = 24626
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                OpcuaNodeIdServicesMethod = 24628
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                              OpcuaNodeIdServicesMethod = 24630
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                       OpcuaNodeIdServicesMethod = 24632
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                          OpcuaNodeIdServicesMethod = 24634
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                   OpcuaNodeIdServicesMethod = 24636
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                                      OpcuaNodeIdServicesMethod = 24638
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                    OpcuaNodeIdServicesMethod = 24640
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                             OpcuaNodeIdServicesMethod = 24642
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                OpcuaNodeIdServicesMethod = 24644
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                                         OpcuaNodeIdServicesMethod = 24646
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                      OpcuaNodeIdServicesMethod = 24648
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                    OpcuaNodeIdServicesMethod = 24650
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                             OpcuaNodeIdServicesMethod = 24652
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                OpcuaNodeIdServicesMethod = 24654
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                         OpcuaNodeIdServicesMethod = 24656
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                  OpcuaNodeIdServicesMethod = 24658
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                OpcuaNodeIdServicesMethod = 24660
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                         OpcuaNodeIdServicesMethod = 24662
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                            OpcuaNodeIdServicesMethod = 24664
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                                     OpcuaNodeIdServicesMethod = 24666
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                  OpcuaNodeIdServicesMethod = 24668
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                OpcuaNodeIdServicesMethod = 24670
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                         OpcuaNodeIdServicesMethod = 24672
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                            OpcuaNodeIdServicesMethod = 24674
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                     OpcuaNodeIdServicesMethod = 24676
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                                                    OpcuaNodeIdServicesMethod = 24678
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                                  OpcuaNodeIdServicesMethod = 24680
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                           OpcuaNodeIdServicesMethod = 24682
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                              OpcuaNodeIdServicesMethod = 24684
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                                       OpcuaNodeIdServicesMethod = 24686
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                                    OpcuaNodeIdServicesMethod = 24688
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                                  OpcuaNodeIdServicesMethod = 24690
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                           OpcuaNodeIdServicesMethod = 24692
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                              OpcuaNodeIdServicesMethod = 24694
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                                       OpcuaNodeIdServicesMethod = 24696
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                                          OpcuaNodeIdServicesMethod = 24698
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                                        OpcuaNodeIdServicesMethod = 24700
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                                 OpcuaNodeIdServicesMethod = 24702
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                                    OpcuaNodeIdServicesMethod = 24704
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                                             OpcuaNodeIdServicesMethod = 24706
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                          OpcuaNodeIdServicesMethod = 24708
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                                        OpcuaNodeIdServicesMethod = 24710
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                                 OpcuaNodeIdServicesMethod = 24712
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                                    OpcuaNodeIdServicesMethod = 24714
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                             OpcuaNodeIdServicesMethod = 24716
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                                      OpcuaNodeIdServicesMethod = 24718
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                                    OpcuaNodeIdServicesMethod = 24720
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                             OpcuaNodeIdServicesMethod = 24722
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                                OpcuaNodeIdServicesMethod = 24724
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                                         OpcuaNodeIdServicesMethod = 24726
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                                      OpcuaNodeIdServicesMethod = 24728
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                                    OpcuaNodeIdServicesMethod = 24730
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                             OpcuaNodeIdServicesMethod = 24732
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                                OpcuaNodeIdServicesMethod = 24734
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                         OpcuaNodeIdServicesMethod = 24736
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2                                                                                                 OpcuaNodeIdServicesMethod = 24738
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2                                                                                                    OpcuaNodeIdServicesMethod = 24740
	OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2                                                                                               OpcuaNodeIdServicesMethod = 24742
	OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships                                                                                                        OpcuaNodeIdServicesMethod = 24744
	OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 24746
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2                                                                  OpcuaNodeIdServicesMethod = 24748
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2                                                                     OpcuaNodeIdServicesMethod = 24750
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2                                                                OpcuaNodeIdServicesMethod = 24752
	OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships                                                                         OpcuaNodeIdServicesMethod = 24754
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2                                                                                                          OpcuaNodeIdServicesMethod = 24756
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2                                                                                                             OpcuaNodeIdServicesMethod = 24758
	OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2                                                                                                        OpcuaNodeIdServicesMethod = 24760
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve2                                                                                                     OpcuaNodeIdServicesMethod = 24762
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve2                                                                                                        OpcuaNodeIdServicesMethod = 24764
	OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve2                                                                                                   OpcuaNodeIdServicesMethod = 24766
	OpcuaNodeIdServicesMethod_LimitAlarmType_GetGroupMemberships                                                                                                            OpcuaNodeIdServicesMethod = 24768
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2                                                                                            OpcuaNodeIdServicesMethod = 24778
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve2                                                                                               OpcuaNodeIdServicesMethod = 24780
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2                                                                                          OpcuaNodeIdServicesMethod = 24782
	OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_GetGroupMemberships                                                                                                   OpcuaNodeIdServicesMethod = 24784
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2                                                                                         OpcuaNodeIdServicesMethod = 24794
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2                                                                                            OpcuaNodeIdServicesMethod = 24796
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2                                                                                       OpcuaNodeIdServicesMethod = 24798
	OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_GetGroupMemberships                                                                                                OpcuaNodeIdServicesMethod = 24800
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2                                                                                         OpcuaNodeIdServicesMethod = 24810
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2                                                                                            OpcuaNodeIdServicesMethod = 24812
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2                                                                                       OpcuaNodeIdServicesMethod = 24814
	OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_GetGroupMemberships                                                                                                OpcuaNodeIdServicesMethod = 24816
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2                                                                                            OpcuaNodeIdServicesMethod = 24826
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve2                                                                                               OpcuaNodeIdServicesMethod = 24828
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2                                                                                          OpcuaNodeIdServicesMethod = 24830
	OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_GetGroupMemberships                                                                                                   OpcuaNodeIdServicesMethod = 24832
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2                                                                                     OpcuaNodeIdServicesMethod = 24842
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2                                                                                        OpcuaNodeIdServicesMethod = 24844
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2                                                                                   OpcuaNodeIdServicesMethod = 24846
	OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_GetGroupMemberships                                                                                            OpcuaNodeIdServicesMethod = 24848
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2                                                                                  OpcuaNodeIdServicesMethod = 24858
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2                                                                                     OpcuaNodeIdServicesMethod = 24860
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2                                                                                OpcuaNodeIdServicesMethod = 24862
	OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships                                                                                         OpcuaNodeIdServicesMethod = 24864
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2                                                                                        OpcuaNodeIdServicesMethod = 24874
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2                                                                                           OpcuaNodeIdServicesMethod = 24876
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2                                                                                      OpcuaNodeIdServicesMethod = 24878
	OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_GetGroupMemberships                                                                                               OpcuaNodeIdServicesMethod = 24880
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2                                                                                     OpcuaNodeIdServicesMethod = 24890
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2                                                                                        OpcuaNodeIdServicesMethod = 24892
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2                                                                                   OpcuaNodeIdServicesMethod = 24894
	OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_GetGroupMemberships                                                                                            OpcuaNodeIdServicesMethod = 24896
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve2                                                                                                  OpcuaNodeIdServicesMethod = 24906
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve2                                                                                                     OpcuaNodeIdServicesMethod = 24908
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve2                                                                                                OpcuaNodeIdServicesMethod = 24910
	OpcuaNodeIdServicesMethod_DiscreteAlarmType_GetGroupMemberships                                                                                                         OpcuaNodeIdServicesMethod = 24912
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve2                                                                                                 OpcuaNodeIdServicesMethod = 24914
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve2                                                                                                    OpcuaNodeIdServicesMethod = 24916
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve2                                                                                               OpcuaNodeIdServicesMethod = 24918
	OpcuaNodeIdServicesMethod_OffNormalAlarmType_GetGroupMemberships                                                                                                        OpcuaNodeIdServicesMethod = 24920
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve2                                                                                           OpcuaNodeIdServicesMethod = 24922
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve2                                                                                              OpcuaNodeIdServicesMethod = 24924
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve2                                                                                         OpcuaNodeIdServicesMethod = 24926
	OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_GetGroupMemberships                                                                                                  OpcuaNodeIdServicesMethod = 24928
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve2                                                                                                      OpcuaNodeIdServicesMethod = 24930
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve2                                                                                                         OpcuaNodeIdServicesMethod = 24932
	OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve2                                                                                                    OpcuaNodeIdServicesMethod = 24934
	OpcuaNodeIdServicesMethod_TripAlarmType_GetGroupMemberships                                                                                                             OpcuaNodeIdServicesMethod = 24936
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2                                                                                      OpcuaNodeIdServicesMethod = 24938
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2                                                                                         OpcuaNodeIdServicesMethod = 24940
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2                                                                                    OpcuaNodeIdServicesMethod = 24942
	OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_GetGroupMemberships                                                                                             OpcuaNodeIdServicesMethod = 24944
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve2                                                                                          OpcuaNodeIdServicesMethod = 24946
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve2                                                                                             OpcuaNodeIdServicesMethod = 24948
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve2                                                                                        OpcuaNodeIdServicesMethod = 24950
	OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_GetGroupMemberships                                                                                                 OpcuaNodeIdServicesMethod = 24952
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve2                                                                                     OpcuaNodeIdServicesMethod = 24954
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve2                                                                                        OpcuaNodeIdServicesMethod = 24956
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2                                                                                   OpcuaNodeIdServicesMethod = 24958
	OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_GetGroupMemberships                                                                                            OpcuaNodeIdServicesMethod = 24960
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve2                                                                                               OpcuaNodeIdServicesMethod = 24962
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve2                                                                                                  OpcuaNodeIdServicesMethod = 24964
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve2                                                                                             OpcuaNodeIdServicesMethod = 24966
	OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_GetGroupMemberships                                                                                                      OpcuaNodeIdServicesMethod = 24968
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2                                                                                        OpcuaNodeIdServicesMethod = 24970
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2                                                                                           OpcuaNodeIdServicesMethod = 24972
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2                                                                                      OpcuaNodeIdServicesMethod = 24974
	OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_GetGroupMemberships                                                                                               OpcuaNodeIdServicesMethod = 24976
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2                                                                            OpcuaNodeIdServicesMethod = 24978
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2                                                                               OpcuaNodeIdServicesMethod = 24980
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2                                                                          OpcuaNodeIdServicesMethod = 24982
	OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships                                                                                   OpcuaNodeIdServicesMethod = 24984
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2                                                                            OpcuaNodeIdServicesMethod = 24986
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2                                                                               OpcuaNodeIdServicesMethod = 24988
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                                          OpcuaNodeIdServicesMethod = 24990
	OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships                                                                                   OpcuaNodeIdServicesMethod = 24992
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                                              OpcuaNodeIdServicesMethod = 24994
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                                 OpcuaNodeIdServicesMethod = 24996
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                                            OpcuaNodeIdServicesMethod = 24998
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                                     OpcuaNodeIdServicesMethod = 25000
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                              OpcuaNodeIdServicesMethod = 25002
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                 OpcuaNodeIdServicesMethod = 25004
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                            OpcuaNodeIdServicesMethod = 25006
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                                     OpcuaNodeIdServicesMethod = 25008
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                                    OpcuaNodeIdServicesMethod = 25010
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                                       OpcuaNodeIdServicesMethod = 25012
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                                  OpcuaNodeIdServicesMethod = 25014
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                                           OpcuaNodeIdServicesMethod = 25016
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                    OpcuaNodeIdServicesMethod = 25018
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                       OpcuaNodeIdServicesMethod = 25020
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                                  OpcuaNodeIdServicesMethod = 25022
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                                           OpcuaNodeIdServicesMethod = 25024
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25026
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25028
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25030
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25032
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                                OpcuaNodeIdServicesMethod = 25034
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                                   OpcuaNodeIdServicesMethod = 25036
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                              OpcuaNodeIdServicesMethod = 25038
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                                       OpcuaNodeIdServicesMethod = 25040
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2                                          OpcuaNodeIdServicesMethod = 25042
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2                                             OpcuaNodeIdServicesMethod = 25044
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2                                        OpcuaNodeIdServicesMethod = 25046
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships                                                 OpcuaNodeIdServicesMethod = 25048
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2                                          OpcuaNodeIdServicesMethod = 25050
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2                                             OpcuaNodeIdServicesMethod = 25052
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2                                        OpcuaNodeIdServicesMethod = 25054
	OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships                                                 OpcuaNodeIdServicesMethod = 25056
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                               OpcuaNodeIdServicesMethod = 25058
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                  OpcuaNodeIdServicesMethod = 25060
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                             OpcuaNodeIdServicesMethod = 25062
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                      OpcuaNodeIdServicesMethod = 25064
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                               OpcuaNodeIdServicesMethod = 25066
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                  OpcuaNodeIdServicesMethod = 25068
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                             OpcuaNodeIdServicesMethod = 25070
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                      OpcuaNodeIdServicesMethod = 25072
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                     OpcuaNodeIdServicesMethod = 25074
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                        OpcuaNodeIdServicesMethod = 25076
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                   OpcuaNodeIdServicesMethod = 25078
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                            OpcuaNodeIdServicesMethod = 25080
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                     OpcuaNodeIdServicesMethod = 25082
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                        OpcuaNodeIdServicesMethod = 25084
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                   OpcuaNodeIdServicesMethod = 25086
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                            OpcuaNodeIdServicesMethod = 25088
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                 OpcuaNodeIdServicesMethod = 25090
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                    OpcuaNodeIdServicesMethod = 25092
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                               OpcuaNodeIdServicesMethod = 25094
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                        OpcuaNodeIdServicesMethod = 25096
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                 OpcuaNodeIdServicesMethod = 25098
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                    OpcuaNodeIdServicesMethod = 25100
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                               OpcuaNodeIdServicesMethod = 25102
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                        OpcuaNodeIdServicesMethod = 25104
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                                   OpcuaNodeIdServicesMethod = 25106
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                                      OpcuaNodeIdServicesMethod = 25108
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                                 OpcuaNodeIdServicesMethod = 25110
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                          OpcuaNodeIdServicesMethod = 25112
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                   OpcuaNodeIdServicesMethod = 25114
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                      OpcuaNodeIdServicesMethod = 25116
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                 OpcuaNodeIdServicesMethod = 25118
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                          OpcuaNodeIdServicesMethod = 25120
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                         OpcuaNodeIdServicesMethod = 25122
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                            OpcuaNodeIdServicesMethod = 25124
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                                       OpcuaNodeIdServicesMethod = 25126
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                                OpcuaNodeIdServicesMethod = 25128
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                         OpcuaNodeIdServicesMethod = 25130
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                            OpcuaNodeIdServicesMethod = 25132
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                       OpcuaNodeIdServicesMethod = 25134
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                                OpcuaNodeIdServicesMethod = 25136
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                                     OpcuaNodeIdServicesMethod = 25138
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                                        OpcuaNodeIdServicesMethod = 25140
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                                   OpcuaNodeIdServicesMethod = 25142
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                            OpcuaNodeIdServicesMethod = 25144
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                     OpcuaNodeIdServicesMethod = 25146
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                        OpcuaNodeIdServicesMethod = 25148
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                                   OpcuaNodeIdServicesMethod = 25150
	OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                            OpcuaNodeIdServicesMethod = 25152
	OpcuaNodeIdServicesMethod_TimedShelve2MethodType                                                                                                                        OpcuaNodeIdServicesMethod = 25157
	OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry                                                                                              OpcuaNodeIdServicesMethod = 25229
	OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry                                                                                           OpcuaNodeIdServicesMethod = 25231
	OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType                                                                                                             OpcuaNodeIdServicesMethod = 25233
	OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType                                                                                                          OpcuaNodeIdServicesMethod = 25235
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder                                                                                    OpcuaNodeIdServicesMethod = 25271
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder                                                                                 OpcuaNodeIdServicesMethod = 25274
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget                                                                                             OpcuaNodeIdServicesMethod = 25278
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget                                                                                          OpcuaNodeIdServicesMethod = 25281
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder                                                                                       OpcuaNodeIdServicesMethod = 25283
	OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder                                                                                    OpcuaNodeIdServicesMethod = 25286
	OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType                                                                                                              OpcuaNodeIdServicesMethod = 25288
	OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType                                                                                                           OpcuaNodeIdServicesMethod = 25291
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder                                                            OpcuaNodeIdServicesMethod = 25293
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder                                                         OpcuaNodeIdServicesMethod = 25296
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder                                                                                                OpcuaNodeIdServicesMethod = 25312
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder                                                                                             OpcuaNodeIdServicesMethod = 25315
	OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType                                                                                                               OpcuaNodeIdServicesMethod = 25331
	OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType                                                                                                            OpcuaNodeIdServicesMethod = 25334
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget                                                                  OpcuaNodeIdServicesMethod = 25348
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget                                                               OpcuaNodeIdServicesMethod = 25351
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder                                                            OpcuaNodeIdServicesMethod = 25353
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder                                                         OpcuaNodeIdServicesMethod = 25356
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget                                                                                                   OpcuaNodeIdServicesMethod = 25366
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget                                                                                                OpcuaNodeIdServicesMethod = 25369
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder                                                                                             OpcuaNodeIdServicesMethod = 25371
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder                                                                                          OpcuaNodeIdServicesMethod = 25374
	OpcuaNodeIdServicesMethod_AddPushTargetMethodType                                                                                                                       OpcuaNodeIdServicesMethod = 25376
	OpcuaNodeIdServicesMethod_RemovePushTargetMethodType                                                                                                                    OpcuaNodeIdServicesMethod = 25379
	OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType                                                                                                                 OpcuaNodeIdServicesMethod = 25381
	OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType                                                                                                              OpcuaNodeIdServicesMethod = 25384
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder                                                                                    OpcuaNodeIdServicesMethod = 25386
	OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder                                                                                 OpcuaNodeIdServicesMethod = 25389
	OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTarget                                                                                             OpcuaNodeIdServicesMethod = 25393
	OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTarget                                                                                          OpcuaNodeIdServicesMethod = 25396
	OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder                                                                                       OpcuaNodeIdServicesMethod = 25398
	OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder                                                                                    OpcuaNodeIdServicesMethod = 25401
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open                                                                                                 OpcuaNodeIdServicesMethod = 25411
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close                                                                                                OpcuaNodeIdServicesMethod = 25414
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read                                                                                                 OpcuaNodeIdServicesMethod = 25416
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write                                                                                                OpcuaNodeIdServicesMethod = 25419
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition                                                                                          OpcuaNodeIdServicesMethod = 25421
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition                                                                                          OpcuaNodeIdServicesMethod = 25424
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds                                                                                           OpcuaNodeIdServicesMethod = 25426
	OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate                                                                                       OpcuaNodeIdServicesMethod = 25429
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder                                                                                        OpcuaNodeIdServicesMethod = 25434
	OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder                                                                                     OpcuaNodeIdServicesMethod = 25437
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget                                                                                                 OpcuaNodeIdServicesMethod = 25441
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget                                                                                              OpcuaNodeIdServicesMethod = 25444
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder                                                                                           OpcuaNodeIdServicesMethod = 25446
	OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder                                                                                        OpcuaNodeIdServicesMethod = 25449
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open                                                                                                     OpcuaNodeIdServicesMethod = 25459
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close                                                                                                    OpcuaNodeIdServicesMethod = 25462
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read                                                                                                     OpcuaNodeIdServicesMethod = 25464
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write                                                                                                    OpcuaNodeIdServicesMethod = 25467
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition                                                                                              OpcuaNodeIdServicesMethod = 25469
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition                                                                                              OpcuaNodeIdServicesMethod = 25472
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds                                                                                               OpcuaNodeIdServicesMethod = 25474
	OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate                                                                                           OpcuaNodeIdServicesMethod = 25477
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_Open                                                                                                                  OpcuaNodeIdServicesMethod = 25490
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_Close                                                                                                                 OpcuaNodeIdServicesMethod = 25493
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_Read                                                                                                                  OpcuaNodeIdServicesMethod = 25495
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_Write                                                                                                                 OpcuaNodeIdServicesMethod = 25498
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_GetPosition                                                                                                           OpcuaNodeIdServicesMethod = 25500
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_SetPosition                                                                                                           OpcuaNodeIdServicesMethod = 25503
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds                                                                                                            OpcuaNodeIdServicesMethod = 25505
	OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate                                                                                                        OpcuaNodeIdServicesMethod = 25508
	OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType                                                                                                   OpcuaNodeIdServicesMethod = 25511
	OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType                                                                                               OpcuaNodeIdServicesMethod = 25514
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity                                                                                              OpcuaNodeIdServicesMethod = 25572
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity                                                                                           OpcuaNodeIdServicesMethod = 25574
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication                                                                                           OpcuaNodeIdServicesMethod = 25576
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication                                                                                        OpcuaNodeIdServicesMethod = 25578
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint                                                                                              OpcuaNodeIdServicesMethod = 25580
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint                                                                                           OpcuaNodeIdServicesMethod = 25582
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity                                                                                               OpcuaNodeIdServicesMethod = 25591
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity                                                                                            OpcuaNodeIdServicesMethod = 25593
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication                                                                                            OpcuaNodeIdServicesMethod = 25595
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication                                                                                         OpcuaNodeIdServicesMethod = 25597
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint                                                                                               OpcuaNodeIdServicesMethod = 25599
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint                                                                                            OpcuaNodeIdServicesMethod = 25601
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity                                                                                             OpcuaNodeIdServicesMethod = 25610
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity                                                                                          OpcuaNodeIdServicesMethod = 25612
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication                                                                                          OpcuaNodeIdServicesMethod = 25614
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication                                                                                       OpcuaNodeIdServicesMethod = 25616
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint                                                                                             OpcuaNodeIdServicesMethod = 25618
	OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint                                                                                          OpcuaNodeIdServicesMethod = 25620
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys                                                                          OpcuaNodeIdServicesMethod = 25622
	OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation                                                                        OpcuaNodeIdServicesMethod = 25623
	OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys                                                                                                              OpcuaNodeIdServicesMethod = 25624
	OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation                                                                                                            OpcuaNodeIdServicesMethod = 25625
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys                                                                          OpcuaNodeIdServicesMethod = 25632
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation                                                                        OpcuaNodeIdServicesMethod = 25633
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups                                                                                                 OpcuaNodeIdServicesMethod = 25641
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups                                                                                              OpcuaNodeIdServicesMethod = 25644
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate                                                                                                      OpcuaNodeIdServicesMethod = 25647
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups                                                                OpcuaNodeIdServicesMethod = 25655
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups                                                             OpcuaNodeIdServicesMethod = 25658
	OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate                                                                     OpcuaNodeIdServicesMethod = 25661
	OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges                                                                                                         OpcuaNodeIdServicesMethod = 25698
	OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults                                                                                                 OpcuaNodeIdServicesMethod = 25699
	OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges                                                                                                             OpcuaNodeIdServicesMethod = 25708
	OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults                                                                                                     OpcuaNodeIdServicesMethod = 25709
	OpcuaNodeIdServicesMethod_ServerConfiguration_SetAdminPassword                                                                                                          OpcuaNodeIdServicesMethod = 25710
	OpcuaNodeIdServicesMethod_RequestTicketsMethodType                                                                                                                      OpcuaNodeIdServicesMethod = 25727
	OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType                                                                                                               OpcuaNodeIdServicesMethod = 25729
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                                         OpcuaNodeIdServicesMethod = 25742
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                                        OpcuaNodeIdServicesMethod = 25745
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                                         OpcuaNodeIdServicesMethod = 25747
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                                        OpcuaNodeIdServicesMethod = 25750
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                                  OpcuaNodeIdServicesMethod = 25752
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                                  OpcuaNodeIdServicesMethod = 25755
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                                OpcuaNodeIdServicesMethod = 25760
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                               OpcuaNodeIdServicesMethod = 25763
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                               OpcuaNodeIdServicesMethod = 25766
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                                            OpcuaNodeIdServicesMethod = 25768
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                                        OpcuaNodeIdServicesMethod = 25772
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                                             OpcuaNodeIdServicesMethod = 25807
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                                              OpcuaNodeIdServicesMethod = 25808
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                                          OpcuaNodeIdServicesMethod = 25809
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                                         OpcuaNodeIdServicesMethod = 25829
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                                             OpcuaNodeIdServicesMethod = 25831
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve                           OpcuaNodeIdServicesMethod = 25876
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2                          OpcuaNodeIdServicesMethod = 25878
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve                              OpcuaNodeIdServicesMethod = 25880
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2                             OpcuaNodeIdServicesMethod = 25881
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve                         OpcuaNodeIdServicesMethod = 25883
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2                        OpcuaNodeIdServicesMethod = 25884
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                                             OpcuaNodeIdServicesMethod = 25917
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                                            OpcuaNodeIdServicesMethod = 25918
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                                           OpcuaNodeIdServicesMethod = 25919
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                                          OpcuaNodeIdServicesMethod = 25921
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                                         OpcuaNodeIdServicesMethod = 25922
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                                   OpcuaNodeIdServicesMethod = 25924
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2                                  OpcuaNodeIdServicesMethod = 25925
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                                      OpcuaNodeIdServicesMethod = 25927
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                                     OpcuaNodeIdServicesMethod = 25928
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                                               OpcuaNodeIdServicesMethod = 25930
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                                              OpcuaNodeIdServicesMethod = 25931
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships                                 OpcuaNodeIdServicesMethod = 25933
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                                             OpcuaNodeIdServicesMethod = 25973
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                                              OpcuaNodeIdServicesMethod = 25974
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                                          OpcuaNodeIdServicesMethod = 25975
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                                         OpcuaNodeIdServicesMethod = 25995
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                                             OpcuaNodeIdServicesMethod = 25997
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve                           OpcuaNodeIdServicesMethod = 26042
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                          OpcuaNodeIdServicesMethod = 26044
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve                              OpcuaNodeIdServicesMethod = 26046
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2                             OpcuaNodeIdServicesMethod = 26047
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                         OpcuaNodeIdServicesMethod = 26049
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                        OpcuaNodeIdServicesMethod = 26050
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                                             OpcuaNodeIdServicesMethod = 26083
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                                            OpcuaNodeIdServicesMethod = 26084
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                                           OpcuaNodeIdServicesMethod = 26085
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                                          OpcuaNodeIdServicesMethod = 26087
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                                         OpcuaNodeIdServicesMethod = 26088
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                                   OpcuaNodeIdServicesMethod = 26090
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2                                  OpcuaNodeIdServicesMethod = 26091
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                                      OpcuaNodeIdServicesMethod = 26093
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                                     OpcuaNodeIdServicesMethod = 26094
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                                               OpcuaNodeIdServicesMethod = 26096
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                                              OpcuaNodeIdServicesMethod = 26097
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships                                 OpcuaNodeIdServicesMethod = 26099
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                               OpcuaNodeIdServicesMethod = 26114
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                                              OpcuaNodeIdServicesMethod = 26117
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                               OpcuaNodeIdServicesMethod = 26119
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                                              OpcuaNodeIdServicesMethod = 26122
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                                        OpcuaNodeIdServicesMethod = 26124
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                                        OpcuaNodeIdServicesMethod = 26127
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                                      OpcuaNodeIdServicesMethod = 26132
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                     OpcuaNodeIdServicesMethod = 26135
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                                     OpcuaNodeIdServicesMethod = 26138
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                                  OpcuaNodeIdServicesMethod = 26140
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                                              OpcuaNodeIdServicesMethod = 26144
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                                   OpcuaNodeIdServicesMethod = 26179
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                                    OpcuaNodeIdServicesMethod = 26180
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                                                OpcuaNodeIdServicesMethod = 26181
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                                               OpcuaNodeIdServicesMethod = 26201
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                                   OpcuaNodeIdServicesMethod = 26203
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve                                 OpcuaNodeIdServicesMethod = 26248
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2                                OpcuaNodeIdServicesMethod = 26250
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                                    OpcuaNodeIdServicesMethod = 26252
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                                   OpcuaNodeIdServicesMethod = 26253
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve                               OpcuaNodeIdServicesMethod = 26255
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2                              OpcuaNodeIdServicesMethod = 26256
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                                   OpcuaNodeIdServicesMethod = 26289
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                                                  OpcuaNodeIdServicesMethod = 26290
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                                                 OpcuaNodeIdServicesMethod = 26291
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                                                OpcuaNodeIdServicesMethod = 26293
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                                               OpcuaNodeIdServicesMethod = 26294
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                                         OpcuaNodeIdServicesMethod = 26296
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                                        OpcuaNodeIdServicesMethod = 26297
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                                            OpcuaNodeIdServicesMethod = 26299
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                                           OpcuaNodeIdServicesMethod = 26300
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                                     OpcuaNodeIdServicesMethod = 26302
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                                    OpcuaNodeIdServicesMethod = 26303
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                                       OpcuaNodeIdServicesMethod = 26305
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                                   OpcuaNodeIdServicesMethod = 26345
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                                    OpcuaNodeIdServicesMethod = 26346
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                                                OpcuaNodeIdServicesMethod = 26347
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                                               OpcuaNodeIdServicesMethod = 26367
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                                   OpcuaNodeIdServicesMethod = 26369
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve                                 OpcuaNodeIdServicesMethod = 26414
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                                OpcuaNodeIdServicesMethod = 26416
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                                    OpcuaNodeIdServicesMethod = 26418
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                                   OpcuaNodeIdServicesMethod = 26419
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                               OpcuaNodeIdServicesMethod = 26421
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                              OpcuaNodeIdServicesMethod = 26422
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                                   OpcuaNodeIdServicesMethod = 26455
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                                                  OpcuaNodeIdServicesMethod = 26456
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                                                 OpcuaNodeIdServicesMethod = 26457
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                                                OpcuaNodeIdServicesMethod = 26459
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                                               OpcuaNodeIdServicesMethod = 26460
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                                         OpcuaNodeIdServicesMethod = 26462
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                                        OpcuaNodeIdServicesMethod = 26463
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                                            OpcuaNodeIdServicesMethod = 26465
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                                           OpcuaNodeIdServicesMethod = 26466
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                                     OpcuaNodeIdServicesMethod = 26468
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                                    OpcuaNodeIdServicesMethod = 26469
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                                       OpcuaNodeIdServicesMethod = 26471
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                                           OpcuaNodeIdServicesMethod = 26486
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                                          OpcuaNodeIdServicesMethod = 26489
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                                           OpcuaNodeIdServicesMethod = 26491
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                                          OpcuaNodeIdServicesMethod = 26494
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                                    OpcuaNodeIdServicesMethod = 26496
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                                    OpcuaNodeIdServicesMethod = 26499
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                                  OpcuaNodeIdServicesMethod = 26504
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                                 OpcuaNodeIdServicesMethod = 26507
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                                 OpcuaNodeIdServicesMethod = 26510
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                                              OpcuaNodeIdServicesMethod = 26512
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                                          OpcuaNodeIdServicesMethod = 26516
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                                               OpcuaNodeIdServicesMethod = 26551
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                                                OpcuaNodeIdServicesMethod = 26552
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                                            OpcuaNodeIdServicesMethod = 26553
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                                           OpcuaNodeIdServicesMethod = 26573
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                                               OpcuaNodeIdServicesMethod = 26575
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve                             OpcuaNodeIdServicesMethod = 26620
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2                            OpcuaNodeIdServicesMethod = 26622
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve                                OpcuaNodeIdServicesMethod = 26624
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2                               OpcuaNodeIdServicesMethod = 26625
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve                           OpcuaNodeIdServicesMethod = 26627
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2                          OpcuaNodeIdServicesMethod = 26628
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                                               OpcuaNodeIdServicesMethod = 26661
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                                              OpcuaNodeIdServicesMethod = 26662
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                                             OpcuaNodeIdServicesMethod = 26663
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                                            OpcuaNodeIdServicesMethod = 26665
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                                           OpcuaNodeIdServicesMethod = 26666
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                                     OpcuaNodeIdServicesMethod = 26668
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                                    OpcuaNodeIdServicesMethod = 26669
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                                        OpcuaNodeIdServicesMethod = 26671
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                                       OpcuaNodeIdServicesMethod = 26672
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                                                 OpcuaNodeIdServicesMethod = 26674
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                                                OpcuaNodeIdServicesMethod = 26675
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                                   OpcuaNodeIdServicesMethod = 26677
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                                               OpcuaNodeIdServicesMethod = 26717
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                                                OpcuaNodeIdServicesMethod = 26718
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                                            OpcuaNodeIdServicesMethod = 26719
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                                           OpcuaNodeIdServicesMethod = 26739
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                                               OpcuaNodeIdServicesMethod = 26741
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve                             OpcuaNodeIdServicesMethod = 26786
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2                            OpcuaNodeIdServicesMethod = 26788
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve                                OpcuaNodeIdServicesMethod = 26790
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2                               OpcuaNodeIdServicesMethod = 26791
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve                           OpcuaNodeIdServicesMethod = 26793
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2                          OpcuaNodeIdServicesMethod = 26794
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                                               OpcuaNodeIdServicesMethod = 26827
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                                              OpcuaNodeIdServicesMethod = 26828
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                                             OpcuaNodeIdServicesMethod = 26829
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                                            OpcuaNodeIdServicesMethod = 26831
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                                           OpcuaNodeIdServicesMethod = 26832
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                                     OpcuaNodeIdServicesMethod = 26834
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                                    OpcuaNodeIdServicesMethod = 26835
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                                        OpcuaNodeIdServicesMethod = 26837
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                                       OpcuaNodeIdServicesMethod = 26838
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                                                 OpcuaNodeIdServicesMethod = 26840
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                                                OpcuaNodeIdServicesMethod = 26841
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                                   OpcuaNodeIdServicesMethod = 26843
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_UpdateCertificate                                                                                                OpcuaNodeIdServicesMethod = 26858
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ApplyChanges                                                                                                     OpcuaNodeIdServicesMethod = 26861
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CancelChanges                                                                                                    OpcuaNodeIdServicesMethod = 26862
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CreateSigningRequest                                                                                             OpcuaNodeIdServicesMethod = 26863
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetRejectedList                                                                                                  OpcuaNodeIdServicesMethod = 26866
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ResetToServerDefaults                                                                                            OpcuaNodeIdServicesMethod = 26868
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets                                                                                                        OpcuaNodeIdServicesMethod = 26873
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints                                                                                                 OpcuaNodeIdServicesMethod = 26875
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                  OpcuaNodeIdServicesMethod = 26889
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                 OpcuaNodeIdServicesMethod = 26892
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                  OpcuaNodeIdServicesMethod = 26894
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                 OpcuaNodeIdServicesMethod = 26897
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                           OpcuaNodeIdServicesMethod = 26899
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                           OpcuaNodeIdServicesMethod = 26902
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                         OpcuaNodeIdServicesMethod = 26907
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                        OpcuaNodeIdServicesMethod = 26910
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                        OpcuaNodeIdServicesMethod = 26913
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                     OpcuaNodeIdServicesMethod = 26915
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                 OpcuaNodeIdServicesMethod = 26919
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                      OpcuaNodeIdServicesMethod = 26954
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                       OpcuaNodeIdServicesMethod = 26955
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                   OpcuaNodeIdServicesMethod = 26956
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                  OpcuaNodeIdServicesMethod = 26976
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                      OpcuaNodeIdServicesMethod = 26978
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve    OpcuaNodeIdServicesMethod = 27023
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2   OpcuaNodeIdServicesMethod = 27025
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve       OpcuaNodeIdServicesMethod = 27027
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2      OpcuaNodeIdServicesMethod = 27028
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve  OpcuaNodeIdServicesMethod = 27030
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2 OpcuaNodeIdServicesMethod = 27031
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                      OpcuaNodeIdServicesMethod = 27064
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                     OpcuaNodeIdServicesMethod = 27065
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                    OpcuaNodeIdServicesMethod = 27066
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                   OpcuaNodeIdServicesMethod = 27068
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                  OpcuaNodeIdServicesMethod = 27069
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService            OpcuaNodeIdServicesMethod = 27071
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2           OpcuaNodeIdServicesMethod = 27072
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService               OpcuaNodeIdServicesMethod = 27074
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2              OpcuaNodeIdServicesMethod = 27075
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                        OpcuaNodeIdServicesMethod = 27077
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                       OpcuaNodeIdServicesMethod = 27078
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships          OpcuaNodeIdServicesMethod = 27080
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                      OpcuaNodeIdServicesMethod = 27120
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                       OpcuaNodeIdServicesMethod = 27121
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                   OpcuaNodeIdServicesMethod = 27122
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                  OpcuaNodeIdServicesMethod = 27142
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                      OpcuaNodeIdServicesMethod = 27144
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve    OpcuaNodeIdServicesMethod = 27189
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2   OpcuaNodeIdServicesMethod = 27191
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve       OpcuaNodeIdServicesMethod = 27193
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2      OpcuaNodeIdServicesMethod = 27194
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve  OpcuaNodeIdServicesMethod = 27196
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2 OpcuaNodeIdServicesMethod = 27197
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                      OpcuaNodeIdServicesMethod = 27230
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                     OpcuaNodeIdServicesMethod = 27231
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                    OpcuaNodeIdServicesMethod = 27232
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                   OpcuaNodeIdServicesMethod = 27234
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                  OpcuaNodeIdServicesMethod = 27235
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService            OpcuaNodeIdServicesMethod = 27237
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2           OpcuaNodeIdServicesMethod = 27238
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService               OpcuaNodeIdServicesMethod = 27240
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2              OpcuaNodeIdServicesMethod = 27241
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                        OpcuaNodeIdServicesMethod = 27243
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                       OpcuaNodeIdServicesMethod = 27244
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships          OpcuaNodeIdServicesMethod = 27246
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                        OpcuaNodeIdServicesMethod = 27261
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                       OpcuaNodeIdServicesMethod = 27264
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                        OpcuaNodeIdServicesMethod = 27266
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                       OpcuaNodeIdServicesMethod = 27269
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                 OpcuaNodeIdServicesMethod = 27271
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                 OpcuaNodeIdServicesMethod = 27274
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                               OpcuaNodeIdServicesMethod = 27279
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                              OpcuaNodeIdServicesMethod = 27282
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                              OpcuaNodeIdServicesMethod = 27285
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                           OpcuaNodeIdServicesMethod = 27287
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                       OpcuaNodeIdServicesMethod = 27291
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                            OpcuaNodeIdServicesMethod = 27326
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                             OpcuaNodeIdServicesMethod = 27327
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                         OpcuaNodeIdServicesMethod = 27328
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                        OpcuaNodeIdServicesMethod = 27348
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                            OpcuaNodeIdServicesMethod = 27350
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 27395
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 27397
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 27399
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 27400
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 27402
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 27403
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                            OpcuaNodeIdServicesMethod = 27436
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                           OpcuaNodeIdServicesMethod = 27437
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                          OpcuaNodeIdServicesMethod = 27438
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                         OpcuaNodeIdServicesMethod = 27440
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                        OpcuaNodeIdServicesMethod = 27441
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                  OpcuaNodeIdServicesMethod = 27443
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                 OpcuaNodeIdServicesMethod = 27444
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                     OpcuaNodeIdServicesMethod = 27446
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                    OpcuaNodeIdServicesMethod = 27447
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                              OpcuaNodeIdServicesMethod = 27449
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                             OpcuaNodeIdServicesMethod = 27450
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                OpcuaNodeIdServicesMethod = 27452
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                            OpcuaNodeIdServicesMethod = 27492
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                             OpcuaNodeIdServicesMethod = 27493
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                         OpcuaNodeIdServicesMethod = 27494
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                        OpcuaNodeIdServicesMethod = 27514
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                            OpcuaNodeIdServicesMethod = 27516
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 27561
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 27563
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 27565
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 27566
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 27568
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 27569
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                            OpcuaNodeIdServicesMethod = 27602
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                           OpcuaNodeIdServicesMethod = 27603
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                          OpcuaNodeIdServicesMethod = 27604
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                         OpcuaNodeIdServicesMethod = 27606
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                        OpcuaNodeIdServicesMethod = 27607
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                  OpcuaNodeIdServicesMethod = 27609
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                 OpcuaNodeIdServicesMethod = 27610
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                     OpcuaNodeIdServicesMethod = 27612
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                    OpcuaNodeIdServicesMethod = 27613
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                              OpcuaNodeIdServicesMethod = 27615
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                             OpcuaNodeIdServicesMethod = 27616
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                OpcuaNodeIdServicesMethod = 27618
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                    OpcuaNodeIdServicesMethod = 27633
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                   OpcuaNodeIdServicesMethod = 27636
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                    OpcuaNodeIdServicesMethod = 27638
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                   OpcuaNodeIdServicesMethod = 27641
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                             OpcuaNodeIdServicesMethod = 27643
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                             OpcuaNodeIdServicesMethod = 27646
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                           OpcuaNodeIdServicesMethod = 27651
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                          OpcuaNodeIdServicesMethod = 27654
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                          OpcuaNodeIdServicesMethod = 27657
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                       OpcuaNodeIdServicesMethod = 27659
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                   OpcuaNodeIdServicesMethod = 27663
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                        OpcuaNodeIdServicesMethod = 27698
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                         OpcuaNodeIdServicesMethod = 27699
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                     OpcuaNodeIdServicesMethod = 27700
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                    OpcuaNodeIdServicesMethod = 27720
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                        OpcuaNodeIdServicesMethod = 27722
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve      OpcuaNodeIdServicesMethod = 27767
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2     OpcuaNodeIdServicesMethod = 27769
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve         OpcuaNodeIdServicesMethod = 27771
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2        OpcuaNodeIdServicesMethod = 27772
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve    OpcuaNodeIdServicesMethod = 27774
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2   OpcuaNodeIdServicesMethod = 27775
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                        OpcuaNodeIdServicesMethod = 27808
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                       OpcuaNodeIdServicesMethod = 27809
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                      OpcuaNodeIdServicesMethod = 27810
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                     OpcuaNodeIdServicesMethod = 27812
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                    OpcuaNodeIdServicesMethod = 27813
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService              OpcuaNodeIdServicesMethod = 27815
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2             OpcuaNodeIdServicesMethod = 27816
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                 OpcuaNodeIdServicesMethod = 27818
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                OpcuaNodeIdServicesMethod = 27819
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                          OpcuaNodeIdServicesMethod = 27821
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                         OpcuaNodeIdServicesMethod = 27822
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships            OpcuaNodeIdServicesMethod = 27824
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                        OpcuaNodeIdServicesMethod = 27864
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                         OpcuaNodeIdServicesMethod = 27865
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                     OpcuaNodeIdServicesMethod = 27866
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                    OpcuaNodeIdServicesMethod = 27886
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                        OpcuaNodeIdServicesMethod = 27888
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve      OpcuaNodeIdServicesMethod = 27933
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2     OpcuaNodeIdServicesMethod = 27935
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve         OpcuaNodeIdServicesMethod = 27937
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2        OpcuaNodeIdServicesMethod = 27938
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve    OpcuaNodeIdServicesMethod = 27940
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2   OpcuaNodeIdServicesMethod = 27941
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                        OpcuaNodeIdServicesMethod = 27974
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                       OpcuaNodeIdServicesMethod = 27975
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                      OpcuaNodeIdServicesMethod = 27976
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                     OpcuaNodeIdServicesMethod = 27978
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                    OpcuaNodeIdServicesMethod = 27979
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService              OpcuaNodeIdServicesMethod = 27981
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2             OpcuaNodeIdServicesMethod = 27982
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                 OpcuaNodeIdServicesMethod = 27984
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                OpcuaNodeIdServicesMethod = 27985
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                          OpcuaNodeIdServicesMethod = 27987
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                         OpcuaNodeIdServicesMethod = 27988
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships            OpcuaNodeIdServicesMethod = 27990
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate                                                                         OpcuaNodeIdServicesMethod = 28005
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges                                                                              OpcuaNodeIdServicesMethod = 28008
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges                                                                             OpcuaNodeIdServicesMethod = 28009
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest                                                                      OpcuaNodeIdServicesMethod = 28010
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList                                                                           OpcuaNodeIdServicesMethod = 28013
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults                                                                     OpcuaNodeIdServicesMethod = 28015
	OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets                                                                                                            OpcuaNodeIdServicesMethod = 29880
	OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints                                                                                                     OpcuaNodeIdServicesMethod = 29882
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                      OpcuaNodeIdServicesMethod = 29896
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                     OpcuaNodeIdServicesMethod = 29899
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                      OpcuaNodeIdServicesMethod = 29901
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                     OpcuaNodeIdServicesMethod = 29904
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                               OpcuaNodeIdServicesMethod = 29906
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                               OpcuaNodeIdServicesMethod = 29909
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                             OpcuaNodeIdServicesMethod = 29914
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                            OpcuaNodeIdServicesMethod = 29917
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                            OpcuaNodeIdServicesMethod = 29920
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                         OpcuaNodeIdServicesMethod = 29922
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList                                     OpcuaNodeIdServicesMethod = 29926
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable                          OpcuaNodeIdServicesMethod = 29961
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable                           OpcuaNodeIdServicesMethod = 29962
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment                       OpcuaNodeIdServicesMethod = 29963
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge                      OpcuaNodeIdServicesMethod = 29983
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm                          OpcuaNodeIdServicesMethod = 29985
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve        OpcuaNodeIdServicesMethod = 30030
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2       OpcuaNodeIdServicesMethod = 30032
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve           OpcuaNodeIdServicesMethod = 30034
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2          OpcuaNodeIdServicesMethod = 30035
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve      OpcuaNodeIdServicesMethod = 30037
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2     OpcuaNodeIdServicesMethod = 30038
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence                          OpcuaNodeIdServicesMethod = 30071
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress                         OpcuaNodeIdServicesMethod = 30072
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2                        OpcuaNodeIdServicesMethod = 30073
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress                       OpcuaNodeIdServicesMethod = 30075
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2                      OpcuaNodeIdServicesMethod = 30076
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService                OpcuaNodeIdServicesMethod = 30078
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2               OpcuaNodeIdServicesMethod = 30079
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService                   OpcuaNodeIdServicesMethod = 30081
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2                  OpcuaNodeIdServicesMethod = 30082
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset                            OpcuaNodeIdServicesMethod = 30084
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2                           OpcuaNodeIdServicesMethod = 30085
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships              OpcuaNodeIdServicesMethod = 30087
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable                          OpcuaNodeIdServicesMethod = 30127
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable                           OpcuaNodeIdServicesMethod = 30128
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment                       OpcuaNodeIdServicesMethod = 30129
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge                      OpcuaNodeIdServicesMethod = 30149
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm                          OpcuaNodeIdServicesMethod = 30151
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve        OpcuaNodeIdServicesMethod = 30196
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2       OpcuaNodeIdServicesMethod = 30198
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve           OpcuaNodeIdServicesMethod = 30200
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2          OpcuaNodeIdServicesMethod = 30201
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve      OpcuaNodeIdServicesMethod = 30203
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2     OpcuaNodeIdServicesMethod = 30204
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence                          OpcuaNodeIdServicesMethod = 30237
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress                         OpcuaNodeIdServicesMethod = 30238
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2                        OpcuaNodeIdServicesMethod = 30239
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress                       OpcuaNodeIdServicesMethod = 30241
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2                      OpcuaNodeIdServicesMethod = 30242
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService                OpcuaNodeIdServicesMethod = 30244
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2               OpcuaNodeIdServicesMethod = 30245
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService                   OpcuaNodeIdServicesMethod = 30247
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2                  OpcuaNodeIdServicesMethod = 30248
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset                            OpcuaNodeIdServicesMethod = 30250
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2                           OpcuaNodeIdServicesMethod = 30251
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships              OpcuaNodeIdServicesMethod = 30253
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                            OpcuaNodeIdServicesMethod = 30268
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                           OpcuaNodeIdServicesMethod = 30271
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                            OpcuaNodeIdServicesMethod = 30273
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                           OpcuaNodeIdServicesMethod = 30276
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                     OpcuaNodeIdServicesMethod = 30278
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                     OpcuaNodeIdServicesMethod = 30281
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                   OpcuaNodeIdServicesMethod = 30286
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                  OpcuaNodeIdServicesMethod = 30289
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                  OpcuaNodeIdServicesMethod = 30292
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                               OpcuaNodeIdServicesMethod = 30294
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList                                           OpcuaNodeIdServicesMethod = 30298
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable                                OpcuaNodeIdServicesMethod = 30333
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable                                 OpcuaNodeIdServicesMethod = 30334
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment                             OpcuaNodeIdServicesMethod = 30335
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge                            OpcuaNodeIdServicesMethod = 30355
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm                                OpcuaNodeIdServicesMethod = 30357
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve              OpcuaNodeIdServicesMethod = 30402
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2             OpcuaNodeIdServicesMethod = 30404
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve                 OpcuaNodeIdServicesMethod = 30406
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2                OpcuaNodeIdServicesMethod = 30407
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve            OpcuaNodeIdServicesMethod = 30409
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2           OpcuaNodeIdServicesMethod = 30410
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence                                OpcuaNodeIdServicesMethod = 30443
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress                               OpcuaNodeIdServicesMethod = 30444
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2                              OpcuaNodeIdServicesMethod = 30445
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress                             OpcuaNodeIdServicesMethod = 30447
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2                            OpcuaNodeIdServicesMethod = 30448
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService                      OpcuaNodeIdServicesMethod = 30450
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2                     OpcuaNodeIdServicesMethod = 30451
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService                         OpcuaNodeIdServicesMethod = 30453
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2                        OpcuaNodeIdServicesMethod = 30454
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset                                  OpcuaNodeIdServicesMethod = 30456
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2                                 OpcuaNodeIdServicesMethod = 30457
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships                    OpcuaNodeIdServicesMethod = 30459
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable                                OpcuaNodeIdServicesMethod = 30499
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable                                 OpcuaNodeIdServicesMethod = 30500
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment                             OpcuaNodeIdServicesMethod = 30501
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge                            OpcuaNodeIdServicesMethod = 30521
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm                                OpcuaNodeIdServicesMethod = 30523
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve              OpcuaNodeIdServicesMethod = 30568
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2             OpcuaNodeIdServicesMethod = 30570
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve                 OpcuaNodeIdServicesMethod = 30572
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2                OpcuaNodeIdServicesMethod = 30573
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve            OpcuaNodeIdServicesMethod = 30575
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2           OpcuaNodeIdServicesMethod = 30576
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence                                OpcuaNodeIdServicesMethod = 30609
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress                               OpcuaNodeIdServicesMethod = 30610
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2                              OpcuaNodeIdServicesMethod = 30611
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress                             OpcuaNodeIdServicesMethod = 30613
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2                            OpcuaNodeIdServicesMethod = 30614
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService                      OpcuaNodeIdServicesMethod = 30616
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2                     OpcuaNodeIdServicesMethod = 30617
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService                         OpcuaNodeIdServicesMethod = 30619
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2                        OpcuaNodeIdServicesMethod = 30620
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset                                  OpcuaNodeIdServicesMethod = 30622
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2                                 OpcuaNodeIdServicesMethod = 30623
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships                    OpcuaNodeIdServicesMethod = 30625
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                        OpcuaNodeIdServicesMethod = 30640
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                       OpcuaNodeIdServicesMethod = 30643
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                        OpcuaNodeIdServicesMethod = 30645
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                       OpcuaNodeIdServicesMethod = 30648
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                 OpcuaNodeIdServicesMethod = 30650
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                 OpcuaNodeIdServicesMethod = 30653
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                               OpcuaNodeIdServicesMethod = 30658
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                              OpcuaNodeIdServicesMethod = 30661
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                              OpcuaNodeIdServicesMethod = 30664
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                           OpcuaNodeIdServicesMethod = 30666
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList                                       OpcuaNodeIdServicesMethod = 30670
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable                            OpcuaNodeIdServicesMethod = 30705
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable                             OpcuaNodeIdServicesMethod = 30706
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment                         OpcuaNodeIdServicesMethod = 30707
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge                        OpcuaNodeIdServicesMethod = 30727
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm                            OpcuaNodeIdServicesMethod = 30729
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 30774
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 30776
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 30778
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 30779
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 30781
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 30782
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence                            OpcuaNodeIdServicesMethod = 30815
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress                           OpcuaNodeIdServicesMethod = 30816
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2                          OpcuaNodeIdServicesMethod = 30817
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress                         OpcuaNodeIdServicesMethod = 30819
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2                        OpcuaNodeIdServicesMethod = 30820
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService                  OpcuaNodeIdServicesMethod = 30822
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2                 OpcuaNodeIdServicesMethod = 30823
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService                     OpcuaNodeIdServicesMethod = 30825
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2                    OpcuaNodeIdServicesMethod = 30826
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset                              OpcuaNodeIdServicesMethod = 30828
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2                             OpcuaNodeIdServicesMethod = 30829
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships                OpcuaNodeIdServicesMethod = 30831
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable                            OpcuaNodeIdServicesMethod = 30871
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable                             OpcuaNodeIdServicesMethod = 30872
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment                         OpcuaNodeIdServicesMethod = 30873
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge                        OpcuaNodeIdServicesMethod = 30893
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm                            OpcuaNodeIdServicesMethod = 30895
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve          OpcuaNodeIdServicesMethod = 30940
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2         OpcuaNodeIdServicesMethod = 30942
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve             OpcuaNodeIdServicesMethod = 30944
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2            OpcuaNodeIdServicesMethod = 30945
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve        OpcuaNodeIdServicesMethod = 30947
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2       OpcuaNodeIdServicesMethod = 30948
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence                            OpcuaNodeIdServicesMethod = 30981
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress                           OpcuaNodeIdServicesMethod = 30982
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2                          OpcuaNodeIdServicesMethod = 30983
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress                         OpcuaNodeIdServicesMethod = 30985
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2                        OpcuaNodeIdServicesMethod = 30986
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService                  OpcuaNodeIdServicesMethod = 30988
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2                 OpcuaNodeIdServicesMethod = 30989
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService                     OpcuaNodeIdServicesMethod = 30991
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2                    OpcuaNodeIdServicesMethod = 30992
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset                              OpcuaNodeIdServicesMethod = 30994
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2                             OpcuaNodeIdServicesMethod = 30995
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships                OpcuaNodeIdServicesMethod = 30997
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate                                                                             OpcuaNodeIdServicesMethod = 31384
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ApplyChanges                                                                                  OpcuaNodeIdServicesMethod = 31387
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CancelChanges                                                                                 OpcuaNodeIdServicesMethod = 31388
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest                                                                          OpcuaNodeIdServicesMethod = 31389
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList                                                                               OpcuaNodeIdServicesMethod = 31392
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ResetToServerDefaults                                                                         OpcuaNodeIdServicesMethod = 31394
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Disable                                                                          OpcuaNodeIdServicesMethod = 32098
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Enable                                                                           OpcuaNodeIdServicesMethod = 32099
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment                                                                       OpcuaNodeIdServicesMethod = 32100
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge                                                                      OpcuaNodeIdServicesMethod = 32120
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm                                                                          OpcuaNodeIdServicesMethod = 32122
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve                                                        OpcuaNodeIdServicesMethod = 32167
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2                                                       OpcuaNodeIdServicesMethod = 32169
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve                                                           OpcuaNodeIdServicesMethod = 32171
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2                                                          OpcuaNodeIdServicesMethod = 32172
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve                                                      OpcuaNodeIdServicesMethod = 32174
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2                                                     OpcuaNodeIdServicesMethod = 32175
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Silence                                                                          OpcuaNodeIdServicesMethod = 32208
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress                                                                         OpcuaNodeIdServicesMethod = 32209
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2                                                                        OpcuaNodeIdServicesMethod = 32210
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress                                                                       OpcuaNodeIdServicesMethod = 32212
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2                                                                      OpcuaNodeIdServicesMethod = 32213
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService                                                                OpcuaNodeIdServicesMethod = 32215
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2                                                               OpcuaNodeIdServicesMethod = 32216
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService                                                                   OpcuaNodeIdServicesMethod = 32218
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2                                                                  OpcuaNodeIdServicesMethod = 32219
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset                                                                            OpcuaNodeIdServicesMethod = 32221
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2                                                                           OpcuaNodeIdServicesMethod = 32222
	OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships                                                              OpcuaNodeIdServicesMethod = 32224
	OpcuaNodeIdServicesMethod_GetCertificatesMethodType                                                                                                                     OpcuaNodeIdServicesMethod = 32282
	OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates                                                                                                       OpcuaNodeIdServicesMethod = 32296
	OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates                                                                                                           OpcuaNodeIdServicesMethod = 32333
	OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetCertificates                                                                                                  OpcuaNodeIdServicesMethod = 32346
	OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates                                                                           OpcuaNodeIdServicesMethod = 32359
	OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetCertificates                                                                               OpcuaNodeIdServicesMethod = 32372
	OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityKeys                                                                                                                OpcuaNodeIdServicesMethod = 32406
	OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityGroup                                                                                                               OpcuaNodeIdServicesMethod = 32409
	OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroup                                                                                                OpcuaNodeIdServicesMethod = 32413
	OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroup                                                                                             OpcuaNodeIdServicesMethod = 32416
	OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroupFolder                                                                                          OpcuaNodeIdServicesMethod = 32418
	OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroupFolder                                                                                       OpcuaNodeIdServicesMethod = 32421
	OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTarget                                                                                                   OpcuaNodeIdServicesMethod = 32425
	OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTarget                                                                                                OpcuaNodeIdServicesMethod = 32428
	OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTargetFolder                                                                                             OpcuaNodeIdServicesMethod = 32430
	OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTargetFolder                                                                                          OpcuaNodeIdServicesMethod = 32433
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Enable                                                                                       OpcuaNodeIdServicesMethod = 32450
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Disable                                                                                      OpcuaNodeIdServicesMethod = 32451
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Reset                                                                                   OpcuaNodeIdServicesMethod = 32464
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddWriterGroup                                                                                      OpcuaNodeIdServicesMethod = 32500
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddReaderGroup                                                                                      OpcuaNodeIdServicesMethod = 32503
	OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_RemoveGroup                                                                                         OpcuaNodeIdServicesMethod = 32506
	OpcuaNodeIdServicesMethod_DataSetClasses_SetSecurityKeys                                                                                                                OpcuaNodeIdServicesMethod = 32508
	OpcuaNodeIdServicesMethod_DataSetClasses_AddConnection                                                                                                                  OpcuaNodeIdServicesMethod = 32510
	OpcuaNodeIdServicesMethod_DataSetClasses_RemoveConnection                                                                                                               OpcuaNodeIdServicesMethod = 32513
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItems                                                                                        OpcuaNodeIdServicesMethod = 32516
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEvents                                                                                           OpcuaNodeIdServicesMethod = 32519
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate                                                                                OpcuaNodeIdServicesMethod = 32522
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate                                                                                   OpcuaNodeIdServicesMethod = 32525
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemovePublishedDataSet                                                                                       OpcuaNodeIdServicesMethod = 32528
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddDataSetFolder                                                                                             OpcuaNodeIdServicesMethod = 32530
	OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemoveDataSetFolder                                                                                          OpcuaNodeIdServicesMethod = 32533
	OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddSubscribedDataSet                                                                                        OpcuaNodeIdServicesMethod = 32536
	OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveSubscribedDataSet                                                                                     OpcuaNodeIdServicesMethod = 32539
	OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddDataSetFolder                                                                                            OpcuaNodeIdServicesMethod = 32541
	OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveDataSetFolder                                                                                         OpcuaNodeIdServicesMethod = 32544
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Open                                                                                                       OpcuaNodeIdServicesMethod = 32554
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Close                                                                                                      OpcuaNodeIdServicesMethod = 32557
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Read                                                                                                       OpcuaNodeIdServicesMethod = 32559
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Write                                                                                                      OpcuaNodeIdServicesMethod = 32562
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_GetPosition                                                                                                OpcuaNodeIdServicesMethod = 32564
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_SetPosition                                                                                                OpcuaNodeIdServicesMethod = 32567
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_ReserveIds                                                                                                 OpcuaNodeIdServicesMethod = 32569
	OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_CloseAndUpdate                                                                                             OpcuaNodeIdServicesMethod = 32572
	OpcuaNodeIdServicesMethod_DataSetClasses_Status_Enable                                                                                                                  OpcuaNodeIdServicesMethod = 32577
	OpcuaNodeIdServicesMethod_DataSetClasses_Status_Disable                                                                                                                 OpcuaNodeIdServicesMethod = 32578
	OpcuaNodeIdServicesMethod_DataSetClasses_Diagnostics_Reset                                                                                                              OpcuaNodeIdServicesMethod = 32591
)

var OpcuaNodeIdServicesMethodValues []OpcuaNodeIdServicesMethod

func init() {
	_ = errors.New
	OpcuaNodeIdServicesMethodValues = []OpcuaNodeIdServicesMethod{
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt,
		OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve,
		OpcuaNodeIdServicesMethod_AddCommentMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_TimedShelveMethodType,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_ConditionRefreshMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_Enable,
		OpcuaNodeIdServicesMethod_ConditionType_Disable,
		OpcuaNodeIdServicesMethod_ConditionType_AddComment,
		OpcuaNodeIdServicesMethod_DialogResponseMethodType,
		OpcuaNodeIdServicesMethod_DialogConditionType_Enable,
		OpcuaNodeIdServicesMethod_DialogConditionType_Disable,
		OpcuaNodeIdServicesMethod_DialogConditionType_AddComment,
		OpcuaNodeIdServicesMethod_DialogConditionType_Respond,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Enable,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Disable,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_AddComment,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Enable,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Disable,
		OpcuaNodeIdServicesMethod_AlarmConditionType_AddComment,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Acknowledge,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Confirm,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Enable,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Disable,
		OpcuaNodeIdServicesMethod_LimitAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Enable,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Disable,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Enable,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Disable,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Enable,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Disable,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Enable,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Disable,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Enable,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Disable,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Enable,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Disable,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Enable,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Disable,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Enable,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Disable,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Enable,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Disable,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Enable,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Disable,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_TripAlarmType_Enable,
		OpcuaNodeIdServicesMethod_TripAlarmType_Disable,
		OpcuaNodeIdServicesMethod_TripAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_TripAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_TripAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems,
		OpcuaNodeIdServicesMethod_Server_GetMonitoredItems,
		OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType,
		OpcuaNodeIdServicesMethod_FileType_Open,
		OpcuaNodeIdServicesMethod_FileType_Close,
		OpcuaNodeIdServicesMethod_FileType_Read,
		OpcuaNodeIdServicesMethod_FileType_Write,
		OpcuaNodeIdServicesMethod_FileType_GetPosition,
		OpcuaNodeIdServicesMethod_FileType_SetPosition,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_Open,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_Close,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_Read,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_Write,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_GetPosition,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_SetPosition,
		OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_OpenMethodType,
		OpcuaNodeIdServicesMethod_CloseMethodType,
		OpcuaNodeIdServicesMethod_ReadMethodType,
		OpcuaNodeIdServicesMethod_WriteMethodType,
		OpcuaNodeIdServicesMethod_GetPositionMethodType,
		OpcuaNodeIdServicesMethod_SetPositionMethodType,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Disable,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Enable,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_OpenWithMasksMethodType,
		OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType,
		OpcuaNodeIdServicesMethod_AddCertificateMethodType,
		OpcuaNodeIdServicesMethod_RemoveCertificateMethodType,
		OpcuaNodeIdServicesMethod_TrustListType_Open,
		OpcuaNodeIdServicesMethod_TrustListType_Close,
		OpcuaNodeIdServicesMethod_TrustListType_Read,
		OpcuaNodeIdServicesMethod_TrustListType_Write,
		OpcuaNodeIdServicesMethod_TrustListType_GetPosition,
		OpcuaNodeIdServicesMethod_TrustListType_SetPosition,
		OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks,
		OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_TrustListType_AddCertificate,
		OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate,
		OpcuaNodeIdServicesMethod_UpdateCertificateMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges,
		OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType,
		OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable,
		OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable,
		OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType,
		OpcuaNodeIdServicesMethod_GetRejectedListMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerType_ResendData,
		OpcuaNodeIdServicesMethod_Server_ResendData,
		OpcuaNodeIdServicesMethod_ResendDataMethodType,
		OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange,
		OpcuaNodeIdServicesMethod_Server_RequestServerStateChange,
		OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType,
		OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType,
		OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Disable,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Enable,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CreateDirectoryMethodType,
		OpcuaNodeIdServicesMethod_CreateFileMethodType,
		OpcuaNodeIdServicesMethod_DeleteFileMethodType,
		OpcuaNodeIdServicesMethod_MoveOrCopyMethodType,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition,
		OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile,
		OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_RemoveConnectionMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType,
		OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType,
		OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables,
		OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType,
		OpcuaNodeIdServicesMethod_PubSubStatusType_Enable,
		OpcuaNodeIdServicesMethod_PubSubStatusType_Disable,
		OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection,
		OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType,
		OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables,
		OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables,
		OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_CreateCredentialMethodType,
		OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType,
		OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField,
		OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType,
		OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_AddExtensionField,
		OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_RemoveExtensionField,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity,
		OpcuaNodeIdServicesMethod_RoleType_AddIdentity,
		OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity,
		OpcuaNodeIdServicesMethod_AddIdentityMethodType,
		OpcuaNodeIdServicesMethod_RemoveIdentityMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit,
		OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset,
		OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType,
		OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType,
		OpcuaNodeIdServicesMethod_CloseAndCommitMethodType,
		OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition,
		OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace,
		OpcuaNodeIdServicesMethod_RoleSetType_AddRole,
		OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole,
		OpcuaNodeIdServicesMethod_AddRoleMethodType,
		OpcuaNodeIdServicesMethod_RemoveRoleMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint,
		OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_RoleType_AddApplication,
		OpcuaNodeIdServicesMethod_RoleType_RemoveApplication,
		OpcuaNodeIdServicesMethod_RoleType_AddEndpoint,
		OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_AddApplicationMethodType,
		OpcuaNodeIdServicesMethod_RemoveApplicationMethodType,
		OpcuaNodeIdServicesMethod_AddEndpointMethodType,
		OpcuaNodeIdServicesMethod_RemoveEndpointMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole,
		OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole,
		OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateFile,
		OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Open,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Close,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Read,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Write,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_GetPosition,
		OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_SetPosition,
		OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory,
		OpcuaNodeIdServicesMethod_FileSystem_CreateFile,
		OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Silence,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Silence,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Silence,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Silence,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Silence,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_AddConnectionMethodType,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Silence,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Silence,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Silence,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Silence,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Silence,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Silence,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Silence,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Silence,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType,
		OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType,
		OpcuaNodeIdServicesMethod_TripAlarmType_Silence,
		OpcuaNodeIdServicesMethod_TripAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Silence,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Disable,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Enable,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Silence,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys,
		OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys,
		OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables,
		OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror,
		OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType,
		OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable,
		OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey,
		OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential,
		OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey,
		OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType,
		OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject,
		OpcuaNodeIdServicesMethod_WriterGroupType_Status_Enable,
		OpcuaNodeIdServicesMethod_WriterGroupType_Status_Disable,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress,
		OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService,
		OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType,
		OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Enable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Disable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential,
		OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_DeleteCredential,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Reset,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Reset,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset,
		OpcuaNodeIdServicesMethod_TripAlarmType_Reset,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Disable,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Enable,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Silence,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Disable,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Enable,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Silence,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset,
		OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Disable,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Enable,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_AddComment,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Acknowledge,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Confirm,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Silence,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsRootType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsConnectionType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsWriterGroupType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsReaderGroupType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetWriterType_Reset,
		OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetReaderType_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables,
		OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror,
		OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader,
		OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader,
		OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias,
		OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias,
		OpcuaNodeIdServicesMethod_FindAliasMethodType,
		OpcuaNodeIdServicesMethod_Aliases_SubAliasNameCategories_Placeholder_FindAlias,
		OpcuaNodeIdServicesMethod_Aliases_FindAlias,
		OpcuaNodeIdServicesMethod_TagVariables_SubAliasNameCategories_Placeholder_FindAlias,
		OpcuaNodeIdServicesMethod_TagVariables_FindAlias,
		OpcuaNodeIdServicesMethod_Topics_SubAliasNameCategories_Placeholder_FindAlias,
		OpcuaNodeIdServicesMethod_Topics_FindAlias,
		OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_GetConnectionMethodType,
		OpcuaNodeIdServicesMethod_ModifyConnectionMethodType,
		OpcuaNodeIdServicesMethod_GetWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType,
		OpcuaNodeIdServicesMethod_GetReaderGroupMethodType,
		OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType,
		OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType,
		OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType,
		OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType,
		OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType,
		OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_UserManagementType_AddUser,
		OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser,
		OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser,
		OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword,
		OpcuaNodeIdServicesMethod_AddUserMethodType,
		OpcuaNodeIdServicesMethod_ModifyUserMethodType,
		OpcuaNodeIdServicesMethod_RemoveUserMethodType,
		OpcuaNodeIdServicesMethod_ChangePasswordMethodType,
		OpcuaNodeIdServicesMethod_UserManagement_AddUser,
		OpcuaNodeIdServicesMethod_UserManagement_ModifyUser,
		OpcuaNodeIdServicesMethod_UserManagement_RemoveUser,
		OpcuaNodeIdServicesMethod_UserManagement_ChangePassword,
		OpcuaNodeIdServicesMethod_DialogConditionType_Respond2,
		OpcuaNodeIdServicesMethod_DialogResponse2MethodType,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2,
		OpcuaNodeIdServicesMethod_WithCommentMethodType,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_TripAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_TripAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2,
		OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_LimitAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_DiscreteAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_OffNormalAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_TripAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_TimedShelve2MethodType,
		OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry,
		OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry,
		OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType,
		OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType,
		OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType,
		OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_AddPushTargetMethodType,
		OpcuaNodeIdServicesMethod_RemovePushTargetMethodType,
		OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType,
		OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds,
		OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds,
		OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_Open,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_Close,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_Read,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_Write,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_GetPosition,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_SetPosition,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds,
		OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType,
		OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint,
		OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys,
		OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys,
		OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups,
		OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges,
		OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ServerConfiguration_SetAdminPassword,
		OpcuaNodeIdServicesMethod_RequestTicketsMethodType,
		OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ApplyChanges,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CancelChanges,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetRejectedList,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ApplyChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CancelChanges,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ResetToServerDefaults,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Disable,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Enable,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Silence,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2,
		OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships,
		OpcuaNodeIdServicesMethod_GetCertificatesMethodType,
		OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates,
		OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates,
		OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetCertificates,
		OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates,
		OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetCertificates,
		OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityKeys,
		OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroupFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTarget,
		OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTarget,
		OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTargetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTargetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Reset,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddWriterGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddReaderGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_RemoveGroup,
		OpcuaNodeIdServicesMethod_DataSetClasses_SetSecurityKeys,
		OpcuaNodeIdServicesMethod_DataSetClasses_AddConnection,
		OpcuaNodeIdServicesMethod_DataSetClasses_RemoveConnection,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItems,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEvents,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemovePublishedDataSet,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddSubscribedDataSet,
		OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveSubscribedDataSet,
		OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveDataSetFolder,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Open,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Close,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Read,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Write,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_GetPosition,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_SetPosition,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_ReserveIds,
		OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_CloseAndUpdate,
		OpcuaNodeIdServicesMethod_DataSetClasses_Status_Enable,
		OpcuaNodeIdServicesMethod_DataSetClasses_Status_Disable,
		OpcuaNodeIdServicesMethod_DataSetClasses_Diagnostics_Reset,
	}
}

func OpcuaNodeIdServicesMethodByValue(value int32) (enum OpcuaNodeIdServicesMethod, ok bool) {
	switch value {
	case 10014:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve, true
	case 10015:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve, true
	case 10016:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve, true
	case 10089:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Enable, true
	case 10090:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Disable, true
	case 10091:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_AddComment, true
	case 10093:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh, true
	case 10113:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Acknowledge, true
	case 10115:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Confirm, true
	case 10168:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve, true
	case 10169:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve, true
	case 10170:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve, true
	case 10243:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Enable, true
	case 10244:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Disable, true
	case 10245:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_AddComment, true
	case 10247:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh, true
	case 10267:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Acknowledge, true
	case 10269:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Confirm, true
	case 10322:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve, true
	case 10323:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve, true
	case 10324:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve, true
	case 10397:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Enable, true
	case 10398:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Disable, true
	case 10399:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_AddComment, true
	case 10401:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh, true
	case 10421:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Acknowledge, true
	case 10423:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Confirm, true
	case 10476:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve, true
	case 10477:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve, true
	case 10478:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve, true
	case 10552:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Enable, true
	case 10553:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Disable, true
	case 10554:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_AddComment, true
	case 10556:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh, true
	case 10576:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Acknowledge, true
	case 10578:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Confirm, true
	case 10631:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve, true
	case 10632:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve, true
	case 10633:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve, true
	case 10666:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Enable, true
	case 10667:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Disable, true
	case 10668:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_AddComment, true
	case 10670:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh, true
	case 10690:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Acknowledge, true
	case 10692:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Confirm, true
	case 10745:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve, true
	case 10746:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve, true
	case 10747:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve, true
	case 10780:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Enable, true
	case 10781:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Disable, true
	case 10782:
		return OpcuaNodeIdServicesMethod_TripAlarmType_AddComment, true
	case 10784:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh, true
	case 10804:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Acknowledge, true
	case 10806:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Confirm, true
	case 10859:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve, true
	case 10860:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve, true
	case 10861:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve, true
	case 11489:
		return OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems, true
	case 11492:
		return OpcuaNodeIdServicesMethod_Server_GetMonitoredItems, true
	case 11495:
		return OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType, true
	case 11580:
		return OpcuaNodeIdServicesMethod_FileType_Open, true
	case 11583:
		return OpcuaNodeIdServicesMethod_FileType_Close, true
	case 11585:
		return OpcuaNodeIdServicesMethod_FileType_Read, true
	case 11588:
		return OpcuaNodeIdServicesMethod_FileType_Write, true
	case 11590:
		return OpcuaNodeIdServicesMethod_FileType_GetPosition, true
	case 11593:
		return OpcuaNodeIdServicesMethod_FileType_SetPosition, true
	case 11600:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Open, true
	case 11603:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Close, true
	case 11605:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Read, true
	case 11608:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Write, true
	case 11610:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_GetPosition, true
	case 11613:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_SetPosition, true
	case 11615:
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace, true
	case 11629:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open, true
	case 11632:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close, true
	case 11634:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read, true
	case 11637:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write, true
	case 11639:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition, true
	case 11642:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition, true
	case 11644:
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace, true
	case 11659:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open, true
	case 11662:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close, true
	case 11664:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read, true
	case 11667:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write, true
	case 11669:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition, true
	case 11672:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition, true
	case 11674:
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace, true
	case 11738:
		return OpcuaNodeIdServicesMethod_OpenMethodType, true
	case 11741:
		return OpcuaNodeIdServicesMethod_CloseMethodType, true
	case 11743:
		return OpcuaNodeIdServicesMethod_ReadMethodType, true
	case 11746:
		return OpcuaNodeIdServicesMethod_WriteMethodType, true
	case 11748:
		return OpcuaNodeIdServicesMethod_GetPositionMethodType, true
	case 11751:
		return OpcuaNodeIdServicesMethod_SetPositionMethodType, true
	case 11784:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Disable, true
	case 11785:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Enable, true
	case 11786:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_AddComment, true
	case 11788:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh, true
	case 11808:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Acknowledge, true
	case 11810:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Confirm, true
	case 11844:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve, true
	case 11845:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve, true
	case 11846:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve, true
	case 12513:
		return OpcuaNodeIdServicesMethod_OpenWithMasksMethodType, true
	case 12516:
		return OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType, true
	case 12518:
		return OpcuaNodeIdServicesMethod_AddCertificateMethodType, true
	case 12520:
		return OpcuaNodeIdServicesMethod_RemoveCertificateMethodType, true
	case 12527:
		return OpcuaNodeIdServicesMethod_TrustListType_Open, true
	case 12530:
		return OpcuaNodeIdServicesMethod_TrustListType_Close, true
	case 12532:
		return OpcuaNodeIdServicesMethod_TrustListType_Read, true
	case 12535:
		return OpcuaNodeIdServicesMethod_TrustListType_Write, true
	case 12537:
		return OpcuaNodeIdServicesMethod_TrustListType_GetPosition, true
	case 12540:
		return OpcuaNodeIdServicesMethod_TrustListType_SetPosition, true
	case 12543:
		return OpcuaNodeIdServicesMethod_TrustListType_OpenWithMasks, true
	case 12546:
		return OpcuaNodeIdServicesMethod_TrustListType_CloseAndUpdate, true
	case 12548:
		return OpcuaNodeIdServicesMethod_TrustListType_AddCertificate, true
	case 12550:
		return OpcuaNodeIdServicesMethod_TrustListType_RemoveCertificate, true
	case 12578:
		return OpcuaNodeIdServicesMethod_UpdateCertificateMethodType, true
	case 12616:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_UpdateCertificate, true
	case 12647:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 12650:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 12652:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 12655:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 12657:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 12660:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 12663:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 12666:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 12668:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 12670:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 12731:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CreateSigningRequest, true
	case 12734:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ApplyChanges, true
	case 12737:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CreateSigningRequest, true
	case 12740:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ApplyChanges, true
	case 12741:
		return OpcuaNodeIdServicesMethod_CreateSigningRequestMethodType, true
	case 12746:
		return OpcuaNodeIdServicesMethod_ServerType_SetSubscriptionDurable, true
	case 12749:
		return OpcuaNodeIdServicesMethod_Server_SetSubscriptionDurable, true
	case 12752:
		return OpcuaNodeIdServicesMethod_SetSubscriptionDurableMethodType, true
	case 12773:
		return OpcuaNodeIdServicesMethod_GetRejectedListMethodType, true
	case 12775:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_GetRejectedList, true
	case 12777:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_GetRejectedList, true
	case 12871:
		return OpcuaNodeIdServicesMethod_ServerType_ResendData, true
	case 12873:
		return OpcuaNodeIdServicesMethod_Server_ResendData, true
	case 12875:
		return OpcuaNodeIdServicesMethod_ResendDataMethodType, true
	case 12883:
		return OpcuaNodeIdServicesMethod_ServerType_RequestServerStateChange, true
	case 12886:
		return OpcuaNodeIdServicesMethod_Server_RequestServerStateChange, true
	case 12888:
		return OpcuaNodeIdServicesMethod_RequestServerStateChangeMethodType, true
	case 12912:
		return OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh2, true
	case 12914:
		return OpcuaNodeIdServicesMethod_ConditionRefresh2MethodType, true
	case 12916:
		return OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh2, true
	case 12918:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh2, true
	case 12984:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh2, true
	case 12986:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh2, true
	case 12988:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh2, true
	case 12990:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh2, true
	case 12992:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh2, true
	case 12994:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh2, true
	case 12996:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh2, true
	case 12998:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh2, true
	case 13000:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2, true
	case 13002:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh2, true
	case 13004:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh2, true
	case 13006:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh2, true
	case 13008:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh2, true
	case 13010:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh2, true
	case 13256:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Disable, true
	case 13257:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Enable, true
	case 13258:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_AddComment, true
	case 13260:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh, true
	case 13262:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ConditionRefresh2, true
	case 13282:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Acknowledge, true
	case 13284:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Confirm, true
	case 13318:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve, true
	case 13319:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve, true
	case 13320:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve, true
	case 13342:
		return OpcuaNodeIdServicesMethod_CreateDirectoryMethodType, true
	case 13345:
		return OpcuaNodeIdServicesMethod_CreateFileMethodType, true
	case 13348:
		return OpcuaNodeIdServicesMethod_DeleteFileMethodType, true
	case 13350:
		return OpcuaNodeIdServicesMethod_MoveOrCopyMethodType, true
	case 13355:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory, true
	case 13358:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile, true
	case 13363:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy, true
	case 13372:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Open, true
	case 13375:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Close, true
	case 13377:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Read, true
	case 13380:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_Write, true
	case 13382:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_GetPosition, true
	case 13385:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileName_Placeholder_SetPosition, true
	case 13387:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateDirectory, true
	case 13390:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_CreateFile, true
	case 13393:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_DeleteFileSystemObject, true
	case 13395:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_MoveOrCopy, true
	case 13605:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Open, true
	case 13608:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Close, true
	case 13610:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Read, true
	case 13613:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_Write, true
	case 13615:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_GetPosition, true
	case 13618:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_SetPosition, true
	case 13621:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_OpenWithMasks, true
	case 13624:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_CloseAndUpdate, true
	case 13627:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_AddCertificate, true
	case 13629:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustList_RemoveCertificate, true
	case 13737:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_UpdateCertificate, true
	case 13821:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open, true
	case 13824:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close, true
	case 13826:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read, true
	case 13829:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write, true
	case 13831:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition, true
	case 13834:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition, true
	case 13837:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 13840:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 13843:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 13845:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 13855:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open, true
	case 13858:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close, true
	case 13860:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read, true
	case 13863:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write, true
	case 13865:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition, true
	case 13868:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition, true
	case 13871:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 13874:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 13877:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 13879:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 13889:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open, true
	case 13892:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close, true
	case 13894:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read, true
	case 13897:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write, true
	case 13899:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 13902:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 13905:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 13908:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 13911:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 13913:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 13923:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open, true
	case 13926:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close, true
	case 13928:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read, true
	case 13931:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write, true
	case 13933:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition, true
	case 13936:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition, true
	case 13939:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks, true
	case 13942:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate, true
	case 13945:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate, true
	case 13947:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate, true
	case 13958:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 13961:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 13963:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 13966:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 13968:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 13971:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 13974:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 13977:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 13980:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 13982:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 13992:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 13995:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 13997:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 14000:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 14002:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 14005:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 14008:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 14011:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 14014:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 14016:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 14026:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 14029:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 14031:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 14034:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 14036:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 14039:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 14042:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 14045:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 14048:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 14050:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 14095:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 14098:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 14100:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 14103:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 14105:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 14108:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 14111:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 14114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 14117:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 14119:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 14129:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 14132:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 14134:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 14137:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 14139:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 14142:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 14145:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 14148:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 14151:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 14153:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 14183:
		return OpcuaNodeIdServicesMethod_RemoveConnectionMethodType, true
	case 14225:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_RemoveGroup, true
	case 14421:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Enable, true
	case 14422:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Status_Disable, true
	case 14424:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup, true
	case 14432:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_RemoveConnection, true
	case 14435:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems, true
	case 14438:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEvents, true
	case 14441:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet, true
	case 14479:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems, true
	case 14482:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents, true
	case 14485:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet, true
	case 14493:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItems, true
	case 14496:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEvents, true
	case 14499:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemovePublishedDataSet, true
	case 14501:
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsMethodType, true
	case 14504:
		return OpcuaNodeIdServicesMethod_AddPublishedEventsMethodType, true
	case 14507:
		return OpcuaNodeIdServicesMethod_RemovePublishedDataSetMethodType, true
	case 14555:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_AddVariables, true
	case 14558:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_RemoveVariables, true
	case 14564:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsAddVariablesMethodType, true
	case 14567:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsRemoveVariablesMethodType, true
	case 14602:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Enable, true
	case 14603:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Status_Disable, true
	case 14604:
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeRemoveGroupMethodType, true
	case 14623:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveWriterMethodType, true
	case 14625:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeRemoveReaderMethodType, true
	case 14645:
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Enable, true
	case 14646:
		return OpcuaNodeIdServicesMethod_PubSubStatusType_Disable, true
	case 15052:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_ModifyFieldSelection, true
	case 15054:
		return OpcuaNodeIdServicesMethod_PublishedEventsTypeModifyFieldSelectionMethodType, true
	case 15115:
		return OpcuaNodeIdServicesMethod_TargetVariablesType_AddTargetVariables, true
	case 15118:
		return OpcuaNodeIdServicesMethod_TargetVariablesType_RemoveTargetVariables, true
	case 15121:
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeAddTargetVariablesMethodType, true
	case 15124:
		return OpcuaNodeIdServicesMethod_TargetVariablesTypeRemoveTargetVariablesMethodType, true
	case 15212:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityKeys, true
	case 15215:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityKeys, true
	case 15218:
		return OpcuaNodeIdServicesMethod_GetSecurityKeysMethodType, true
	case 15225:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable, true
	case 15226:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable, true
	case 15233:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Enable, true
	case 15234:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Disable, true
	case 15241:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Enable, true
	case 15242:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Status_Disable, true
	case 15248:
		return OpcuaNodeIdServicesMethod_CreateCredentialMethodType, true
	case 15267:
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Enable, true
	case 15268:
		return OpcuaNodeIdServicesMethod_PubSubGroupType_Status_Disable, true
	case 15301:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Enable, true
	case 15302:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Status_Disable, true
	case 15309:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Enable, true
	case 15310:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Status_Disable, true
	case 15431:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_GetSecurityGroup, true
	case 15435:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroup, true
	case 15438:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup, true
	case 15440:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_GetSecurityGroup, true
	case 15444:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroup, true
	case 15447:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroup, true
	case 15449:
		return OpcuaNodeIdServicesMethod_GetSecurityGroupMethodType, true
	case 15454:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup, true
	case 15457:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup, true
	case 15461:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroup, true
	case 15464:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroup, true
	case 15466:
		return OpcuaNodeIdServicesMethod_AddSecurityGroupMethodType, true
	case 15469:
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupMethodType, true
	case 15474:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField, true
	case 15477:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField, true
	case 15482:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_AddExtensionField, true
	case 15485:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_ExtensionFields_RemoveExtensionField, true
	case 15491:
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_AddExtensionField, true
	case 15494:
		return OpcuaNodeIdServicesMethod_ExtensionFieldsType_RemoveExtensionField, true
	case 15496:
		return OpcuaNodeIdServicesMethod_AddExtensionFieldMethodType, true
	case 15499:
		return OpcuaNodeIdServicesMethod_RemoveExtensionFieldMethodType, true
	case 15504:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_AddExtensionField, true
	case 15507:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_ExtensionFields_RemoveExtensionField, true
	case 15512:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_AddExtensionField, true
	case 15515:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_ExtensionFields_RemoveExtensionField, true
	case 15612:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddIdentity, true
	case 15614:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveIdentity, true
	case 15624:
		return OpcuaNodeIdServicesMethod_RoleType_AddIdentity, true
	case 15626:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveIdentity, true
	case 15636:
		return OpcuaNodeIdServicesMethod_AddIdentityMethodType, true
	case 15638:
		return OpcuaNodeIdServicesMethod_RemoveIdentityMethodType, true
	case 15648:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddIdentity, true
	case 15650:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveIdentity, true
	case 15660:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddIdentity, true
	case 15662:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveIdentity, true
	case 15672:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddIdentity, true
	case 15674:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveIdentity, true
	case 15684:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddIdentity, true
	case 15686:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveIdentity, true
	case 15696:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddIdentity, true
	case 15698:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveIdentity, true
	case 15708:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddIdentity, true
	case 15710:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveIdentity, true
	case 15720:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddIdentity, true
	case 15722:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveIdentity, true
	case 15746:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForRead, true
	case 15749:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_GenerateFileForWrite, true
	case 15751:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_CloseAndCommit, true
	case 15794:
		return OpcuaNodeIdServicesMethod_TemporaryFileTransferType_TransferState_Placeholder_Reset, true
	case 15795:
		return OpcuaNodeIdServicesMethod_GenerateFileForReadMethodType, true
	case 15798:
		return OpcuaNodeIdServicesMethod_GenerateFileForWriteMethodType, true
	case 15800:
		return OpcuaNodeIdServicesMethod_CloseAndCommitMethodType, true
	case 15843:
		return OpcuaNodeIdServicesMethod_FileTransferStateMachineType_Reset, true
	case 15846:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Enable, true
	case 15847:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Status_Disable, true
	case 15893:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Enable, true
	case 15894:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Status_Disable, true
	case 15907:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityKeys, true
	case 15910:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_GetSecurityGroup, true
	case 15914:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup, true
	case 15917:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup, true
	case 15971:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Open, true
	case 15974:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Close, true
	case 15976:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Read, true
	case 15979:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_Write, true
	case 15981:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_GetPosition, true
	case 15984:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_SetPosition, true
	case 15986:
		return OpcuaNodeIdServicesMethod_OPCUANamespaceMetadata_NamespaceFile_ExportNamespace, true
	case 15997:
		return OpcuaNodeIdServicesMethod_RoleSetType_AddRole, true
	case 16000:
		return OpcuaNodeIdServicesMethod_RoleSetType_RemoveRole, true
	case 16002:
		return OpcuaNodeIdServicesMethod_AddRoleMethodType, true
	case 16005:
		return OpcuaNodeIdServicesMethod_RemoveRoleMethodType, true
	case 16041:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddIdentity, true
	case 16043:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveIdentity, true
	case 16076:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset, true
	case 16165:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddApplication, true
	case 16167:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveApplication, true
	case 16169:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_AddEndpoint, true
	case 16171:
		return OpcuaNodeIdServicesMethod_RoleSetType_RoleName_Placeholder_RemoveEndpoint, true
	case 16176:
		return OpcuaNodeIdServicesMethod_RoleType_AddApplication, true
	case 16178:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveApplication, true
	case 16180:
		return OpcuaNodeIdServicesMethod_RoleType_AddEndpoint, true
	case 16182:
		return OpcuaNodeIdServicesMethod_RoleType_RemoveEndpoint, true
	case 16184:
		return OpcuaNodeIdServicesMethod_AddApplicationMethodType, true
	case 16186:
		return OpcuaNodeIdServicesMethod_RemoveApplicationMethodType, true
	case 16188:
		return OpcuaNodeIdServicesMethod_AddEndpointMethodType, true
	case 16190:
		return OpcuaNodeIdServicesMethod_RemoveEndpointMethodType, true
	case 16195:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddApplication, true
	case 16197:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveApplication, true
	case 16199:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_AddEndpoint, true
	case 16201:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Anonymous_RemoveEndpoint, true
	case 16206:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddApplication, true
	case 16208:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveApplication, true
	case 16210:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_AddEndpoint, true
	case 16212:
		return OpcuaNodeIdServicesMethod_WellKnownRole_AuthenticatedUser_RemoveEndpoint, true
	case 16217:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddApplication, true
	case 16219:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveApplication, true
	case 16221:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_AddEndpoint, true
	case 16223:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Observer_RemoveEndpoint, true
	case 16228:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddApplication, true
	case 16230:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveApplication, true
	case 16232:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_AddEndpoint, true
	case 16234:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Operator_RemoveEndpoint, true
	case 16239:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddApplication, true
	case 16241:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveApplication, true
	case 16243:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_AddEndpoint, true
	case 16245:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Engineer_RemoveEndpoint, true
	case 16250:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddApplication, true
	case 16252:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveApplication, true
	case 16254:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_AddEndpoint, true
	case 16256:
		return OpcuaNodeIdServicesMethod_WellKnownRole_Supervisor_RemoveEndpoint, true
	case 16261:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddApplication, true
	case 16263:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveApplication, true
	case 16265:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_AddEndpoint, true
	case 16267:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityAdmin_RemoveEndpoint, true
	case 16272:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddApplication, true
	case 16274:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveApplication, true
	case 16276:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_AddEndpoint, true
	case 16278:
		return OpcuaNodeIdServicesMethod_WellKnownRole_ConfigureAdmin_RemoveEndpoint, true
	case 16290:
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_AddRole, true
	case 16293:
		return OpcuaNodeIdServicesMethod_ServerType_ServerCapabilities_RoleSet_RemoveRole, true
	case 16296:
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_AddRole, true
	case 16299:
		return OpcuaNodeIdServicesMethod_ServerCapabilitiesType_RoleSet_RemoveRole, true
	case 16301:
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_AddRole, true
	case 16304:
		return OpcuaNodeIdServicesMethod_Server_ServerCapabilities_RoleSet_RemoveRole, true
	case 16316:
		return OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateDirectory, true
	case 16319:
		return OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_CreateFile, true
	case 16324:
		return OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy, true
	case 16333:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Open, true
	case 16336:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Close, true
	case 16338:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Read, true
	case 16341:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_Write, true
	case 16343:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_GetPosition, true
	case 16346:
		return OpcuaNodeIdServicesMethod_FileSystem_FileName_Placeholder_SetPosition, true
	case 16348:
		return OpcuaNodeIdServicesMethod_FileSystem_CreateDirectory, true
	case 16351:
		return OpcuaNodeIdServicesMethod_FileSystem_CreateFile, true
	case 16354:
		return OpcuaNodeIdServicesMethod_FileSystem_DeleteFileSystemObject, true
	case 16356:
		return OpcuaNodeIdServicesMethod_FileSystem_MoveOrCopy, true
	case 16402:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Silence, true
	case 16403:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress, true
	case 16439:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable, true
	case 16440:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable, true
	case 16441:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment, true
	case 16461:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge, true
	case 16463:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm, true
	case 16515:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve, true
	case 16516:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve, true
	case 16517:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve, true
	case 16533:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Silence, true
	case 16534:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress, true
	case 16535:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup, true
	case 16560:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup, true
	case 16569:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Silence, true
	case 16570:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress, true
	case 16598:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_AddConnection, true
	case 16601:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case 16609:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Silence, true
	case 16610:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress, true
	case 16639:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate, true
	case 16649:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Silence, true
	case 16650:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress, true
	case 16651:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_AddDataSetFolder, true
	case 16680:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder, true
	case 16689:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Silence, true
	case 16690:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress, true
	case 16691:
		return OpcuaNodeIdServicesMethod_AddConnectionMethodType, true
	case 16729:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Silence, true
	case 16730:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress, true
	case 16769:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Silence, true
	case 16770:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress, true
	case 16810:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Silence, true
	case 16811:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress, true
	case 16842:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate, true
	case 16851:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Silence, true
	case 16852:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress, true
	case 16881:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate, true
	case 16884:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder, true
	case 16892:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Silence, true
	case 16893:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress, true
	case 16923:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case 16933:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Silence, true
	case 16934:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress, true
	case 16935:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedDataItemsTemplate, true
	case 16960:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddPublishedEventsTemplate, true
	case 16969:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Silence, true
	case 16970:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress, true
	case 16994:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_AddDataSetFolder, true
	case 16997:
		return OpcuaNodeIdServicesMethod_DataSetFolderType_RemoveDataSetFolder, true
	case 17005:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Silence, true
	case 17006:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress, true
	case 17030:
		return OpcuaNodeIdServicesMethod_AddPublishedDataItemsTemplateMethodType, true
	case 17033:
		return OpcuaNodeIdServicesMethod_AddPublishedEventsTemplateMethodType, true
	case 17041:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Silence, true
	case 17042:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Suppress, true
	case 17067:
		return OpcuaNodeIdServicesMethod_AddDataSetFolderMethodType, true
	case 17077:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Silence, true
	case 17078:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress, true
	case 17079:
		return OpcuaNodeIdServicesMethod_RemoveDataSetFolderMethodType, true
	case 17113:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Disable, true
	case 17114:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Enable, true
	case 17115:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_AddComment, true
	case 17117:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh, true
	case 17119:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ConditionRefresh2, true
	case 17139:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Acknowledge, true
	case 17141:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Confirm, true
	case 17193:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve, true
	case 17194:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve, true
	case 17195:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve, true
	case 17212:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Silence, true
	case 17213:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress, true
	case 17293:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter, true
	case 17296:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SetSecurityKeys, true
	case 17298:
		return OpcuaNodeIdServicesMethod_SetSecurityKeysMethodType, true
	case 17316:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable, true
	case 17317:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable, true
	case 17323:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter, true
	case 17331:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable, true
	case 17332:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable, true
	case 17333:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader, true
	case 17355:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader, true
	case 17356:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup, true
	case 17359:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup, true
	case 17362:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup, true
	case 17364:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SetSecurityKeys, true
	case 17366:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_AddConnection, true
	case 17369:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_RemoveConnection, true
	case 17372:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItems, true
	case 17375:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEvents, true
	case 17378:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case 17381:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate, true
	case 17384:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet, true
	case 17386:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateTargetVariables, true
	case 17389:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_CreateDataSetMirror, true
	case 17392:
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateTargetVariablesMethodType, true
	case 17395:
		return OpcuaNodeIdServicesMethod_DataSetReaderTypeCreateDataSetMirrorMethodType, true
	case 17398:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_AddDataSetFolder, true
	case 17403:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder, true
	case 17407:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Enable, true
	case 17408:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Status_Disable, true
	case 17421:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_Diagnostics_Reset, true
	case 17427:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddWriterGroup, true
	case 17465:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_AddReaderGroup, true
	case 17516:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey, true
	case 17519:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential, true
	case 17521:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential, true
	case 17522:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationFolderType_CreateCredential, true
	case 17525:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey, true
	case 17528:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_CreateCredential, true
	case 17531:
		return OpcuaNodeIdServicesMethod_GetEncryptingKeyMethodType, true
	case 17534:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_GetEncryptingKey, true
	case 17561:
		return OpcuaNodeIdServicesMethod_PubSubConnectionTypeAddWriterGroupMethodType, true
	case 17630:
		return OpcuaNodeIdServicesMethod_PubSubConnectionAddReaderGroupGroupMethodType, true
	case 17718:
		return OpcuaNodeIdServicesMethod_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject, true
	case 17722:
		return OpcuaNodeIdServicesMethod_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject, true
	case 17734:
		return OpcuaNodeIdServicesMethod_WriterGroupType_Status_Enable, true
	case 17735:
		return OpcuaNodeIdServicesMethod_WriterGroupType_Status_Disable, true
	case 17751:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Enable, true
	case 17752:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Status_Disable, true
	case 17765:
		return OpcuaNodeIdServicesMethod_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 17824:
		return OpcuaNodeIdServicesMethod_WriterGroupType_Diagnostics_Reset, true
	case 17868:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress, true
	case 17869:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService, true
	case 17870:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService, true
	case 17875:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress, true
	case 17876:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService, true
	case 17877:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService, true
	case 17882:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress, true
	case 17883:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService, true
	case 17884:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService, true
	case 17889:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress, true
	case 17890:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService, true
	case 17891:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService, true
	case 17896:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress, true
	case 17897:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService, true
	case 17898:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService, true
	case 17904:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService, true
	case 17905:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService, true
	case 17910:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress, true
	case 17911:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService, true
	case 17912:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService, true
	case 17917:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress, true
	case 17918:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService, true
	case 17919:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService, true
	case 17924:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress, true
	case 17925:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService, true
	case 17926:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService, true
	case 17931:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress, true
	case 17932:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService, true
	case 17933:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService, true
	case 17938:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress, true
	case 17939:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService, true
	case 17940:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService, true
	case 17945:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress, true
	case 17946:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService, true
	case 17947:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService, true
	case 17952:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress, true
	case 17953:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService, true
	case 17954:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService, true
	case 17959:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress, true
	case 17960:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService, true
	case 17961:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService, true
	case 17966:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress, true
	case 17967:
		return OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService, true
	case 17968:
		return OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService, true
	case 17969:
		return OpcuaNodeIdServicesMethod_WriterGroupType_AddDataSetWriter, true
	case 17973:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress, true
	case 17974:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService, true
	case 17975:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService, true
	case 17980:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress, true
	case 17981:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService, true
	case 17982:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService, true
	case 17992:
		return OpcuaNodeIdServicesMethod_WriterGroupType_RemoveDataSetWriter, true
	case 17994:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddWriterMethodType, true
	case 18006:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_UpdateCredential, true
	case 18008:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfigurationType_DeleteCredential, true
	case 18009:
		return OpcuaNodeIdServicesMethod_KeyCredentialUpdateMethodType, true
	case 18074:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Enable, true
	case 18075:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_Status_Disable, true
	case 18090:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable, true
	case 18091:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable, true
	case 18104:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset, true
	case 18161:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential, true
	case 18163:
		return OpcuaNodeIdServicesMethod_KeyCredentialConfiguration_ServiceName_Placeholder_DeleteCredential, true
	case 18199:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset, true
	case 18212:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset, true
	case 18222:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Reset, true
	case 18232:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset, true
	case 18242:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset, true
	case 18255:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress, true
	case 18256:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset, true
	case 18266:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset, true
	case 18276:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset, true
	case 18286:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset, true
	case 18296:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset, true
	case 18306:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset, true
	case 18316:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset, true
	case 18326:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset, true
	case 18336:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset, true
	case 18346:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Reset, true
	case 18380:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Disable, true
	case 18381:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Enable, true
	case 18382:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_AddComment, true
	case 18384:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh, true
	case 18386:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ConditionRefresh2, true
	case 18406:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Acknowledge, true
	case 18408:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Confirm, true
	case 18453:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve, true
	case 18455:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve, true
	case 18456:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve, true
	case 18489:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Silence, true
	case 18490:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress, true
	case 18491:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress, true
	case 18492:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService, true
	case 18493:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService, true
	case 18494:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset, true
	case 18529:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Disable, true
	case 18530:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Enable, true
	case 18531:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_AddComment, true
	case 18533:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh, true
	case 18535:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ConditionRefresh2, true
	case 18555:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Acknowledge, true
	case 18557:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Confirm, true
	case 18602:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve, true
	case 18604:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve, true
	case 18605:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve, true
	case 18638:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Silence, true
	case 18639:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress, true
	case 18640:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress, true
	case 18641:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService, true
	case 18642:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService, true
	case 18643:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset, true
	case 18654:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset, true
	case 18664:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset, true
	case 18666:
		return OpcuaNodeIdServicesMethod_AlarmMetricsType_Reset, true
	case 18679:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset, true
	case 18727:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_Diagnostics_Reset, true
	case 18883:
		return OpcuaNodeIdServicesMethod_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 18942:
		return OpcuaNodeIdServicesMethod_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 19001:
		return OpcuaNodeIdServicesMethod_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset, true
	case 19119:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset, true
	case 19188:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset, true
	case 19253:
		return OpcuaNodeIdServicesMethod_PubSubConnectionType_Diagnostics_Reset, true
	case 19330:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Disable, true
	case 19331:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Enable, true
	case 19332:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_AddComment, true
	case 19334:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh, true
	case 19336:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ConditionRefresh2, true
	case 19356:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Acknowledge, true
	case 19358:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Confirm, true
	case 19403:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve, true
	case 19405:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve, true
	case 19406:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve, true
	case 19439:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Silence, true
	case 19440:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress, true
	case 19441:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress, true
	case 19442:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService, true
	case 19443:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService, true
	case 19444:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset, true
	case 19483:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Disable, true
	case 19484:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Enable, true
	case 19485:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_AddComment, true
	case 19505:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Acknowledge, true
	case 19507:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Confirm, true
	case 19562:
		return OpcuaNodeIdServicesMethod_DataSetWriterType_Diagnostics_Reset, true
	case 19621:
		return OpcuaNodeIdServicesMethod_DataSetReaderType_Diagnostics_Reset, true
	case 19689:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsType_Reset, true
	case 19744:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsRootType_Reset, true
	case 19798:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsConnectionType_Reset, true
	case 19846:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsWriterGroupType_Reset, true
	case 19915:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsReaderGroupType_Reset, true
	case 19980:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetWriterType_Reset, true
	case 20039:
		return OpcuaNodeIdServicesMethod_PubSubDiagnosticsDataSetReaderType_Reset, true
	case 20097:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve, true
	case 20099:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve, true
	case 20100:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20132:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Silence, true
	case 20133:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress, true
	case 20134:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress, true
	case 20135:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService, true
	case 20136:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService, true
	case 20137:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset, true
	case 20176:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Disable, true
	case 20177:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Enable, true
	case 20178:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_AddComment, true
	case 20198:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Acknowledge, true
	case 20200:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Confirm, true
	case 20245:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20247:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20248:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20280:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Silence, true
	case 20281:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress, true
	case 20282:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress, true
	case 20283:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService, true
	case 20284:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService, true
	case 20285:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset, true
	case 20324:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 20325:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 20326:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 20346:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 20348:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 20393:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20395:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20396:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20430:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 20431:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 20432:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 20433:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 20434:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 20435:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 20474:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 20475:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 20476:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 20496:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 20498:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 20543:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20545:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20546:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20578:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 20579:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 20580:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 20581:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 20582:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 20583:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 20622:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 20623:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 20624:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 20644:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 20646:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 20691:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20693:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20694:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 20726:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 20727:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 20728:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 20729:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 20730:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 20731:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 20770:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 20771:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 20772:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 20792:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 20794:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 20839:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 20841:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 20842:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 20874:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 20875:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 20876:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 20877:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 20878:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 20879:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 20918:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 20919:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 20920:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 20940:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 20942:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 20987:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 20989:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 20990:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21009:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables, true
	case 21012:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror, true
	case 21027:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_Diagnostics_Reset, true
	case 21082:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_AddDataSetReader, true
	case 21085:
		return OpcuaNodeIdServicesMethod_ReaderGroupType_RemoveDataSetReader, true
	case 21087:
		return OpcuaNodeIdServicesMethod_PubSubGroupTypeAddReaderMethodType, true
	case 21225:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 21226:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 21227:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 21228:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 21229:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 21230:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 21269:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 21270:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 21271:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 21291:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 21293:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 21338:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21340:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21341:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21373:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 21374:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 21375:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 21376:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 21377:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 21378:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 21417:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable, true
	case 21418:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable, true
	case 21419:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment, true
	case 21439:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge, true
	case 21441:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm, true
	case 21486:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve, true
	case 21488:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve, true
	case 21489:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21521:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence, true
	case 21522:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress, true
	case 21523:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress, true
	case 21524:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService, true
	case 21525:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService, true
	case 21526:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset, true
	case 21565:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable, true
	case 21566:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable, true
	case 21567:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment, true
	case 21587:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge, true
	case 21589:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm, true
	case 21634:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21636:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21637:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21669:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence, true
	case 21670:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress, true
	case 21671:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress, true
	case 21672:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService, true
	case 21673:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService, true
	case 21674:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset, true
	case 21713:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 21714:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 21715:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 21735:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 21737:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 21782:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 21784:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 21785:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 21817:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 21818:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 21819:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 21820:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 21821:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 21822:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 21861:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 21862:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 21863:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 21883:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 21885:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 21930:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 21932:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 21933:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 21965:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 21966:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 21967:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 21968:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 21969:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 21970:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 22009:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 22010:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 22011:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 22031:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 22033:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 22078:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22080:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22081:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22113:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 22114:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 22115:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 22116:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 22117:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 22118:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 22157:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 22158:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 22159:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 22179:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 22181:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 22226:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22228:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22229:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22261:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 22262:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 22263:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 22264:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 22265:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 22266:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 22305:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 22306:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 22307:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 22327:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 22329:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 22374:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22376:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22377:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22409:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 22410:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 22411:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 22412:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 22413:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 22414:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 22453:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 22454:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 22455:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 22475:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 22477:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 22522:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22524:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22525:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22557:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 22558:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 22559:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 22560:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 22561:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 22562:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 22601:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 22602:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 22603:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 22623:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 22625:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 22670:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22672:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22673:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 22705:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 22706:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 22707:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 22708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 22709:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 22710:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 22749:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 22750:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 22751:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 22771:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 22773:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 22818:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 22820:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 22821:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 22853:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 22854:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 22855:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 22856:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 22857:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 22858:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 22897:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 22898:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 22899:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 22919:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 22921:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 22966:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 22968:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 22969:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 23001:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 23002:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 23003:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 23004:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 23005:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 23006:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 23045:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 23046:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 23047:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 23067:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 23069:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 23114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 23116:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 23117:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 23149:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 23150:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 23151:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 23152:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 23153:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 23154:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 23193:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 23194:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 23195:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 23215:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 23217:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 23262:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 23264:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 23265:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 23297:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 23298:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 23299:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 23300:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 23301:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 23302:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 23341:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 23342:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 23343:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 23363:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 23365:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 23410:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 23412:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 23413:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 23445:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 23446:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 23447:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 23448:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 23449:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 23450:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 23459:
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias, true
	case 23462:
		return OpcuaNodeIdServicesMethod_AliasNameCategoryType_FindAlias, true
	case 23465:
		return OpcuaNodeIdServicesMethod_FindAliasMethodType, true
	case 23473:
		return OpcuaNodeIdServicesMethod_Aliases_SubAliasNameCategories_Placeholder_FindAlias, true
	case 23476:
		return OpcuaNodeIdServicesMethod_Aliases_FindAlias, true
	case 23482:
		return OpcuaNodeIdServicesMethod_TagVariables_SubAliasNameCategories_Placeholder_FindAlias, true
	case 23485:
		return OpcuaNodeIdServicesMethod_TagVariables_FindAlias, true
	case 23491:
		return OpcuaNodeIdServicesMethod_Topics_SubAliasNameCategories_Placeholder_FindAlias, true
	case 23494:
		return OpcuaNodeIdServicesMethod_Topics_FindAlias, true
	case 23526:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_GetRejectedList, true
	case 23529:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList, true
	case 23531:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList, true
	case 23533:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList, true
	case 23535:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList, true
	case 23544:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 23546:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 23548:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 23550:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 23552:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 23554:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 23637:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder, true
	case 23640:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder, true
	case 23673:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddDataSetFolder, true
	case 23676:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder, true
	case 23726:
		return OpcuaNodeIdServicesMethod_GetConnectionMethodType, true
	case 23729:
		return OpcuaNodeIdServicesMethod_ModifyConnectionMethodType, true
	case 23745:
		return OpcuaNodeIdServicesMethod_GetWriterGroupMethodType, true
	case 23748:
		return OpcuaNodeIdServicesMethod_ModifyWriterGroupMethodType, true
	case 23767:
		return OpcuaNodeIdServicesMethod_GetReaderGroupMethodType, true
	case 23770:
		return OpcuaNodeIdServicesMethod_ModifyReaderGroupMethodType, true
	case 23779:
		return OpcuaNodeIdServicesMethod_GetDataSetWriterMethodType, true
	case 23781:
		return OpcuaNodeIdServicesMethod_ModifyDataSetWriterMethodType, true
	case 23790:
		return OpcuaNodeIdServicesMethod_GetDataSetReaderMethodType, true
	case 23792:
		return OpcuaNodeIdServicesMethod_ModifyDataSetReaderMethodType, true
	case 23797:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet, true
	case 23800:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet, true
	case 23802:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder, true
	case 23805:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder, true
	case 23811:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddSubscribedDataSet, true
	case 23814:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveSubscribedDataSet, true
	case 23816:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_AddDataSetFolder, true
	case 23819:
		return OpcuaNodeIdServicesMethod_SubscribedDataSetFolderType_RemoveDataSetFolder, true
	case 23821:
		return OpcuaNodeIdServicesMethod_AddSubscribedDataSetMethodType, true
	case 23824:
		return OpcuaNodeIdServicesMethod_RemoveSubscribedDataSetMethodType, true
	case 24004:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet, true
	case 24007:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet, true
	case 24010:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet, true
	case 24013:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet, true
	case 2426:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Start, true
	case 24269:
		return OpcuaNodeIdServicesMethod_UserManagementType_AddUser, true
	case 2427:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Suspend, true
	case 24271:
		return OpcuaNodeIdServicesMethod_UserManagementType_ModifyUser, true
	case 24273:
		return OpcuaNodeIdServicesMethod_UserManagementType_RemoveUser, true
	case 24275:
		return OpcuaNodeIdServicesMethod_UserManagementType_ChangePassword, true
	case 2428:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Resume, true
	case 24282:
		return OpcuaNodeIdServicesMethod_AddUserMethodType, true
	case 24284:
		return OpcuaNodeIdServicesMethod_ModifyUserMethodType, true
	case 24286:
		return OpcuaNodeIdServicesMethod_RemoveUserMethodType, true
	case 24288:
		return OpcuaNodeIdServicesMethod_ChangePasswordMethodType, true
	case 2429:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Halt, true
	case 2430:
		return OpcuaNodeIdServicesMethod_ProgramStateMachineType_Reset, true
	case 24304:
		return OpcuaNodeIdServicesMethod_UserManagement_AddUser, true
	case 24306:
		return OpcuaNodeIdServicesMethod_UserManagement_ModifyUser, true
	case 24308:
		return OpcuaNodeIdServicesMethod_UserManagement_RemoveUser, true
	case 24310:
		return OpcuaNodeIdServicesMethod_UserManagement_ChangePassword, true
	case 24312:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Respond2, true
	case 24314:
		return OpcuaNodeIdServicesMethod_DialogResponse2MethodType, true
	case 24316:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Suppress2, true
	case 24318:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Unsuppress2, true
	case 24320:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_RemoveFromService2, true
	case 24322:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_PlaceInService2, true
	case 24324:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Reset2, true
	case 24326:
		return OpcuaNodeIdServicesMethod_WithCommentMethodType, true
	case 24328:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2, true
	case 24330:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2, true
	case 24332:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2, true
	case 24334:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2, true
	case 24336:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2, true
	case 24338:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Suppress2, true
	case 24340:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Unsuppress2, true
	case 24342:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_RemoveFromService2, true
	case 24344:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_PlaceInService2, true
	case 24346:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Reset2, true
	case 24348:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Suppress2, true
	case 24350:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Unsuppress2, true
	case 24352:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_RemoveFromService2, true
	case 24354:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_PlaceInService2, true
	case 24356:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Reset2, true
	case 24358:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Suppress2, true
	case 24360:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Unsuppress2, true
	case 24362:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_RemoveFromService2, true
	case 24364:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_PlaceInService2, true
	case 24366:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Reset2, true
	case 24368:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Suppress2, true
	case 24370:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Unsuppress2, true
	case 24372:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_RemoveFromService2, true
	case 24374:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_PlaceInService2, true
	case 24376:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Reset2, true
	case 24378:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Suppress2, true
	case 24380:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Unsuppress2, true
	case 24382:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_RemoveFromService2, true
	case 24384:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_PlaceInService2, true
	case 24386:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Reset2, true
	case 24388:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Suppress2, true
	case 24390:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Unsuppress2, true
	case 24392:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_RemoveFromService2, true
	case 24394:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_PlaceInService2, true
	case 24396:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Reset2, true
	case 24398:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Suppress2, true
	case 24400:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Unsuppress2, true
	case 24402:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_RemoveFromService2, true
	case 24404:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_PlaceInService2, true
	case 24406:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Reset2, true
	case 24408:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Suppress2, true
	case 24410:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Unsuppress2, true
	case 24412:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_RemoveFromService2, true
	case 24414:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_PlaceInService2, true
	case 24416:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Reset2, true
	case 24418:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Suppress2, true
	case 24420:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Unsuppress2, true
	case 24422:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_RemoveFromService2, true
	case 24424:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_PlaceInService2, true
	case 24426:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Reset2, true
	case 24428:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Suppress2, true
	case 24430:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Unsuppress2, true
	case 24432:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_RemoveFromService2, true
	case 24434:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_PlaceInService2, true
	case 24436:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Reset2, true
	case 24438:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Suppress2, true
	case 24440:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Unsuppress2, true
	case 24442:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_RemoveFromService2, true
	case 24444:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_PlaceInService2, true
	case 24446:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Reset2, true
	case 24448:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Suppress2, true
	case 24450:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Unsuppress2, true
	case 24452:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_RemoveFromService2, true
	case 24454:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_PlaceInService2, true
	case 24456:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Reset2, true
	case 24458:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Suppress2, true
	case 24460:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Unsuppress2, true
	case 24462:
		return OpcuaNodeIdServicesMethod_TripAlarmType_RemoveFromService2, true
	case 24464:
		return OpcuaNodeIdServicesMethod_TripAlarmType_PlaceInService2, true
	case 24466:
		return OpcuaNodeIdServicesMethod_TripAlarmType_Reset2, true
	case 24468:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Suppress2, true
	case 24470:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Unsuppress2, true
	case 24472:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_RemoveFromService2, true
	case 24474:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_PlaceInService2, true
	case 24476:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_Reset2, true
	case 24478:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Suppress2, true
	case 24480:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Unsuppress2, true
	case 24482:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_RemoveFromService2, true
	case 24484:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_PlaceInService2, true
	case 24486:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_Reset2, true
	case 24488:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Suppress2, true
	case 24490:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Unsuppress2, true
	case 24492:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_RemoveFromService2, true
	case 24494:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_PlaceInService2, true
	case 24496:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_Reset2, true
	case 24498:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Suppress2, true
	case 24500:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Unsuppress2, true
	case 24502:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_RemoveFromService2, true
	case 24504:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_PlaceInService2, true
	case 24506:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_Reset2, true
	case 24508:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Suppress2, true
	case 24510:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Unsuppress2, true
	case 24512:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_RemoveFromService2, true
	case 24514:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_PlaceInService2, true
	case 24516:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_Reset2, true
	case 24518:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Suppress2, true
	case 24520:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Unsuppress2, true
	case 24522:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_RemoveFromService2, true
	case 24524:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_PlaceInService2, true
	case 24526:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_Reset2, true
	case 24528:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Suppress2, true
	case 24530:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Unsuppress2, true
	case 24532:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_RemoveFromService2, true
	case 24534:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_PlaceInService2, true
	case 24536:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_Reset2, true
	case 24538:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24540:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24542:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24544:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24546:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24548:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24550:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24552:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24554:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24556:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24558:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24560:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24562:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24564:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24566:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24568:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24570:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24572:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24574:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24576:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24578:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24580:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24582:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24584:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24586:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24588:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24590:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24592:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24594:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24596:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24598:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2, true
	case 24600:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2, true
	case 24602:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2, true
	case 24604:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2, true
	case 24606:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2, true
	case 24608:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2, true
	case 24610:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2, true
	case 24612:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2, true
	case 24614:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2, true
	case 24616:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2, true
	case 24618:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24620:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24622:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24624:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24626:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24628:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24630:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24632:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24634:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24636:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24638:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24640:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24642:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24644:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24646:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24648:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24650:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24652:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24654:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24656:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24658:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24660:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24662:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24664:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24666:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24668:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24670:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24672:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24674:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24676:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24678:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 24680:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 24682:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 24684:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 24686:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 24688:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 24690:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 24692:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24694:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 24696:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 24698:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 24700:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 24702:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 24704:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 24706:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 24708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 24710:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 24712:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24714:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 24716:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 24718:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 24720:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 24722:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 24724:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 24726:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 24728:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 24730:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 24732:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 24734:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 24736:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 24738:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve2, true
	case 24740:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve2, true
	case 24742:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve2, true
	case 24744:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_GetGroupMemberships, true
	case 24746:
		return OpcuaNodeIdServicesMethod_GetGroupMembershipsMethodType, true
	case 24748:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2, true
	case 24750:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2, true
	case 24752:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2, true
	case 24754:
		return OpcuaNodeIdServicesMethod_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships, true
	case 24756:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve2, true
	case 24758:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve2, true
	case 24760:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve2, true
	case 24762:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve2, true
	case 24764:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve2, true
	case 24766:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve2, true
	case 24768:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_GetGroupMemberships, true
	case 24778:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2, true
	case 24780:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve2, true
	case 24782:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2, true
	case 24784:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_GetGroupMemberships, true
	case 24794:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2, true
	case 24796:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2, true
	case 24798:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2, true
	case 24800:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_GetGroupMemberships, true
	case 24810:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2, true
	case 24812:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2, true
	case 24814:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2, true
	case 24816:
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_GetGroupMemberships, true
	case 24826:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2, true
	case 24828:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve2, true
	case 24830:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2, true
	case 24832:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_GetGroupMemberships, true
	case 24842:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2, true
	case 24844:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2, true
	case 24846:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2, true
	case 24848:
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_GetGroupMemberships, true
	case 24858:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2, true
	case 24860:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2, true
	case 24862:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2, true
	case 24864:
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships, true
	case 24874:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2, true
	case 24876:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2, true
	case 24878:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2, true
	case 24880:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_GetGroupMemberships, true
	case 24890:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2, true
	case 24892:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2, true
	case 24894:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2, true
	case 24896:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_GetGroupMemberships, true
	case 24906:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve2, true
	case 24908:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve2, true
	case 24910:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve2, true
	case 24912:
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_GetGroupMemberships, true
	case 24914:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve2, true
	case 24916:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve2, true
	case 24918:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve2, true
	case 24920:
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_GetGroupMemberships, true
	case 24922:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve2, true
	case 24924:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve2, true
	case 24926:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve2, true
	case 24928:
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_GetGroupMemberships, true
	case 24930:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve2, true
	case 24932:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve2, true
	case 24934:
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve2, true
	case 24936:
		return OpcuaNodeIdServicesMethod_TripAlarmType_GetGroupMemberships, true
	case 24938:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2, true
	case 24940:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2, true
	case 24942:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2, true
	case 24944:
		return OpcuaNodeIdServicesMethod_InstrumentDiagnosticAlarmType_GetGroupMemberships, true
	case 24946:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_TimedShelve2, true
	case 24948:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_Unshelve2, true
	case 24950:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve2, true
	case 24952:
		return OpcuaNodeIdServicesMethod_SystemDiagnosticAlarmType_GetGroupMemberships, true
	case 24954:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_TimedShelve2, true
	case 24956:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_Unshelve2, true
	case 24958:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2, true
	case 24960:
		return OpcuaNodeIdServicesMethod_CertificateExpirationAlarmType_GetGroupMemberships, true
	case 24962:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_TimedShelve2, true
	case 24964:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_Unshelve2, true
	case 24966:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_ShelvingState_OneShotShelve2, true
	case 24968:
		return OpcuaNodeIdServicesMethod_DiscrepancyAlarmType_GetGroupMemberships, true
	case 24970:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2, true
	case 24972:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2, true
	case 24974:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2, true
	case 24976:
		return OpcuaNodeIdServicesMethod_TrustListOutOfDateAlarmType_GetGroupMemberships, true
	case 24978:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2, true
	case 24980:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2, true
	case 24982:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 24984:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_CertificateExpired_GetGroupMemberships, true
	case 24986:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 24988:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 24990:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 24992:
		return OpcuaNodeIdServicesMethod_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships, true
	case 24994:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 24996:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 24998:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25000:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25002:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25004:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25006:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25008:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25010:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25012:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25014:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25016:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25018:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25020:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25022:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25024:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25026:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25028:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25030:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25032:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25034:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25036:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25038:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25040:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25042:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25044:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2, true
	case 25046:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25048:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships, true
	case 25050:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25052:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25054:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25056:
		return OpcuaNodeIdServicesMethod_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships, true
	case 25058:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25060:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25062:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25064:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25066:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25068:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25070:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25072:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25074:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25076:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25078:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25080:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25082:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25084:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25086:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25088:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25090:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25092:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25094:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25096:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25098:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25100:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25102:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25104:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25106:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25108:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25110:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25112:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25114:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25116:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25118:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25120:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25122:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25124:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25126:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25128:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 25130:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25132:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25134:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25136:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25138:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25140:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25142:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25144:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 25146:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 25148:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 25150:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 25152:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 25157:
		return OpcuaNodeIdServicesMethod_TimedShelve2MethodType, true
	case 25229:
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_AddPriorityMappingEntry, true
	case 25231:
		return OpcuaNodeIdServicesMethod_PriorityMappingTableType_DeletePriorityMappingEntry, true
	case 25233:
		return OpcuaNodeIdServicesMethod_AddPriorityMappingEntryMethodType, true
	case 25235:
		return OpcuaNodeIdServicesMethod_DeletePriorityMappingEntryMethodType, true
	case 25271:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder, true
	case 25274:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder, true
	case 25278:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTarget, true
	case 25281:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget, true
	case 25283:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder, true
	case 25286:
		return OpcuaNodeIdServicesMethod_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder, true
	case 25288:
		return OpcuaNodeIdServicesMethod_AddSecurityGroupFolderMethodType, true
	case 25291:
		return OpcuaNodeIdServicesMethod_RemoveSecurityGroupFolderMethodType, true
	case 25293:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder, true
	case 25296:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder, true
	case 25312:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_AddSecurityGroupFolder, true
	case 25315:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_RemoveSecurityGroupFolder, true
	case 25331:
		return OpcuaNodeIdServicesMethod_ConnectSecurityGroupsMethodType, true
	case 25334:
		return OpcuaNodeIdServicesMethod_DisconnectSecurityGroupsMethodType, true
	case 25348:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget, true
	case 25351:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget, true
	case 25353:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder, true
	case 25356:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder, true
	case 25366:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTarget, true
	case 25369:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTarget, true
	case 25371:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_AddPushTargetFolder, true
	case 25374:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_RemovePushTargetFolder, true
	case 25376:
		return OpcuaNodeIdServicesMethod_AddPushTargetMethodType, true
	case 25379:
		return OpcuaNodeIdServicesMethod_RemovePushTargetMethodType, true
	case 25381:
		return OpcuaNodeIdServicesMethod_AddPushTargetFolderMethodType, true
	case 25384:
		return OpcuaNodeIdServicesMethod_RemovePushTargetFolderMethodType, true
	case 25386:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder, true
	case 25389:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder, true
	case 25393:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTarget, true
	case 25396:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTarget, true
	case 25398:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder, true
	case 25401:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder, true
	case 25411:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Open, true
	case 25414:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Close, true
	case 25416:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Read, true
	case 25419:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_Write, true
	case 25421:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_GetPosition, true
	case 25424:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_SetPosition, true
	case 25426:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_ReserveIds, true
	case 25429:
		return OpcuaNodeIdServicesMethod_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate, true
	case 25434:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder, true
	case 25437:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder, true
	case 25441:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTarget, true
	case 25444:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTarget, true
	case 25446:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_AddPushTargetFolder, true
	case 25449:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder, true
	case 25459:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Open, true
	case 25462:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Close, true
	case 25464:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Read, true
	case 25467:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_Write, true
	case 25469:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_GetPosition, true
	case 25472:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_SetPosition, true
	case 25474:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_ReserveIds, true
	case 25477:
		return OpcuaNodeIdServicesMethod_PublishSubscribe_PubSubConfiguration_CloseAndUpdate, true
	case 25490:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_Open, true
	case 25493:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_Close, true
	case 25495:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_Read, true
	case 25498:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_Write, true
	case 25500:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_GetPosition, true
	case 25503:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_SetPosition, true
	case 25505:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_ReserveIds, true
	case 25508:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationType_CloseAndUpdate, true
	case 25511:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeReserveIdsMethodType, true
	case 25514:
		return OpcuaNodeIdServicesMethod_PubSubConfigurationTypeCloseAndUpdateMethodType, true
	case 25572:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddIdentity, true
	case 25574:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity, true
	case 25576:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddApplication, true
	case 25578:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication, true
	case 25580:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint, true
	case 25582:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint, true
	case 25591:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddIdentity, true
	case 25593:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveIdentity, true
	case 25595:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddApplication, true
	case 25597:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveApplication, true
	case 25599:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_AddEndpoint, true
	case 25601:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint, true
	case 25610:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddIdentity, true
	case 25612:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity, true
	case 25614:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddApplication, true
	case 25616:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveApplication, true
	case 25618:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_AddEndpoint, true
	case 25620:
		return OpcuaNodeIdServicesMethod_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint, true
	case 25622:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case 25623:
		return OpcuaNodeIdServicesMethod_SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case 25624:
		return OpcuaNodeIdServicesMethod_SecurityGroupType_InvalidateKeys, true
	case 25625:
		return OpcuaNodeIdServicesMethod_SecurityGroupType_ForceKeyRotation, true
	case 25632:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys, true
	case 25633:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation, true
	case 25641:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_ConnectSecurityGroups, true
	case 25644:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_DisconnectSecurityGroups, true
	case 25647:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetType_TriggerKeyUpdate, true
	case 25655:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups, true
	case 25658:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups, true
	case 25661:
		return OpcuaNodeIdServicesMethod_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate, true
	case 25698:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_CancelChanges, true
	case 25699:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_ResetToServerDefaults, true
	case 25708:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_CancelChanges, true
	case 25709:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_ResetToServerDefaults, true
	case 25710:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_SetAdminPassword, true
	case 25727:
		return OpcuaNodeIdServicesMethod_RequestTicketsMethodType, true
	case 25729:
		return OpcuaNodeIdServicesMethod_SetRegistrarEndpointsMethodType, true
	case 25742:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 25745:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 25747:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 25750:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 25752:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 25755:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 25760:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 25763:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 25766:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 25768:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 25772:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 25807:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 25808:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 25809:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 25829:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 25831:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 25876:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 25878:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 25880:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 25881:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 25883:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 25884:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 25917:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 25918:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 25919:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 25921:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 25922:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 25924:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 25925:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 25927:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 25928:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 25930:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 25931:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 25933:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 25973:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 25974:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 25975:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 25995:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 25997:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 26042:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 26044:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 26046:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 26047:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 26049:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 26050:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 26083:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 26084:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 26085:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 26087:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 26088:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 26090:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 26091:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 26093:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 26094:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 26096:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 26097:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 26099:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 26114:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 26117:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 26119:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 26122:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 26124:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 26127:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 26132:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 26135:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 26138:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 26140:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 26144:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 26179:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 26180:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 26181:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 26201:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 26203:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 26248:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 26250:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 26252:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 26253:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 26255:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 26256:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 26289:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 26290:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 26291:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 26293:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 26294:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 26296:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 26297:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 26299:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 26300:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 26302:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 26303:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 26305:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 26345:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 26346:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 26347:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 26367:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 26369:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 26414:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 26416:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 26418:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 26419:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 26421:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 26422:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 26455:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 26456:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 26457:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 26459:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 26460:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 26462:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 26463:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 26465:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 26466:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 26468:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 26469:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 26471:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 26486:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 26489:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 26491:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 26494:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 26496:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 26499:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 26504:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 26507:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 26510:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 26512:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 26516:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 26551:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 26552:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 26553:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 26573:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 26575:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 26620:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 26622:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 26624:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 26625:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 26627:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 26628:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 26661:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 26662:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 26663:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 26665:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 26666:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 26668:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 26669:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 26671:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 26672:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 26674:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 26675:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 26677:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 26717:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 26718:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 26719:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 26739:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 26741:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 26786:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 26788:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 26790:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 26791:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 26793:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 26794:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 26827:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 26828:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 26829:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 26831:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 26832:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 26834:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 26835:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 26837:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 26838:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 26840:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 26841:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 26843:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 26858:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_UpdateCertificate, true
	case 26861:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ApplyChanges, true
	case 26862:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CancelChanges, true
	case 26863:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_CreateSigningRequest, true
	case 26866:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetRejectedList, true
	case 26868:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_ResetToServerDefaults, true
	case 26873:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_RequestTickets, true
	case 26875:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_SetRegistrarEndpoints, true
	case 26889:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 26892:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 26894:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 26897:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 26899:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 26902:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 26907:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 26910:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 26913:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 26915:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 26919:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 26954:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 26955:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 26956:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 26976:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 26978:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 27023:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27025:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27027:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27028:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27030:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27031:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27064:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 27065:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 27066:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 27068:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 27069:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 27071:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 27072:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 27074:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 27075:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 27077:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 27078:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 27080:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 27120:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 27121:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 27122:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 27142:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 27144:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 27189:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27191:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27193:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27194:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27196:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27197:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27230:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 27231:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 27232:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 27234:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 27235:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 27237:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 27238:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27240:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 27241:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 27243:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 27244:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 27246:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 27261:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 27264:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 27266:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 27269:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 27271:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 27274:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 27279:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 27282:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 27285:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 27287:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 27291:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 27326:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 27327:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 27328:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 27348:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 27350:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 27395:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27397:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27399:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27400:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27402:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27403:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27436:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 27437:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 27438:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 27440:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 27441:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 27443:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 27444:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 27446:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 27447:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 27449:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 27450:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 27452:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 27492:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 27493:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 27494:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 27514:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 27516:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 27561:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27563:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27565:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27566:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27568:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27569:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27602:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 27603:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 27604:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 27606:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 27607:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 27609:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 27610:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27612:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 27613:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 27615:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 27616:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 27618:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 27633:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 27636:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 27638:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 27641:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 27643:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 27646:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 27651:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 27654:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 27657:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 27659:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 27663:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 27698:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 27699:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 27700:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 27720:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 27722:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 27767:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 27769:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 27771:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 27772:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 27774:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 27775:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 27808:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 27809:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 27810:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 27812:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 27813:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 27815:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 27816:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 27818:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 27819:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 27821:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 27822:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 27824:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 27864:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 27865:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 27866:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 27886:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 27888:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 27933:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 27935:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 27937:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 27938:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 27940:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 27941:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 27974:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 27975:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 27976:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 27978:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 27979:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 27981:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 27982:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 27984:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 27985:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 27987:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 27988:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 27990:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 28005:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate, true
	case 28008:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges, true
	case 28009:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges, true
	case 28010:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest, true
	case 28013:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList, true
	case 28015:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults, true
	case 2947:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_Unshelve, true
	case 2948:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_OneShotShelve, true
	case 2949:
		return OpcuaNodeIdServicesMethod_ShelvedStateMachineType_TimedShelve, true
	case 29880:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_RequestTickets, true
	case 29882:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_SetRegistrarEndpoints, true
	case 29896:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open, true
	case 29899:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close, true
	case 29901:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read, true
	case 29904:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write, true
	case 29906:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition, true
	case 29909:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition, true
	case 29914:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks, true
	case 29917:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate, true
	case 29920:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate, true
	case 29922:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate, true
	case 29926:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList, true
	case 29961:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable, true
	case 29962:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable, true
	case 29963:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment, true
	case 29983:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge, true
	case 29985:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm, true
	case 30030:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 30032:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 30034:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 30035:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 30037:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 30038:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 30071:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence, true
	case 30072:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress, true
	case 30073:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2, true
	case 30075:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress, true
	case 30076:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2, true
	case 30078:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService, true
	case 30079:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2, true
	case 30081:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService, true
	case 30082:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2, true
	case 30084:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset, true
	case 30085:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2, true
	case 30087:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships, true
	case 30127:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable, true
	case 30128:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable, true
	case 30129:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment, true
	case 30149:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge, true
	case 30151:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm, true
	case 30196:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 30198:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 30200:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 30201:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 30203:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 30204:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 30237:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence, true
	case 30238:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress, true
	case 30239:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2, true
	case 30241:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress, true
	case 30242:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2, true
	case 30244:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService, true
	case 30245:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2, true
	case 30247:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService, true
	case 30248:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2, true
	case 30250:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset, true
	case 30251:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2, true
	case 30253:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 30268:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open, true
	case 30271:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close, true
	case 30273:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read, true
	case 30276:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write, true
	case 30278:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition, true
	case 30281:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition, true
	case 30286:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks, true
	case 30289:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate, true
	case 30292:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate, true
	case 30294:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate, true
	case 30298:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList, true
	case 30333:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable, true
	case 30334:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable, true
	case 30335:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment, true
	case 30355:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge, true
	case 30357:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm, true
	case 30402:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 30404:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 30406:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 30407:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 30409:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 30410:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 30443:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence, true
	case 30444:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress, true
	case 30445:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2, true
	case 30447:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress, true
	case 30448:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2, true
	case 30450:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService, true
	case 30451:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2, true
	case 30453:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService, true
	case 30454:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2, true
	case 30456:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset, true
	case 30457:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2, true
	case 30459:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships, true
	case 30499:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable, true
	case 30500:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable, true
	case 30501:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment, true
	case 30521:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge, true
	case 30523:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm, true
	case 30568:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 30570:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 30572:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 30573:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 30575:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 30576:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 30609:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence, true
	case 30610:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress, true
	case 30611:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2, true
	case 30613:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress, true
	case 30614:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2, true
	case 30616:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService, true
	case 30617:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2, true
	case 30619:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService, true
	case 30620:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2, true
	case 30622:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset, true
	case 30623:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2, true
	case 30625:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 30640:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open, true
	case 30643:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close, true
	case 30645:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read, true
	case 30648:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write, true
	case 30650:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition, true
	case 30653:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition, true
	case 30658:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks, true
	case 30661:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate, true
	case 30664:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate, true
	case 30666:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate, true
	case 30670:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList, true
	case 30705:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable, true
	case 30706:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable, true
	case 30707:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment, true
	case 30727:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge, true
	case 30729:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm, true
	case 30774:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve, true
	case 30776:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2, true
	case 30778:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve, true
	case 30779:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2, true
	case 30781:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve, true
	case 30782:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2, true
	case 30815:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence, true
	case 30816:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress, true
	case 30817:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2, true
	case 30819:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress, true
	case 30820:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2, true
	case 30822:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService, true
	case 30823:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2, true
	case 30825:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService, true
	case 30826:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2, true
	case 30828:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset, true
	case 30829:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2, true
	case 30831:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships, true
	case 30871:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable, true
	case 30872:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable, true
	case 30873:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment, true
	case 30893:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge, true
	case 30895:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm, true
	case 30940:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve, true
	case 30942:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2, true
	case 30944:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve, true
	case 30945:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2, true
	case 30947:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve, true
	case 30948:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2, true
	case 30981:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence, true
	case 30982:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress, true
	case 30983:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2, true
	case 30985:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress, true
	case 30986:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2, true
	case 30988:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService, true
	case 30989:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2, true
	case 30991:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService, true
	case 30992:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2, true
	case 30994:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset, true
	case 30995:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2, true
	case 30997:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships, true
	case 31384:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate, true
	case 31387:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ApplyChanges, true
	case 31388:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CancelChanges, true
	case 31389:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest, true
	case 31392:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList, true
	case 31394:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_ResetToServerDefaults, true
	case 32098:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Disable, true
	case 32099:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Enable, true
	case 32100:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment, true
	case 32120:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge, true
	case 32122:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm, true
	case 32167:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve, true
	case 32169:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2, true
	case 32171:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve, true
	case 32172:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2, true
	case 32174:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve, true
	case 32175:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2, true
	case 32208:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Silence, true
	case 32209:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress, true
	case 32210:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2, true
	case 32212:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress, true
	case 32213:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2, true
	case 32215:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService, true
	case 32216:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2, true
	case 32218:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService, true
	case 32219:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2, true
	case 32221:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset, true
	case 32222:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2, true
	case 32224:
		return OpcuaNodeIdServicesMethod_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships, true
	case 32282:
		return OpcuaNodeIdServicesMethod_GetCertificatesMethodType, true
	case 32296:
		return OpcuaNodeIdServicesMethod_ServerConfigurationType_GetCertificates, true
	case 32333:
		return OpcuaNodeIdServicesMethod_ServerConfiguration_GetCertificates, true
	case 32346:
		return OpcuaNodeIdServicesMethod_ApplicationConfigurationType_GetCertificates, true
	case 32359:
		return OpcuaNodeIdServicesMethod_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates, true
	case 32372:
		return OpcuaNodeIdServicesMethod_ProvisionableDevice_ApplicationName_Placeholder_GetCertificates, true
	case 32406:
		return OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityKeys, true
	case 32409:
		return OpcuaNodeIdServicesMethod_DataSetClasses_GetSecurityGroup, true
	case 32413:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroup, true
	case 32416:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroup, true
	case 32418:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_AddSecurityGroupFolder, true
	case 32421:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SecurityGroups_RemoveSecurityGroupFolder, true
	case 32425:
		return OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTarget, true
	case 32428:
		return OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTarget, true
	case 32430:
		return OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_AddPushTargetFolder, true
	case 32433:
		return OpcuaNodeIdServicesMethod_DataSetClasses_KeyPushTargets_RemovePushTargetFolder, true
	case 32450:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Enable, true
	case 32451:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Status_Disable, true
	case 32464:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Reset, true
	case 32500:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddWriterGroup, true
	case 32503:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_AddReaderGroup, true
	case 32506:
		return OpcuaNodeIdServicesMethod_DataSetClasses_ConnectionName_Placeholder_RemoveGroup, true
	case 32508:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SetSecurityKeys, true
	case 32510:
		return OpcuaNodeIdServicesMethod_DataSetClasses_AddConnection, true
	case 32513:
		return OpcuaNodeIdServicesMethod_DataSetClasses_RemoveConnection, true
	case 32516:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItems, true
	case 32519:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEvents, true
	case 32522:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate, true
	case 32525:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate, true
	case 32528:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemovePublishedDataSet, true
	case 32530:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_AddDataSetFolder, true
	case 32533:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PublishedDataSets_RemoveDataSetFolder, true
	case 32536:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddSubscribedDataSet, true
	case 32539:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveSubscribedDataSet, true
	case 32541:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_AddDataSetFolder, true
	case 32544:
		return OpcuaNodeIdServicesMethod_DataSetClasses_SubscribedDataSets_RemoveDataSetFolder, true
	case 32554:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Open, true
	case 32557:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Close, true
	case 32559:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Read, true
	case 32562:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_Write, true
	case 32564:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_GetPosition, true
	case 32567:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_SetPosition, true
	case 32569:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_ReserveIds, true
	case 32572:
		return OpcuaNodeIdServicesMethod_DataSetClasses_PubSubConfiguration_CloseAndUpdate, true
	case 32577:
		return OpcuaNodeIdServicesMethod_DataSetClasses_Status_Enable, true
	case 32578:
		return OpcuaNodeIdServicesMethod_DataSetClasses_Status_Disable, true
	case 32591:
		return OpcuaNodeIdServicesMethod_DataSetClasses_Diagnostics_Reset, true
	case 3863:
		return OpcuaNodeIdServicesMethod_AddCommentMethodType, true
	case 3875:
		return OpcuaNodeIdServicesMethod_ConditionType_ConditionRefresh, true
	case 4198:
		return OpcuaNodeIdServicesMethod_DialogConditionType_ConditionRefresh, true
	case 5123:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_ConditionRefresh, true
	case 5550:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ConditionRefresh, true
	case 6102:
		return OpcuaNodeIdServicesMethod_TimedShelveMethodType, true
	case 6126:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ConditionRefresh, true
	case 9007:
		return OpcuaNodeIdServicesMethod_ConditionRefreshMethodType, true
	case 9027:
		return OpcuaNodeIdServicesMethod_ConditionType_Enable, true
	case 9028:
		return OpcuaNodeIdServicesMethod_ConditionType_Disable, true
	case 9029:
		return OpcuaNodeIdServicesMethod_ConditionType_AddComment, true
	case 9031:
		return OpcuaNodeIdServicesMethod_DialogResponseMethodType, true
	case 9051:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Enable, true
	case 9052:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Disable, true
	case 9053:
		return OpcuaNodeIdServicesMethod_DialogConditionType_AddComment, true
	case 9069:
		return OpcuaNodeIdServicesMethod_DialogConditionType_Respond, true
	case 9089:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Enable, true
	case 9090:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Disable, true
	case 9091:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_AddComment, true
	case 9111:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Acknowledge, true
	case 9113:
		return OpcuaNodeIdServicesMethod_AcknowledgeableConditionType_Confirm, true
	case 9134:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Enable, true
	case 9135:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Disable, true
	case 9136:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_AddComment, true
	case 9156:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Acknowledge, true
	case 9158:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_Confirm, true
	case 9211:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_Unshelve, true
	case 9212:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_OneShotShelve, true
	case 9213:
		return OpcuaNodeIdServicesMethod_AlarmConditionType_ShelvingState_TimedShelve, true
	case 9235:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Enable, true
	case 9236:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Disable, true
	case 9237:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_AddComment, true
	case 9257:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Acknowledge, true
	case 9259:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_Confirm, true
	case 9312:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_Unshelve, true
	case 9313:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_OneShotShelve, true
	case 9314:
		return OpcuaNodeIdServicesMethod_LimitAlarmType_ShelvingState_TimedShelve, true
	case 9370:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Enable, true
	case 9371:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Disable, true
	case 9372:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_AddComment, true
	case 9374:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ConditionRefresh, true
	case 9394:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Acknowledge, true
	case 9396:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_Confirm, true
	case 9449:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_Unshelve, true
	case 9450:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve, true
	case 9451:
		return OpcuaNodeIdServicesMethod_ExclusiveLimitAlarmType_ShelvingState_TimedShelve, true
	case 9511:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Enable, true
	case 9512:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Disable, true
	case 9513:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_AddComment, true
	case 9515:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ConditionRefresh, true
	case 9535:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Acknowledge, true
	case 9537:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_Confirm, true
	case 9590:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_Unshelve, true
	case 9591:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve, true
	case 9592:
		return OpcuaNodeIdServicesMethod_ExclusiveLevelAlarmType_ShelvingState_TimedShelve, true
	case 9652:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Enable, true
	case 9653:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Disable, true
	case 9654:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_AddComment, true
	case 9656:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ConditionRefresh, true
	case 9676:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Acknowledge, true
	case 9678:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_Confirm, true
	case 9731:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve, true
	case 9732:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve, true
	case 9733:
		return OpcuaNodeIdServicesMethod_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve, true
	case 9793:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Enable, true
	case 9794:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Disable, true
	case 9795:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_AddComment, true
	case 9797:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ConditionRefresh, true
	case 9817:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Acknowledge, true
	case 9819:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_Confirm, true
	case 9872:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_Unshelve, true
	case 9873:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve, true
	case 9874:
		return OpcuaNodeIdServicesMethod_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve, true
	case 9935:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Enable, true
	case 9936:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Disable, true
	case 9937:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_AddComment, true
	case 9939:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ConditionRefresh, true
	case 9959:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Acknowledge, true
	case 9961:
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_Confirm, true
	}
	return 0, false
}

func OpcuaNodeIdServicesMethodByName(value string) (enum OpcuaNodeIdServicesMethod, ok bool) {
	switch value {
	case "NonExclusiveLimitAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_Unshelve, true
	case "NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve, true
	case "NonExclusiveLimitAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve, true
	case "NonExclusiveLevelAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Enable, true
	case "NonExclusiveLevelAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Disable, true
	case "NonExclusiveLevelAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_AddComment, true
	case "NonExclusiveLevelAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ConditionRefresh, true
	case "NonExclusiveLevelAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Acknowledge, true
	case "NonExclusiveLevelAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_Confirm, true
	case "NonExclusiveLevelAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_Unshelve, true
	case "NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve, true
	case "NonExclusiveLevelAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve, true
	case "NonExclusiveRateOfChangeAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Enable, true
	case "NonExclusiveRateOfChangeAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Disable, true
	case "NonExclusiveRateOfChangeAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_AddComment, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ConditionRefresh, true
	case "NonExclusiveRateOfChangeAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Acknowledge, true
	case "NonExclusiveRateOfChangeAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_Confirm, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve, true
	case "NonExclusiveDeviationAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Enable, true
	case "NonExclusiveDeviationAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Disable, true
	case "NonExclusiveDeviationAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_AddComment, true
	case "NonExclusiveDeviationAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ConditionRefresh, true
	case "NonExclusiveDeviationAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Acknowledge, true
	case "NonExclusiveDeviationAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_Confirm, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve, true
	case "DiscreteAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Enable, true
	case "DiscreteAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Disable, true
	case "DiscreteAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_AddComment, true
	case "DiscreteAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ConditionRefresh, true
	case "DiscreteAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Acknowledge, true
	case "DiscreteAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_Confirm, true
	case "DiscreteAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_Unshelve, true
	case "DiscreteAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_OneShotShelve, true
	case "DiscreteAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_DiscreteAlarmType_ShelvingState_TimedShelve, true
	case "OffNormalAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Enable, true
	case "OffNormalAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Disable, true
	case "OffNormalAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_AddComment, true
	case "OffNormalAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ConditionRefresh, true
	case "OffNormalAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Acknowledge, true
	case "OffNormalAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_Confirm, true
	case "OffNormalAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_Unshelve, true
	case "OffNormalAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_OneShotShelve, true
	case "OffNormalAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_OffNormalAlarmType_ShelvingState_TimedShelve, true
	case "TripAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_TripAlarmType_Enable, true
	case "TripAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_TripAlarmType_Disable, true
	case "TripAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_TripAlarmType_AddComment, true
	case "TripAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_TripAlarmType_ConditionRefresh, true
	case "TripAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_TripAlarmType_Acknowledge, true
	case "TripAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_TripAlarmType_Confirm, true
	case "TripAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_Unshelve, true
	case "TripAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_OneShotShelve, true
	case "TripAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_TripAlarmType_ShelvingState_TimedShelve, true
	case "ServerType_GetMonitoredItems":
		return OpcuaNodeIdServicesMethod_ServerType_GetMonitoredItems, true
	case "Server_GetMonitoredItems":
		return OpcuaNodeIdServicesMethod_Server_GetMonitoredItems, true
	case "GetMonitoredItemsMethodType":
		return OpcuaNodeIdServicesMethod_GetMonitoredItemsMethodType, true
	case "FileType_Open":
		return OpcuaNodeIdServicesMethod_FileType_Open, true
	case "FileType_Close":
		return OpcuaNodeIdServicesMethod_FileType_Close, true
	case "FileType_Read":
		return OpcuaNodeIdServicesMethod_FileType_Read, true
	case "FileType_Write":
		return OpcuaNodeIdServicesMethod_FileType_Write, true
	case "FileType_GetPosition":
		return OpcuaNodeIdServicesMethod_FileType_GetPosition, true
	case "FileType_SetPosition":
		return OpcuaNodeIdServicesMethod_FileType_SetPosition, true
	case "AddressSpaceFileType_Open":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Open, true
	case "AddressSpaceFileType_Close":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Close, true
	case "AddressSpaceFileType_Read":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Read, true
	case "AddressSpaceFileType_Write":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_Write, true
	case "AddressSpaceFileType_GetPosition":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_GetPosition, true
	case "AddressSpaceFileType_SetPosition":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_SetPosition, true
	case "AddressSpaceFileType_ExportNamespace":
		return OpcuaNodeIdServicesMethod_AddressSpaceFileType_ExportNamespace, true
	case "NamespaceMetadataType_NamespaceFile_Open":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Open, true
	case "NamespaceMetadataType_NamespaceFile_Close":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Close, true
	case "NamespaceMetadataType_NamespaceFile_Read":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Read, true
	case "NamespaceMetadataType_NamespaceFile_Write":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_Write, true
	case "NamespaceMetadataType_NamespaceFile_GetPosition":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_GetPosition, true
	case "NamespaceMetadataType_NamespaceFile_SetPosition":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_SetPosition, true
	case "NamespaceMetadataType_NamespaceFile_ExportNamespace":
		return OpcuaNodeIdServicesMethod_NamespaceMetadataType_NamespaceFile_ExportNamespace, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace":
		return OpcuaNodeIdServicesMethod_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace, true
	case "OpenMethodType":
		return OpcuaNodeIdServicesMethod_OpenMethodType, true
	case "CloseMethodType":
		return OpcuaNodeIdServicesMethod_CloseMethodType, true
	case "ReadMethodType":
		return OpcuaNodeIdServicesMethod_ReadMethodType, true
	case "WriteMethodType":
		return OpcuaNodeIdServicesMethod_WriteMethodType, true
	case "GetPositionMethodType":
		return OpcuaNodeIdServicesMethod_GetPositionMethodType, true
	case "SetPositionMethodType":
		return OpcuaNodeIdServicesMethod_SetPositionMethodType, true
	case "SystemOffNormalAlarmType_Disable":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Disable, true
	case "SystemOffNormalAlarmType_Enable":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Enable, true
	case "SystemOffNormalAlarmType_AddComment":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_AddComment, true
	case "SystemOffNormalAlarmType_ConditionRefresh":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ConditionRefresh, true
	case "SystemOffNormalAlarmType_Acknowledge":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Acknowledge, true
	case "SystemOffNormalAlarmType_Confirm":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_Confirm, true
	case "SystemOffNormalAlarmType_ShelvingState_Unshelve":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_Unshelve, true
	case "SystemOffNormalAlarmType_ShelvingState_OneShotShelve":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_OneShotShelve, true
	case "SystemOffNormalAlarmType_ShelvingState_TimedShelve":
		return OpcuaNodeIdServicesMethod_SystemOffNormalAlarmType_ShelvingState_TimedShelve, true
	case "OpenWithMasksMethodType":
		return OpcuaNodeIdServicesMethod_OpenWithMasksMethodType, true
	case "CloseAndUpdateMethodType":
		return OpcuaNodeIdServicesMethod_CloseAndUpdateMethodType, true
	case "AddCertificateMethodType":
		return OpcuaNodeIdServicesMethod_AddCertificateMethodType, true
	case "RemoveCertificateMethodType":
		return OpcuaNodeIdServicesMethod_RemoveCertificateMethodType, true
	case "TrustListType_Open":
		return OpcuaNodeIdServicesMethod_TrustListType_Open, true
	case "TrustListType_Close":
		return OpcuaNodeIdServicesMethod_TrustListType_Close, true
	case "TrustListType_Read":
		return OpcuaNodeIdServicesMethod_TrustListType_Read, true
	case "TrustListType_Write":
		return OpcuaNodeIdServicesMethod_TrustListType_Write, true
	case "TrustListType_GetPosition":
		return OpcuaNodeIdServicesMethod_TrustListType_GetPosition, true
	case "TrustListType_SetPosi