/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// NetworkAddressDataType is the corresponding interface of NetworkAddressDataType
type NetworkAddressDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetNetworkInterface returns NetworkInterface (property field)
	GetNetworkInterface() PascalString
}

// NetworkAddressDataTypeExactly can be used when we want exactly this type and not a type which fulfills NetworkAddressDataType.
// This is useful for switch cases.
type NetworkAddressDataTypeExactly interface {
	NetworkAddressDataType
	isNetworkAddressDataType() bool
}

// _NetworkAddressDataType is the data-structure of this message
type _NetworkAddressDataType struct {
	*_ExtensionObjectDefinition
	NetworkInterface PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NetworkAddressDataType) GetIdentifier() string {
	return "15504"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NetworkAddressDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_NetworkAddressDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NetworkAddressDataType) GetNetworkInterface() PascalString {
	return m.NetworkInterface
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewNetworkAddressDataType factory function for _NetworkAddressDataType
func NewNetworkAddressDataType(networkInterface PascalString) *_NetworkAddressDataType {
	_result := &_NetworkAddressDataType{
		NetworkInterface:           networkInterface,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastNetworkAddressDataType(structType any) NetworkAddressDataType {
	if casted, ok := structType.(NetworkAddressDataType); ok {
		return casted
	}
	if casted, ok := structType.(*NetworkAddressDataType); ok {
		return *casted
	}
	return nil
}

func (m *_NetworkAddressDataType) GetTypeName() string {
	return "NetworkAddressDataType"
}

func (m *_NetworkAddressDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (networkInterface)
	lengthInBits += m.NetworkInterface.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_NetworkAddressDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NetworkAddressDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (NetworkAddressDataType, error) {
	return NetworkAddressDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func NetworkAddressDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (NetworkAddressDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("NetworkAddressDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NetworkAddressDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (networkInterface)
	if pullErr := readBuffer.PullContext("networkInterface"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for networkInterface")
	}
	_networkInterface, _networkInterfaceErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _networkInterfaceErr != nil {
		return nil, errors.Wrap(_networkInterfaceErr, "Error parsing 'networkInterface' field of NetworkAddressDataType")
	}
	networkInterface := _networkInterface.(PascalString)
	if closeErr := readBuffer.CloseContext("networkInterface"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for networkInterface")
	}

	if closeErr := readBuffer.CloseContext("NetworkAddressDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NetworkAddressDataType")
	}

	// Create a partially initialized instance
	_child := &_NetworkAddressDataType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		NetworkInterface:           networkInterface,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_NetworkAddressDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NetworkAddressDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NetworkAddressDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NetworkAddressDataType")
		}

		// Simple Field (networkInterface)
		if pushErr := writeBuffer.PushContext("networkInterface"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for networkInterface")
		}
		_networkInterfaceErr := writeBuffer.WriteSerializable(ctx, m.GetNetworkInterface())
		if popErr := writeBuffer.PopContext("networkInterface"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for networkInterface")
		}
		if _networkInterfaceErr != nil {
			return errors.Wrap(_networkInterfaceErr, "Error serializing 'networkInterface' field")
		}

		if popErr := writeBuffer.PopContext("NetworkAddressDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NetworkAddressDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NetworkAddressDataType) isNetworkAddressDataType() bool {
	return true
}

func (m *_NetworkAddressDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
