/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ModifySubscriptionRequest is the corresponding interface of ModifySubscriptionRequest
type ModifySubscriptionRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetRequestedPublishingInterval returns RequestedPublishingInterval (property field)
	GetRequestedPublishingInterval() float64
	// GetRequestedLifetimeCount returns RequestedLifetimeCount (property field)
	GetRequestedLifetimeCount() uint32
	// GetRequestedMaxKeepAliveCount returns RequestedMaxKeepAliveCount (property field)
	GetRequestedMaxKeepAliveCount() uint32
	// GetMaxNotificationsPerPublish returns MaxNotificationsPerPublish (property field)
	GetMaxNotificationsPerPublish() uint32
	// GetPriority returns Priority (property field)
	GetPriority() uint8
}

// ModifySubscriptionRequestExactly can be used when we want exactly this type and not a type which fulfills ModifySubscriptionRequest.
// This is useful for switch cases.
type ModifySubscriptionRequestExactly interface {
	ModifySubscriptionRequest
	isModifySubscriptionRequest() bool
}

// _ModifySubscriptionRequest is the data-structure of this message
type _ModifySubscriptionRequest struct {
	*_ExtensionObjectDefinition
	RequestHeader               ExtensionObjectDefinition
	SubscriptionId              uint32
	RequestedPublishingInterval float64
	RequestedLifetimeCount      uint32
	RequestedMaxKeepAliveCount  uint32
	MaxNotificationsPerPublish  uint32
	Priority                    uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModifySubscriptionRequest) GetIdentifier() string {
	return "793"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModifySubscriptionRequest) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_ModifySubscriptionRequest) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModifySubscriptionRequest) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_ModifySubscriptionRequest) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_ModifySubscriptionRequest) GetRequestedPublishingInterval() float64 {
	return m.RequestedPublishingInterval
}

func (m *_ModifySubscriptionRequest) GetRequestedLifetimeCount() uint32 {
	return m.RequestedLifetimeCount
}

func (m *_ModifySubscriptionRequest) GetRequestedMaxKeepAliveCount() uint32 {
	return m.RequestedMaxKeepAliveCount
}

func (m *_ModifySubscriptionRequest) GetMaxNotificationsPerPublish() uint32 {
	return m.MaxNotificationsPerPublish
}

func (m *_ModifySubscriptionRequest) GetPriority() uint8 {
	return m.Priority
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewModifySubscriptionRequest factory function for _ModifySubscriptionRequest
func NewModifySubscriptionRequest(requestHeader ExtensionObjectDefinition, subscriptionId uint32, requestedPublishingInterval float64, requestedLifetimeCount uint32, requestedMaxKeepAliveCount uint32, maxNotificationsPerPublish uint32, priority uint8) *_ModifySubscriptionRequest {
	_result := &_ModifySubscriptionRequest{
		RequestHeader:               requestHeader,
		SubscriptionId:              subscriptionId,
		RequestedPublishingInterval: requestedPublishingInterval,
		RequestedLifetimeCount:      requestedLifetimeCount,
		RequestedMaxKeepAliveCount:  requestedMaxKeepAliveCount,
		MaxNotificationsPerPublish:  maxNotificationsPerPublish,
		Priority:                    priority,
		_ExtensionObjectDefinition:  NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastModifySubscriptionRequest(structType any) ModifySubscriptionRequest {
	if casted, ok := structType.(ModifySubscriptionRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ModifySubscriptionRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ModifySubscriptionRequest) GetTypeName() string {
	return "ModifySubscriptionRequest"
}

func (m *_ModifySubscriptionRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (requestedPublishingInterval)
	lengthInBits += 64

	// Simple field (requestedLifetimeCount)
	lengthInBits += 32

	// Simple field (requestedMaxKeepAliveCount)
	lengthInBits += 32

	// Simple field (maxNotificationsPerPublish)
	lengthInBits += 32

	// Simple field (priority)
	lengthInBits += 8

	return lengthInBits
}

func (m *_ModifySubscriptionRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ModifySubscriptionRequestParse(ctx context.Context, theBytes []byte, identifier string) (ModifySubscriptionRequest, error) {
	return ModifySubscriptionRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func ModifySubscriptionRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (ModifySubscriptionRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ModifySubscriptionRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModifySubscriptionRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of ModifySubscriptionRequest")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	// Simple Field (subscriptionId)
	_subscriptionId, _subscriptionIdErr := readBuffer.ReadUint32("subscriptionId", 32)
	if _subscriptionIdErr != nil {
		return nil, errors.Wrap(_subscriptionIdErr, "Error parsing 'subscriptionId' field of ModifySubscriptionRequest")
	}
	subscriptionId := _subscriptionId

	// Simple Field (requestedPublishingInterval)
	_requestedPublishingInterval, _requestedPublishingIntervalErr := readBuffer.ReadFloat64("requestedPublishingInterval", 64)
	if _requestedPublishingIntervalErr != nil {
		return nil, errors.Wrap(_requestedPublishingIntervalErr, "Error parsing 'requestedPublishingInterval' field of ModifySubscriptionRequest")
	}
	requestedPublishingInterval := _requestedPublishingInterval

	// Simple Field (requestedLifetimeCount)
	_requestedLifetimeCount, _requestedLifetimeCountErr := readBuffer.ReadUint32("requestedLifetimeCount", 32)
	if _requestedLifetimeCountErr != nil {
		return nil, errors.Wrap(_requestedLifetimeCountErr, "Error parsing 'requestedLifetimeCount' field of ModifySubscriptionRequest")
	}
	requestedLifetimeCount := _requestedLifetimeCount

	// Simple Field (requestedMaxKeepAliveCount)
	_requestedMaxKeepAliveCount, _requestedMaxKeepAliveCountErr := readBuffer.ReadUint32("requestedMaxKeepAliveCount", 32)
	if _requestedMaxKeepAliveCountErr != nil {
		return nil, errors.Wrap(_requestedMaxKeepAliveCountErr, "Error parsing 'requestedMaxKeepAliveCount' field of ModifySubscriptionRequest")
	}
	requestedMaxKeepAliveCount := _requestedMaxKeepAliveCount

	// Simple Field (maxNotificationsPerPublish)
	_maxNotificationsPerPublish, _maxNotificationsPerPublishErr := readBuffer.ReadUint32("maxNotificationsPerPublish", 32)
	if _maxNotificationsPerPublishErr != nil {
		return nil, errors.Wrap(_maxNotificationsPerPublishErr, "Error parsing 'maxNotificationsPerPublish' field of ModifySubscriptionRequest")
	}
	maxNotificationsPerPublish := _maxNotificationsPerPublish

	// Simple Field (priority)
	_priority, _priorityErr := readBuffer.ReadUint8("priority", 8)
	if _priorityErr != nil {
		return nil, errors.Wrap(_priorityErr, "Error parsing 'priority' field of ModifySubscriptionRequest")
	}
	priority := _priority

	if closeErr := readBuffer.CloseContext("ModifySubscriptionRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModifySubscriptionRequest")
	}

	// Create a partially initialized instance
	_child := &_ModifySubscriptionRequest{
		_ExtensionObjectDefinition:  &_ExtensionObjectDefinition{},
		RequestHeader:               requestHeader,
		SubscriptionId:              subscriptionId,
		RequestedPublishingInterval: requestedPublishingInterval,
		RequestedLifetimeCount:      requestedLifetimeCount,
		RequestedMaxKeepAliveCount:  requestedMaxKeepAliveCount,
		MaxNotificationsPerPublish:  maxNotificationsPerPublish,
		Priority:                    priority,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_ModifySubscriptionRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModifySubscriptionRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModifySubscriptionRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModifySubscriptionRequest")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Simple Field (subscriptionId)
		subscriptionId := uint32(m.GetSubscriptionId())
		_subscriptionIdErr := writeBuffer.WriteUint32("subscriptionId", 32, (subscriptionId))
		if _subscriptionIdErr != nil {
			return errors.Wrap(_subscriptionIdErr, "Error serializing 'subscriptionId' field")
		}

		// Simple Field (requestedPublishingInterval)
		requestedPublishingInterval := float64(m.GetRequestedPublishingInterval())
		_requestedPublishingIntervalErr := writeBuffer.WriteFloat64("requestedPublishingInterval", 64, (requestedPublishingInterval))
		if _requestedPublishingIntervalErr != nil {
			return errors.Wrap(_requestedPublishingIntervalErr, "Error serializing 'requestedPublishingInterval' field")
		}

		// Simple Field (requestedLifetimeCount)
		requestedLifetimeCount := uint32(m.GetRequestedLifetimeCount())
		_requestedLifetimeCountErr := writeBuffer.WriteUint32("requestedLifetimeCount", 32, (requestedLifetimeCount))
		if _requestedLifetimeCountErr != nil {
			return errors.Wrap(_requestedLifetimeCountErr, "Error serializing 'requestedLifetimeCount' field")
		}

		// Simple Field (requestedMaxKeepAliveCount)
		requestedMaxKeepAliveCount := uint32(m.GetRequestedMaxKeepAliveCount())
		_requestedMaxKeepAliveCountErr := writeBuffer.WriteUint32("requestedMaxKeepAliveCount", 32, (requestedMaxKeepAliveCount))
		if _requestedMaxKeepAliveCountErr != nil {
			return errors.Wrap(_requestedMaxKeepAliveCountErr, "Error serializing 'requestedMaxKeepAliveCount' field")
		}

		// Simple Field (maxNotificationsPerPublish)
		maxNotificationsPerPublish := uint32(m.GetMaxNotificationsPerPublish())
		_maxNotificationsPerPublishErr := writeBuffer.WriteUint32("maxNotificationsPerPublish", 32, (maxNotificationsPerPublish))
		if _maxNotificationsPerPublishErr != nil {
			return errors.Wrap(_maxNotificationsPerPublishErr, "Error serializing 'maxNotificationsPerPublish' field")
		}

		// Simple Field (priority)
		priority := uint8(m.GetPriority())
		_priorityErr := writeBuffer.WriteUint8("priority", 8, (priority))
		if _priorityErr != nil {
			return errors.Wrap(_priorityErr, "Error serializing 'priority' field")
		}

		if popErr := writeBuffer.PopContext("ModifySubscriptionRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModifySubscriptionRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModifySubscriptionRequest) isModifySubscriptionRequest() bool {
	return true
}

func (m *_ModifySubscriptionRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
