/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
	"io"
)

// Code generated by code-generation. DO NOT EDIT.

// LocalizedText is the corresponding interface of LocalizedText
type LocalizedText interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetTextSpecified returns TextSpecified (property field)
	GetTextSpecified() bool
	// GetLocaleSpecified returns LocaleSpecified (property field)
	GetLocaleSpecified() bool
	// GetLocale returns Locale (property field)
	GetLocale() PascalString
	// GetText returns Text (property field)
	GetText() PascalString
}

// LocalizedTextExactly can be used when we want exactly this type and not a type which fulfills LocalizedText.
// This is useful for switch cases.
type LocalizedTextExactly interface {
	LocalizedText
	isLocalizedText() bool
}

// _LocalizedText is the data-structure of this message
type _LocalizedText struct {
	TextSpecified   bool
	LocaleSpecified bool
	Locale          PascalString
	Text            PascalString
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LocalizedText) GetTextSpecified() bool {
	return m.TextSpecified
}

func (m *_LocalizedText) GetLocaleSpecified() bool {
	return m.LocaleSpecified
}

func (m *_LocalizedText) GetLocale() PascalString {
	return m.Locale
}

func (m *_LocalizedText) GetText() PascalString {
	return m.Text
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewLocalizedText factory function for _LocalizedText
func NewLocalizedText(textSpecified bool, localeSpecified bool, locale PascalString, text PascalString) *_LocalizedText {
	return &_LocalizedText{TextSpecified: textSpecified, LocaleSpecified: localeSpecified, Locale: locale, Text: text}
}

// Deprecated: use the interface for direct cast
func CastLocalizedText(structType any) LocalizedText {
	if casted, ok := structType.(LocalizedText); ok {
		return casted
	}
	if casted, ok := structType.(*LocalizedText); ok {
		return *casted
	}
	return nil
}

func (m *_LocalizedText) GetTypeName() string {
	return "LocalizedText"
}

func (m *_LocalizedText) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 6

	// Simple field (textSpecified)
	lengthInBits += 1

	// Simple field (localeSpecified)
	lengthInBits += 1

	// Optional Field (locale)
	if m.Locale != nil {
		lengthInBits += m.Locale.GetLengthInBits(ctx)
	}

	// Optional Field (text)
	if m.Text != nil {
		lengthInBits += m.Text.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_LocalizedText) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func LocalizedTextParse(ctx context.Context, theBytes []byte) (LocalizedText, error) {
	return LocalizedTextParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func LocalizedTextParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (LocalizedText, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("LocalizedText"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LocalizedText")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 6)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of LocalizedText")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (textSpecified)
	_textSpecified, _textSpecifiedErr := readBuffer.ReadBit("textSpecified")
	if _textSpecifiedErr != nil {
		return nil, errors.Wrap(_textSpecifiedErr, "Error parsing 'textSpecified' field of LocalizedText")
	}
	textSpecified := _textSpecified

	// Simple Field (localeSpecified)
	_localeSpecified, _localeSpecifiedErr := readBuffer.ReadBit("localeSpecified")
	if _localeSpecifiedErr != nil {
		return nil, errors.Wrap(_localeSpecifiedErr, "Error parsing 'localeSpecified' field of LocalizedText")
	}
	localeSpecified := _localeSpecified

	// Optional Field (locale) (Can be skipped, if a given expression evaluates to false)
	var locale PascalString = nil
	if localeSpecified {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("locale"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for locale")
		}
		_val, _err := PascalStringParseWithBuffer(ctx, readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			log.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'locale' field of LocalizedText")
		default:
			locale = _val.(PascalString)
			if closeErr := readBuffer.CloseContext("locale"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for locale")
			}
		}
	}

	// Optional Field (text) (Can be skipped, if a given expression evaluates to false)
	var text PascalString = nil
	if textSpecified {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("text"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for text")
		}
		_val, _err := PascalStringParseWithBuffer(ctx, readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			log.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'text' field of LocalizedText")
		default:
			text = _val.(PascalString)
			if closeErr := readBuffer.CloseContext("text"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for text")
			}
		}
	}

	if closeErr := readBuffer.CloseContext("LocalizedText"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LocalizedText")
	}

	// Create the instance
	return &_LocalizedText{
		TextSpecified:   textSpecified,
		LocaleSpecified: localeSpecified,
		Locale:          locale,
		Text:            text,
		reservedField0:  reservedField0,
	}, nil
}

func (m *_LocalizedText) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LocalizedText) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("LocalizedText"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for LocalizedText")
	}

	// Reserved Field (reserved)
	{
		var reserved uint8 = uint8(0x00)
		if m.reservedField0 != nil {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Overriding reserved field with unexpected value.")
			reserved = *m.reservedField0
		}
		_err := writeBuffer.WriteUint8("reserved", 6, reserved)
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	// Simple Field (textSpecified)
	textSpecified := bool(m.GetTextSpecified())
	_textSpecifiedErr := writeBuffer.WriteBit("textSpecified", (textSpecified))
	if _textSpecifiedErr != nil {
		return errors.Wrap(_textSpecifiedErr, "Error serializing 'textSpecified' field")
	}

	// Simple Field (localeSpecified)
	localeSpecified := bool(m.GetLocaleSpecified())
	_localeSpecifiedErr := writeBuffer.WriteBit("localeSpecified", (localeSpecified))
	if _localeSpecifiedErr != nil {
		return errors.Wrap(_localeSpecifiedErr, "Error serializing 'localeSpecified' field")
	}

	// Optional Field (locale) (Can be skipped, if the value is null)
	var locale PascalString = nil
	if m.GetLocale() != nil {
		if pushErr := writeBuffer.PushContext("locale"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for locale")
		}
		locale = m.GetLocale()
		_localeErr := writeBuffer.WriteSerializable(ctx, locale)
		if popErr := writeBuffer.PopContext("locale"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for locale")
		}
		if _localeErr != nil {
			return errors.Wrap(_localeErr, "Error serializing 'locale' field")
		}
	}

	// Optional Field (text) (Can be skipped, if the value is null)
	var text PascalString = nil
	if m.GetText() != nil {
		if pushErr := writeBuffer.PushContext("text"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for text")
		}
		text = m.GetText()
		_textErr := writeBuffer.WriteSerializable(ctx, text)
		if popErr := writeBuffer.PopContext("text"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for text")
		}
		if _textErr != nil {
			return errors.Wrap(_textErr, "Error serializing 'text' field")
		}
	}

	if popErr := writeBuffer.PopContext("LocalizedText"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for LocalizedText")
	}
	return nil
}

func (m *_LocalizedText) isLocalizedText() bool {
	return true
}

func (m *_LocalizedText) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
