/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Index is the corresponding interface of Index
type Index interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// IndexExactly can be used when we want exactly this type and not a type which fulfills Index.
// This is useful for switch cases.
type IndexExactly interface {
	Index
	isIndex() bool
}

// _Index is the data-structure of this message
type _Index struct {
}

// NewIndex factory function for _Index
func NewIndex() *_Index {
	return &_Index{}
}

// Deprecated: use the interface for direct cast
func CastIndex(structType any) Index {
	if casted, ok := structType.(Index); ok {
		return casted
	}
	if casted, ok := structType.(*Index); ok {
		return *casted
	}
	return nil
}

func (m *_Index) GetTypeName() string {
	return "Index"
}

func (m *_Index) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Index) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func IndexParse(ctx context.Context, theBytes []byte) (Index, error) {
	return IndexParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func IndexParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Index, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Index"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Index")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("Index"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Index")
	}

	// Create the instance
	return &_Index{}, nil
}

func (m *_Index) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Index) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Index"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Index")
	}

	if popErr := writeBuffer.PopContext("Index"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Index")
	}
	return nil
}

func (m *_Index) isIndex() bool {
	return true
}

func (m *_Index) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
