/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ImagePNG is the corresponding interface of ImagePNG
type ImagePNG interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// ImagePNGExactly can be used when we want exactly this type and not a type which fulfills ImagePNG.
// This is useful for switch cases.
type ImagePNGExactly interface {
	ImagePNG
	isImagePNG() bool
}

// _ImagePNG is the data-structure of this message
type _ImagePNG struct {
}

// NewImagePNG factory function for _ImagePNG
func NewImagePNG() *_ImagePNG {
	return &_ImagePNG{}
}

// Deprecated: use the interface for direct cast
func CastImagePNG(structType any) ImagePNG {
	if casted, ok := structType.(ImagePNG); ok {
		return casted
	}
	if casted, ok := structType.(*ImagePNG); ok {
		return *casted
	}
	return nil
}

func (m *_ImagePNG) GetTypeName() string {
	return "ImagePNG"
}

func (m *_ImagePNG) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ImagePNG) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ImagePNGParse(ctx context.Context, theBytes []byte) (ImagePNG, error) {
	return ImagePNGParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ImagePNGParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ImagePNG, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ImagePNG"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ImagePNG")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ImagePNG"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ImagePNG")
	}

	// Create the instance
	return &_ImagePNG{}, nil
}

func (m *_ImagePNG) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ImagePNG) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ImagePNG"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ImagePNG")
	}

	if popErr := writeBuffer.PopContext("ImagePNG"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ImagePNG")
	}
	return nil
}

func (m *_ImagePNG) isImagePNG() bool {
	return true
}

func (m *_ImagePNG) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
