/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentityMappingRuleType is the corresponding interface of IdentityMappingRuleType
type IdentityMappingRuleType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetCriteriaType returns CriteriaType (property field)
	GetCriteriaType() IdentityCriteriaType
	// GetCriteria returns Criteria (property field)
	GetCriteria() PascalString
}

// IdentityMappingRuleTypeExactly can be used when we want exactly this type and not a type which fulfills IdentityMappingRuleType.
// This is useful for switch cases.
type IdentityMappingRuleTypeExactly interface {
	IdentityMappingRuleType
	isIdentityMappingRuleType() bool
}

// _IdentityMappingRuleType is the data-structure of this message
type _IdentityMappingRuleType struct {
	*_ExtensionObjectDefinition
	CriteriaType IdentityCriteriaType
	Criteria     PascalString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentityMappingRuleType) GetIdentifier() string {
	return "15636"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentityMappingRuleType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_IdentityMappingRuleType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentityMappingRuleType) GetCriteriaType() IdentityCriteriaType {
	return m.CriteriaType
}

func (m *_IdentityMappingRuleType) GetCriteria() PascalString {
	return m.Criteria
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewIdentityMappingRuleType factory function for _IdentityMappingRuleType
func NewIdentityMappingRuleType(criteriaType IdentityCriteriaType, criteria PascalString) *_IdentityMappingRuleType {
	_result := &_IdentityMappingRuleType{
		CriteriaType:               criteriaType,
		Criteria:                   criteria,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastIdentityMappingRuleType(structType any) IdentityMappingRuleType {
	if casted, ok := structType.(IdentityMappingRuleType); ok {
		return casted
	}
	if casted, ok := structType.(*IdentityMappingRuleType); ok {
		return *casted
	}
	return nil
}

func (m *_IdentityMappingRuleType) GetTypeName() string {
	return "IdentityMappingRuleType"
}

func (m *_IdentityMappingRuleType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (criteriaType)
	lengthInBits += 32

	// Simple field (criteria)
	lengthInBits += m.Criteria.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_IdentityMappingRuleType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func IdentityMappingRuleTypeParse(ctx context.Context, theBytes []byte, identifier string) (IdentityMappingRuleType, error) {
	return IdentityMappingRuleTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func IdentityMappingRuleTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (IdentityMappingRuleType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("IdentityMappingRuleType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentityMappingRuleType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (criteriaType)
	if pullErr := readBuffer.PullContext("criteriaType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for criteriaType")
	}
	_criteriaType, _criteriaTypeErr := IdentityCriteriaTypeParseWithBuffer(ctx, readBuffer)
	if _criteriaTypeErr != nil {
		return nil, errors.Wrap(_criteriaTypeErr, "Error parsing 'criteriaType' field of IdentityMappingRuleType")
	}
	criteriaType := _criteriaType
	if closeErr := readBuffer.CloseContext("criteriaType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for criteriaType")
	}

	// Simple Field (criteria)
	if pullErr := readBuffer.PullContext("criteria"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for criteria")
	}
	_criteria, _criteriaErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _criteriaErr != nil {
		return nil, errors.Wrap(_criteriaErr, "Error parsing 'criteria' field of IdentityMappingRuleType")
	}
	criteria := _criteria.(PascalString)
	if closeErr := readBuffer.CloseContext("criteria"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for criteria")
	}

	if closeErr := readBuffer.CloseContext("IdentityMappingRuleType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentityMappingRuleType")
	}

	// Create a partially initialized instance
	_child := &_IdentityMappingRuleType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		CriteriaType:               criteriaType,
		Criteria:                   criteria,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_IdentityMappingRuleType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentityMappingRuleType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentityMappingRuleType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentityMappingRuleType")
		}

		// Simple Field (criteriaType)
		if pushErr := writeBuffer.PushContext("criteriaType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for criteriaType")
		}
		_criteriaTypeErr := writeBuffer.WriteSerializable(ctx, m.GetCriteriaType())
		if popErr := writeBuffer.PopContext("criteriaType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for criteriaType")
		}
		if _criteriaTypeErr != nil {
			return errors.Wrap(_criteriaTypeErr, "Error serializing 'criteriaType' field")
		}

		// Simple Field (criteria)
		if pushErr := writeBuffer.PushContext("criteria"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for criteria")
		}
		_criteriaErr := writeBuffer.WriteSerializable(ctx, m.GetCriteria())
		if popErr := writeBuffer.PopContext("criteria"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for criteria")
		}
		if _criteriaErr != nil {
			return errors.Wrap(_criteriaErr, "Error serializing 'criteria' field")
		}

		if popErr := writeBuffer.PopContext("IdentityMappingRuleType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentityMappingRuleType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentityMappingRuleType) isIdentityMappingRuleType() bool {
	return true
}

func (m *_IdentityMappingRuleType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
