/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// EccEncryptedSecret is the corresponding interface of EccEncryptedSecret
type EccEncryptedSecret interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// EccEncryptedSecretExactly can be used when we want exactly this type and not a type which fulfills EccEncryptedSecret.
// This is useful for switch cases.
type EccEncryptedSecretExactly interface {
	EccEncryptedSecret
	isEccEncryptedSecret() bool
}

// _EccEncryptedSecret is the data-structure of this message
type _EccEncryptedSecret struct {
}

// NewEccEncryptedSecret factory function for _EccEncryptedSecret
func NewEccEncryptedSecret() *_EccEncryptedSecret {
	return &_EccEncryptedSecret{}
}

// Deprecated: use the interface for direct cast
func CastEccEncryptedSecret(structType any) EccEncryptedSecret {
	if casted, ok := structType.(EccEncryptedSecret); ok {
		return casted
	}
	if casted, ok := structType.(*EccEncryptedSecret); ok {
		return *casted
	}
	return nil
}

func (m *_EccEncryptedSecret) GetTypeName() string {
	return "EccEncryptedSecret"
}

func (m *_EccEncryptedSecret) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_EccEncryptedSecret) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func EccEncryptedSecretParse(ctx context.Context, theBytes []byte) (EccEncryptedSecret, error) {
	return EccEncryptedSecretParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func EccEncryptedSecretParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (EccEncryptedSecret, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("EccEncryptedSecret"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EccEncryptedSecret")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("EccEncryptedSecret"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EccEncryptedSecret")
	}

	// Create the instance
	return &_EccEncryptedSecret{}, nil
}

func (m *_EccEncryptedSecret) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EccEncryptedSecret) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("EccEncryptedSecret"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for EccEncryptedSecret")
	}

	if popErr := writeBuffer.PopContext("EccEncryptedSecret"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for EccEncryptedSecret")
	}
	return nil
}

func (m *_EccEncryptedSecret) isEccEncryptedSecret() bool {
	return true
}

func (m *_EccEncryptedSecret) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
