/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// DoubleComplexNumberType is the corresponding interface of DoubleComplexNumberType
type DoubleComplexNumberType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetReal returns Real (property field)
	GetReal() float64
	// GetImaginary returns Imaginary (property field)
	GetImaginary() float64
}

// DoubleComplexNumberTypeExactly can be used when we want exactly this type and not a type which fulfills DoubleComplexNumberType.
// This is useful for switch cases.
type DoubleComplexNumberTypeExactly interface {
	DoubleComplexNumberType
	isDoubleComplexNumberType() bool
}

// _DoubleComplexNumberType is the data-structure of this message
type _DoubleComplexNumberType struct {
	*_ExtensionObjectDefinition
	Real      float64
	Imaginary float64
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DoubleComplexNumberType) GetIdentifier() string {
	return "12174"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DoubleComplexNumberType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_DoubleComplexNumberType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DoubleComplexNumberType) GetReal() float64 {
	return m.Real
}

func (m *_DoubleComplexNumberType) GetImaginary() float64 {
	return m.Imaginary
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewDoubleComplexNumberType factory function for _DoubleComplexNumberType
func NewDoubleComplexNumberType(real float64, imaginary float64) *_DoubleComplexNumberType {
	_result := &_DoubleComplexNumberType{
		Real:                       real,
		Imaginary:                  imaginary,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastDoubleComplexNumberType(structType any) DoubleComplexNumberType {
	if casted, ok := structType.(DoubleComplexNumberType); ok {
		return casted
	}
	if casted, ok := structType.(*DoubleComplexNumberType); ok {
		return *casted
	}
	return nil
}

func (m *_DoubleComplexNumberType) GetTypeName() string {
	return "DoubleComplexNumberType"
}

func (m *_DoubleComplexNumberType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (real)
	lengthInBits += 64

	// Simple field (imaginary)
	lengthInBits += 64

	return lengthInBits
}

func (m *_DoubleComplexNumberType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DoubleComplexNumberTypeParse(ctx context.Context, theBytes []byte, identifier string) (DoubleComplexNumberType, error) {
	return DoubleComplexNumberTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func DoubleComplexNumberTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (DoubleComplexNumberType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("DoubleComplexNumberType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DoubleComplexNumberType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (real)
	_real, _realErr := readBuffer.ReadFloat64("real", 64)
	if _realErr != nil {
		return nil, errors.Wrap(_realErr, "Error parsing 'real' field of DoubleComplexNumberType")
	}
	real := _real

	// Simple Field (imaginary)
	_imaginary, _imaginaryErr := readBuffer.ReadFloat64("imaginary", 64)
	if _imaginaryErr != nil {
		return nil, errors.Wrap(_imaginaryErr, "Error parsing 'imaginary' field of DoubleComplexNumberType")
	}
	imaginary := _imaginary

	if closeErr := readBuffer.CloseContext("DoubleComplexNumberType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DoubleComplexNumberType")
	}

	// Create a partially initialized instance
	_child := &_DoubleComplexNumberType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Real:                       real,
		Imaginary:                  imaginary,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_DoubleComplexNumberType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DoubleComplexNumberType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DoubleComplexNumberType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DoubleComplexNumberType")
		}

		// Simple Field (real)
		real := float64(m.GetReal())
		_realErr := writeBuffer.WriteFloat64("real", 64, (real))
		if _realErr != nil {
			return errors.Wrap(_realErr, "Error serializing 'real' field")
		}

		// Simple Field (imaginary)
		imaginary := float64(m.GetImaginary())
		_imaginaryErr := writeBuffer.WriteFloat64("imaginary", 64, (imaginary))
		if _imaginaryErr != nil {
			return errors.Wrap(_imaginaryErr, "Error serializing 'imaginary' field")
		}

		if popErr := writeBuffer.PopContext("DoubleComplexNumberType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DoubleComplexNumberType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DoubleComplexNumberType) isDoubleComplexNumberType() bool {
	return true
}

func (m *_DoubleComplexNumberType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
