/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ConnectionRequestInformation is the corresponding interface of ConnectionRequestInformation
type ConnectionRequestInformation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetConnectionType returns ConnectionType (discriminator field)
	GetConnectionType() uint8
}

// ConnectionRequestInformationExactly can be used when we want exactly this type and not a type which fulfills ConnectionRequestInformation.
// This is useful for switch cases.
type ConnectionRequestInformationExactly interface {
	ConnectionRequestInformation
	isConnectionRequestInformation() bool
}

// _ConnectionRequestInformation is the data-structure of this message
type _ConnectionRequestInformation struct {
	_ConnectionRequestInformationChildRequirements
}

type _ConnectionRequestInformationChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetConnectionType() uint8
}

type ConnectionRequestInformationParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ConnectionRequestInformation, serializeChildFunction func() error) error
	GetTypeName() string
}

type ConnectionRequestInformationChild interface {
	utils.Serializable
	InitializeParent(parent ConnectionRequestInformation)
	GetParent() *ConnectionRequestInformation

	GetTypeName() string
	ConnectionRequestInformation
}

// NewConnectionRequestInformation factory function for _ConnectionRequestInformation
func NewConnectionRequestInformation() *_ConnectionRequestInformation {
	return &_ConnectionRequestInformation{}
}

// Deprecated: use the interface for direct cast
func CastConnectionRequestInformation(structType any) ConnectionRequestInformation {
	if casted, ok := structType.(ConnectionRequestInformation); ok {
		return casted
	}
	if casted, ok := structType.(*ConnectionRequestInformation); ok {
		return *casted
	}
	return nil
}

func (m *_ConnectionRequestInformation) GetTypeName() string {
	return "ConnectionRequestInformation"
}

func (m *_ConnectionRequestInformation) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Implicit Field (structureLength)
	lengthInBits += 8
	// Discriminator Field (connectionType)
	lengthInBits += 8

	return lengthInBits
}

func (m *_ConnectionRequestInformation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ConnectionRequestInformationParse(ctx context.Context, theBytes []byte) (ConnectionRequestInformation, error) {
	return ConnectionRequestInformationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ConnectionRequestInformationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ConnectionRequestInformation, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ConnectionRequestInformation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConnectionRequestInformation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (structureLength) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	structureLength, _structureLengthErr := readBuffer.ReadUint8("structureLength", 8)
	_ = structureLength
	if _structureLengthErr != nil {
		return nil, errors.Wrap(_structureLengthErr, "Error parsing 'structureLength' field of ConnectionRequestInformation")
	}

	// Discriminator Field (connectionType) (Used as input to a switch field)
	connectionType, _connectionTypeErr := readBuffer.ReadUint8("connectionType", 8)
	if _connectionTypeErr != nil {
		return nil, errors.Wrap(_connectionTypeErr, "Error parsing 'connectionType' field of ConnectionRequestInformation")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type ConnectionRequestInformationChildSerializeRequirement interface {
		ConnectionRequestInformation
		InitializeParent(ConnectionRequestInformation)
		GetParent() ConnectionRequestInformation
	}
	var _childTemp any
	var _child ConnectionRequestInformationChildSerializeRequirement
	var typeSwitchError error
	switch {
	case connectionType == 0x03: // ConnectionRequestInformationDeviceManagement
		_childTemp, typeSwitchError = ConnectionRequestInformationDeviceManagementParseWithBuffer(ctx, readBuffer)
	case connectionType == 0x04: // ConnectionRequestInformationTunnelConnection
		_childTemp, typeSwitchError = ConnectionRequestInformationTunnelConnectionParseWithBuffer(ctx, readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [connectionType=%v]", connectionType)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of ConnectionRequestInformation")
	}
	_child = _childTemp.(ConnectionRequestInformationChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("ConnectionRequestInformation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConnectionRequestInformation")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_ConnectionRequestInformation) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ConnectionRequestInformation, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ConnectionRequestInformation"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ConnectionRequestInformation")
	}

	// Implicit Field (structureLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
	structureLength := uint8(uint8(m.GetLengthInBytes(ctx)))
	_structureLengthErr := writeBuffer.WriteUint8("structureLength", 8, (structureLength))
	if _structureLengthErr != nil {
		return errors.Wrap(_structureLengthErr, "Error serializing 'structureLength' field")
	}

	// Discriminator Field (connectionType) (Used as input to a switch field)
	connectionType := uint8(child.GetConnectionType())
	_connectionTypeErr := writeBuffer.WriteUint8("connectionType", 8, (connectionType))

	if _connectionTypeErr != nil {
		return errors.Wrap(_connectionTypeErr, "Error serializing 'connectionType' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("ConnectionRequestInformation"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ConnectionRequestInformation")
	}
	return nil
}

func (m *_ConnectionRequestInformation) isConnectionRequestInformation() bool {
	return true
}

func (m *_ConnectionRequestInformation) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
