/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Apdu is the corresponding interface of Apdu
type Apdu interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetControl returns Control (discriminator field)
	GetControl() uint8
	// GetNumbered returns Numbered (property field)
	GetNumbered() bool
	// GetCounter returns Counter (property field)
	GetCounter() uint8
}

// ApduExactly can be used when we want exactly this type and not a type which fulfills Apdu.
// This is useful for switch cases.
type ApduExactly interface {
	Apdu
	isApdu() bool
}

// _Apdu is the data-structure of this message
type _Apdu struct {
	_ApduChildRequirements
	Numbered bool
	Counter  uint8

	// Arguments.
	DataLength uint8
}

type _ApduChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetControl() uint8
}

type ApduParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child Apdu, serializeChildFunction func() error) error
	GetTypeName() string
}

type ApduChild interface {
	utils.Serializable
	InitializeParent(parent Apdu, numbered bool, counter uint8)
	GetParent() *Apdu

	GetTypeName() string
	Apdu
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Apdu) GetNumbered() bool {
	return m.Numbered
}

func (m *_Apdu) GetCounter() uint8 {
	return m.Counter
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewApdu factory function for _Apdu
func NewApdu(numbered bool, counter uint8, dataLength uint8) *_Apdu {
	return &_Apdu{Numbered: numbered, Counter: counter, DataLength: dataLength}
}

// Deprecated: use the interface for direct cast
func CastApdu(structType any) Apdu {
	if casted, ok := structType.(Apdu); ok {
		return casted
	}
	if casted, ok := structType.(*Apdu); ok {
		return *casted
	}
	return nil
}

func (m *_Apdu) GetTypeName() string {
	return "Apdu"
}

func (m *_Apdu) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (control)
	lengthInBits += 1

	// Simple field (numbered)
	lengthInBits += 1

	// Simple field (counter)
	lengthInBits += 4

	return lengthInBits
}

func (m *_Apdu) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ApduParse(ctx context.Context, theBytes []byte, dataLength uint8) (Apdu, error) {
	return ApduParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), dataLength)
}

func ApduParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, dataLength uint8) (Apdu, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Apdu"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Apdu")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Discriminator Field (control) (Used as input to a switch field)
	control, _controlErr := readBuffer.ReadUint8("control", 1)
	if _controlErr != nil {
		return nil, errors.Wrap(_controlErr, "Error parsing 'control' field of Apdu")
	}

	// Simple Field (numbered)
	_numbered, _numberedErr := readBuffer.ReadBit("numbered")
	if _numberedErr != nil {
		return nil, errors.Wrap(_numberedErr, "Error parsing 'numbered' field of Apdu")
	}
	numbered := _numbered

	// Simple Field (counter)
	_counter, _counterErr := readBuffer.ReadUint8("counter", 4)
	if _counterErr != nil {
		return nil, errors.Wrap(_counterErr, "Error parsing 'counter' field of Apdu")
	}
	counter := _counter

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type ApduChildSerializeRequirement interface {
		Apdu
		InitializeParent(Apdu, bool, uint8)
		GetParent() Apdu
	}
	var _childTemp any
	var _child ApduChildSerializeRequirement
	var typeSwitchError error
	switch {
	case control == uint8(1): // ApduControlContainer
		_childTemp, typeSwitchError = ApduControlContainerParseWithBuffer(ctx, readBuffer, dataLength)
	case control == uint8(0): // ApduDataContainer
		_childTemp, typeSwitchError = ApduDataContainerParseWithBuffer(ctx, readBuffer, dataLength)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [control=%v]", control)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of Apdu")
	}
	_child = _childTemp.(ApduChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("Apdu"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Apdu")
	}

	// Finish initializing
	_child.InitializeParent(_child, numbered, counter)
	return _child, nil
}

func (pm *_Apdu) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child Apdu, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Apdu"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Apdu")
	}

	// Discriminator Field (control) (Used as input to a switch field)
	control := uint8(child.GetControl())
	_controlErr := writeBuffer.WriteUint8("control", 1, (control))

	if _controlErr != nil {
		return errors.Wrap(_controlErr, "Error serializing 'control' field")
	}

	// Simple Field (numbered)
	numbered := bool(m.GetNumbered())
	_numberedErr := writeBuffer.WriteBit("numbered", (numbered))
	if _numberedErr != nil {
		return errors.Wrap(_numberedErr, "Error serializing 'numbered' field")
	}

	// Simple Field (counter)
	counter := uint8(m.GetCounter())
	_counterErr := writeBuffer.WriteUint8("counter", 4, (counter))
	if _counterErr != nil {
		return errors.Wrap(_counterErr, "Error serializing 'counter' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("Apdu"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Apdu")
	}
	return nil
}

////
// Arguments Getter

func (m *_Apdu) GetDataLength() uint8 {
	return m.DataLength
}

//
////

func (m *_Apdu) isApdu() bool {
	return true
}

func (m *_Apdu) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
