/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/apache/plc4x/plc4go/protocols/knxnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type KnxnetipParserHelper struct {
}

func (m KnxnetipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "KnxProperty":
		propertyType, _ := model.KnxPropertyDataTypeByName(arguments[0])
		dataLengthInBytes, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.KnxPropertyParseWithBuffer(context.Background(), io, propertyType, dataLengthInBytes)
	case "HPAIControlEndpoint":
		return model.HPAIControlEndpointParseWithBuffer(context.Background(), io)
	case "TunnelingResponseDataBlock":
		return model.TunnelingResponseDataBlockParseWithBuffer(context.Background(), io)
	case "DeviceDescriptorType2":
		return model.DeviceDescriptorType2ParseWithBuffer(context.Background(), io)
	case "ChannelInformation":
		return model.ChannelInformationParseWithBuffer(context.Background(), io)
	case "KnxDatapoint":
		datapointType, _ := model.KnxDatapointTypeByName(arguments[0])
		return model.KnxDatapointParseWithBuffer(context.Background(), io, datapointType)
	case "DeviceConfigurationAckDataBlock":
		return model.DeviceConfigurationAckDataBlockParseWithBuffer(context.Background(), io)
	case "ConnectionRequestInformation":
		return model.ConnectionRequestInformationParseWithBuffer(context.Background(), io)
	case "Apdu":
		dataLength, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduParseWithBuffer(context.Background(), io, dataLength)
	case "HPAIDiscoveryEndpoint":
		return model.HPAIDiscoveryEndpointParseWithBuffer(context.Background(), io)
	case "ProjectInstallationIdentifier":
		return model.ProjectInstallationIdentifierParseWithBuffer(context.Background(), io)
	case "ServiceId":
		return model.ServiceIdParseWithBuffer(context.Background(), io)
	case "HPAIDataEndpoint":
		return model.HPAIDataEndpointParseWithBuffer(context.Background(), io)
	case "RelativeTimestamp":
		return model.RelativeTimestampParseWithBuffer(context.Background(), io)
	case "CEMI":
		size, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.CEMIParseWithBuffer(context.Background(), io, size)
	case "KnxNetIpMessage":
		return model.KnxNetIpMessageParseWithBuffer(context.Background(), io)
	case "DeviceStatus":
		return model.DeviceStatusParseWithBuffer(context.Background(), io)
	case "IPAddress":
		return model.IPAddressParseWithBuffer(context.Background(), io)
	case "GroupObjectDescriptorRealisationTypeB":
		return model.GroupObjectDescriptorRealisationTypeBParseWithBuffer(context.Background(), io)
	case "CEMIAdditionalInformation":
		return model.CEMIAdditionalInformationParseWithBuffer(context.Background(), io)
	case "ComObjectTable":
		firmwareType, _ := model.FirmwareTypeByName(arguments[0])
		return model.ComObjectTableParseWithBuffer(context.Background(), io, firmwareType)
	case "KnxAddress":
		return model.KnxAddressParseWithBuffer(context.Background(), io)
	case "ConnectionResponseDataBlock":
		return model.ConnectionResponseDataBlockParseWithBuffer(context.Background(), io)
	case "TunnelingRequestDataBlock":
		return model.TunnelingRequestDataBlockParseWithBuffer(context.Background(), io)
	case "DIBDeviceInfo":
		return model.DIBDeviceInfoParseWithBuffer(context.Background(), io)
	case "DeviceConfigurationRequestDataBlock":
		return model.DeviceConfigurationRequestDataBlockParseWithBuffer(context.Background(), io)
	case "DIBSuppSvcFamilies":
		return model.DIBSuppSvcFamiliesParseWithBuffer(context.Background(), io)
	case "LDataFrame":
		return model.LDataFrameParseWithBuffer(context.Background(), io)
	case "ApduDataExt":
		length, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduDataExtParseWithBuffer(context.Background(), io, length)
	case "ApduControl":
		return model.ApduControlParseWithBuffer(context.Background(), io)
	case "KnxGroupAddress":
		numLevels, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.KnxGroupAddressParseWithBuffer(context.Background(), io, numLevels)
	case "GroupObjectDescriptorRealisationType6":
		return model.GroupObjectDescriptorRealisationType6ParseWithBuffer(context.Background(), io)
	case "GroupObjectDescriptorRealisationType7":
		return model.GroupObjectDescriptorRealisationType7ParseWithBuffer(context.Background(), io)
	case "MACAddress":
		return model.MACAddressParseWithBuffer(context.Background(), io)
	case "GroupObjectDescriptorRealisationType2":
		return model.GroupObjectDescriptorRealisationType2ParseWithBuffer(context.Background(), io)
	case "ApduData":
		dataLength, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduDataParseWithBuffer(context.Background(), io, dataLength)
	case "GroupObjectDescriptorRealisationType1":
		return model.GroupObjectDescriptorRealisationType1ParseWithBuffer(context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
