/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// SetAttributeListRequest is the corresponding interface of SetAttributeListRequest
type SetAttributeListRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	CipService
}

// SetAttributeListRequestExactly can be used when we want exactly this type and not a type which fulfills SetAttributeListRequest.
// This is useful for switch cases.
type SetAttributeListRequestExactly interface {
	SetAttributeListRequest
	isSetAttributeListRequest() bool
}

// _SetAttributeListRequest is the data-structure of this message
type _SetAttributeListRequest struct {
	*_CipService
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SetAttributeListRequest) GetService() uint8 {
	return 0x04
}

func (m *_SetAttributeListRequest) GetResponse() bool {
	return bool(false)
}

func (m *_SetAttributeListRequest) GetConnected() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SetAttributeListRequest) InitializeParent(parent CipService) {}

func (m *_SetAttributeListRequest) GetParent() CipService {
	return m._CipService
}

// NewSetAttributeListRequest factory function for _SetAttributeListRequest
func NewSetAttributeListRequest(serviceLen uint16) *_SetAttributeListRequest {
	_result := &_SetAttributeListRequest{
		_CipService: NewCipService(serviceLen),
	}
	_result._CipService._CipServiceChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSetAttributeListRequest(structType any) SetAttributeListRequest {
	if casted, ok := structType.(SetAttributeListRequest); ok {
		return casted
	}
	if casted, ok := structType.(*SetAttributeListRequest); ok {
		return *casted
	}
	return nil
}

func (m *_SetAttributeListRequest) GetTypeName() string {
	return "SetAttributeListRequest"
}

func (m *_SetAttributeListRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	return lengthInBits
}

func (m *_SetAttributeListRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SetAttributeListRequestParse(ctx context.Context, theBytes []byte, connected bool, serviceLen uint16) (SetAttributeListRequest, error) {
	return SetAttributeListRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), connected, serviceLen)
}

func SetAttributeListRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, connected bool, serviceLen uint16) (SetAttributeListRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("SetAttributeListRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SetAttributeListRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SetAttributeListRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SetAttributeListRequest")
	}

	// Create a partially initialized instance
	_child := &_SetAttributeListRequest{
		_CipService: &_CipService{
			ServiceLen: serviceLen,
		},
	}
	_child._CipService._CipServiceChildRequirements = _child
	return _child, nil
}

func (m *_SetAttributeListRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SetAttributeListRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SetAttributeListRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SetAttributeListRequest")
		}

		if popErr := writeBuffer.PopContext("SetAttributeListRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SetAttributeListRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SetAttributeListRequest) isSetAttributeListRequest() bool {
	return true
}

func (m *_SetAttributeListRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
