/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ListServicesRequest is the corresponding interface of ListServicesRequest
type ListServicesRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	EipPacket
}

// ListServicesRequestExactly can be used when we want exactly this type and not a type which fulfills ListServicesRequest.
// This is useful for switch cases.
type ListServicesRequestExactly interface {
	ListServicesRequest
	isListServicesRequest() bool
}

// _ListServicesRequest is the data-structure of this message
type _ListServicesRequest struct {
	*_EipPacket
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ListServicesRequest) GetCommand() uint16 {
	return 0x0004
}

func (m *_ListServicesRequest) GetResponse() bool {
	return bool(false)
}

func (m *_ListServicesRequest) GetPacketLength() uint16 {
	return 0
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ListServicesRequest) InitializeParent(parent EipPacket, sessionHandle uint32, status uint32, senderContext []byte, options uint32) {
	m.SessionHandle = sessionHandle
	m.Status = status
	m.SenderContext = senderContext
	m.Options = options
}

func (m *_ListServicesRequest) GetParent() EipPacket {
	return m._EipPacket
}

// NewListServicesRequest factory function for _ListServicesRequest
func NewListServicesRequest(sessionHandle uint32, status uint32, senderContext []byte, options uint32) *_ListServicesRequest {
	_result := &_ListServicesRequest{
		_EipPacket: NewEipPacket(sessionHandle, status, senderContext, options),
	}
	_result._EipPacket._EipPacketChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastListServicesRequest(structType any) ListServicesRequest {
	if casted, ok := structType.(ListServicesRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ListServicesRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ListServicesRequest) GetTypeName() string {
	return "ListServicesRequest"
}

func (m *_ListServicesRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	return lengthInBits
}

func (m *_ListServicesRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ListServicesRequestParse(ctx context.Context, theBytes []byte, response bool) (ListServicesRequest, error) {
	return ListServicesRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), response)
}

func ListServicesRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, response bool) (ListServicesRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ListServicesRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ListServicesRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ListServicesRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ListServicesRequest")
	}

	// Create a partially initialized instance
	_child := &_ListServicesRequest{
		_EipPacket: &_EipPacket{},
	}
	_child._EipPacket._EipPacketChildRequirements = _child
	return _child, nil
}

func (m *_ListServicesRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ListServicesRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ListServicesRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ListServicesRequest")
		}

		if popErr := writeBuffer.PopContext("ListServicesRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ListServicesRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ListServicesRequest) isListServicesRequest() bool {
	return true
}

func (m *_ListServicesRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
