/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// GAVState is an enum
type GAVState uint8

type IGAVState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	GAVState_DOES_NOT_EXIST GAVState = 0
	GAVState_ON             GAVState = 1
	GAVState_OFF            GAVState = 2
	GAVState_ERROR          GAVState = 3
)

var GAVStateValues []GAVState

func init() {
	_ = errors.New
	GAVStateValues = []GAVState{
		GAVState_DOES_NOT_EXIST,
		GAVState_ON,
		GAVState_OFF,
		GAVState_ERROR,
	}
}

func GAVStateByValue(value uint8) (enum GAVState, ok bool) {
	switch value {
	case 0:
		return GAVState_DOES_NOT_EXIST, true
	case 1:
		return GAVState_ON, true
	case 2:
		return GAVState_OFF, true
	case 3:
		return GAVState_ERROR, true
	}
	return 0, false
}

func GAVStateByName(value string) (enum GAVState, ok bool) {
	switch value {
	case "DOES_NOT_EXIST":
		return GAVState_DOES_NOT_EXIST, true
	case "ON":
		return GAVState_ON, true
	case "OFF":
		return GAVState_OFF, true
	case "ERROR":
		return GAVState_ERROR, true
	}
	return 0, false
}

func GAVStateKnows(value uint8) bool {
	for _, typeValue := range GAVStateValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastGAVState(structType any) GAVState {
	castFunc := func(typ any) GAVState {
		if sGAVState, ok := typ.(GAVState); ok {
			return sGAVState
		}
		return 0
	}
	return castFunc(structType)
}

func (m GAVState) GetLengthInBits(ctx context.Context) uint16 {
	return 2
}

func (m GAVState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func GAVStateParse(ctx context.Context, theBytes []byte) (GAVState, error) {
	return GAVStateParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func GAVStateParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (GAVState, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint8("GAVState", 2)
	if err != nil {
		return 0, errors.Wrap(err, "error reading GAVState")
	}
	if enum, ok := GAVStateByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for GAVState")
		return GAVState(val), nil
	} else {
		return enum, nil
	}
}

func (e GAVState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e GAVState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint8("GAVState", 2, uint8(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e GAVState) PLC4XEnumName() string {
	switch e {
	case GAVState_DOES_NOT_EXIST:
		return "DOES_NOT_EXIST"
	case GAVState_ON:
		return "ON"
	case GAVState_OFF:
		return "OFF"
	case GAVState_ERROR:
		return "ERROR"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e GAVState) String() string {
	return e.PLC4XEnumName()
}
