/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetShedLevelAmount is the corresponding interface of BACnetShedLevelAmount
type BACnetShedLevelAmount interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetShedLevel
	// GetAmount returns Amount (property field)
	GetAmount() BACnetContextTagReal
}

// BACnetShedLevelAmountExactly can be used when we want exactly this type and not a type which fulfills BACnetShedLevelAmount.
// This is useful for switch cases.
type BACnetShedLevelAmountExactly interface {
	BACnetShedLevelAmount
	isBACnetShedLevelAmount() bool
}

// _BACnetShedLevelAmount is the data-structure of this message
type _BACnetShedLevelAmount struct {
	*_BACnetShedLevel
	Amount BACnetContextTagReal
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetShedLevelAmount) InitializeParent(parent BACnetShedLevel, peekedTagHeader BACnetTagHeader) {
	m.PeekedTagHeader = peekedTagHeader
}

func (m *_BACnetShedLevelAmount) GetParent() BACnetShedLevel {
	return m._BACnetShedLevel
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetShedLevelAmount) GetAmount() BACnetContextTagReal {
	return m.Amount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetShedLevelAmount factory function for _BACnetShedLevelAmount
func NewBACnetShedLevelAmount(amount BACnetContextTagReal, peekedTagHeader BACnetTagHeader) *_BACnetShedLevelAmount {
	_result := &_BACnetShedLevelAmount{
		Amount:           amount,
		_BACnetShedLevel: NewBACnetShedLevel(peekedTagHeader),
	}
	_result._BACnetShedLevel._BACnetShedLevelChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetShedLevelAmount(structType any) BACnetShedLevelAmount {
	if casted, ok := structType.(BACnetShedLevelAmount); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetShedLevelAmount); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetShedLevelAmount) GetTypeName() string {
	return "BACnetShedLevelAmount"
}

func (m *_BACnetShedLevelAmount) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (amount)
	lengthInBits += m.Amount.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetShedLevelAmount) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetShedLevelAmountParse(ctx context.Context, theBytes []byte) (BACnetShedLevelAmount, error) {
	return BACnetShedLevelAmountParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetShedLevelAmountParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetShedLevelAmount, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetShedLevelAmount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetShedLevelAmount")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (amount)
	if pullErr := readBuffer.PullContext("amount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for amount")
	}
	_amount, _amountErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(2)), BACnetDataType(BACnetDataType_REAL))
	if _amountErr != nil {
		return nil, errors.Wrap(_amountErr, "Error parsing 'amount' field of BACnetShedLevelAmount")
	}
	amount := _amount.(BACnetContextTagReal)
	if closeErr := readBuffer.CloseContext("amount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for amount")
	}

	if closeErr := readBuffer.CloseContext("BACnetShedLevelAmount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetShedLevelAmount")
	}

	// Create a partially initialized instance
	_child := &_BACnetShedLevelAmount{
		_BACnetShedLevel: &_BACnetShedLevel{},
		Amount:           amount,
	}
	_child._BACnetShedLevel._BACnetShedLevelChildRequirements = _child
	return _child, nil
}

func (m *_BACnetShedLevelAmount) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetShedLevelAmount) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetShedLevelAmount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetShedLevelAmount")
		}

		// Simple Field (amount)
		if pushErr := writeBuffer.PushContext("amount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for amount")
		}
		_amountErr := writeBuffer.WriteSerializable(ctx, m.GetAmount())
		if popErr := writeBuffer.PopContext("amount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for amount")
		}
		if _amountErr != nil {
			return errors.Wrap(_amountErr, "Error serializing 'amount' field")
		}

		if popErr := writeBuffer.PopContext("BACnetShedLevelAmount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetShedLevelAmount")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetShedLevelAmount) isBACnetShedLevelAmount() bool {
	return true
}

func (m *_BACnetShedLevelAmount) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
