/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesAccessCredentialDisableReason is the corresponding interface of BACnetPropertyStatesAccessCredentialDisableReason
type BACnetPropertyStatesAccessCredentialDisableReason interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetPropertyStates
	// GetAccessCredentialDisableReason returns AccessCredentialDisableReason (property field)
	GetAccessCredentialDisableReason() BACnetAccessCredentialDisableReasonTagged
}

// BACnetPropertyStatesAccessCredentialDisableReasonExactly can be used when we want exactly this type and not a type which fulfills BACnetPropertyStatesAccessCredentialDisableReason.
// This is useful for switch cases.
type BACnetPropertyStatesAccessCredentialDisableReasonExactly interface {
	BACnetPropertyStatesAccessCredentialDisableReason
	isBACnetPropertyStatesAccessCredentialDisableReason() bool
}

// _BACnetPropertyStatesAccessCredentialDisableReason is the data-structure of this message
type _BACnetPropertyStatesAccessCredentialDisableReason struct {
	*_BACnetPropertyStates
	AccessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) InitializeParent(parent BACnetPropertyStates, peekedTagHeader BACnetTagHeader) {
	m.PeekedTagHeader = peekedTagHeader
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetParent() BACnetPropertyStates {
	return m._BACnetPropertyStates
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetAccessCredentialDisableReason() BACnetAccessCredentialDisableReasonTagged {
	return m.AccessCredentialDisableReason
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetPropertyStatesAccessCredentialDisableReason factory function for _BACnetPropertyStatesAccessCredentialDisableReason
func NewBACnetPropertyStatesAccessCredentialDisableReason(accessCredentialDisableReason BACnetAccessCredentialDisableReasonTagged, peekedTagHeader BACnetTagHeader) *_BACnetPropertyStatesAccessCredentialDisableReason {
	_result := &_BACnetPropertyStatesAccessCredentialDisableReason{
		AccessCredentialDisableReason: accessCredentialDisableReason,
		_BACnetPropertyStates:         NewBACnetPropertyStates(peekedTagHeader),
	}
	_result._BACnetPropertyStates._BACnetPropertyStatesChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesAccessCredentialDisableReason(structType any) BACnetPropertyStatesAccessCredentialDisableReason {
	if casted, ok := structType.(BACnetPropertyStatesAccessCredentialDisableReason); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesAccessCredentialDisableReason); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetTypeName() string {
	return "BACnetPropertyStatesAccessCredentialDisableReason"
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (accessCredentialDisableReason)
	lengthInBits += m.AccessCredentialDisableReason.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetPropertyStatesAccessCredentialDisableReasonParse(ctx context.Context, theBytes []byte, peekedTagNumber uint8) (BACnetPropertyStatesAccessCredentialDisableReason, error) {
	return BACnetPropertyStatesAccessCredentialDisableReasonParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), peekedTagNumber)
}

func BACnetPropertyStatesAccessCredentialDisableReasonParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, peekedTagNumber uint8) (BACnetPropertyStatesAccessCredentialDisableReason, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesAccessCredentialDisableReason"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesAccessCredentialDisableReason")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (accessCredentialDisableReason)
	if pullErr := readBuffer.PullContext("accessCredentialDisableReason"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for accessCredentialDisableReason")
	}
	_accessCredentialDisableReason, _accessCredentialDisableReasonErr := BACnetAccessCredentialDisableReasonTaggedParseWithBuffer(ctx, readBuffer, uint8(peekedTagNumber), TagClass(TagClass_CONTEXT_SPECIFIC_TAGS))
	if _accessCredentialDisableReasonErr != nil {
		return nil, errors.Wrap(_accessCredentialDisableReasonErr, "Error parsing 'accessCredentialDisableReason' field of BACnetPropertyStatesAccessCredentialDisableReason")
	}
	accessCredentialDisableReason := _accessCredentialDisableReason.(BACnetAccessCredentialDisableReasonTagged)
	if closeErr := readBuffer.CloseContext("accessCredentialDisableReason"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for accessCredentialDisableReason")
	}

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesAccessCredentialDisableReason"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesAccessCredentialDisableReason")
	}

	// Create a partially initialized instance
	_child := &_BACnetPropertyStatesAccessCredentialDisableReason{
		_BACnetPropertyStates:         &_BACnetPropertyStates{},
		AccessCredentialDisableReason: accessCredentialDisableReason,
	}
	_child._BACnetPropertyStates._BACnetPropertyStatesChildRequirements = _child
	return _child, nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesAccessCredentialDisableReason"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesAccessCredentialDisableReason")
		}

		// Simple Field (accessCredentialDisableReason)
		if pushErr := writeBuffer.PushContext("accessCredentialDisableReason"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for accessCredentialDisableReason")
		}
		_accessCredentialDisableReasonErr := writeBuffer.WriteSerializable(ctx, m.GetAccessCredentialDisableReason())
		if popErr := writeBuffer.PopContext("accessCredentialDisableReason"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for accessCredentialDisableReason")
		}
		if _accessCredentialDisableReasonErr != nil {
			return errors.Wrap(_accessCredentialDisableReasonErr, "Error serializing 'accessCredentialDisableReason' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesAccessCredentialDisableReason"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesAccessCredentialDisableReason")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) isBACnetPropertyStatesAccessCredentialDisableReason() bool {
	return true
}

func (m *_BACnetPropertyStatesAccessCredentialDisableReason) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
