/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLoopAction is the corresponding interface of BACnetConstructedDataLoopAction
type BACnetConstructedDataLoopAction interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetAction returns Action (property field)
	GetAction() BACnetActionTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetActionTagged
}

// BACnetConstructedDataLoopActionExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataLoopAction.
// This is useful for switch cases.
type BACnetConstructedDataLoopActionExactly interface {
	BACnetConstructedDataLoopAction
	isBACnetConstructedDataLoopAction() bool
}

// _BACnetConstructedDataLoopAction is the data-structure of this message
type _BACnetConstructedDataLoopAction struct {
	*_BACnetConstructedData
	Action BACnetActionTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLoopAction) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_LOOP
}

func (m *_BACnetConstructedDataLoopAction) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLoopAction) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataLoopAction) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLoopAction) GetAction() BACnetActionTagged {
	return m.Action
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLoopAction) GetActualValue() BACnetActionTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetActionTagged(m.GetAction())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataLoopAction factory function for _BACnetConstructedDataLoopAction
func NewBACnetConstructedDataLoopAction(action BACnetActionTagged, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLoopAction {
	_result := &_BACnetConstructedDataLoopAction{
		Action:                 action,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLoopAction(structType any) BACnetConstructedDataLoopAction {
	if casted, ok := structType.(BACnetConstructedDataLoopAction); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLoopAction); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLoopAction) GetTypeName() string {
	return "BACnetConstructedDataLoopAction"
}

func (m *_BACnetConstructedDataLoopAction) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (action)
	lengthInBits += m.Action.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLoopAction) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataLoopActionParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLoopAction, error) {
	return BACnetConstructedDataLoopActionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataLoopActionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLoopAction, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLoopAction"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLoopAction")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (action)
	if pullErr := readBuffer.PullContext("action"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for action")
	}
	_action, _actionErr := BACnetActionTaggedParseWithBuffer(ctx, readBuffer, uint8(uint8(0)), TagClass(TagClass_APPLICATION_TAGS))
	if _actionErr != nil {
		return nil, errors.Wrap(_actionErr, "Error parsing 'action' field of BACnetConstructedDataLoopAction")
	}
	action := _action.(BACnetActionTagged)
	if closeErr := readBuffer.CloseContext("action"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for action")
	}

	// Virtual field
	_actualValue := action
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLoopAction"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLoopAction")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataLoopAction{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		Action: action,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataLoopAction) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLoopAction) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLoopAction"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLoopAction")
		}

		// Simple Field (action)
		if pushErr := writeBuffer.PushContext("action"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for action")
		}
		_actionErr := writeBuffer.WriteSerializable(ctx, m.GetAction())
		if popErr := writeBuffer.PopContext("action"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for action")
		}
		if _actionErr != nil {
			return errors.Wrap(_actionErr, "Error serializing 'action' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLoopAction"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLoopAction")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLoopAction) isBACnetConstructedDataLoopAction() bool {
	return true
}

func (m *_BACnetConstructedDataLoopAction) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
