/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataFullDutyBaseline is the corresponding interface of BACnetConstructedDataFullDutyBaseline
type BACnetConstructedDataFullDutyBaseline interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetFullDutyBaseLine returns FullDutyBaseLine (property field)
	GetFullDutyBaseLine() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
}

// BACnetConstructedDataFullDutyBaselineExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataFullDutyBaseline.
// This is useful for switch cases.
type BACnetConstructedDataFullDutyBaselineExactly interface {
	BACnetConstructedDataFullDutyBaseline
	isBACnetConstructedDataFullDutyBaseline() bool
}

// _BACnetConstructedDataFullDutyBaseline is the data-structure of this message
type _BACnetConstructedDataFullDutyBaseline struct {
	*_BACnetConstructedData
	FullDutyBaseLine BACnetApplicationTagReal
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataFullDutyBaseline) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataFullDutyBaseline) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FULL_DUTY_BASELINE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataFullDutyBaseline) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataFullDutyBaseline) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataFullDutyBaseline) GetFullDutyBaseLine() BACnetApplicationTagReal {
	return m.FullDutyBaseLine
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataFullDutyBaseline) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetFullDutyBaseLine())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataFullDutyBaseline factory function for _BACnetConstructedDataFullDutyBaseline
func NewBACnetConstructedDataFullDutyBaseline(fullDutyBaseLine BACnetApplicationTagReal, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataFullDutyBaseline {
	_result := &_BACnetConstructedDataFullDutyBaseline{
		FullDutyBaseLine:       fullDutyBaseLine,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataFullDutyBaseline(structType any) BACnetConstructedDataFullDutyBaseline {
	if casted, ok := structType.(BACnetConstructedDataFullDutyBaseline); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataFullDutyBaseline); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataFullDutyBaseline) GetTypeName() string {
	return "BACnetConstructedDataFullDutyBaseline"
}

func (m *_BACnetConstructedDataFullDutyBaseline) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (fullDutyBaseLine)
	lengthInBits += m.FullDutyBaseLine.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataFullDutyBaseline) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataFullDutyBaselineParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataFullDutyBaseline, error) {
	return BACnetConstructedDataFullDutyBaselineParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataFullDutyBaselineParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataFullDutyBaseline, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataFullDutyBaseline"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataFullDutyBaseline")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (fullDutyBaseLine)
	if pullErr := readBuffer.PullContext("fullDutyBaseLine"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for fullDutyBaseLine")
	}
	_fullDutyBaseLine, _fullDutyBaseLineErr := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
	if _fullDutyBaseLineErr != nil {
		return nil, errors.Wrap(_fullDutyBaseLineErr, "Error parsing 'fullDutyBaseLine' field of BACnetConstructedDataFullDutyBaseline")
	}
	fullDutyBaseLine := _fullDutyBaseLine.(BACnetApplicationTagReal)
	if closeErr := readBuffer.CloseContext("fullDutyBaseLine"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for fullDutyBaseLine")
	}

	// Virtual field
	_actualValue := fullDutyBaseLine
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataFullDutyBaseline"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataFullDutyBaseline")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataFullDutyBaseline{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		FullDutyBaseLine: fullDutyBaseLine,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataFullDutyBaseline) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataFullDutyBaseline) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataFullDutyBaseline"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataFullDutyBaseline")
		}

		// Simple Field (fullDutyBaseLine)
		if pushErr := writeBuffer.PushContext("fullDutyBaseLine"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for fullDutyBaseLine")
		}
		_fullDutyBaseLineErr := writeBuffer.WriteSerializable(ctx, m.GetFullDutyBaseLine())
		if popErr := writeBuffer.PopContext("fullDutyBaseLine"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for fullDutyBaseLine")
		}
		if _fullDutyBaseLineErr != nil {
			return errors.Wrap(_fullDutyBaseLineErr, "Error serializing 'fullDutyBaseLine' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataFullDutyBaseline"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataFullDutyBaseline")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataFullDutyBaseline) isBACnetConstructedDataFullDutyBaseline() bool {
	return true
}

func (m *_BACnetConstructedDataFullDutyBaseline) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
